/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2;

import ee.ut.soras.ajavtV2.NumberTokenizer;
import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.util.ArvSonaFraasideTuvastaja;
import ee.ut.soras.ajavtV2.util.LogiPidaja;
import ee.ut.soras.ajavtV2.util.TextUtils;
import ee.ut.soras.wrappers.EstyhmmWrapper;
import ee.ut.soras.wrappers.impl.T3MestaReader;
import ee.ut.soras.wrappers.impl.T3OLPReader;
import ee.ut.soras.wrappers.impl.VabaMorfJSONReader;
import ee.ut.soras.wrappers.mudel.MorfAnRida;
import ee.ut.soras.wrappers.mudel.MorfAnSona;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EelTootlus {
    public static LogiPidaja logi = null;
    private static Pattern musterLauseLoppLauseAlgus = Pattern.compile("[?!.](\\s+)\\p{Lu}");
    private static Pattern musterKomaSonadeVahel = Pattern.compile("(\\p{Alpha}|[0-9])([,]\\s+)(\\p{Alpha}|[0-9])");
    private static Pattern musterArvudeKriipslopp = Pattern.compile("^(\\d|[.,!?])+-$");
    private static Pattern musterSTlopp = Pattern.compile("^.+(-)?st$");
    private static Pattern musterPoleSTlopp = Pattern.compile("^(august|p\u00e4rast)$", 64);
    private static Pattern musterNIlopp = Pattern.compile("^.+(-)?ni$");
    private static Pattern musterPoleNIlopp = Pattern.compile("^(juuni|kuni)$");
    private static final Pattern verbOlevik = Pattern.compile("^(b|d|vad|te|me|n|neg o|t(a|akse)||k(s|sid|sime|sin|site)|neg ks|o|ge|gem|gu|neg g(e|em|u)|tagu|taks|neg vat|vat|tavat|tav|v),");
    private static final Pattern verbLihtminevik = Pattern.compile("^(s|sid|sime|sin|site|ti|neg (nud|tud)),");
    private static final Pattern verbTingivKaudneMinevik = Pattern.compile("^(k(s|sid|sime|sin|site)|neg ks|vat|tavat|neg vat),");
    private static final Pattern verbYldMinevik = Pattern.compile("^(nu(ks|ksid|ksime|ksin|ksite|vat)|tu(ks|vat)|neg nuks),");
    private static final Pattern verbKeskSonaMinevikuVorm = Pattern.compile("^(nud|tud),");
    private static final Pattern ksTyveMinevikuLopp = Pattern.compile("^(.+)(dud|tud|nud)$");
    private static final Pattern ksTyveOlevikuLopp = Pattern.compile("^(.+)(v)$");

    public static String prepareTextForMorphAnalysis(String tekst) {
        int startIndex;
        StringBuffer sb = new StringBuffer(tekst);
        Matcher matcher = musterLauseLoppLauseAlgus.matcher(sb);
        while (matcher.find()) {
            if (matcher.groupCount() <= 0 || (startIndex = matcher.start(1)) == -1) continue;
            sb.replace(startIndex, startIndex + 1, System.getProperty("line.separator"));
        }
        matcher = musterKomaSonadeVahel.matcher(sb);
        while (matcher.find()) {
            if (matcher.groupCount() <= 0 || (startIndex = matcher.start(2)) == -1) continue;
            sb.replace(startIndex, startIndex + 1, " , ");
        }
        return sb.toString();
    }

    public static List<AjavtSona> eeltootlusValiseMorfAnalyysiga(EstyhmmWrapper wrapper, String tekst) throws Exception {
        tekst = EelTootlus.prepareTextForMorphAnalysis(tekst);
        String morfAnOutput = wrapper.process(tekst);
        return EelTootlus.eeltootlus(morfAnOutput);
    }

    public static List<AjavtSona> eeltootlus(String morfAnalyzedText) throws Exception {
        BufferedReader inputReader = new BufferedReader(new StringReader(morfAnalyzedText));
        List<MorfAnSona> morfAnalyysitud = T3MestaReader.parseT3mestatext(inputReader);
        inputReader.close();
        ArrayList<AjavtSona> eelt88deldud = new ArrayList<AjavtSona>(morfAnalyysitud.size());
        ArvSonaFraasideTuvastaja arvuTuvastaja = new ArvSonaFraasideTuvastaja(eelt88deldud);
        ArrayList<Object> eelnevaVerbiInfo = new ArrayList<Object>(2);
        AjavtSona eelmineSona = null;
        for (int i = 0; i < morfAnalyysitud.size(); ++i) {
            MorfAnSona sona = morfAnalyysitud.get(i);
            EelTootlus.lisaUusAjavtSona(eelt88deldud, sona, arvuTuvastaja);
            eelmineSona = (AjavtSona)eelt88deldud.get(eelt88deldud.size() - 1);
            if (eelmineSona.onVerb()) {
                EelTootlus.maaraGrammatilineAeg(eelmineSona, false, eelnevaVerbiInfo);
            } else if (eelmineSona.onAdjektiivPos()) {
                EelTootlus.maaraGrammatilineAeg(eelmineSona, true, eelnevaVerbiInfo);
            }
            if (eelmineSona == null || !eelmineSona.onOlpKindelPiir() && !eelmineSona.onLauseLopp()) continue;
            eelnevaVerbiInfo.clear();
        }
        return eelt88deldud;
    }

    public static List<AjavtSona> eeltootlusT3OLP(String sisendT3OLP) throws Exception {
        BufferedReader inputReader = new BufferedReader(new StringReader(sisendT3OLP));
        List<MorfAnSona> morfAnalyysitud = T3OLPReader.parseT3OLPtext(inputReader);
        inputReader.close();
        ArrayList<AjavtSona> eelt88deldud = new ArrayList<AjavtSona>(morfAnalyysitud.size());
        ArvSonaFraasideTuvastaja arvuTuvastaja = new ArvSonaFraasideTuvastaja(eelt88deldud);
        ArrayList<Object> eelnevaVerbiInfo = new ArrayList<Object>(2);
        AjavtSona eelmineSona = null;
        for (int i = 0; i < morfAnalyysitud.size(); ++i) {
            MorfAnSona sona = morfAnalyysitud.get(i);
            EelTootlus.lisaUusAjavtSona(eelt88deldud, sona, arvuTuvastaja);
            eelmineSona = (AjavtSona)eelt88deldud.get(eelt88deldud.size() - 1);
            if (eelmineSona.onVerb()) {
                EelTootlus.maaraGrammatilineAeg(eelmineSona, false, eelnevaVerbiInfo);
            } else if (eelmineSona.onAdjektiivPos()) {
                EelTootlus.maaraGrammatilineAeg(eelmineSona, true, eelnevaVerbiInfo);
            }
            if (eelmineSona == null || !eelmineSona.onOlpKindelPiir() && !eelmineSona.onLauseLopp()) continue;
            eelnevaVerbiInfo.clear();
        }
        return eelt88deldud;
    }

    public static List<AjavtSona> eeltootlusJSON(String sisendJSON) throws Exception {
        BufferedReader inputReader = new BufferedReader(new StringReader(sisendJSON));
        List<MorfAnSona> morfAnalyysitud = VabaMorfJSONReader.parseJSONtext(inputReader);
        inputReader.close();
        ArrayList<AjavtSona> eelt88deldud = new ArrayList<AjavtSona>(morfAnalyysitud.size());
        ArvSonaFraasideTuvastaja arvuTuvastaja = new ArvSonaFraasideTuvastaja(eelt88deldud);
        ArrayList<Object> eelnevaVerbiInfo = new ArrayList<Object>(2);
        AjavtSona eelmineSona = null;
        for (int i = 0; i < morfAnalyysitud.size(); ++i) {
            MorfAnSona sona = morfAnalyysitud.get(i);
            EelTootlus.lisaUusAjavtSona(eelt88deldud, sona, arvuTuvastaja);
            eelmineSona = (AjavtSona)eelt88deldud.get(eelt88deldud.size() - 1);
            if (eelmineSona.onVerb()) {
                EelTootlus.maaraGrammatilineAeg(eelmineSona, false, eelnevaVerbiInfo);
            } else if (eelmineSona.onAdjektiivPos()) {
                EelTootlus.maaraGrammatilineAeg(eelmineSona, true, eelnevaVerbiInfo);
            }
            if (eelmineSona == null || !eelmineSona.onOlpKindelPiir() && !eelmineSona.onLauseLopp()) continue;
            eelnevaVerbiInfo.clear();
        }
        return eelt88deldud;
    }

    private static int findNextInnerTokenPosition(List<AjavtSona> tulemusList, MorfAnSona morfAnSona) {
        if (!tulemusList.isEmpty()) {
            int lastTokenPosition = tulemusList.get(tulemusList.size() - 1).getTokenPosition();
            int lastInnerPosition = tulemusList.get(tulemusList.size() - 1).getInnerTokenPosition();
            int tokenPositionsDifference = lastInnerPosition - lastTokenPosition;
            int currentTokenPosition = morfAnSona.getTokenPosition();
            return currentTokenPosition + tokenPositionsDifference;
        }
        return morfAnSona.getTokenPosition();
    }

    private static void lisaUusAjavtSona(List<AjavtSona> tulemusList, MorfAnSona morfAnSona, ArvSonaFraasideTuvastaja arvuTuvastaja) {
        int innerTokenPosition;
        String analyysitavSona = morfAnSona.getAlgSona();
        if (morfAnSona.getAlgSona().length() > 50) {
            analyysitavSona = morfAnSona.getAlgSona().substring(0, 50);
        }
        boolean numbersSuccessfullyExtracted = false;
        if (NumberTokenizer.isNumberTokenizationNeeded(analyysitavSona)) {
            List<String> subStrings = NumberTokenizer.extractNumbersWithTrailingPunctation(analyysitavSona, true);
            innerTokenPosition = EelTootlus.findNextInnerTokenPosition(tulemusList, morfAnSona);
            for (int i = 0; i < subStrings.size(); ++i) {
                String string = subStrings.get(i);
                AjavtSona ajavtSona = new AjavtSona(morfAnSona, string);
                EelTootlus.leiaKasOnTeguPotentsiaalseAjavahemikuOsaga(ajavtSona, string);
                ajavtSona.setInnerTokenPosition(innerTokenPosition);
                if (subStrings.size() > 1) {
                    ajavtSona.setAtTokenBreakPosition(true);
                }
                tulemusList.add(ajavtSona);
                ++innerTokenPosition;
                if (i < subStrings.size() - 1) {
                    ajavtSona.setOnLauseLopp(false);
                    ajavtSona.setOlpOnKindelPiir(false);
                    continue;
                }
                ajavtSona.setOnLauseLopp(morfAnSona.onLauseLopp());
                ajavtSona.setOlpOnKindelPiir(morfAnSona.onOlpKindelPiir());
            }
            numbersSuccessfullyExtracted = true;
        }
        if (!numbersSuccessfullyExtracted) {
            AjavtSona ajavtSona = new AjavtSona(morfAnSona, null);
            ajavtSona.setOnLauseLopp(morfAnSona.onLauseLopp());
            ajavtSona.setOlpOnKindelPiir(morfAnSona.onOlpKindelPiir());
            EelTootlus.leiaKasOnTeguPotentsiaalseAjavahemikuOsaga(ajavtSona, analyysitavSona);
            innerTokenPosition = EelTootlus.findNextInnerTokenPosition(tulemusList, morfAnSona);
            tulemusList.add(ajavtSona);
            ajavtSona.setInnerTokenPosition(innerTokenPosition);
            arvuTuvastaja.tuvastaArvSonaFraas(ajavtSona);
        }
    }

    private static void leiaKasOnTeguPotentsiaalseAjavahemikuOsaga(AjavtSona ajavtsona, String sona) {
        List<MorfAnRida> analyysiTulemused;
        String sonaLowerCase = sona.toLowerCase();
        String sonaLowerCaseWithOutPunctation = TextUtils.trimSurroundingPunctation(sonaLowerCase);
        if (musterSTlopp.matcher(sonaLowerCaseWithOutPunctation).matches() && ajavtsona.getAnalyysiTulemused() != null) {
            analyysiTulemused = ajavtsona.getAnalyysiTulemused();
            for (MorfAnRida morfAnRida : analyysiTulemused) {
                if (!morfAnRida.leiaKasMorfTunnusEsineb("el") || musterPoleSTlopp.matcher(sonaLowerCaseWithOutPunctation).matches()) continue;
                ajavtsona.setOnPotentsiaalneVahemikuAlgus(true);
            }
        }
        if (musterArvudeKriipslopp.matcher(sonaLowerCase).matches()) {
            ajavtsona.setOnPotentsiaalneVahemikuAlgus(true);
        }
        if (musterNIlopp.matcher(sonaLowerCaseWithOutPunctation).matches() && ajavtsona.getAnalyysiTulemused() != null) {
            analyysiTulemused = ajavtsona.getAnalyysiTulemused();
            for (MorfAnRida morfAnRida : analyysiTulemused) {
                if (!morfAnRida.leiaKasMorfTunnusEsineb("ter") || musterPoleNIlopp.matcher(sonaLowerCaseWithOutPunctation).matches()) continue;
                ajavtsona.setOnPotentsiaalneVahemikuLopp(true);
            }
        }
    }

    private static void maaraGrammatilineAeg(AjavtSona sona, boolean onOmadusSona, List<Object> eelnevaVerbiInfo) {
        if (!onOmadusSona) {
            String eelnevaVerbiMod = null;
            AjavtSona eelnevVerb = null;
            if (eelnevaVerbiInfo != null && eelnevaVerbiInfo.size() == 2) {
                eelnevaVerbiMod = (String)eelnevaVerbiInfo.get(0);
                eelnevVerb = (AjavtSona)eelnevaVerbiInfo.get(1);
            }
            List<MorfAnRida> analyysiTulemused = sona.getAnalyysiTulemused();
            for (MorfAnRida morfAnRida : analyysiTulemused) {
                if (morfAnRida.getVormiNimetused() == null) continue;
                if (verbOlevik.matcher(morfAnRida.getVormiNimetused()).matches()) {
                    sona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.OLEVIK);
                    if (morfAnRida.getLemmaIlmaVahemarkideta().equals("ole")) {
                        eelnevaVerbiMod = verbTingivKaudneMinevik.matcher(morfAnRida.getVormiNimetused()).matches() ? morfAnRida.getLemmaIlmaVahemarkideta() + "_ot" : morfAnRida.getLemmaIlmaVahemarkideta() + "_o";
                    }
                }
                if (verbLihtminevik.matcher(morfAnRida.getVormiNimetused()).matches()) {
                    sona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.LIHTMINEVIK);
                    if (morfAnRida.getLemmaIlmaVahemarkideta().equals("ole")) {
                        eelnevaVerbiMod = morfAnRida.getLemmaIlmaVahemarkideta() + "_m";
                    }
                }
                if (verbYldMinevik.matcher(morfAnRida.getVormiNimetused()).matches()) {
                    sona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.YLDMINEVIK);
                }
                if (!verbKeskSonaMinevikuVorm.matcher(morfAnRida.getVormiNimetused()).matches()) continue;
                boolean verbiAegMaaratud = false;
                if (eelnevVerb != null && eelnevaVerbiMod != null) {
                    if (eelnevaVerbiMod.equals("pole") || eelnevaVerbiMod.equals("ei")) {
                        eelnevVerb.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.LIHTMINEVIK);
                        sona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.LIHTMINEVIK);
                    }
                    if (eelnevaVerbiMod.equals("ole_o")) {
                        eelnevVerb.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.TAISMINEVIK);
                        sona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.TAISMINEVIK);
                        verbiAegMaaratud = true;
                    } else if (eelnevaVerbiMod.equals("ole_ot")) {
                        eelnevVerb.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.YLDMINEVIK);
                        sona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.YLDMINEVIK);
                        verbiAegMaaratud = true;
                    } else if (eelnevaVerbiMod.equals("ole_m")) {
                        eelnevVerb.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.ENNEMINEVIK);
                        sona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.ENNEMINEVIK);
                        verbiAegMaaratud = true;
                    }
                }
                if (verbiAegMaaratud) continue;
                sona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.KS_MINEVIK);
            }
            String algSona = sona.getAlgSona();
            if (algSona.equals("pole") || algSona.equals("ei")) {
                eelnevaVerbiMod = algSona;
            }
            eelnevaVerbiInfo.clear();
            eelnevaVerbiInfo.add(eelnevaVerbiMod);
            eelnevaVerbiInfo.add(sona);
        } else {
            List<MorfAnRida> analyysiTulemused = sona.getAnalyysiTulemused();
            for (MorfAnRida morfAnRida : analyysiTulemused) {
                if (morfAnRida.getSonaliik() == null || !morfAnRida.getSonaliik().equals("_A_") || morfAnRida.getLemmaIlmaVahemarkideta() == null) continue;
                String lemmaIlmaVahemarkideta = morfAnRida.getLemmaIlmaVahemarkideta();
                if (ksTyveMinevikuLopp.matcher(lemmaIlmaVahemarkideta).matches()) {
                    sona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.KS_MINEVIK);
                    break;
                }
                if (!ksTyveOlevikuLopp.matcher(lemmaIlmaVahemarkideta).matches()) continue;
                sona.setGrammatilineAeg(AjavtSona.GRAMMATILINE_AEG.KS_OLEVIK);
                break;
            }
        }
    }
}

