/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel;

import ee.ut.soras.ajavtV2.NumberTokenizer;
import ee.ut.soras.ajavtV2.mudel.FraasisPaiknemiseKoht;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.AjavaljendiKandidaat;
import ee.ut.soras.ajavtV2.util.TextUtils;
import ee.ut.soras.wrappers.mudel.MorfAnSona;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AjavtSona
extends MorfAnSona {
    private int startPosition = -1;
    private int endPosition = -1;
    private int innerTokenPosition = -1;
    private boolean atTokenBreakPosition = false;
    private String algSonaErisymbolidNormaliseeritud = null;
    private String algSonaYmbritsevateMarkideta = null;
    private FraasisPaiknemiseKoht arvSonaFraasis = FraasisPaiknemiseKoht.PUUDUB;
    private Integer arvSonaTaisArvVaartus = null;
    private Double arvSonaMurdArvVaartus = null;
    private List<FraasisPaiknemiseKoht> ajavaljendiKandidaatides = null;
    private List<AjavaljendiKandidaat> ajavaljendiKandidaadid = null;
    private boolean onPotentsiaalneVahemikuAlgus = false;
    private boolean onPotentsiaalneVahemikuLopp = false;
    private GRAMMATILINE_AEG grammatilineAeg = GRAMMATILINE_AEG.MAARAMATA;

    public AjavtSona(String algSona) {
        super(algSona);
        if (algSona.length() <= 50) {
            this.algSonaErisymbolidNormaliseeritud = TextUtils.normalizeSpecialSymbols(algSona);
            this.algSonaYmbritsevateMarkideta = TextUtils.trimSurroundingPunctation(this.algSonaErisymbolidNormaliseeritud);
            if (algSona.equals(this.algSonaYmbritsevateMarkideta) || this.algSonaYmbritsevateMarkideta.length() == 0) {
                this.algSonaYmbritsevateMarkideta = this.algSonaErisymbolidNormaliseeritud;
            }
        }
    }

    public AjavtSona(MorfAnSona morfSona, String uusAlgSona) {
        super(uusAlgSona != null ? uusAlgSona : morfSona.getAlgSona());
        for (int i = 0; i < morfSona.getAnalyysiTulemused().size(); ++i) {
            super.lisaAnalyysiRida(morfSona.getAnalyysiTulemused().get(i));
        }
        super.setTokenPosition(morfSona.getTokenPosition());
        String algSona = this.getAlgSona();
        if (algSona.length() <= 50) {
            this.algSonaErisymbolidNormaliseeritud = TextUtils.normalizeSpecialSymbols(algSona);
            this.algSonaYmbritsevateMarkideta = TextUtils.trimSurroundingPunctation(this.algSonaErisymbolidNormaliseeritud);
            if (algSona.equals(this.algSonaYmbritsevateMarkideta) || this.algSonaYmbritsevateMarkideta.length() == 0) {
                this.algSonaYmbritsevateMarkideta = this.algSonaErisymbolidNormaliseeritud;
            }
        }
    }

    public void eemaldaYlekattuvadAjavaljendiKandidaadid() {
        ArrayList<AjavaljendiKandidaat> eemaldatavad = new ArrayList<AjavaljendiKandidaat>();
        for (int i = 0; i < this.ajavaljendiKandidaadid.size(); ++i) {
            AjavaljendiKandidaat ajavaljend = this.ajavaljendiKandidaadid.get(i);
            if (!ajavaljend.onYlekaetudTeisteAjavaljendifraasidePoolt()) continue;
            eemaldatavad.add(ajavaljend);
        }
        for (AjavaljendiKandidaat ajavaljend : eemaldatavad) {
            ajavaljend.eemaldaEnnastSonadeKyljest();
        }
    }

    public void eemaldaAjavaljendiKandidaat(AjavaljendiKandidaat ajav) {
        Iterator<AjavaljendiKandidaat> ajavIterator = this.ajavaljendiKandidaadid.iterator();
        Iterator<FraasisPaiknemiseKoht> kohtIterator = this.ajavaljendiKandidaatides.iterator();
        while (ajavIterator.hasNext() && kohtIterator.hasNext()) {
            AjavaljendiKandidaat av = ajavIterator.next();
            kohtIterator.next();
            if (!av.equals(ajav)) continue;
            ajavIterator.remove();
            kohtIterator.remove();
            break;
        }
    }

    public List<Integer> parsiPotentsVahemikugaSeotudArvud() {
        ArrayList<Integer> numbrid = new ArrayList<Integer>();
        boolean eiKuuluMustriEgaFraasiAlla = true;
        if (this.onSeotudMoneAjavaljendiKandidaadiga()) {
            for (AjavaljendiKandidaat ajavKandidaat : this.ajavaljendiKandidaadid) {
                if (ajavKandidaat.getAste() != AjavaljendiKandidaat.ASTE.YHENDATUD_FRAASINA && ajavKandidaat.getAste() != AjavaljendiKandidaat.ASTE.MUSTRI_POOLT_ERALDATUD) continue;
                eiKuuluMustriEgaFraasiAlla = false;
                break;
            }
        }
        if (eiKuuluMustriEgaFraasiAlla) {
            if (this.getArvSonaFraasis().onFraasiAlgus() && this.getArvSonaTaisArvVaartus() != null) {
                numbrid.add(this.getArvSonaTaisArvVaartus());
            } else if (this.getArvSonaFraasis() == FraasisPaiknemiseKoht.PUUDUB) {
                List<String> possibleNumbers = NumberTokenizer.extractNumbersWithTrailingPunctation(this.getAlgSona(), false);
                for (int j = 0; j < possibleNumbers.size(); ++j) {
                    if (possibleNumbers.get(j).length() <= 0) continue;
                    try {
                        Integer integer = Integer.valueOf(possibleNumbers.get(j));
                        if (integer == null) continue;
                        numbrid.add(integer);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
        }
        return numbrid.isEmpty() ? null : numbrid;
    }

    public boolean arvudeEsitusKujuOnYhilduv(AjavtSona sona) {
        return this.arvSonaFraasis == sona.arvSonaFraasis || this.arvSonaFraasis != FraasisPaiknemiseKoht.PUUDUB && sona.arvSonaFraasis != FraasisPaiknemiseKoht.PUUDUB;
    }

    public void margendaAjavaljendiKandidaadiga(AjavaljendiKandidaat ajav, FraasisPaiknemiseKoht koht) {
        if (this.ajavaljendiKandidaadid == null) {
            this.ajavaljendiKandidaatides = new ArrayList<FraasisPaiknemiseKoht>();
            this.ajavaljendiKandidaadid = new ArrayList<AjavaljendiKandidaat>();
        }
        this.ajavaljendiKandidaadid.add(ajav);
        this.ajavaljendiKandidaatides.add(koht);
    }

    public boolean onSeotudMoneAjavaljendiKandidaadiga() {
        return this.ajavaljendiKandidaadid != null && this.ajavaljendiKandidaadid.size() > 0;
    }

    public boolean onVoimalikTsiteeringuLoppVoiAlgus() {
        String kontrollitavAlgSona = this.getAlgSonaErisymbolidNormaliseeritud();
        if (kontrollitavAlgSona != null) {
            boolean beginQuote = TextUtils.beginningOfQuote.matcher(kontrollitavAlgSona).matches();
            boolean endQuote = TextUtils.endOfQuote.matcher(kontrollitavAlgSona).matches();
            return beginQuote && !endQuote || !beginQuote && endQuote || beginQuote && endQuote && kontrollitavAlgSona.length() == 1;
        }
        return false;
    }

    public List<FraasisPaiknemiseKoht> getAjavaljendiKandidaatides() {
        return this.ajavaljendiKandidaatides;
    }

    public List<AjavaljendiKandidaat> getAjavaljendiKandidaadid() {
        return this.ajavaljendiKandidaadid;
    }

    public FraasisPaiknemiseKoht getArvSonaFraasis() {
        return this.arvSonaFraasis;
    }

    public void setArvSonaFraasis(FraasisPaiknemiseKoht arvSonaFraasis) {
        this.arvSonaFraasis = arvSonaFraasis;
    }

    public Integer getArvSonaTaisArvVaartus() {
        return this.arvSonaTaisArvVaartus;
    }

    public void setArvSonaTaisArvVaartus(Integer arvSonaVaartus) {
        this.arvSonaTaisArvVaartus = arvSonaVaartus;
    }

    public Double getArvSonaMurdArvVaartus() {
        return this.arvSonaMurdArvVaartus;
    }

    public void setArvSonaMurdArvVaartus(Double arvSonaMurdArvVaartus) {
        this.arvSonaMurdArvVaartus = arvSonaMurdArvVaartus;
    }

    public boolean isOnPotentsiaalneVahemikuAlgus() {
        return this.onPotentsiaalneVahemikuAlgus;
    }

    public void setOnPotentsiaalneVahemikuAlgus(boolean onPotentsiaalneVahemikuAlgus) {
        this.onPotentsiaalneVahemikuAlgus = onPotentsiaalneVahemikuAlgus;
    }

    public boolean isOnPotentsiaalneVahemikuLopp() {
        return this.onPotentsiaalneVahemikuLopp;
    }

    public void setOnPotentsiaalneVahemikuLopp(boolean onPotentsiaalneVahemikuLopp) {
        this.onPotentsiaalneVahemikuLopp = onPotentsiaalneVahemikuLopp;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(int endPosition) {
        this.endPosition = endPosition;
    }

    public int getInnerTokenPosition() {
        return this.innerTokenPosition;
    }

    public void setInnerTokenPosition(int innerTokenPosition) {
        this.innerTokenPosition = innerTokenPosition;
    }

    public boolean isAtTokenBreakPosition() {
        return this.atTokenBreakPosition;
    }

    public void setAtTokenBreakPosition(boolean atTokenBreakPosition) {
        this.atTokenBreakPosition = atTokenBreakPosition;
    }

    public String getAlgSonaYmbritsevateMarkideta() {
        if (this.algSonaYmbritsevateMarkideta != null) {
            return this.algSonaYmbritsevateMarkideta;
        }
        return this.getAlgSona();
    }

    public String getAlgSonaErisymbolidNormaliseeritud() {
        if (this.algSonaErisymbolidNormaliseeritud != null) {
            return this.algSonaErisymbolidNormaliseeritud;
        }
        return this.getAlgSona();
    }

    public GRAMMATILINE_AEG getGrammatilineAeg() {
        return this.grammatilineAeg;
    }

    public void setGrammatilineAeg(GRAMMATILINE_AEG verbiAeg) {
        this.grammatilineAeg = verbiAeg;
    }

    public static enum GRAMMATILINE_AEG {
        MAARAMATA,
        OLEVIK,
        TAISMINEVIK,
        LIHTMINEVIK,
        ENNEMINEVIK,
        YLDMINEVIK,
        KS_MINEVIK,
        KS_OLEVIK;

    }
}

