/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel.sonamallid;

import ee.ut.soras.ajavtV2.AjaTuvastaja;
import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.MustriTahis;
import ee.ut.soras.ajavtV2.mudel.TuvastamisReegel;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.AjavaljendiKandidaat;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.Granulaarsus;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.SemantikaDefinitsioon;
import ee.ut.soras.ajavtV2.mudel.sonamallid.FraasiMuster;
import ee.ut.soras.ajavtV2.mudel.sonamallid.MallileVastavus;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaKlass;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMall;
import ee.ut.soras.ajavtV2.util.SemDefValjadeParsija;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

public class FraasiMusterLihtne
implements FraasiMuster {
    private String mustriID;
    private List<SonaMall> sonaMallid;
    private List<Boolean> onValikuline;
    private List<Boolean> onArajaetav;
    private TuvastamisReegel tuvastamisReegel = null;
    HashMap<String, List<AjavtSona>> malliRahuldavadAlamFraasid;
    HashMap<String, MallileVastavus> sonaMallideOlekud;
    int jargMustris = 0;
    int vaheleJaetud = 0;

    public FraasiMusterLihtne(List<SonaMall> sonaMallid, List<Boolean> valikulisus, List<Boolean> araJaetavus, String mustriID) {
        this.mustriID = mustriID;
        this.sonaMallid = sonaMallid;
        this.onValikuline = valikulisus;
        this.onArajaetav = araJaetavus;
        this.malliRahuldavadAlamFraasid = new HashMap(this.sonaMallid.size());
        this.sonaMallideOlekud = new HashMap(this.sonaMallid.size());
    }

    @Override
    public void kontrolliMustrileVastavust(AjavtSona sona, HashMap<String, MallileVastavus> kontrollitudSonaKlassid) throws Exception {
        this.kontrolliMustrileVastavust(sona, kontrollitudSonaKlassid, Integer.MAX_VALUE);
    }

    private void kontrolliMustrileVastavust(AjavtSona sona, HashMap<String, MallileVastavus> kontrollitudSonaKlassid, int kontrolliKatkestusIndeks) throws Exception {
        boolean ajavaljendOnLeitud = false;
        if (kontrolliKatkestusIndeks == this.jargMustris) {
            this.jargMustris = 0;
            this.vaheleJaetud = 0;
            return;
        }
        boolean valikulineSona = this.onValikuline.get(this.jargMustris);
        MallileVastavus vastavus = this.kontrolliSonaMallileVastavust(sona, this.jargMustris, kontrollitudSonaKlassid);
        if (vastavus == MallileVastavus.EI_VASTA) {
            if (valikulineSona) {
                ++this.vaheleJaetud;
                if (this.jargMustris < this.sonaMallid.size() - 1) {
                    ++this.jargMustris;
                    this.kontrolliMustrileVastavust(sona, kontrollitudSonaKlassid, kontrolliKatkestusIndeks);
                } else {
                    ajavaljendOnLeitud = true;
                }
            } else {
                this.malliRahuldavadAlamFraasid.clear();
                this.sonaMallideOlekud.clear();
                if (this.jargMustris > 0) {
                    kontrolliKatkestusIndeks = this.jargMustris;
                    this.jargMustris = 0;
                    this.vaheleJaetud = 0;
                    this.kontrolliMustrileVastavust(sona, kontrollitudSonaKlassid, kontrolliKatkestusIndeks);
                }
            }
        } else {
            String voti = String.valueOf(this.jargMustris);
            this.lisaSonaMalliRahuldavateSonadeHulka(voti, sona, vastavus);
            if (vastavus == MallileVastavus.VASTAB_LOPLIKULT) {
                if (this.jargMustris - this.vaheleJaetud < this.sonaMallid.size() - this.vaheleJaetud - 1) {
                    ++this.jargMustris;
                } else {
                    ajavaljendOnLeitud = true;
                }
            }
        }
        if (ajavaljendOnLeitud) {
            this.konstrueeriJaKinnitaEraldatudAjavaljendiKandidaat();
            this.malliRahuldavadAlamFraasid.clear();
            this.sonaMallideOlekud.clear();
            int viimaneJargMustris = this.jargMustris;
            this.jargMustris = 0;
            this.vaheleJaetud = 0;
            if (this.onValikuline.get(viimaneJargMustris).booleanValue()) {
                this.kontrolliMustrileVastavust(sona, kontrollitudSonaKlassid);
            }
        }
    }

    private MallileVastavus kontrolliSonaMallileVastavust(AjavtSona sona, int sonaMalliID, HashMap<String, MallileVastavus> kontrollitudSonaKlassid) {
        SonaMall kontrollitavMall = this.sonaMallid.get(sonaMalliID);
        if (kontrollitavMall.getTyyp() == SonaMall.TYYP.SONAKLASS) {
            String klassiNimi = ((SonaKlass)kontrollitavMall).getNimi();
            if (kontrollitudSonaKlassid.containsKey(klassiNimi)) {
                return kontrollitudSonaKlassid.get(klassiNimi);
            }
            MallileVastavus vastavus = kontrollitavMall.vastabMallile(sona);
            kontrollitudSonaKlassid.put(klassiNimi, vastavus);
            return vastavus;
        }
        return kontrollitavMall.vastabMallile(sona);
    }

    private void lisaSonaMalliRahuldavateSonadeHulka(String voti, AjavtSona sona, MallileVastavus vastavus) {
        List<Object> malliRahuldavAlamFraas = null;
        if (this.sonaMallideOlekud.containsKey(voti) && this.malliRahuldavadAlamFraasid.containsKey(voti)) {
            malliRahuldavAlamFraas = this.malliRahuldavadAlamFraasid.get(voti);
            malliRahuldavAlamFraas.add(sona);
        } else {
            malliRahuldavAlamFraas = new ArrayList<AjavtSona>();
            malliRahuldavAlamFraas.add(sona);
        }
        this.malliRahuldavadAlamFraasid.put(voti, malliRahuldavAlamFraas);
        this.sonaMallideOlekud.put(voti, vastavus);
    }

    private AjavaljendiKandidaat konstrueeriJaKinnitaEraldatudAjavaljendiKandidaat() {
        AjavaljendiKandidaat ajavaljendiKandidaat = null;
        List<AjavtSona> eraldatudSonad = this.koguKokkuEraldatudSonadOigesJarjekorras();
        if (!eraldatudSonad.isEmpty()) {
            ajavaljendiKandidaat = new AjavaljendiKandidaat();
            if (!this.lisaKandidaadileSemantikaDefinitsioonid(ajavaljendiKandidaat)) {
                return null;
            }
            AjaTuvastaja.seoSonadKandidaadiKylge(ajavaljendiKandidaat, eraldatudSonad);
            ajavaljendiKandidaat.lisaTuvastamisReegel(this.tuvastamisReegel);
            ajavaljendiKandidaat.setMustriID(this.mustriID);
        }
        return ajavaljendiKandidaat;
    }

    private List<AjavtSona> koguKokkuEraldatudSonadOigesJarjekorras() {
        ArrayList<AjavtSona> eraldatudSonad = new ArrayList<AjavtSona>();
        for (int i = 0; i < this.sonaMallid.size(); ++i) {
            Boolean onArajaetavSona;
            String voti = String.valueOf(i);
            if (!this.malliRahuldavadAlamFraasid.containsKey(voti) || (onArajaetavSona = this.onArajaetav.get(i)).booleanValue()) continue;
            List<AjavtSona> malliRahuldavAlamFraas = this.malliRahuldavadAlamFraasid.get(voti);
            for (int k = 0; k < malliRahuldavAlamFraas.size(); ++k) {
                eraldatudSonad.add(malliRahuldavAlamFraas.get(k));
            }
        }
        return eraldatudSonad;
    }

    private boolean lisaKandidaadileSemantikaDefinitsioonid(AjavaljendiKandidaat ajav) {
        SemDefValjadeParsija.FORMAT_OF_VALUE formatOfValue;
        boolean eraldatiVahemaltYksSemDef = false;
        ArrayList<SemantikaDefinitsioon> semDefidSonaMallidest = new ArrayList<SemantikaDefinitsioon>();
        HashMap<Integer, String> semDefidSonaMallidestIndeksMustris = new HashMap<Integer, String>();
        HashMap<String, String> rahuldatudMustriosad = new HashMap<String, String>();
        for (int i = 0; i < this.sonaMallid.size(); ++i) {
            String voti = String.valueOf(i);
            if (!this.malliRahuldavadAlamFraasid.containsKey(voti)) continue;
            List<AjavtSona> malliRahuldavAlamFraas = this.malliRahuldavadAlamFraasid.get(voti);
            AjavtSona viimaneSobitunudSona = malliRahuldavAlamFraas.get(malliRahuldavAlamFraas.size() - 1);
            List<SemantikaDefinitsioon> semDefs = this.sonaMallid.get(i).tagastaMalliSemantilineOsa(viimaneSobitunudSona);
            if (semDefs == null || semDefs.isEmpty()) continue;
            if (semDefs.get(0).getSonaKlass() != null) {
                rahuldatudMustriosad.put(semDefs.get(0).getSonaKlass(), "1");
                rahuldatudMustriosad.put(semDefs.get(0).getSonaKlass() + "_" + voti, "1");
                for (int j = 0; j < semDefs.size(); ++j) {
                    semDefidSonaMallidestIndeksMustris.put(semDefidSonaMallidest.size() + j, voti);
                }
            }
            semDefidSonaMallidest.addAll(semDefs);
        }
        if (this.tuvastamisReegel != null) {
            List<SemantikaDefinitsioon> semDefidUued = this.tuvastamisReegel.taiendaSonaMallidestSaadudSemDeffe(this.malliRahuldavadAlamFraasid, rahuldatudMustriosad, semDefidSonaMallidest, semDefidSonaMallidestIndeksMustris, this.sonaMallid);
            semDefidSonaMallidest.addAll(semDefidUued);
        }
        for (SemantikaDefinitsioon semDefinitsioon1 : semDefidSonaMallidest) {
            String refferedName;
            formatOfValue = SemDefValjadeParsija.detectFormatOfValue(semDefinitsioon1.getSemValue());
            if (formatOfValue == SemDefValjadeParsija.FORMAT_OF_VALUE.REF_TO_VAL) {
                refferedName = semDefinitsioon1.getSemValue().split(":")[1];
                for (SemantikaDefinitsioon semDefinitsioon2 : semDefidSonaMallidest) {
                    if (semDefinitsioon2.getSonaKlass() == null || !semDefinitsioon2.getSonaKlass().equals(refferedName) || semDefinitsioon2.getSemValue() == null) continue;
                    semDefinitsioon1.setSemValue(semDefinitsioon2.getSemValue());
                }
            }
            if (formatOfValue != SemDefValjadeParsija.FORMAT_OF_VALUE.REF_TO_LAB) continue;
            refferedName = semDefinitsioon1.getSemValue().split(":")[1];
            for (SemantikaDefinitsioon semDefinitsioon2 : semDefidSonaMallidest) {
                if (semDefinitsioon2.getSonaKlass() == null || !semDefinitsioon2.getSonaKlass().equals(refferedName) || semDefinitsioon2.getSemLabel() == null) continue;
                semDefinitsioon1.setSemValue(semDefinitsioon2.getSemLabel());
            }
        }
        ListIterator<SemantikaDefinitsioon> listIterator = semDefidSonaMallidest.listIterator();
        while (listIterator.hasNext()) {
            SemantikaDefinitsioon semDefinitsioon = (SemantikaDefinitsioon)listIterator.next();
            formatOfValue = SemDefValjadeParsija.detectFormatOfValue(semDefinitsioon.getSemValue());
            if (semDefinitsioon.getGranulaarsus() != Granulaarsus.HOUR_OF_DAY && (semDefinitsioon.getSemLabel() != null || formatOfValue == SemDefValjadeParsija.FORMAT_OF_VALUE.UNSET || formatOfValue == SemDefValjadeParsija.FORMAT_OF_VALUE.INTEGER || formatOfValue == SemDefValjadeParsija.FORMAT_OF_VALUE.FRACTION || formatOfValue == SemDefValjadeParsija.FORMAT_OF_VALUE.CONSTANT)) continue;
            List<SemantikaDefinitsioon> lahtikirjutatudDefinitsioonid = SemDefValjadeParsija.kirjutaLahtiSemantikadefinitsioon(semDefinitsioon, formatOfValue);
            listIterator.remove();
            for (SemantikaDefinitsioon lahtiKirjutatudSemDef : lahtikirjutatudDefinitsioonid) {
                listIterator.add(lahtiKirjutatudSemDef);
            }
        }
        Collections.sort(semDefidSonaMallidest);
        for (int i = 0; i < semDefidSonaMallidest.size(); ++i) {
            SemantikaDefinitsioon semDefinitsioon = (SemantikaDefinitsioon)semDefidSonaMallidest.get(i);
            ajav.lisaSemantikaEhitusklots(semDefinitsioon);
            eraldatiVahemaltYksSemDef = true;
        }
        if (eraldatiVahemaltYksSemDef && this.tuvastamisReegel != null && this.tuvastamisReegel.kasLeidubMustriTahiseid()) {
            List<MustriTahis> mustriTahised = this.tuvastamisReegel.parsiRahuldatudMustriosaleVastavadMustriTahised(this.malliRahuldavadAlamFraasid, rahuldatudMustriosad);
            ajav.lisaMustriTahised(mustriTahised);
        }
        return eraldatiVahemaltYksSemDef;
    }

    @Override
    public String getMustriID() {
        return this.mustriID;
    }

    @Override
    public void setMustriID(String mustriID) {
        this.mustriID = mustriID;
    }

    @Override
    public List<SonaMall> getSonaMallid() {
        return this.sonaMallid;
    }

    @Override
    public void setTuvastamisReegel(TuvastamisReegel tuvastamisReegel) {
        this.tuvastamisReegel = tuvastamisReegel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mustriID != null) {
            sb.append(this.mustriID);
            sb.append(" ");
        }
        sb.append("< ");
        for (int i = 0; i < this.sonaMallid.size(); ++i) {
            SonaMall mall = this.sonaMallid.get(i);
            sb.append(mall);
            Boolean ongiValikuline = this.onValikuline.get(i);
            if (ongiValikuline.booleanValue()) {
                sb.append("?");
            }
            sb.append(" ");
        }
        sb.append(">");
        return sb.toString();
    }
}

