/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.wrappers.impl;

import ee.ut.soras.wrappers.EstyhmmWrapper;
import ee.ut.soras.wrappers.SisendVooLugejaLoim;
import ee.ut.soras.wrappers.erind.EstYhmmErind;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class EstyhmmWrapperImpl
implements EstyhmmWrapper {
    private String[] cmds = new String[]{"t3mesta", "-Y", "-cio", "utf8"};
    private String charset = "UTF8";

    public EstyhmmWrapperImpl(String cmd, String encoding) {
        if (cmd != null && cmd.length() > 0) {
            this.cmds = cmd.split("(\\s+)");
        }
        this.charset = encoding;
    }

    @Override
    public String process(String text) throws Exception {
        Process p = null;
        ArrayList<String> command = new ArrayList<String>(4);
        for (String cmdName : this.cmds) {
            command.add(cmdName);
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        p = pb.start();
        SisendVooLugejaLoim stdInLugeja = new SisendVooLugejaLoim(p.getInputStream(), this.charset);
        SisendVooLugejaLoim stdErrLugeja = new SisendVooLugejaLoim(p.getErrorStream(), this.charset);
        stdErrLugeja.start();
        stdInLugeja.start();
        BufferedWriter outToEstYhmm = new BufferedWriter(new OutputStreamWriter(p.getOutputStream(), this.charset));
        outToEstYhmm.append(text);
        outToEstYhmm.close();
        int exitValue = p.waitFor();
        if (exitValue != 0) {
            throw new EstYhmmErind("Exitvalue: " + exitValue);
        }
        stdInLugeja.join();
        stdErrLugeja.join();
        p.getInputStream().close();
        p.getOutputStream().close();
        p.getErrorStream().close();
        return stdInLugeja.getSisendVooValjund();
    }
}

