/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.osalau;

import ee.ut.soras.osalau.OsalauSona;
import ee.ut.soras.wrappers.mudel.MorfAnRida;
import ee.ut.soras.wrappers.mudel.MorfAnSona;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

public class MorfTunnusteHulk {
    List<MorfAnRida> tunnused = new ArrayList<MorfAnRida>(5);
    private static HashMap<String, Pattern> preCompiledPatterns = new HashMap();

    public MorfTunnusteHulk() {
    }

    public MorfTunnusteHulk(MorfAnSona sona) {
        if (sona.kasLeidusAnalyys()) {
            this.tunnused.addAll(sona.getAnalyysiTulemused());
        }
    }

    public MorfTunnusteHulk(OsalauSona sona) {
        if (sona.getMorfSona().kasLeidusAnalyys()) {
            this.tunnused.addAll(sona.getMorfSona().getAnalyysiTulemused());
        }
    }

    public MorfTunnusteHulk filterByPOS(String pos) {
        MorfTunnusteHulk uusHulk = new MorfTunnusteHulk();
        for (MorfAnRida analyys : this.tunnused) {
            if (analyys.getSonaliik() == null || !analyys.getSonaliik().equalsIgnoreCase(pos)) continue;
            uusHulk.tunnused.add(analyys);
        }
        return uusHulk;
    }

    public MorfTunnusteHulk filterByLemma(String lemma) {
        MorfTunnusteHulk uusHulk = new MorfTunnusteHulk();
        for (MorfAnRida analyys : this.tunnused) {
            if (analyys.getLemma() == null || !analyys.getLemma().equals(lemma)) continue;
            uusHulk.tunnused.add(analyys);
        }
        return uusHulk;
    }

    public MorfTunnusteHulk filterByLemmaRegExp(String lemmaRegExpStr) {
        MorfTunnusteHulk uusHulk = new MorfTunnusteHulk();
        Pattern lemmaRegExp = this.getPreCompiledPattern(lemmaRegExpStr);
        for (MorfAnRida analyys : this.tunnused) {
            if (analyys.getLemma() == null || !lemmaRegExp.matcher(analyys.getLemma()).matches()) continue;
            uusHulk.tunnused.add(analyys);
        }
        return uusHulk;
    }

    public MorfTunnusteHulk filterByFormNames(String formNamesRegExpStr) {
        MorfTunnusteHulk uusHulk = new MorfTunnusteHulk();
        Pattern formNamesRegExp = this.getPreCompiledPattern(formNamesRegExpStr);
        for (MorfAnRida analyys : this.tunnused) {
            if (analyys.getVormiNimetused() == null || !formNamesRegExp.matcher(analyys.getVormiNimetused()).matches()) continue;
            uusHulk.tunnused.add(analyys);
        }
        return uusHulk;
    }

    public MorfTunnusteHulk filterByEnding(String endingRegExpStr) {
        MorfTunnusteHulk uusHulk = new MorfTunnusteHulk();
        Pattern endingRegExp = this.getPreCompiledPattern(endingRegExpStr);
        for (MorfAnRida analyys : this.tunnused) {
            if (analyys.getLopp() == null || !endingRegExp.matcher(analyys.getLopp()).matches()) continue;
            uusHulk.tunnused.add(analyys);
        }
        return uusHulk;
    }

    private Pattern getPreCompiledPattern(String patternString) {
        if (!preCompiledPatterns.containsKey(patternString)) {
            Pattern newPattern = Pattern.compile(patternString);
            preCompiledPatterns.put(patternString, newPattern);
        }
        return preCompiledPatterns.get(patternString);
    }

    public boolean isEmpty() {
        return this.tunnused == null || this.tunnused.isEmpty();
    }

    public boolean formNamesFromFirstAnalysesMatch(MorfTunnusteHulk otherMorphFeatures) {
        if (!this.isEmpty() && !otherMorphFeatures.isEmpty()) {
            MorfAnRida morfAnRida1 = this.tunnused.get(0);
            MorfAnRida morfAnRida2 = otherMorphFeatures.tunnused.get(0);
            String formNames1 = morfAnRida1.getVormiNimetused();
            String formNames2 = morfAnRida2.getVormiNimetused();
            return formNames1 != null && formNames2 != null && formNames1.equals(formNames2);
        }
        return false;
    }
}

