/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.osalau;

import ee.ut.soras.osalau.MorfTunnusteHulk;
import ee.ut.soras.osalau.OsalauSona;
import ee.ut.soras.osalau.SonaMall;
import ee.ut.soras.osalau.TekstiFiltreerimine;
import ee.ut.soras.osalau.ValjundiVormistaja;
import ee.ut.soras.wrappers.impl.VabaMorfJSONReader;
import ee.ut.soras.wrappers.mudel.MorfAnSona;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;

public class Osalausestaja {
    private Pattern koneAlgusJutumark = Pattern.compile("^[\"\u00ab\u02ee\u030b\u201c\u201d\u201e].*$");
    private Pattern koneLoppJutumark = Pattern.compile("^.*[\"\u00bb\u02ee\u030b\u201c\u201d\u201e]$");

    public List<OsalauSona> osalausesta(List<MorfAnSona> sonad) {
        ArrayList<OsalauSona> osalauSonad = new ArrayList<OsalauSona>(sonad.size());
        for (int i = 0; i < sonad.size(); ++i) {
            osalauSonad.add(new OsalauSona(sonad.get(i)));
        }
        List<List<OsalauSona>> laused = TekstiFiltreerimine.eraldaLaused(osalauSonad);
        this.lisaSulgudeKindladPiirid(laused);
        this.lisaKesksedVerbid(laused);
        this.lisaOletuslikudPiirid1(laused);
        this.lisaJutum2rkidePiirid(laused);
        List<List<OsalauSona>> lausedOsalaused = TekstiFiltreerimine.jagaKindlatePiirideKohalt(laused);
        this.eemaldaOletuslikudPiirid1(lausedOsalaused);
        lausedOsalaused = TekstiFiltreerimine.jagaKindlatePiirideKohalt(laused);
        this.lisaKindladPiirid1(lausedOsalaused);
        lausedOsalaused = TekstiFiltreerimine.jagaKindlatePiirideKohalt(laused);
        this.liitOeldisteKorrektsioon(lausedOsalaused);
        this.eemaldaOletuslikudPiirid2(lausedOsalaused);
        lausedOsalaused = TekstiFiltreerimine.jagaKindlatePiirideKohalt(laused);
        this.eemaldaLoetelud(lausedOsalaused);
        for (List<OsalauSona> osalause : lausedOsalaused) {
            new EelnevadJargnevadOeldised(osalause, new SonaMall(OsalauSona.MARGEND.OLETATAV_PIIR), true);
        }
        lausedOsalaused = TekstiFiltreerimine.jagaKindlatePiirideKohalt(laused);
        this.teisendaKiiludeks(laused, true);
        return osalauSonad;
    }

    public String osalausestaPyVabamorfJSON(String sisendJSON) throws Exception {
        List<MorfAnSona> tekstiSonad = null;
        try {
            BufferedReader inputReader = new BufferedReader(new StringReader(sisendJSON));
            tekstiSonad = VabaMorfJSONReader.parseJSONtext(inputReader);
            inputReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        List<OsalauSona> margendatudSonad = this.osalausesta(tekstiSonad);
        return ValjundiVormistaja.vormistaTulemusVabaMorfiJSONkujul(sisendJSON, margendatudSonad, false);
    }

    private void lisaSulgudeKindladPiirid(List<List<OsalauSona>> laused) {
        SonaMall suludOnYmber = new SonaMall(Pattern.compile("^\\(.+\\)[.,;!?]*$"));
        for (List<OsalauSona> lause : laused) {
            Stack<Integer> avavadSulud = new Stack<Integer>();
            for (int i = 0; i < lause.size(); ++i) {
                String algSona = lause.get(i).getNormAlgSona();
                for (int j = 0; j < algSona.length(); ++j) {
                    if (algSona.charAt(j) == '(') {
                        avavadSulud.push(i);
                        continue;
                    }
                    if (algSona.charAt(j) != ')' || avavadSulud.isEmpty()) continue;
                    Integer indeks = (Integer)avavadSulud.pop();
                    OsalauSona suluAlgusSona = lause.get(indeks);
                    boolean voibKiilunaEraldada = true;
                    if (indeks == i) {
                        try {
                            voibKiilunaEraldada = suludOnYmber.vastabMallileAND(suluAlgusSona);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.exit(-1);
                        }
                    }
                    if (!voibKiilunaEraldada) continue;
                    suluAlgusSona.lisaMargend(OsalauSona.MARGEND.KIILU_ALGUS);
                    lause.get(i).lisaMargend(OsalauSona.MARGEND.KIILU_LOPP);
                }
            }
        }
    }

    private void lisaKesksedVerbid(List<List<OsalauSona>> laused) {
        SonaMall onKomaLopus = new SonaMall(Pattern.compile("^.*,$"));
        for (List<OsalauSona> lause : laused) {
            for (int i = 0; i < lause.size(); ++i) {
                MorfTunnusteHulk tunnused2;
                MorfTunnusteHulk tunnused = new MorfTunnusteHulk(lause.get(i));
                MorfTunnusteHulk verbiTunnused = tunnused.filterByPOS("_V_");
                if (verbiTunnused.isEmpty()) continue;
                if (verbiTunnused.filterByFormNames("^\\s*(ma|mata|mas|mast|maks|da|des|tama|v|tav|tud|nud),?\\s*$").isEmpty() && verbiTunnused.filterByLemma("ei").isEmpty() && verbiTunnused.filterByLemma("\u00e4ra").isEmpty()) {
                    lause.get(i).lisaMargend(OsalauSona.MARGEND.OELDIS);
                }
                if (!verbiTunnused.filterByLemma("ei").isEmpty() && i + 1 < lause.size()) {
                    tunnused2 = new MorfTunnusteHulk(lause.get(i + 1).getMorfSona());
                    if (!tunnused2.filterByPOS("_V_").filterByEnding("^\\s*(nud|dud|tud)(ki)?\\s*$").isEmpty()) {
                        lause.get(i).lisaMargend(OsalauSona.MARGEND.OELDIS);
                        lause.get(i + 1).lisaMargend(OsalauSona.MARGEND.OELDIS);
                    }
                    if (!tunnused2.filterByPOS("_V_").filterByFormNames("^\\s*(o),?\\s*$").isEmpty()) {
                        lause.get(i).lisaMargend(OsalauSona.MARGEND.OELDIS);
                        lause.get(i + 1).lisaMargend(OsalauSona.MARGEND.OELDIS);
                    }
                }
                if (!verbiTunnused.filterByLemma("\u00e4ra").isEmpty() && i + 1 < lause.size() && !(tunnused2 = new MorfTunnusteHulk(lause.get(i + 1).getMorfSona())).filterByPOS("_V_").filterByFormNames("^\\s*(o),?\\s*$").isEmpty()) {
                    lause.get(i).lisaMargend(OsalauSona.MARGEND.OELDIS);
                    lause.get(i + 1).lisaMargend(OsalauSona.MARGEND.OELDIS);
                }
                if (!verbiTunnused.filterByLemma("ole").isEmpty() && i + 1 < lause.size() && !(tunnused2 = new MorfTunnusteHulk(lause.get(i + 1).getMorfSona())).filterByPOS("_V_").filterByEnding("^\\s*(nud)(ki)?\\s*$").isEmpty()) {
                    lause.get(i).lisaMargend(OsalauSona.MARGEND.OELDIS);
                    lause.get(i + 1).lisaMargend(OsalauSona.MARGEND.OELDIS);
                }
                if (verbiTunnused.filterByFormNames("^\\s*(des|mata|maks),?\\s*$").isEmpty()) continue;
                if (i - 1 >= 0) {
                    try {
                        if (onKomaLopus.vastabMallileAND(lause.get(i - 1))) {
                            lause.get(i).lisaMargend(OsalauSona.MARGEND.OELDIS);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                }
                if (!verbiTunnused.filterByFormNames("^\\s*(des),?\\s*$").isEmpty() && i - 2 >= 0) {
                    try {
                        if (lause.get(i - 1).getNormAlgSona() != null && lause.get(i - 1).getNormAlgSona().equals("mitte") && onKomaLopus.vastabMallileAND(lause.get(i - 2))) {
                            lause.get(i).lisaMargend(OsalauSona.MARGEND.OELDIS);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                }
                if (verbiTunnused.filterByFormNames("^\\s*(des|maks),?\\s*$").isEmpty()) continue;
                if (i == 0) {
                    lause.get(i).lisaMargend(OsalauSona.MARGEND.OELDIS);
                    continue;
                }
                String algSona = lause.get(i).getNormAlgSona();
                if (algSona == null || !algSona.matches("^[ABCDEFGHIJKLMNOPRS\u0160\u017dTUV\u00d5\u00c4\u00d6\u00dc].*")) continue;
                lause.get(i).lisaMargend(OsalauSona.MARGEND.OELDIS);
            }
        }
    }

    private void lisaOletuslikudPiirid1(List<List<OsalauSona>> laused) {
        for (List<OsalauSona> lause : laused) {
            for (int i = 0; i < lause.size(); ++i) {
                String algSona = lause.get(i).getNormAlgSona();
                if (algSona != null && i != 0 && i != lause.size() - 1) {
                    if (algSona.matches("^(ja|ning|ega|v\u014di|v\u00f5i)$")) {
                        lause.get(i).lisaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                    }
                    if (algSona.matches("^.*[,;:?!]$")) {
                        lause.get(i).lisaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                    }
                    if (algSona.matches("^[.]+$")) {
                        lause.get(i).lisaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                    }
                    if (this.koneLoppJutumark.matcher(algSona).matches()) {
                        lause.get(i).lisaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                    }
                    if (this.koneAlgusJutumark.matcher(algSona).matches()) {
                        lause.get(i).lisaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                    }
                    if (!algSona.matches("^\\s*(-{1,}|\u2212|\uff0d|\u02d7|\ufe63|-|\u2010|\u2011|\u2012|\u2013|\u2014|\u2015)\\s*$")) continue;
                    lause.get(i).lisaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                    continue;
                }
                if (algSona == null || !algSona.matches("^.*\\p{Alpha}.*[,;:.?!]$")) continue;
                lause.get(i).lisaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
            }
        }
    }

    private void lisaJutum2rkidePiirid(List<List<OsalauSona>> laused) {
        SonaMall oeldis = new SonaMall(OsalauSona.MARGEND.OELDIS);
        SonaMall osalausepiir = new SonaMall(OsalauSona.MARGEND.OLETATAV_PIIR);
        osalausepiir.lisaVajalikMargend(OsalauSona.MARGEND.KINDEL_PIIR);
        SonaMall koikJutuMargid = new SonaMall(this.koneAlgusJutumark);
        koikJutuMargid.lisaTeksikujuKirjeldus(this.koneLoppJutumark);
        SonaMall jutuMarkJaOLP = new SonaMall(this.koneAlgusJutumark);
        jutuMarkJaOLP.lisaTeksikujuKirjeldus(this.koneLoppJutumark);
        jutuMarkJaOLP.lisaVajalikMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
        jutuMarkJaOLP.lisaVajalikMargend(OsalauSona.MARGEND.KINDEL_PIIR);
        jutuMarkJaOLP.lisaVajalikMargend(OsalauSona.MARGEND.KIILU_ALGUS);
        jutuMarkJaOLP.lisaVajalikMargend(OsalauSona.MARGEND.KIILU_LOPP);
        try {
            for (List<OsalauSona> lause : laused) {
                int i;
                for (int i2 = 0; i2 < lause.size(); ++i2) {
                    int j;
                    int j2;
                    String tekstiSona2;
                    OsalauSona sona = lause.get(i2);
                    String tekstiSona = sona.getNormAlgSona();
                    if (tekstiSona.matches("^.*:$") && sona.omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR) && i2 + 1 < lause.size() && this.koneAlgusJutumark.matcher(tekstiSona2 = lause.get(i2 + 1).getNormAlgSona()).matches() && (j2 = TekstiFiltreerimine.eelnebMargendigaSona(lause, i2, oeldis, osalausepiir)) > -1) {
                        lause.get(i2 + 1).lisaMargend(OsalauSona.MARGEND.KONE_ALGUS);
                        lause.get(i2 + 1).lisaMargend(OsalauSona.MARGEND.KINDEL_PIIR);
                        lause.get(i2 + 1).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                        lause.get(i2).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                    }
                    if (tekstiSona.matches("^.*[,;.?!]$") && sona.omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR)) {
                        if (i2 + 1 >= lause.size() || !this.koneLoppJutumark.matcher(tekstiSona2 = lause.get(i2 + 1).getNormAlgSona()).matches() || (j2 = TekstiFiltreerimine.jargnebMargendigaSona(lause, i2 + 1, oeldis, osalausepiir)) <= -1) continue;
                        lause.get(i2 + 1).lisaMargend(OsalauSona.MARGEND.KONE_LOPP);
                        lause.get(i2 + 1).lisaMargend(OsalauSona.MARGEND.KINDEL_PIIR);
                        lause.get(i2 + 1).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                        lause.get(i2).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                        continue;
                    }
                    if (!this.koneLoppJutumark.matcher(tekstiSona).matches() || !tekstiSona.matches("^.*[,;.?!].{1,2}$") || !sona.omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR) || (j = TekstiFiltreerimine.jargnebMargendigaSona(lause, i2, oeldis, osalausepiir)) <= -1) continue;
                    lause.get(i2).lisaMargend(OsalauSona.MARGEND.KONE_LOPP);
                    lause.get(i2).lisaMargend(OsalauSona.MARGEND.KINDEL_PIIR);
                    lause.get(i2).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                }
                ArrayList<Integer> jutuMarkideIndeksid = new ArrayList<Integer>();
                for (i = 0; i < lause.size(); ++i) {
                    OsalauSona sona = lause.get(i);
                    if (!koikJutuMargid.vastabMallileOR(sona) || sona.omabMargendit(OsalauSona.MARGEND.KINDEL_PIIR)) continue;
                    jutuMarkideIndeksid.add(i);
                }
                if (jutuMarkideIndeksid.size() == 2) {
                    int alustavMark = (Integer)jutuMarkideIndeksid.get(0);
                    int lopetavMark = (Integer)jutuMarkideIndeksid.get(1);
                    int oeldisEnneMarke = TekstiFiltreerimine.eelnebMargendigaSona(lause, alustavMark, oeldis, jutuMarkJaOLP);
                    int oeldisParastMarke = TekstiFiltreerimine.jargnebMargendigaSona(lause, lopetavMark, oeldis, jutuMarkJaOLP);
                    int oeldisMarkideSees = TekstiFiltreerimine.jargnebMargendigaSona(lause, alustavMark, oeldis, koikJutuMargid);
                    int jutum2rkM2rkideSees = TekstiFiltreerimine.jargnebMargendigaSonaOR(lause, alustavMark, koikJutuMargid, null);
                    if (jutum2rkM2rkideSees > -1 && jutum2rkM2rkideSees < lopetavMark) continue;
                    if (oeldisMarkideSees > -1 && (oeldisEnneMarke > -1 || oeldisParastMarke > -1)) {
                        lause.get(alustavMark).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                        lause.get(alustavMark).eemaldaMargend(OsalauSona.MARGEND.KINDEL_PIIR);
                        lause.get(alustavMark).lisaMargend(OsalauSona.MARGEND.KIILU_ALGUS);
                        lause.get(lopetavMark).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                        lause.get(lopetavMark).eemaldaMargend(OsalauSona.MARGEND.KINDEL_PIIR);
                        lause.get(lopetavMark).lisaMargend(OsalauSona.MARGEND.KIILU_LOPP);
                    }
                }
                for (i = 0; i < lause.size(); ++i) {
                    OsalauSona sona = lause.get(i);
                    if (!koikJutuMargid.vastabMallileOR(sona) || !sona.omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR)) continue;
                    sona.eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void eemaldaOletuslikudPiirid1(List<List<OsalauSona>> tykeldus) {
        SonaMall koolonLopus = new SonaMall(Pattern.compile("^.*:$"));
        SonaMall kriipsLopus = new SonaMall(Pattern.compile("^[^-]+-$"));
        SonaMall ainultkirjaVM = new SonaMall(Pattern.compile("^[.?!]{1,}$"));
        SonaMall kirjaVMLopus = new SonaMall(Pattern.compile("^.*[.?!]{1,}$"));
        SonaMall koolonSemiKLopus = new SonaMall(Pattern.compile("^.*[;:]$"));
        SonaMall initsiaalid = new SonaMall(Pattern.compile("^([A-Z\u0160\u017d\u00d5\u00c4\u00d6\u00dc-]+\\.)+:?$"));
        try {
            OsalauSona eelmineSona = null;
            for (List<OsalauSona> osalause : tykeldus) {
                for (int i = 0; i < osalause.size(); ++i) {
                    OsalauSona eelmSona;
                    MorfTunnusteHulk j2rgmSonaTunnused;
                    OsalauSona sona = osalause.get(i);
                    if (!(!koolonLopus.vastabMallileAND(sona) || i + 1 >= osalause.size() || (j2rgmSonaTunnused = new MorfTunnusteHulk(osalause.get(i + 1))).filterByPOS("_N_").isEmpty() && j2rgmSonaTunnused.filterByPOS("_O_").isEmpty())) {
                        MorfTunnusteHulk eelSonaTunnused = null;
                        if (sona.getNormAlgSona().length() > 1) {
                            eelSonaTunnused = new MorfTunnusteHulk(sona);
                        } else if (i - 1 > -1) {
                            eelSonaTunnused = new MorfTunnusteHulk(osalause.get(i - 1));
                        }
                        if (eelSonaTunnused != null && !eelSonaTunnused.filterByPOS("_N_").isEmpty()) {
                            sona.eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                        }
                    }
                    if (kriipsLopus.vastabMallileAND(sona) && i + 1 < osalause.size() && osalause.get(i + 1).omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR)) {
                        osalause.get(i + 1).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                    }
                    if (ainultkirjaVM.vastabMallileAND(sona) && sona.omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR) && i - 1 > -1 && kirjaVMLopus.vastabMallileAND(eelmSona = osalause.get(i - 1)) && eelmSona.omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR)) {
                        eelmSona.eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                    }
                    if (koolonSemiKLopus.vastabMallileAND(sona) && sona.omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR)) {
                        sona.eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                        sona.lisaMargend(OsalauSona.MARGEND.KINDEL_PIIR);
                    }
                    if ((eelmineSona == null || eelmineSona.getMorfSona().onLauseLopp()) && initsiaalid.vastabMallileAND(sona)) {
                        if (koolonSemiKLopus.vastabMallileAND(sona)) {
                            sona.eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                            sona.lisaMargend(OsalauSona.MARGEND.KINDEL_PIIR);
                        } else if (i + 1 < osalause.size() && koolonSemiKLopus.vastabMallileAND(osalause.get(i + 1))) {
                            osalause.get(i + 1).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                            osalause.get(i + 1).lisaMargend(OsalauSona.MARGEND.KINDEL_PIIR);
                        }
                    }
                    eelmineSona = sona;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void lisaKindladPiirid1(List<List<OsalauSona>> tykeldus) {
        SonaMall komaKriipsLopus = new SonaMall(Pattern.compile("^.*(,|-{1,}|\u2212|\uff0d|\u02d7|\ufe63|-|\u2010|\u2011|\u2012|\u2013|\u2014|\u2015)$"));
        SonaMall jaNingEgaVoi = new SonaMall(Pattern.compile("^(ja|ning|ega|v\u014di|v\u00f5i)$"));
        SonaMall agaKuigi = new SonaMall(Pattern.compile("^(aga|kuigi)$"));
        SonaMall etKuiMillalJne = new SonaMall(Pattern.compile("^(et|kui|millal|kus|kuhu|kust|sest|kuid|nagu|ehkki|siis|kuni|otsekui|justkui|kuna|kuidas|kas|siis)$"));
        SonaMall oeldis = new SonaMall(OsalauSona.MARGEND.OELDIS);
        SonaMall osalausepiir = new SonaMall(OsalauSona.MARGEND.OLETATAV_PIIR);
        osalausepiir.lisaVajalikMargend(OsalauSona.MARGEND.KINDEL_PIIR);
        try {
            for (List<OsalauSona> osalause : tykeldus) {
                for (int i = 0; i < osalause.size(); ++i) {
                    MorfTunnusteHulk j2rgmSona;
                    OsalauSona sona = osalause.get(i);
                    if (!komaKriipsLopus.vastabMallileAND(sona) || i + 1 >= osalause.size() || !sona.omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR) && !sona.omabMargendit(OsalauSona.MARGEND.KINDEL_PIIR)) continue;
                    if (jaNingEgaVoi.vastabMallileAND(osalause.get(i + 1)) && (osalause.get(i + 1).omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR) || osalause.get(i + 1).omabMargendit(OsalauSona.MARGEND.KINDEL_PIIR))) {
                        sona.asendaMargend(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                        osalause.get(i + 1).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                        osalause.get(i + 1).eemaldaMargend(OsalauSona.MARGEND.KINDEL_PIIR);
                    }
                    if (agaKuigi.vastabMallileAND(osalause.get(i + 1)) && TekstiFiltreerimine.jargnebMargendigaSona(osalause, i + 1, oeldis, osalausepiir) > -1) {
                        sona.asendaMargend(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                    }
                    if (etKuiMillalJne.vastabMallileAND(osalause.get(i + 1))) {
                        sona.asendaMargend(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                    }
                    if (!(j2rgmSona = new MorfTunnusteHulk(osalause.get(i + 1))).filterByLemmaRegExp("^(mis|mis_*sugune|milline|kes|see)$").isEmpty()) {
                        sona.asendaMargendRange(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                    }
                    if (i + 2 >= osalause.size() || osalause.get(i + 2).getNormAlgSona() == null || !osalause.get(i + 2).getNormAlgSona().equals("et")) continue;
                    sona.asendaMargendRange(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void liitOeldisteKorrektsioon(List<List<OsalauSona>> tykeldus) {
        SonaMall oeldis = new SonaMall(OsalauSona.MARGEND.OELDIS);
        SonaMall oletatavpiir = new SonaMall(OsalauSona.MARGEND.OLETATAV_PIIR);
        SonaMall kindelpiir = new SonaMall(OsalauSona.MARGEND.KINDEL_PIIR);
        try {
            for (List<OsalauSona> osalause : tykeldus) {
                block3: for (int i = 0; i < osalause.size(); ++i) {
                    int j;
                    MorfTunnusteHulk sonaTunnused;
                    OsalauSona sona = osalause.get(i);
                    if (!oeldis.vastabMallileAND(sona) || (sonaTunnused = new MorfTunnusteHulk(sona)).filterByPOS("_V_").filterByFormNames("^(neg)?\\s*nud,?\\s*$").isEmpty()) continue;
                    int jargnevOletatavPiir = -1;
                    if (oletatavpiir.vastabMallileAND(sona)) {
                        jargnevOletatavPiir = i;
                    } else {
                        for (j = i + 1; j < osalause.size() && !kindelpiir.vastabMallileAND(osalause.get(j)); ++j) {
                            if (!oletatavpiir.vastabMallileAND(osalause.get(j))) continue;
                            jargnevOletatavPiir = j;
                            break;
                        }
                    }
                    if (jargnevOletatavPiir <= -1) continue;
                    for (j = jargnevOletatavPiir + 1; j < osalause.size(); ++j) {
                        OsalauSona j2rgmSona = osalause.get(j);
                        MorfTunnusteHulk tunnused2 = new MorfTunnusteHulk(j2rgmSona);
                        if (!tunnused2.filterByPOS("_V_").filterByFormNames("^\\s*nud,?\\s*$").isEmpty() && !oeldis.vastabMallileAND(j2rgmSona)) {
                            j2rgmSona.lisaMargend(OsalauSona.MARGEND.OELDIS);
                            continue block3;
                        }
                        if (kindelpiir.vastabMallileAND(j2rgmSona) || oletatavpiir.vastabMallileAND(j2rgmSona)) continue block3;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void eemaldaOletuslikudPiirid2(List<List<OsalauSona>> tykeldus) {
        SonaMall oeldis = new SonaMall(OsalauSona.MARGEND.OELDIS);
        SonaMall oletatavpiir = new SonaMall(OsalauSona.MARGEND.OLETATAV_PIIR);
        SonaMall jaMall = new SonaMall(Pattern.compile("^ja$"));
        SonaMall ningMall = new SonaMall(Pattern.compile("^ning$"));
        SonaMall komagaS6na = new SonaMall(Pattern.compile("^.*,$"));
        SonaMall sisaldabT2hteNumbrit = new SonaMall(Pattern.compile("^.*\\p{Alnum}.*$"));
        SonaMall jaNingEgaV6iMall = new SonaMall(Pattern.compile("^(ja|ning|ega|v\u014di|v\u00f5i)$"));
        SonaMall oletatavJaKindel = new SonaMall(OsalauSona.MARGEND.OLETATAV_PIIR);
        oletatavJaKindel.lisaVajalikMargend(OsalauSona.MARGEND.KINDEL_PIIR);
        try {
            for (List<OsalauSona> osalause : tykeldus) {
                EelnevadJargnevadOeldised eelnevadJargnevadOeldised = new EelnevadJargnevadOeldised(osalause, new SonaMall(OsalauSona.MARGEND.OLETATAV_PIIR), true);
                for (int i = 0; i < osalause.size(); ++i) {
                    int jargnevOeldis;
                    int eelnevOeldis;
                    OsalauSona sona = osalause.get(i);
                    if (oletatavpiir.vastabMallileAND(sona)) {
                        eelnevOeldis = eelnevadJargnevadOeldised.getEelnevaOeldiseIndeks(i);
                        jargnevOeldis = eelnevadJargnevadOeldised.getJargnevaOeldiseIndeks(i);
                        if (jaMall.vastabMallileAND(sona) && eelnevOeldis > -1 && jargnevOeldis == -1) {
                            int jargnevNing = TekstiFiltreerimine.jargnebMargendigaSona(osalause, i, ningMall, null);
                            int jargnevOLP = TekstiFiltreerimine.jargnebMargendigaSonaOR(osalause, i, oletatavJaKindel, null);
                            if (jargnevNing > -1 && (jargnevOLP == -1 || jargnevOLP >= jargnevNing)) {
                                int ningEelnevOeldis = eelnevadJargnevadOeldised.getEelnevaOeldiseIndeks(jargnevNing);
                                int ningJargnevOeldis = eelnevadJargnevadOeldised.getJargnevaOeldiseIndeks(jargnevNing);
                                if (ningEelnevOeldis == -1 && ningJargnevOeldis > -1) {
                                    osalause.get(jargnevNing).asendaMargend(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                                }
                            }
                        }
                    }
                    if (oletatavpiir.vastabMallileAND(sona)) {
                        eelnevOeldis = eelnevadJargnevadOeldised.getEelnevaOeldiseIndeks(i);
                        jargnevOeldis = eelnevadJargnevadOeldised.getJargnevaOeldiseIndeks(i);
                        if ((jaMall.vastabMallileAND(sona) || ningMall.vastabMallileAND(sona)) && eelnevOeldis == -1 && jargnevOeldis == i + 1 && i - 1 > -1 && sisaldabT2hteNumbrit.vastabMallileAND(osalause.get(i - 1))) {
                            osalause.get(i).asendaMargend(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                        }
                    }
                    if (oletatavpiir.vastabMallileAND(sona)) {
                        int eelnebOeldisKusagil;
                        MorfTunnusteHulk j2rgmSonaTunnused;
                        eelnevOeldis = eelnevadJargnevadOeldised.getEelnevaOeldiseIndeks(i);
                        jargnevOeldis = eelnevadJargnevadOeldised.getJargnevaOeldiseIndeks(i);
                        if (eelnevOeldis == -1 && jargnevOeldis == i + 2 && !(j2rgmSonaTunnused = new MorfTunnusteHulk(osalause.get(i + 1))).filterByPOS("_P_").isEmpty() && (eelnebOeldisKusagil = TekstiFiltreerimine.eelnebMargendigaSona(osalause, i, oeldis, null)) > -1) {
                            osalause.get(i).asendaMargend(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                        }
                    }
                    if (oletatavpiir.vastabMallileAND(sona) && jaNingEgaV6iMall.vastabMallileAND(sona)) {
                        if (i + 2 < osalause.size() && komagaS6na.vastabMallileAND(osalause.get(i + 2)) && !osalause.get(i + 2).omabMargendit(OsalauSona.MARGEND.KINDEL_PIIR)) {
                            osalause.get(i).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                        }
                        if (i + 1 < osalause.size() && komagaS6na.vastabMallileAND(osalause.get(i + 1)) && !osalause.get(i + 1).omabMargendit(OsalauSona.MARGEND.KINDEL_PIIR)) {
                            osalause.get(i).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                        }
                    }
                    if (i == 0) {
                        int j;
                        boolean verbLeitud;
                        MorfTunnusteHulk tunnused = new MorfTunnusteHulk(osalause.get(i));
                        int jargnebKomaga = TekstiFiltreerimine.jargnebMargendigaSona(osalause, i, komagaS6na, null);
                        if (!tunnused.filterByLemma("kui").isEmpty()) {
                            MorfTunnusteHulk j2rgmSonaTunnused;
                            if (jargnebKomaga > -1 && jargnebKomaga + 1 < osalause.size() && osalause.get(jargnebKomaga).omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR) && !(j2rgmSonaTunnused = new MorfTunnusteHulk(osalause.get(jargnebKomaga + 1))).filterByPOS("_V_").isEmpty() && TekstiFiltreerimine.eelnebMargendigaSonaOR(osalause, jargnebKomaga, oletatavJaKindel, null) == -1) {
                                osalause.get(jargnebKomaga).asendaMargend(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                            }
                            if (jargnebKomaga > -1 && jargnebKomaga + 1 < osalause.size() && osalause.get(jargnebKomaga).omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR) && TekstiFiltreerimine.eelnebMargendigaSonaOR(osalause, jargnebKomaga, oletatavJaKindel, null) == -1) {
                                verbLeitud = false;
                                for (j = i + 1; j <= jargnebKomaga; ++j) {
                                    MorfTunnusteHulk sonaTunnused = new MorfTunnusteHulk(osalause.get(j));
                                    if (sonaTunnused.filterByPOS("_V_").isEmpty()) continue;
                                    verbLeitud = true;
                                    break;
                                }
                                if (verbLeitud) {
                                    boolean teineVerbLeitud = false;
                                    for (int j2 = jargnebKomaga + 1; j2 < osalause.size() && !oletatavJaKindel.vastabMallileOR(osalause.get(j2)); ++j2) {
                                        MorfTunnusteHulk sonaTunnused = new MorfTunnusteHulk(osalause.get(j2));
                                        if (sonaTunnused.filterByPOS("_V_").isEmpty()) continue;
                                        teineVerbLeitud = true;
                                        break;
                                    }
                                    if (teineVerbLeitud) {
                                        osalause.get(jargnebKomaga).asendaMargend(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                                    }
                                }
                            }
                        }
                        if (!tunnused.filterByLemma("et").isEmpty() && jargnebKomaga > -1 && jargnebKomaga + 1 < osalause.size() && osalause.get(jargnebKomaga).omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR)) {
                            if (TekstiFiltreerimine.jargnebMargendigaSona(osalause, jargnebKomaga, oeldis, oletatavJaKindel) > -1) {
                                verbLeitud = false;
                                for (j = i + 1; j <= jargnebKomaga; ++j) {
                                    MorfTunnusteHulk sonaTunnused = new MorfTunnusteHulk(osalause.get(j));
                                    if (sonaTunnused.filterByPOS("_V_").isEmpty()) continue;
                                    verbLeitud = true;
                                    break;
                                }
                                if (verbLeitud) {
                                    osalause.get(jargnebKomaga).asendaMargend(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                                }
                            } else if (osalause.get(jargnebKomaga - 1).omabMargendit(OsalauSona.MARGEND.OELDIS)) {
                                boolean teineVerbLeitud = false;
                                for (j = jargnebKomaga + 1; j < osalause.size() && !oletatavJaKindel.vastabMallileOR(osalause.get(j)); ++j) {
                                    MorfTunnusteHulk sonaTunnused = new MorfTunnusteHulk(osalause.get(j));
                                    if (sonaTunnused.filterByPOS("_V_").isEmpty()) continue;
                                    teineVerbLeitud = true;
                                    break;
                                }
                                if (teineVerbLeitud) {
                                    osalause.get(jargnebKomaga).asendaMargend(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                                }
                            }
                        }
                    }
                    if (!oletatavpiir.vastabMallileAND(sona) || !komagaS6na.vastabMallileAND(sona)) continue;
                    int eelnevOeldis2 = eelnevadJargnevadOeldised.getEelnevaOeldiseIndeks(i);
                    jargnevOeldis = eelnevadJargnevadOeldised.getJargnevaOeldiseIndeks(i);
                    if (eelnevOeldis2 != -1 || jargnevOeldis != i + 1 || TekstiFiltreerimine.eelnebMargendigaSona(osalause, i, oeldis, null) <= -1) continue;
                    osalause.get(i).asendaMargend(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void eemaldaLoetelud(List<List<OsalauSona>> tykeldus) {
        SonaMall oletatavpiir = new SonaMall(OsalauSona.MARGEND.OLETATAV_PIIR);
        try {
            for (List<OsalauSona> osalause : tykeldus) {
                for (int i = 0; i < osalause.size(); ++i) {
                    OsalauSona sona = osalause.get(i);
                    if (!oletatavpiir.vastabMallileAND(sona)) continue;
                    String sidend = "";
                    if (sona.getNormAlgSona() != null) {
                        sidend = sona.getNormAlgSona();
                    }
                    MorfTunnusteHulk esimeseSonaTunnused = null;
                    MorfTunnusteHulk teiseSonaTunnused = null;
                    MorfTunnusteHulk sonaTunnused = new MorfTunnusteHulk(sona);
                    if (sonaTunnused.filterByPOS("_Z_").isEmpty() && sonaTunnused.filterByPOS("_J_").isEmpty()) {
                        esimeseSonaTunnused = sonaTunnused;
                    } else if (i - 1 > -1) {
                        esimeseSonaTunnused = new MorfTunnusteHulk(osalause.get(i - 1));
                    }
                    if (i + 1 < osalause.size()) {
                        teiseSonaTunnused = new MorfTunnusteHulk(osalause.get(i + 1));
                    }
                    if (esimeseSonaTunnused == null || teiseSonaTunnused == null || !esimeseSonaTunnused.formNamesFromFirstAnalysesMatch(teiseSonaTunnused) || sidend.matches("^\\s*(-{1,}|\u2212|\uff0d|\u02d7|\ufe63|-|\u2010|\u2011|\u2012|\u2013|\u2014|\u2015)\\s*$")) continue;
                    sona.eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void teisendaKiiludeks(List<List<OsalauSona>> laused, boolean eemaldaLauseL6pustKindelPiir) {
        try {
            SonaMall koikpiirid = new SonaMall(OsalauSona.MARGEND.KINDEL_PIIR);
            koikpiirid.lisaVajalikMargend(OsalauSona.MARGEND.KIILU_ALGUS);
            koikpiirid.lisaVajalikMargend(OsalauSona.MARGEND.KIILU_LOPP);
            koikpiirid.lisaVajalikMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
            SonaMall kindladpiirid = new SonaMall(OsalauSona.MARGEND.KINDEL_PIIR);
            kindladpiirid.lisaVajalikMargend(OsalauSona.MARGEND.KIILU_ALGUS);
            kindladpiirid.lisaVajalikMargend(OsalauSona.MARGEND.KIILU_LOPP);
            SonaMall kindelpiir = new SonaMall(OsalauSona.MARGEND.KINDEL_PIIR);
            SonaMall komagaS6na = new SonaMall(Pattern.compile("^.*,$"));
            SonaMall ainultKomaga = new SonaMall(Pattern.compile("^,+$"));
            SonaMall kusKustKuhuMillal = new SonaMall(Pattern.compile("^(kus|kust|kuhu|millal)$"));
            for (List<OsalauSona> lause : laused) {
                EelnevadJargnevadOeldised eelJargOeldised = new EelnevadJargnevadOeldised(lause, koikpiirid, false);
                for (int i = 0; i < lause.size(); ++i) {
                    OsalauSona sona = lause.get(i);
                    if (kindelpiir.vastabMallileAND(sona)) {
                        int eelnevOeldis = eelJargOeldised.getEelnevaOeldiseIndeks(i);
                        int jargnevOeldis = eelJargOeldised.getJargnevaOeldiseIndeks(i);
                        if (eelnevOeldis == -1 && jargnevOeldis > i) {
                            int jargnevOeldis2;
                            int j2rgmPiir;
                            int j2rgmKindel;
                            MorfTunnusteHulk jargmSonaTunnused = new MorfTunnusteHulk(lause.get(i + 1));
                            if (!jargmSonaTunnused.filterByLemmaRegExp("^(mis|kes|et)$").isEmpty()) {
                                j2rgmKindel = TekstiFiltreerimine.jargnebMargendigaSona(lause, i + 1, kindelpiir, null);
                                j2rgmPiir = TekstiFiltreerimine.jargnebMargendigaSonaOR(lause, i + 1, koikpiirid, null);
                                if (j2rgmKindel > i + 1 && j2rgmPiir == j2rgmKindel && komagaS6na.vastabMallileAND(lause.get(j2rgmKindel)) && (jargnevOeldis2 = eelJargOeldised.getJargnevaOeldiseIndeks(j2rgmKindel)) == j2rgmKindel + 1) {
                                    if (ainultKomaga.vastabMallileAND(sona)) {
                                        sona.asendaMargend(OsalauSona.MARGEND.KINDEL_PIIR, OsalauSona.MARGEND.KIILU_ALGUS);
                                    } else {
                                        sona.eemaldaMargend(OsalauSona.MARGEND.KINDEL_PIIR);
                                        lause.get(i + 1).lisaMargend(OsalauSona.MARGEND.KIILU_ALGUS);
                                    }
                                    lause.get(j2rgmKindel).asendaMargend(OsalauSona.MARGEND.KINDEL_PIIR, OsalauSona.MARGEND.KIILU_LOPP);
                                }
                            }
                            if (kusKustKuhuMillal.vastabMallileAND(lause.get(i + 1))) {
                                j2rgmKindel = TekstiFiltreerimine.jargnebMargendigaSona(lause, i + 1, kindelpiir, null);
                                j2rgmPiir = TekstiFiltreerimine.jargnebMargendigaSonaOR(lause, i + 1, koikpiirid, null);
                                if (j2rgmKindel > i + 1 && j2rgmPiir == j2rgmKindel && komagaS6na.vastabMallileAND(lause.get(j2rgmKindel)) && (jargnevOeldis2 = eelJargOeldised.getJargnevaOeldiseIndeks(j2rgmKindel)) == j2rgmKindel + 1) {
                                    if (ainultKomaga.vastabMallileAND(sona)) {
                                        sona.asendaMargend(OsalauSona.MARGEND.KINDEL_PIIR, OsalauSona.MARGEND.KIILU_ALGUS);
                                    } else {
                                        sona.eemaldaMargend(OsalauSona.MARGEND.KINDEL_PIIR);
                                        lause.get(i + 1).lisaMargend(OsalauSona.MARGEND.KIILU_ALGUS);
                                    }
                                    lause.get(j2rgmKindel).asendaMargend(OsalauSona.MARGEND.KINDEL_PIIR, OsalauSona.MARGEND.KIILU_LOPP);
                                }
                            }
                        }
                    }
                    if (i != lause.size() - 1 || !eemaldaLauseL6pustKindelPiir || !kindelpiir.vastabMallileAND(sona)) continue;
                    sona.eemaldaMargend(OsalauSona.MARGEND.KINDEL_PIIR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private class EelnevadJargnevadOeldised {
        private HashMap<Integer, Integer> eelnebOeldis = new HashMap();
        private HashMap<Integer, Integer> jargnebOeldis = new HashMap();

        public EelnevadJargnevadOeldised(List<OsalauSona> osalause, SonaMall otsitavpiir, boolean muudaOletatavadKindlaks) {
            this.leiaOtsitavatePiirideEelnevadJargnevadOeldised(osalause, otsitavpiir, muudaOletatavadKindlaks);
        }

        public void leiaOtsitavatePiirideEelnevadJargnevadOeldised(List<OsalauSona> osalause, SonaMall otsitavpiir, boolean muudaOletatavadKindlaks) {
            SonaMall oeldis = new SonaMall(OsalauSona.MARGEND.OELDIS);
            try {
                for (int i = 0; i < osalause.size(); ++i) {
                    OsalauSona sona = osalause.get(i);
                    if (!otsitavpiir.vastabMallileOR(sona)) continue;
                    int eelnevOeldis = TekstiFiltreerimine.eelnebMargendigaSona(osalause, i, oeldis, otsitavpiir);
                    int jargnevOeldis = TekstiFiltreerimine.jargnebMargendigaSona(osalause, i, oeldis, otsitavpiir);
                    if (jargnevOeldis == -1) {
                        int jargnevOeldis2 = TekstiFiltreerimine.jargnebMargendigaSona(osalause, i, oeldis, null);
                        int jargnevOletatav = TekstiFiltreerimine.jargnebMargendigaSonaOR(osalause, i, otsitavpiir, null);
                        if (jargnevOeldis2 > -1 && jargnevOeldis2 == jargnevOletatav) {
                            jargnevOeldis = jargnevOeldis2;
                        }
                    }
                    if (eelnevOeldis == -1 && sona.omabMargendit(OsalauSona.MARGEND.OELDIS)) {
                        eelnevOeldis = i;
                    }
                    this.eelnebOeldis.put(i, eelnevOeldis);
                    this.jargnebOeldis.put(i, jargnevOeldis);
                    if (!muudaOletatavadKindlaks || !sona.omabMargendit(OsalauSona.MARGEND.OLETATAV_PIIR) || eelnevOeldis <= -1 || jargnevOeldis <= -1) continue;
                    sona.asendaMargend(OsalauSona.MARGEND.OLETATAV_PIIR, OsalauSona.MARGEND.KINDEL_PIIR);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }

        public int getEelnevaOeldiseIndeks(Integer indeksOsalauses) {
            if (this.eelnebOeldis != null && this.eelnebOeldis.containsKey(indeksOsalauses)) {
                return this.eelnebOeldis.get(indeksOsalauses);
            }
            return -1;
        }

        public int getJargnevaOeldiseIndeks(Integer indeksOsalauses) {
            if (this.jargnebOeldis != null && this.jargnebOeldis.containsKey(indeksOsalauses)) {
                return this.jargnebOeldis.get(indeksOsalauses);
            }
            return -1;
        }
    }
}

