/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel.sonamallid;

import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.FraasisPaiknemiseKoht;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.SemantikaDefinitsioon;
import ee.ut.soras.ajavtV2.mudel.sonamallid.MallileVastavus;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMalliSemOsa;
import ee.ut.soras.ajavtV2.util.TextUtils;
import ee.ut.soras.wrappers.mudel.MorfAnRida;
import java.util.List;

public class ArvuEriKujudSonaMall
extends SonaMalliSemOsa
implements SonaMall {
    private String[] arvuTyybid = null;
    private int arvuVaartuseAlampiir = -1;
    private int arvuVaartuseYlempiir = -1;
    public static final Object[][] romanToArabic = new Object[][]{{"I", 1}, {"V", 5}, {"X", 10}, {"L", 50}, {"C", 100}, {"D", 500}, {"M", 1000}};

    public void setArvuVaartusePiirid(int arvuVaartuseAlampiir, int arvuVaartuseYlempiir) {
        this.arvuVaartuseAlampiir = arvuVaartuseAlampiir;
        this.arvuVaartuseYlempiir = arvuVaartuseYlempiir;
    }

    public ArvuEriKujudSonaMall() {
        this.setArvuTyyp("_N_|_O_|_F_");
    }

    public void setArvuTyyp(String inputArvuTyyp) {
        String[] split;
        if (inputArvuTyyp != null && (split = inputArvuTyyp.split("\\|")) != null && split.length > 0) {
            this.arvuTyybid = split;
        }
    }

    private boolean arvMahubEtteantudPiiridesse(int arv) {
        if (this.arvuVaartuseAlampiir != -1 && this.arvuVaartuseAlampiir > arv) {
            return false;
        }
        return this.arvuVaartuseYlempiir == -1 || this.arvuVaartuseYlempiir >= arv;
    }

    @Override
    public SonaMall.TYYP getTyyp() {
        return SonaMall.TYYP.ERIARV;
    }

    @Override
    public MallileVastavus vastabMallile(AjavtSona sona) {
        if (this.arvuTyybid != null) {
            for (String arvutyyp : this.arvuTyybid) {
                boolean rahuldabKitsendusi = true;
                if (!this.vastabArvuTyybile(arvutyyp, sona)) {
                    rahuldabKitsendusi = false;
                }
                if (arvutyyp.equals("_R_") && rahuldabKitsendusi) {
                    int arv = ArvuEriKujudSonaMall.parsiRoomaNumber(sona.getAlgSonaYmbritsevateMarkideta());
                    if (!this.arvMahubEtteantudPiiridesse(arv)) {
                        rahuldabKitsendusi = false;
                    }
                } else if (sona.getArvSonaFraasis() != FraasisPaiknemiseKoht.PUUDUB) {
                    Integer taisArvuna = sona.getArvSonaTaisArvVaartus();
                    Double murdArvuna = sona.getArvSonaMurdArvVaartus();
                    if (taisArvuna != null && !this.arvMahubEtteantudPiiridesse(taisArvuna) || murdArvuna != null && !this.arvMahubEtteantudPiiridesse(murdArvuna.intValue()) || taisArvuna == null && murdArvuna == null) {
                        rahuldabKitsendusi = false;
                    }
                } else {
                    rahuldabKitsendusi = false;
                }
                if (!rahuldabKitsendusi) continue;
                if (arvutyyp.matches("_[NOF]_")) {
                    if (sona.getArvSonaFraasis() == FraasisPaiknemiseKoht.AINUSSONA || sona.getArvSonaFraasis() == FraasisPaiknemiseKoht.LOPUS) {
                        return MallileVastavus.VASTAB_LOPLIKULT;
                    }
                    if (sona.getArvSonaFraasis() == FraasisPaiknemiseKoht.ALGUSES) {
                        return MallileVastavus.VASTAB_ALGUS;
                    }
                    if (sona.getArvSonaFraasis() != FraasisPaiknemiseKoht.KESKEL) continue;
                    return MallileVastavus.VASTAB_KESKOSA;
                }
                return MallileVastavus.VASTAB_LOPLIKULT;
            }
        }
        return MallileVastavus.EI_VASTA;
    }

    private boolean vastabArvuTyybile(String arvutyyp, AjavtSona sona) {
        if (sona.getArvSonaTaisArvVaartus() != null && sona.getArvSonaMurdArvVaartus() == null) {
            for (MorfAnRida rida : sona.getAnalyysiTulemused()) {
                if (rida.getSonaliik() == null || !rida.getSonaliik().startsWith(arvutyyp)) continue;
                return true;
            }
        } else {
            int arv;
            if (sona.getArvSonaTaisArvVaartus() == null && sona.getArvSonaMurdArvVaartus() != null && arvutyyp.matches("_F_")) {
                return true;
            }
            if (arvutyyp.equals("_R_") && (arv = ArvuEriKujudSonaMall.parsiRoomaNumber(sona.getAlgSonaYmbritsevateMarkideta())) != -1) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<SemantikaDefinitsioon> tagastaMalliSemantilineOsa(AjavtSona viimaneSobitunudSona) {
        int[] references = super.getSemValueReferences();
        List<SemantikaDefinitsioon> semRules = super.tagastaMalliSemantilineOsa(viimaneSobitunudSona);
        if (references != null && semRules != null && references.length == semRules.size() && this.arvuTyybid != null) {
            for (int i = 0; i < references.length; ++i) {
                SemantikaDefinitsioon semRule = semRules.get(i);
                int reference = references[i];
                if (reference <= -1 || semRule == null) continue;
                for (String arvutyyp : this.arvuTyybid) {
                    if (!this.vastabArvuTyybile(arvutyyp, viimaneSobitunudSona)) continue;
                    if (arvutyyp.equals("_R_")) {
                        int arv = ArvuEriKujudSonaMall.parsiRoomaNumber(viimaneSobitunudSona.getAlgSonaYmbritsevateMarkideta());
                        if (arv == -1 || !this.arvMahubEtteantudPiiridesse(arv)) continue;
                        semRule.setSemValue(String.valueOf(arv));
                        continue;
                    }
                    if (!viimaneSobitunudSona.getArvSonaFraasis().onFraasiLopp()) continue;
                    Integer taisArvuna = viimaneSobitunudSona.getArvSonaTaisArvVaartus();
                    Double murdArvuna = viimaneSobitunudSona.getArvSonaMurdArvVaartus();
                    if (murdArvuna != null) {
                        if (!this.arvMahubEtteantudPiiridesse(murdArvuna.intValue())) continue;
                        semRule.setSemValue(murdArvuna.toString().replace(".", ","));
                        continue;
                    }
                    if (taisArvuna == null || semRule.getSemValue() != null && (semRule.getSemValue() == null || TextUtils.musterMurdArv.matcher(semRule.getSemValue()).matches()) || !this.arvMahubEtteantudPiiridesse(taisArvuna)) continue;
                    semRule.setSemValue(taisArvuna.toString());
                }
            }
        }
        return semRules;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("arvu_erikujud{");
        for (String tyyp : this.arvuTyybid) {
            sb.append(tyyp);
            sb.append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static int parsiYksikRoomaNumber(String str) {
        for (Object[] fromRomanToArabicTable : romanToArabic) {
            String roman = (String)fromRomanToArabicTable[0];
            if (!roman.equalsIgnoreCase(str)) continue;
            return (Integer)fromRomanToArabicTable[1];
        }
        return -1;
    }

    public static int parsiRoomaNumber(String str) {
        int summa = 0;
        boolean unknownSymbolFound = false;
        for (int i = 0; i < str.length(); ++i) {
            String substr = str.substring(i, i + 1);
            int arabic1 = ArvuEriKujudSonaMall.parsiYksikRoomaNumber(substr);
            if (arabic1 > -1) {
                if (i == str.length() - 1) {
                    summa += arabic1;
                } else {
                    int arabic2 = ArvuEriKujudSonaMall.parsiYksikRoomaNumber(str.substring(i + 1, i + 2));
                    if (arabic2 > -1) {
                        if (arabic1 >= arabic2) {
                            summa += arabic1;
                        } else {
                            summa += arabic2 - arabic1;
                            ++i;
                        }
                    } else {
                        unknownSymbolFound = true;
                    }
                }
            } else {
                unknownSymbolFound = true;
            }
            if (!unknownSymbolFound) continue;
            summa = -1;
            break;
        }
        return summa > 0 ? summa : -1;
    }
}

