/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.mudel.sonamallid;

import ee.ut.soras.ajavtV2.mudel.AjavtSona;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.SemantikaDefinitsioon;
import ee.ut.soras.ajavtV2.mudel.sonamallid.MallileVastavus;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMalliSemOsa;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegExpSonaMall
extends SonaMalliSemOsa
implements SonaMall {
    private Pattern regexp;

    public RegExpSonaMall(String regulaaravaldis) {
        try {
            this.regexp = Pattern.compile(regulaaravaldis);
        }
        catch (PatternSyntaxException e) {
            this.regexp = null;
        }
    }

    @Override
    public MallileVastavus vastabMallile(AjavtSona sona) {
        boolean vastabMallile = false;
        if (this.regexp != null) {
            Matcher m = this.regexp.matcher(sona.getAlgSonaYmbritsevateMarkideta());
            vastabMallile = m.matches();
        }
        return vastabMallile ? MallileVastavus.VASTAB_LOPLIKULT : MallileVastavus.EI_VASTA;
    }

    public String toString() {
        return "/" + this.regexp.pattern() + "/";
    }

    @Override
    public SonaMall.TYYP getTyyp() {
        return SonaMall.TYYP.REGEXP;
    }

    @Override
    public List<SemantikaDefinitsioon> tagastaMalliSemantilineOsa(AjavtSona viimaneSobitunudSona) {
        List<String> sobitunudAlamgrupid;
        int[] references = super.getSemValueReferences();
        List<SemantikaDefinitsioon> semDefs = super.tagastaMalliSemantilineOsa(viimaneSobitunudSona);
        if (references != null && semDefs != null && this.regexp != null && references.length == semDefs.size() && !(sobitunudAlamgrupid = this.parsiSobitunudAlamgrupid(viimaneSobitunudSona, references)).isEmpty()) {
            for (int i = 0; i < references.length; ++i) {
                SemantikaDefinitsioon semDef = semDefs.get(i);
                int reference = references[i];
                if (reference <= -1 || semDef == null || sobitunudAlamgrupid.get(i).length() <= 0) continue;
                semDef.setSemValue(sobitunudAlamgrupid.get(i));
            }
        }
        return semDefs;
    }

    public List<String> parsiSobitunudAlamgrupid(AjavtSona sobituvSona, int[] references) {
        Matcher m;
        LinkedList<String> alamSoned = new LinkedList<String>();
        if (references != null && (m = this.regexp.matcher(sobituvSona.getAlgSonaYmbritsevateMarkideta())).matches()) {
            for (int i = 0; i < references.length; ++i) {
                int reference = references[i];
                if (reference > -1) {
                    if (reference > m.groupCount()) continue;
                    alamSoned.add(m.group(reference));
                    continue;
                }
                alamSoned.add("");
            }
        }
        return alamSoned;
    }
}

