/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.ajavtV2.util;

import ee.ut.soras.ajavtV2.AjaTuvastaja;
import ee.ut.soras.ajavtV2.mudel.FraasiMustriFilter;
import ee.ut.soras.ajavtV2.mudel.MustriTahis;
import ee.ut.soras.ajavtV2.mudel.TuvastamisReegel;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.AjavaljendiKandidaat;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.Granulaarsus;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.LiitumisReegel;
import ee.ut.soras.ajavtV2.mudel.ajavaljend.SemantikaDefinitsioon;
import ee.ut.soras.ajavtV2.mudel.sonamallid.AlgVormSonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.ArvuEriKujudSonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.FraasiMuster;
import ee.ut.soras.ajavtV2.mudel.sonamallid.FraasiMusterFSM;
import ee.ut.soras.ajavtV2.mudel.sonamallid.NegatiivneMuster;
import ee.ut.soras.ajavtV2.mudel.sonamallid.RegExpSonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaKlass;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMall;
import ee.ut.soras.ajavtV2.mudel.sonamallid.SonaMalliSemOsa;
import ee.ut.soras.ajavtV2.mudel.sonamallid.TavaTekstSonaMall;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MustridXMLFailist {
    public static final String TAG_SONAKLASS = "SonaKlass";
    public static final String TAG_SONAKLASS_NIMI = "nimi";
    public static final String TAG_ELEMENT = "Element";
    public static final String TAG_ELEMENT_TYYP = "tyyp";
    public static final String TAG_ELEMENT_TYYP_ALGVORM = "algv";
    public static final String TAG_ELEMENT_TYYP_REGEXP = "reg";
    public static final String TAG_ELEMENT_TYYP_ARVSONA = "arvSona";
    public static final String TAG_ELEMENT_TYYP_ERI_ARV = "eriArv";
    public static final String TAG_ELEMENT_TYYP_TEKST = "tekst";
    public static final String TAG_ELEMENT_VAARTUS = "vaartus";
    public static final String TAG_ELEMENT_NUMPIIRANG = "arvuPiirang";
    public static final String TAG_ELEMENT_ARVULIIK = "arvuLiik";
    public static final String TAG_REEGEL = "Reegel";
    public static final String TAG_MUSTER = "Muster";
    public static final String TAG_MUSTER_VBSNJRG = "vabaSonajarg";
    public static final String TAG_FILTER = "Filter";
    public static final String TAG_MORF_TUNNUSED = "morfTunnused";
    public static final String TAG_SEOTUD_MUSTRIOSA = "seotudMustriosa";
    public static final String TAG_SEMDEF = "SemReegel";
    public static final String TAG_PRIORITEET = "priority";
    public static final String TAG_SEOTUD_KONTEKST = "seotudKontekst";
    public static final String TAG_ATTRIB = "attrib";
    public static final String TAG_SEMFIELD = "semField";
    public static final String TAG_OP = "op";
    public static final String TAG_SEMLABEL = "semLabel";
    public static final String TAG_SEMVALUE = "semValue";
    public static final String TAG_SEMVAL_EBATAPNE = "semValOnEbatapne";
    public static final String TAG_EXPLICIT_POINT = "explicitPoint";
    public static final String TAG_DIRECTION = "direction";
    public static final String TAG_MUDEL = "mudel";
    public static final String TAG_MUSTRITAHIS = "MustriTahis";
    public static final String TAG_MUSTRITAHISED = "tahised";
    public static final String TAG_MUSTRITAHIS_PESA = "poleEraldiSeisevAjav";
    public static final String TAG_NEGMUSTER = "NegMuster";
    public static final String TAG_NEGMUSTER_STARTPOS = "startPos";
    public static final String TAG_NEGMUSTER_PRESPUNCT = "preservePunct";
    public static final String TAG_LIITUMISREEGEL = "LiitumisReegel";
    public static final String TAG_LIITUMISREEGEL_ASTE = "tase";
    public static final String TAG_LIITUMISREEGEL_FJRK = "fikseeritudJarjekord";
    public static final String TAG_LIITUMISREEGEL_K6RVUTI = "tapseltKorvuti";
    private Document dom;
    private HashMap<String, SonaKlass> sonaKlassid;
    private Pattern musterSonaKlass = Pattern.compile("^!?([A-Z0-9_]+)\\??$");
    private Pattern musterRegexp = Pattern.compile("^!?/([^/]+)/\\??$");
    private Pattern musterAlgvorm = Pattern.compile("^!?\\|(.+)\\|\\??$");
    private Pattern musterValikuline = Pattern.compile("^(.+)\\?$");
    private Pattern musterArajaetav = Pattern.compile("^!(.+)$");

    public void votaMustridXMLFailist(String failiNimi, AjaTuvastaja tuvastaja) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.dom = db.parse(failiNimi);
        this.sonaKlassid = this.parsiDokumendistSonaKlassid();
        tuvastaja.setSonaKlassid(this.sonaKlassid);
        tuvastaja.setReeglid(this.parsiDokumendistTuvastamisReeglid());
        tuvastaja.setLiitumisReeglid(this.parsiDokumendistLiitumisReeglid());
    }

    public void votaMustridXMLSisendvoost(InputStream in, AjaTuvastaja tuvastaja) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.dom = db.parse(in);
        this.sonaKlassid = this.parsiDokumendistSonaKlassid();
        tuvastaja.setSonaKlassid(this.sonaKlassid);
        tuvastaja.setReeglid(this.parsiDokumendistTuvastamisReeglid());
        tuvastaja.setLiitumisReeglid(this.parsiDokumendistLiitumisReeglid());
    }

    private List<TuvastamisReegel> parsiDokumendistTuvastamisReeglid() {
        ArrayList<TuvastamisReegel> reeglid = new ArrayList<TuvastamisReegel>();
        int mustriLoendur = 1;
        Element juur = this.dom.getDocumentElement();
        NodeList reegelNodes = juur.getElementsByTagName(TAG_REEGEL);
        if (reegelNodes != null && reegelNodes.getLength() > 0) {
            reeglid = new ArrayList(reegelNodes.getLength());
            for (int i = 0; i < reegelNodes.getLength(); ++i) {
                NodeList negMusterNodes;
                String muster;
                FraasiMuster fm;
                Element reegelElem = (Element)reegelNodes.item(i);
                Element musterElem = MustridXMLFailist.getElementByTagName(reegelElem, TAG_MUSTER);
                if (musterElem == null || (fm = this.parsiFraasiMuster(muster = musterElem.getTextContent(), mustriLoendur++)) == null) continue;
                TuvastamisReegel reegel = new TuvastamisReegel();
                reegel.setFraasiMuster(fm);
                reeglid.add(reegel);
                NodeList filterNodes = reegelElem.getElementsByTagName(TAG_FILTER);
                if (filterNodes != null && filterNodes.getLength() > 0) {
                    for (int j = 0; j < filterNodes.getLength(); ++j) {
                        Element filterElem = (Element)filterNodes.item(j);
                        FraasiMustriFilter fmf = this.parsiFraasiMustriFilter(filterElem);
                        if (fmf == null) continue;
                        reegel.lisaFraasiMustriFilter(fmf);
                    }
                }
                NodeList semDefNodes = reegelElem.getElementsByTagName(TAG_SEMDEF);
                LinkedList<SemantikaDefinitsioon> semDefinitsioonid = new LinkedList<SemantikaDefinitsioon>();
                if (semDefNodes != null && semDefNodes.getLength() > 0) {
                    for (int j = 0; j < semDefNodes.getLength(); ++j) {
                        SemantikaDefinitsioon semDef;
                        Element semDefElem = (Element)semDefNodes.item(j);
                        if (!semDefElem.getParentNode().equals(reegelElem) || (semDef = this.looUusSemDefElemendiPohjal(semDefElem)) == null) continue;
                        semDefinitsioonid.add(semDef);
                    }
                }
                NodeList mustriTahisNodes = reegelElem.getElementsByTagName(TAG_MUSTRITAHIS);
                LinkedList<MustriTahis> mustriTahised = new LinkedList<MustriTahis>();
                if (mustriTahisNodes != null && mustriTahisNodes.getLength() > 0) {
                    for (int j = 0; j < mustriTahisNodes.getLength(); ++j) {
                        Element tahisElem = (Element)mustriTahisNodes.item(j);
                        if (!tahisElem.getParentNode().equals(reegelElem)) continue;
                        MustriTahis tahis = this.looUusMustriTahisDefElemendiPohjal(tahisElem);
                        if (tahisElem == null) continue;
                        mustriTahised.add(tahis);
                    }
                }
                if (!semDefinitsioonid.isEmpty() || !mustriTahised.isEmpty()) {
                    FraasiMustriFilter fmf = new FraasiMustriFilter(null, null);
                    if (!semDefinitsioonid.isEmpty()) {
                        fmf.setSemDefinitsioonid(semDefinitsioonid);
                    }
                    if (!mustriTahised.isEmpty()) {
                        for (MustriTahis mustriTahis : mustriTahised) {
                            fmf.addMustriTahis(mustriTahis);
                        }
                    }
                    reegel.lisaFraasiMustriFilter(fmf);
                }
                if ((negMusterNodes = reegelElem.getElementsByTagName(TAG_NEGMUSTER)) == null || negMusterNodes.getLength() <= 0) continue;
                LinkedList<NegatiivneMuster> negMustrid = new LinkedList<NegatiivneMuster>();
                for (int j = 0; j < negMusterNodes.getLength(); ++j) {
                    Element negMusterNode = (Element)negMusterNodes.item(j);
                    NegatiivneMuster negMustr = this.looUusNegMusterElemendiPohjal(negMusterNode);
                    if (negMustr == null) continue;
                    negMustrid.add(negMustr);
                }
                if (negMustrid.isEmpty()) continue;
                reegel.setNegMustrid(negMustrid);
            }
        }
        return reeglid;
    }

    private HashMap<String, SonaKlass> parsiDokumendistSonaKlassid() {
        HashMap<String, SonaKlass> sonaKlassid = new HashMap<String, SonaKlass>();
        Element juur = this.dom.getDocumentElement();
        NodeList sonaKlassNodes = juur.getElementsByTagName(TAG_SONAKLASS);
        if (sonaKlassNodes != null && sonaKlassNodes.getLength() > 0) {
            sonaKlassid = new HashMap(sonaKlassNodes.getLength());
            for (int i = 0; i < sonaKlassNodes.getLength(); ++i) {
                SonaKlass sonaKlass = null;
                Element sonaKlassElem = (Element)sonaKlassNodes.item(i);
                String klassiNimi = MustridXMLFailist.getElementsAttributeByName(sonaKlassElem, TAG_SONAKLASS_NIMI);
                if (klassiNimi == null) continue;
                sonaKlass = new SonaKlass(klassiNimi);
                NodeList elementNodes = sonaKlassElem.getElementsByTagName(TAG_ELEMENT);
                if (elementNodes != null && elementNodes.getLength() > 0) {
                    for (int j = 0; j < elementNodes.getLength(); ++j) {
                        Element elem = (Element)elementNodes.item(j);
                        SonaMall sonaMall = this.parsiDokumendiElemendistSonaMall(elem);
                        if (sonaMall == null) continue;
                        sonaKlass.lisaElement(sonaMall);
                    }
                }
                if (sonaKlass.getElemendid().isEmpty()) continue;
                sonaKlassid.put(klassiNimi, sonaKlass);
            }
        }
        return sonaKlassid;
    }

    private SonaMall parsiDokumendiElemendistSonaMall(Element elem) {
        SonaMalliSemOsa sonaMall = null;
        String tyyp = MustridXMLFailist.getElementsAttributeByName(elem, TAG_ELEMENT_TYYP);
        if (tyyp != null) {
            String vaartus;
            if (tyyp.compareTo(TAG_ELEMENT_TYYP_ALGVORM) == 0 && (vaartus = MustridXMLFailist.getElementsAttributeByName(elem, TAG_ELEMENT_VAARTUS)) != null) {
                sonaMall = new AlgVormSonaMall(vaartus);
            }
            if (tyyp.compareTo(TAG_ELEMENT_TYYP_ARVSONA) == 0 || tyyp.compareTo(TAG_ELEMENT_TYYP_ERI_ARV) == 0) {
                String arvuTyyp;
                sonaMall = new ArvuEriKujudSonaMall();
                String numPiirang = MustridXMLFailist.getElementsAttributeByName(elem, TAG_ELEMENT_NUMPIIRANG);
                if (numPiirang != null) {
                    String[] range = numPiirang.split("-");
                    int lowerBound = -1;
                    int upperBound = -1;
                    if (range.length == 2) {
                        try {
                            lowerBound = Integer.parseInt(range[0]);
                            upperBound = Integer.parseInt(range[1]);
                        }
                        catch (NumberFormatException e) {}
                    } else if (numPiirang.startsWith("-")) {
                        try {
                            upperBound = Integer.parseInt(range[0]);
                        }
                        catch (NumberFormatException e) {}
                    } else {
                        try {
                            lowerBound = Integer.parseInt(range[0]);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    ((ArvuEriKujudSonaMall)sonaMall).setArvuVaartusePiirid(lowerBound, upperBound);
                }
                if ((arvuTyyp = MustridXMLFailist.getElementsAttributeByName(elem, TAG_ELEMENT_ARVULIIK)) != null) {
                    ((ArvuEriKujudSonaMall)sonaMall).setArvuTyyp(arvuTyyp);
                }
            }
            if (tyyp.compareTo(TAG_ELEMENT_TYYP_REGEXP) == 0 && (vaartus = MustridXMLFailist.getElementsAttributeByName(elem, TAG_ELEMENT_VAARTUS)) != null) {
                sonaMall = new RegExpSonaMall(vaartus);
            }
            if (tyyp.compareTo(TAG_ELEMENT_TYYP_TEKST) == 0 && (vaartus = MustridXMLFailist.getElementsAttributeByName(elem, TAG_ELEMENT_VAARTUS)) != null) {
                sonaMall = new TavaTekstSonaMall(vaartus);
            }
            if (sonaMall != null) {
                this.lisaSonaMallileSemOsa((SonaMall)((Object)sonaMall), elem);
            }
        }
        return sonaMall;
    }

    private void lisaSonaMallileSemOsa(SonaMall sonaMall, Element elem) {
        String direction;
        String semEbatapne;
        String semLabel;
        String semValue;
        String op;
        String semField = MustridXMLFailist.getElementsAttributeByName(elem, TAG_SEMFIELD);
        if (semField != null) {
            sonaMall.lisaSemField(semField);
        }
        if ((op = MustridXMLFailist.getElementsAttributeByName(elem, TAG_OP)) != null) {
            sonaMall.lisaOp(op);
        }
        if ((semValue = MustridXMLFailist.getElementsAttributeByName(elem, TAG_SEMVALUE)) != null) {
            sonaMall.lisaSemValue(semValue);
        }
        if ((semLabel = MustridXMLFailist.getElementsAttributeByName(elem, TAG_SEMLABEL)) != null) {
            sonaMall.lisaSemLabel(semLabel);
        }
        if ((semEbatapne = MustridXMLFailist.getElementsAttributeByName(elem, TAG_SEMVAL_EBATAPNE)) != null && semEbatapne.equals("1")) {
            sonaMall.setSemValueOnEbatapne(true);
        }
        if ((direction = MustridXMLFailist.getElementsAttributeByName(elem, TAG_DIRECTION)) != null) {
            sonaMall.setSeekDirection(direction);
        }
    }

    private SemantikaDefinitsioon looUusSemDefElemendiPohjal(Element elem) {
        String attrib;
        String explicitPoint;
        String mudel;
        String direction;
        String semEbatapne;
        String semLabel;
        String semValue;
        String semField;
        String op;
        String seotudKontekst;
        SemantikaDefinitsioon semDef = new SemantikaDefinitsioon();
        String seotudMustriOsa = MustridXMLFailist.getElementsAttributeByName(elem, TAG_SEOTUD_MUSTRIOSA);
        if (seotudMustriOsa != null) {
            semDef.setSeotudMustriOsa(seotudMustriOsa);
        }
        if ((seotudKontekst = MustridXMLFailist.getElementsAttributeByName(elem, TAG_SEOTUD_KONTEKST)) != null) {
            semDef.setSeotudKontekst(seotudKontekst);
        } else {
            semDef.setSeotudKontekst("");
        }
        String priority = MustridXMLFailist.getElementsAttributeByName(elem, TAG_PRIORITEET);
        if (priority != null) {
            semDef.setPriority(priority);
        }
        if ((op = MustridXMLFailist.getElementsAttributeByName(elem, TAG_OP)) != null) {
            semDef.setOp(op);
        }
        if ((semField = MustridXMLFailist.getElementsAttributeByName(elem, TAG_SEMFIELD)) != null) {
            if (Granulaarsus.getGranulaarsus(semField) != null) {
                semDef.setGranulaarsus(Granulaarsus.getGranulaarsus(semField));
            }
            if (op != null && (op.equals(SemantikaDefinitsioon.OP.ANCHOR_TIMEX.toString()) || op.equals(SemantikaDefinitsioon.OP.ANCHOR_TIMEX_IN_SENTENCE.toString()) || op.equals(SemantikaDefinitsioon.OP.FIND_NTH_SUBGRAN.toString()))) {
                semDef.setGranulaarsusStr(semField);
            }
        }
        if ((semValue = MustridXMLFailist.getElementsAttributeByName(elem, TAG_SEMVALUE)) != null) {
            semDef.setSemValue(semValue);
        }
        if ((semLabel = MustridXMLFailist.getElementsAttributeByName(elem, TAG_SEMLABEL)) != null) {
            semDef.setSemLabel(semLabel);
        }
        if ((semEbatapne = MustridXMLFailist.getElementsAttributeByName(elem, TAG_SEMVAL_EBATAPNE)) != null && semEbatapne.equals("1")) {
            semDef.setSemValueOnEbatapne(true);
        }
        if ((direction = MustridXMLFailist.getElementsAttributeByName(elem, TAG_DIRECTION)) != null) {
            semDef.setDirection(direction);
        }
        if ((mudel = MustridXMLFailist.getElementsAttributeByName(elem, TAG_MUDEL)) != null) {
            semDef.setMudel(mudel);
        }
        if ((explicitPoint = MustridXMLFailist.getElementsAttributeByName(elem, TAG_EXPLICIT_POINT)) != null) {
            semDef.setIsExplicitPoint(explicitPoint);
        }
        if ((attrib = MustridXMLFailist.getElementsAttributeByName(elem, TAG_ATTRIB)) != null) {
            semDef.setAttribute(attrib);
        }
        return semDef;
    }

    private MustriTahis looUusMustriTahisDefElemendiPohjal(Element elem) {
        String poleEraldiseisevAjavaljend;
        String mustriTahisedSonena;
        MustriTahis mustriTahis = new MustriTahis();
        String seotudMustriOsa = MustridXMLFailist.getElementsAttributeByName(elem, TAG_SEOTUD_MUSTRIOSA);
        if (seotudMustriOsa != null) {
            mustriTahis.setSeotudMustriOsa(seotudMustriOsa);
        }
        if ((mustriTahisedSonena = MustridXMLFailist.getElementsAttributeByName(elem, TAG_MUSTRITAHISED)) != null) {
            mustriTahis.setMustriTahised(mustriTahisedSonena);
        }
        if ((poleEraldiseisevAjavaljend = MustridXMLFailist.getElementsAttributeByName(elem, TAG_MUSTRITAHIS_PESA)) != null) {
            mustriTahis.setAjavPoleEraldiSeisev(poleEraldiseisevAjavaljend.matches("(1|true)"));
        }
        return mustriTahis;
    }

    private NegatiivneMuster looUusNegMusterElemendiPohjal(Element elem) {
        NegatiivneMuster negMuster = null;
        String muster = elem.getTextContent();
        if (muster != null) {
            String preservePunct;
            negMuster = new NegatiivneMuster();
            negMuster.setMusterSonena(muster);
            String startPos = MustridXMLFailist.getElementsAttributeByName(elem, TAG_NEGMUSTER_STARTPOS);
            if (startPos != null) {
                try {
                    int startingPos = Integer.parseInt(startPos);
                    negMuster.setAlgusPositsioon(startingPos);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((preservePunct = MustridXMLFailist.getElementsAttributeByName(elem, TAG_NEGMUSTER_PRESPUNCT)) != null && preservePunct.matches("(?i)true")) {
                negMuster.setSailitaYmbritsevadMargid(true);
            }
        }
        return negMuster;
    }

    private FraasiMuster parsiFraasiMuster(String muster, int mustriID) {
        ArrayList<SonaMall> mallid = new ArrayList<SonaMall>();
        ArrayList<Boolean> valikulisused = new ArrayList<Boolean>();
        ArrayList<Boolean> areJaetavad = new ArrayList<Boolean>();
        StringTokenizer tokenizer = new StringTokenizer(muster);
        int valikulisi = 0;
        int araJaetavaid = 0;
        while (tokenizer.hasMoreTokens()) {
            String key;
            String element = tokenizer.nextToken();
            SonaMall sonaMall = null;
            Matcher regMatcher = this.musterRegexp.matcher(element);
            Matcher algMatcher = this.musterAlgvorm.matcher(element);
            Matcher klaMatcher = this.musterSonaKlass.matcher(element);
            if (regMatcher.matches()) {
                sonaMall = new RegExpSonaMall(regMatcher.group(1));
            } else if (algMatcher.matches()) {
                sonaMall = new AlgVormSonaMall(algMatcher.group(1));
            } else if (klaMatcher.matches() && this.sonaKlassid.containsKey(key = klaMatcher.group(1))) {
                sonaMall = this.sonaKlassid.get(key);
            }
            if (sonaMall == null) continue;
            if (this.musterValikuline.matcher(element).matches()) {
                valikulisused.add(new Boolean(true));
                ++valikulisi;
            } else {
                valikulisused.add(new Boolean(false));
            }
            if (this.musterArajaetav.matcher(element).matches()) {
                areJaetavad.add(new Boolean(true));
                ++araJaetavaid;
            } else {
                areJaetavad.add(new Boolean(false));
            }
            mallid.add(sonaMall);
        }
        if (mallid.size() == 0) {
            return null;
        }
        if (valikulisi == mallid.size() || araJaetavaid == mallid.size()) {
            return null;
        }
        return new FraasiMusterFSM(mallid, valikulisused, areJaetavad, "m" + String.valueOf(mustriID));
    }

    private FraasiMustriFilter parsiFraasiMustriFilter(Element fraasiMustriFilterElem) {
        NodeList mustriTahisNodes;
        int j;
        String seotudMustriOsa = MustridXMLFailist.getElementsAttributeByName(fraasiMustriFilterElem, TAG_SEOTUD_MUSTRIOSA);
        String morfTunnused = MustridXMLFailist.getElementsAttributeByName(fraasiMustriFilterElem, TAG_MORF_TUNNUSED);
        FraasiMustriFilter filter = new FraasiMustriFilter(morfTunnused, seotudMustriOsa);
        NodeList semDefNodes = fraasiMustriFilterElem.getElementsByTagName(TAG_SEMDEF);
        if (semDefNodes != null && semDefNodes.getLength() > 0) {
            LinkedList<SemantikaDefinitsioon> semDefinitsioonid = new LinkedList<SemantikaDefinitsioon>();
            for (j = 0; j < semDefNodes.getLength(); ++j) {
                Element semDefElem = (Element)semDefNodes.item(j);
                SemantikaDefinitsioon semDef = this.looUusSemDefElemendiPohjal(semDefElem);
                if (semDef == null) continue;
                semDefinitsioonid.add(semDef);
            }
            if (!semDefinitsioonid.isEmpty()) {
                filter.setSemDefinitsioonid(semDefinitsioonid);
            } else {
                return null;
            }
        }
        if ((mustriTahisNodes = fraasiMustriFilterElem.getElementsByTagName(TAG_MUSTRITAHIS)) != null && mustriTahisNodes.getLength() > 0) {
            for (j = 0; j < mustriTahisNodes.getLength(); ++j) {
                Element mustriTahisElem = (Element)mustriTahisNodes.item(j);
                MustriTahis tahis = this.looUusMustriTahisDefElemendiPohjal(mustriTahisElem);
                if (tahis == null) continue;
                filter.addMustriTahis(tahis);
            }
        }
        return filter;
    }

    private List<LiitumisReegel> parsiDokumendistLiitumisReeglid() {
        ArrayList<LiitumisReegel> reeglid = new ArrayList<LiitumisReegel>();
        Element juur = this.dom.getDocumentElement();
        NodeList reegelNodes = juur.getElementsByTagName(TAG_LIITUMISREEGEL);
        if (reegelNodes != null && reegelNodes.getLength() > 0) {
            for (int i = 0; i < reegelNodes.getLength(); ++i) {
                String peavadOlemaTapseltKorvuti;
                String fraasiJarjekordFikseeritud;
                StringTokenizer tokenizer;
                Element reegelElem = (Element)reegelNodes.item(i);
                String muster = reegelElem.getTextContent();
                if (muster == null || (tokenizer = new StringTokenizer(muster)).countTokens() <= 0) continue;
                LiitumisReegel liitumisReegel = new LiitumisReegel();
                String[] alamOsad = new String[tokenizer.countTokens()];
                int j = 0;
                while (tokenizer.hasMoreElements()) {
                    String mustriOsa = (String)tokenizer.nextElement();
                    alamOsad[j++] = mustriOsa;
                }
                liitumisReegel.setMustriTahised(alamOsad);
                String reegliAste = MustridXMLFailist.getElementsAttributeByName(reegelElem, TAG_LIITUMISREEGEL_ASTE);
                if (reegliAste != null) {
                    if (reegliAste.equals("FRAAS")) {
                        liitumisReegel.setYhendamiseAste(AjavaljendiKandidaat.ASTE.YHENDATUD_FRAASINA);
                    }
                    if (reegliAste.equals("VAHEMIK")) {
                        liitumisReegel.setYhendamiseAste(AjavaljendiKandidaat.ASTE.YHENDATUD_VAHEMIKUNA);
                    }
                }
                if ((fraasiJarjekordFikseeritud = MustridXMLFailist.getElementsAttributeByName(reegelElem, TAG_LIITUMISREEGEL_FJRK)) != null) {
                    liitumisReegel.setFikseeritudJarjekord(fraasiJarjekordFikseeritud.matches("(1|true)"));
                }
                if ((peavadOlemaTapseltKorvuti = MustridXMLFailist.getElementsAttributeByName(reegelElem, TAG_LIITUMISREEGEL_K6RVUTI)) != null) {
                    liitumisReegel.setTapseltKorvuti(peavadOlemaTapseltKorvuti.matches("(1|true)"));
                }
                reeglid.add(liitumisReegel);
            }
        }
        return reeglid;
    }

    private static Element getElementByTagName(Element parentElement, String tagName) {
        NodeList nl = parentElement.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }

    private static String getElementsAttributeByName(Element element, String attribName) {
        String attrib = element.getAttribute(attribName);
        if (attrib != null && attrib.length() > 0) {
            return attrib;
        }
        return null;
    }
}

