# -*- coding: utf-8 -*-
# #START_LICENSE###########################################################
#
#
# This file is part of the Environment for Tree Exploration program
# (ETE).  http://ete.cgenomics.org
#  
# ETE is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#  
# ETE is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
# License for more details.
#  
# You should have received a copy of the GNU General Public License
# along with ETE.  If not, see <http://www.gnu.org/licenses/>.
#
# 
#                     ABOUT THE ETE PACKAGE
#                     =====================
# 
# ETE is distributed under the GPL copyleft license (2008-2011).  
#
# If you make use of ETE in published work, please cite:
#
# Jaime Huerta-Cepas, Joaquin Dopazo and Toni Gabaldon.
# ETE: a python Environment for Tree Exploration. Jaime BMC
# Bioinformatics 2010,:24doi:10.1186/1471-2105-11-24
#
# Note that extra references to the specific methods implemented in 
# the toolkit are available in the documentation. 
# 
# More info at http://ete.cgenomics.org
#
# 
# #END_LICENSE#############################################################
__VERSION__="ete2-2.1rev489" 
#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Mon Jun 27 10:13:44 2011 by generateDS.py version 2.5b.
#

import sys
import getopt
import re as re_

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError("Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
STRING_CLEANUP_PAT = re_.compile(r"[\n\r\s]+")

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    # First try with no namespace.
    value = attrs.get(attr_name)
    if value is None:
        # Now try the other possible namespaces.
        namespaces = node.nsmap.itervalues()
        for namespace in namespaces:
            value = attrs.get('{%s}%s' % (namespace, attr_name, ))
            if value is not None:
                break
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class Base(GeneratedsSuper):
    """The base type for all complexType definitions in the nexml schema.
    This type allows a number of special attributes: xml:lang - for
    languages codes xml:base - see http://www.w3.org/TR/xmlbase/
    xml:id - see http://www.w3.org/TR/xml-id/ xml:space - for
    whitespace handling xlink:href - for links Also see
    http://www.w3.org/2001/xml.xsd for more information on the xml
    and xlink attributes."""
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if Base.subclass:
            return Base.subclass(*args_, **kwargs_)
        else:
            return Base(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def export(self, outfile, level, namespace_='', name_='Base', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Base')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Base'):
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.append(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                if name not in already_processed:
                    already_processed.append(name)
                    outfile.write(' %s=%s' % (name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='Base', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Base'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s = "%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class Base


class Meta(Base):
    subclass = None
    superclass = Base
    def __init__(self, valueOf_=None):
        super(Meta, self).__init__()
        pass
    def factory(*args_, **kwargs_):
        if Meta.subclass:
            return Meta.subclass(*args_, **kwargs_)
        else:
            return Meta(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='Meta', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Meta')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="Meta"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Meta'):
        super(Meta, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Meta')
    def exportChildren(self, outfile, level, namespace_='', name_='Meta', fromsubclass_=False):
        super(Meta, self).exportChildren(outfile, level, namespace_, name_, True)
        pass
    def hasContent_(self):
        if (
            super(Meta, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Meta'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Meta, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Meta, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Meta, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Meta, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Meta


class ResourceMeta(Meta):
    """Metadata annotations in which the object is a resource. If this
    element contains meta elements as children, then the object of
    this annotation is a "blank node"."""
    subclass = None
    superclass = Meta
    def __init__(self, href=None, rel=None, meta=None, valueOf_=None):
        super(ResourceMeta, self).__init__()
        self.href = _cast(None, href)
        self.rel = _cast(None, rel)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if ResourceMeta.subclass:
            return ResourceMeta.subclass(*args_, **kwargs_)
        else:
            return ResourceMeta(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_rel(self): return self.rel
    def set_rel(self, rel): self.rel = rel
    def export(self, outfile, level, namespace_='', name_='ResourceMeta', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceMeta')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="ResourceMeta"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ResourceMeta'):
        super(ResourceMeta, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ResourceMeta')
        if self.href is not None and 'href' not in already_processed:
            already_processed.append('href')
            outfile.write(' href=%s' % (quote_attrib(self.href), ))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            outfile.write(' rel=%s' % (quote_attrib(self.rel), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ResourceMeta', fromsubclass_=False):
        super(ResourceMeta, self).exportChildren(outfile, level, namespace_, name_, True)
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(ResourceMeta, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ResourceMeta'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.href is not None and 'href' not in already_processed:
            already_processed.append('href')
            showIndent(outfile, level)
            outfile.write('href = %s,\n' % (self.href,))
        if self.rel is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            showIndent(outfile, level)
            outfile.write('rel = %s,\n' % (self.rel,))
        super(ResourceMeta, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ResourceMeta, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.append('href')
            self.href = value
        value = find_attr_value_('rel', node)
        if value is not None and 'rel' not in already_processed:
            already_processed.append('rel')
            self.rel = value
        super(ResourceMeta, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        super(ResourceMeta, self).buildChildren(child_, node, nodeName_, True)
# end class ResourceMeta


class LiteralMeta(Meta):
    """Metadata annotations in which the object is a literal value. If the
    @content attribute is used, then the element should contain no
    children."""
    subclass = None
    superclass = Meta
    def __init__(self, datatype=None, content=None, property=None, valueOf_=None):
        super(LiteralMeta, self).__init__()
        self.datatype = _cast(None, datatype)
        self.content = _cast(None, content)
        self.property = _cast(None, property)
        pass
    def factory(*args_, **kwargs_):
        if LiteralMeta.subclass:
            return LiteralMeta.subclass(*args_, **kwargs_)
        else:
            return LiteralMeta(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_content(self): return self.content
    def set_content(self, content): self.content = content
    def get_property(self): return self.property
    def set_property(self, property): self.property = property
    def export(self, outfile, level, namespace_='', name_='LiteralMeta', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LiteralMeta')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="LiteralMeta"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LiteralMeta'):
        super(LiteralMeta, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LiteralMeta')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
        if self.content is not None and 'content' not in already_processed:
            already_processed.append('content')
            outfile.write(' content=%s' % (self.gds_format_string(quote_attrib(self.content).encode(ExternalEncoding), input_name='content'), ))
        if self.property is not None and 'property' not in already_processed:
            already_processed.append('property')
            outfile.write(' property=%s' % (quote_attrib(self.property), ))
    def exportChildren(self, outfile, level, namespace_='', name_='LiteralMeta', fromsubclass_=False):
        super(LiteralMeta, self).exportChildren(outfile, level, namespace_, name_, True)
        pass
    def hasContent_(self):
        if (
            super(LiteralMeta, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='LiteralMeta'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        if self.content is not None and 'content' not in already_processed:
            already_processed.append('content')
            showIndent(outfile, level)
            outfile.write('content = "%s",\n' % (self.content,))
        if self.property is not None and 'property' not in already_processed:
            already_processed.append('property')
            showIndent(outfile, level)
            outfile.write('property = %s,\n' % (self.property,))
        super(LiteralMeta, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(LiteralMeta, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.append('datatype')
            self.datatype = value
        value = find_attr_value_('content', node)
        if value is not None and 'content' not in already_processed:
            already_processed.append('content')
            self.content = value
        value = find_attr_value_('property', node)
        if value is not None and 'property' not in already_processed:
            already_processed.append('property')
            self.property = value
        super(LiteralMeta, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(LiteralMeta, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class LiteralMeta


class attrExtensions(GeneratedsSuper):
    """This element is for use in WSDL 1.1 only. It does not apply to WSDL
    2.0 documents. Use in WSDL 2.0 documents is invalid."""
    subclass = None
    superclass = None
    def __init__(self, valueOf_=None):
        self.anyAttributes_ = {}
    def factory(*args_, **kwargs_):
        if attrExtensions.subclass:
            return attrExtensions.subclass(*args_, **kwargs_)
        else:
            return attrExtensions(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_anyAttributes_(self): return self.anyAttributes_
    def set_anyAttributes_(self, anyAttributes_): self.anyAttributes_ = anyAttributes_
    def export(self, outfile, level, namespace_='', name_='attrExtensions', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='attrExtensions')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='attrExtensions'):
        for name, value in self.anyAttributes_.items():
            xsinamespaceprefix = 'xsi'
            xsinamespace1 = 'http://www.w3.org/2001/XMLSchema-instance'
            xsinamespace2 = '{%s}' % (xsinamespace1, )
            if name.startswith(xsinamespace2):
                name1 = name[len(xsinamespace2):]
                name2 = '%s:%s' % (xsinamespaceprefix, name1, )
                if name2 not in already_processed:
                    already_processed.append(name2)
                    outfile.write(' %s=%s' % (name2, quote_attrib(value), ))
            else:
                if name not in already_processed:
                    already_processed.append(name)
                    outfile.write(' %s=%s' % (name, quote_attrib(value), ))
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='attrExtensions', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='attrExtensions'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        for name, value in self.anyAttributes_.items():
            showIndent(outfile, level)
            outfile.write('%s = "%s",\n' % (name, value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        self.anyAttributes_ = {}
        for name, value in attrs.items():
            if name not in already_processed:
                self.anyAttributes_[name] = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class attrExtensions


class AbstractMapping(Base):
    """The AbstractMapping type is the superclass for an ambiguity mapping.
    In an instance document, a subclass of this type will look like
    <member state="st1"/>, i.e. an element called "member" with an
    attribute called "state" whose value is an id reference that
    refers to an element that subclasses AbstractState. The purpose
    of AbstractMapping is to specify which other states may be
    implied, e.g. a nucleotide symbol "N" would have mappings to
    "A", "C", "G" and "T"."""
    subclass = None
    superclass = Base
    def __init__(self, state=None, valueOf_=None):
        super(AbstractMapping, self).__init__()
        self.state = _cast(None, state)
        pass
    def factory(*args_, **kwargs_):
        if AbstractMapping.subclass:
            return AbstractMapping.subclass(*args_, **kwargs_)
        else:
            return AbstractMapping(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def export(self, outfile, level, namespace_='', name_='AbstractMapping', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractMapping')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractMapping"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractMapping'):
        super(AbstractMapping, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractMapping')
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            outfile.write(' state=%s' % (self.gds_format_string(quote_attrib(self.state).encode(ExternalEncoding), input_name='state'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractMapping', fromsubclass_=False):
        super(AbstractMapping, self).exportChildren(outfile, level, namespace_, name_, True)
        pass
    def hasContent_(self):
        if (
            super(AbstractMapping, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractMapping'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            showIndent(outfile, level)
            outfile.write('state = "%s",\n' % (self.state,))
        super(AbstractMapping, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractMapping, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.append('state')
            self.state = value
        super(AbstractMapping, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AbstractMapping, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AbstractMapping


class DNAMapping(AbstractMapping):
    """An IUPAC ambiguity mapping."""
    subclass = None
    superclass = AbstractMapping
    def __init__(self, state=None, valueOf_=None):
        super(DNAMapping, self).__init__(state, )
        pass
    def factory(*args_, **kwargs_):
        if DNAMapping.subclass:
            return DNAMapping.subclass(*args_, **kwargs_)
        else:
            return DNAMapping(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='DNAMapping', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNAMapping')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNAMapping'):
        super(DNAMapping, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DNAMapping')
    def exportChildren(self, outfile, level, namespace_='', name_='DNAMapping', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            super(DNAMapping, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DNAMapping'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DNAMapping, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DNAMapping, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DNAMapping, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DNAMapping


class AAMapping(AbstractMapping):
    """An IUPAC ambiguity mapping."""
    subclass = None
    superclass = AbstractMapping
    def __init__(self, state=None, valueOf_=None):
        super(AAMapping, self).__init__(state, )
        pass
    def factory(*args_, **kwargs_):
        if AAMapping.subclass:
            return AAMapping.subclass(*args_, **kwargs_)
        else:
            return AAMapping(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='AAMapping', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AAMapping')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AAMapping'):
        super(AAMapping, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AAMapping')
    def exportChildren(self, outfile, level, namespace_='', name_='AAMapping', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            super(AAMapping, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AAMapping'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AAMapping, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AAMapping, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AAMapping, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class AAMapping


class RNAMapping(AbstractMapping):
    """An IUPAC RNA ambiguity mapping."""
    subclass = None
    superclass = AbstractMapping
    def __init__(self, state=None, valueOf_=None):
        super(RNAMapping, self).__init__(state, )
        pass
    def factory(*args_, **kwargs_):
        if RNAMapping.subclass:
            return RNAMapping.subclass(*args_, **kwargs_)
        else:
            return RNAMapping(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='RNAMapping', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RNAMapping')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RNAMapping'):
        super(RNAMapping, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RNAMapping')
    def exportChildren(self, outfile, level, namespace_='', name_='RNAMapping', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            super(RNAMapping, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RNAMapping'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RNAMapping, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RNAMapping, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RNAMapping, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class RNAMapping


class StandardMapping(AbstractMapping):
    """A standard character ambiguity mapping."""
    subclass = None
    superclass = AbstractMapping
    def __init__(self, state=None, valueOf_=None):
        super(StandardMapping, self).__init__(state, )
        pass
    def factory(*args_, **kwargs_):
        if StandardMapping.subclass:
            return StandardMapping.subclass(*args_, **kwargs_)
        else:
            return StandardMapping(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='StandardMapping', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardMapping')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardMapping'):
        super(StandardMapping, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardMapping')
    def exportChildren(self, outfile, level, namespace_='', name_='StandardMapping', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            super(StandardMapping, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardMapping'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StandardMapping, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardMapping, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StandardMapping, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class StandardMapping


class Annotated(Base):
    """The Annotated complexType is a super class for objects that
    optionally have metadata annotations of type Meta."""
    subclass = None
    superclass = Base
    def __init__(self, about=None, meta=None, valueOf_=None):
        super(Annotated, self).__init__()
        self.about = _cast(None, about)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if Annotated.subclass:
            return Annotated.subclass(*args_, **kwargs_)
        else:
            return Annotated(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_about(self): return self.about
    def set_about(self, about): self.about = about
    def export(self, outfile, level, namespace_='', name_='Annotated', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Annotated')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="Annotated"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Annotated'):
        super(Annotated, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Annotated')
        if self.about is not None and 'about' not in already_processed:
            already_processed.append('about')
            outfile.write(' about=%s' % (quote_attrib(self.about), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Annotated', fromsubclass_=False):
        super(Annotated, self).exportChildren(outfile, level, namespace_, name_, True)
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(Annotated, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Annotated'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.about is not None and 'about' not in already_processed:
            already_processed.append('about')
            showIndent(outfile, level)
            outfile.write('about = %s,\n' % (self.about,))
        super(Annotated, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Annotated, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('about', node)
        if value is not None and 'about' not in already_processed:
            already_processed.append('about')
            self.about = value
        super(Annotated, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        super(Annotated, self).buildChildren(child_, node, nodeName_, True)
# end class Annotated


class Nexml(Annotated):
    """The root element for nexml."""
    subclass = None
    superclass = Annotated
    def __init__(self, about=None, meta=None, version=None, generator=None, otus=None, characters=None, trees=None, valueOf_=None):
        super(Nexml, self).__init__(about, meta, )
        self.version = _cast(None, version)
        self.generator = _cast(None, generator)
        if otus is None:
            self.otus = []
        else:
            self.otus = otus
        if characters is None:
            self.characters = []
        else:
            self.characters = characters
        if trees is None:
            self.trees = []
        else:
            self.trees = trees
    def factory(*args_, **kwargs_):
        if Nexml.subclass:
            return Nexml.subclass(*args_, **kwargs_)
        else:
            return Nexml(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_otus(self): return self.otus
    def set_otus(self, otus): self.otus = otus
    def add_otus(self, value): self.otus.append(value)
    def insert_otus(self, index, value): self.otus[index] = value
    def get_characters(self): return self.characters
    def set_characters(self, characters): self.characters = characters
    def add_characters(self, value): self.characters.append(value)
    def insert_characters(self, index, value): self.characters[index] = value
    def get_trees(self): return self.trees
    def set_trees(self, trees): self.trees = trees
    def add_trees(self, value): self.trees.append(value)
    def insert_trees(self, index, value): self.trees[index] = value
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def validate_Nexml1_0(self, value):
        # Validate type Nexml1_0, a restriction on xs:decimal.
        pass
    def get_generator(self): return self.generator
    def set_generator(self, generator): self.generator = generator
    def export(self, outfile, level, namespace_='', name_='Nexml', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Nexml')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="Nexml"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Nexml'):
        super(Nexml, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Nexml')
        if self.version is not None and 'version' not in already_processed:
            already_processed.append('version')
            outfile.write(' version=%s' % (quote_attrib(self.version), ))
        if self.generator is not None and 'generator' not in already_processed:
            already_processed.append('generator')
            outfile.write(' generator=%s' % (self.gds_format_string(quote_attrib(self.generator).encode(ExternalEncoding), input_name='generator'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Nexml', fromsubclass_=False):
        super(Nexml, self).exportChildren(outfile, level, namespace_, name_, True)
        for otus_ in self.otus:
            otus_.export(outfile, level, namespace_, name_='otus')
        for characters_ in self.get_characters():
            characters_.export(outfile, level, namespace_, name_='characters')
        for trees_ in self.trees:
            trees_.export(outfile, level, namespace_, name_='trees')
    def hasContent_(self):
        if (
            self.otus or
            self.characters or
            self.trees or
            super(Nexml, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Nexml'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.version is not None and 'version' not in already_processed:
            already_processed.append('version')
            showIndent(outfile, level)
            outfile.write('version = %f,\n' % (self.version,))
        if self.generator is not None and 'generator' not in already_processed:
            already_processed.append('generator')
            showIndent(outfile, level)
            outfile.write('generator = "%s",\n' % (self.generator,))
        super(Nexml, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Nexml, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('otus=[\n')
        level += 1
        for otus_ in self.otus:
            showIndent(outfile, level)
            outfile.write('model_.Taxa(\n')
            otus_.exportLiteral(outfile, level, name_='Taxa')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('characters=[\n')
        level += 1
        for characters_ in self.characters:
            showIndent(outfile, level)
            outfile.write('model_.AbstractBlock(\n')
            characters_.exportLiteral(outfile, level, name_='AbstractBlock')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('trees=[\n')
        level += 1
        for trees_ in self.trees:
            showIndent(outfile, level)
            outfile.write('model_.Trees(\n')
            trees_.exportLiteral(outfile, level, name_='Trees')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.append('version')
            try:
                self.version = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (version): %s' % exp)
            self.validate_Nexml1_0(self.version)    # validate type Nexml1_0
        value = find_attr_value_('generator', node)
        if value is not None and 'generator' not in already_processed:
            already_processed.append('generator')
            self.generator = value
        super(Nexml, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'otus':
            obj_ = Taxa.factory()
            obj_.build(child_)
            self.otus.append(obj_)
        elif nodeName_ == 'characters':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <characters> element')
            self.characters.append(obj_)
        elif nodeName_ == 'trees':
            obj_ = Trees.factory()
            obj_.build(child_)
            self.trees.append(obj_)
        super(Nexml, self).buildChildren(child_, node, nodeName_, True)
# end class Nexml


class AbstractObsMatrix(Annotated):
    """The AbstractObsMatrix super class is the abstract type for a
    <matrix> element that contains rows which hold granular state
    observations."""
    subclass = None
    superclass = Annotated
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(AbstractObsMatrix, self).__init__(about, meta, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AbstractObsMatrix.subclass:
            return AbstractObsMatrix.subclass(*args_, **kwargs_)
        else:
            return AbstractObsMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AbstractObsMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractObsMatrix')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractObsMatrix"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractObsMatrix'):
        super(AbstractObsMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractObsMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractObsMatrix', fromsubclass_=False):
        super(AbstractObsMatrix, self).exportChildren(outfile, level, namespace_, name_, True)
        for row_ in self.get_row():
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(AbstractObsMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractObsMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractObsMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractObsMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.AbstractObsRow(\n')
            row_.exportLiteral(outfile, level, name_='AbstractObsRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractObsMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <row> element')
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
        super(AbstractObsMatrix, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractObsMatrix


class AbstractSeqMatrix(Annotated):
    """The AbstractSeqMatrix super class is the abstract type for a
    <matrix> element that contains rows which hold raw character
    sequences."""
    subclass = None
    superclass = Annotated
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(AbstractSeqMatrix, self).__init__(about, meta, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AbstractSeqMatrix.subclass:
            return AbstractSeqMatrix.subclass(*args_, **kwargs_)
        else:
            return AbstractSeqMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AbstractSeqMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractSeqMatrix')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractSeqMatrix"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractSeqMatrix'):
        super(AbstractSeqMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractSeqMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractSeqMatrix', fromsubclass_=False):
        super(AbstractSeqMatrix, self).exportChildren(outfile, level, namespace_, name_, True)
        for row_ in self.get_row():
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(AbstractSeqMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractSeqMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractSeqMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractSeqMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.AbstractSeqRow(\n')
            row_.exportLiteral(outfile, level, name_='AbstractSeqRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractSeqMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <row> element')
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
        super(AbstractSeqMatrix, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractSeqMatrix


class AbstractFormat(Annotated):
    """The AbstractFormat type is the superclass for the element that
    defines the allowed characters and states in a matrix, and their
    ambiguity mapping. It may enclose AbstractStates elements that
    define states and their mappings, and AbstractChar elements that
    specify which AbstractStates apply to which matrix columns."""
    subclass = None
    superclass = Annotated
    def __init__(self, about=None, meta=None, states=None, char=None, set=None, valueOf_=None):
        super(AbstractFormat, self).__init__(about, meta, )
        if states is None:
            self.states = []
        else:
            self.states = states
        if char is None:
            self.char = []
        else:
            self.char = char
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AbstractFormat.subclass:
            return AbstractFormat.subclass(*args_, **kwargs_)
        else:
            return AbstractFormat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def add_states(self, value): self.states.append(value)
    def insert_states(self, index, value): self.states[index] = value
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def add_char(self, value): self.char.append(value)
    def insert_char(self, index, value): self.char[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AbstractFormat', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractFormat')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractFormat"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractFormat'):
        super(AbstractFormat, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractFormat')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractFormat', fromsubclass_=False):
        super(AbstractFormat, self).exportChildren(outfile, level, namespace_, name_, True)
        for states_ in self.get_states():
            states_.export(outfile, level, namespace_, name_='states')
        for char_ in self.get_char():
            char_.export(outfile, level, namespace_, name_='char')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.states or
            self.char or
            self.set or
            super(AbstractFormat, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractFormat'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractFormat, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractFormat, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('states=[\n')
        level += 1
        for states_ in self.states:
            showIndent(outfile, level)
            outfile.write('model_.AbstractStates(\n')
            states_.exportLiteral(outfile, level, name_='AbstractStates')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('char=[\n')
        level += 1
        for char_ in self.char:
            showIndent(outfile, level)
            outfile.write('model_.AbstractChar(\n')
            char_.exportLiteral(outfile, level, name_='AbstractChar')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CharSet(\n')
            set_.exportLiteral(outfile, level, name_='CharSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractFormat, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'states':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <states> element')
            self.states.append(obj_)
        elif nodeName_ == 'char':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <char> element')
            self.char.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CharSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
        super(AbstractFormat, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractFormat


class ContinuousObsMatrix(AbstractObsMatrix):
    """A matrix of rows with single character observations."""
    subclass = None
    superclass = AbstractObsMatrix
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(ContinuousObsMatrix, self).__init__(about, meta, row, set, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if ContinuousObsMatrix.subclass:
            return ContinuousObsMatrix.subclass(*args_, **kwargs_)
        else:
            return ContinuousObsMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='ContinuousObsMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousObsMatrix')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContinuousObsMatrix'):
        super(ContinuousObsMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousObsMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='ContinuousObsMatrix', fromsubclass_=False):
        for row_ in self.row:
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(ContinuousObsMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ContinuousObsMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ContinuousObsMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ContinuousObsMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.ContinuousMatrixObsRow(\n')
            row_.exportLiteral(outfile, level, name_='ContinuousMatrixObsRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ContinuousObsMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            obj_ = ContinuousMatrixObsRow.factory()
            obj_.build(child_)
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class ContinuousObsMatrix


class ContinuousSeqMatrix(AbstractSeqMatrix):
    """A matrix of rows with seq strings of type continuous."""
    subclass = None
    superclass = AbstractSeqMatrix
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(ContinuousSeqMatrix, self).__init__(about, meta, row, set, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if ContinuousSeqMatrix.subclass:
            return ContinuousSeqMatrix.subclass(*args_, **kwargs_)
        else:
            return ContinuousSeqMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='ContinuousSeqMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousSeqMatrix')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContinuousSeqMatrix'):
        super(ContinuousSeqMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousSeqMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='ContinuousSeqMatrix', fromsubclass_=False):
        for row_ in self.row:
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(ContinuousSeqMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ContinuousSeqMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ContinuousSeqMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ContinuousSeqMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.ContinuousMatrixSeqRow(\n')
            row_.exportLiteral(outfile, level, name_='ContinuousMatrixSeqRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ContinuousSeqMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            obj_ = ContinuousMatrixSeqRow.factory()
            obj_.build(child_)
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class ContinuousSeqMatrix


class ContinuousFormat(AbstractFormat):
    """The ContinuousFormat class is the container of continuous column
    definitions."""
    subclass = None
    superclass = AbstractFormat
    def __init__(self, about=None, meta=None, states=None, char=None, set=None, valueOf_=None):
        super(ContinuousFormat, self).__init__(about, meta, states, char, set, )
        if char is None:
            self.char = []
        else:
            self.char = char
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if ContinuousFormat.subclass:
            return ContinuousFormat.subclass(*args_, **kwargs_)
        else:
            return ContinuousFormat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def add_char(self, value): self.char.append(value)
    def insert_char(self, index, value): self.char[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='ContinuousFormat', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousFormat')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContinuousFormat'):
        super(ContinuousFormat, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousFormat')
    def exportChildren(self, outfile, level, namespace_='', name_='ContinuousFormat', fromsubclass_=False):
        for char_ in self.char:
            char_.export(outfile, level, namespace_, name_='char')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.char or
            self.set or
            super(ContinuousFormat, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ContinuousFormat'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ContinuousFormat, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ContinuousFormat, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('char=[\n')
        level += 1
        for char_ in self.char:
            showIndent(outfile, level)
            outfile.write('model_.ContinuousChar(\n')
            char_.exportLiteral(outfile, level, name_='ContinuousChar')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CharSet(\n')
            set_.exportLiteral(outfile, level, name_='CharSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ContinuousFormat, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'char':
            obj_ = ContinuousChar.factory()
            obj_.build(child_)
            self.char.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CharSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class ContinuousFormat


class Labelled(Annotated):
    """The Labelled complexType is a super class for objects that
    optionally have label attributes to use as a (non-unique) name
    of type xs:string."""
    subclass = None
    superclass = Annotated
    def __init__(self, about=None, meta=None, label=None, valueOf_=None):
        super(Labelled, self).__init__(about, meta, )
        self.label = _cast(None, label)
        pass
    def factory(*args_, **kwargs_):
        if Labelled.subclass:
            return Labelled.subclass(*args_, **kwargs_)
        else:
            return Labelled(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_label(self): return self.label
    def set_label(self, label): self.label = label
    def export(self, outfile, level, namespace_='', name_='Labelled', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Labelled')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="Labelled"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Labelled'):
        super(Labelled, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Labelled')
        if self.label is not None and 'label' not in already_processed:
            already_processed.append('label')
            outfile.write(' label=%s' % (self.gds_format_string(quote_attrib(self.label).encode(ExternalEncoding), input_name='label'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='Labelled', fromsubclass_=False):
        super(Labelled, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(Labelled, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Labelled'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.label is not None and 'label' not in already_processed:
            already_processed.append('label')
            showIndent(outfile, level)
            outfile.write('label = "%s",\n' % (self.label,))
        super(Labelled, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Labelled, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('label', node)
        if value is not None and 'label' not in already_processed:
            already_processed.append('label')
            self.label = value
        super(Labelled, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Labelled, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Labelled


class StandardObsMatrix(AbstractObsMatrix):
    """A matrix of rows with single character observations."""
    subclass = None
    superclass = AbstractObsMatrix
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(StandardObsMatrix, self).__init__(about, meta, row, set, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if StandardObsMatrix.subclass:
            return StandardObsMatrix.subclass(*args_, **kwargs_)
        else:
            return StandardObsMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='StandardObsMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardObsMatrix')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardObsMatrix'):
        super(StandardObsMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardObsMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='StandardObsMatrix', fromsubclass_=False):
        for row_ in self.row:
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(StandardObsMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardObsMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StandardObsMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardObsMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.StandardMatrixObsRow(\n')
            row_.exportLiteral(outfile, level, name_='StandardMatrixObsRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StandardObsMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            obj_ = StandardMatrixObsRow.factory()
            obj_.build(child_)
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class StandardObsMatrix


class StandardSeqMatrix(AbstractSeqMatrix):
    """A matrix of rows with seq strings of type standard."""
    subclass = None
    superclass = AbstractSeqMatrix
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(StandardSeqMatrix, self).__init__(about, meta, row, set, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if StandardSeqMatrix.subclass:
            return StandardSeqMatrix.subclass(*args_, **kwargs_)
        else:
            return StandardSeqMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='StandardSeqMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardSeqMatrix')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardSeqMatrix'):
        super(StandardSeqMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardSeqMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='StandardSeqMatrix', fromsubclass_=False):
        for row_ in self.row:
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(StandardSeqMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardSeqMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StandardSeqMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardSeqMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.StandardMatrixSeqRow(\n')
            row_.exportLiteral(outfile, level, name_='StandardMatrixSeqRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StandardSeqMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            obj_ = StandardMatrixSeqRow.factory()
            obj_.build(child_)
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class StandardSeqMatrix


class StandardFormat(AbstractFormat):
    """The StandardFormat class is the container of standard column
    definitions."""
    subclass = None
    superclass = AbstractFormat
    def __init__(self, about=None, meta=None, states=None, char=None, set=None, valueOf_=None):
        super(StandardFormat, self).__init__(about, meta, states, char, set, )
        if states is None:
            self.states = []
        else:
            self.states = states
        if char is None:
            self.char = []
        else:
            self.char = char
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if StandardFormat.subclass:
            return StandardFormat.subclass(*args_, **kwargs_)
        else:
            return StandardFormat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def add_states(self, value): self.states.append(value)
    def insert_states(self, index, value): self.states[index] = value
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def add_char(self, value): self.char.append(value)
    def insert_char(self, index, value): self.char[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='StandardFormat', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardFormat')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardFormat'):
        super(StandardFormat, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardFormat')
    def exportChildren(self, outfile, level, namespace_='', name_='StandardFormat', fromsubclass_=False):
        for states_ in self.states:
            states_.export(outfile, level, namespace_, name_='states')
        for char_ in self.char:
            char_.export(outfile, level, namespace_, name_='char')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.states or
            self.char or
            self.set or
            super(StandardFormat, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardFormat'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StandardFormat, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardFormat, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('states=[\n')
        level += 1
        for states_ in self.states:
            showIndent(outfile, level)
            outfile.write('model_.StandardStates(\n')
            states_.exportLiteral(outfile, level, name_='StandardStates')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('char=[\n')
        level += 1
        for char_ in self.char:
            showIndent(outfile, level)
            outfile.write('model_.StandardChar(\n')
            char_.exportLiteral(outfile, level, name_='StandardChar')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CharSet(\n')
            set_.exportLiteral(outfile, level, name_='CharSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StandardFormat, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'states':
            obj_ = StandardStates.factory()
            obj_.build(child_)
            self.states.append(obj_)
        elif nodeName_ == 'char':
            obj_ = StandardChar.factory()
            obj_.build(child_)
            self.char.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CharSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class StandardFormat


class RNAObsMatrix(AbstractObsMatrix):
    """A matrix of rows with single character observations."""
    subclass = None
    superclass = AbstractObsMatrix
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(RNAObsMatrix, self).__init__(about, meta, row, set, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if RNAObsMatrix.subclass:
            return RNAObsMatrix.subclass(*args_, **kwargs_)
        else:
            return RNAObsMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='RNAObsMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RNAObsMatrix')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RNAObsMatrix'):
        super(RNAObsMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RNAObsMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='RNAObsMatrix', fromsubclass_=False):
        for row_ in self.row:
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(RNAObsMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RNAObsMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RNAObsMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RNAObsMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.RNAMatrixObsRow(\n')
            row_.exportLiteral(outfile, level, name_='RNAMatrixObsRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RNAObsMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            obj_ = RNAMatrixObsRow.factory()
            obj_.build(child_)
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class RNAObsMatrix


class RNASeqMatrix(AbstractSeqMatrix):
    """A matrix of rows with seq strings of type RNA."""
    subclass = None
    superclass = AbstractSeqMatrix
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(RNASeqMatrix, self).__init__(about, meta, row, set, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if RNASeqMatrix.subclass:
            return RNASeqMatrix.subclass(*args_, **kwargs_)
        else:
            return RNASeqMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='RNASeqMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RNASeqMatrix')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RNASeqMatrix'):
        super(RNASeqMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RNASeqMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='RNASeqMatrix', fromsubclass_=False):
        for row_ in self.row:
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(RNASeqMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RNASeqMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RNASeqMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RNASeqMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.RNAMatrixSeqRow(\n')
            row_.exportLiteral(outfile, level, name_='RNAMatrixSeqRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RNASeqMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            obj_ = RNAMatrixSeqRow.factory()
            obj_.build(child_)
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class RNASeqMatrix


class RNAFormat(AbstractFormat):
    """The RNAFormat class is the container of RNA column definitions."""
    subclass = None
    superclass = AbstractFormat
    def __init__(self, about=None, meta=None, states=None, char=None, set=None, valueOf_=None):
        super(RNAFormat, self).__init__(about, meta, states, char, set, )
        if states is None:
            self.states = []
        else:
            self.states = states
        if char is None:
            self.char = []
        else:
            self.char = char
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if RNAFormat.subclass:
            return RNAFormat.subclass(*args_, **kwargs_)
        else:
            return RNAFormat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def add_states(self, value): self.states.append(value)
    def insert_states(self, index, value): self.states[index] = value
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def add_char(self, value): self.char.append(value)
    def insert_char(self, index, value): self.char[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='RNAFormat', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RNAFormat')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RNAFormat'):
        super(RNAFormat, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RNAFormat')
    def exportChildren(self, outfile, level, namespace_='', name_='RNAFormat', fromsubclass_=False):
        for states_ in self.states:
            states_.export(outfile, level, namespace_, name_='states')
        for char_ in self.char:
            char_.export(outfile, level, namespace_, name_='char')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.states or
            self.char or
            self.set or
            super(RNAFormat, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RNAFormat'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RNAFormat, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RNAFormat, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('states=[\n')
        level += 1
        for states_ in self.states:
            showIndent(outfile, level)
            outfile.write('model_.RNAStates(\n')
            states_.exportLiteral(outfile, level, name_='RNAStates')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('char=[\n')
        level += 1
        for char_ in self.char:
            showIndent(outfile, level)
            outfile.write('model_.RNAChar(\n')
            char_.exportLiteral(outfile, level, name_='RNAChar')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CharSet(\n')
            set_.exportLiteral(outfile, level, name_='CharSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RNAFormat, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'states':
            obj_ = RNAStates.factory()
            obj_.build(child_)
            self.states.append(obj_)
        elif nodeName_ == 'char':
            obj_ = RNAChar.factory()
            obj_.build(child_)
            self.char.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CharSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class RNAFormat


class RestrictionObsMatrix(AbstractObsMatrix):
    """A matrix of rows with single character observations."""
    subclass = None
    superclass = AbstractObsMatrix
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(RestrictionObsMatrix, self).__init__(about, meta, row, set, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if RestrictionObsMatrix.subclass:
            return RestrictionObsMatrix.subclass(*args_, **kwargs_)
        else:
            return RestrictionObsMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='RestrictionObsMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionObsMatrix')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RestrictionObsMatrix'):
        super(RestrictionObsMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionObsMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='RestrictionObsMatrix', fromsubclass_=False):
        for row_ in self.row:
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(RestrictionObsMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RestrictionObsMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RestrictionObsMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RestrictionObsMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.RestrictionMatrixObsRow(\n')
            row_.exportLiteral(outfile, level, name_='RestrictionMatrixObsRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RestrictionObsMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            obj_ = RestrictionMatrixObsRow.factory()
            obj_.build(child_)
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class RestrictionObsMatrix


class RestrictionSeqMatrix(AbstractSeqMatrix):
    """A matrix of rows with seq strings of type restriction."""
    subclass = None
    superclass = AbstractSeqMatrix
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(RestrictionSeqMatrix, self).__init__(about, meta, row, set, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if RestrictionSeqMatrix.subclass:
            return RestrictionSeqMatrix.subclass(*args_, **kwargs_)
        else:
            return RestrictionSeqMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='RestrictionSeqMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionSeqMatrix')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RestrictionSeqMatrix'):
        super(RestrictionSeqMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionSeqMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='RestrictionSeqMatrix', fromsubclass_=False):
        for row_ in self.row:
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(RestrictionSeqMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RestrictionSeqMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RestrictionSeqMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RestrictionSeqMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.RestrictionMatrixSeqRow(\n')
            row_.exportLiteral(outfile, level, name_='RestrictionMatrixSeqRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RestrictionSeqMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            obj_ = RestrictionMatrixSeqRow.factory()
            obj_.build(child_)
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class RestrictionSeqMatrix


class RestrictionFormat(AbstractFormat):
    """The RestrictionFormat class is the container of restriction column
    definitions."""
    subclass = None
    superclass = AbstractFormat
    def __init__(self, about=None, meta=None, states=None, char=None, set=None, valueOf_=None):
        super(RestrictionFormat, self).__init__(about, meta, states, char, set, )
        if states is None:
            self.states = []
        else:
            self.states = states
        if char is None:
            self.char = []
        else:
            self.char = char
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if RestrictionFormat.subclass:
            return RestrictionFormat.subclass(*args_, **kwargs_)
        else:
            return RestrictionFormat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def add_states(self, value): self.states.append(value)
    def insert_states(self, index, value): self.states[index] = value
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def add_char(self, value): self.char.append(value)
    def insert_char(self, index, value): self.char[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='RestrictionFormat', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionFormat')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RestrictionFormat'):
        super(RestrictionFormat, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionFormat')
    def exportChildren(self, outfile, level, namespace_='', name_='RestrictionFormat', fromsubclass_=False):
        for states_ in self.states:
            states_.export(outfile, level, namespace_, name_='states')
        for char_ in self.char:
            char_.export(outfile, level, namespace_, name_='char')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.states or
            self.char or
            self.set or
            super(RestrictionFormat, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RestrictionFormat'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RestrictionFormat, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RestrictionFormat, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('states=[\n')
        level += 1
        for states_ in self.states:
            showIndent(outfile, level)
            outfile.write('model_.RestrictionStates(\n')
            states_.exportLiteral(outfile, level, name_='RestrictionStates')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('char=[\n')
        level += 1
        for char_ in self.char:
            showIndent(outfile, level)
            outfile.write('model_.RestrictionChar(\n')
            char_.exportLiteral(outfile, level, name_='RestrictionChar')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CharSet(\n')
            set_.exportLiteral(outfile, level, name_='CharSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RestrictionFormat, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'states':
            obj_ = RestrictionStates.factory()
            obj_.build(child_)
            self.states.append(obj_)
        elif nodeName_ == 'char':
            obj_ = RestrictionChar.factory()
            obj_.build(child_)
            self.char.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CharSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class RestrictionFormat


class AAObsMatrix(AbstractObsMatrix):
    """A matrix of rows with single character observations."""
    subclass = None
    superclass = AbstractObsMatrix
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(AAObsMatrix, self).__init__(about, meta, row, set, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AAObsMatrix.subclass:
            return AAObsMatrix.subclass(*args_, **kwargs_)
        else:
            return AAObsMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AAObsMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AAObsMatrix')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AAObsMatrix'):
        super(AAObsMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AAObsMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='AAObsMatrix', fromsubclass_=False):
        for row_ in self.row:
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(AAObsMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AAObsMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AAObsMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AAObsMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.AAMatrixObsRow(\n')
            row_.exportLiteral(outfile, level, name_='AAMatrixObsRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AAObsMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            obj_ = AAMatrixObsRow.factory()
            obj_.build(child_)
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class AAObsMatrix


class AASeqMatrix(AbstractSeqMatrix):
    """A matrix of rows with amino acid data as sequence strings."""
    subclass = None
    superclass = AbstractSeqMatrix
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(AASeqMatrix, self).__init__(about, meta, row, set, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AASeqMatrix.subclass:
            return AASeqMatrix.subclass(*args_, **kwargs_)
        else:
            return AASeqMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AASeqMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AASeqMatrix')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AASeqMatrix'):
        super(AASeqMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AASeqMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='AASeqMatrix', fromsubclass_=False):
        for row_ in self.row:
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(AASeqMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AASeqMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AASeqMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AASeqMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.AAMatrixSeqRow(\n')
            row_.exportLiteral(outfile, level, name_='AAMatrixSeqRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AASeqMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            obj_ = AAMatrixSeqRow.factory()
            obj_.build(child_)
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class AASeqMatrix


class AAFormat(AbstractFormat):
    """The AAFormat class is the container of amino acid column
    definitions."""
    subclass = None
    superclass = AbstractFormat
    def __init__(self, about=None, meta=None, states=None, char=None, set=None, valueOf_=None):
        super(AAFormat, self).__init__(about, meta, states, char, set, )
        if states is None:
            self.states = []
        else:
            self.states = states
        if char is None:
            self.char = []
        else:
            self.char = char
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AAFormat.subclass:
            return AAFormat.subclass(*args_, **kwargs_)
        else:
            return AAFormat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def add_states(self, value): self.states.append(value)
    def insert_states(self, index, value): self.states[index] = value
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def add_char(self, value): self.char.append(value)
    def insert_char(self, index, value): self.char[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AAFormat', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AAFormat')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AAFormat'):
        super(AAFormat, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AAFormat')
    def exportChildren(self, outfile, level, namespace_='', name_='AAFormat', fromsubclass_=False):
        for states_ in self.states:
            states_.export(outfile, level, namespace_, name_='states')
        for char_ in self.char:
            char_.export(outfile, level, namespace_, name_='char')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.states or
            self.char or
            self.set or
            super(AAFormat, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AAFormat'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AAFormat, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AAFormat, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('states=[\n')
        level += 1
        for states_ in self.states:
            showIndent(outfile, level)
            outfile.write('model_.AAStates(\n')
            states_.exportLiteral(outfile, level, name_='AAStates')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('char=[\n')
        level += 1
        for char_ in self.char:
            showIndent(outfile, level)
            outfile.write('model_.AAChar(\n')
            char_.exportLiteral(outfile, level, name_='AAChar')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CharSet(\n')
            set_.exportLiteral(outfile, level, name_='CharSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AAFormat, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'states':
            obj_ = AAStates.factory()
            obj_.build(child_)
            self.states.append(obj_)
        elif nodeName_ == 'char':
            obj_ = AAChar.factory()
            obj_.build(child_)
            self.char.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CharSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class AAFormat


class DNAObsMatrix(AbstractObsMatrix):
    """A matrix of rows with single character observations."""
    subclass = None
    superclass = AbstractObsMatrix
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(DNAObsMatrix, self).__init__(about, meta, row, set, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if DNAObsMatrix.subclass:
            return DNAObsMatrix.subclass(*args_, **kwargs_)
        else:
            return DNAObsMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='DNAObsMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNAObsMatrix')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNAObsMatrix'):
        super(DNAObsMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DNAObsMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='DNAObsMatrix', fromsubclass_=False):
        for row_ in self.row:
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(DNAObsMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DNAObsMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DNAObsMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DNAObsMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.DNAMatrixObsRow(\n')
            row_.exportLiteral(outfile, level, name_='DNAMatrixObsRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DNAObsMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            obj_ = DNAMatrixObsRow.factory()
            obj_.build(child_)
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class DNAObsMatrix


class DNASeqMatrix(AbstractSeqMatrix):
    """A matrix of rows with seq strings of type DNA."""
    subclass = None
    superclass = AbstractSeqMatrix
    def __init__(self, about=None, meta=None, row=None, set=None, valueOf_=None):
        super(DNASeqMatrix, self).__init__(about, meta, row, set, )
        if row is None:
            self.row = []
        else:
            self.row = row
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if DNASeqMatrix.subclass:
            return DNASeqMatrix.subclass(*args_, **kwargs_)
        else:
            return DNASeqMatrix(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def add_row(self, value): self.row.append(value)
    def insert_row(self, index, value): self.row[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='DNASeqMatrix', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNASeqMatrix')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNASeqMatrix'):
        super(DNASeqMatrix, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DNASeqMatrix')
    def exportChildren(self, outfile, level, namespace_='', name_='DNASeqMatrix', fromsubclass_=False):
        for row_ in self.row:
            row_.export(outfile, level, namespace_, name_='row')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.row or
            self.set or
            super(DNASeqMatrix, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DNASeqMatrix'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DNASeqMatrix, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DNASeqMatrix, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('row=[\n')
        level += 1
        for row_ in self.row:
            showIndent(outfile, level)
            outfile.write('model_.DNAMatrixSeqRow(\n')
            row_.exportLiteral(outfile, level, name_='DNAMatrixSeqRow')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.RowSet(\n')
            set_.exportLiteral(outfile, level, name_='RowSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DNASeqMatrix, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'row':
            obj_ = DNAMatrixSeqRow.factory()
            obj_.build(child_)
            self.row.append(obj_)
        elif nodeName_ == 'set':
            obj_ = RowSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class DNASeqMatrix


class DNAFormat(AbstractFormat):
    """The DNAFormat class is the container of DNA column definitions."""
    subclass = None
    superclass = AbstractFormat
    def __init__(self, about=None, meta=None, states=None, char=None, set=None, valueOf_=None):
        super(DNAFormat, self).__init__(about, meta, states, char, set, )
        if states is None:
            self.states = []
        else:
            self.states = states
        if char is None:
            self.char = []
        else:
            self.char = char
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if DNAFormat.subclass:
            return DNAFormat.subclass(*args_, **kwargs_)
        else:
            return DNAFormat(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def add_states(self, value): self.states.append(value)
    def insert_states(self, index, value): self.states[index] = value
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def add_char(self, value): self.char.append(value)
    def insert_char(self, index, value): self.char[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='DNAFormat', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNAFormat')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNAFormat'):
        super(DNAFormat, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DNAFormat')
    def exportChildren(self, outfile, level, namespace_='', name_='DNAFormat', fromsubclass_=False):
        for states_ in self.states:
            states_.export(outfile, level, namespace_, name_='states')
        for char_ in self.char:
            char_.export(outfile, level, namespace_, name_='char')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.states or
            self.char or
            self.set or
            super(DNAFormat, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DNAFormat'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DNAFormat, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DNAFormat, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('states=[\n')
        level += 1
        for states_ in self.states:
            showIndent(outfile, level)
            outfile.write('model_.DNAStates(\n')
            states_.exportLiteral(outfile, level, name_='DNAStates')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('char=[\n')
        level += 1
        for char_ in self.char:
            showIndent(outfile, level)
            outfile.write('model_.DNAChar(\n')
            char_.exportLiteral(outfile, level, name_='DNAChar')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CharSet(\n')
            set_.exportLiteral(outfile, level, name_='CharSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DNAFormat, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'states':
            obj_ = DNAStates.factory()
            obj_.build(child_)
            self.states.append(obj_)
        elif nodeName_ == 'char':
            obj_ = DNAChar.factory()
            obj_.build(child_)
            self.char.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CharSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class DNAFormat


class AbstractObs(Labelled):
    """The AbstractObs type is the superclass for single observations, i.e.
    cells in a matrix. A concrete instance of AbstractObs has a
    "char" attribute that refers to an explicitly defined character
    (e.g. in categorical matrices), and a "state" attribute that
    either holds a reference to an explicitly defined state, or a
    raw state value (a continuous value)."""
    subclass = None
    superclass = Labelled
    def __init__(self, about=None, meta=None, label=None, char=None, state=None, valueOf_=None):
        super(AbstractObs, self).__init__(about, meta, label, )
        self.char = _cast(None, char)
        self.state = _cast(None, state)
        pass
    def factory(*args_, **kwargs_):
        if AbstractObs.subclass:
            return AbstractObs.subclass(*args_, **kwargs_)
        else:
            return AbstractObs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def export(self, outfile, level, namespace_='', name_='AbstractObs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractObs')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractObs"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractObs'):
        super(AbstractObs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractObs')
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            outfile.write(' char=%s' % (quote_attrib(self.char), ))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            outfile.write(' state=%s' % (quote_attrib(self.state), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractObs', fromsubclass_=False):
        super(AbstractObs, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(AbstractObs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractObs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            showIndent(outfile, level)
            outfile.write('char = %s,\n' % (self.char,))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            showIndent(outfile, level)
            outfile.write('state = %s,\n' % (self.state,))
        super(AbstractObs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractObs, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.append('char')
            self.char = value
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.append('state')
            self.state = value
        super(AbstractObs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AbstractObs, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AbstractObs


class ContinuousObs(AbstractObs):
    """This is a single cell in a matrix containing a continuous
    observation."""
    subclass = None
    superclass = AbstractObs
    def __init__(self, about=None, meta=None, label=None, char=None, state=None, valueOf_=None):
        super(ContinuousObs, self).__init__(about, meta, label, char, state, )
        self.char = _cast(None, char)
        self.state = _cast(None, state)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if ContinuousObs.subclass:
            return ContinuousObs.subclass(*args_, **kwargs_)
        else:
            return ContinuousObs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def validate_ContinuousToken(self, value):
        # Validate type ContinuousToken, a restriction on xs:double.
        pass
    def export(self, outfile, level, namespace_='', name_='ContinuousObs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousObs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContinuousObs'):
        super(ContinuousObs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousObs')
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            outfile.write(' char=%s' % (self.gds_format_string(quote_attrib(self.char).encode(ExternalEncoding), input_name='char'), ))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            outfile.write(' state=%s' % (quote_attrib(self.state), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ContinuousObs', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(ContinuousObs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ContinuousObs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            showIndent(outfile, level)
            outfile.write('char = "%s",\n' % (self.char,))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            showIndent(outfile, level)
            outfile.write('state = %e,\n' % (self.state,))
        super(ContinuousObs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ContinuousObs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.append('char')
            self.char = value
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.append('state')
            try:
                self.state = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (state): %s' % exp)
            self.validate_ContinuousToken(self.state)    # validate type ContinuousToken
        super(ContinuousObs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class ContinuousObs


class IDTagged(Labelled):
    """The IDTagged complexType is a super class for objects that require
    unique id attributes of type xs:ID. The id must be unique within
    the XML document."""
    subclass = None
    superclass = Labelled
    def __init__(self, about=None, meta=None, label=None, id=None, valueOf_=None):
        super(IDTagged, self).__init__(about, meta, label, )
        self.id = _cast(None, id)
        pass
    def factory(*args_, **kwargs_):
        if IDTagged.subclass:
            return IDTagged.subclass(*args_, **kwargs_)
        else:
            return IDTagged(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='', name_='IDTagged', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IDTagged')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="IDTagged"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IDTagged'):
        super(IDTagged, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IDTagged')
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='IDTagged', fromsubclass_=False):
        super(IDTagged, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(IDTagged, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IDTagged'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
        super(IDTagged, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IDTagged, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        super(IDTagged, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(IDTagged, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class IDTagged


class Taxa(IDTagged):
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, set=None, valueOf_=None):
        super(Taxa, self).__init__(about, meta, label, id, )
        if otu is None:
            self.otu = []
        else:
            self.otu = otu
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if Taxa.subclass:
            return Taxa.subclass(*args_, **kwargs_)
        else:
            return Taxa(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_otu(self): return self.otu
    def set_otu(self, otu): self.otu = otu
    def add_otu(self, value): self.otu.append(value)
    def insert_otu(self, index, value): self.otu[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='Taxa', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Taxa')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="Taxa"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Taxa'):
        super(Taxa, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Taxa')
    def exportChildren(self, outfile, level, namespace_='', name_='Taxa', fromsubclass_=False):
        super(Taxa, self).exportChildren(outfile, level, namespace_, name_, True)
        for otu_ in self.otu:
            otu_.export(outfile, level, namespace_, name_='otu')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.otu or
            self.set or
            super(Taxa, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Taxa'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Taxa, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Taxa, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('otu=[\n')
        level += 1
        for otu_ in self.otu:
            showIndent(outfile, level)
            outfile.write('model_.Taxon(\n')
            otu_.exportLiteral(outfile, level, name_='Taxon')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.TaxonSet(\n')
            set_.exportLiteral(outfile, level, name_='TaxonSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Taxa, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'otu':
            obj_ = Taxon.factory()
            obj_.build(child_)
            self.otu.append(obj_)
        elif nodeName_ == 'set':
            obj_ = TaxonSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
        super(Taxa, self).buildChildren(child_, node, nodeName_, True)
# end class Taxa


class Taxon(IDTagged):
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, valueOf_=None):
        super(Taxon, self).__init__(about, meta, label, id, )
        pass
    def factory(*args_, **kwargs_):
        if Taxon.subclass:
            return Taxon.subclass(*args_, **kwargs_)
        else:
            return Taxon(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='Taxon', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Taxon')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="Taxon"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Taxon'):
        super(Taxon, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Taxon')
    def exportChildren(self, outfile, level, namespace_='', name_='Taxon', fromsubclass_=False):
        super(Taxon, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(Taxon, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Taxon'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Taxon, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Taxon, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Taxon, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(Taxon, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class Taxon


class AbstractTrees(IDTagged):
    """The AbstractTrees superclass is what concrete trees inherit from."""
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, network=None, tree=None, set=None, valueOf_=None):
        super(AbstractTrees, self).__init__(about, meta, label, id, )
        if network is None:
            self.network = []
        else:
            self.network = network
        if tree is None:
            self.tree = []
        else:
            self.tree = tree
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AbstractTrees.subclass:
            return AbstractTrees.subclass(*args_, **kwargs_)
        else:
            return AbstractTrees(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def add_network(self, value): self.network.append(value)
    def insert_network(self, index, value): self.network[index] = value
    def get_tree(self): return self.tree
    def set_tree(self, tree): self.tree = tree
    def add_tree(self, value): self.tree.append(value)
    def insert_tree(self, index, value): self.tree[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AbstractTrees', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractTrees')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractTrees"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractTrees'):
        super(AbstractTrees, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractTrees')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractTrees', fromsubclass_=False):
        super(AbstractTrees, self).exportChildren(outfile, level, namespace_, name_, True)
        for network_ in self.get_network():
            network_.export(outfile, level, namespace_, name_='network')
        for tree_ in self.get_tree():
            tree_.export(outfile, level, namespace_, name_='tree')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.network or
            self.tree or
            self.set or
            super(AbstractTrees, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractTrees'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractTrees, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractTrees, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('network=[\n')
        level += 1
        for network_ in self.network:
            showIndent(outfile, level)
            outfile.write('model_.AbstractNetwork(\n')
            network_.exportLiteral(outfile, level, name_='AbstractNetwork')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('tree=[\n')
        level += 1
        for tree_ in self.tree:
            showIndent(outfile, level)
            outfile.write('model_.AbstractTree(\n')
            tree_.exportLiteral(outfile, level, name_='AbstractTree')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.TreeAndNetworkSet(\n')
            set_.exportLiteral(outfile, level, name_='TreeAndNetworkSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractTrees, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <network> element')
            self.network.append(obj_)
        elif nodeName_ == 'tree':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <tree> element')
            self.tree.append(obj_)
        elif nodeName_ == 'set':
            obj_ = TreeAndNetworkSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
        super(AbstractTrees, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractTrees


class AbstractNetwork(IDTagged):
    """The AbstractNetwork superclass is what a concrete network inherits
    from."""
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, node=None, edge=None, set=None, valueOf_=None):
        super(AbstractNetwork, self).__init__(about, meta, label, id, )
        if node is None:
            self.node = []
        else:
            self.node = node
        if edge is None:
            self.edge = []
        else:
            self.edge = edge
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AbstractNetwork.subclass:
            return AbstractNetwork.subclass(*args_, **kwargs_)
        else:
            return AbstractNetwork(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_node(self): return self.node
    def set_node(self, node): self.node = node
    def add_node(self, value): self.node.append(value)
    def insert_node(self, index, value): self.node[index] = value
    def get_edge(self): return self.edge
    def set_edge(self, edge): self.edge = edge
    def add_edge(self, value): self.edge.append(value)
    def insert_edge(self, index, value): self.edge[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AbstractNetwork', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractNetwork')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractNetwork"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractNetwork'):
        super(AbstractNetwork, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractNetwork')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractNetwork', fromsubclass_=False):
        super(AbstractNetwork, self).exportChildren(outfile, level, namespace_, name_, True)
        for node_ in self.get_node():
            node_.export(outfile, level, namespace_, name_='node')
        for edge_ in self.get_edge():
            edge_.export(outfile, level, namespace_, name_='edge')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.node or
            self.edge or
            self.set or
            super(AbstractNetwork, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractNetwork'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractNetwork, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractNetwork, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('node=[\n')
        level += 1
        for node_ in self.node:
            showIndent(outfile, level)
            outfile.write('model_.AbstractNode(\n')
            node_.exportLiteral(outfile, level, name_='AbstractNode')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('edge=[\n')
        level += 1
        for edge_ in self.edge:
            showIndent(outfile, level)
            outfile.write('model_.AbstractEdge(\n')
            edge_.exportLiteral(outfile, level, name_='AbstractEdge')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.NodeAndRootEdgeAndEdgeSet(\n')
            set_.exportLiteral(outfile, level, name_='NodeAndRootEdgeAndEdgeSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractNetwork, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'node':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <node> element')
            self.node.append(obj_)
        elif nodeName_ == 'edge':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <edge> element')
            self.edge.append(obj_)
        elif nodeName_ == 'set':
            obj_ = NodeAndRootEdgeAndEdgeSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
        super(AbstractNetwork, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractNetwork


class AbstractTree(IDTagged):
    """The AbstractTree superclass is what a concrete tree inherits from."""
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, node=None, rootedge=None, edge=None, set=None, valueOf_=None):
        super(AbstractTree, self).__init__(about, meta, label, id, )
        if node is None:
            self.node = []
        else:
            self.node = node
        self.rootedge = rootedge
        if edge is None:
            self.edge = []
        else:
            self.edge = edge
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AbstractTree.subclass:
            return AbstractTree.subclass(*args_, **kwargs_)
        else:
            return AbstractTree(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_node(self): return self.node
    def set_node(self, node): self.node = node
    def add_node(self, value): self.node.append(value)
    def insert_node(self, index, value): self.node[index] = value
    def get_rootedge(self): return self.rootedge
    def set_rootedge(self, rootedge): self.rootedge = rootedge
    def get_edge(self): return self.edge
    def set_edge(self, edge): self.edge = edge
    def add_edge(self, value): self.edge.append(value)
    def insert_edge(self, index, value): self.edge[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AbstractTree', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractTree')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractTree"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractTree'):
        super(AbstractTree, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractTree')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractTree', fromsubclass_=False):
        super(AbstractTree, self).exportChildren(outfile, level, namespace_, name_, True)
        for node_ in self.get_node():
            node_.export(outfile, level, namespace_, name_='node')
        rootedge_.export(outfile, level, namespace_, name_='rootedge')
        for edge_ in self.get_edge():
            edge_.export(outfile, level, namespace_, name_='edge')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.node or
            self.rootedge is not None or
            self.edge or
            self.set or
            super(AbstractTree, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractTree'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractTree, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractTree, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('node=[\n')
        level += 1
        for node_ in self.node:
            showIndent(outfile, level)
            outfile.write('model_.AbstractNode(\n')
            node_.exportLiteral(outfile, level, name_='AbstractNode')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.AbstractRootEdge is not None:
            showIndent(outfile, level)
            outfile.write('AbstractRootEdge=model_.AbstractRootEdge(\n')
            self.AbstractRootEdge.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('edge=[\n')
        level += 1
        for edge_ in self.edge:
            showIndent(outfile, level)
            outfile.write('model_.AbstractEdge(\n')
            edge_.exportLiteral(outfile, level, name_='AbstractEdge')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.NodeAndRootEdgeAndEdgeSet(\n')
            set_.exportLiteral(outfile, level, name_='NodeAndRootEdgeAndEdgeSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractTree, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'node':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <node> element')
            self.node.append(obj_)
        elif nodeName_ == 'rootedge':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <rootedge> element')
            self.set_rootedge(obj_)
        elif nodeName_ == 'edge':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <edge> element')
            self.edge.append(obj_)
        elif nodeName_ == 'set':
            obj_ = NodeAndRootEdgeAndEdgeSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
        super(AbstractTree, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractTree


class AbstractRootEdge(IDTagged):
    """The AbstractRootEdge complex type is a superclass for the edge that
    leads into a root, i.e. an edge with only a target attribute,
    but no source attribute. This type of edge is used for
    coalescent trees, where the initial lineage has a certain length
    before things start splitting up."""
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, length=None, target=None, valueOf_=None):
        super(AbstractRootEdge, self).__init__(about, meta, label, id, )
        self.length = _cast(None, length)
        self.target = _cast(None, target)
        pass
    def factory(*args_, **kwargs_):
        if AbstractRootEdge.subclass:
            return AbstractRootEdge.subclass(*args_, **kwargs_)
        else:
            return AbstractRootEdge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_length(self): return self.length
    def set_length(self, length): self.length = length
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def export(self, outfile, level, namespace_='', name_='AbstractRootEdge', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractRootEdge')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractRootEdge"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractRootEdge'):
        super(AbstractRootEdge, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractRootEdge')
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            outfile.write(' length=%s' % (quote_attrib(self.length), ))
        if self.target is not None and 'target' not in already_processed:
            already_processed.append('target')
            outfile.write(' target=%s' % (self.gds_format_string(quote_attrib(self.target).encode(ExternalEncoding), input_name='target'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractRootEdge', fromsubclass_=False):
        super(AbstractRootEdge, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(AbstractRootEdge, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractRootEdge'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            showIndent(outfile, level)
            outfile.write('length = %s,\n' % (self.length,))
        if self.target is not None and 'target' not in already_processed:
            already_processed.append('target')
            showIndent(outfile, level)
            outfile.write('target = "%s",\n' % (self.target,))
        super(AbstractRootEdge, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractRootEdge, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('length', node)
        if value is not None and 'length' not in already_processed:
            already_processed.append('length')
            self.length = value
        value = find_attr_value_('target', node)
        if value is not None and 'target' not in already_processed:
            already_processed.append('target')
            self.target = value
        super(AbstractRootEdge, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AbstractRootEdge, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AbstractRootEdge


class AbstractEdge(IDTagged):
    """The AbstractEdge superclass is what concrete edges inherit from by
    restriction. It represents an edge element much like that of
    GraphML, i.e. an element that connects node elements."""
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, source=None, length=None, target=None, valueOf_=None):
        super(AbstractEdge, self).__init__(about, meta, label, id, )
        self.source = _cast(None, source)
        self.length = _cast(None, length)
        self.target = _cast(None, target)
        pass
    def factory(*args_, **kwargs_):
        if AbstractEdge.subclass:
            return AbstractEdge.subclass(*args_, **kwargs_)
        else:
            return AbstractEdge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def get_length(self): return self.length
    def set_length(self, length): self.length = length
    def get_target(self): return self.target
    def set_target(self, target): self.target = target
    def export(self, outfile, level, namespace_='', name_='AbstractEdge', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractEdge')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractEdge"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractEdge'):
        super(AbstractEdge, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractEdge')
        if self.source is not None and 'source' not in already_processed:
            already_processed.append('source')
            outfile.write(' source=%s' % (self.gds_format_string(quote_attrib(self.source).encode(ExternalEncoding), input_name='source'), ))
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            outfile.write(' length=%s' % (quote_attrib(self.length), ))
        if self.target is not None and 'target' not in already_processed:
            already_processed.append('target')
            outfile.write(' target=%s' % (self.gds_format_string(quote_attrib(self.target).encode(ExternalEncoding), input_name='target'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractEdge', fromsubclass_=False):
        super(AbstractEdge, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(AbstractEdge, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractEdge'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.source is not None and 'source' not in already_processed:
            already_processed.append('source')
            showIndent(outfile, level)
            outfile.write('source = "%s",\n' % (self.source,))
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            showIndent(outfile, level)
            outfile.write('length = %s,\n' % (self.length,))
        if self.target is not None and 'target' not in already_processed:
            already_processed.append('target')
            showIndent(outfile, level)
            outfile.write('target = "%s",\n' % (self.target,))
        super(AbstractEdge, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractEdge, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('source', node)
        if value is not None and 'source' not in already_processed:
            already_processed.append('source')
            self.source = value
        value = find_attr_value_('length', node)
        if value is not None and 'length' not in already_processed:
            already_processed.append('length')
            self.length = value
        value = find_attr_value_('target', node)
        if value is not None and 'target' not in already_processed:
            already_processed.append('target')
            self.target = value
        super(AbstractEdge, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AbstractEdge, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AbstractEdge


class IntTree(AbstractTree):
    """A concrete tree implementation, with integer edge lengths."""
    subclass = None
    superclass = AbstractTree
    def __init__(self, about=None, meta=None, label=None, id=None, node=None, rootedge=None, edge=None, set=None, valueOf_=None):
        super(IntTree, self).__init__(about, meta, label, id, node, rootedge, edge, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if node is None:
            self.node = []
        else:
            self.node = node
        self.rootedge = rootedge
        if edge is None:
            self.edge = []
        else:
            self.edge = edge
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if IntTree.subclass:
            return IntTree.subclass(*args_, **kwargs_)
        else:
            return IntTree(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_node(self): return self.node
    def set_node(self, node): self.node = node
    def add_node(self, value): self.node.append(value)
    def insert_node(self, index, value): self.node[index] = value
    def get_rootedge(self): return self.rootedge
    def set_rootedge(self, rootedge): self.rootedge = rootedge
    def get_edge(self): return self.edge
    def set_edge(self, edge): self.edge = edge
    def add_edge(self, value): self.edge.append(value)
    def insert_edge(self, index, value): self.edge[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='IntTree', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IntTree')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IntTree'):
        super(IntTree, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IntTree')
    def exportChildren(self, outfile, level, namespace_='', name_='IntTree', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for node_ in self.node:
            node_.export(outfile, level, namespace_, name_='node')
        if self.rootedge:
            self.rootedge.export(outfile, level, namespace_, name_='rootedge')
        for edge_ in self.edge:
            edge_.export(outfile, level, namespace_, name_='edge')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.node or
            self.rootedge is not None or
            self.edge or
            self.set or
            super(IntTree, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IntTree'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IntTree, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IntTree, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('node=[\n')
        level += 1
        for node_ in self.node:
            showIndent(outfile, level)
            outfile.write('model_.TreeNode(\n')
            node_.exportLiteral(outfile, level, name_='TreeNode')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.rootedge is not None:
            showIndent(outfile, level)
            outfile.write('rootedge=model_.TreeIntRootEdge(\n')
            self.rootedge.exportLiteral(outfile, level, name_='rootedge')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('edge=[\n')
        level += 1
        for edge_ in self.edge:
            showIndent(outfile, level)
            outfile.write('model_.TreeIntEdge(\n')
            edge_.exportLiteral(outfile, level, name_='TreeIntEdge')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.NodeAndRootEdgeAndEdgeSet(\n')
            set_.exportLiteral(outfile, level, name_='NodeAndRootEdgeAndEdgeSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(IntTree, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'node':
            obj_ = TreeNode.factory()
            obj_.build(child_)
            self.node.append(obj_)
        elif nodeName_ == 'rootedge':
            obj_ = TreeIntRootEdge.factory()
            obj_.build(child_)
            self.set_rootedge(obj_)
        elif nodeName_ == 'edge':
            obj_ = TreeIntEdge.factory()
            obj_.build(child_)
            self.edge.append(obj_)
        elif nodeName_ == 'set':
            obj_ = NodeAndRootEdgeAndEdgeSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class IntTree


class FloatTree(AbstractTree):
    """A concrete tree implementation, with floating point edge lengths."""
    subclass = None
    superclass = AbstractTree
    def __init__(self, about=None, meta=None, label=None, id=None, node=None, rootedge=None, edge=None, set=None, valueOf_=None):
        super(FloatTree, self).__init__(about, meta, label, id, node, rootedge, edge, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if node is None:
            self.node = []
        else:
            self.node = node
        self.rootedge = rootedge
        if edge is None:
            self.edge = []
        else:
            self.edge = edge
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if FloatTree.subclass:
            return FloatTree.subclass(*args_, **kwargs_)
        else:
            return FloatTree(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_node(self): return self.node
    def set_node(self, node): self.node = node
    def add_node(self, value): self.node.append(value)
    def insert_node(self, index, value): self.node[index] = value
    def get_rootedge(self): return self.rootedge
    def set_rootedge(self, rootedge): self.rootedge = rootedge
    def get_edge(self): return self.edge
    def set_edge(self, edge): self.edge = edge
    def add_edge(self, value): self.edge.append(value)
    def insert_edge(self, index, value): self.edge[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='FloatTree', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FloatTree')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FloatTree'):
        super(FloatTree, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FloatTree')
    def exportChildren(self, outfile, level, namespace_='', name_='FloatTree', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for node_ in self.node:
            node_.export(outfile, level, namespace_, name_='node')
        if self.rootedge:
            self.rootedge.export(outfile, level, namespace_, name_='rootedge')
        for edge_ in self.edge:
            edge_.export(outfile, level, namespace_, name_='edge')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.node or
            self.rootedge is not None or
            self.edge or
            self.set or
            super(FloatTree, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='FloatTree'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(FloatTree, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FloatTree, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('node=[\n')
        level += 1
        for node_ in self.node:
            showIndent(outfile, level)
            outfile.write('model_.TreeNode(\n')
            node_.exportLiteral(outfile, level, name_='TreeNode')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.rootedge is not None:
            showIndent(outfile, level)
            outfile.write('rootedge=model_.TreeFloatRootEdge(\n')
            self.rootedge.exportLiteral(outfile, level, name_='rootedge')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('edge=[\n')
        level += 1
        for edge_ in self.edge:
            showIndent(outfile, level)
            outfile.write('model_.TreeFloatEdge(\n')
            edge_.exportLiteral(outfile, level, name_='TreeFloatEdge')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.NodeAndRootEdgeAndEdgeSet(\n')
            set_.exportLiteral(outfile, level, name_='NodeAndRootEdgeAndEdgeSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(FloatTree, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'node':
            obj_ = TreeNode.factory()
            obj_.build(child_)
            self.node.append(obj_)
        elif nodeName_ == 'rootedge':
            obj_ = TreeFloatRootEdge.factory()
            obj_.build(child_)
            self.set_rootedge(obj_)
        elif nodeName_ == 'edge':
            obj_ = TreeFloatEdge.factory()
            obj_.build(child_)
            self.edge.append(obj_)
        elif nodeName_ == 'set':
            obj_ = NodeAndRootEdgeAndEdgeSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class FloatTree


class TreeIntRootEdge(AbstractRootEdge):
    """A concrete root edge implementation, with int length."""
    subclass = None
    superclass = AbstractRootEdge
    def __init__(self, about=None, meta=None, label=None, id=None, length=None, target=None, valueOf_=None):
        super(TreeIntRootEdge, self).__init__(about, meta, label, id, length, target, )
        self.length = _cast(int, length)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if TreeIntRootEdge.subclass:
            return TreeIntRootEdge.subclass(*args_, **kwargs_)
        else:
            return TreeIntRootEdge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_length(self): return self.length
    def set_length(self, length): self.length = length
    def export(self, outfile, level, namespace_='', name_='TreeIntRootEdge', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TreeIntRootEdge')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TreeIntRootEdge'):
        super(TreeIntRootEdge, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TreeIntRootEdge')
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            outfile.write(' length="%s"' % self.gds_format_integer(self.length, input_name='length'))
    def exportChildren(self, outfile, level, namespace_='', name_='TreeIntRootEdge', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(TreeIntRootEdge, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TreeIntRootEdge'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            showIndent(outfile, level)
            outfile.write('length = %d,\n' % (self.length,))
        super(TreeIntRootEdge, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TreeIntRootEdge, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('length', node)
        if value is not None and 'length' not in already_processed:
            already_processed.append('length')
            try:
                self.length = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(TreeIntRootEdge, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class TreeIntRootEdge


class TreeIntEdge(AbstractEdge):
    """A concrete edge implementation, with int length."""
    subclass = None
    superclass = AbstractEdge
    def __init__(self, about=None, meta=None, label=None, id=None, source=None, length=None, target=None, valueOf_=None):
        super(TreeIntEdge, self).__init__(about, meta, label, id, source, length, target, )
        self.length = _cast(int, length)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if TreeIntEdge.subclass:
            return TreeIntEdge.subclass(*args_, **kwargs_)
        else:
            return TreeIntEdge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_length(self): return self.length
    def set_length(self, length): self.length = length
    def export(self, outfile, level, namespace_='', name_='TreeIntEdge', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TreeIntEdge')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TreeIntEdge'):
        super(TreeIntEdge, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TreeIntEdge')
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            outfile.write(' length="%s"' % self.gds_format_integer(self.length, input_name='length'))
    def exportChildren(self, outfile, level, namespace_='', name_='TreeIntEdge', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(TreeIntEdge, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TreeIntEdge'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            showIndent(outfile, level)
            outfile.write('length = %d,\n' % (self.length,))
        super(TreeIntEdge, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TreeIntEdge, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('length', node)
        if value is not None and 'length' not in already_processed:
            already_processed.append('length')
            try:
                self.length = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(TreeIntEdge, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class TreeIntEdge


class TreeFloatRootEdge(AbstractRootEdge):
    """A concrete root edge implementation, with float length."""
    subclass = None
    superclass = AbstractRootEdge
    def __init__(self, about=None, meta=None, label=None, id=None, length=None, target=None, valueOf_=None):
        super(TreeFloatRootEdge, self).__init__(about, meta, label, id, length, target, )
        self.length = _cast(float, length)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if TreeFloatRootEdge.subclass:
            return TreeFloatRootEdge.subclass(*args_, **kwargs_)
        else:
            return TreeFloatRootEdge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_length(self): return self.length
    def set_length(self, length): self.length = length
    def export(self, outfile, level, namespace_='', name_='TreeFloatRootEdge', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TreeFloatRootEdge')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TreeFloatRootEdge'):
        super(TreeFloatRootEdge, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TreeFloatRootEdge')
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            outfile.write(' length="%s"' % self.gds_format_double(self.length, input_name='length'))
    def exportChildren(self, outfile, level, namespace_='', name_='TreeFloatRootEdge', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(TreeFloatRootEdge, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TreeFloatRootEdge'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            showIndent(outfile, level)
            outfile.write('length = %e,\n' % (self.length,))
        super(TreeFloatRootEdge, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TreeFloatRootEdge, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('length', node)
        if value is not None and 'length' not in already_processed:
            already_processed.append('length')
            try:
                self.length = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (length): %s' % exp)
        super(TreeFloatRootEdge, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class TreeFloatRootEdge


class TreeFloatEdge(AbstractEdge):
    """A concrete edge implementation, with float length."""
    subclass = None
    superclass = AbstractEdge
    def __init__(self, about=None, meta=None, label=None, id=None, source=None, length=None, target=None, valueOf_=None):
        super(TreeFloatEdge, self).__init__(about, meta, label, id, source, length, target, )
        self.length = _cast(float, length)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if TreeFloatEdge.subclass:
            return TreeFloatEdge.subclass(*args_, **kwargs_)
        else:
            return TreeFloatEdge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_length(self): return self.length
    def set_length(self, length): self.length = length
    def export(self, outfile, level, namespace_='', name_='TreeFloatEdge', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TreeFloatEdge')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TreeFloatEdge'):
        super(TreeFloatEdge, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TreeFloatEdge')
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            outfile.write(' length="%s"' % self.gds_format_double(self.length, input_name='length'))
    def exportChildren(self, outfile, level, namespace_='', name_='TreeFloatEdge', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(TreeFloatEdge, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TreeFloatEdge'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            showIndent(outfile, level)
            outfile.write('length = %e,\n' % (self.length,))
        super(TreeFloatEdge, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TreeFloatEdge, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('length', node)
        if value is not None and 'length' not in already_processed:
            already_processed.append('length')
            try:
                self.length = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (length): %s' % exp)
        super(TreeFloatEdge, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class TreeFloatEdge


class StandardObs(AbstractObs):
    """This is a single cell in a matrix containing a standard observation."""
    subclass = None
    superclass = AbstractObs
    def __init__(self, about=None, meta=None, label=None, char=None, state=None, valueOf_=None):
        super(StandardObs, self).__init__(about, meta, label, char, state, )
        self.char = _cast(None, char)
        self.state = _cast(None, state)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if StandardObs.subclass:
            return StandardObs.subclass(*args_, **kwargs_)
        else:
            return StandardObs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def export(self, outfile, level, namespace_='', name_='StandardObs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardObs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardObs'):
        super(StandardObs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardObs')
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            outfile.write(' char=%s' % (self.gds_format_string(quote_attrib(self.char).encode(ExternalEncoding), input_name='char'), ))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            outfile.write(' state=%s' % (self.gds_format_string(quote_attrib(self.state).encode(ExternalEncoding), input_name='state'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StandardObs', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(StandardObs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardObs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            showIndent(outfile, level)
            outfile.write('char = "%s",\n' % (self.char,))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            showIndent(outfile, level)
            outfile.write('state = "%s",\n' % (self.state,))
        super(StandardObs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardObs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.append('char')
            self.char = value
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.append('state')
            self.state = value
        super(StandardObs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class StandardObs


class RNAObs(AbstractObs):
    """This is a single cell in a matrix containing an RNA nucleotide
    observation."""
    subclass = None
    superclass = AbstractObs
    def __init__(self, about=None, meta=None, label=None, char=None, state=None, valueOf_=None):
        super(RNAObs, self).__init__(about, meta, label, char, state, )
        self.char = _cast(None, char)
        self.state = _cast(None, state)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if RNAObs.subclass:
            return RNAObs.subclass(*args_, **kwargs_)
        else:
            return RNAObs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def export(self, outfile, level, namespace_='', name_='RNAObs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RNAObs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RNAObs'):
        super(RNAObs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RNAObs')
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            outfile.write(' char=%s' % (self.gds_format_string(quote_attrib(self.char).encode(ExternalEncoding), input_name='char'), ))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            outfile.write(' state=%s' % (self.gds_format_string(quote_attrib(self.state).encode(ExternalEncoding), input_name='state'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RNAObs', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(RNAObs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RNAObs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            showIndent(outfile, level)
            outfile.write('char = "%s",\n' % (self.char,))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            showIndent(outfile, level)
            outfile.write('state = "%s",\n' % (self.state,))
        super(RNAObs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RNAObs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.append('char')
            self.char = value
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.append('state')
            self.state = value
        super(RNAObs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class RNAObs


class RestrictionObs(AbstractObs):
    """This is a single cell in a matrix containing a restriction site
    observation."""
    subclass = None
    superclass = AbstractObs
    def __init__(self, about=None, meta=None, label=None, char=None, state=None, valueOf_=None):
        super(RestrictionObs, self).__init__(about, meta, label, char, state, )
        self.char = _cast(None, char)
        self.state = _cast(None, state)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if RestrictionObs.subclass:
            return RestrictionObs.subclass(*args_, **kwargs_)
        else:
            return RestrictionObs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def export(self, outfile, level, namespace_='', name_='RestrictionObs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionObs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RestrictionObs'):
        super(RestrictionObs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionObs')
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            outfile.write(' char=%s' % (self.gds_format_string(quote_attrib(self.char).encode(ExternalEncoding), input_name='char'), ))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            outfile.write(' state=%s' % (self.gds_format_string(quote_attrib(self.state).encode(ExternalEncoding), input_name='state'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RestrictionObs', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(RestrictionObs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RestrictionObs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            showIndent(outfile, level)
            outfile.write('char = "%s",\n' % (self.char,))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            showIndent(outfile, level)
            outfile.write('state = "%s",\n' % (self.state,))
        super(RestrictionObs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RestrictionObs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.append('char')
            self.char = value
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.append('state')
            self.state = value
        super(RestrictionObs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class RestrictionObs


class AAObs(AbstractObs):
    """This is a single cell in a matrix containing an amino acid
    observation."""
    subclass = None
    superclass = AbstractObs
    def __init__(self, about=None, meta=None, label=None, char=None, state=None, valueOf_=None):
        super(AAObs, self).__init__(about, meta, label, char, state, )
        self.char = _cast(None, char)
        self.state = _cast(None, state)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if AAObs.subclass:
            return AAObs.subclass(*args_, **kwargs_)
        else:
            return AAObs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def export(self, outfile, level, namespace_='', name_='AAObs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AAObs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AAObs'):
        super(AAObs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AAObs')
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            outfile.write(' char=%s' % (self.gds_format_string(quote_attrib(self.char).encode(ExternalEncoding), input_name='char'), ))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            outfile.write(' state=%s' % (self.gds_format_string(quote_attrib(self.state).encode(ExternalEncoding), input_name='state'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AAObs', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(AAObs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AAObs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            showIndent(outfile, level)
            outfile.write('char = "%s",\n' % (self.char,))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            showIndent(outfile, level)
            outfile.write('state = "%s",\n' % (self.state,))
        super(AAObs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AAObs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.append('char')
            self.char = value
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.append('state')
            self.state = value
        super(AAObs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class AAObs


class DNAObs(AbstractObs):
    """This is a single cell in a matrix containing a nucleotide
    observation."""
    subclass = None
    superclass = AbstractObs
    def __init__(self, about=None, meta=None, label=None, char=None, state=None, valueOf_=None):
        super(DNAObs, self).__init__(about, meta, label, char, state, )
        self.char = _cast(None, char)
        self.state = _cast(None, state)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if DNAObs.subclass:
            return DNAObs.subclass(*args_, **kwargs_)
        else:
            return DNAObs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def export(self, outfile, level, namespace_='', name_='DNAObs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNAObs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNAObs'):
        super(DNAObs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DNAObs')
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            outfile.write(' char=%s' % (self.gds_format_string(quote_attrib(self.char).encode(ExternalEncoding), input_name='char'), ))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            outfile.write(' state=%s' % (self.gds_format_string(quote_attrib(self.state).encode(ExternalEncoding), input_name='state'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='DNAObs', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(DNAObs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DNAObs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            showIndent(outfile, level)
            outfile.write('char = "%s",\n' % (self.char,))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            showIndent(outfile, level)
            outfile.write('state = "%s",\n' % (self.state,))
        super(DNAObs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DNAObs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.append('char')
            self.char = value
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.append('state')
            self.state = value
        super(DNAObs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class DNAObs


class AbstractChar(IDTagged):
    """The AbstractChar type is the superclass for a column definition,
    which may have a "states" attribute that refers to an
    AbstractStates element, a codon attribute of type CodonPosition
    and an id attribute that may be an actual id (e.g. for
    categorical matrices where observations explicitly refer to a
    column definition) or an integer for sequence matrices."""
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, tokens=None, states=None, codon=None, valueOf_=None):
        super(AbstractChar, self).__init__(about, meta, label, id, )
        self.tokens = _cast(None, tokens)
        self.states = _cast(None, states)
        self.codon = _cast(None, codon)
        pass
    def factory(*args_, **kwargs_):
        if AbstractChar.subclass:
            return AbstractChar.subclass(*args_, **kwargs_)
        else:
            return AbstractChar(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tokens(self): return self.tokens
    def set_tokens(self, tokens): self.tokens = tokens
    def validate_MSTokenLength(self, value):
        # Validate type MSTokenLength, a restriction on xs:positiveInteger.
        pass
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def get_codon(self): return self.codon
    def set_codon(self, codon): self.codon = codon
    def validate_CodonPosition(self, value):
        # Validate type CodonPosition, a restriction on xs:nonNegativeInteger.
        pass
    def export(self, outfile, level, namespace_='', name_='AbstractChar', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractChar')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractChar"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractChar'):
        super(AbstractChar, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractChar')
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            outfile.write(' tokens=%s' % (quote_attrib(self.tokens), ))
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            outfile.write(' states=%s' % (self.gds_format_string(quote_attrib(self.states).encode(ExternalEncoding), input_name='states'), ))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            outfile.write(' codon=%s' % (quote_attrib(self.codon), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractChar', fromsubclass_=False):
        super(AbstractChar, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(AbstractChar, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractChar'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            showIndent(outfile, level)
            outfile.write('tokens = %d,\n' % (self.tokens,))
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            showIndent(outfile, level)
            outfile.write('states = "%s",\n' % (self.states,))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            showIndent(outfile, level)
            outfile.write('codon = %d,\n' % (self.codon,))
        super(AbstractChar, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractChar, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tokens', node)
        if value is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            try:
                self.tokens = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.tokens <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_MSTokenLength(self.tokens)    # validate type MSTokenLength
        value = find_attr_value_('states', node)
        if value is not None and 'states' not in already_processed:
            already_processed.append('states')
            self.states = value
        value = find_attr_value_('codon', node)
        if value is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            try:
                self.codon = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.codon < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_CodonPosition(self.codon)    # validate type CodonPosition
        super(AbstractChar, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AbstractChar, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AbstractChar


class AbstractStates(IDTagged):
    """A container for a set of AbstractState elements."""
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, state=None, polymorphic_state_set=None, uncertain_state_set=None, set=None, valueOf_=None):
        super(AbstractStates, self).__init__(about, meta, label, id, )
        if state is None:
            self.state = []
        else:
            self.state = state
        if polymorphic_state_set is None:
            self.polymorphic_state_set = []
        else:
            self.polymorphic_state_set = polymorphic_state_set
        if uncertain_state_set is None:
            self.uncertain_state_set = []
        else:
            self.uncertain_state_set = uncertain_state_set
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AbstractStates.subclass:
            return AbstractStates.subclass(*args_, **kwargs_)
        else:
            return AbstractStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def add_state(self, value): self.state.append(value)
    def insert_state(self, index, value): self.state[index] = value
    def get_polymorphic_state_set(self): return self.polymorphic_state_set
    def set_polymorphic_state_set(self, polymorphic_state_set): self.polymorphic_state_set = polymorphic_state_set
    def add_polymorphic_state_set(self, value): self.polymorphic_state_set.append(value)
    def insert_polymorphic_state_set(self, index, value): self.polymorphic_state_set[index] = value
    def get_uncertain_state_set(self): return self.uncertain_state_set
    def set_uncertain_state_set(self, uncertain_state_set): self.uncertain_state_set = uncertain_state_set
    def add_uncertain_state_set(self, value): self.uncertain_state_set.append(value)
    def insert_uncertain_state_set(self, index, value): self.uncertain_state_set[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AbstractStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractStates')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractStates"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractStates'):
        super(AbstractStates, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractStates')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractStates', fromsubclass_=False):
        super(AbstractStates, self).exportChildren(outfile, level, namespace_, name_, True)
        for state_ in self.get_state():
            state_.export(outfile, level, namespace_, name_='state')
        for polymorphic_state_set_ in self.get_polymorphic_state_set():
            polymorphic_state_set_.export(outfile, level, namespace_, name_='polymorphic_state_set')
        for uncertain_state_set_ in self.get_uncertain_state_set():
            uncertain_state_set_.export(outfile, level, namespace_, name_='uncertain_state_set')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.state or
            self.polymorphic_state_set or
            self.uncertain_state_set or
            self.set or
            super(AbstractStates, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractStates, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractStates, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('state=[\n')
        level += 1
        for state_ in self.state:
            showIndent(outfile, level)
            outfile.write('model_.AbstractState(\n')
            state_.exportLiteral(outfile, level, name_='AbstractState')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('polymorphic_state_set=[\n')
        level += 1
        for polymorphic_state_set_ in self.polymorphic_state_set:
            showIndent(outfile, level)
            outfile.write('model_.AbstractPolymorphicStateSet(\n')
            polymorphic_state_set_.exportLiteral(outfile, level, name_='AbstractPolymorphicStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('uncertain_state_set=[\n')
        level += 1
        for uncertain_state_set_ in self.uncertain_state_set:
            showIndent(outfile, level)
            outfile.write('model_.AbstractUncertainStateSet(\n')
            uncertain_state_set_.exportLiteral(outfile, level, name_='AbstractUncertainStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.StateSet(\n')
            set_.exportLiteral(outfile, level, name_='StateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractStates, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'state':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <state> element')
            self.state.append(obj_)
        elif nodeName_ == 'polymorphic_state_set':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <polymorphic_state_set> element')
            self.polymorphic_state_set.append(obj_)
        elif nodeName_ == 'uncertain_state_set':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <uncertain_state_set> element')
            self.uncertain_state_set.append(obj_)
        elif nodeName_ == 'set':
            obj_ = StateSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
        super(AbstractStates, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractStates


class AbstractState(IDTagged):
    """The AbstractState type is the super-class for a state definition.
    The element has a required symbol attribute that in restricted
    concrete subclasses must be of a sensible type such as a single
    IUPAC character. It may enclose zero or more AbstractMapping
    elements to resolve ambiguities."""
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, valueOf_=None):
        super(AbstractState, self).__init__(about, meta, label, id, )
        self.symbol = _cast(None, symbol)
        pass
    def factory(*args_, **kwargs_):
        if AbstractState.subclass:
            return AbstractState.subclass(*args_, **kwargs_)
        else:
            return AbstractState(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def export(self, outfile, level, namespace_='', name_='AbstractState', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractState')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractState"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractState'):
        super(AbstractState, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractState')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (quote_attrib(self.symbol), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractState', fromsubclass_=False):
        super(AbstractState, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(AbstractState, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractState'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = %s,\n' % (self.symbol,))
        super(AbstractState, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractState, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            self.symbol = value
        super(AbstractState, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AbstractState, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AbstractState


class ContinuousChar(AbstractChar):
    """A concrete implementation of the char element, which requires only
    an id attribute."""
    subclass = None
    superclass = AbstractChar
    def __init__(self, about=None, meta=None, label=None, id=None, tokens=None, states=None, codon=None, valueOf_=None):
        super(ContinuousChar, self).__init__(about, meta, label, id, tokens, states, codon, )
        self.states = _cast(None, states)
        self.tokens = _cast(None, tokens)
        self.codon = _cast(None, codon)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if ContinuousChar.subclass:
            return ContinuousChar.subclass(*args_, **kwargs_)
        else:
            return ContinuousChar(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def get_tokens(self): return self.tokens
    def set_tokens(self, tokens): self.tokens = tokens
    def validate_MSTokenLength(self, value):
        # Validate type MSTokenLength, a restriction on xs:positiveInteger.
        pass
    def get_codon(self): return self.codon
    def set_codon(self, codon): self.codon = codon
    def validate_CodonPosition(self, value):
        # Validate type CodonPosition, a restriction on xs:nonNegativeInteger.
        pass
    def export(self, outfile, level, namespace_='', name_='ContinuousChar', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousChar')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContinuousChar'):
        super(ContinuousChar, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousChar')
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            outfile.write(' states=%s' % (self.gds_format_string(quote_attrib(self.states).encode(ExternalEncoding), input_name='states'), ))
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            outfile.write(' tokens=%s' % (quote_attrib(self.tokens), ))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            outfile.write(' codon=%s' % (quote_attrib(self.codon), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ContinuousChar', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(ContinuousChar, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ContinuousChar'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            showIndent(outfile, level)
            outfile.write('states = "%s",\n' % (self.states,))
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            showIndent(outfile, level)
            outfile.write('tokens = %d,\n' % (self.tokens,))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            showIndent(outfile, level)
            outfile.write('codon = %d,\n' % (self.codon,))
        super(ContinuousChar, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ContinuousChar, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('states', node)
        if value is not None and 'states' not in already_processed:
            already_processed.append('states')
            self.states = value
        value = find_attr_value_('tokens', node)
        if value is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            try:
                self.tokens = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.tokens <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_MSTokenLength(self.tokens)    # validate type MSTokenLength
        value = find_attr_value_('codon', node)
        if value is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            try:
                self.codon = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.codon < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_CodonPosition(self.codon)    # validate type CodonPosition
        super(ContinuousChar, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class ContinuousChar


class AbstractSet(IDTagged):
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, valueOf_=None):
        super(AbstractSet, self).__init__(about, meta, label, id, )
        pass
    def factory(*args_, **kwargs_):
        if AbstractSet.subclass:
            return AbstractSet.subclass(*args_, **kwargs_)
        else:
            return AbstractSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def export(self, outfile, level, namespace_='', name_='AbstractSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractSet')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractSet"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractSet'):
        super(AbstractSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractSet')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractSet', fromsubclass_=False):
        super(AbstractSet, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(AbstractSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractSet, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AbstractSet, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AbstractSet


class TaxaLinked(IDTagged):
    """The TaxaLinked complexType is a super class for objects that that
    require an otus id reference."""
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, valueOf_=None):
        super(TaxaLinked, self).__init__(about, meta, label, id, )
        self.otus = _cast(None, otus)
        pass
    def factory(*args_, **kwargs_):
        if TaxaLinked.subclass:
            return TaxaLinked.subclass(*args_, **kwargs_)
        else:
            return TaxaLinked(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_otus(self): return self.otus
    def set_otus(self, otus): self.otus = otus
    def export(self, outfile, level, namespace_='', name_='TaxaLinked', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaxaLinked')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="TaxaLinked"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TaxaLinked'):
        super(TaxaLinked, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaxaLinked')
        if self.otus is not None and 'otus' not in already_processed:
            already_processed.append('otus')
            outfile.write(' otus=%s' % (self.gds_format_string(quote_attrib(self.otus).encode(ExternalEncoding), input_name='otus'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='TaxaLinked', fromsubclass_=False):
        super(TaxaLinked, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(TaxaLinked, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TaxaLinked'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.otus is not None and 'otus' not in already_processed:
            already_processed.append('otus')
            showIndent(outfile, level)
            outfile.write('otus = "%s",\n' % (self.otus,))
        super(TaxaLinked, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaxaLinked, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('otus', node)
        if value is not None and 'otus' not in already_processed:
            already_processed.append('otus')
            self.otus = value
        super(TaxaLinked, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(TaxaLinked, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class TaxaLinked


class OptionalTaxonLinked(IDTagged):
    """The OptionalOTULinked complexType is a super class for objects that
    that optionally have an otu id reference."""
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, valueOf_=None):
        super(OptionalTaxonLinked, self).__init__(about, meta, label, id, )
        self.otu = _cast(None, otu)
        pass
    def factory(*args_, **kwargs_):
        if OptionalTaxonLinked.subclass:
            return OptionalTaxonLinked.subclass(*args_, **kwargs_)
        else:
            return OptionalTaxonLinked(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_otu(self): return self.otu
    def set_otu(self, otu): self.otu = otu
    def export(self, outfile, level, namespace_='', name_='OptionalTaxonLinked', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OptionalTaxonLinked')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="OptionalTaxonLinked"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OptionalTaxonLinked'):
        super(OptionalTaxonLinked, self).exportAttributes(outfile, level, already_processed, namespace_, name_='OptionalTaxonLinked')
        if self.otu is not None and 'otu' not in already_processed:
            already_processed.append('otu')
            outfile.write(' otu=%s' % (self.gds_format_string(quote_attrib(self.otu).encode(ExternalEncoding), input_name='otu'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='OptionalTaxonLinked', fromsubclass_=False):
        super(OptionalTaxonLinked, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(OptionalTaxonLinked, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='OptionalTaxonLinked'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.otu is not None and 'otu' not in already_processed:
            already_processed.append('otu')
            showIndent(outfile, level)
            outfile.write('otu = "%s",\n' % (self.otu,))
        super(OptionalTaxonLinked, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(OptionalTaxonLinked, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('otu', node)
        if value is not None and 'otu' not in already_processed:
            already_processed.append('otu')
            self.otu = value
        super(OptionalTaxonLinked, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(OptionalTaxonLinked, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class OptionalTaxonLinked


class TaxonLinked(IDTagged):
    """The TaxonLinked complexType is a super class for objects that
    require a taxon id reference."""
    subclass = None
    superclass = IDTagged
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, valueOf_=None):
        super(TaxonLinked, self).__init__(about, meta, label, id, )
        self.otu = _cast(None, otu)
        pass
    def factory(*args_, **kwargs_):
        if TaxonLinked.subclass:
            return TaxonLinked.subclass(*args_, **kwargs_)
        else:
            return TaxonLinked(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_otu(self): return self.otu
    def set_otu(self, otu): self.otu = otu
    def export(self, outfile, level, namespace_='', name_='TaxonLinked', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaxonLinked')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="TaxonLinked"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TaxonLinked'):
        super(TaxonLinked, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaxonLinked')
        if self.otu is not None and 'otu' not in already_processed:
            already_processed.append('otu')
            outfile.write(' otu=%s' % (self.gds_format_string(quote_attrib(self.otu).encode(ExternalEncoding), input_name='otu'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='TaxonLinked', fromsubclass_=False):
        super(TaxonLinked, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(TaxonLinked, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TaxonLinked'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.otu is not None and 'otu' not in already_processed:
            already_processed.append('otu')
            showIndent(outfile, level)
            outfile.write('otu = "%s",\n' % (self.otu,))
        super(TaxonLinked, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaxonLinked, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('otu', node)
        if value is not None and 'otu' not in already_processed:
            already_processed.append('otu')
            self.otu = value
        super(TaxonLinked, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(TaxonLinked, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class TaxonLinked


class IntNetwork(AbstractNetwork):
    """A concrete network implementation, with integer edge lengths."""
    subclass = None
    superclass = AbstractNetwork
    def __init__(self, about=None, meta=None, label=None, id=None, node=None, edge=None, set=None, valueOf_=None):
        super(IntNetwork, self).__init__(about, meta, label, id, node, edge, set, )
        if node is None:
            self.node = []
        else:
            self.node = node
        if edge is None:
            self.edge = []
        else:
            self.edge = edge
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if IntNetwork.subclass:
            return IntNetwork.subclass(*args_, **kwargs_)
        else:
            return IntNetwork(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_node(self): return self.node
    def set_node(self, node): self.node = node
    def add_node(self, value): self.node.append(value)
    def insert_node(self, index, value): self.node[index] = value
    def get_edge(self): return self.edge
    def set_edge(self, edge): self.edge = edge
    def add_edge(self, value): self.edge.append(value)
    def insert_edge(self, index, value): self.edge[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='IntNetwork', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='IntNetwork')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='IntNetwork'):
        super(IntNetwork, self).exportAttributes(outfile, level, already_processed, namespace_, name_='IntNetwork')
    def exportChildren(self, outfile, level, namespace_='', name_='IntNetwork', fromsubclass_=False):
        for node_ in self.node:
            node_.export(outfile, level, namespace_, name_='node')
        for edge_ in self.edge:
            edge_.export(outfile, level, namespace_, name_='edge')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.node or
            self.edge or
            self.set or
            super(IntNetwork, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='IntNetwork'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(IntNetwork, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(IntNetwork, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('node=[\n')
        level += 1
        for node_ in self.node:
            showIndent(outfile, level)
            outfile.write('model_.NetworkNode(\n')
            node_.exportLiteral(outfile, level, name_='NetworkNode')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('edge=[\n')
        level += 1
        for edge_ in self.edge:
            showIndent(outfile, level)
            outfile.write('model_.NetworkIntEdge(\n')
            edge_.exportLiteral(outfile, level, name_='NetworkIntEdge')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.NodeAndRootEdgeAndEdgeSet(\n')
            set_.exportLiteral(outfile, level, name_='NodeAndRootEdgeAndEdgeSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(IntNetwork, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'node':
            obj_ = NetworkNode.factory()
            obj_.build(child_)
            self.node.append(obj_)
        elif nodeName_ == 'edge':
            obj_ = NetworkIntEdge.factory()
            obj_.build(child_)
            self.edge.append(obj_)
        elif nodeName_ == 'set':
            obj_ = NodeAndRootEdgeAndEdgeSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class IntNetwork


class FloatNetwork(AbstractNetwork):
    """A concrete network implementation, with floating point edge lengths."""
    subclass = None
    superclass = AbstractNetwork
    def __init__(self, about=None, meta=None, label=None, id=None, node=None, edge=None, set=None, valueOf_=None):
        super(FloatNetwork, self).__init__(about, meta, label, id, node, edge, set, )
        if node is None:
            self.node = []
        else:
            self.node = node
        if edge is None:
            self.edge = []
        else:
            self.edge = edge
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if FloatNetwork.subclass:
            return FloatNetwork.subclass(*args_, **kwargs_)
        else:
            return FloatNetwork(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_node(self): return self.node
    def set_node(self, node): self.node = node
    def add_node(self, value): self.node.append(value)
    def insert_node(self, index, value): self.node[index] = value
    def get_edge(self): return self.edge
    def set_edge(self, edge): self.edge = edge
    def add_edge(self, value): self.edge.append(value)
    def insert_edge(self, index, value): self.edge[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='FloatNetwork', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='FloatNetwork')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='FloatNetwork'):
        super(FloatNetwork, self).exportAttributes(outfile, level, already_processed, namespace_, name_='FloatNetwork')
    def exportChildren(self, outfile, level, namespace_='', name_='FloatNetwork', fromsubclass_=False):
        for node_ in self.node:
            node_.export(outfile, level, namespace_, name_='node')
        for edge_ in self.edge:
            edge_.export(outfile, level, namespace_, name_='edge')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.node or
            self.edge or
            self.set or
            super(FloatNetwork, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='FloatNetwork'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(FloatNetwork, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(FloatNetwork, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('node=[\n')
        level += 1
        for node_ in self.node:
            showIndent(outfile, level)
            outfile.write('model_.NetworkNode(\n')
            node_.exportLiteral(outfile, level, name_='NetworkNode')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('edge=[\n')
        level += 1
        for edge_ in self.edge:
            showIndent(outfile, level)
            outfile.write('model_.NetworkFloatEdge(\n')
            edge_.exportLiteral(outfile, level, name_='NetworkFloatEdge')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.NodeAndRootEdgeAndEdgeSet(\n')
            set_.exportLiteral(outfile, level, name_='NodeAndRootEdgeAndEdgeSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(FloatNetwork, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'node':
            obj_ = NetworkNode.factory()
            obj_.build(child_)
            self.node.append(obj_)
        elif nodeName_ == 'edge':
            obj_ = NetworkFloatEdge.factory()
            obj_.build(child_)
            self.edge.append(obj_)
        elif nodeName_ == 'set':
            obj_ = NodeAndRootEdgeAndEdgeSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class FloatNetwork


class NetworkIntEdge(AbstractEdge):
    """A concrete network edge implementation, with int edge."""
    subclass = None
    superclass = AbstractEdge
    def __init__(self, about=None, meta=None, label=None, id=None, source=None, length=None, target=None, valueOf_=None):
        super(NetworkIntEdge, self).__init__(about, meta, label, id, source, length, target, )
        self.length = _cast(int, length)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if NetworkIntEdge.subclass:
            return NetworkIntEdge.subclass(*args_, **kwargs_)
        else:
            return NetworkIntEdge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_length(self): return self.length
    def set_length(self, length): self.length = length
    def export(self, outfile, level, namespace_='', name_='NetworkIntEdge', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkIntEdge')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkIntEdge'):
        super(NetworkIntEdge, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkIntEdge')
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            outfile.write(' length="%s"' % self.gds_format_integer(self.length, input_name='length'))
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkIntEdge', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(NetworkIntEdge, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NetworkIntEdge'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            showIndent(outfile, level)
            outfile.write('length = %d,\n' % (self.length,))
        super(NetworkIntEdge, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NetworkIntEdge, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('length', node)
        if value is not None and 'length' not in already_processed:
            already_processed.append('length')
            try:
                self.length = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        super(NetworkIntEdge, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class NetworkIntEdge


class NetworkFloatEdge(AbstractEdge):
    """A concrete network edge implementation, with float edge."""
    subclass = None
    superclass = AbstractEdge
    def __init__(self, about=None, meta=None, label=None, id=None, source=None, length=None, target=None, valueOf_=None):
        super(NetworkFloatEdge, self).__init__(about, meta, label, id, source, length, target, )
        self.length = _cast(float, length)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if NetworkFloatEdge.subclass:
            return NetworkFloatEdge.subclass(*args_, **kwargs_)
        else:
            return NetworkFloatEdge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_length(self): return self.length
    def set_length(self, length): self.length = length
    def export(self, outfile, level, namespace_='', name_='NetworkFloatEdge', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkFloatEdge')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkFloatEdge'):
        super(NetworkFloatEdge, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkFloatEdge')
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            outfile.write(' length="%s"' % self.gds_format_double(self.length, input_name='length'))
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkFloatEdge', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(NetworkFloatEdge, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NetworkFloatEdge'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.length is not None and 'length' not in already_processed:
            already_processed.append('length')
            showIndent(outfile, level)
            outfile.write('length = %e,\n' % (self.length,))
        super(NetworkFloatEdge, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NetworkFloatEdge, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('length', node)
        if value is not None and 'length' not in already_processed:
            already_processed.append('length')
            try:
                self.length = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (length): %s' % exp)
        super(NetworkFloatEdge, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class NetworkFloatEdge


class AbstractNode(OptionalTaxonLinked):
    """The AbstractNode superclass is what concrete nodes inherit from by
    restriction. It represents a node element much like that of
    GraphML, i.e. an element that is connected into a tree by edge
    elements."""
    subclass = None
    superclass = OptionalTaxonLinked
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, root=False, valueOf_=None):
        super(AbstractNode, self).__init__(about, meta, label, id, otu, )
        self.root = _cast(bool, root)
        pass
    def factory(*args_, **kwargs_):
        if AbstractNode.subclass:
            return AbstractNode.subclass(*args_, **kwargs_)
        else:
            return AbstractNode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_root(self): return self.root
    def set_root(self, root): self.root = root
    def export(self, outfile, level, namespace_='', name_='AbstractNode', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractNode')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractNode"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractNode'):
        super(AbstractNode, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractNode')
        if self.root is not None and 'root' not in already_processed:
            already_processed.append('root')
            outfile.write(' root="%s"' % self.gds_format_boolean(self.gds_str_lower(str(self.root)), input_name='root'))
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractNode', fromsubclass_=False):
        super(AbstractNode, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(AbstractNode, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractNode'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.root is not None and 'root' not in already_processed:
            already_processed.append('root')
            showIndent(outfile, level)
            outfile.write('root = %s,\n' % (self.root,))
        super(AbstractNode, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractNode, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('root', node)
        if value is not None and 'root' not in already_processed:
            already_processed.append('root')
            if value in ('true', '1'):
                self.root = True
            elif value in ('false', '0'):
                self.root = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(AbstractNode, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(AbstractNode, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class AbstractNode


class TreeNode(AbstractNode):
    """A concrete node implementation."""
    subclass = None
    superclass = AbstractNode
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, root=False, valueOf_=None):
        super(TreeNode, self).__init__(about, meta, label, id, otu, root, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if TreeNode.subclass:
            return TreeNode.subclass(*args_, **kwargs_)
        else:
            return TreeNode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def export(self, outfile, level, namespace_='', name_='TreeNode', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TreeNode')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TreeNode'):
        super(TreeNode, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TreeNode')
    def exportChildren(self, outfile, level, namespace_='', name_='TreeNode', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(TreeNode, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TreeNode'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(TreeNode, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TreeNode, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(TreeNode, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class TreeNode


class Trees(TaxaLinked):
    """A concrete container for tree objects."""
    subclass = None
    superclass = TaxaLinked
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, network=None, tree=None, set=None, valueOf_=None):
        super(Trees, self).__init__(about, meta, label, id, otus, )
        if network is None:
            self.network = []
        else:
            self.network = network
        if tree is None:
            self.tree = []
        else:
            self.tree = tree
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if Trees.subclass:
            return Trees.subclass(*args_, **kwargs_)
        else:
            return Trees(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def add_network(self, value): self.network.append(value)
    def insert_network(self, index, value): self.network[index] = value
    def get_tree(self): return self.tree
    def set_tree(self, tree): self.tree = tree
    def add_tree(self, value): self.tree.append(value)
    def insert_tree(self, index, value): self.tree[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='Trees', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='Trees')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="Trees"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='Trees'):
        super(Trees, self).exportAttributes(outfile, level, already_processed, namespace_, name_='Trees')
    def exportChildren(self, outfile, level, namespace_='', name_='Trees', fromsubclass_=False):
        super(Trees, self).exportChildren(outfile, level, namespace_, name_, True)
        for network_ in self.get_network():
            network_.export(outfile, level, namespace_, name_='network')
        for tree_ in self.get_tree():
            tree_.export(outfile, level, namespace_, name_='tree')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.network or
            self.tree or
            self.set or
            super(Trees, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='Trees'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(Trees, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(Trees, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('network=[\n')
        level += 1
        for network_ in self.network:
            showIndent(outfile, level)
            outfile.write('model_.AbstractNetwork(\n')
            network_.exportLiteral(outfile, level, name_='AbstractNetwork')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('tree=[\n')
        level += 1
        for tree_ in self.tree:
            showIndent(outfile, level)
            outfile.write('model_.AbstractTree(\n')
            tree_.exportLiteral(outfile, level, name_='AbstractTree')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.TreeAndNetworkSet(\n')
            set_.exportLiteral(outfile, level, name_='TreeAndNetworkSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(Trees, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'network':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <network> element')
            self.network.append(obj_)
        elif nodeName_ == 'tree':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <tree> element')
            self.tree.append(obj_)
        elif nodeName_ == 'set':
            obj_ = TreeAndNetworkSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
        super(Trees, self).buildChildren(child_, node, nodeName_, True)
# end class Trees


class StandardChar(AbstractChar):
    """A concrete implementation of the char element, which requires a
    states attribute to refer to a set of defined states"""
    subclass = None
    superclass = AbstractChar
    def __init__(self, about=None, meta=None, label=None, id=None, tokens=None, states=None, codon=None, valueOf_=None):
        super(StandardChar, self).__init__(about, meta, label, id, tokens, states, codon, )
        self.tokens = _cast(None, tokens)
        self.states = _cast(None, states)
        self.codon = _cast(None, codon)
        self.id = _cast(None, id)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if StandardChar.subclass:
            return StandardChar.subclass(*args_, **kwargs_)
        else:
            return StandardChar(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_tokens(self): return self.tokens
    def set_tokens(self, tokens): self.tokens = tokens
    def validate_MSTokenLength(self, value):
        # Validate type MSTokenLength, a restriction on xs:positiveInteger.
        pass
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def get_codon(self): return self.codon
    def set_codon(self, codon): self.codon = codon
    def validate_CodonPosition(self, value):
        # Validate type CodonPosition, a restriction on xs:nonNegativeInteger.
        pass
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='', name_='StandardChar', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardChar')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardChar'):
        super(StandardChar, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardChar')
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            outfile.write(' tokens=%s' % (quote_attrib(self.tokens), ))
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            outfile.write(' states=%s' % (self.gds_format_string(quote_attrib(self.states).encode(ExternalEncoding), input_name='states'), ))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            outfile.write(' codon=%s' % (quote_attrib(self.codon), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StandardChar', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(StandardChar, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardChar'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            showIndent(outfile, level)
            outfile.write('tokens = %d,\n' % (self.tokens,))
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            showIndent(outfile, level)
            outfile.write('states = "%s",\n' % (self.states,))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            showIndent(outfile, level)
            outfile.write('codon = %d,\n' % (self.codon,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
        super(StandardChar, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardChar, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tokens', node)
        if value is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            try:
                self.tokens = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.tokens <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_MSTokenLength(self.tokens)    # validate type MSTokenLength
        value = find_attr_value_('states', node)
        if value is not None and 'states' not in already_processed:
            already_processed.append('states')
            self.states = value
        value = find_attr_value_('codon', node)
        if value is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            try:
                self.codon = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.codon < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_CodonPosition(self.codon)    # validate type CodonPosition
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        super(StandardChar, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class StandardChar


class StandardStates(AbstractStates):
    """A container for a set of states."""
    subclass = None
    superclass = AbstractStates
    def __init__(self, about=None, meta=None, label=None, id=None, state=None, polymorphic_state_set=None, uncertain_state_set=None, set=None, valueOf_=None):
        super(StandardStates, self).__init__(about, meta, label, id, state, polymorphic_state_set, uncertain_state_set, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if state is None:
            self.state = []
        else:
            self.state = state
        if polymorphic_state_set is None:
            self.polymorphic_state_set = []
        else:
            self.polymorphic_state_set = polymorphic_state_set
        if uncertain_state_set is None:
            self.uncertain_state_set = []
        else:
            self.uncertain_state_set = uncertain_state_set
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if StandardStates.subclass:
            return StandardStates.subclass(*args_, **kwargs_)
        else:
            return StandardStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def add_state(self, value): self.state.append(value)
    def insert_state(self, index, value): self.state[index] = value
    def get_polymorphic_state_set(self): return self.polymorphic_state_set
    def set_polymorphic_state_set(self, polymorphic_state_set): self.polymorphic_state_set = polymorphic_state_set
    def add_polymorphic_state_set(self, value): self.polymorphic_state_set.append(value)
    def insert_polymorphic_state_set(self, index, value): self.polymorphic_state_set[index] = value
    def get_uncertain_state_set(self): return self.uncertain_state_set
    def set_uncertain_state_set(self, uncertain_state_set): self.uncertain_state_set = uncertain_state_set
    def add_uncertain_state_set(self, value): self.uncertain_state_set.append(value)
    def insert_uncertain_state_set(self, index, value): self.uncertain_state_set[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='StandardStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardStates'):
        super(StandardStates, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardStates')
    def exportChildren(self, outfile, level, namespace_='', name_='StandardStates', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for state_ in self.state:
            state_.export(outfile, level, namespace_, name_='state')
        for polymorphic_state_set_ in self.polymorphic_state_set:
            polymorphic_state_set_.export(outfile, level, namespace_, name_='polymorphic_state_set')
        for uncertain_state_set_ in self.uncertain_state_set:
            uncertain_state_set_.export(outfile, level, namespace_, name_='uncertain_state_set')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.state or
            self.polymorphic_state_set or
            self.uncertain_state_set or
            self.set or
            super(StandardStates, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StandardStates, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardStates, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('state=[\n')
        level += 1
        for state_ in self.state:
            showIndent(outfile, level)
            outfile.write('model_.StandardState(\n')
            state_.exportLiteral(outfile, level, name_='StandardState')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('polymorphic_state_set=[\n')
        level += 1
        for polymorphic_state_set_ in self.polymorphic_state_set:
            showIndent(outfile, level)
            outfile.write('model_.StandardPolymorphicStateSet(\n')
            polymorphic_state_set_.exportLiteral(outfile, level, name_='StandardPolymorphicStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('uncertain_state_set=[\n')
        level += 1
        for uncertain_state_set_ in self.uncertain_state_set:
            showIndent(outfile, level)
            outfile.write('model_.StandardUncertainStateSet(\n')
            uncertain_state_set_.exportLiteral(outfile, level, name_='StandardUncertainStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.StateSet(\n')
            set_.exportLiteral(outfile, level, name_='StateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StandardStates, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'state':
            obj_ = StandardState.factory()
            obj_.build(child_)
            self.state.append(obj_)
        elif nodeName_ == 'polymorphic_state_set':
            obj_ = StandardPolymorphicStateSet.factory()
            obj_.build(child_)
            self.polymorphic_state_set.append(obj_)
        elif nodeName_ == 'uncertain_state_set':
            obj_ = StandardUncertainStateSet.factory()
            obj_.build(child_)
            self.uncertain_state_set.append(obj_)
        elif nodeName_ == 'set':
            obj_ = StateSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class StandardStates


class StandardState(AbstractState):
    """This is a concrete implementation of the state element, which
    requires a symbol element, in this case restricted to integers,
    and optional mapping elements to refer to other states."""
    subclass = None
    superclass = AbstractState
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, valueOf_=None):
        super(StandardState, self).__init__(about, meta, label, id, symbol, )
        self.symbol = _cast(None, symbol)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if StandardState.subclass:
            return StandardState.subclass(*args_, **kwargs_)
        else:
            return StandardState(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def validate_StandardToken(self, value):
        # Validate type StandardToken, a restriction on xs:integer.
        pass
    def export(self, outfile, level, namespace_='', name_='StandardState', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardState')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardState'):
        super(StandardState, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardState')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (quote_attrib(self.symbol), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StandardState', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(StandardState, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardState'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = %d,\n' % (self.symbol,))
        super(StandardState, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardState, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            try:
                self.symbol = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            self.validate_StandardToken(self.symbol)    # validate type StandardToken
        super(StandardState, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class StandardState


class RNAChar(AbstractChar):
    """A concrete implementation of the AbstractChar element, i.e. a single
    column in an alignment."""
    subclass = None
    superclass = AbstractChar
    def __init__(self, about=None, meta=None, label=None, id=None, tokens=None, states=None, codon=None, valueOf_=None):
        super(RNAChar, self).__init__(about, meta, label, id, tokens, states, codon, )
        self.tokens = _cast(None, tokens)
        self.states = _cast(None, states)
        self.codon = _cast(None, codon)
        self.id = _cast(None, id)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if RNAChar.subclass:
            return RNAChar.subclass(*args_, **kwargs_)
        else:
            return RNAChar(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_tokens(self): return self.tokens
    def set_tokens(self, tokens): self.tokens = tokens
    def validate_MSTokenLength(self, value):
        # Validate type MSTokenLength, a restriction on xs:positiveInteger.
        pass
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def get_codon(self): return self.codon
    def set_codon(self, codon): self.codon = codon
    def validate_CodonPosition(self, value):
        # Validate type CodonPosition, a restriction on xs:nonNegativeInteger.
        pass
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='', name_='RNAChar', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RNAChar')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RNAChar'):
        super(RNAChar, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RNAChar')
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            outfile.write(' tokens=%s' % (quote_attrib(self.tokens), ))
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            outfile.write(' states=%s' % (self.gds_format_string(quote_attrib(self.states).encode(ExternalEncoding), input_name='states'), ))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            outfile.write(' codon=%s' % (quote_attrib(self.codon), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RNAChar', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(RNAChar, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RNAChar'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            showIndent(outfile, level)
            outfile.write('tokens = %d,\n' % (self.tokens,))
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            showIndent(outfile, level)
            outfile.write('states = "%s",\n' % (self.states,))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            showIndent(outfile, level)
            outfile.write('codon = %d,\n' % (self.codon,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
        super(RNAChar, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RNAChar, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tokens', node)
        if value is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            try:
                self.tokens = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.tokens <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_MSTokenLength(self.tokens)    # validate type MSTokenLength
        value = find_attr_value_('states', node)
        if value is not None and 'states' not in already_processed:
            already_processed.append('states')
            self.states = value
        value = find_attr_value_('codon', node)
        if value is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            try:
                self.codon = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.codon < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_CodonPosition(self.codon)    # validate type CodonPosition
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        super(RNAChar, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class RNAChar


class RNAStates(AbstractStates):
    """A container for a set of states."""
    subclass = None
    superclass = AbstractStates
    def __init__(self, about=None, meta=None, label=None, id=None, state=None, polymorphic_state_set=None, uncertain_state_set=None, set=None, valueOf_=None):
        super(RNAStates, self).__init__(about, meta, label, id, state, polymorphic_state_set, uncertain_state_set, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if state is None:
            self.state = []
        else:
            self.state = state
        if polymorphic_state_set is None:
            self.polymorphic_state_set = []
        else:
            self.polymorphic_state_set = polymorphic_state_set
        if uncertain_state_set is None:
            self.uncertain_state_set = []
        else:
            self.uncertain_state_set = uncertain_state_set
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if RNAStates.subclass:
            return RNAStates.subclass(*args_, **kwargs_)
        else:
            return RNAStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def add_state(self, value): self.state.append(value)
    def insert_state(self, index, value): self.state[index] = value
    def get_polymorphic_state_set(self): return self.polymorphic_state_set
    def set_polymorphic_state_set(self, polymorphic_state_set): self.polymorphic_state_set = polymorphic_state_set
    def add_polymorphic_state_set(self, value): self.polymorphic_state_set.append(value)
    def insert_polymorphic_state_set(self, index, value): self.polymorphic_state_set[index] = value
    def get_uncertain_state_set(self): return self.uncertain_state_set
    def set_uncertain_state_set(self, uncertain_state_set): self.uncertain_state_set = uncertain_state_set
    def add_uncertain_state_set(self, value): self.uncertain_state_set.append(value)
    def insert_uncertain_state_set(self, index, value): self.uncertain_state_set[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='RNAStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RNAStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RNAStates'):
        super(RNAStates, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RNAStates')
    def exportChildren(self, outfile, level, namespace_='', name_='RNAStates', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for state_ in self.state:
            state_.export(outfile, level, namespace_, name_='state')
        for polymorphic_state_set_ in self.polymorphic_state_set:
            polymorphic_state_set_.export(outfile, level, namespace_, name_='polymorphic_state_set')
        for uncertain_state_set_ in self.uncertain_state_set:
            uncertain_state_set_.export(outfile, level, namespace_, name_='uncertain_state_set')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.state or
            self.polymorphic_state_set or
            self.uncertain_state_set or
            self.set or
            super(RNAStates, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RNAStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RNAStates, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RNAStates, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('state=[\n')
        level += 1
        for state_ in self.state:
            showIndent(outfile, level)
            outfile.write('model_.RNAState(\n')
            state_.exportLiteral(outfile, level, name_='RNAState')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('polymorphic_state_set=[\n')
        level += 1
        for polymorphic_state_set_ in self.polymorphic_state_set:
            showIndent(outfile, level)
            outfile.write('model_.RNAPolymorphicStateSet(\n')
            polymorphic_state_set_.exportLiteral(outfile, level, name_='RNAPolymorphicStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('uncertain_state_set=[\n')
        level += 1
        for uncertain_state_set_ in self.uncertain_state_set:
            showIndent(outfile, level)
            outfile.write('model_.RNAUncertainStateSet(\n')
            uncertain_state_set_.exportLiteral(outfile, level, name_='RNAUncertainStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.StateSet(\n')
            set_.exportLiteral(outfile, level, name_='StateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RNAStates, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'state':
            obj_ = RNAState.factory()
            obj_.build(child_)
            self.state.append(obj_)
        elif nodeName_ == 'polymorphic_state_set':
            obj_ = RNAPolymorphicStateSet.factory()
            obj_.build(child_)
            self.polymorphic_state_set.append(obj_)
        elif nodeName_ == 'uncertain_state_set':
            obj_ = RNAUncertainStateSet.factory()
            obj_.build(child_)
            self.uncertain_state_set.append(obj_)
        elif nodeName_ == 'set':
            obj_ = StateSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class RNAStates


class RNAState(AbstractState):
    """This is a concrete implementation of the state element, which
    requires a symbol attribute, in this case restricted to
    RNAToken, i.e. a single IUPAC nucleotide symbol, and optional
    mapping elements to refer to other states."""
    subclass = None
    superclass = AbstractState
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, valueOf_=None):
        super(RNAState, self).__init__(about, meta, label, id, symbol, )
        self.symbol = _cast(None, symbol)
        pass
    def factory(*args_, **kwargs_):
        if RNAState.subclass:
            return RNAState.subclass(*args_, **kwargs_)
        else:
            return RNAState(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def validate_RNAToken(self, value):
        # Validate type RNAToken, a restriction on AbstractSymbol.
        pass
    def export(self, outfile, level, namespace_='', name_='RNAState', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RNAState')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RNAState'):
        super(RNAState, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RNAState')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (quote_attrib(self.symbol), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RNAState', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            super(RNAState, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RNAState'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = "%s",\n' % (self.symbol,))
        super(RNAState, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RNAState, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            self.symbol = value
            self.validate_RNAToken(self.symbol)    # validate type RNAToken
        super(RNAState, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class RNAState


class RestrictionChar(AbstractChar):
    """A concrete implementation of the char element, which requires a
    unique identifier and a state set reference."""
    subclass = None
    superclass = AbstractChar
    def __init__(self, about=None, meta=None, label=None, id=None, tokens=None, states=None, codon=None, valueOf_=None):
        super(RestrictionChar, self).__init__(about, meta, label, id, tokens, states, codon, )
        self.tokens = _cast(None, tokens)
        self.states = _cast(None, states)
        self.codon = _cast(None, codon)
        self.id = _cast(None, id)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if RestrictionChar.subclass:
            return RestrictionChar.subclass(*args_, **kwargs_)
        else:
            return RestrictionChar(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_tokens(self): return self.tokens
    def set_tokens(self, tokens): self.tokens = tokens
    def validate_MSTokenLength(self, value):
        # Validate type MSTokenLength, a restriction on xs:positiveInteger.
        pass
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def get_codon(self): return self.codon
    def set_codon(self, codon): self.codon = codon
    def validate_CodonPosition(self, value):
        # Validate type CodonPosition, a restriction on xs:nonNegativeInteger.
        pass
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='', name_='RestrictionChar', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionChar')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RestrictionChar'):
        super(RestrictionChar, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionChar')
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            outfile.write(' tokens=%s' % (quote_attrib(self.tokens), ))
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            outfile.write(' states=%s' % (self.gds_format_string(quote_attrib(self.states).encode(ExternalEncoding), input_name='states'), ))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            outfile.write(' codon=%s' % (quote_attrib(self.codon), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RestrictionChar', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(RestrictionChar, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RestrictionChar'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            showIndent(outfile, level)
            outfile.write('tokens = %d,\n' % (self.tokens,))
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            showIndent(outfile, level)
            outfile.write('states = "%s",\n' % (self.states,))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            showIndent(outfile, level)
            outfile.write('codon = %d,\n' % (self.codon,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
        super(RestrictionChar, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RestrictionChar, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tokens', node)
        if value is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            try:
                self.tokens = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.tokens <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_MSTokenLength(self.tokens)    # validate type MSTokenLength
        value = find_attr_value_('states', node)
        if value is not None and 'states' not in already_processed:
            already_processed.append('states')
            self.states = value
        value = find_attr_value_('codon', node)
        if value is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            try:
                self.codon = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.codon < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_CodonPosition(self.codon)    # validate type CodonPosition
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        super(RestrictionChar, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class RestrictionChar


class RestrictionStates(AbstractStates):
    """A container for a set of states."""
    subclass = None
    superclass = AbstractStates
    def __init__(self, about=None, meta=None, label=None, id=None, state=None, polymorphic_state_set=None, uncertain_state_set=None, set=None, valueOf_=None):
        super(RestrictionStates, self).__init__(about, meta, label, id, state, polymorphic_state_set, uncertain_state_set, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if state is None:
            self.state = []
        else:
            self.state = state
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if RestrictionStates.subclass:
            return RestrictionStates.subclass(*args_, **kwargs_)
        else:
            return RestrictionStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def add_state(self, value): self.state.append(value)
    def insert_state(self, index, value): self.state[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='RestrictionStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RestrictionStates'):
        super(RestrictionStates, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionStates')
    def exportChildren(self, outfile, level, namespace_='', name_='RestrictionStates', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for state_ in self.state:
            state_.export(outfile, level, namespace_, name_='state')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.state or
            self.set or
            super(RestrictionStates, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RestrictionStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RestrictionStates, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RestrictionStates, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('state=[\n')
        level += 1
        for state_ in self.state:
            showIndent(outfile, level)
            outfile.write('model_.RestrictionState(\n')
            state_.exportLiteral(outfile, level, name_='RestrictionState')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.StateSet(\n')
            set_.exportLiteral(outfile, level, name_='StateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RestrictionStates, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'state':
            obj_ = RestrictionState.factory()
            obj_.build(child_)
            self.state.append(obj_)
        elif nodeName_ == 'set':
            obj_ = StateSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class RestrictionStates


class RestrictionState(AbstractState):
    """This is a concrete implementation of the state element, which
    requires a symbol element, in this case restricted to 0/1."""
    subclass = None
    superclass = AbstractState
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, valueOf_=None):
        super(RestrictionState, self).__init__(about, meta, label, id, symbol, )
        self.symbol = _cast(None, symbol)
        pass
    def factory(*args_, **kwargs_):
        if RestrictionState.subclass:
            return RestrictionState.subclass(*args_, **kwargs_)
        else:
            return RestrictionState(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def validate_RestrictionToken(self, value):
        # Validate type RestrictionToken, a restriction on xs:integer.
        pass
    def export(self, outfile, level, namespace_='', name_='RestrictionState', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionState')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RestrictionState'):
        super(RestrictionState, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionState')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (quote_attrib(self.symbol), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RestrictionState', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            super(RestrictionState, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RestrictionState'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = %d,\n' % (self.symbol,))
        super(RestrictionState, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RestrictionState, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            try:
                self.symbol = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            self.validate_RestrictionToken(self.symbol)    # validate type RestrictionToken
        super(RestrictionState, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class RestrictionState


class AAState(AbstractState):
    """This is a concrete implementation of the state element, which
    requires a symbol element, in this case restricted to AAToken,
    i.e. a single IUPAC amino acid symbol, and optional mapping
    elements to refer to other states."""
    subclass = None
    superclass = AbstractState
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, valueOf_=None):
        super(AAState, self).__init__(about, meta, label, id, symbol, )
        self.symbol = _cast(None, symbol)
        pass
    def factory(*args_, **kwargs_):
        if AAState.subclass:
            return AAState.subclass(*args_, **kwargs_)
        else:
            return AAState(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def validate_AAToken(self, value):
        # Validate type AAToken, a restriction on AbstractSymbol.
        pass
    def export(self, outfile, level, namespace_='', name_='AAState', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AAState')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AAState'):
        super(AAState, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AAState')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (quote_attrib(self.symbol), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AAState', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            super(AAState, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AAState'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = "%s",\n' % (self.symbol,))
        super(AAState, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AAState, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            self.symbol = value
            self.validate_AAToken(self.symbol)    # validate type AAToken
        super(AAState, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class AAState


class AAStates(AbstractStates):
    """A container for a set of states."""
    subclass = None
    superclass = AbstractStates
    def __init__(self, about=None, meta=None, label=None, id=None, state=None, polymorphic_state_set=None, uncertain_state_set=None, set=None, valueOf_=None):
        super(AAStates, self).__init__(about, meta, label, id, state, polymorphic_state_set, uncertain_state_set, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if state is None:
            self.state = []
        else:
            self.state = state
        if polymorphic_state_set is None:
            self.polymorphic_state_set = []
        else:
            self.polymorphic_state_set = polymorphic_state_set
        if uncertain_state_set is None:
            self.uncertain_state_set = []
        else:
            self.uncertain_state_set = uncertain_state_set
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AAStates.subclass:
            return AAStates.subclass(*args_, **kwargs_)
        else:
            return AAStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def add_state(self, value): self.state.append(value)
    def insert_state(self, index, value): self.state[index] = value
    def get_polymorphic_state_set(self): return self.polymorphic_state_set
    def set_polymorphic_state_set(self, polymorphic_state_set): self.polymorphic_state_set = polymorphic_state_set
    def add_polymorphic_state_set(self, value): self.polymorphic_state_set.append(value)
    def insert_polymorphic_state_set(self, index, value): self.polymorphic_state_set[index] = value
    def get_uncertain_state_set(self): return self.uncertain_state_set
    def set_uncertain_state_set(self, uncertain_state_set): self.uncertain_state_set = uncertain_state_set
    def add_uncertain_state_set(self, value): self.uncertain_state_set.append(value)
    def insert_uncertain_state_set(self, index, value): self.uncertain_state_set[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AAStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AAStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AAStates'):
        super(AAStates, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AAStates')
    def exportChildren(self, outfile, level, namespace_='', name_='AAStates', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for state_ in self.state:
            state_.export(outfile, level, namespace_, name_='state')
        for polymorphic_state_set_ in self.polymorphic_state_set:
            polymorphic_state_set_.export(outfile, level, namespace_, name_='polymorphic_state_set')
        for uncertain_state_set_ in self.uncertain_state_set:
            uncertain_state_set_.export(outfile, level, namespace_, name_='uncertain_state_set')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.state or
            self.polymorphic_state_set or
            self.uncertain_state_set or
            self.set or
            super(AAStates, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AAStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AAStates, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AAStates, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('state=[\n')
        level += 1
        for state_ in self.state:
            showIndent(outfile, level)
            outfile.write('model_.AAState(\n')
            state_.exportLiteral(outfile, level, name_='AAState')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('polymorphic_state_set=[\n')
        level += 1
        for polymorphic_state_set_ in self.polymorphic_state_set:
            showIndent(outfile, level)
            outfile.write('model_.AAPolymorphicStateSet(\n')
            polymorphic_state_set_.exportLiteral(outfile, level, name_='AAPolymorphicStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('uncertain_state_set=[\n')
        level += 1
        for uncertain_state_set_ in self.uncertain_state_set:
            showIndent(outfile, level)
            outfile.write('model_.AAUncertainStateSet(\n')
            uncertain_state_set_.exportLiteral(outfile, level, name_='AAUncertainStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.StateSet(\n')
            set_.exportLiteral(outfile, level, name_='StateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AAStates, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'state':
            obj_ = AAState.factory()
            obj_.build(child_)
            self.state.append(obj_)
        elif nodeName_ == 'polymorphic_state_set':
            obj_ = AAPolymorphicStateSet.factory()
            obj_.build(child_)
            self.polymorphic_state_set.append(obj_)
        elif nodeName_ == 'uncertain_state_set':
            obj_ = AAUncertainStateSet.factory()
            obj_.build(child_)
            self.uncertain_state_set.append(obj_)
        elif nodeName_ == 'set':
            obj_ = StateSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class AAStates


class AAChar(AbstractChar):
    """A concrete implementation of the AbstractChar element."""
    subclass = None
    superclass = AbstractChar
    def __init__(self, about=None, meta=None, label=None, id=None, tokens=None, states=None, codon=None, valueOf_=None):
        super(AAChar, self).__init__(about, meta, label, id, tokens, states, codon, )
        self.tokens = _cast(None, tokens)
        self.states = _cast(None, states)
        self.codon = _cast(None, codon)
        self.id = _cast(None, id)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if AAChar.subclass:
            return AAChar.subclass(*args_, **kwargs_)
        else:
            return AAChar(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_tokens(self): return self.tokens
    def set_tokens(self, tokens): self.tokens = tokens
    def validate_MSTokenLength(self, value):
        # Validate type MSTokenLength, a restriction on xs:positiveInteger.
        pass
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def get_codon(self): return self.codon
    def set_codon(self, codon): self.codon = codon
    def validate_CodonPosition(self, value):
        # Validate type CodonPosition, a restriction on xs:nonNegativeInteger.
        pass
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='', name_='AAChar', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AAChar')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AAChar'):
        super(AAChar, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AAChar')
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            outfile.write(' tokens=%s' % (quote_attrib(self.tokens), ))
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            outfile.write(' states=%s' % (self.gds_format_string(quote_attrib(self.states).encode(ExternalEncoding), input_name='states'), ))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            outfile.write(' codon=%s' % (quote_attrib(self.codon), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AAChar', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(AAChar, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AAChar'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            showIndent(outfile, level)
            outfile.write('tokens = %d,\n' % (self.tokens,))
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            showIndent(outfile, level)
            outfile.write('states = "%s",\n' % (self.states,))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            showIndent(outfile, level)
            outfile.write('codon = %d,\n' % (self.codon,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
        super(AAChar, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AAChar, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tokens', node)
        if value is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            try:
                self.tokens = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.tokens <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_MSTokenLength(self.tokens)    # validate type MSTokenLength
        value = find_attr_value_('states', node)
        if value is not None and 'states' not in already_processed:
            already_processed.append('states')
            self.states = value
        value = find_attr_value_('codon', node)
        if value is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            try:
                self.codon = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.codon < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_CodonPosition(self.codon)    # validate type CodonPosition
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        super(AAChar, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class AAChar


class DNAChar(AbstractChar):
    """A concrete implementation of the AbstractChar element."""
    subclass = None
    superclass = AbstractChar
    def __init__(self, about=None, meta=None, label=None, id=None, tokens=None, states=None, codon=None, valueOf_=None):
        super(DNAChar, self).__init__(about, meta, label, id, tokens, states, codon, )
        self.tokens = _cast(None, tokens)
        self.states = _cast(None, states)
        self.codon = _cast(None, codon)
        self.id = _cast(None, id)
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if DNAChar.subclass:
            return DNAChar.subclass(*args_, **kwargs_)
        else:
            return DNAChar(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_tokens(self): return self.tokens
    def set_tokens(self, tokens): self.tokens = tokens
    def validate_MSTokenLength(self, value):
        # Validate type MSTokenLength, a restriction on xs:positiveInteger.
        pass
    def get_states(self): return self.states
    def set_states(self, states): self.states = states
    def get_codon(self): return self.codon
    def set_codon(self, codon): self.codon = codon
    def validate_CodonPosition(self, value):
        # Validate type CodonPosition, a restriction on xs:nonNegativeInteger.
        pass
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='', name_='DNAChar', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNAChar')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNAChar'):
        super(DNAChar, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DNAChar')
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            outfile.write(' tokens=%s' % (quote_attrib(self.tokens), ))
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            outfile.write(' states=%s' % (self.gds_format_string(quote_attrib(self.states).encode(ExternalEncoding), input_name='states'), ))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            outfile.write(' codon=%s' % (quote_attrib(self.codon), ))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id=%s' % (self.gds_format_string(quote_attrib(self.id).encode(ExternalEncoding), input_name='id'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='DNAChar', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(DNAChar, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DNAChar'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tokens is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            showIndent(outfile, level)
            outfile.write('tokens = %d,\n' % (self.tokens,))
        if self.states is not None and 'states' not in already_processed:
            already_processed.append('states')
            showIndent(outfile, level)
            outfile.write('states = "%s",\n' % (self.states,))
        if self.codon is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            showIndent(outfile, level)
            outfile.write('codon = %d,\n' % (self.codon,))
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = "%s",\n' % (self.id,))
        super(DNAChar, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DNAChar, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tokens', node)
        if value is not None and 'tokens' not in already_processed:
            already_processed.append('tokens')
            try:
                self.tokens = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.tokens <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
            self.validate_MSTokenLength(self.tokens)    # validate type MSTokenLength
        value = find_attr_value_('states', node)
        if value is not None and 'states' not in already_processed:
            already_processed.append('states')
            self.states = value
        value = find_attr_value_('codon', node)
        if value is not None and 'codon' not in already_processed:
            already_processed.append('codon')
            try:
                self.codon = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.codon < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
            self.validate_CodonPosition(self.codon)    # validate type CodonPosition
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            self.id = value
        super(DNAChar, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class DNAChar


class DNAStates(AbstractStates):
    """A container for a set of states."""
    subclass = None
    superclass = AbstractStates
    def __init__(self, about=None, meta=None, label=None, id=None, state=None, polymorphic_state_set=None, uncertain_state_set=None, set=None, valueOf_=None):
        super(DNAStates, self).__init__(about, meta, label, id, state, polymorphic_state_set, uncertain_state_set, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if state is None:
            self.state = []
        else:
            self.state = state
        if polymorphic_state_set is None:
            self.polymorphic_state_set = []
        else:
            self.polymorphic_state_set = polymorphic_state_set
        if uncertain_state_set is None:
            self.uncertain_state_set = []
        else:
            self.uncertain_state_set = uncertain_state_set
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if DNAStates.subclass:
            return DNAStates.subclass(*args_, **kwargs_)
        else:
            return DNAStates(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def add_state(self, value): self.state.append(value)
    def insert_state(self, index, value): self.state[index] = value
    def get_polymorphic_state_set(self): return self.polymorphic_state_set
    def set_polymorphic_state_set(self, polymorphic_state_set): self.polymorphic_state_set = polymorphic_state_set
    def add_polymorphic_state_set(self, value): self.polymorphic_state_set.append(value)
    def insert_polymorphic_state_set(self, index, value): self.polymorphic_state_set[index] = value
    def get_uncertain_state_set(self): return self.uncertain_state_set
    def set_uncertain_state_set(self, uncertain_state_set): self.uncertain_state_set = uncertain_state_set
    def add_uncertain_state_set(self, value): self.uncertain_state_set.append(value)
    def insert_uncertain_state_set(self, index, value): self.uncertain_state_set[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='DNAStates', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNAStates')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNAStates'):
        super(DNAStates, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DNAStates')
    def exportChildren(self, outfile, level, namespace_='', name_='DNAStates', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for state_ in self.state:
            state_.export(outfile, level, namespace_, name_='state')
        for polymorphic_state_set_ in self.polymorphic_state_set:
            polymorphic_state_set_.export(outfile, level, namespace_, name_='polymorphic_state_set')
        for uncertain_state_set_ in self.uncertain_state_set:
            uncertain_state_set_.export(outfile, level, namespace_, name_='uncertain_state_set')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.state or
            self.polymorphic_state_set or
            self.uncertain_state_set or
            self.set or
            super(DNAStates, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DNAStates'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DNAStates, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DNAStates, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('state=[\n')
        level += 1
        for state_ in self.state:
            showIndent(outfile, level)
            outfile.write('model_.DNAState(\n')
            state_.exportLiteral(outfile, level, name_='DNAState')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('polymorphic_state_set=[\n')
        level += 1
        for polymorphic_state_set_ in self.polymorphic_state_set:
            showIndent(outfile, level)
            outfile.write('model_.DNAPolymorphicStateSet(\n')
            polymorphic_state_set_.exportLiteral(outfile, level, name_='DNAPolymorphicStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('uncertain_state_set=[\n')
        level += 1
        for uncertain_state_set_ in self.uncertain_state_set:
            showIndent(outfile, level)
            outfile.write('model_.DNAUncertainStateSet(\n')
            uncertain_state_set_.exportLiteral(outfile, level, name_='DNAUncertainStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.StateSet(\n')
            set_.exportLiteral(outfile, level, name_='StateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DNAStates, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'state':
            obj_ = DNAState.factory()
            obj_.build(child_)
            self.state.append(obj_)
        elif nodeName_ == 'polymorphic_state_set':
            obj_ = DNAPolymorphicStateSet.factory()
            obj_.build(child_)
            self.polymorphic_state_set.append(obj_)
        elif nodeName_ == 'uncertain_state_set':
            obj_ = DNAUncertainStateSet.factory()
            obj_.build(child_)
            self.uncertain_state_set.append(obj_)
        elif nodeName_ == 'set':
            obj_ = StateSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class DNAStates


class DNAState(AbstractState):
    """This is a concrete implementation of the state element, which
    requires a symbol element, in this case restricted to DNAToken,
    i.e. a single IUPAC nucleotide symbol, and optional mapping
    elements to refer to other states."""
    subclass = None
    superclass = AbstractState
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, valueOf_=None):
        super(DNAState, self).__init__(about, meta, label, id, symbol, )
        self.symbol = _cast(None, symbol)
        pass
    def factory(*args_, **kwargs_):
        if DNAState.subclass:
            return DNAState.subclass(*args_, **kwargs_)
        else:
            return DNAState(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def validate_DNAToken(self, value):
        # Validate type DNAToken, a restriction on AbstractSymbol.
        pass
    def export(self, outfile, level, namespace_='', name_='DNAState', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNAState')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNAState'):
        super(DNAState, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DNAState')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (quote_attrib(self.symbol), ))
    def exportChildren(self, outfile, level, namespace_='', name_='DNAState', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (
            super(DNAState, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DNAState'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = "%s",\n' % (self.symbol,))
        super(DNAState, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DNAState, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            self.symbol = value
            self.validate_DNAToken(self.symbol)    # validate type DNAToken
        super(DNAState, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class DNAState


class AbstractBlock(TaxaLinked):
    """The AbstractBlock is the superclass for blocks that contain an
    element structure of type AbstractFormat."""
    subclass = None
    superclass = TaxaLinked
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, valueOf_=None):
        super(AbstractBlock, self).__init__(about, meta, label, id, otus, )
        self.format = format
    def factory(*args_, **kwargs_):
        if AbstractBlock.subclass:
            return AbstractBlock.subclass(*args_, **kwargs_)
        else:
            return AbstractBlock(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def export(self, outfile, level, namespace_='', name_='AbstractBlock', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractBlock')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractBlock"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractBlock'):
        super(AbstractBlock, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractBlock')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractBlock', fromsubclass_=False):
        super(AbstractBlock, self).exportChildren(outfile, level, namespace_, name_, True)
        format_.export(outfile, level, namespace_, name_='format')
    def hasContent_(self):
        if (
            self.format is not None or
            super(AbstractBlock, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractBlock'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractBlock, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractBlock, self).exportLiteralChildren(outfile, level, name_)
        if self.AbstractFormat is not None:
            showIndent(outfile, level)
            outfile.write('AbstractFormat=model_.AbstractFormat(\n')
            self.AbstractFormat.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractBlock, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'format':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <format> element')
            self.set_format(obj_)
        super(AbstractBlock, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractBlock


class AbstractObsRow(TaxonLinked):
    """The AbstractObsRow represents a single row in a matrix. The row must
    refer to a previously declared otu element by its id attribute
    (and must have an id itself, may have a label, and may have meta
    attachments). The row contains multiple cell elements."""
    subclass = None
    superclass = TaxonLinked
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, cell=None, set=None, valueOf_=None):
        super(AbstractObsRow, self).__init__(about, meta, label, id, otu, )
        if cell is None:
            self.cell = []
        else:
            self.cell = cell
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AbstractObsRow.subclass:
            return AbstractObsRow.subclass(*args_, **kwargs_)
        else:
            return AbstractObsRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def add_cell(self, value): self.cell.append(value)
    def insert_cell(self, index, value): self.cell[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AbstractObsRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractObsRow')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractObsRow"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractObsRow'):
        super(AbstractObsRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractObsRow')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractObsRow', fromsubclass_=False):
        super(AbstractObsRow, self).exportChildren(outfile, level, namespace_, name_, True)
        for cell_ in self.get_cell():
            cell_.export(outfile, level, namespace_, name_='cell')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.cell or
            self.set or
            super(AbstractObsRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractObsRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractObsRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractObsRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('cell=[\n')
        level += 1
        for cell_ in self.cell:
            showIndent(outfile, level)
            outfile.write('model_.AbstractObs(\n')
            cell_.exportLiteral(outfile, level, name_='AbstractObs')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CellSet(\n')
            set_.exportLiteral(outfile, level, name_='CellSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractObsRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'cell':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <cell> element')
            self.cell.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CellSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
        super(AbstractObsRow, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractObsRow


class AbstractSeqRow(TaxonLinked):
    """The AbstractSeqRow represents a single row in a matrix. The row must
    refer to a previously declared otu element by its id attribute
    (and must have an id itself, may have a label, and may have meta
    attachments). The row contains a single seq element with raw
    character data."""
    subclass = None
    superclass = TaxonLinked
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, seq=None, valueOf_=None):
        super(AbstractSeqRow, self).__init__(about, meta, label, id, otu, )
        self.seq = seq
    def factory(*args_, **kwargs_):
        if AbstractSeqRow.subclass:
            return AbstractSeqRow.subclass(*args_, **kwargs_)
        else:
            return AbstractSeqRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_seq(self): return self.seq
    def set_seq(self, seq): self.seq = seq
    def export(self, outfile, level, namespace_='', name_='AbstractSeqRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractSeqRow')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractSeqRow"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractSeqRow'):
        super(AbstractSeqRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractSeqRow')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractSeqRow', fromsubclass_=False):
        super(AbstractSeqRow, self).exportChildren(outfile, level, namespace_, name_, True)
        if self.seq:
            self.seq.export(outfile, level, namespace_, name_='seq', )
    def hasContent_(self):
        if (
            self.seq is not None or
            super(AbstractSeqRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractSeqRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractSeqRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractSeqRow, self).exportLiteralChildren(outfile, level, name_)
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('seq=model_.xs_anySimpleType(\n')
            self.seq.exportLiteral(outfile, level, name_='seq')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractSeqRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'seq':
            obj_ = xs_anySimpleType.factory()
            obj_.build(child_)
            self.set_seq(obj_)
        super(AbstractSeqRow, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractSeqRow


class AbstractUncertainStateSet(AbstractState):
    """The AbstractUncertainStateSet type is the super-class for an
    uncertain state set definition. The element has a required
    AbstractSymbol attribute that in restricted concrete subclasses
    must be of a sensible type such as a single IUPAC character. It
    may enclose zero or more AbstractMapping elements to resolve
    ambiguities."""
    subclass = None
    superclass = AbstractState
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, member=None, valueOf_=None):
        super(AbstractUncertainStateSet, self).__init__(about, meta, label, id, symbol, )
        if member is None:
            self.member = []
        else:
            self.member = member
    def factory(*args_, **kwargs_):
        if AbstractUncertainStateSet.subclass:
            return AbstractUncertainStateSet.subclass(*args_, **kwargs_)
        else:
            return AbstractUncertainStateSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_member(self): return self.member
    def set_member(self, member): self.member = member
    def add_member(self, value): self.member.append(value)
    def insert_member(self, index, value): self.member[index] = value
    def export(self, outfile, level, namespace_='', name_='AbstractUncertainStateSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractUncertainStateSet')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractUncertainStateSet"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractUncertainStateSet'):
        super(AbstractUncertainStateSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractUncertainStateSet')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractUncertainStateSet', fromsubclass_=False):
        super(AbstractUncertainStateSet, self).exportChildren(outfile, level, namespace_, name_, True)
        for member_ in self.get_member():
            member_.export(outfile, level, namespace_, name_='member')
    def hasContent_(self):
        if (
            self.member or
            super(AbstractUncertainStateSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractUncertainStateSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractUncertainStateSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractUncertainStateSet, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('member=[\n')
        level += 1
        for member_ in self.member:
            showIndent(outfile, level)
            outfile.write('model_.AbstractMapping(\n')
            member_.exportLiteral(outfile, level, name_='AbstractMapping')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractUncertainStateSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'member':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <member> element')
            self.member.append(obj_)
        super(AbstractUncertainStateSet, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractUncertainStateSet


class ContinuousMatrixObsRow(AbstractObsRow):
    """This is a row in a matrix of continuous data as granular
    obervations."""
    subclass = None
    superclass = AbstractObsRow
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, cell=None, set=None, valueOf_=None):
        super(ContinuousMatrixObsRow, self).__init__(about, meta, label, id, otu, cell, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if cell is None:
            self.cell = []
        else:
            self.cell = cell
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if ContinuousMatrixObsRow.subclass:
            return ContinuousMatrixObsRow.subclass(*args_, **kwargs_)
        else:
            return ContinuousMatrixObsRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def add_cell(self, value): self.cell.append(value)
    def insert_cell(self, index, value): self.cell[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='ContinuousMatrixObsRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousMatrixObsRow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContinuousMatrixObsRow'):
        super(ContinuousMatrixObsRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousMatrixObsRow')
    def exportChildren(self, outfile, level, namespace_='', name_='ContinuousMatrixObsRow', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for cell_ in self.cell:
            cell_.export(outfile, level, namespace_, name_='cell')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.cell or
            self.set or
            super(ContinuousMatrixObsRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ContinuousMatrixObsRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ContinuousMatrixObsRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ContinuousMatrixObsRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('cell=[\n')
        level += 1
        for cell_ in self.cell:
            showIndent(outfile, level)
            outfile.write('model_.ContinuousObs(\n')
            cell_.exportLiteral(outfile, level, name_='ContinuousObs')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CellSet(\n')
            set_.exportLiteral(outfile, level, name_='CellSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ContinuousMatrixObsRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'cell':
            obj_ = ContinuousObs.factory()
            obj_.build(child_)
            self.cell.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CellSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class ContinuousMatrixObsRow


class ContinuousMatrixSeqRow(AbstractSeqRow):
    """This is a row in a matrix of continuous data as character sequences."""
    subclass = None
    superclass = AbstractSeqRow
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, seq=None, valueOf_=None):
        super(ContinuousMatrixSeqRow, self).__init__(about, meta, label, id, otu, seq, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.seq = seq
    def factory(*args_, **kwargs_):
        if ContinuousMatrixSeqRow.subclass:
            return ContinuousMatrixSeqRow.subclass(*args_, **kwargs_)
        else:
            return ContinuousMatrixSeqRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_seq(self): return self.seq
    def set_seq(self, seq): self.seq = seq
    def validate_ContinuousSeq(self, value):
        # Validate type ContinuousSeq, a restriction on AbstractTokenList.
        pass
    def export(self, outfile, level, namespace_='', name_='ContinuousMatrixSeqRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousMatrixSeqRow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContinuousMatrixSeqRow'):
        super(ContinuousMatrixSeqRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousMatrixSeqRow')
    def exportChildren(self, outfile, level, namespace_='', name_='ContinuousMatrixSeqRow', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('<%sseq>%s</%sseq>\n' % (namespace_, self.gds_format_double_list(self.seq, input_name='seq'), namespace_))
    def hasContent_(self):
        if (
            self.meta or
            self.seq is not None or
            super(ContinuousMatrixSeqRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ContinuousMatrixSeqRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ContinuousMatrixSeqRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ContinuousMatrixSeqRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('seq=%e,\n' % self.seq)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ContinuousMatrixSeqRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'seq':
            seq_ = child_.text
            seq_ = self.gds_validate_double_list(seq_, node, 'seq')
            self.seq = seq_
            self.validate_ContinuousSeq(self.seq)    # validate type ContinuousSeq
# end class ContinuousMatrixSeqRow


class NodeAndRootEdgeAndEdgeSet(AbstractSet):
    subclass = None
    superclass = AbstractSet
    def __init__(self, about=None, meta=None, label=None, id=None, node=None, edge=None, rootedge=None, valueOf_=None):
        super(NodeAndRootEdgeAndEdgeSet, self).__init__(about, meta, label, id, )
        self.node = _cast(None, node)
        self.edge = _cast(None, edge)
        self.rootedge = _cast(None, rootedge)
        pass
    def factory(*args_, **kwargs_):
        if NodeAndRootEdgeAndEdgeSet.subclass:
            return NodeAndRootEdgeAndEdgeSet.subclass(*args_, **kwargs_)
        else:
            return NodeAndRootEdgeAndEdgeSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_node(self): return self.node
    def set_node(self, node): self.node = node
    def get_edge(self): return self.edge
    def set_edge(self, edge): self.edge = edge
    def get_rootedge(self): return self.rootedge
    def set_rootedge(self, rootedge): self.rootedge = rootedge
    def export(self, outfile, level, namespace_='', name_='NodeAndRootEdgeAndEdgeSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NodeAndRootEdgeAndEdgeSet')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="NodeAndRootEdgeAndEdgeSet"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NodeAndRootEdgeAndEdgeSet'):
        super(NodeAndRootEdgeAndEdgeSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NodeAndRootEdgeAndEdgeSet')
        if self.node is not None and 'node' not in already_processed:
            already_processed.append('node')
            outfile.write(' node=%s' % (self.gds_format_string(quote_attrib(self.node).encode(ExternalEncoding), input_name='node'), ))
        if self.edge is not None and 'edge' not in already_processed:
            already_processed.append('edge')
            outfile.write(' edge=%s' % (self.gds_format_string(quote_attrib(self.edge).encode(ExternalEncoding), input_name='edge'), ))
        if self.rootedge is not None and 'rootedge' not in already_processed:
            already_processed.append('rootedge')
            outfile.write(' rootedge=%s' % (self.gds_format_string(quote_attrib(self.rootedge).encode(ExternalEncoding), input_name='rootedge'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='NodeAndRootEdgeAndEdgeSet', fromsubclass_=False):
        super(NodeAndRootEdgeAndEdgeSet, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(NodeAndRootEdgeAndEdgeSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NodeAndRootEdgeAndEdgeSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.node is not None and 'node' not in already_processed:
            already_processed.append('node')
            showIndent(outfile, level)
            outfile.write('node = "%s",\n' % (self.node,))
        if self.edge is not None and 'edge' not in already_processed:
            already_processed.append('edge')
            showIndent(outfile, level)
            outfile.write('edge = "%s",\n' % (self.edge,))
        if self.rootedge is not None and 'rootedge' not in already_processed:
            already_processed.append('rootedge')
            showIndent(outfile, level)
            outfile.write('rootedge = "%s",\n' % (self.rootedge,))
        super(NodeAndRootEdgeAndEdgeSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NodeAndRootEdgeAndEdgeSet, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('node', node)
        if value is not None and 'node' not in already_processed:
            already_processed.append('node')
            self.node = value
        value = find_attr_value_('edge', node)
        if value is not None and 'edge' not in already_processed:
            already_processed.append('edge')
            self.edge = value
        value = find_attr_value_('rootedge', node)
        if value is not None and 'rootedge' not in already_processed:
            already_processed.append('rootedge')
            self.rootedge = value
        super(NodeAndRootEdgeAndEdgeSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(NodeAndRootEdgeAndEdgeSet, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class NodeAndRootEdgeAndEdgeSet


class TreeAndNetworkSet(AbstractSet):
    subclass = None
    superclass = AbstractSet
    def __init__(self, about=None, meta=None, label=None, id=None, tree=None, network=None, valueOf_=None):
        super(TreeAndNetworkSet, self).__init__(about, meta, label, id, )
        self.tree = _cast(None, tree)
        self.network = _cast(None, network)
        pass
    def factory(*args_, **kwargs_):
        if TreeAndNetworkSet.subclass:
            return TreeAndNetworkSet.subclass(*args_, **kwargs_)
        else:
            return TreeAndNetworkSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_tree(self): return self.tree
    def set_tree(self, tree): self.tree = tree
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def export(self, outfile, level, namespace_='', name_='TreeAndNetworkSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TreeAndNetworkSet')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="TreeAndNetworkSet"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TreeAndNetworkSet'):
        super(TreeAndNetworkSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TreeAndNetworkSet')
        if self.tree is not None and 'tree' not in already_processed:
            already_processed.append('tree')
            outfile.write(' tree=%s' % (self.gds_format_string(quote_attrib(self.tree).encode(ExternalEncoding), input_name='tree'), ))
        if self.network is not None and 'network' not in already_processed:
            already_processed.append('network')
            outfile.write(' network=%s' % (self.gds_format_string(quote_attrib(self.network).encode(ExternalEncoding), input_name='network'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='TreeAndNetworkSet', fromsubclass_=False):
        super(TreeAndNetworkSet, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(TreeAndNetworkSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TreeAndNetworkSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tree is not None and 'tree' not in already_processed:
            already_processed.append('tree')
            showIndent(outfile, level)
            outfile.write('tree = "%s",\n' % (self.tree,))
        if self.network is not None and 'network' not in already_processed:
            already_processed.append('network')
            showIndent(outfile, level)
            outfile.write('network = "%s",\n' % (self.network,))
        super(TreeAndNetworkSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TreeAndNetworkSet, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tree', node)
        if value is not None and 'tree' not in already_processed:
            already_processed.append('tree')
            self.tree = value
        value = find_attr_value_('network', node)
        if value is not None and 'network' not in already_processed:
            already_processed.append('network')
            self.network = value
        super(TreeAndNetworkSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(TreeAndNetworkSet, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class TreeAndNetworkSet


class CellSet(AbstractSet):
    subclass = None
    superclass = AbstractSet
    def __init__(self, about=None, meta=None, label=None, id=None, cell=None, valueOf_=None):
        super(CellSet, self).__init__(about, meta, label, id, )
        self.cell = _cast(None, cell)
        pass
    def factory(*args_, **kwargs_):
        if CellSet.subclass:
            return CellSet.subclass(*args_, **kwargs_)
        else:
            return CellSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def export(self, outfile, level, namespace_='', name_='CellSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CellSet')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="CellSet"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CellSet'):
        super(CellSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CellSet')
        if self.cell is not None and 'cell' not in already_processed:
            already_processed.append('cell')
            outfile.write(' cell=%s' % (self.gds_format_string(quote_attrib(self.cell).encode(ExternalEncoding), input_name='cell'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='CellSet', fromsubclass_=False):
        super(CellSet, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(CellSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CellSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.cell is not None and 'cell' not in already_processed:
            already_processed.append('cell')
            showIndent(outfile, level)
            outfile.write('cell = "%s",\n' % (self.cell,))
        super(CellSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CellSet, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('cell', node)
        if value is not None and 'cell' not in already_processed:
            already_processed.append('cell')
            self.cell = value
        super(CellSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(CellSet, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class CellSet


class RowSet(AbstractSet):
    subclass = None
    superclass = AbstractSet
    def __init__(self, about=None, meta=None, label=None, id=None, row=None, valueOf_=None):
        super(RowSet, self).__init__(about, meta, label, id, )
        self.row = _cast(None, row)
        pass
    def factory(*args_, **kwargs_):
        if RowSet.subclass:
            return RowSet.subclass(*args_, **kwargs_)
        else:
            return RowSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_row(self): return self.row
    def set_row(self, row): self.row = row
    def export(self, outfile, level, namespace_='', name_='RowSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RowSet')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="RowSet"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RowSet'):
        super(RowSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RowSet')
        if self.row is not None and 'row' not in already_processed:
            already_processed.append('row')
            outfile.write(' row=%s' % (self.gds_format_string(quote_attrib(self.row).encode(ExternalEncoding), input_name='row'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RowSet', fromsubclass_=False):
        super(RowSet, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(RowSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RowSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.row is not None and 'row' not in already_processed:
            already_processed.append('row')
            showIndent(outfile, level)
            outfile.write('row = "%s",\n' % (self.row,))
        super(RowSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RowSet, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('row', node)
        if value is not None and 'row' not in already_processed:
            already_processed.append('row')
            self.row = value
        super(RowSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(RowSet, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class RowSet


class CharSet(AbstractSet):
    subclass = None
    superclass = AbstractSet
    def __init__(self, about=None, meta=None, label=None, id=None, char=None, valueOf_=None):
        super(CharSet, self).__init__(about, meta, label, id, )
        self.char = _cast(None, char)
        pass
    def factory(*args_, **kwargs_):
        if CharSet.subclass:
            return CharSet.subclass(*args_, **kwargs_)
        else:
            return CharSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_char(self): return self.char
    def set_char(self, char): self.char = char
    def export(self, outfile, level, namespace_='', name_='CharSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CharSet')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="CharSet"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CharSet'):
        super(CharSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='CharSet')
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            outfile.write(' char=%s' % (self.gds_format_string(quote_attrib(self.char).encode(ExternalEncoding), input_name='char'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='CharSet', fromsubclass_=False):
        super(CharSet, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(CharSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='CharSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.char is not None and 'char' not in already_processed:
            already_processed.append('char')
            showIndent(outfile, level)
            outfile.write('char = "%s",\n' % (self.char,))
        super(CharSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(CharSet, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('char', node)
        if value is not None and 'char' not in already_processed:
            already_processed.append('char')
            self.char = value
        super(CharSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(CharSet, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class CharSet


class StateSet(AbstractSet):
    subclass = None
    superclass = AbstractSet
    def __init__(self, about=None, meta=None, label=None, id=None, uncertain_state_set=None, state=None, polymorphic_state_set=None, valueOf_=None):
        super(StateSet, self).__init__(about, meta, label, id, )
        self.uncertain_state_set = _cast(None, uncertain_state_set)
        self.state = _cast(None, state)
        self.polymorphic_state_set = _cast(None, polymorphic_state_set)
        pass
    def factory(*args_, **kwargs_):
        if StateSet.subclass:
            return StateSet.subclass(*args_, **kwargs_)
        else:
            return StateSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_uncertain_state_set(self): return self.uncertain_state_set
    def set_uncertain_state_set(self, uncertain_state_set): self.uncertain_state_set = uncertain_state_set
    def get_state(self): return self.state
    def set_state(self, state): self.state = state
    def get_polymorphic_state_set(self): return self.polymorphic_state_set
    def set_polymorphic_state_set(self, polymorphic_state_set): self.polymorphic_state_set = polymorphic_state_set
    def export(self, outfile, level, namespace_='', name_='StateSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StateSet')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="StateSet"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StateSet'):
        super(StateSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StateSet')
        if self.uncertain_state_set is not None and 'uncertain_state_set' not in already_processed:
            already_processed.append('uncertain_state_set')
            outfile.write(' uncertain_state_set=%s' % (self.gds_format_string(quote_attrib(self.uncertain_state_set).encode(ExternalEncoding), input_name='uncertain_state_set'), ))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            outfile.write(' state=%s' % (self.gds_format_string(quote_attrib(self.state).encode(ExternalEncoding), input_name='state'), ))
        if self.polymorphic_state_set is not None and 'polymorphic_state_set' not in already_processed:
            already_processed.append('polymorphic_state_set')
            outfile.write(' polymorphic_state_set=%s' % (self.gds_format_string(quote_attrib(self.polymorphic_state_set).encode(ExternalEncoding), input_name='polymorphic_state_set'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StateSet', fromsubclass_=False):
        super(StateSet, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(StateSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StateSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.uncertain_state_set is not None and 'uncertain_state_set' not in already_processed:
            already_processed.append('uncertain_state_set')
            showIndent(outfile, level)
            outfile.write('uncertain_state_set = "%s",\n' % (self.uncertain_state_set,))
        if self.state is not None and 'state' not in already_processed:
            already_processed.append('state')
            showIndent(outfile, level)
            outfile.write('state = "%s",\n' % (self.state,))
        if self.polymorphic_state_set is not None and 'polymorphic_state_set' not in already_processed:
            already_processed.append('polymorphic_state_set')
            showIndent(outfile, level)
            outfile.write('polymorphic_state_set = "%s",\n' % (self.polymorphic_state_set,))
        super(StateSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StateSet, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('uncertain_state_set', node)
        if value is not None and 'uncertain_state_set' not in already_processed:
            already_processed.append('uncertain_state_set')
            self.uncertain_state_set = value
        value = find_attr_value_('state', node)
        if value is not None and 'state' not in already_processed:
            already_processed.append('state')
            self.state = value
        value = find_attr_value_('polymorphic_state_set', node)
        if value is not None and 'polymorphic_state_set' not in already_processed:
            already_processed.append('polymorphic_state_set')
            self.polymorphic_state_set = value
        super(StateSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(StateSet, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class StateSet


class TaxonSet(AbstractSet):
    subclass = None
    superclass = AbstractSet
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, valueOf_=None):
        super(TaxonSet, self).__init__(about, meta, label, id, )
        self.otu = _cast(None, otu)
        pass
    def factory(*args_, **kwargs_):
        if TaxonSet.subclass:
            return TaxonSet.subclass(*args_, **kwargs_)
        else:
            return TaxonSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_otu(self): return self.otu
    def set_otu(self, otu): self.otu = otu
    def export(self, outfile, level, namespace_='', name_='TaxonSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TaxonSet')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="TaxonSet"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TaxonSet'):
        super(TaxonSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TaxonSet')
        if self.otu is not None and 'otu' not in already_processed:
            already_processed.append('otu')
            outfile.write(' otu=%s' % (self.gds_format_string(quote_attrib(self.otu).encode(ExternalEncoding), input_name='otu'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='TaxonSet', fromsubclass_=False):
        super(TaxonSet, self).exportChildren(outfile, level, namespace_, name_, True)
    def hasContent_(self):
        if (
            super(TaxonSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='TaxonSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.otu is not None and 'otu' not in already_processed:
            already_processed.append('otu')
            showIndent(outfile, level)
            outfile.write('otu = "%s",\n' % (self.otu,))
        super(TaxonSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(TaxonSet, self).exportLiteralChildren(outfile, level, name_)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('otu', node)
        if value is not None and 'otu' not in already_processed:
            already_processed.append('otu')
            self.otu = value
        super(TaxonSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(TaxonSet, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class TaxonSet


class NetworkNode(AbstractNode):
    """A concrete network node implementation."""
    subclass = None
    superclass = AbstractNode
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, root=False, valueOf_=None):
        super(NetworkNode, self).__init__(about, meta, label, id, otu, root, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
    def factory(*args_, **kwargs_):
        if NetworkNode.subclass:
            return NetworkNode.subclass(*args_, **kwargs_)
        else:
            return NetworkNode(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def export(self, outfile, level, namespace_='', name_='NetworkNode', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkNode')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NetworkNode'):
        super(NetworkNode, self).exportAttributes(outfile, level, already_processed, namespace_, name_='NetworkNode')
    def exportChildren(self, outfile, level, namespace_='', name_='NetworkNode', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
    def hasContent_(self):
        if (
            self.meta or
            super(NetworkNode, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='NetworkNode'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(NetworkNode, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(NetworkNode, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(NetworkNode, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
# end class NetworkNode


class StandardMatrixObsRow(AbstractObsRow):
    """This is a row in a matrix of standard data as granular obervations."""
    subclass = None
    superclass = AbstractObsRow
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, cell=None, set=None, valueOf_=None):
        super(StandardMatrixObsRow, self).__init__(about, meta, label, id, otu, cell, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if cell is None:
            self.cell = []
        else:
            self.cell = cell
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if StandardMatrixObsRow.subclass:
            return StandardMatrixObsRow.subclass(*args_, **kwargs_)
        else:
            return StandardMatrixObsRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def add_cell(self, value): self.cell.append(value)
    def insert_cell(self, index, value): self.cell[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='StandardMatrixObsRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardMatrixObsRow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardMatrixObsRow'):
        super(StandardMatrixObsRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardMatrixObsRow')
    def exportChildren(self, outfile, level, namespace_='', name_='StandardMatrixObsRow', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for cell_ in self.cell:
            cell_.export(outfile, level, namespace_, name_='cell')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.cell or
            self.set or
            super(StandardMatrixObsRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardMatrixObsRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StandardMatrixObsRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardMatrixObsRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('cell=[\n')
        level += 1
        for cell_ in self.cell:
            showIndent(outfile, level)
            outfile.write('model_.StandardObs(\n')
            cell_.exportLiteral(outfile, level, name_='StandardObs')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CellSet(\n')
            set_.exportLiteral(outfile, level, name_='CellSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StandardMatrixObsRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'cell':
            obj_ = StandardObs.factory()
            obj_.build(child_)
            self.cell.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CellSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class StandardMatrixObsRow


class StandardMatrixSeqRow(AbstractSeqRow):
    """This is a row in a matrix of standard data as character sequences."""
    subclass = None
    superclass = AbstractSeqRow
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, seq=None, valueOf_=None):
        super(StandardMatrixSeqRow, self).__init__(about, meta, label, id, otu, seq, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.seq = seq
    def factory(*args_, **kwargs_):
        if StandardMatrixSeqRow.subclass:
            return StandardMatrixSeqRow.subclass(*args_, **kwargs_)
        else:
            return StandardMatrixSeqRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_seq(self): return self.seq
    def set_seq(self, seq): self.seq = seq
    def validate_StandardSeq(self, value):
        # Validate type StandardSeq, a restriction on AbstractTokenList.
        pass
    def export(self, outfile, level, namespace_='', name_='StandardMatrixSeqRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardMatrixSeqRow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardMatrixSeqRow'):
        super(StandardMatrixSeqRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardMatrixSeqRow')
    def exportChildren(self, outfile, level, namespace_='', name_='StandardMatrixSeqRow', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('<%sseq>%s</%sseq>\n' % (namespace_, self.gds_format_double_list(self.seq, input_name='seq'), namespace_))
    def hasContent_(self):
        if (
            self.meta or
            self.seq is not None or
            super(StandardMatrixSeqRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardMatrixSeqRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StandardMatrixSeqRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardMatrixSeqRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('seq=%e,\n' % self.seq)
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StandardMatrixSeqRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'seq':
            seq_ = child_.text
            seq_ = self.gds_validate_double_list(seq_, node, 'seq')
            self.seq = seq_
            self.validate_StandardSeq(self.seq)    # validate type StandardSeq
# end class StandardMatrixSeqRow


class StandardUncertainStateSet(AbstractUncertainStateSet):
    """The StandardUncertainStateSet type is a single uncertain ambiguity
    mapping."""
    subclass = None
    superclass = AbstractUncertainStateSet
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, member=None, valueOf_=None):
        super(StandardUncertainStateSet, self).__init__(about, meta, label, id, symbol, member, )
        self.symbol = _cast(None, symbol)
        if member is None:
            self.member = []
        else:
            self.member = member
    def factory(*args_, **kwargs_):
        if StandardUncertainStateSet.subclass:
            return StandardUncertainStateSet.subclass(*args_, **kwargs_)
        else:
            return StandardUncertainStateSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_member(self): return self.member
    def set_member(self, member): self.member = member
    def add_member(self, value): self.member.append(value)
    def insert_member(self, index, value): self.member[index] = value
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def export(self, outfile, level, namespace_='', name_='StandardUncertainStateSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardUncertainStateSet')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardUncertainStateSet'):
        super(StandardUncertainStateSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardUncertainStateSet')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (self.gds_format_string(quote_attrib(self.symbol).encode(ExternalEncoding), input_name='symbol'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='StandardUncertainStateSet', fromsubclass_=False):
        for member_ in self.member:
            member_.export(outfile, level, namespace_, name_='member')
    def hasContent_(self):
        if (
            self.member or
            super(StandardUncertainStateSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardUncertainStateSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = "%s",\n' % (self.symbol,))
        super(StandardUncertainStateSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardUncertainStateSet, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('member=[\n')
        level += 1
        for member_ in self.member:
            showIndent(outfile, level)
            outfile.write('model_.StandardMapping(\n')
            member_.exportLiteral(outfile, level, name_='StandardMapping')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            self.symbol = value
        super(StandardUncertainStateSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'member':
            obj_ = StandardMapping.factory()
            obj_.build(child_)
            self.member.append(obj_)
# end class StandardUncertainStateSet


class RNAMatrixObsRow(AbstractObsRow):
    """This is a row in a matrix of RNA data containing granular
    observations."""
    subclass = None
    superclass = AbstractObsRow
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, cell=None, set=None, valueOf_=None):
        super(RNAMatrixObsRow, self).__init__(about, meta, label, id, otu, cell, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if cell is None:
            self.cell = []
        else:
            self.cell = cell
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if RNAMatrixObsRow.subclass:
            return RNAMatrixObsRow.subclass(*args_, **kwargs_)
        else:
            return RNAMatrixObsRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def add_cell(self, value): self.cell.append(value)
    def insert_cell(self, index, value): self.cell[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='RNAMatrixObsRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RNAMatrixObsRow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RNAMatrixObsRow'):
        super(RNAMatrixObsRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RNAMatrixObsRow')
    def exportChildren(self, outfile, level, namespace_='', name_='RNAMatrixObsRow', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for cell_ in self.cell:
            cell_.export(outfile, level, namespace_, name_='cell')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.cell or
            self.set or
            super(RNAMatrixObsRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RNAMatrixObsRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RNAMatrixObsRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RNAMatrixObsRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('cell=[\n')
        level += 1
        for cell_ in self.cell:
            showIndent(outfile, level)
            outfile.write('model_.RNAObs(\n')
            cell_.exportLiteral(outfile, level, name_='RNAObs')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CellSet(\n')
            set_.exportLiteral(outfile, level, name_='CellSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RNAMatrixObsRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'cell':
            obj_ = RNAObs.factory()
            obj_.build(child_)
            self.cell.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CellSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class RNAMatrixObsRow


class RNAMatrixSeqRow(AbstractSeqRow):
    """This is a row in a matrix of RNA data containing raw sequence data."""
    subclass = None
    superclass = AbstractSeqRow
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, seq=None, valueOf_=None):
        super(RNAMatrixSeqRow, self).__init__(about, meta, label, id, otu, seq, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.seq = seq
    def factory(*args_, **kwargs_):
        if RNAMatrixSeqRow.subclass:
            return RNAMatrixSeqRow.subclass(*args_, **kwargs_)
        else:
            return RNAMatrixSeqRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_seq(self): return self.seq
    def set_seq(self, seq): self.seq = seq
    def validate_RNASeq(self, value):
        # Validate type RNASeq, a restriction on AbstractSeq.
        pass
    def export(self, outfile, level, namespace_='', name_='RNAMatrixSeqRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RNAMatrixSeqRow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RNAMatrixSeqRow'):
        super(RNAMatrixSeqRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RNAMatrixSeqRow')
    def exportChildren(self, outfile, level, namespace_='', name_='RNAMatrixSeqRow', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('<%sseq>%s</%sseq>\n' % (namespace_, self.gds_format_string(quote_xml(self.seq).encode(ExternalEncoding), input_name='seq'), namespace_))
    def hasContent_(self):
        if (
            self.meta or
            self.seq is not None or
            super(RNAMatrixSeqRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RNAMatrixSeqRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RNAMatrixSeqRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RNAMatrixSeqRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('seq=%s,\n' % quote_python(self.seq).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RNAMatrixSeqRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'seq':
            seq_ = child_.text
            seq_ = self.gds_validate_string(seq_, node, 'seq')
            self.seq = seq_
            self.validate_RNASeq(self.seq)    # validate type RNASeq
# end class RNAMatrixSeqRow


class RNAUncertainStateSet(AbstractUncertainStateSet):
    """The RNAUncertainStateSet describes a single uncertain IUPAC
    ambiguity mapping."""
    subclass = None
    superclass = AbstractUncertainStateSet
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, member=None, valueOf_=None):
        super(RNAUncertainStateSet, self).__init__(about, meta, label, id, symbol, member, )
        self.symbol = _cast(None, symbol)
        if member is None:
            self.member = []
        else:
            self.member = member
    def factory(*args_, **kwargs_):
        if RNAUncertainStateSet.subclass:
            return RNAUncertainStateSet.subclass(*args_, **kwargs_)
        else:
            return RNAUncertainStateSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_member(self): return self.member
    def set_member(self, member): self.member = member
    def add_member(self, value): self.member.append(value)
    def insert_member(self, index, value): self.member[index] = value
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def validate_RNAToken(self, value):
        # Validate type RNAToken, a restriction on AbstractSymbol.
        pass
    def export(self, outfile, level, namespace_='', name_='RNAUncertainStateSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RNAUncertainStateSet')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RNAUncertainStateSet'):
        super(RNAUncertainStateSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RNAUncertainStateSet')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (quote_attrib(self.symbol), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RNAUncertainStateSet', fromsubclass_=False):
        for member_ in self.member:
            member_.export(outfile, level, namespace_, name_='member')
    def hasContent_(self):
        if (
            self.member or
            super(RNAUncertainStateSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RNAUncertainStateSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = "%s",\n' % (self.symbol,))
        super(RNAUncertainStateSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RNAUncertainStateSet, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('member=[\n')
        level += 1
        for member_ in self.member:
            showIndent(outfile, level)
            outfile.write('model_.RNAMapping(\n')
            member_.exportLiteral(outfile, level, name_='RNAMapping')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            self.symbol = value
            self.validate_RNAToken(self.symbol)    # validate type RNAToken
        super(RNAUncertainStateSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'member':
            obj_ = RNAMapping.factory()
            obj_.build(child_)
            self.member.append(obj_)
# end class RNAUncertainStateSet


class RestrictionMatrixObsRow(AbstractObsRow):
    """This is a row in a matrix of restriction site data as granular
    obervations."""
    subclass = None
    superclass = AbstractObsRow
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, cell=None, set=None, valueOf_=None):
        super(RestrictionMatrixObsRow, self).__init__(about, meta, label, id, otu, cell, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if cell is None:
            self.cell = []
        else:
            self.cell = cell
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if RestrictionMatrixObsRow.subclass:
            return RestrictionMatrixObsRow.subclass(*args_, **kwargs_)
        else:
            return RestrictionMatrixObsRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def add_cell(self, value): self.cell.append(value)
    def insert_cell(self, index, value): self.cell[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='RestrictionMatrixObsRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionMatrixObsRow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RestrictionMatrixObsRow'):
        super(RestrictionMatrixObsRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionMatrixObsRow')
    def exportChildren(self, outfile, level, namespace_='', name_='RestrictionMatrixObsRow', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for cell_ in self.cell:
            cell_.export(outfile, level, namespace_, name_='cell')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.cell or
            self.set or
            super(RestrictionMatrixObsRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RestrictionMatrixObsRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RestrictionMatrixObsRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RestrictionMatrixObsRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('cell=[\n')
        level += 1
        for cell_ in self.cell:
            showIndent(outfile, level)
            outfile.write('model_.RestrictionObs(\n')
            cell_.exportLiteral(outfile, level, name_='RestrictionObs')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CellSet(\n')
            set_.exportLiteral(outfile, level, name_='CellSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RestrictionMatrixObsRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'cell':
            obj_ = RestrictionObs.factory()
            obj_.build(child_)
            self.cell.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CellSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class RestrictionMatrixObsRow


class RestrictionMatrixSeqRow(AbstractSeqRow):
    """This is a row in a matrix of restriction site data as character
    sequences."""
    subclass = None
    superclass = AbstractSeqRow
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, seq=None, valueOf_=None):
        super(RestrictionMatrixSeqRow, self).__init__(about, meta, label, id, otu, seq, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.seq = seq
    def factory(*args_, **kwargs_):
        if RestrictionMatrixSeqRow.subclass:
            return RestrictionMatrixSeqRow.subclass(*args_, **kwargs_)
        else:
            return RestrictionMatrixSeqRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_seq(self): return self.seq
    def set_seq(self, seq): self.seq = seq
    def validate_RestrictionSeq(self, value):
        # Validate type RestrictionSeq, a restriction on xs:string.
        pass
    def export(self, outfile, level, namespace_='', name_='RestrictionMatrixSeqRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionMatrixSeqRow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RestrictionMatrixSeqRow'):
        super(RestrictionMatrixSeqRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionMatrixSeqRow')
    def exportChildren(self, outfile, level, namespace_='', name_='RestrictionMatrixSeqRow', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('<%sseq>%s</%sseq>\n' % (namespace_, self.gds_format_string(quote_xml(self.seq).encode(ExternalEncoding), input_name='seq'), namespace_))
    def hasContent_(self):
        if (
            self.meta or
            self.seq is not None or
            super(RestrictionMatrixSeqRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RestrictionMatrixSeqRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RestrictionMatrixSeqRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RestrictionMatrixSeqRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('seq=%s,\n' % quote_python(self.seq).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RestrictionMatrixSeqRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'seq':
            seq_ = child_.text
            seq_ = self.gds_validate_string(seq_, node, 'seq')
            self.seq = seq_
            self.validate_RestrictionSeq(self.seq)    # validate type RestrictionSeq
# end class RestrictionMatrixSeqRow


class AAMatrixObsRow(AbstractObsRow):
    """This is a row in a matrix of amino acid data containing granular
    observations."""
    subclass = None
    superclass = AbstractObsRow
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, cell=None, set=None, valueOf_=None):
        super(AAMatrixObsRow, self).__init__(about, meta, label, id, otu, cell, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if cell is None:
            self.cell = []
        else:
            self.cell = cell
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if AAMatrixObsRow.subclass:
            return AAMatrixObsRow.subclass(*args_, **kwargs_)
        else:
            return AAMatrixObsRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def add_cell(self, value): self.cell.append(value)
    def insert_cell(self, index, value): self.cell[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='AAMatrixObsRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AAMatrixObsRow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AAMatrixObsRow'):
        super(AAMatrixObsRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AAMatrixObsRow')
    def exportChildren(self, outfile, level, namespace_='', name_='AAMatrixObsRow', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for cell_ in self.cell:
            cell_.export(outfile, level, namespace_, name_='cell')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.cell or
            self.set or
            super(AAMatrixObsRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AAMatrixObsRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AAMatrixObsRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AAMatrixObsRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('cell=[\n')
        level += 1
        for cell_ in self.cell:
            showIndent(outfile, level)
            outfile.write('model_.AAObs(\n')
            cell_.exportLiteral(outfile, level, name_='AAObs')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CellSet(\n')
            set_.exportLiteral(outfile, level, name_='CellSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AAMatrixObsRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'cell':
            obj_ = AAObs.factory()
            obj_.build(child_)
            self.cell.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CellSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class AAMatrixObsRow


class AAMatrixSeqRow(AbstractSeqRow):
    """This is a row in a matrix of amino acid data containing raw sequence
    data."""
    subclass = None
    superclass = AbstractSeqRow
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, seq=None, valueOf_=None):
        super(AAMatrixSeqRow, self).__init__(about, meta, label, id, otu, seq, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.seq = seq
    def factory(*args_, **kwargs_):
        if AAMatrixSeqRow.subclass:
            return AAMatrixSeqRow.subclass(*args_, **kwargs_)
        else:
            return AAMatrixSeqRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_seq(self): return self.seq
    def set_seq(self, seq): self.seq = seq
    def validate_AASeq(self, value):
        # Validate type AASeq, a restriction on AbstractSeq.
        pass
    def export(self, outfile, level, namespace_='', name_='AAMatrixSeqRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AAMatrixSeqRow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AAMatrixSeqRow'):
        super(AAMatrixSeqRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AAMatrixSeqRow')
    def exportChildren(self, outfile, level, namespace_='', name_='AAMatrixSeqRow', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('<%sseq>%s</%sseq>\n' % (namespace_, self.gds_format_string(quote_xml(self.seq).encode(ExternalEncoding), input_name='seq'), namespace_))
    def hasContent_(self):
        if (
            self.meta or
            self.seq is not None or
            super(AAMatrixSeqRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AAMatrixSeqRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AAMatrixSeqRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AAMatrixSeqRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('seq=%s,\n' % quote_python(self.seq).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AAMatrixSeqRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'seq':
            seq_ = child_.text
            seq_ = self.gds_validate_string(seq_, node, 'seq')
            self.seq = seq_
            self.validate_AASeq(self.seq)    # validate type AASeq
# end class AAMatrixSeqRow


class AAUncertainStateSet(AbstractUncertainStateSet):
    """The AAUncertainStateSet defines an uncertain ambiguity mapping."""
    subclass = None
    superclass = AbstractUncertainStateSet
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, member=None, valueOf_=None):
        super(AAUncertainStateSet, self).__init__(about, meta, label, id, symbol, member, )
        self.symbol = _cast(None, symbol)
        if member is None:
            self.member = []
        else:
            self.member = member
    def factory(*args_, **kwargs_):
        if AAUncertainStateSet.subclass:
            return AAUncertainStateSet.subclass(*args_, **kwargs_)
        else:
            return AAUncertainStateSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_member(self): return self.member
    def set_member(self, member): self.member = member
    def add_member(self, value): self.member.append(value)
    def insert_member(self, index, value): self.member[index] = value
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def validate_AAToken(self, value):
        # Validate type AAToken, a restriction on AbstractSymbol.
        pass
    def export(self, outfile, level, namespace_='', name_='AAUncertainStateSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AAUncertainStateSet')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AAUncertainStateSet'):
        super(AAUncertainStateSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AAUncertainStateSet')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (quote_attrib(self.symbol), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AAUncertainStateSet', fromsubclass_=False):
        for member_ in self.member:
            member_.export(outfile, level, namespace_, name_='member')
    def hasContent_(self):
        if (
            self.member or
            super(AAUncertainStateSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AAUncertainStateSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = "%s",\n' % (self.symbol,))
        super(AAUncertainStateSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AAUncertainStateSet, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('member=[\n')
        level += 1
        for member_ in self.member:
            showIndent(outfile, level)
            outfile.write('model_.AAMapping(\n')
            member_.exportLiteral(outfile, level, name_='AAMapping')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            self.symbol = value
            self.validate_AAToken(self.symbol)    # validate type AAToken
        super(AAUncertainStateSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'member':
            obj_ = AAMapping.factory()
            obj_.build(child_)
            self.member.append(obj_)
# end class AAUncertainStateSet


class DNAMatrixObsRow(AbstractObsRow):
    """This is a row in a matrix of DNA data containing granular
    observations."""
    subclass = None
    superclass = AbstractObsRow
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, cell=None, set=None, valueOf_=None):
        super(DNAMatrixObsRow, self).__init__(about, meta, label, id, otu, cell, set, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        if cell is None:
            self.cell = []
        else:
            self.cell = cell
        if set is None:
            self.set = []
        else:
            self.set = set
    def factory(*args_, **kwargs_):
        if DNAMatrixObsRow.subclass:
            return DNAMatrixObsRow.subclass(*args_, **kwargs_)
        else:
            return DNAMatrixObsRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_cell(self): return self.cell
    def set_cell(self, cell): self.cell = cell
    def add_cell(self, value): self.cell.append(value)
    def insert_cell(self, index, value): self.cell[index] = value
    def get_set(self): return self.set
    def set_set(self, set): self.set = set
    def add_set(self, value): self.set.append(value)
    def insert_set(self, index, value): self.set[index] = value
    def export(self, outfile, level, namespace_='', name_='DNAMatrixObsRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNAMatrixObsRow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNAMatrixObsRow'):
        super(DNAMatrixObsRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DNAMatrixObsRow')
    def exportChildren(self, outfile, level, namespace_='', name_='DNAMatrixObsRow', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        for cell_ in self.cell:
            cell_.export(outfile, level, namespace_, name_='cell')
        for set_ in self.set:
            set_.export(outfile, level, namespace_, name_='set')
    def hasContent_(self):
        if (
            self.meta or
            self.cell or
            self.set or
            super(DNAMatrixObsRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DNAMatrixObsRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DNAMatrixObsRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DNAMatrixObsRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('cell=[\n')
        level += 1
        for cell_ in self.cell:
            showIndent(outfile, level)
            outfile.write('model_.DNAObs(\n')
            cell_.exportLiteral(outfile, level, name_='DNAObs')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('set=[\n')
        level += 1
        for set_ in self.set:
            showIndent(outfile, level)
            outfile.write('model_.CellSet(\n')
            set_.exportLiteral(outfile, level, name_='CellSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DNAMatrixObsRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'cell':
            obj_ = DNAObs.factory()
            obj_.build(child_)
            self.cell.append(obj_)
        elif nodeName_ == 'set':
            obj_ = CellSet.factory()
            obj_.build(child_)
            self.set.append(obj_)
# end class DNAMatrixObsRow


class DNAMatrixSeqRow(AbstractSeqRow):
    """This is a row in a matrix of DNA data containing raw sequence data."""
    subclass = None
    superclass = AbstractSeqRow
    def __init__(self, about=None, meta=None, label=None, id=None, otu=None, seq=None, valueOf_=None):
        super(DNAMatrixSeqRow, self).__init__(about, meta, label, id, otu, seq, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.seq = seq
    def factory(*args_, **kwargs_):
        if DNAMatrixSeqRow.subclass:
            return DNAMatrixSeqRow.subclass(*args_, **kwargs_)
        else:
            return DNAMatrixSeqRow(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_seq(self): return self.seq
    def set_seq(self, seq): self.seq = seq
    def validate_DNASeq(self, value):
        # Validate type DNASeq, a restriction on AbstractSeq.
        pass
    def export(self, outfile, level, namespace_='', name_='DNAMatrixSeqRow', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNAMatrixSeqRow')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNAMatrixSeqRow'):
        super(DNAMatrixSeqRow, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DNAMatrixSeqRow')
    def exportChildren(self, outfile, level, namespace_='', name_='DNAMatrixSeqRow', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('<%sseq>%s</%sseq>\n' % (namespace_, self.gds_format_string(quote_xml(self.seq).encode(ExternalEncoding), input_name='seq'), namespace_))
    def hasContent_(self):
        if (
            self.meta or
            self.seq is not None or
            super(DNAMatrixSeqRow, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DNAMatrixSeqRow'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DNAMatrixSeqRow, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DNAMatrixSeqRow, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.seq is not None:
            showIndent(outfile, level)
            outfile.write('seq=%s,\n' % quote_python(self.seq).encode(ExternalEncoding))
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DNAMatrixSeqRow, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'seq':
            seq_ = child_.text
            seq_ = self.gds_validate_string(seq_, node, 'seq')
            self.seq = seq_
            self.validate_DNASeq(self.seq)    # validate type DNASeq
# end class DNAMatrixSeqRow


class DNAUncertainStateSet(AbstractUncertainStateSet):
    """The DNAUncertainStateSet type defines an IUPAC ambiguity mapping. It
    may enclose zero or more AbstractMapping elements to resolve
    ambiguities."""
    subclass = None
    superclass = AbstractUncertainStateSet
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, member=None, valueOf_=None):
        super(DNAUncertainStateSet, self).__init__(about, meta, label, id, symbol, member, )
        self.symbol = _cast(None, symbol)
        if member is None:
            self.member = []
        else:
            self.member = member
    def factory(*args_, **kwargs_):
        if DNAUncertainStateSet.subclass:
            return DNAUncertainStateSet.subclass(*args_, **kwargs_)
        else:
            return DNAUncertainStateSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_member(self): return self.member
    def set_member(self, member): self.member = member
    def add_member(self, value): self.member.append(value)
    def insert_member(self, index, value): self.member[index] = value
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def validate_DNAToken(self, value):
        # Validate type DNAToken, a restriction on AbstractSymbol.
        pass
    def export(self, outfile, level, namespace_='', name_='DNAUncertainStateSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNAUncertainStateSet')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNAUncertainStateSet'):
        super(DNAUncertainStateSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DNAUncertainStateSet')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (quote_attrib(self.symbol), ))
    def exportChildren(self, outfile, level, namespace_='', name_='DNAUncertainStateSet', fromsubclass_=False):
        for member_ in self.member:
            member_.export(outfile, level, namespace_, name_='member')
    def hasContent_(self):
        if (
            self.member or
            super(DNAUncertainStateSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DNAUncertainStateSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = "%s",\n' % (self.symbol,))
        super(DNAUncertainStateSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DNAUncertainStateSet, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('member=[\n')
        level += 1
        for member_ in self.member:
            showIndent(outfile, level)
            outfile.write('model_.DNAMapping(\n')
            member_.exportLiteral(outfile, level, name_='DNAMapping')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            self.symbol = value
            self.validate_DNAToken(self.symbol)    # validate type DNAToken
        super(DNAUncertainStateSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'member':
            obj_ = DNAMapping.factory()
            obj_.build(child_)
            self.member.append(obj_)
# end class DNAUncertainStateSet


class AbstractCells(AbstractBlock):
    """The AbstractSeqBlock type is the superclass for character blocks
    that consist of granular character state observations."""
    subclass = None
    superclass = AbstractBlock
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(AbstractCells, self).__init__(about, meta, label, id, otus, format, )
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if AbstractCells.subclass:
            return AbstractCells.subclass(*args_, **kwargs_)
        else:
            return AbstractCells(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='AbstractCells', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractCells')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractCells"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractCells'):
        super(AbstractCells, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractCells')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractCells', fromsubclass_=False):
        super(AbstractCells, self).exportChildren(outfile, level, namespace_, name_, True)
        matrix_.export(outfile, level, namespace_, name_='matrix')
    def hasContent_(self):
        if (
            self.matrix is not None or
            super(AbstractCells, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractCells'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractCells, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractCells, self).exportLiteralChildren(outfile, level, name_)
        if self.AbstractObsMatrix is not None:
            showIndent(outfile, level)
            outfile.write('AbstractObsMatrix=model_.AbstractObsMatrix(\n')
            self.AbstractObsMatrix.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractCells, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'matrix':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <matrix> element')
            self.set_matrix(obj_)
        super(AbstractCells, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractCells


class AbstractSeqs(AbstractBlock):
    """The AbstractSeqBlock type is the superclass for character blocks
    that consist of raw character sequences."""
    subclass = None
    superclass = AbstractBlock
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(AbstractSeqs, self).__init__(about, meta, label, id, otus, format, )
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if AbstractSeqs.subclass:
            return AbstractSeqs.subclass(*args_, **kwargs_)
        else:
            return AbstractSeqs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='AbstractSeqs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractSeqs')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractSeqs"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractSeqs'):
        super(AbstractSeqs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractSeqs')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractSeqs', fromsubclass_=False):
        super(AbstractSeqs, self).exportChildren(outfile, level, namespace_, name_, True)
        matrix_.export(outfile, level, namespace_, name_='matrix')
    def hasContent_(self):
        if (
            self.matrix is not None or
            super(AbstractSeqs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractSeqs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractSeqs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractSeqs, self).exportLiteralChildren(outfile, level, name_)
        if self.AbstractSeqMatrix is not None:
            showIndent(outfile, level)
            outfile.write('AbstractSeqMatrix=model_.AbstractSeqMatrix(\n')
            self.AbstractSeqMatrix.exportLiteral(outfile, level)
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractSeqs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'matrix':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <matrix> element')
            self.set_matrix(obj_)
        super(AbstractSeqs, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractSeqs


class AbstractPolymorphicStateSet(AbstractUncertainStateSet):
    """The AbstractPolymorphicStateSet type is the super-class for a
    polymorphic state set definition. The element has a required
    AbstractSymbol attribute that in restricted concrete subclasses
    must be of a sensible type such as a single IUPAC character. It
    may enclose zero or more AbstractMapping elements to resolve
    ambiguities."""
    subclass = None
    superclass = AbstractUncertainStateSet
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, member=None, uncertain_state_set=None, valueOf_=None):
        super(AbstractPolymorphicStateSet, self).__init__(about, meta, label, id, symbol, member, )
        if uncertain_state_set is None:
            self.uncertain_state_set = []
        else:
            self.uncertain_state_set = uncertain_state_set
    def factory(*args_, **kwargs_):
        if AbstractPolymorphicStateSet.subclass:
            return AbstractPolymorphicStateSet.subclass(*args_, **kwargs_)
        else:
            return AbstractPolymorphicStateSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_uncertain_state_set(self): return self.uncertain_state_set
    def set_uncertain_state_set(self, uncertain_state_set): self.uncertain_state_set = uncertain_state_set
    def add_uncertain_state_set(self, value): self.uncertain_state_set.append(value)
    def insert_uncertain_state_set(self, index, value): self.uncertain_state_set[index] = value
    def export(self, outfile, level, namespace_='', name_='AbstractPolymorphicStateSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractPolymorphicStateSet')
        outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        if 'xsi:type' not in already_processed:
            outfile.write(' xsi:type="AbstractPolymorphicStateSet"')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AbstractPolymorphicStateSet'):
        super(AbstractPolymorphicStateSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AbstractPolymorphicStateSet')
    def exportChildren(self, outfile, level, namespace_='', name_='AbstractPolymorphicStateSet', fromsubclass_=False):
        super(AbstractPolymorphicStateSet, self).exportChildren(outfile, level, namespace_, name_, True)
        for uncertain_state_set_ in self.get_uncertain_state_set():
            uncertain_state_set_.export(outfile, level, namespace_, name_='uncertain_state_set')
    def hasContent_(self):
        if (
            self.uncertain_state_set or
            super(AbstractPolymorphicStateSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AbstractPolymorphicStateSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(AbstractPolymorphicStateSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AbstractPolymorphicStateSet, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('uncertain_state_set=[\n')
        level += 1
        for uncertain_state_set_ in self.uncertain_state_set:
            showIndent(outfile, level)
            outfile.write('model_.AbstractUncertainStateSet(\n')
            uncertain_state_set_.exportLiteral(outfile, level, name_='AbstractUncertainStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AbstractPolymorphicStateSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'uncertain_state_set':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <uncertain_state_set> element')
            self.uncertain_state_set.append(obj_)
        super(AbstractPolymorphicStateSet, self).buildChildren(child_, node, nodeName_, True)
# end class AbstractPolymorphicStateSet


class ContinuousCells(AbstractCells):
    """A continuous characters block consisting of granular cells preceded
    by metadata."""
    subclass = None
    superclass = AbstractCells
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(ContinuousCells, self).__init__(about, meta, label, id, otus, format, matrix, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.format = format
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if ContinuousCells.subclass:
            return ContinuousCells.subclass(*args_, **kwargs_)
        else:
            return ContinuousCells(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='ContinuousCells', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousCells')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContinuousCells'):
        super(ContinuousCells, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousCells')
    def exportChildren(self, outfile, level, namespace_='', name_='ContinuousCells', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.format:
            self.format.export(outfile, level, namespace_, name_='format', )
        if self.matrix:
            self.matrix.export(outfile, level, namespace_, name_='matrix', )
    def hasContent_(self):
        if (
            self.meta or
            self.format is not None or
            self.matrix is not None or
            super(ContinuousCells, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ContinuousCells'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ContinuousCells, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ContinuousCells, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.ContinuousFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.matrix is not None:
            showIndent(outfile, level)
            outfile.write('matrix=model_.ContinuousObsMatrix(\n')
            self.matrix.exportLiteral(outfile, level, name_='matrix')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ContinuousCells, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'format':
            obj_ = ContinuousFormat.factory()
            obj_.build(child_)
            self.set_format(obj_)
        elif nodeName_ == 'matrix':
            obj_ = ContinuousObsMatrix.factory()
            obj_.build(child_)
            self.set_matrix(obj_)
# end class ContinuousCells


class ContinuousSeqs(AbstractSeqs):
    """A continuous characters block consisting of float sequences preceded
    by metadata."""
    subclass = None
    superclass = AbstractSeqs
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(ContinuousSeqs, self).__init__(about, meta, label, id, otus, format, matrix, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.format = format
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if ContinuousSeqs.subclass:
            return ContinuousSeqs.subclass(*args_, **kwargs_)
        else:
            return ContinuousSeqs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='ContinuousSeqs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousSeqs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContinuousSeqs'):
        super(ContinuousSeqs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ContinuousSeqs')
    def exportChildren(self, outfile, level, namespace_='', name_='ContinuousSeqs', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.format:
            self.format.export(outfile, level, namespace_, name_='format', )
        if self.matrix:
            self.matrix.export(outfile, level, namespace_, name_='matrix', )
    def hasContent_(self):
        if (
            self.meta or
            self.format is not None or
            self.matrix is not None or
            super(ContinuousSeqs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ContinuousSeqs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ContinuousSeqs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ContinuousSeqs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.ContinuousFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.matrix is not None:
            showIndent(outfile, level)
            outfile.write('matrix=model_.ContinuousSeqMatrix(\n')
            self.matrix.exportLiteral(outfile, level, name_='matrix')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ContinuousSeqs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'format':
            obj_ = ContinuousFormat.factory()
            obj_.build(child_)
            self.set_format(obj_)
        elif nodeName_ == 'matrix':
            obj_ = ContinuousSeqMatrix.factory()
            obj_.build(child_)
            self.set_matrix(obj_)
# end class ContinuousSeqs


class StandardCells(AbstractCells):
    """A standard characters block consisting of granular cells preceded by
    metadata."""
    subclass = None
    superclass = AbstractCells
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(StandardCells, self).__init__(about, meta, label, id, otus, format, matrix, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.format = format
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if StandardCells.subclass:
            return StandardCells.subclass(*args_, **kwargs_)
        else:
            return StandardCells(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='StandardCells', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardCells')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardCells'):
        super(StandardCells, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardCells')
    def exportChildren(self, outfile, level, namespace_='', name_='StandardCells', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.format:
            self.format.export(outfile, level, namespace_, name_='format', )
        if self.matrix:
            self.matrix.export(outfile, level, namespace_, name_='matrix', )
    def hasContent_(self):
        if (
            self.meta or
            self.format is not None or
            self.matrix is not None or
            super(StandardCells, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardCells'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StandardCells, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardCells, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.StandardFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.matrix is not None:
            showIndent(outfile, level)
            outfile.write('matrix=model_.StandardObsMatrix(\n')
            self.matrix.exportLiteral(outfile, level, name_='matrix')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StandardCells, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'format':
            obj_ = StandardFormat.factory()
            obj_.build(child_)
            self.set_format(obj_)
        elif nodeName_ == 'matrix':
            obj_ = StandardObsMatrix.factory()
            obj_.build(child_)
            self.set_matrix(obj_)
# end class StandardCells


class StandardSeqs(AbstractSeqs):
    """A standard characters block consisting of sequences preceded by
    metadata."""
    subclass = None
    superclass = AbstractSeqs
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(StandardSeqs, self).__init__(about, meta, label, id, otus, format, matrix, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.format = format
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if StandardSeqs.subclass:
            return StandardSeqs.subclass(*args_, **kwargs_)
        else:
            return StandardSeqs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='StandardSeqs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardSeqs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardSeqs'):
        super(StandardSeqs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardSeqs')
    def exportChildren(self, outfile, level, namespace_='', name_='StandardSeqs', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.format:
            self.format.export(outfile, level, namespace_, name_='format', )
        if self.matrix:
            self.matrix.export(outfile, level, namespace_, name_='matrix', )
    def hasContent_(self):
        if (
            self.meta or
            self.format is not None or
            self.matrix is not None or
            super(StandardSeqs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardSeqs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StandardSeqs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardSeqs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.StandardFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.matrix is not None:
            showIndent(outfile, level)
            outfile.write('matrix=model_.StandardSeqMatrix(\n')
            self.matrix.exportLiteral(outfile, level, name_='matrix')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StandardSeqs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'format':
            obj_ = StandardFormat.factory()
            obj_.build(child_)
            self.set_format(obj_)
        elif nodeName_ == 'matrix':
            obj_ = StandardSeqMatrix.factory()
            obj_.build(child_)
            self.set_matrix(obj_)
# end class StandardSeqs


class StandardPolymorphicStateSet(AbstractPolymorphicStateSet):
    """The StandardPolymorphicStateSet type is a single polymorphic
    ambiguity mapping."""
    subclass = None
    superclass = AbstractPolymorphicStateSet
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, member=None, uncertain_state_set=None, valueOf_=None):
        super(StandardPolymorphicStateSet, self).__init__(about, meta, label, id, symbol, member, uncertain_state_set, )
        if member is None:
            self.member = []
        else:
            self.member = member
        if uncertain_state_set is None:
            self.uncertain_state_set = []
        else:
            self.uncertain_state_set = uncertain_state_set
    def factory(*args_, **kwargs_):
        if StandardPolymorphicStateSet.subclass:
            return StandardPolymorphicStateSet.subclass(*args_, **kwargs_)
        else:
            return StandardPolymorphicStateSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_member(self): return self.member
    def set_member(self, member): self.member = member
    def add_member(self, value): self.member.append(value)
    def insert_member(self, index, value): self.member[index] = value
    def get_uncertain_state_set(self): return self.uncertain_state_set
    def set_uncertain_state_set(self, uncertain_state_set): self.uncertain_state_set = uncertain_state_set
    def add_uncertain_state_set(self, value): self.uncertain_state_set.append(value)
    def insert_uncertain_state_set(self, index, value): self.uncertain_state_set[index] = value
    def export(self, outfile, level, namespace_='', name_='StandardPolymorphicStateSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='StandardPolymorphicStateSet')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='StandardPolymorphicStateSet'):
        super(StandardPolymorphicStateSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='StandardPolymorphicStateSet')
    def exportChildren(self, outfile, level, namespace_='', name_='StandardPolymorphicStateSet', fromsubclass_=False):
        for member_ in self.member:
            member_.export(outfile, level, namespace_, name_='member')
        for uncertain_state_set_ in self.uncertain_state_set:
            uncertain_state_set_.export(outfile, level, namespace_, name_='uncertain_state_set')
    def hasContent_(self):
        if (
            self.member or
            self.uncertain_state_set or
            super(StandardPolymorphicStateSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='StandardPolymorphicStateSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(StandardPolymorphicStateSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(StandardPolymorphicStateSet, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('member=[\n')
        level += 1
        for member_ in self.member:
            showIndent(outfile, level)
            outfile.write('model_.StandardMapping(\n')
            member_.exportLiteral(outfile, level, name_='StandardMapping')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('uncertain_state_set=[\n')
        level += 1
        for uncertain_state_set_ in self.uncertain_state_set:
            showIndent(outfile, level)
            outfile.write('model_.StandardUncertainStateSet(\n')
            uncertain_state_set_.exportLiteral(outfile, level, name_='StandardUncertainStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(StandardPolymorphicStateSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'member':
            obj_ = StandardMapping.factory()
            obj_.build(child_)
            self.member.append(obj_)
        elif nodeName_ == 'uncertain_state_set':
            obj_ = StandardUncertainStateSet.factory()
            obj_.build(child_)
            self.uncertain_state_set.append(obj_)
# end class StandardPolymorphicStateSet


class RnaCells(AbstractCells):
    """A RNA characters block consisting of granular cells preceded by
    metadata."""
    subclass = None
    superclass = AbstractCells
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(RnaCells, self).__init__(about, meta, label, id, otus, format, matrix, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.format = format
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if RnaCells.subclass:
            return RnaCells.subclass(*args_, **kwargs_)
        else:
            return RnaCells(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='RnaCells', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RnaCells')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RnaCells'):
        super(RnaCells, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RnaCells')
    def exportChildren(self, outfile, level, namespace_='', name_='RnaCells', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.format:
            self.format.export(outfile, level, namespace_, name_='format')
        if self.matrix:
            self.matrix.export(outfile, level, namespace_, name_='matrix', )
    def hasContent_(self):
        if (
            self.meta or
            self.format is not None or
            self.matrix is not None or
            super(RnaCells, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RnaCells'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RnaCells, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RnaCells, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.RNAFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.matrix is not None:
            showIndent(outfile, level)
            outfile.write('matrix=model_.RNAObsMatrix(\n')
            self.matrix.exportLiteral(outfile, level, name_='matrix')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RnaCells, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'format':
            obj_ = RNAFormat.factory()
            obj_.build(child_)
            self.set_format(obj_)
        elif nodeName_ == 'matrix':
            obj_ = RNAObsMatrix.factory()
            obj_.build(child_)
            self.set_matrix(obj_)
# end class RnaCells


class RnaSeqs(AbstractSeqs):
    """A RNA characters block consisting of sequences preceded by metadata."""
    subclass = None
    superclass = AbstractSeqs
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(RnaSeqs, self).__init__(about, meta, label, id, otus, format, matrix, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.format = format
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if RnaSeqs.subclass:
            return RnaSeqs.subclass(*args_, **kwargs_)
        else:
            return RnaSeqs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='RnaSeqs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RnaSeqs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RnaSeqs'):
        super(RnaSeqs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RnaSeqs')
    def exportChildren(self, outfile, level, namespace_='', name_='RnaSeqs', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.format:
            self.format.export(outfile, level, namespace_, name_='format', )
        if self.matrix:
            self.matrix.export(outfile, level, namespace_, name_='matrix', )
    def hasContent_(self):
        if (
            self.meta or
            self.format is not None or
            self.matrix is not None or
            super(RnaSeqs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RnaSeqs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RnaSeqs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RnaSeqs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.RNAFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.matrix is not None:
            showIndent(outfile, level)
            outfile.write('matrix=model_.RNASeqMatrix(\n')
            self.matrix.exportLiteral(outfile, level, name_='matrix')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RnaSeqs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'format':
            obj_ = RNAFormat.factory()
            obj_.build(child_)
            self.set_format(obj_)
        elif nodeName_ == 'matrix':
            obj_ = RNASeqMatrix.factory()
            obj_.build(child_)
            self.set_matrix(obj_)
# end class RnaSeqs


class RNAPolymorphicStateSet(AbstractPolymorphicStateSet):
    """The RNAPolymorphicStateSet describes a single polymorphic IUPAC
    ambiguity mapping."""
    subclass = None
    superclass = AbstractPolymorphicStateSet
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, member=None, uncertain_state_set=None, valueOf_=None):
        super(RNAPolymorphicStateSet, self).__init__(about, meta, label, id, symbol, member, uncertain_state_set, )
        self.symbol = _cast(None, symbol)
        if member is None:
            self.member = []
        else:
            self.member = member
        if uncertain_state_set is None:
            self.uncertain_state_set = []
        else:
            self.uncertain_state_set = uncertain_state_set
    def factory(*args_, **kwargs_):
        if RNAPolymorphicStateSet.subclass:
            return RNAPolymorphicStateSet.subclass(*args_, **kwargs_)
        else:
            return RNAPolymorphicStateSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_member(self): return self.member
    def set_member(self, member): self.member = member
    def add_member(self, value): self.member.append(value)
    def insert_member(self, index, value): self.member[index] = value
    def get_uncertain_state_set(self): return self.uncertain_state_set
    def set_uncertain_state_set(self, uncertain_state_set): self.uncertain_state_set = uncertain_state_set
    def add_uncertain_state_set(self, value): self.uncertain_state_set.append(value)
    def insert_uncertain_state_set(self, index, value): self.uncertain_state_set[index] = value
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def validate_RNAToken(self, value):
        # Validate type RNAToken, a restriction on AbstractSymbol.
        pass
    def export(self, outfile, level, namespace_='', name_='RNAPolymorphicStateSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RNAPolymorphicStateSet')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RNAPolymorphicStateSet'):
        super(RNAPolymorphicStateSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RNAPolymorphicStateSet')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (quote_attrib(self.symbol), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RNAPolymorphicStateSet', fromsubclass_=False):
        for member_ in self.member:
            member_.export(outfile, level, namespace_, name_='member')
        for uncertain_state_set_ in self.uncertain_state_set:
            uncertain_state_set_.export(outfile, level, namespace_, name_='uncertain_state_set')
    def hasContent_(self):
        if (
            self.member or
            self.uncertain_state_set or
            super(RNAPolymorphicStateSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RNAPolymorphicStateSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = "%s",\n' % (self.symbol,))
        super(RNAPolymorphicStateSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RNAPolymorphicStateSet, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('member=[\n')
        level += 1
        for member_ in self.member:
            showIndent(outfile, level)
            outfile.write('model_.RNAMapping(\n')
            member_.exportLiteral(outfile, level, name_='RNAMapping')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('uncertain_state_set=[\n')
        level += 1
        for uncertain_state_set_ in self.uncertain_state_set:
            showIndent(outfile, level)
            outfile.write('model_.RNAUncertainStateSet(\n')
            uncertain_state_set_.exportLiteral(outfile, level, name_='RNAUncertainStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            self.symbol = value
            self.validate_RNAToken(self.symbol)    # validate type RNAToken
        super(RNAPolymorphicStateSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'member':
            obj_ = RNAMapping.factory()
            obj_.build(child_)
            self.member.append(obj_)
        elif nodeName_ == 'uncertain_state_set':
            obj_ = RNAUncertainStateSet.factory()
            obj_.build(child_)
            self.uncertain_state_set.append(obj_)
# end class RNAPolymorphicStateSet


class RestrictionCells(AbstractCells):
    """A standard characters block consisting of granular cells preceded by
    metadata."""
    subclass = None
    superclass = AbstractCells
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(RestrictionCells, self).__init__(about, meta, label, id, otus, format, matrix, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.format = format
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if RestrictionCells.subclass:
            return RestrictionCells.subclass(*args_, **kwargs_)
        else:
            return RestrictionCells(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='RestrictionCells', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionCells')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RestrictionCells'):
        super(RestrictionCells, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionCells')
    def exportChildren(self, outfile, level, namespace_='', name_='RestrictionCells', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.format:
            self.format.export(outfile, level, namespace_, name_='format', )
        if self.matrix:
            self.matrix.export(outfile, level, namespace_, name_='matrix', )
    def hasContent_(self):
        if (
            self.meta or
            self.format is not None or
            self.matrix is not None or
            super(RestrictionCells, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RestrictionCells'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RestrictionCells, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RestrictionCells, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.RestrictionFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.matrix is not None:
            showIndent(outfile, level)
            outfile.write('matrix=model_.RestrictionObsMatrix(\n')
            self.matrix.exportLiteral(outfile, level, name_='matrix')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RestrictionCells, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'format':
            obj_ = RestrictionFormat.factory()
            obj_.build(child_)
            self.set_format(obj_)
        elif nodeName_ == 'matrix':
            obj_ = RestrictionObsMatrix.factory()
            obj_.build(child_)
            self.set_matrix(obj_)
# end class RestrictionCells


class RestrictionSeqs(AbstractSeqs):
    """A restriction site characters block consisting of sequences preceded
    by metadata."""
    subclass = None
    superclass = AbstractSeqs
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(RestrictionSeqs, self).__init__(about, meta, label, id, otus, format, matrix, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.format = format
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if RestrictionSeqs.subclass:
            return RestrictionSeqs.subclass(*args_, **kwargs_)
        else:
            return RestrictionSeqs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='RestrictionSeqs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionSeqs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RestrictionSeqs'):
        super(RestrictionSeqs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RestrictionSeqs')
    def exportChildren(self, outfile, level, namespace_='', name_='RestrictionSeqs', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.format:
            self.format.export(outfile, level, namespace_, name_='format', )
        if self.matrix:
            self.matrix.export(outfile, level, namespace_, name_='matrix', )
    def hasContent_(self):
        if (
            self.meta or
            self.format is not None or
            self.matrix is not None or
            super(RestrictionSeqs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RestrictionSeqs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RestrictionSeqs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RestrictionSeqs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.RestrictionFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.matrix is not None:
            showIndent(outfile, level)
            outfile.write('matrix=model_.RestrictionSeqMatrix(\n')
            self.matrix.exportLiteral(outfile, level, name_='matrix')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RestrictionSeqs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'format':
            obj_ = RestrictionFormat.factory()
            obj_.build(child_)
            self.set_format(obj_)
        elif nodeName_ == 'matrix':
            obj_ = RestrictionSeqMatrix.factory()
            obj_.build(child_)
            self.set_matrix(obj_)
# end class RestrictionSeqs


class ProteinCells(AbstractCells):
    """An amino acid characters block consisting of granular cells preceded
    by metadata."""
    subclass = None
    superclass = AbstractCells
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(ProteinCells, self).__init__(about, meta, label, id, otus, format, matrix, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.format = format
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if ProteinCells.subclass:
            return ProteinCells.subclass(*args_, **kwargs_)
        else:
            return ProteinCells(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='ProteinCells', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProteinCells')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ProteinCells'):
        super(ProteinCells, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ProteinCells')
    def exportChildren(self, outfile, level, namespace_='', name_='ProteinCells', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.format:
            self.format.export(outfile, level, namespace_, name_='format', )
        if self.matrix:
            self.matrix.export(outfile, level, namespace_, name_='matrix', )
    def hasContent_(self):
        if (
            self.meta or
            self.format is not None or
            self.matrix is not None or
            super(ProteinCells, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ProteinCells'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ProteinCells, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ProteinCells, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.AAFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.matrix is not None:
            showIndent(outfile, level)
            outfile.write('matrix=model_.AAObsMatrix(\n')
            self.matrix.exportLiteral(outfile, level, name_='matrix')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ProteinCells, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'format':
            obj_ = AAFormat.factory()
            obj_.build(child_)
            self.set_format(obj_)
        elif nodeName_ == 'matrix':
            obj_ = AAObsMatrix.factory()
            obj_.build(child_)
            self.set_matrix(obj_)
# end class ProteinCells


class ProteinSeqs(AbstractSeqs):
    """An amino acid characters block consisting of sequences preceded by
    metadata."""
    subclass = None
    superclass = AbstractSeqs
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(ProteinSeqs, self).__init__(about, meta, label, id, otus, format, matrix, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.format = format
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if ProteinSeqs.subclass:
            return ProteinSeqs.subclass(*args_, **kwargs_)
        else:
            return ProteinSeqs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='ProteinSeqs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ProteinSeqs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ProteinSeqs'):
        super(ProteinSeqs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ProteinSeqs')
    def exportChildren(self, outfile, level, namespace_='', name_='ProteinSeqs', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.format:
            self.format.export(outfile, level, namespace_, name_='format', )
        if self.matrix:
            self.matrix.export(outfile, level, namespace_, name_='matrix', )
    def hasContent_(self):
        if (
            self.meta or
            self.format is not None or
            self.matrix is not None or
            super(ProteinSeqs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ProteinSeqs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(ProteinSeqs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ProteinSeqs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.AAFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.matrix is not None:
            showIndent(outfile, level)
            outfile.write('matrix=model_.AASeqMatrix(\n')
            self.matrix.exportLiteral(outfile, level, name_='matrix')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(ProteinSeqs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'format':
            obj_ = AAFormat.factory()
            obj_.build(child_)
            self.set_format(obj_)
        elif nodeName_ == 'matrix':
            obj_ = AASeqMatrix.factory()
            obj_.build(child_)
            self.set_matrix(obj_)
# end class ProteinSeqs


class AAPolymorphicStateSet(AbstractPolymorphicStateSet):
    """The AAPolymorphicStateSet defines a polymorphic ambiguity mapping."""
    subclass = None
    superclass = AbstractPolymorphicStateSet
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, member=None, uncertain_state_set=None, valueOf_=None):
        super(AAPolymorphicStateSet, self).__init__(about, meta, label, id, symbol, member, uncertain_state_set, )
        self.symbol = _cast(None, symbol)
        if member is None:
            self.member = []
        else:
            self.member = member
        if uncertain_state_set is None:
            self.uncertain_state_set = []
        else:
            self.uncertain_state_set = uncertain_state_set
    def factory(*args_, **kwargs_):
        if AAPolymorphicStateSet.subclass:
            return AAPolymorphicStateSet.subclass(*args_, **kwargs_)
        else:
            return AAPolymorphicStateSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_member(self): return self.member
    def set_member(self, member): self.member = member
    def add_member(self, value): self.member.append(value)
    def insert_member(self, index, value): self.member[index] = value
    def get_uncertain_state_set(self): return self.uncertain_state_set
    def set_uncertain_state_set(self, uncertain_state_set): self.uncertain_state_set = uncertain_state_set
    def add_uncertain_state_set(self, value): self.uncertain_state_set.append(value)
    def insert_uncertain_state_set(self, index, value): self.uncertain_state_set[index] = value
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def validate_AAToken(self, value):
        # Validate type AAToken, a restriction on AbstractSymbol.
        pass
    def export(self, outfile, level, namespace_='', name_='AAPolymorphicStateSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='AAPolymorphicStateSet')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='AAPolymorphicStateSet'):
        super(AAPolymorphicStateSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='AAPolymorphicStateSet')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (quote_attrib(self.symbol), ))
    def exportChildren(self, outfile, level, namespace_='', name_='AAPolymorphicStateSet', fromsubclass_=False):
        for member_ in self.member:
            member_.export(outfile, level, namespace_, name_='member')
        for uncertain_state_set_ in self.uncertain_state_set:
            uncertain_state_set_.export(outfile, level, namespace_, name_='uncertain_state_set')
    def hasContent_(self):
        if (
            self.member or
            self.uncertain_state_set or
            super(AAPolymorphicStateSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='AAPolymorphicStateSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = "%s",\n' % (self.symbol,))
        super(AAPolymorphicStateSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(AAPolymorphicStateSet, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('member=[\n')
        level += 1
        for member_ in self.member:
            showIndent(outfile, level)
            outfile.write('model_.AAMapping(\n')
            member_.exportLiteral(outfile, level, name_='AAMapping')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('uncertain_state_set=[\n')
        level += 1
        for uncertain_state_set_ in self.uncertain_state_set:
            showIndent(outfile, level)
            outfile.write('model_.AAUncertainStateSet(\n')
            uncertain_state_set_.exportLiteral(outfile, level, name_='AAUncertainStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            self.symbol = value
            self.validate_AAToken(self.symbol)    # validate type AAToken
        super(AAPolymorphicStateSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'member':
            obj_ = AAMapping.factory()
            obj_.build(child_)
            self.member.append(obj_)
        elif nodeName_ == 'uncertain_state_set':
            obj_ = AAUncertainStateSet.factory()
            obj_.build(child_)
            self.uncertain_state_set.append(obj_)
# end class AAPolymorphicStateSet


class DnaCells(AbstractCells):
    """A DNA characters block consisting of granular cells preceded by
    metadata."""
    subclass = None
    superclass = AbstractCells
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(DnaCells, self).__init__(about, meta, label, id, otus, format, matrix, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.format = format
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if DnaCells.subclass:
            return DnaCells.subclass(*args_, **kwargs_)
        else:
            return DnaCells(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='DnaCells', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DnaCells')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DnaCells'):
        super(DnaCells, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DnaCells')
    def exportChildren(self, outfile, level, namespace_='', name_='DnaCells', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.format:
            self.format.export(outfile, level, namespace_, name_='format', )
        if self.matrix:
            self.matrix.export(outfile, level, namespace_, name_='matrix', )
    def hasContent_(self):
        if (
            self.meta or
            self.format is not None or
            self.matrix is not None or
            super(DnaCells, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DnaCells'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DnaCells, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DnaCells, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.DNAFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.matrix is not None:
            showIndent(outfile, level)
            outfile.write('matrix=model_.DNAObsMatrix(\n')
            self.matrix.exportLiteral(outfile, level, name_='matrix')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DnaCells, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'format':
            obj_ = DNAFormat.factory()
            obj_.build(child_)
            self.set_format(obj_)
        elif nodeName_ == 'matrix':
            obj_ = DNAObsMatrix.factory()
            obj_.build(child_)
            self.set_matrix(obj_)
# end class DnaCells


class DnaSeqs(AbstractSeqs):
    """A DNA characters block consisting of sequences preceded by metadata."""
    subclass = None
    superclass = AbstractSeqs
    def __init__(self, about=None, meta=None, label=None, id=None, otus=None, format=None, matrix=None, valueOf_=None):
        super(DnaSeqs, self).__init__(about, meta, label, id, otus, format, matrix, )
        if meta is None:
            self.meta = []
        else:
            self.meta = meta
        self.format = format
        self.matrix = matrix
    def factory(*args_, **kwargs_):
        if DnaSeqs.subclass:
            return DnaSeqs.subclass(*args_, **kwargs_)
        else:
            return DnaSeqs(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_meta(self): return self.meta
    def set_meta(self, meta): self.meta = meta
    def add_meta(self, value): self.meta.append(value)
    def insert_meta(self, index, value): self.meta[index] = value
    def get_format(self): return self.format
    def set_format(self, format): self.format = format
    def get_matrix(self): return self.matrix
    def set_matrix(self, matrix): self.matrix = matrix
    def export(self, outfile, level, namespace_='', name_='DnaSeqs', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DnaSeqs')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DnaSeqs'):
        super(DnaSeqs, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DnaSeqs')
    def exportChildren(self, outfile, level, namespace_='', name_='DnaSeqs', fromsubclass_=False):
        for meta_ in self.get_meta():
            meta_.export(outfile, level, namespace_, name_='meta')
        if self.format:
            self.format.export(outfile, level, namespace_, name_='format', )
        if self.matrix:
            self.matrix.export(outfile, level, namespace_, name_='matrix', )
    def hasContent_(self):
        if (
            self.meta or
            self.format is not None or
            self.matrix is not None or
            super(DnaSeqs, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DnaSeqs'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(DnaSeqs, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DnaSeqs, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('meta=[\n')
        level += 1
        for meta_ in self.meta:
            showIndent(outfile, level)
            outfile.write('model_.Meta(\n')
            meta_.exportLiteral(outfile, level, name_='Meta')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.format is not None:
            showIndent(outfile, level)
            outfile.write('format=model_.DNAFormat(\n')
            self.format.exportLiteral(outfile, level, name_='format')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.matrix is not None:
            showIndent(outfile, level)
            outfile.write('matrix=model_.DNASeqMatrix(\n')
            self.matrix.exportLiteral(outfile, level, name_='matrix')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(DnaSeqs, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'meta':
            type_name_ = child_.attrib.get('{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <meta> element')
            self.meta.append(obj_)
        elif nodeName_ == 'format':
            obj_ = DNAFormat.factory()
            obj_.build(child_)
            self.set_format(obj_)
        elif nodeName_ == 'matrix':
            obj_ = DNASeqMatrix.factory()
            obj_.build(child_)
            self.set_matrix(obj_)
# end class DnaSeqs


class DNAPolymorphicStateSet(AbstractPolymorphicStateSet):
    """The DNAPolymorphicStateSet type defines an IUPAC ambiguity mapping.
    It may enclose zero or more AbstractMapping elements to resolve
    ambiguities."""
    subclass = None
    superclass = AbstractPolymorphicStateSet
    def __init__(self, about=None, meta=None, label=None, id=None, symbol=None, member=None, uncertain_state_set=None, valueOf_=None):
        super(DNAPolymorphicStateSet, self).__init__(about, meta, label, id, symbol, member, uncertain_state_set, )
        self.symbol = _cast(None, symbol)
        if member is None:
            self.member = []
        else:
            self.member = member
        if uncertain_state_set is None:
            self.uncertain_state_set = []
        else:
            self.uncertain_state_set = uncertain_state_set
    def factory(*args_, **kwargs_):
        if DNAPolymorphicStateSet.subclass:
            return DNAPolymorphicStateSet.subclass(*args_, **kwargs_)
        else:
            return DNAPolymorphicStateSet(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_member(self): return self.member
    def set_member(self, member): self.member = member
    def add_member(self, value): self.member.append(value)
    def insert_member(self, index, value): self.member[index] = value
    def get_uncertain_state_set(self): return self.uncertain_state_set
    def set_uncertain_state_set(self, uncertain_state_set): self.uncertain_state_set = uncertain_state_set
    def add_uncertain_state_set(self, value): self.uncertain_state_set.append(value)
    def insert_uncertain_state_set(self, index, value): self.uncertain_state_set[index] = value
    def get_symbol(self): return self.symbol
    def set_symbol(self, symbol): self.symbol = symbol
    def validate_DNAToken(self, value):
        # Validate type DNAToken, a restriction on AbstractSymbol.
        pass
    def export(self, outfile, level, namespace_='', name_='DNAPolymorphicStateSet', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DNAPolymorphicStateSet')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DNAPolymorphicStateSet'):
        super(DNAPolymorphicStateSet, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DNAPolymorphicStateSet')
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            outfile.write(' symbol=%s' % (quote_attrib(self.symbol), ))
    def exportChildren(self, outfile, level, namespace_='', name_='DNAPolymorphicStateSet', fromsubclass_=False):
        for member_ in self.member:
            member_.export(outfile, level, namespace_, name_='member')
        for uncertain_state_set_ in self.uncertain_state_set:
            uncertain_state_set_.export(outfile, level, namespace_, name_='uncertain_state_set')
    def hasContent_(self):
        if (
            self.member or
            self.uncertain_state_set or
            super(DNAPolymorphicStateSet, self).hasContent_()
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='DNAPolymorphicStateSet'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.symbol is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            showIndent(outfile, level)
            outfile.write('symbol = "%s",\n' % (self.symbol,))
        super(DNAPolymorphicStateSet, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(DNAPolymorphicStateSet, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('member=[\n')
        level += 1
        for member_ in self.member:
            showIndent(outfile, level)
            outfile.write('model_.DNAMapping(\n')
            member_.exportLiteral(outfile, level, name_='DNAMapping')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('uncertain_state_set=[\n')
        level += 1
        for uncertain_state_set_ in self.uncertain_state_set:
            showIndent(outfile, level)
            outfile.write('model_.DNAUncertainStateSet(\n')
            uncertain_state_set_.exportLiteral(outfile, level, name_='DNAUncertainStateSet')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('symbol', node)
        if value is not None and 'symbol' not in already_processed:
            already_processed.append('symbol')
            self.symbol = value
            self.validate_DNAToken(self.symbol)    # validate type DNAToken
        super(DNAPolymorphicStateSet, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'member':
            obj_ = DNAMapping.factory()
            obj_.build(child_)
            self.member.append(obj_)
        elif nodeName_ == 'uncertain_state_set':
            obj_ = DNAUncertainStateSet.factory()
            obj_.build(child_)
            self.uncertain_state_set.append(obj_)
# end class DNAPolymorphicStateSet


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Nexml'
        rootClass = Nexml
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('<?xml version="1.0" ?>\n')
##     rootObj.export(sys.stdout, 0, name_=rootTag, 
##         namespacedef_='xmlns:nex="http://www.nexml.org/2009"')
    return rootObj


def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Nexml'
        rootClass = Nexml
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('<?xml version="1.0" ?>\n')
##     rootObj.export(sys.stdout, 0, name_="Nexml",
##         namespacedef_='xmlns:nex="http://www.nexml.org/2009"')
    return rootObj


def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Nexml'
        rootClass = Nexml
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
##     sys.stdout.write('#from nexml import *\n\n')
##     sys.stdout.write('import nexml as model_\n\n')
##     sys.stdout.write('rootObj = model_.rootTag(\n')
##     rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
##     sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "AAChar",
    "AAFormat",
    "AAMapping",
    "AAMatrixObsRow",
    "AAMatrixSeqRow",
    "AAObs",
    "AAObsMatrix",
    "AAPolymorphicStateSet",
    "AASeqMatrix",
    "AAState",
    "AAStates",
    "AAUncertainStateSet",
    "AbstractBlock",
    "AbstractCells",
    "AbstractChar",
    "AbstractEdge",
    "AbstractFormat",
    "AbstractMapping",
    "AbstractNetwork",
    "AbstractNode",
    "AbstractObs",
    "AbstractObsMatrix",
    "AbstractObsRow",
    "AbstractPolymorphicStateSet",
    "AbstractRootEdge",
    "AbstractSeqMatrix",
    "AbstractSeqRow",
    "AbstractSeqs",
    "AbstractSet",
    "AbstractState",
    "AbstractStates",
    "AbstractTree",
    "AbstractTrees",
    "AbstractUncertainStateSet",
    "Annotated",
    "Base",
    "CellSet",
    "CharSet",
    "ContinuousCells",
    "ContinuousChar",
    "ContinuousFormat",
    "ContinuousMatrixObsRow",
    "ContinuousMatrixSeqRow",
    "ContinuousObs",
    "ContinuousObsMatrix",
    "ContinuousSeqMatrix",
    "ContinuousSeqs",
    "DNAChar",
    "DNAFormat",
    "DNAMapping",
    "DNAMatrixObsRow",
    "DNAMatrixSeqRow",
    "DNAObs",
    "DNAObsMatrix",
    "DNAPolymorphicStateSet",
    "DNASeqMatrix",
    "DNAState",
    "DNAStates",
    "DNAUncertainStateSet",
    "DnaCells",
    "DnaSeqs",
    "FloatNetwork",
    "FloatTree",
    "IDTagged",
    "IntNetwork",
    "IntTree",
    "Labelled",
    "LiteralMeta",
    "Meta",
    "NetworkFloatEdge",
    "NetworkIntEdge",
    "NetworkNode",
    "Nexml",
    "NodeAndRootEdgeAndEdgeSet",
    "OptionalTaxonLinked",
    "ProteinCells",
    "ProteinSeqs",
    "RNAChar",
    "RNAFormat",
    "RNAMapping",
    "RNAMatrixObsRow",
    "RNAMatrixSeqRow",
    "RNAObs",
    "RNAObsMatrix",
    "RNAPolymorphicStateSet",
    "RNASeqMatrix",
    "RNAState",
    "RNAStates",
    "RNAUncertainStateSet",
    "ResourceMeta",
    "RestrictionCells",
    "RestrictionChar",
    "RestrictionFormat",
    "RestrictionMatrixObsRow",
    "RestrictionMatrixSeqRow",
    "RestrictionObs",
    "RestrictionObsMatrix",
    "RestrictionSeqMatrix",
    "RestrictionSeqs",
    "RestrictionState",
    "RestrictionStates",
    "RnaCells",
    "RnaSeqs",
    "RowSet",
    "StandardCells",
    "StandardChar",
    "StandardFormat",
    "StandardMapping",
    "StandardMatrixObsRow",
    "StandardMatrixSeqRow",
    "StandardObs",
    "StandardObsMatrix",
    "StandardPolymorphicStateSet",
    "StandardSeqMatrix",
    "StandardSeqs",
    "StandardState",
    "StandardStates",
    "StandardUncertainStateSet",
    "StateSet",
    "Taxa",
    "TaxaLinked",
    "Taxon",
    "TaxonLinked",
    "TaxonSet",
    "TreeAndNetworkSet",
    "TreeFloatEdge",
    "TreeFloatRootEdge",
    "TreeIntEdge",
    "TreeIntRootEdge",
    "TreeNode",
    "Trees",
    "attrExtensions"
    ]
