import wx, wx.html
from etmParsers import *

class ETMhtml(wx.Frame):
    def __init__(self, size=wx.DefaultSize):
        wx.Frame.__init__(self, None, -1, 'etm', size=size)
        self.html = wx.html.HtmlWindow(self)
        if "gtk2" in wx.PlatformInfo:
            self.html.SetStandardFonts(htmlfont+4, '', '')
        else:
            self.html.SetFonts('', '', [i for i in range(htmlfont,
                htmlfont+13,2)])
        self.html.SetRelatedFrame(self, "%s")
        button = wx.Button(self, wx.ID_OK)
        button.SetDefault()
        self.printer = wx.html.HtmlEasyPrinting()
        self.printer.SetFonts('', '', [i for i in range(htmlprintfont,
            htmlprintfont+13, 2)])
        self.printdata = self.printer.GetPrintData()
        self.printdata.SetColour(False)
        self.Bind(wx.EVT_BUTTON, self.OnQuit, button)
        self.Bind(wx.EVT_CHAR, self.OnChar)
        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.html, 1, wx.EXPAND | wx.ALL, 4)
        sizer.Add(button, 0, wx.ALIGN_CENTER | wx.BOTTOM, 4)
        self.SetSizer(sizer)
        self.Layout()
        
    def SetPage(self, text):
        self.page = text
        self.html.SetPage(self.page)

    def OnChar(self, event):
        keycode = event.GetKeyCode()
        if keycode == 17:         # Ctrl-Q quit
            self.OnQuit(event)
        elif keycode == 16:         # Ctrl-P print
            self.OnPrint(event)
        else:
            event.Skip()

    def OnPrint(self, event):
        self.printer.SetHeader(
          '<center><font size="+1">%s</font></center>' %
          self.html.GetOpenedPageTitle())
        self.printer.SetFooter(
                '<center>Page @PAGENUM@ of @PAGESCNT@</center>')
        self.printer.PrintText(self.page)


    def OnQuit(self,event):
        self.Destroy()


class App(wx.App):
    def OnInit(self):
        self.frame = ETMhtml(size=(200, 200))
        self.frame.SetPage('<title>test title</title> <b>test text</b>')
        self.frame.Show(True)
        self.SetTopWindow(self.frame)
        return True
        
def main():
    app = App(redirect=False)
    app.MainLoop()
    
if __name__ == '__main__':
    main()