# etmRC.py
import sys, os, os.path, codecs
has_etmrc = False

rc = []
added = []
msg = []
error = []
warn = []
fatal = False
warning = False
set_ed = False
search_path = os.getenv('PATH').split(os.pathsep)
cwd = os.getcwd()
homedir = os.path.expanduser("~")
etmrc_maybe = os.path.join(cwd, 'rc')
if os.path.isfile(etmrc_maybe):
    etmdir = cwd
    etmrc = etmrc_maybe
else:
    etmdir = os.path.join(homedir, ".etm")
    etmrc = os.path.join(homedir, ".etm", "rc")

if sys.platform == 'darwin':
    mac = True
    d_bgcolor = 'GRAY70'
    d_selectcolor = [64, 208, 64, 48]
    d_busycolor = [64, 208, 64]
    d_basefont = 12
    d_htmlfont = 8
    d_htmlprintfont = 5
    d_calfont = 0
    d_width = 560 
    d_height = 360
    d_statusfontadj = 0
    d_listfontadj = 0
    d_datefontadj = 0
    d_buttonfontadj = 0
else:
    mac = False
    d_bgcolor = 'GRAY85'
    d_selectcolor = [160, 255, 144, 128]
    d_busycolor = [0, 160, 0]
    d_basefont = 8
    d_htmlfont = 4
    d_htmlprintfont = 5
    d_calfont = 8
    d_width = 640
    d_height = 360
    d_statusfontadj = 0
    d_listfontadj = 0
    d_datefontadj = 0
    d_buttonfontadj = 0

def PathSearch(filename):
    for path in search_path:
        candidate = os.path.join(path,filename)
        if os.path.os.path.isfile(candidate):
            return os.path.abspath(candidate)
    return ''
    
def check(variable):
    global rc, added
    name = variable[0]
    defining_code = variable[1]
    description = "\n### ".join(variable[2:])
    if description:
        rc.append("\n### %s" % description)
    # if globals().has_key(name):
    if name in globals():
        if type(globals()[name]) == str:
            if globals()[name] != "":
                s = "%s = '''%s'''" % (name, globals()[name])
                # print "not empty: %s = %s" % (name, globals()[name])
            else:
                s = "%s = ''" % (name)
        else:
            s = "%s = %s" % (name, globals()[name])
        rc.append(s)
    else:
        res = ''
        if type(defining_code) == str:
            try:
                exec "res = %s" % defining_code
            except:
                exec "res = '%s'" % defining_code
        elif type(defining_code) in [tuple, list]:
            exec "res = (%s)" % repr(defining_code)
        else:
            exec "res = %s" % defining_code
        globals()[name] = res
        if globals()[name] != "not set":
            # print "Adding: %s" % name
            if type(res) == str:
                if res != "":
                    s = "%s = '''%s'''" % (name, res)
                else:
                    s = "%s = ''" % (name)
            elif type(res) in [tuple, list]:
                s = "%s = %s" % (name, repr(res))
            else:
                s = "%s = %s" % (name, res)
            added.append(s)
            rc.append(s)


def set_etmrc():
    global has_etmrc
    if os.path.isfile(etmrc):
        has_etmrc = True
    return etmrc

def check_etmdir():
    if not os.path.isdir(etmdir):
        os.mkdir(etmdir)
        print("""
Created '%s' to hold etm system files.
\n""" % (etmdir))
    return os.path.isdir(etmdata)

def check_etmdata():
    if not os.path.isdir(etmdata):
        os.mkdir(etmdata)
        print("""
Created '%s' to hold project files.
Users of earlier versions of etm will need either to move their
project files to this subdirectory or to correct the entry for
etmdata in '%s'.\n""" % (etmdata, etmrc))
    return os.path.isdir(etmdata)

def check_export():
    if not os.path.isdir(export):
        os.mkdir(export)
        print("""
Created '%s' to hold exported files.
This location is specified by  the entry for export in '%s'.\n""" % (export,etmrc))
    return os.path.isdir(etmdata)

def set_editor_settings():
    global rc, added, set_ed
    chooselater = ['choose later', '', '', '']
    comment = ""
    selected = []
    unselected = []
    if set_ed:
        return None
    else:
        set_ed = True
    if mac:
        options = {
            'bbedit' : [
                "editcmd = '''%(e)s +%(n)s -w --new-window %(f)s'''",
            ],
            'edit' : [
                "editcmd = '''%(e)s +%(n)s -w --new-window %(f)s'''",
            ],
            'mate' : [
                "editcmd = '''%(e)s -l %(n)s -w %(f)s'''",
            ],
            'vim' : [
                "editcmd = '''%(e)s -g -p -f +%(n)s %(f)s'''",
            ],
        }
        for name in ['bbedit','mate', 'vim', 'edit']:
            editor = PathSearch(name)
            # select the first that works and comment out the others
            if editor:
                if comment != "# ":
                    selected = (editor,
                        options[name][0])
                else:
                    unselected.append(name)
                rc.append("%seditor = '''%s'''" % (comment, editor))
                added.append("%seditor = '''%s'''" % (comment, editor))
                rc.append("%s%s" % (comment, options[name][0]))
                added.append("%s%s" % (comment, options[name][0]))
                comment = "# "
    else: # not mac
        options = {
            'gvim' : [
                "editcmd = '''%(e)s -f +%(n)s %(f)s'''",
            ],
            'emacs' : [
                "editcmd = '''%(e)s +%(n)s %(f)s'''",
            ]
        }
        for name in ['gvim','emacs']:
            editor = PathSearch(name)
            # select the first that works and comment out the others
            if editor:
                if comment != "# ":
                    selected = (editor,
                        options[name][0])
                else:
                    unselected.append(name)
                rc.append("%seditor = '''%s'''" % (comment, editor))
                added.append("%seditor = '''%s'''" % (comment, editor))
                rc.append("%s%s" % (comment, options[name][0]))
                added.append("%s%s" % (comment, options[name][0]))
                comment = "# "
    if selected == []:
        rc.append("editor = ''")
        rc.append("editcmd = ''")
        print("""
        You will need to specify values for:

            editor
            editcmd

        in %s.\n""" % etmrc)
    else:
        print("""
Project files will be located in the directory

    etmdata = '%s'

The following settings were made for your external editor:

    editor = '%s'
    editcmd = '%s'

Edit %s if you wish to make changes.\n""" % (etmdata,
        selected[0], selected[1], etmrc))
        if len(unselected) > 0:
            print("""\
Comparable settings were also made for

    %s

but were commented out. \n""" % ", ".join(unselected))
    return None

def set_editor():
    if not set_ed:
        set_editor_settings()
    return "not set"

def set_editcmd():
    if not set_ed:
        set_editor_settings()
    return "not set"

def trace(func):
    if enable_tracing:
        def callf(*args, **kwargs):
            debug_log.write("Calling %s: %s, %s\n" %
                (func.__name__, args, kwargs))
            r = func(*args, **kwargs)
            debug_log.write("%s returned %s\n" % (func.__name__, r))
            return(r)
        return(callf)
    else:
        return(func)

def make_etmrc():
    fo = open("%s" % etmrc,'w')
    fo.write("""\
### Configuration settings for etm (Event and Task Manager)
###
### etm's current default settings will be written to '~/.etm/rc' if
### this file doesn't already exist. This means you can always restore
### the default settings by either removing or renaming ~/.etm/rc.
### Further, if you would like to restore some but not all of the default
### settings, simply erase the settings you want restored and the next
### time e.py is run, your ~/.etm/rc will be recreated
### with your settings together with the default settings for the ones
### you erased.
###\n""")
    for line in rc:
        fo.write("%s\n" % line)
    fo.close()

variables = [
    ['encoding', '"UTF-8"', 
        'The default encoding for terminal output. Your terminal must',
        ' be able to support output using this encoding.'],
    ['etmdata', "%s" % os.path.join(etmdir,"data"),
        'The directory in which project files will be stored.'],
    ['export', "%s" % os.path.join(etmdir, "export"),
        'The directory in which exported exported iCal/vCal and CSV',
        'files will be stored.'],
    ['inc', 60,
        'The interval in seconds between alert updates'],
    ['rotate_files', True,
        'If true, new rotating files will be created each month in the',
        'format "<current month number>-<item type>.txt".', 
        'Otherwise static files in the format "<item type>.txt" will be',
        'used where <item-type> = action, done, event, and so forth.'],
    ['action', '"actns"',
        'The root for action data files. By default new action entries will be saved to',
        '"<current month number>-ACTION.txt" if rotate_files is true',
        'and otherwise to "ACTION.txt".'],
    ['done', '"done"',
        'The root for finished copies of repeating tasks. By default new events',
        'will be saved to "<current month number>-DONE.txt" if rotate_files is true',
        'and otherwise to "DONE.txt".'],
    ['event', '"evnts"',
        'The root for event data files. By default new events will be saved to',
        '"<current month number>-EVENT.txt" if rotate_files is true',
        'and otherwise to "EVENT.txt".'],
    ['note', '"notes"',
        'The root for note data files. By default new note entries will be saved to',
        '"<current month number>-NOTE.txt" if rotate_files is true',
        'and otherwise to "NOTE.txt".'],
    ['reminder', '"rmdrs"',
        'The root for reminder data files. By default new note entries will be saved to',
        '"<current month number>-REMINDER.txt" if rotate_files is true',
        'and otherwise to "REMINDER.txt".'],
    ['task', '"tasks"',
        'The root for task data files. By default new tasks will be saved to',
        '"<current month number>-TASK.txt" if rotate_files is true',
        'and otherwise to "TASK.txt".'],
    ['action_interval', 10,
        'If positive, an alert will be sounded every action_interval',
        'minutes while the action timer is running.'],
    ['numbaks', 3,
        'The number of backups of data files to keep'],
    ['context', None,
        'The default context for new events and tasks'],
    ['keyword', None,
        'The default keyword for new events and tasks'],
    ['editor', '"%s" % set_editor()',
        'Edit settings',
        'editor:  the full path to the external editor',
        'editcmd: the command for editing an old task, event or action',
        'using the following SUBSTITUTIONS:',
        '   %(e)s -> editor',
        '   %(n)s -> the line number to edit',
        '   %(f)s -> the file name'     ],
    ['editcmd', '"%s" % set_editcmd()', ''],
    ['alertcmd', '''''',
        'The command to run when alerts are triggered with these replacements:',
        '   %(t)s -> thetimeis <current time>',
        '   %(T)s -> <current time>',
        '   %(m)s -> the text of the alert message',
        'If left blank, the default, then an internal alert will be displayed.'],
    ['extent', 30,
        'New events with a starttime but no endtime will, by default,',
        'have an endtime equal to this number of minutes after starttime',
        'when displaying busy and free times'],
    ['increment', 1,
        'When aggregating times for events and action entries, if',
        'the actual number of minutes is m and the increment is i, then',
        'the number of minutes added will be ceil(m/i)*i. E.g. if m=20',
        'and i=15, then ceil(20.0/15.0)*15 = 30 minutes will be added.'],
    ['hours_minutes', False,
        'Display time spent in time reports using hours and minutes (True)',
        'or hours rounded up to the nearest tenth (False).'],
    ['c_position', 0,
        'Time report default setting. If c_position is positive, subtotal by',
        'category in an order determined by the value of c_position.'],
    ['d_position', 0,
        'Time report default setting. If d_position is positive, subtotal by',
        'date in an order determined by the value of d_position.'],
    ['k_level', 0,
        'Time report default setting. If k_level is positive, subtotal by',
        'keywords to a depth corresponding to the value of k_level. E.g.,',
        'if k_level is 2, and there is an item with keyword \'a:b:c\', then',
        'subtotals corresponding to \'a\' and \'a:b\' would be formed.'],
    ['ledger_include', "1010",
        "Four digit string of the form CDKI where C, D, K and I are",
        "integers. Subtotal by category if C is positive and in an order",
        "corresponding to C. Subtotal by date if D is positive and in an",
        "order corresponding to D. Subtotal by keywords to a depth",
        "corresponding to the value of K if positive. E.g., if K is 2,",
        "and there is an item with keyword 'a:b:c', then subtotals",
        "corresponding to 'a' and 'a:b' would be formed."],
    ['use_ampm', True,
        'Display time using 12 hour, AM/PM format (True) or 24 hour format (False)'],
    ['sundayfirst', True,
        'Make Sunday the first day of the week if true'],
    ['opening', "8:00a",
        'The opening or earliest time to consider, by default, in displaying ',
        'unscheduled periods'],
    ['closing', "5:00p",
        'The closing or latest time to consider, by default, in displaying ',
        'unscheduled periods'],
    ['busy_include', "1010",
        "Four digit string of the form bBfF where b, B, f and F are",
        "either 0 or 1. Include busy time bars if b = 1; include busy",
        "times if B = 1; include free time bars if f = 1; include free",
        "times if F = 1."],
    ['minimum', 30,
        'The minimum number of minutes for an free (unscheduled) period to',
        'be displayed'],
    ['slack', 15,
        'The number of minutes before and after busy periods to omit',
        'in computing free periods'],
    ['busychar', '*',
        'The character used to indicate busy periods'],
    ['freechar', '-',
        'The character used to indicate free periods'],
    ['conflictchar', '#',
        'The character used to indicate a more than one event',
        'scheduled for the same time period'],
    ['slotsize', 10,
        'The number of minutes expressed by one character in busy/free time',
        'bars. It must be true that 60 % slotsize = 0. Recommended choices', 
        'are 10, 12 or 15. Using the default, 10, the time bar for 8am - 8pm',
        'would be 12*(60/10) = 72 characters wide. Using 12, the same 12',
        'hour time bar would be 12*(60/12) = 60 characters wide.'],
    ['main_history', [
        '-g d -o fnr', '-g c -o fnr', '-g k -o fnr',
        '-g d -o afnru', '-g c -o afnru', '-g k -o afnru',
        '-g d -o abfnruw', '-g c -o abfnruw', '-g k -o abfnruw',
        ], 
        'A list of option strings to include in the history list for',
        'agenda view.'],
    ['item_history', [
        '-g d -o fnr', '-g c -o fnr', '-g k -o fnr',
        '-g d -o afnru', '-g c -o afnru', '-g k -o afnru',
        '-g d -o abfnruw', '-g c -o abfnruw', '-g k -o abfnruw',
        ], 
        'A list of option strings to include in the history list for',
        'item view.'],
    ['busy_history', [], 
        'A list of option strings to include in the history list for',
        'busy/free view.'],
    ['ledger_history', [], 
        'A list of option strings to include in the history list for',
        'ledger view.'],
    ['templates', [],
        'A list of templates for new tasks and events'],
    ['weekday_fmt', '%a, %b %d',
        'The format to use for the date when grouping by date',
        'using the directives listed above.'],
    ['week_begin', 6,
        'The first day of the week. Monday = 0, Sunday = 6.'],
    ['location', [],
        'The USNO location for sun/moon data. Either a US city-state',
        '2-tuple such as [\'Chapel Hill\', \'NC\'] or',
        'a placename-longitude-latitude 7-tuple such as ',
        '[\'Home\', \'W\', 79, 0, \'N\', 35, 54]',
    ],
    ['basefontsize', d_basefont, 
        'The base font size'],
    ['htmlfont', d_htmlfont, 
        'The starting html font size'],
    ['htmlprintfont', d_htmlprintfont, 
        'The starting html printing font size'],
    ['calfontsize', d_calfont, 
        'The calendar font size. Ignored if set equal to 0.'],
    ['statusfontadj', d_statusfontadj, 
        'The adjustment for the status bar font'],
    ['listfontadj', d_listfontadj, 
        'The adjustment for the item list font'],
    ['datefontadj', d_datefontadj, 
        'The adjustment for the date (title) font'],
    ['buttonfontadj', d_buttonfontadj, 
        'The adjustment for the today button font'],
    ['detail_bgcolor', d_bgcolor, 
            'The background color for the detail (information) bar',
            'in the etm wx gui'],
    ['detail_fgcolor', 'Black', 
            'The foreground color for the detail (information) bar',
            'in the etm wx gui'],
    ['entry_fgcolor', 'Black', 
            'The foreground color for the entry bar',
            'in the etm wx gui'],
    ['entry_bgcolor', 'White', 
            'The background color for the entry bar',
            'in the etm wx gui'],
    ['main_bgcolor', 'White', 
            'The background color for the main window and the entry bar',
            'in the etm wx gui'],
    ['main_fgcolor', 'Black', 
            'The default foreground color for the main window',
            'in the etm wx gui'],
    ['busycolor', d_busycolor, 
            'The background color for busy bars in the busy panel'],
    ['selectcolor', d_selectcolor, 
            'The background color for selected days in the calendar',
            'panel'],
    ['cal_pastcolor', '#FFCCCC',
        'The background color to use for past years in the',
        '12 month calendar'],
    ['cal_currentcolor', '#FFFFCC',
        'The background color to use for the current year in the',
        '12 month calendar'],
    ['cal_futurecolor', '#99CCFF',
        'The background color to use for future years in the',
        '12 month calendar'],
    ['Main', '"main"',
        'Language customizations:',
        'The word to use in the agenda view title bar.',],
    ['Item', '"item"',
        'The word to use in the item view title bar.'],
    ['Busy', '"busy"',
        'The word to use in the busy view title bar.'],
    ['Ledger', '"ledger"',
        'The word to use in the time ledger title bar.'],
    ['Options', '"options"',
        'The word to use in the prompt for options.'],
    ['NoDueDate', '"Without a due date"',
        'The group title for items without a due date.'],
    ['Quit', '"Quit"',
        'The word to use for quit in the command line.'],
    ['Help', '"Help"',
        'The word to use for help in the command line.'],
    ['minutes', 'minutes from now',
        'In alerts, the string to append for more than one minute'],
    ['minute', 'minute from now',
        'In alerts, the string for exactly one minute'],
    ['rightnow', '',
        'In alerts, the string to use for this instant'],
    ['thetimeis', '"The time is"',
        'The prefix for the spoken time'],
    ['weatherlocation', 'USNC0105&u=f',
    'The yahoo weather location code and temperature scale for your area.',
    'Go to http://weather.yahoo.com/, enter your location and hit return.',
    'When the weather page for your location opens, choose view source ',
    '(under the View menu), search for \'forecastrss\' and copy the ',
    'location code that follows \'p=\', e.g., for',
    '       ...forecastrss?p=USNC0120&u=f                                ',
    'the location code would be \'USNC0120&u=f\'. Note: the \'&u=f\'',
    'gives fahrenheit readings while \'&u=c\' would give celcius/centigrade.'],
    ['rising', 'rising', 'Phrase for the barometric pressure is increasing'],
    ['constant', 'steady', 'Phrase for the barometric pressure is constant'],
    ['falling', 'falling', 'Phrase for the barometric pressure is decreasing'],
    ['chill', 'feels like', 'Phrase for the wind chill temperature'],
    ['weather', 'Weather for', 'Phase for weather header'],
    ['current_conditions', 'Current conditions', 'Phrase for current conditions'],
    ['forecast', 'Forecast', 'Phrase for forecast'],
    ]

# main
etmrc = set_etmrc()
if has_etmrc:
    fo = open(etmrc, 'r')
    exec(fo)
    fo.close()

for variable in variables:
    check(variable)

try:
    if sys.stdout.encoding.lower() != encoding.lower():
        # try to reset stdout to the encoding specified in etmrc
        try:
            old_stdout = sys.stdout
            old_encoding = sys.stdout.encoding
            new_stdout = codecs.lookup(encoding)[-1](sys.stdout)
            new_encoding = new_stdout.encoding
            print("""\
    Warning. The encoding of sys.stdout, '%s', does not match the setting
    for 'encoding' in ~/.etm/rc, '%s'.""" % 
            (old_encoding, new_encoding))
        except:
            print("""\
    Error. Output using encoding '%s' is not supported by your terminal.
    Please correct the setting for 'encoding' in ~/.etm/etmrc.
    Using encoding '%s' instead.
    """ % (encoding, sys.stdout.encoding))
            # sys.stdout = old_stdout
except:
    pass

check_etmdir()
check_etmdata()
check_export()

if fatal:
    sys.exit()
    
# enable_tracing = True
enable_tracing = False

if enable_tracing:
    debuglog = os.path.join(etmdir, 'debug.log')
    debug_log = open(debuglog, "w")
    print "Tracing enabled. Writing to '%s'." % debuglog
    
if len(added) > 0:
    if has_etmrc:
        import shutil
        shutil.copyfile(etmrc, "%s.bak" % etmrc)
        make_etmrc()
        fo = open(etmrc, 'r')
        exec(fo)
        fo.close()
        print """\
IMPORTANT: Your configuration file

    %s

has as been copied to

    %s.bak

and a new configuration file which incorporates your settings together
with

    %s

has been saved as

    %s \n""" % (etmrc, etmrc, "\n    ".join(added), etmrc)

    else:
        make_etmrc()
        print("""\
A new configuration file with default settings has been saved as

    %s \n""" % etmrc)

    print """\
Please remember to vote for etm at <http://freshmeat.net/projects/etm/>
and to send your comments to <daniel.graham@duke.edu>. Continuing
improvement depends upon your feedback.

Thanks for using etm!
"""
    raw_input('Press enter to continue')
    if warning:
        sys.exit()