import wx, wx.html
from etmParsers import *
import wx.aui
import etmHelp
page_fmt = "{0:^7}"

help_text = etmHelp.htmlPage['Help']

view_text =  etmHelp.htmlPage['View']

add_text = etmHelp.htmlPage['Add']

examples_text = etmHelp.htmlPage['Examples']

class MyHtmlWindow(wx.html.HtmlWindow):
    def __init__(self, parent, id, pos = wx.DefaultPosition, size=wx.DefaultSize, style=0):
        wx.html.HtmlWindow.__init__(self, parent, id, pos, size,
            style=wx.BORDER_SUNKEN)
        if "gtk2" in wx.PlatformInfo:
            self.SetStandardFonts(htmlfont+4, '', '')
        else:
            self.SetFonts('', '', [i for i in range(htmlfont,
                htmlfont+13, 2)])
        self.page = ''
        self.printer = wx.html.HtmlEasyPrinting()
        self.printer.SetFonts('', '', [i for i in range(htmlprintfont,
            htmlprintfont+13, 2)])
        self.printdata = self.printer.GetPrintData()
        self.printdata.SetColour(False)

    # Keep it from taking the focus
    #  def AcceptsFocus(self, *args, **kwargs):
        #  return False

    def OnPrint(self, event):
        self.printer.SetHeader(
          '<center><font size="+1">%s</font></center>' %
          self.GetOpenedPageTitle())
        self.printer.SetFooter(
                '<center>Page @PAGENUM@ of @PAGESCNT@</center>')
        self.printer.PrintText(self.page)

    def OnChar(self, event):
        keycode = event.GetKeyCode()
        print "OnChar", keycode
        if keycode in [27, 17]:  # Escape, Ctrl-Q
            self.OnOk(event)
        elif keycode in [16]: # Ctrl-P
            self.OnPrint(event)
        elif keycode in [25]: # Ctrl-Y
            self.OnSelect(event)
        else:
            event.Skip()

    def OnSelect(self, event):
        s = self.SelectionToText()
        if s:
            self.do = wx.TextDataObject()
            self.do.SetText(s)
            if wx.TheClipboard.Open():
                wx.TheClipboard.SetData(self.do)
                wx.TheClipboard.Close()
            self.SetPage(self.page)


class ETMhtml(wx.Dialog):
    def __init__(self, parent = None, size=wx.DefaultSize, page = ''):
        wx.Dialog.__init__(
            self, parent, -1, 'etm', size=wx.DefaultSize, pos=wx.DefaultPosition, 
            style=wx.DEFAULT_DIALOG_STYLE)
        self.parent = parent

        sizer = wx.BoxSizer(wx.VERTICAL)

        vbox = wx.BoxSizer(wx.VERTICAL)

        self.html = MyHtmlWindow(self, -1, size=size)
        self.html.Bind(wx.EVT_CHAR, self.OnChar)
        self.html.SetBorders(0)
        self.page = page
        self.html.SetPage(self.page)
        self.html.page = page
        #  self.printer = wx.html.HtmlEasyPrinting()
        self.Bind(wx.EVT_CHAR, self.OnChar)

        vbox.Add(self.html, 1, wx.EXPAND | wx.ALL, 4)
        sizer.Add(vbox, 0, wx.GROW|wx.ALIGN_CENTER_VERTICAL|wx.ALL, 1)

        btnsizer = wx.StdDialogButtonSizer()

        self.btn1 = wx.Button(self, wx.ID_OK)
        self.btn1.SetDefault()
        self.btn1.Bind(wx.EVT_BUTTON, self.OnOk)
        btnsizer.AddButton(self.btn1)

        btnsizer.Realize()

        sizer.Add(btnsizer, 0, wx.ALIGN_CENTER_VERTICAL 
                | wx.ALIGN_CENTER | wx.BOTTOM, 2)

        self.SetSizer(sizer)
        sizer.Fit(self)

    def OnEnter(self, event):
        event = wx.CommandEvent(wx.wxEVT_COMMAND_BUTTON_CLICKED, self.btn1.GetId()) 
        self.btn1.Command(event) 

    def OnChar(self, event):
        keycode = event.GetKeyCode()
        "etmHTML OnChar", keycode
        if keycode in [27, 17]:  # Escape, Ctrl-Q
            self.OnOk(event)
        elif keycode in [16]: # Ctrl-P
            self.html.OnPrint(event)
        elif keycode in [25]: # Ctrl-Y
            self.html.OnSelect(event)
        else:
            event.Skip()

    def OnSelect(self, event):
        self.html.OnSelect(event)

    def OnOk(self, event):
        event.Skip()
        self.Destroy()

class NBPanel(wx.Panel):
    """ etm """

    def __init__(self, parent):
        """ Class constructor. """

        wx.Panel.__init__(self, parent, -1)

        # Create the wx.aui.AuiNotebook
        # create the AuiNotebook instance
        bookStyle = wx.aui.AUI_NB_DEFAULT_STYLE
        bookStyle &= ~(wx.aui.AUI_NB_CLOSE_ON_ACTIVE_TAB)
        monofont = wx.Font(-1, wx.MODERN, wx.NORMAL, wx.NORMAL)
        self.nb = wx.aui.AuiNotebook(self, style=bookStyle)

        # Create a simple text control
        #  help_page = wx.TextCtrl(self.nb, -1, help_text, style=wx.TE_MULTILINE)
        help_page = MyHtmlWindow(self, -1)
        help_page.SetPage(help_text)
        self.nb.AddPage(help_page,  page_fmt.format("ETM Overview"))
        self.help_page = help_page
        self.help_page.page = help_text

        add_page = MyHtmlWindow(self, -1)
        add_page.SetPage(add_text)
        self.nb.AddPage(add_page, page_fmt.format("Item Options"))
        self.add_page = add_page
        self.add_page.page = add_text

        view_page = MyHtmlWindow(self, -1)
        view_page.SetPage(view_text)
        self.nb.AddPage(view_page, page_fmt.format("Display Options"))
        self.view_page = view_page
        self.view_page.page = view_text

        examples_page = MyHtmlWindow(self, -1)
        examples_page.SetPage(examples_text)
        self.nb.AddPage(examples_page, page_fmt.format("Examples"))
        self.examples_page = examples_page
        self.examples_page.page = examples_text

        self.nb.Bind(wx.aui.EVT_AUINOTEBOOK_PAGE_CHANGED, self.OnTabChanged)

        btnsizer = wx.StdDialogButtonSizer()

        self.btn1 = wx.Button(self, wx.ID_OK)
        self.btn1.SetDefault()
        btnsizer.AddButton(self.btn1)

        btnsizer.Realize()


        # Put the wx.aui.AuiNotebook in a sizer and
        # assign the sizer to the main panel
        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.nb, 1, wx.EXPAND)
        sizer.Add(btnsizer, 0, wx.ALIGN_CENTER_VERTICAL 
                | wx.ALIGN_CENTER | wx.BOTTOM, 2)
        self.SetSizer(sizer)

    def SetPage(self, n):
        self.current_page = n
        self.nb.SetSelection(n)

    def OnTabChanged(self, evt):
        newpage=evt.GetSelection()
        #  self.last_page = self.current_page
        self.current_page = newpage

class ETMnb(wx.Frame):
    def __init__(self, parent):
        wx.Frame.__init__(self, parent, -1, 'etm help', size = (580, 600))
        self.parent = parent
        self.panel = NBPanel(self)
        self.Bind(wx.EVT_CHAR, self.OnChar)
        self.panel.btn1.Bind(wx.EVT_BUTTON, self.OnOk)
        if self.parent and self.parent.currentPage:
            page = self.parent.currentPage
        else:
            page = 0
        self.panel.SetPage(page)
        #  self.panel.Bind(wx.EVT_CHAR, self.OnChar)
        self.Bind(wx.EVT_CHAR, self.OnChar)

    def OnChar(self, event):
        keycode = event.GetKeyCode()
        print "ETMnb OnChar", keycode
        if keycode in [27, 17]:  # Escape, Ctrl-Q
            self.OnOk(event)
        elif keycode in [16]: # Ctrl-P
            self.OnPrint(event)
        elif keycode in [25]: # Ctrl-Y
            self.OnSelect(event)
        else:
            event.Skip()

    def OnOk(self, event):
        if event:
            event.Skip()
        #  self.parent.helpFrame = None
        self.Destroy()

    def OnPrint(self, event):
        page = [self.panel.help_page, 
                self.panel.add_page, 
                self.panel.view_page, 
                self.panel.examples_page][self.panel.current_page]
        page.OnPrint(event)

    def OnSelect(self, event):
        page = [self.panel.help_page, 
                self.panel.add_page, 
                self.panel.view_page, 
                self.panel.examples_page][self.panel.current_page]
        page.OnSelect(event)


    def SetPage(self, n):
        self.panel.SetPage(n)

class App(wx.App):
    def OnInit(self):
        frame = ETMnb(None)
        frame.CenterOnScreen()
        frame.Show()
        return(True)


def main():
    app = App(redirect=False)
    app.MainLoop()

if __name__ == '__main__':
    main()
