#!/usr/bin/env python
# encoding: utf-8

import cmd
from etm.etmData import *

year = int(datetime.date.today().strftime("%Y"))
beg_year = year - year_beg
end_year = year + year_end
data_beg = (beg_year, 1, 1)
data_end = (end_year, 12, 31)

common_prefix, all, alerts, busytimes, id2hash, lastmodified, currenthash, \
            contexts, keywords, locations, msgs = \
            getTuples(data_beg, data_end)


class IntOrCmd(cmd.Cmd):
    """Accepts commands via the normal interactive
    prompt or on the command line.
    """
    doc_header = "documented etm commands\nEnter 'help X' for\ndetails about command X"
    misc_header = 'miscellaneous etm commands'
    undoc_header = 'undocumented etm commands'

    def preloop(self):
        if msgs:
            print "Errors loading data"
            for m in msgs:
                print m
        self.prompt = "enter 'q' to quit or 'help' for usage information\netm: "

    def do_b(self, line):
        all_off, attrs, codes = get_attrs()
        opt_lst = []
        tmp = re.split('\s*-', line)
        p = tmp.pop(0)
        for x in tmp:
            if not x:
                continue
            opt_lst.extend(["-%s" % x[0], ("%s" % x[1:]).strip()])
        options = get_opts(nameHash['b'], opt_lst)
        parse_opts(options)
        lst = data2Busy(busytimes, options)
        for l in lst:
            if len(l) >=3:
                a = codes[l[2]]
            else:
                a = ''
            print a, l[0], all_off
        print ''

    def do_B(self, line):
        opt_lst = []
        tmp = re.split('\s*-', line)
        p = tmp.pop(0)
        for x in tmp:
            if not x:
                continue
            opt_lst.extend(["-%s" % x[0], ("%s" % x[1:]).strip()])
        options = get_opts(nameHash['b'], opt_lst)
        parse_opts(options)
        lst = data2Busy(busytimes, options)
        for l in lst:
            print(l[0])
        print ''

    def do_o(self, line):
        all_off, attrs, codes = get_attrs()
        opt_lst = []
        tmp = re.split('\s*-', line)
        p = tmp.pop(0)
        for x in tmp:
            if not x:
                continue
            opt_lst.extend(["-%s" % x[0], ("%s" % x[1:]).strip()])
        options = get_opts(nameHash['o'], opt_lst)
        parse_opts(options)
        dt = data2Report(all, options, id2hash)
        for s, f, a in dt:
            print attrs[a], s, all_off
        if 'vcal' in options and options['vcal']:
            ret, s = make_vcal('export.ics', all, options)
            print("\n%s" % s)
        if 'values' in options and options['values']:
            s = make_csv('export.csv', all, options)
            print("\n%s" % s)
        print ''

    def do_O(self, line):
        opt_lst = []
        tmp = re.split('\s*-', line)
        p = tmp.pop(0)
        for x in tmp:
            if not x:
                continue
            opt_lst.extend(["-%s" % x[0], ("%s" % x[1:]).strip()])
        options = get_opts(nameHash['o'], opt_lst)
        parse_opts(options)
        dt = data2Report(all, options, id2hash)
        for s, f, a in dt:
            print s
        if 'vcal' in options and options['vcal']:
            ret, s = make_vcal('export.ics', all, options)
            print("\n%s" % s)
        if 'values' in options and options['values']:
            s = make_csv('export.csv', all, options)
            print("\n%s" % s)
        print ''

    def do_q(self, line):
        return True

    def do_n(self, line):
        print "%s" % newer()[1]

    def do_w(self, line):
        try:
            import etm.etmWX
            etm.etmWX.main()
        except:
            print('Errors importing etm.etmWX ')
            print(sys.exc_info())

    def busy_help(self):
        parser = ETMOptParser(usage = '')
        for opt in parserOpts[nameHash['b']]:
            s, a, dst, dflt, hlp = optionParms[opt]
            if dflt:
                parser.add_option(s, action = a, dest = dst, default = dflt, 
                        help = hlp)
            else:
                    parser.add_option(s, action = a, dest = dst,  help = hlp)
        parser.print_help()

    def help_b(self): 
        print "Busy report using colors"
        print "b [options]"
        self.busy_help()

    def help_B(self): 
        print "Busy report without colors"
        print "B [options]"
        self.busy_help()

    def outline_help(self):
        parser = ETMOptParser(usage = '')
        for opt in parserOpts[nameHash['o']]:
            s, a, dst, dflt, hlp = optionParms[opt]
            if dflt:
                parser.add_option(s, action = a, dest = dst, default = dflt, 
                        help = hlp)
            else:
                    parser.add_option(s, action = a, dest = dst,  help = hlp)
        parser.print_help()

    def help_o(self): 
        print "Outline report using colors"
        print "o [options]"
        self.busy_help()

    def help_O(self): 
        print "Outline report without colors"
        print "O [options]"
        self.busy_help()

    def help_n(self): 
        print "Check for a newer version of etm"

    def help_w(self): 
        print """\
Start the GUI version of etm. 
Enter this option at the command line to avoid blocking the interactive loop."""

    def help_help(self):
        print "Usage: X [options]"
        print "where the command X is either b, B, o, O, n or w."
        print "Using lower/upper case gives output with/without colors."
        print "Use 'help X' for detailed help on command X."

    def help_q(self):
        print "quit"

if __name__ == '__main__':
    import sys
    if len(sys.argv) > 1:
        IntOrCmd().onecmd(' '.join(sys.argv[1:]))
        #  print "\nUse 'e.py' without arguments to start the interactive shell."
    else:
        IntOrCmd().cmdloop()
