from setuptools import setup, find_packages
from etm.etmVersion import version

setup(
    name='etm',
    version=version,
    url='http://www.duke.edu/~dgraham/ETM',
    description='event and task manager',
    long_description='manage events and tasks using simple text files',
    platforms='Any',
    license='License :: OSI Approved :: GNU General Public License (GPL)',
    author='Daniel A Graham',
    author_email='daniel.graham@duke.edu',
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Intended Audience :: End Users/Desktop',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Topic :: Utilities',
        'Topic :: Office/Business', 
        ],
    packages=['etm'],
    # package_data={'etm': ['etm_hourglass*.png']},
    package_data={'etm': ['etmlogo*.png', 'etmlogo.ico', 'etm_*.wav']},
    #  py_modules=['ez_setup'],
    scripts=['e.py', 'e.pyw'],
    install_requires=["python-dateutil<2.0.0", "icalendar>=2.0.1"],
)
