from django import template

register = template.Library()

@register.inclusion_tag('searchutil/pagination.html')
def pagination_links(paginator_page, show_pages, url_params=None,
                     first_page_label=None, last_page_label=None,
                     page_url=''):
    '''Django template tag to display pagination links for a paginated
    list of items.

    Expects the following variables:
     * the current :class:`~django.core.paginator.Page` of a
       :class:`~django.core.paginator.Paginator` object
     * a dictionary of the pages to be displayed, in the format
       generated by :meth:`eulcommon.searchutil.pages_to_show`
     * optional url params to include in pagination link (e.g., search
       terms when paginating search results)
     * optional first page label (only used when first page is not in
       list of pages to be shown)
     * optional last page label (only used when last page is not in
       list of pages to be shown)
     * optional url to use for page links (only needed when the url is
       different from the current one)

    Example use::

      {% load search_utils %}

      {% pagination_links paged_items show_pages  %}
     
    '''
    return {
        'items': paginator_page,
        'show_pages': show_pages,
        'url_params': url_params,
        'first_page_label': first_page_label,
        'last_page_label': last_page_label,
        'page_url': page_url,
        }

