from execute import execute_listing_query
from collections import defaultdict
from memoize import memoize

office_name_cache = {}

FIXED_NWMLS_LOOKUPS = {
    'ST': {
        'A': 'Active',
        'CT': 'Contingent',
        'PB': 'Pending BU Requested',
        'PF': 'Pending Feasability',
        'PI': 'Pending Inspection',
        'PS': 'Pending Short Sale',
        'P': 'Pending',
        'E': 'Expired',
        'T': 'Temp. Off Markt.',
        'SFR': 'Sale Fail Release',
        'CA': 'Cancelled',
        'R': 'Rented',
        'S': 'Sold',
    },
    'AR': {
        '2': 'Purdy',
        '3': 'Rosedale',
        '4': 'Key Peninsula Sout',
        '5': 'Fox Island',
        '6': 'Gig Harbor South',
        '7': 'Artondale',
        '8': 'Gig Harbor North',
        '9': 'Key Peninsula Nort',
        '12': 'Anderson Island',
        '13': 'North Tacoma',
        '14': 'North Tacoma',
        '15': 'North Tacoma',
        '16': 'North Tacoma',
        '17': 'North Tacoma',
        '18': 'North Tacoma',
        '19': 'North Tacoma',
        '20': 'North Tacoma',
        '21': 'North Tacoma',
        '22': 'North Tacoma',
        '23': 'North Tacoma',
        '24': 'North Tacoma',
        '25': 'North Tacoma',
        '26': 'Central Tacoma',
        '27': 'Central Tacoma',
        '28': 'Central Tacoma',
        '29': 'Central Tacoma',
        '30': 'Central Tacoma',
        '31': 'West Tacoma',
        '32': 'University Place',
        '33': 'University Place',
        '34': 'University Place',
        '35': 'University Place',
        '36': 'Lakewood',
        '37': 'Lakewood',
        '38': 'Lakewood',
        '39': 'Lakewood',
        '40': 'Lakewood',
        '41': 'Lakewood/Tillicum',
        '42': 'Dupont',
        '43': 'Steilacoom',
        '44': 'Ketron Island',
        '45': 'South Tacoma',
        '46': 'South Tacoma',
        '47': 'South Tacoma',
        '48': 'South Tacoma',
        '49': 'South Tacoma',
        '50': 'South Tacoma',
        '51': 'South Tacoma',
        '52': 'South Tacoma',
        '53': 'South Tacoma',
        '54': 'South Tacoma',
        '55': 'Southeast Tacoma',
        '56': 'Southeast Tacoma',
        '57': 'Southeast Tacoma',
        '58': 'Southeast Tacoma',
        '59': 'Southeast Tacoma',
        '60': 'Southeast Tacoma',
        '61': 'Southeast Tacoma',
        '62': 'Southeast Tacoma',
        '63': 'Parkland',
        '64': 'Parkland',
        '65': 'Parkland',
        '66': 'Parkland',
        '67': 'Parkland',
        '68': 'Parkland',
        '69': 'Parkland',
        '70': 'Fife',
        '71': 'Milton',
        '72': 'Edgewood',
        '73': 'Sumner',
        '74': 'Sumner',
        '78': 'Port of Tacoma',
        '79': 'Puyallup',
        '80': 'Puyallup',
        '81': 'Puyallup',
        '82': 'Puyallup',
        '83': 'Puyallup',
        '84': 'Puyallup',
        '85': 'Puyallup',
        '86': 'Puyallup',
        '87': 'Puyallup',
        '88': 'Puyallup',
        '89': 'Graham/Fredrickso',
        '94': 'Browns Point',
        '95': 'Browns Point',
        '96': 'Asotin County',
        '99': 'Spanaway',
        '100': 'Jovita/West Hill',
        '109': 'Lake Tapps/Bonne',
        '110': 'Dash Point/Feder',
        '111': 'Buckley',
        '112': 'Wilkeson/Carbona',
        '113': 'Sumner',
        '114': 'Orting',
        '119': 'Roy/McKenna',
        '120': 'Des Moines/Redon',
        '121': 'Harts Lake',
        '122': 'Graham',
        '123': 'Tanwax Lake/Kapo',
        '124': 'Eatonville',
        '125': 'Eatonville',
        '126': 'Alder',
        '127': 'Elbe',
        '128': 'Ashford',
        '129': 'Clear Lake',
        '130': 'Burien/Normandy',
        '131': 'Columbia County',
        '134': 'East Pierce/Mt R',
        '135': 'Greenwater',
        '136': 'Garfield County',
        '140': 'West Seattle',
        '141': 'S. Kitsap W Of H',
        '142': 'S Kitsap E Of Hw',
        '143': 'Port Orchard',
        '144': 'Retsil/Mancheste',
        '145': 'Seabeck/Hlly',
        '146': 'Chico',
        '147': 'Silverdale',
        '148': 'West Bremerton',
        '149': 'East Bremerton',
        '150': 'E Central Kitsap',
        '161': 'Hansville',
        '162': 'Kingston',
        '163': 'Port Gamble',
        '164': 'Lofall',
        '165': 'Finn Hill',
        '166': 'Poulsbo',
        '167': 'Suquamish',
        '168': 'Indianola',
        '170': 'Bainbridge Islan',
        '171': 'Belfair/ Hood Ca',
        '172': 'Mason Lk Region',
        '173': 'South Shore Hood',
        '174': 'Harstine Island',
        '175': 'Shelton',
        '176': 'Agate',
        '177': 'Sw Mason County',
        '178': 'Nw Mason County',
        '179': 'Arcadia - Kamilc',
        '180': 'Grapeview',
        '190': 'Taholah',
        '191': 'Pacific Beach',
        '192': 'Copalis Beach',
        '193': 'Copalis Crossing',
        '194': 'Ocean Shores',
        '195': 'Quinault',
        '196': 'Humptulips',
        '197': 'Hoquiam',
        '198': 'Aberdeen',
        '199': 'Satsop',
        '200': 'Elma',
        '201': 'McCleary',
        '202': 'Cosmopolis',
        '203': 'Montesano',
        '204': 'Oakville',
        '206': 'Westport',
        '207': 'Bay Center',
        '208': 'Grayland',
        '209': 'Tokeland',
        '210': 'Raymond',
        '211': 'South Bend',
        '212': 'Menlo',
        '213': 'Lebam',
        '214': 'Amanda Park',
        '215': 'Malone',
        '216': 'Neilton',
        '217': 'Aloha',
        '218': 'Moclips',
        '219': 'Central Park',
        '220': 'Ocosta',
        '244   ': 'Benton County',
        '245': 'Franklin County',
        '286': 'NEDouglas County',
        '289': 'East Grant Count',
        '290': 'North Grant Coun',
        '291': 'North Central Gr',
        '292': 'West Grant Count',
        '293': 'South Grant Coun',
        '294': 'Central Grant Co',
        '295': 'South Moses Lake',
        '296': 'Peninsula',
        '297': 'Central Moses La',
        '298': 'North Moses Lake',
        '299': 'West Moses Lake',
        '300': 'Enumclaw',
        '310': 'Auburn',
        '320': 'Blk Dimnd/Mpl Vl',
        '330': 'Kent',
        '340': 'Renton/Benson Hi',
        '350': 'Renton/Highlands',
        '360': 'Skyway Area',
        '380': 'Southeast Seattle',
        '381': 'Adams County',
        '385   ': 'SODO/Beacon Hill',
        '386': 'Lincoln County',
        '390': 'Central Seattle/',
        '401': 'West Kelso And B',
        '402': 'Highlands',
        '403': 'St. Helens',
        '404': 'Westside',
        '405': 'Olympic',
        '406': 'Columbia Heights',
        '407': 'Hillside',
        '408': 'Northlake/Cvg',
        '409': 'Pacific Way',
        '410': 'Beacon Hill',
        '411': 'Robert Gray/Mint',
        '412': 'West County',
        '413': 'Wahkiakum County',
        '414': 'North County',
        '415': 'Ostrander',
        '416': 'North Kelso',
        '417': 'Kelso Hill',
        '418': 'South Kelso',
        '419': 'East County',
        '420': 'South County/Woo',
        '426': 'Centralia',
        '428': 'Adna/Pe Ell',
        '430': 'Chehalis',
        '432': 'Napavine',
        '434': 'Onalaska',
        '436': 'Morton',
        '441': 'Thurston Nw',
        '442': 'Black Hills',
        '443': 'Tumwater',
        '444': 'Olympia Westside',
        '445': 'Boston Harbor',
        '446': 'Thurston Ne',
        '447': 'Olympia North',
        '448': 'Olympia South',
        '449': 'East Olympia',
        '450': 'Lacey',
        '451': 'Hawks Prairie',
        '452': 'Thurston Se',
        '453': 'Yelm/Rainier',
        '454': 'Thurston South',
        '455': 'Rochester',
        '465': 'Ferry County',
        '475': 'Yakima County',
        '480': 'Port Townsend',
        '481': 'Cape George',
        '482': 'South Port Townsend',
        '483': 'Marrowstone',
        '484': 'Kala Point',
        '485': 'Hadlock',
        '486': 'Gardiner',
        '487': 'Oak Bay',
        '488': 'Chimacum Valley',
        '489': 'Port Ludlow',
        '490': 'Shine',
        '491': 'Coyle',
        '492': 'Quilcene',
        '493': 'Brinnon',
        '494': 'West Jeff County',
        '495': 'Discovery Bay',
        '500': 'East Side/South',
        '501': 'Klickitat County',
        '510': 'Mercer Island',
        '520': 'Bellevue/West Of',
        '530': 'Bellevue/East Of',
        '540': 'East Of Lake Sam',
        '550': 'Redmond/Carnatio',
        '560': 'Kirkland/Bridle',
        '561': 'Spokane County',
        '600': 'Juanita/Woodinvi',
        '610': 'Southeast Snohom',
        '620': 'Okanogan Valley',
        '700': 'Queen Anne/Magno',
        '701   ': 'Belltown/Downtn ',
        '705': 'Ballard/Greenlak',
        '710': 'North Seattle',
        '715': 'Richmond Beach/S',
        '720': 'Lake Forest Park',
        '730': 'Southwest Snohom',
        '740': 'Everett/Mukilteo',
        '750': 'East Snohomish C',
        '760': 'Northeast Snohom',
        '770': 'Northwest Snohom',
        '780': 'Camano Island',
        '800': 'Vashon Island',
        '811': 'South Whidbey Is',
        '812': 'Central Whidbey',
        '813': 'North Whidbey Is',
        '815': 'Anacortes',
        '816': 'Guemes Island',
        '817': 'Other Skagit Cou',
        '820': 'La Conner',
        '825': 'Burlington',
        '830': 'Sedro Woolley',
        '835': 'Mount Vernon',
        '840': 'Lyman/Hamilton',
        '845': 'Concrete & Up Ri',
        '850': 'Sudden Valley',
        '860': 'Bellingham',
        '865': 'Meridian',
        '870': 'Ferndale/Custer',
        '880': 'Blaine/Birch Bay',
        '881': 'Point Roberts',
        '885': 'Lynden',
        '890': 'Nooksack Valley',
        '895': 'Mount Baker/Demi',
        '899   ': 'Waldron',
        '900': 'San Juan Island',
        '901': 'Orc/Shw/Obsr/Crn',
        '902': 'Lopez/Frost',
        '903': 'Dec/Ctr/Blakely',
        '904': 'Stu/Hen/Pl/Johns',
        '905': 'Other San Juan I',
        '906': 'Clallam County',
        '907': 'Walla Walla Coun',
        '911': 'Miller Peninsula',
        '912': 'Southeast Clalla',
        '913': 'Northeast Sequim',
        '914': 'North Central Se',
        '915': 'Northwest Sequim',
        '916': 'Southeast Sequim',
        '917': 'Southwest Sequim',
        '918': 'East of Port Ang',
        '919': 'East of Port Ang',
        '920': 'Northeast Port A',
        '921': 'Central East Por',
        '922': 'Central West Por',
        '923': 'Northwest Port A',
        '924': 'Southeast Port A',
        '925': 'Southwest Port A',
        '926': 'West of Port Ang',
        '927': 'Northwest Clalla',
        '928': 'Southwest Clalla',
        '930': 'South Pacific Co',
        '940': 'Stevens County',
        '948': 'Upper Kittitas C',
        '949': 'Lower Kittitas C',
        '950': 'Skamania County',
        '959': 'Stevens Pass',
        '961': 'Chelan',
        '962': 'Manson',
        '963': 'Chelan Falls',
        '964': 'Entiat',
        '965': 'Mansfield',
        '966': 'Methow Valley',
        '967': 'Brewster/Pateros',
        '968': 'Bridgeport',
        '969': 'Orondo',
        '970': 'E. Wenatchee',
        '971': 'Wenatchee',
        '972': 'Leavenworth',
        '980': 'Pend Oreille Cou',
        '990': 'Whitman County',
        '1026': 'East Orchard',
        '1031': 'Camp Bonneville',
        '1033': 'Camas-Washougal',
        '1042': 'Evergreen Hwy',
        '1043': 'City Centr-West',
        '1045': 'Salmon Creek',
        '1046': 'Minnehaha',
        '1047': 'West Orchard',
        '1051': 'Ridgefield',
        '1061': 'Battle Ground',
        '1062': 'Brush Pr/Hcknsn',
        '1064': 'Vennersborg',
        '1070': 'LaCenter',
        '1071': 'North County',
    },
    'SD': {
        '00':'Not Known',
        'ABR':'Aberdeen',
        'AD':'Adna',
        'ALMI':'Almira',
        'ANA':'Anacortes',
        'AR':'Arlington',
        'ASOT':'Asotin-Anatone',
        'AUB':'Auburn',
        'BE':'Bellevue',
        'BEL':'Bellingham',
        'BENG':'Benge',
        'BG':'Battle Ground',
        'BICK':'Bickleton',
        'BIS':'Bainbridge Island',
        'BLN':'Blaine',
        'BOI':'Boistfort',
        'BRG':'Bridgeport',
        'BRI':'Brinnon',
        'BRL':'Burlington',
        'BRM':'Bremerton #100c',
        'BRW':'Brewster',
        'BTH':'Bethel',
        'CAM':'Camas',
        'CAS':'Cashmere',
        'CEN':'Centralia',
        'CENT':'Centerville',
        'CENV':'Central Valley',
        'CHE':'Chehalis',
        'CHEN':'Cheney',
        'CHEW':'Chewelah',
        'CHI':'Chimacum #49',
        'CK':'Central Kitsap #401',
        'CLAR':'Clarkston',
        'CLE':'Cle Elum-Roslyn',
        'CLH':'Coulee-Hartline',
        'CLP':'Clover Park',
        'COFX':'Colfax',
        'COLB':'Columbia - Burbank',
        'COLH':'Columbia - Hunters',
        'COLP':'College Place',
        'COLT':'Colton',
        'COLV':'Colville',
        'CON':'Concrete',
        'COS':'Cosmopolis',
        'CPF':'Cape Flattery',
        'CPV':'Coupeville',
        'CRB':'Carbonado',
        'CRE':'Creston',
        'CRES':'Crescent',
        'CRK':'Castle Rock',
        'CSC':'Cascade',
        'CURL':'Curlew',
        'CUSI':'Cusick',
        'CWY':'Conway',
        'DAM':'Damman',
        'DAR':'Darrington',
        'DAVE':'Davenport',
        'DAYT':'Dayton',
        'DGR':'Dieringer',
        'DIXI':'Dixie',
        'DPRK':'Deer Park',
        'EAS':'Easton',
        'EAT':'Eatonville',
        'ED':'Edmonds',
        'ELM':'Elma',
        'ELN':'Ellensburg',
        'EMT':'Eastmont',
        'ENDI':'Endicott',
        'ENM':'Enumclaw',
        'ENT':'Entiat',
        'EPH':'Ephrata',
        'EV':'Everett',
        'EVA':'Evaline',
        'EVAL':'East Valley Spokane',
        'EVG':'Evergreen',
        'EVGR':'Evergreen - Hunters',
        'EYAK':'East Valley Yakima',
        'FED':'Federal Way',
        'FIF':'Fife',
        'FINL':'Finley',
        'FPS':'Franklin Pierce',
        'FREE':'Freeman',
        'FRN':'Ferndale',
        'GARF':'Garfield',
        'GF':'Granite Falls',
        'GLEN':'Glenwood',
        'GMT':'Green Mountain',
        'GOLD':'Goldendale',
        'GRC':'Grand Coulee',
        'GRF':'Griffin',
        'GRGR':'Granger',
        'GRNO':'Great Northern',
        'GRP':'Grapeview #54',
        'GRVW':'Grandview',
        'HARR':'Harrington',
        'HC':'Hood Canal #404',
        'HGL':'Highline',
        'HLND':'Highland',
        'HOC':'Hockinson',
        'HOQ':'Hoquiam',
        'INCH':'Inchelium',
        'IND':'Index',
        'ISS':'Issaquah',
        'KAHL':'Kahlotus',
        'KAL':'Kalama',
        'KEL':'Kelso',
        'KELR':'Keller',
        'KENN':'Kennewick',
        'KETF':'Kettle Falls',
        'KION':'Kiona-Benton City',
        'KLIC':'Klickitat',
        'KNT':'Kent',
        'KTS':'Kittitas',
        'LAC':'La Conner',
        'LACS':'Lacrosse',
        'LAMO':'Lamont',
        'LC':'La Center',
        'LCH':'Lake Chelan',
        'LGV':'Longview',
        'LIBR':'Liberty',
        'LIND':'Lind',
        'LKD':'Lakewood',
        'LKW':'Lake Washington',
        'LOON':'Loon Lake',
        'LPZ':'Lopez Island',
        'LS':'Lake Stevens',
        'LYLE':'Lyle',
        'LYN':'Lynden',
        'MABT':'Mabton',
        'MAR':'Marysville',
        'MARW':'Mary Walker',
        'MCC':'McCleary',
        'MEAD':'Mead',
        'MEDL':'Medical Lake',
        'MER':'Meridian',
        'MET':'Methow Valley',
        'MIS':'Mercer Island',
        'MK':'Mary M. Knight #311',
        'MLA':'Mill A',
        'MLK':'Moses Lake',
        'MNS':'Manson',
        'MON':'Monroe',
        'MOR':'Morton',
        'MOS':'Mossyrock',
        'MOT':'Montesano',
        'MSF':'Mansfield',
        'MTAD':'Mount Adams',
        'MTB':'Mount Baker',
        'MTP':'Mount Pleasant',
        'MTV':'Mount Vernon',
        'MUK':'Mukilteo',
        'NAP':'Napavine',
        'NAS':'Naselle-Grays River',
        'NAVY':'Naches Valley',
        'NBC':'North Beach',
        'NES':'Nespelem',
        'NEWP':'Newport',
        'NFRA':'North Franklin',
        'NK':'North Kitsap #400',
        'NM':'North Mason #403',
        'NMFS':'Nine Mile Falls',
        'NOO':'Nooksack Valley',
        'NPRT':'Northport',
        'NRV':'North River',
        'NTH':'Northshore',
        'NTN':'North Thurston',
        'OAK':'Oakville',
        'OAKS':'Oakesdale',
        'OCB':'Ocean Beach',
        'OCO':'Ocosta',
        'ODES':'Odessa',
        'OH':'Oak Harbor',
        'OKA':'Okanogan',
        'OLY':'Olympia',
        'OMA':'Omak',
        'ONA':'Onalaska',
        'ONCR':'Onion Creek',
        'ORC':'Orcas Island',
        'ORCH':'Orchard Prairie',
        'ORIE':'Orient',
        'ORO':'Orondo',
        'ORT':'Orting',
        'OTHE':'Othello',
        'OTHR':'Other',
        'OVL':'Oroville',
        'PAL':'Palisades',
        'PALO':'Palouse',
        'PASC':'Pasco',
        'PAT':'Pateros',
        'PATS':'Paterson',
        'PE':'Pe Ell',
        'PEN':'Peninsula',
        'PI':'Pioneer #402',
        'POME':'Pomeroy',
        'PRES':'Prescott',
        'PROS':'Prosser',
        'PTA':'Port Angeles',
        'PTT':'Port Townsend #50',
        'PULL':'Pullman',
        'PUY':'Puyallup',
        'QNC':'Quincy',
        'QTS':'Queets-Clearwater',
        'QUI':'Quinault',
        'QUL':'Quilcene',
        'QUT':'Quillayute',
        'RAI':'Rainier',
        'RAY':'Raymond',
        'REAR':'Reardan-Edwall',
        'REN':'Renton',
        'REPU':'Republic',
        'RICH':'Richland',
        'RID':'Ridgefield',
        'RITZ':'Ritzville',
        'ROC':'Rochester',
        'ROOS':'Roosevelt',
        'ROSA':'Rosalia',
        'RSID':'Riverside',
        'RVW':'Riverview',
        'RYL':'Royal',
        'SAN':'San Juan Island',
        'SAT':'Satsop',
        'SB':'South Bend',
        'SDW':'Sedro Woolley',
        'SEA':'Seattle',
        'SELA':'Selah',
        'SELK':'Selkirk',
        'SEQ':'Sequim',
        'SHL':'Shelton',
        'SHW':'Shaw Island',
        'SK':'South Kitsap',
        'SKM':'Skamania',
        'SKY':'Skykomish',
        'SNO':'Snohomish',
        'SPL':'Soap Lake',
        'SPOK':'Spokane',
        'SPRA':'Sprague',
        'SRI':'Shoreline',
        'SS':'South Side #42',
        'SSID':'Sunnyside',
        'ST':'Stanwood',
        'STAR':'Star',
        'STBU':'Starbuck',
        'STE':'Steilacoom Historica',
        'STEP':'Steptoe',
        'STH':'Stehekin',
        'STJO':'St. John',
        'STV':'Stevenson-Carson',
        'SUL':'Sultan',
        'SUM':'Sumner',
        'SUMM':'Summit Valley',
        'SVS':'Snoqualmie Valley',
        'SWI':'South Whidbey Island',
        'TAC':'Tacoma',
        'TEKO':'Tekoa',
        'TEN':'Tenino',
        'THL':'Taholah',
        'THO':'Thorp',
        'THS':'Tahoma',
        'TOL':'Toledo',
        'TOPP':'Toppenish',
        'TOU':'Toutle Lake',
        'TOUC':'Touchet',
        'TROU':'Trout Lake',
        'TSK':'Tonasket',
        'TUK':'Tukwila',
        'TUM':'Tumwater',
        'UGAP':'Union Gap',
        'UNP':'University Place',
        'VALY':'Valley',
        'VAN':'Vancouver',
        'VDR':'Vader',
        'VSH':'Vashon Island',
        'WAH':'Wahkiakum',
        'WAIT':'Waitsburg',
        'WAPA':'Wapato',
        'WAS':'Washougal',
        'WAWA':'Walla Walla',
        'WDL':'Woodland',
        'WELL':'Wellpinit',
        'WEN':'Wenatchee',
        'WHR':'White River',
        'WHT':'White Pass',
        'WILB':'Wilbur',
        'WIN':'Winlock',
        'WIS':'Wishkah',
        'WISH':'Wishram',
        'WLC':'Wilson Creek',
        'WLP':'Willapa',
        'WLU':'Wahluke',
        'WRD':'Warden',
        'WSAL':'White Salmon',
        'WTUC':'Washtucna',
        'WV':'Waterville',
        'WVAL':'West Valley Spokane',
        'WYAK':'West Valley Yakima',
        'YAKI':'Yakima',
        'YEL':'Yelm',
        'ZILA':'Zillah',
    }
}

@memoize
def _get_offices(username, password):
    for row in execute_listing_query(username, password, 'RetrieveOfficeData', {'MLS': 'nwmls'}):
        yield dict([(c.tag.replace('{http://www.nwmls.com/Schemas/Standard/StandardXML1_1.xsd}', ''), c.text) for c in row.getchildren()])


@memoize
def _get_amenities(username, password, prop_type):
    for r in execute_listing_query(username, password, 'RetrieveAmenityData', {'MLS': 'nwmls', 'PropertyType': prop_type}):
        field_name = r.find('{http://www.nwmls.com/Schemas/General/EverNetAmenityXML.xsd}Code').text
        values = r.find('{http://www.nwmls.com/Schemas/General/EverNetAmenityXML.xsd}Values').getchildren()
        row = dict([(c.tag.replace('{http://www.nwmls.com/Schemas/General/EverNetAmenityXML.xsd}', ''), c.text) for c in values])
        yield field_name, row


def _get_office_table(offices):
    return dict([(office.get('{http://www.nwmls.com/Schemas/General/EverNetOfficeXML.xsd}OfficeMLSID'), office.get('{http://www.nwmls.com/Schemas/General/EverNetOfficeXML.xsd}OfficeName')) for office in offices])


def _get_amenities_table(amenities):
    field_map = defaultdict(dict)
    for field_name, row in amenities:
        field_map[field_name][row['Code']] = row['Description']
    return field_map


def _look_up_dynamic_fields(username, password, row):
    prop_type = row.get('PTYP')
    out = {}
    lookup_table = _get_amenities_table(_get_amenities(username, password, prop_type))
    for key, value in row.iteritems():
        if not value:
            continue
        if key not in lookup_table:
            out[key] = value
        else:
            out[key] = []
            for v in value.split('|'):
                out[key].append(lookup_table[key].get(v))
    return out

def _look_up_fixed_fields(row):
    out = {}
    for key, value in row.iteritems():
        if key in FIXED_NWMLS_LOOKUPS:
            out[key] = FIXED_NWMLS_LOOKUPS[key].get(value, value)
        else:
            out[key] = value
    return out

def _add_office_name_field(row, username, password):
    offices = _get_office_table(_get_offices(username, password))
    row['OFFICENAME'] = offices.get(row.get('LO'))
    return row


def look_up_all_fields(username, password, row):
    row = _look_up_dynamic_fields(username, password, row)
    row = _add_office_name_field(row, username, password)
    row = _look_up_fixed_fields(row)
    return row
