# elib/plugs/list.py
#
#

""" lists various stuff. """

## elib imports

from elib import cmnds, core
from elib.utils import str2stamp

## list command

def list(event):
    plugs = core.plugins
    plug = plugs.get(event.rest)
    if not plug: event.display("plugins: %s" % ", ".join(plugs.names())) ; return
    try: store = getattr(plug, "store")
    except AttributeError: event.reply("no store available for %s" % event.rest) ; return
    c = 0
    objs = sorted(store.objects(), key=lambda obj: str2stamp(obj._timed))
    for obj in objs:
        c += 1
        event.reply("%s) %s (%s)\n" % (c, obj.txt, obj._timed or "no time"))

cmnds.register("list", list)
