# elib/plugs/start.py
#
#

""" start various bots. """

## elib imports

from elib import cmnds, fleet, Config
from elib.drivers.irc import IRCBot
from elib.utils import parse_options

## basic imports

import logging
import _thread

## default config 

config = Config()
config.server = "irc.freenode.net"
config.port = 6667
config.nick = "evidence"
config.username = "Evidence Bot"
config.channel = "#evidence"

## start command

def start(event):
    if event.rest: opts = parse_options(event.rest) ; config.update(opts)
    bot = IRCBot(**config)
    fleet.register(bot.what, bot)
    try: _thread.start_new_thread(bot.run_forever, ())
    except: error()
    fleet.bots.append(bot)

cmnds.register("start", start)
