# elib/plugs/list.py
#
#

""" lists various stuff. """

## elib imports

from elib import cmnds, core
from elib.utils import str2stamp

## list command

def list(event):
    p = core.plugins
    plug = p.get(event.rest)
    if not plug: event.reply("plugins: %s" % ", ".join(p.names())) ; return
    try: store = getattr(plug, "store")
    except AttributeError: event.reply("no store available for %s" % event.rest) ; return
    c = 0
    objs = sorted(store.objects(), key=lambda obj: str2stamp(obj._timed))
    for obj in objs: c += 1 ; event.reply("%s) %s (%s)" % (c, obj.txt, obj._timed or "no time"))

cmnds.register("list", list)
