#!/usr/bin/env python3
#
#

import os
import sys

if sys.version_info.major < 3: print("you need to run elib with python3") ; os._exit(1)

try: use_setuptools()
except: pass

try:
    from setuptools import setup
except Exception as ex:
    print(str(ex))
    os._exit(1)

import elib

setup(
    name='evidence',
    version='%s' % elib.__version__,
    url='https://pikacode.com/milla/evidence',
    author='Bart Thate',
    author_email='milla@dds.nl',
    description='evidence - tool for evidence taking',
    license='MIT',
    include_package_data=True,
    zip_safe=False,
    requires=['distribute', 'sleekxmpp'],
    scripts=['bin/evidence',
            ],
    packages=['elib',
              'elib.drivers',
              'elib.plugs',
              'elib.test',
             ],
    long_description = """ bot to help gathering evidence over a longer period of time .. kenmerk: 69389/12 """,
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Environment :: Console',
        'Environment :: Other Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: Unix',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules'],
)
