# -*- coding:utf-8 -*-
import unittest


def add(x, y):
    return x + y


class Seq(object):
    def __init__(self, xs):
        self.xs = xs

    def add(self, x):
        self.xs.append(x)


def apply_test_function(*args, **kwargs):
    from evilunit import test_function
    return test_function(*args, **kwargs)


@apply_test_function("{}:add".format(__name__))
class TestCallFUTIsAutoGenerated(unittest.TestCase):
    def test_it(self):
        result = self._callFUT(10, 20)
        self.assertEqual(result, 30)


@apply_test_function("{}:add".format(__name__))
class TestCallFUTIsDefinedByHand(unittest.TestCase):
    def _callFUT(self):
        return self._getTarget()(10, 20)

    def test_it(self):
        result = self._callFUT()
        self.assertEqual(result, 30)


def apply_test_instance(*args, **kwargs):
    from evilunit import test_target
    return test_target(*args, **kwargs)


@apply_test_instance("{}:Seq".format(__name__))
class TestMakeOneIsAutoGenerated(unittest.TestCase):
    def test_it(self):
        target = self._makeOne([1])
        target.add(2)
        self.assertEqual(target.xs, [1, 2])


@apply_test_instance("{}:Seq".format(__name__))
class TestMakeOneIsDefinedBySelf(unittest.TestCase):
    def _makeOne(self, *args, **kwargs):
        return self._getTarget()([1, 2, 3])

    def test_it(self):
        target = self._makeOne()
        self.assertEqual(target.xs, [1, 2, 3])
