# #!/usr/bin/env python

# ezupload 0.0.1 by David Hacker

import argparse
import time
import os
import imp
import uuid
import subprocess
from pprint import pprint

setup_start_code = """#!/usr/bin/env python
# Auto-generated using ezupload

from setuptools import setup

def read(fname):
    with open(fname, 'r') as fr:
        return fr.read()
    
setup("""

setup_end_code = """\n)"""
        
data_code = """class ArgumentData:
    args = """
    
delimiter = ''
    
def main():
    parser = argparse.ArgumentParser(
                                   description='''ezupload execution script
                                   
 ezupload aims to make uploading projects to PyPi fast and easy.
 Less hassle for the user = better.
                                   ''',
                                   formatter_class = argparse.RawTextHelpFormatter
                                   )
    parser.add_argument("directory",
                        help="Directory of the project (not a file path)")
    parser.add_argument("-n", "--no-setup",
                        action="store_true", default=False,
                        help="Do not attempt to generate a new setup.py")
    args = parser.parse_args()
    print "For help or more information, please visit"
    print "https://github.com/dmhacker/ezupload/wiki"
    print ""
    
    directory = args.directory
    if not args.no_setup:
        write_setup(directory, processed_args=find_setup(directory))
    upload(directory)
    
def find_setup(directory):
    old_arguments_file = directory+"/ezdata.py"
    if os.path.isfile(old_arguments_file):
        print "Using previous setup data ..."
        with open(old_arguments_file, 'r') as fid:
            code = fid.read()
        module = imp.new_module('usercode{0}'.format(str(uuid.uuid4())))
        exec code in module.__dict__
        return module.ArgumentData().args
    print "Did not find previous setup data."
    return None

def in_quotes(s):
    return "'"+s+"'"

def write_setup(directory, processed_args=None):
    
    print ""
    print (directory+"/setup.py").center(75)
    print "* = required field".center(75)
    print "Leave an optional field blank to skip it".center(75)
    
    gen = ArgumentGenerator()
    if processed_args == None:
        # Basics
        gen.add_string_input('Name', optional=False)
        gen.add_string_input('Version', optional=False)
        gen.add_string_input('Description', optional=False)
        gen.add_string_input('Long Description', optional=False, classifier='file')
        gen.add_list_input('Packages', optional=False)
        gen.add_dict_input('Package Data', str, list)
        gen.add_dict_input('Entry Points', str, list, optional=False)
        
        # Extraneous
        gen.add_list_input('Install Requires')
        gen.add_list_input('Scripts')
        gen.add_string_input('URL')
        gen.add_string_input('License')
        gen.add_string_input('Author')
        gen.add_string_input('Author Email')
        gen.add_string_input('Maintainer')
        gen.add_string_input('Maintainer Email')
        gen.add_string_input('Keywords')
        gen.add_list_input('Classifiers')
    else:
        gen.set_previous_input(processed_args)
        print "\nInput a new version (old = {0})".format(processed_args['version'])
        gen.add_string_input('Version', optional=False, start='')
    
    processed_args = gen.get_input()
    
    print "\nSetup arguments:"
    pprint(processed_args)
    print ""
    time.sleep(2)
    
    _write_setup_file(directory, processed_args)
    
def _write_setup_file(directory, arg_dict):
    
    def wrap(obj):
        if isinstance(obj, str):
            return in_quotes(obj)
        elif isinstance(obj, list):
            wrapped = '['
            for index, item in enumerate(obj):
                wrapped += wrap(item)
                if index < len(obj)-1:
                    wrapped += ','
            wrapped += ']'
            return wrapped
        elif isinstance(obj, dict):
            wrapped = '{'
            dict_items = obj.items()
            for index, item in enumerate(dict_items):
                key, value = item
                wrapped += wrap(key) + ":" + wrap(value)
                if index < len(dict_items)-1:
                    wrapped += ','
            wrapped += '}'
            return wrapped
                    
    fw = open(directory+"/ezdata.py", 'w')
    fw.write(data_code)
    fw.write(wrap(arg_dict))
    fw.close()
    
    fw = open(directory+"/setup.py", 'w')
    fw.write(setup_start_code)
    for arg_name, arg_content in arg_dict.iteritems():
        translated = wrap(arg_content)
        if arg_name == 'long_description':
            if len(translated.split('/')) == 1:
                #unwrapped = translated.replace('\'', '')
                #absolute_path = os.path.abspath(directory+'/'+unwrapped)
                translated = 'read('+translated+')'
        fw.write("\n    "+arg_name+"="+translated+",")
    fw.write(setup_end_code)
    fw.close()
   
list_delimiter = ','
dict_item_delimiter = ';'
dict_kv_delimiter = '-'

class ArgumentGenerator:
    _args = {}
            
    def add_string_input(self, arg, optional=True, start='\n', classifier='str'):
        wrapped_arg = start+arg+('*' * (not optional))+' ['+classifier+']: '
        user_input = raw_input(wrapped_arg)
        key_arg = arg.lower().replace(' ', '_')
        if user_input == delimiter:
            if optional:
                print "Skipped field!"
            else:
                print "This field is required!"
                self.add_string_input(arg, optional=optional)
                
        else:
            self._args[key_arg] = user_input
            
            print "Processed:",in_quotes(user_input)
            
    def add_list_input(self, arg, optional=True, start='\n'):
        wrapped_arg = start+arg+('*' * (not optional))+' [list]: '
        user_input = raw_input(wrapped_arg)
        key_arg = arg.lower().replace(' ', '_')
        if user_input == delimiter:
            if optional:
                print "Skipped field!"
            else:
                print "This field is required!"
                self.add_list_input(arg, optional=optional)
        else:
            processed = self.process_list_input(user_input)
            if processed == None:
                print "Failed to translate input into list!"
                print "Input was:", user_input
                self.add_list_input(arg, optional=optional)
            else:
                self._args[key_arg] = processed
                
                print "Processed:"
                pprint(processed)
                
    def add_dict_input(self, arg, keytype, valuetype, optional=True, start='\n'):
        wrapped_arg = start+arg+('*' * (not optional))+' [{'+keytype.__name__+dict_kv_delimiter+valuetype.__name__+'}]: '
        user_input = raw_input(wrapped_arg)
        key_arg = arg.lower().replace(' ', '_')
        if user_input == delimiter:
            if optional:
                print "Skipped field!"
            else:
                print "This field is required!"
                self.add_dict_input(arg, keytype, valuetype, optional=optional)
        else:
            processed = self.process_dict_input(user_input, keytype, valuetype)
            if processed == None:
                print "Failed to translate input into dict!"
                print "Input was:", user_input
                self.add_dict_input(arg, keytype, valuetype, optional=optional)
            else:
                self._args[key_arg] = processed
                
                print "Processed:"
                pprint(processed)
                
    def process_list_input(self, userinput):
        return [s.strip() for s in userinput.split(list_delimiter)]
                
    def process_dict_input(self, userinput, keytype, valuetype):
        
        def translate(raw, type):
            if type == list:
                return self.process_list_input(raw)
            else:
                return str(raw)
        
        final_dict = {}
        dict_items = [s.strip() for s in userinput.split(dict_item_delimiter)]
        for item in dict_items:
            unwrapped_item = [s.strip() for s in userinput.split(dict_kv_delimiter)]
            if len(unwrapped_item) != 2:
                return None
            key = translate(unwrapped_item[0], keytype)
            value = translate(unwrapped_item[1], valuetype)
            final_dict[key] = value
        return final_dict
    
    def get_input(self):
        return self._args
    
    def set_previous_input(self, old_args):
        self._args = old_args
            
def upload(directory):
    print "Beginning upload process ..."
    
    absolute_directory = os.path.dirname(os.path.abspath(directory+"/setup.py"))
    
    def setup_call(extra_args):
        all_args = ['python', 'setup.py'] + extra_args
        call = subprocess.Popen(all_args, cwd=absolute_directory, shell=True)
        call.wait()
        
    setup_call(['register'])
    all_dists = ['sdist', 'bdist_dumb', 'bdist_wininst']
    try:
        imp.find_module('wheel')
        wheel = True
    except ImportError:
        wheel = False
    if wheel:
        all_dists.append('bdist_wheel')
        all_dists.append('--universal')
    all_dists.append('upload')
    setup_call(all_dists) 
     
if __name__ == '__main__':
    main()
    