import numpy
import math
import producer
import canvas2D
import canvas3D
import shape3D
import math
            
pcer = producer.GCodeProducer()

first_layer_config = canvas2D.Canvas2DConfig(1.0 / 11.0, 360, 0.0, print_width = 0.5, layer_height = 0.4)
normal_layer_config = canvas2D.Canvas2DConfig(1.0 / 22.0, 500, 0.0, print_width = 0.6, layer_height = 0.4)

config3D = canvas3D.Canvas3DConfig(first_layer_config, normal_layer_config, 300.0)

canvas3D = canvas3D.Canvas3D(pcer, config3D)

#tube1 = Tube3DProducer(canvas3D, numpy.array([0.0, 0.0]), 17.8, 20.4, 0.0, 40.0)
#tube2 = Tube3DProducer(canvas3D, numpy.array([0.0, 0.0]), 20.4, 30.0, 0.0, 2.0)
#tube2 = Tube3DProducer(canvas3D, numpy.array([0.0, 0.0]), 20.4, 30.0, 0.0, 2.0)
tube2 = shape3D.Tube3DProducer(canvas3D, numpy.array([0.0, 0.0]), 13, 14, 0.0, 10.0)
#tube3 = Tube3DProducer(canvas3D, numpy.array([0.0, 0.0]), 3, 6.4, 0.0, 40.0)

canvas3D.draw()

#canvas = Canvas2D(gcp, config)

#disc = Disc2DProducer(canvas, numpy.array([0.0, 0.0]), 20.0, 30.0)
#disc.draw()

prefix = """; generated by Slic3r 0.9.8 on 2013-02-21 at 23:57:20

; layer_height = 0.4
; perimeters = 3
; top_solid_layers = 3
; bottom_solid_layers = 3
; fill_density = 0.4
; perimeter_speed = 30
; infill_speed = 60
; travel_speed = 130
; scale = 1
; nozzle_diameter = 0.5
; filament_diameter = 3
; extrusion_multiplier = 1
; perimeters extrusion width = 0.53mm
; infill extrusion width = 0.53mm
; first layer extrusion width = 0.80mm

M107
M104 S230 ; set temperature
G28 ; home all axes
M109 S230 ; wait for temperature to be reached
G90 ; use absolute coordinates
G21 ; set units to millimeters
G92 E0 ; reset extruder axis to zero
M82 ; use absolute distances for extrusion
G1 F1800.000 E0.00000
G92 E0
"""

suffix = """
G92 E0
M107
M104 S0 ; turn off temperature
G28 X0  ; home X axis
M84     ; disable motors
"""

output = prefix + str(pcer) + suffix

f = open("/Users/lagunas/Dropbox/3DDesign/pythontest.gcode", "wb")
f.write(output)
f.close()
