# -*- coding: utf-8 -*-

from __future__ import unicode_literals
from ..person import Provider as PersonProvider


class Provider(PersonProvider):
    formats = (
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}}',
        '{{prefix}} {{first_name}} {{last_name}}',
        '{{first_name}} {{last_name}} {{suffix}}',
        '{{prefix}} {{first_name}} {{last_name}} {{suffix}}'
    )

    first_names = (
        # top 50 Female Names in Iran: http://www.sabteahval.ir/Upload/Modules/Contents/asset100/name/d1391.htm
        'فاطمه', 'اسما', 'زهرا', 'عسل', 'نازنین زهرا', 'النا', 'زینب', 'سارا', 'یسنا', 'آتنا', 'ریحانه', 'آیناز', 'هستی', 'محیا', 'ستایش', 'باران', 'ثنا', 'هلیا', 'مریم', 'یلدا', 'فاطمه زهرا', 'ملیكا', 'سارینا', 'نازنین', 'مهسا', 'آیلین', 'نرگس', 'حنانه', 'رقیه', 'كیانا', 'كوثر', 'هانیه', 'مبینا', 'مهدیس', 'رها', 'آوا', 'اسرا', 'یگانه', 'نیایش', 'حدیث', 'الینا', 'سوگند', 'مائده', 'پریا', 'معصومه', 'مهدیه', 'آیدا', 'الناز', 'محدثه', 'یاسمین',
        # top 50 male Names in Iran: http://www.sabteahval.ir/Upload/Modules/Contents/asset100/name/p1391.htm
        'امیر علی', 'پرهام', 'ابوالفضل', 'كیان', 'امیرحسین', 'متین', 'محمد طاها', 'عرفان', 'محمد', 'دانیال', 'علی', 'آرمین', 'امیرمحمد', 'آرتین', 'حسین', 'سبحان', 'مهدی', 'سینا', 'محمد مهدی', 'آریا', 'محمدرضا', 'محمدپارسا', 'طاها', 'سجاد', 'امیررضا', 'آرش', 'امیرعباس', 'نیما', 'علیرضا', 'عرشیا', 'محمدامین', 'مبین', 'محمدحسین', 'یوسف', 'رضا', 'احسان', 'علی اصغر', 'آرین', 'امیرمهدی', 'محمدیاسین', 'ماهان', 'عباس', 'پارسا', 'حسام', 'یاسین', 'علی رضا', 'ایلیا', 'علی اكبر', 'محمدجواد', 'بنیامین'
    )

    last_names = (
        'محمدی', 'محمد پور', 'اکبر پور', 'رضا زاده', 'مجتهدی', 'دایی', 'حمیدی', 'کابلی', 'عبدالعلی', 'احمدی', 'اشرفی', 'علیجانی', 'ابوطالبی', 'علی شاهی', 'الوندی', 'بهمنی', 'بهرامی', 'هنری', 'ایروانی', 'حریریان', 'جعفر پور', 'جلالی', 'جلیلی', 'روحانی', 'خسروجردی', 'منصوری', 'مهدیان', 'نوروزی', 'نوری', 'رسته', 'سماوات', 'سمسار', 'شادروان', 'شاکری', 'سلطانی', 'شبیری', 'تحسینی', 'تنزیلی', 'طلوعی', 'ولاشجردی', 'وثاق', 'ظفری', 'زمانی', 'زارع', 'زارعی', 'ربانی', 'شمشیری', 'صارمی', 'صیادی', 'سرخوشیان',
        'رستمی', 'رسولی', 'رفیعی', 'کریمی', 'کرمانی', 'سعیدی', 'عباسی', 'پویان', 'ترکاشوند', 'زنجانی', 'تهرانی', 'جنتی', 'صنایعی', 'جهانی', 'اشتری', 'چنگیزی', 'دادفر', 'سغیری', 'پارسا', 'ضابطی', 'میردامادی', 'عقیلی', 'نامور', 'حسنی', 'لاهوتی', 'محجوب', 'هاشمی', 'معروف', 'معین', 'هوشیار', 'هومن', 'هدایت', 'قاضی', 'ملکیان', 'ضرغامی', 'یزدی', 'نوبختی', 'مجتبوی', 'نیلوفری', 'لاچینی', 'علی پور', 'عبدالمالکی', 'فرجی', 'موسوی', 'همدانی', 'موحد', 'کمالی', 'گلپایگانی', 'نعمتی', 'عزیزی'
    )

    prefixes = ('جناب آقای', 'سرکار خانم', 'جناب آقای دکتر', 'سرکار خانم دکتر')

    @classmethod
    def prefix(cls):
        return cls.random_element(cls.prefixes)

    @classmethod
    def suffix(cls):
        return ''
