'''
usage:
 (sudo) python setup.py +
	 install		... local
	 register		... at http://pypi.python.org/pypi
	 sdist			... create *.tar to be uploaded to pyPI
	 sdist upload	... build the package and upload in to pyPI
'''

#########################
#import os,sys
#_path = os.path.abspath(os.path.dirname(__file__))
#print _path
#sys.path.insert(0,_path)
import fancytools as package
#########################


from setuptools import setup, find_packages
import os
#import shutil

def read(*paths):
	"""Build a file path from *paths* and return the contents."""
	try:
		f_name = os.path.join(*paths)
		with open(f_name, 'r') as f:
			return f.read()
	except IOError:
		print('%s not existing ... skipping' %f_name)
		return ''

setup(
	name			= package.__name__,
	version 		= package.__version__,
	author			= package.__author__,
	author_email	= package.__email__,
	url				= package.__url__,
	license			= package.__license__,
	install_requires= package.__depencies__,
	classifiers		= package.__classifiers__,
	description		= package.__doc__,
	packages		= find_packages(exclude=['tests*']),
	include_package_data=True,
	scripts			= [] if not os.path.exists('bin') else [
						os.path.join('bin',x) for x in os.listdir('bin')],
	long_description=(
		read('README.rst') + '\n\n' +
		read('CHANGES.rst') + '\n\n' +
		read('AUTHORS.rst')
		),
	)



## remove the build
## else old and notexistent files could come again in the installed pkg
#mainPath = os.path.abspath(os.path.dirname(__file__))
#bPath = os.path.join(mainPath,'build')
#if os.path.exists(bPath):
	#shutil.rmtree(bPath)

#