from distutils.core import setup, Extension
import os

Name = 'fast_prns'

# The easiest way to re-cythonize code: delete fast_prns.c.
# (It will then be automatically regenerated by Cython)
USE_CYTHON = False if Name+'.c' in os.listdir(os.getcwd()) else True

ext = '.pyx' if USE_CYTHON else '.c'
extensions = [Extension(Name, [Name+ext], extra_compile_args=['-O3'] )]

if USE_CYTHON:
	from Cython.Build import cythonize
	extensions = cythonize(extensions)

setup(
	name=Name,
	version='1.0.0',
	description='Fast exponential and normal Pseudo Random Number Generator',
	author='Christopher McFarland',
	author_email='christopherdmcfarland+pypi@gmail.com',	
	maintainer_email='christopherdmcfarland+pypi@gmail.com',	
	url='https://bitbucket.org/cdmcfarland/fast_prns',
	classifiers =[
		'Programming Language :: Python',
		'Programming Language :: Python :: 3',
		'Programming Language :: Python :: 2.7',
		'Programming Language :: Cython',
		'Programming Language :: C',
		'License :: OSI Approved',
		'License :: OSI Approved :: MIT License',
		'Operating System :: Unix',
		'Intended Audience :: Science/Research',
		'Natural Language :: English',
		'Topic :: Scientific/Engineering',
		],
	license = 'MIT License',	
#	packages = ['distutils', 'distutils.core', 'numpy'],
	requires=['numpy'],
	ext_modules = extensions 
)

