/* Text wrapping is not recommended for this document 
 * 
 * Exponential PRN generator. Must call exponential_setup() to initialize the
 * uniform PRN.
 *
 * exponential() -> Exponentially-distributed PRN with mean 1. 
 * */

#ifndef __cdm_z_exp__
#define __cdm_z_exp__
#include <stdlib.h>
#include <math.h>
#include "MT19937.h"
#define	__EXP_BINS__	252

/* Uses WDS_SAMPELR agorithm cited in main text to sample from A_i */
#define _WDS_SAMPLER() 	(Rand->l >> 8 >= pmf[Rand->s[0]] ? map[Rand++->s[0]] : Rand++->s[0])
/* Draws random uniform doubles beginning at start, ending at end, using an
 * integer source of randomness U, with domain [0, scale). */
#define _CDM_SAMPLE(start, end, U, scale) ((start)*(scale) + ((end) - (start))*(U))
/* Test to see if rejection sampling is required in the overhang. See Fig. 2
 * in main text. */
#define _EXP_MINIMUM_TESTWORTHY_VALUE(y, x) ((y) - (x) > 1707931576952627293)

/* The precomputed lengths, denoted X_i in the main text, from create_layers.py */
static double __exp_X__[__EXP_BINS__+1] = { 8.20662406753e-19, 7.39737323516e-19, 6.91333133779e-19, 6.5647358821e-19, 6.29125399598e-19, 6.06572241296e-19, 5.87352761037e-19, 5.70588505285e-19, 5.55709456916e-19, 5.42324389037e-19, 5.30152976965e-19, 5.18987392577e-19, 5.0866922618e-19, 4.99074929388e-19, 4.90106258944e-19, 4.81683790106e-19, 4.73742386536e-19, 4.66227958072e-19, 4.59095090178e-19, 4.52305277907e-19, 4.45825588164e-19, 4.39627631264e-19, 4.33686759671e-19, 4.27981436185e-19, 4.22492730271e-19, 4.17203912535e-19, 4.12100125225e-19, 4.07168112259e-19, 4.0239599631e-19, 3.97773093429e-19, 3.93289757853e-19, 3.88937251293e-19, 3.84707632187e-19, 3.80593661382e-19, 3.76588721385e-19, 3.7268674692e-19, 3.68882164922e-19, 3.65169842488e-19, 3.61545041533e-19, 3.58003379153e-19, 3.54540792845e-19, 3.51153509888e-19, 3.478380203e-19, 3.44591052889e-19, 3.41409553966e-19, 3.38290668387e-19, 3.35231722623e-19, 3.32230209587e-19, 3.29283775028e-19, 3.26390205282e-19, 3.23547416228e-19, 3.20753443311e-19, 3.18006432505e-19, 3.15304632118e-19, 3.12646385343e-19, 3.10030123469e-19, 3.07454359701e-19, 3.049176835e-19, 3.02418755411e-19, 2.99956302321e-19, 2.97529113107e-19, 2.95136034631e-19, 2.92775968057e-19, 2.90447865454e-19, 2.88150726664e-19, 2.85883596399e-19, 2.83645561563e-19, 2.81435748768e-19, 2.79253322026e-19, 2.77097480612e-19, 2.74967457073e-19, 2.72862515379e-19, 2.70781949192e-19, 2.68725080264e-19, 2.66691256932e-19, 2.64679852713e-19, 2.62690264997e-19, 2.60721913814e-19, 2.58774240685e-19, 2.56846707542e-19, 2.54938795718e-19, 2.53050004991e-19, 2.51179852691e-19, 2.49327872862e-19, 2.47493615466e-19, 2.45676645638e-19, 2.43876542983e-19, 2.42092900908e-19, 2.40325326001e-19, 2.38573437435e-19, 2.36836866406e-19, 2.35115255607e-19, 2.33408258722e-19, 2.31715539953e-19, 2.3003677357e-19, 2.28371643478e-19, 2.2671984282e-19, 2.2508107358e-19, 2.23455046227e-19, 2.21841479361e-19, 2.20240099382e-19, 2.18650640175e-19, 2.17072842808e-19, 2.15506455249e-19, 2.13951232087e-19, 2.12406934276e-19, 2.10873328882e-19, 2.09350188851e-19, 2.07837292773e-19, 2.06334424671e-19, 2.04841373792e-19, 2.03357934403e-19, 2.01883905608e-19, 2.00419091156e-19, 1.98963299272e-19, 1.97516342486e-19, 1.96078037473e-19, 1.94648204892e-19, 1.93226669243e-19, 1.9181325872e-19, 1.90407805074e-19, 1.89010143478e-19, 1.87620112397e-19, 1.86237553469e-19, 1.8486231138e-19, 1.83494233754e-19, 1.82133171034e-19, 1.80778976379e-19, 1.79431505561e-19, 1.78090616856e-19, 1.76756170954e-19, 1.75428030858e-19, 1.74106061794e-19, 1.7279013112e-19, 1.71480108238e-19, 1.7017586451e-19, 1.68877273172e-19, 1.67584209255e-19, 1.66296549505e-19, 1.65014172306e-19, 1.63736957602e-19, 1.62464786823e-19, 1.61197542813e-19, 1.59935109756e-19, 1.58677373107e-19, 1.57424219521e-19, 1.56175536784e-19, 1.54931213746e-19, 1.5369114025e-19, 1.52455207068e-19, 1.51223305837e-19, 1.49995328986e-19, 1.48771169674e-19, 1.47550721726e-19, 1.46333879563e-19, 1.4512053814e-19, 1.43910592874e-19, 1.42703939586e-19, 1.41500474425e-19, 1.40300093807e-19, 1.39102694344e-19, 1.37908172772e-19, 1.36716425886e-19, 1.35527350466e-19, 1.34340843201e-19, 1.3315680062e-19, 1.31975119012e-19, 1.3079569435e-19, 1.29618422208e-19, 1.28443197683e-19, 1.27269915307e-19, 1.26098468959e-19, 1.24928751776e-19, 1.23760656057e-19, 1.22594073168e-19, 1.21428893439e-19, 1.20265006056e-19, 1.19102298955e-19, 1.17940658704e-19, 1.16779970383e-19, 1.15620117456e-19, 1.14460981638e-19, 1.13302442758e-19, 1.12144378607e-19, 1.10986664787e-19, 1.0982917454e-19, 1.08671778581e-19, 1.07514344905e-19, 1.06356738599e-19, 1.05198821625e-19, 1.04040452605e-19, 1.02881486575e-19, 1.01721774741e-19, 1.00561164199e-19, 9.93994976483e-20, 9.82366130767e-20, 9.70723434263e-20, 9.59065162307e-20, 9.47389532242e-20, 9.35694699202e-20, 9.23978751546e-20, 9.12239705906e-20, 9.00475501809e-20, 8.88683995826e-20, 8.76862955198e-20, 8.65010050861e-20, 8.53122849831e-20, 8.41198806844e-20, 8.29235255165e-20, 8.1722939648e-20, 8.05178289728e-20, 7.93078838751e-20, 7.80927778595e-20, 7.68721660284e-20, 7.5645683384e-20, 7.44129429302e-20, 7.31735335451e-20, 7.19270175876e-20, 7.06729281977e-20, 6.94107662395e-20, 6.81399968293e-20, 6.68600453746e-20, 6.55702930402e-20, 6.42700715334e-20, 6.29586570809e-20, 6.16352634381e-20, 6.02990337322e-20, 5.89490308929e-20, 5.75842263599e-20, 5.62034866696e-20, 5.48055574135e-20, 5.3389043909e-20, 5.1952387718e-20, 5.04938378663e-20, 4.90114152226e-20, 4.75028679334e-20, 4.59656150013e-20, 4.4396673898e-20, 4.27925663021e-20, 4.11491932734e-20, 3.94616667626e-20, 3.77240771314e-20, 3.59291640862e-20, 3.40678366911e-20, 3.21284476416e-20, 3.00956469164e-20, 2.79484694556e-20, 2.56569130487e-20, 2.31752097568e-20, 2.04266952283e-20, 1.72617703302e-20, 1.32818892594e-20, 0.0};

void exponential_setup(void){
	mt_init();
}

/* Internal function to draw PRN from overhang i */
static inline double _exp_overhang(uint8_t i) {
	static double *X = __exp_X__;
	static double Y[__EXP_BINS__+1] = { 5.59520549511e-23, 1.18025099827e-22, 1.84444233867e-22, 2.54390304667e-22, 3.27376943115e-22, 4.03077321327e-22, 4.81254783195e-22, 5.61729148966e-22, 6.44358205404e-22, 7.29026623435e-22, 8.15638884563e-22, 9.04114536835e-22, 9.94384884864e-22, 1.0863906046e-21, 1.18007997755e-21, 1.27540755348e-21, 1.37233311764e-21, 1.47082087944e-21, 1.57083882574e-21, 1.67235819844e-21, 1.7753530675e-21, 1.87979997851e-21, 1.98567765878e-21, 2.09296677041e-21, 2.201649701e-21, 2.31171038523e-21, 2.42313415161e-21, 2.53590759014e-21, 2.65001843742e-21, 2.76545547637e-21, 2.88220844835e-21, 3.00026797575e-21, 3.11962549361e-21, 3.24027318888e-21, 3.36220394642e-21, 3.48541130074e-21, 3.60988939279e-21, 3.7356329311e-21, 3.86263715686e-21, 3.99089781236e-21, 4.12041111239e-21, 4.25117371845e-21, 4.38318271516e-21, 4.51643558895e-21, 4.65093020852e-21, 4.78666480711e-21, 4.92363796621e-21, 5.06184860075e-21, 5.20129594544e-21, 5.34197954236e-21, 5.48389922948e-21, 5.62705513018e-21, 5.77144764362e-21, 5.9170774359e-21, 6.06394543192e-21, 6.21205280795e-21, 6.36140098478e-21, 6.51199162141e-21, 6.66382660935e-21, 6.81690806729e-21, 6.97123833635e-21, 7.12681997563e-21, 7.28365575824e-21, 7.44174866764e-21, 7.60110189437e-21, 7.76171883308e-21, 7.92360307983e-21, 8.08675842978e-21, 8.25118887504e-21, 8.41689860281e-21, 8.58389199384e-21, 8.752173621e-21, 8.92174824817e-21, 9.0926208293e-21, 9.26479650768e-21, 9.43828061539e-21, 9.61307867302e-21, 9.78919638943e-21, 9.96663966183e-21, 1.01454145759e-20, 1.03255274063e-20, 1.05069846171e-20, 1.06897928622e-20, 1.08739589867e-20, 1.10594900275e-20, 1.12463932147e-20, 1.14346759725e-20, 1.16243459211e-20, 1.18154108781e-20, 1.20078788602e-20, 1.22017580851e-20, 1.23970569735e-20, 1.25937841516e-20, 1.27919484529e-20, 1.29915589212e-20, 1.31926248126e-20, 1.33951555991e-20, 1.35991609708e-20, 1.38046508394e-20, 1.40116353411e-20, 1.42201248406e-20, 1.44301299338e-20, 1.46416614524e-20, 1.48547304671e-20, 1.50693482921e-20, 1.5285526489e-20, 1.55032768718e-20, 1.57226115107e-20, 1.59435427376e-20, 1.61660831506e-20, 1.63902456195e-20, 1.6616043291e-20, 1.68434895946e-20, 1.70725982479e-20, 1.73033832633e-20, 1.75358589536e-20, 1.77700399393e-20, 1.80059411545e-20, 1.82435778548e-20, 1.84829656238e-20, 1.87241203814e-20, 1.89670583912e-20, 1.92117962687e-20, 1.94583509899e-20, 1.97067399002e-20, 1.99569807232e-20, 2.02090915706e-20, 2.04630909515e-20, 2.07189977831e-20, 2.09768314011e-20, 2.12366115708e-20, 2.14983584983e-20, 2.17620928428e-20, 2.20278357286e-20, 2.2295608758e-20, 2.2565434025e-20, 2.28373341287e-20, 2.31113321878e-20, 2.33874518561e-20, 2.36657173374e-20, 2.39461534023e-20, 2.42287854051e-20, 2.4513639301e-20, 2.48007416649e-20, 2.50901197103e-20, 2.53818013093e-20, 2.56758150136e-20, 2.59721900756e-20, 2.62709564716e-20, 2.65721449254e-20, 2.68757869323e-20, 2.71819147857e-20, 2.74905616033e-20, 2.78017613558e-20, 2.81155488957e-20, 2.84319599887e-20, 2.87510313451e-20, 2.90728006545e-20, 2.939730662e-20, 2.97245889962e-20, 3.00546886272e-20, 3.03876474879e-20, 3.07235087261e-20, 3.10623167078e-20, 3.14041170641e-20, 3.17489567409e-20, 3.20968840504e-20, 3.24479487265e-20, 3.28022019823e-20, 3.31596965706e-20, 3.35204868483e-20, 3.38846288435e-20, 3.42521803272e-20, 3.46232008885e-20, 3.4997752014e-20, 3.53758971719e-20, 3.57577019011e-20, 3.61432339058e-20, 3.65325631548e-20, 3.69257619879e-20, 3.73229052281e-20, 3.77240703013e-20, 3.81293373632e-20, 3.85387894342e-20, 3.89525125438e-20, 3.93705958834e-20, 3.97931319704e-20, 4.02202168223e-20, 4.06519501444e-20, 4.10884355286e-20, 4.15297806682e-20, 4.19760975869e-20, 4.24275028853e-20, 4.28841180055e-20, 4.3346069516e-20, 4.38134894182e-20, 4.42865154775e-20, 4.47652915804e-20, 4.52499681207e-20, 4.57407024181e-20, 4.62376591717e-20, 4.67410109528e-20, 4.72509387408e-20, 4.77676325071e-20, 4.82912918521e-20, 4.88221267023e-20, 4.93603580729e-20, 4.99062189052e-20, 5.04599549866e-20, 5.10218259653e-20, 5.15921064692e-20, 5.21710873452e-20, 5.2759077033e-20, 5.33564030933e-20, 5.39634139104e-20, 5.45804805963e-20, 5.52079991245e-20, 5.58463927299e-20, 5.64961146142e-20, 5.71576510093e-20, 5.7831524655e-20, 5.85182987638e-20, 5.92185815588e-20, 5.99330314883e-20, 6.06623632468e-20, 6.14073547584e-20, 6.21688553205e-20, 6.29477951501e-20, 6.37451966432e-20, 6.45621877375e-20, 6.54000178819e-20, 6.62600772633e-20, 6.71439201451e-20, 6.80532934473e-20, 6.89901720881e-20, 6.99568031586e-20, 7.09557617949e-20, 7.19900227889e-20, 7.30630537391e-20, 7.41789382663e-20, 7.53425421342e-20, 7.65597421711e-20, 7.78377498634e-20, 7.9185582674e-20, 8.06147755374e-20, 8.21405027698e-20, 8.37834459783e-20, 8.55731292497e-20, 8.75544596696e-20, 8.98023880577e-20, 9.24624714212e-20, 9.5919641345e-20, 1.08420217249e-19};
	
	uint64_t y;
	MT_FLUSH();
	if (Rand[0].l > Rand[1].l) { 
		y = Rand[0].l;
		Rand[0].l = Rand[1].l;
	}
	else {
		y = Rand[1].l;
	}
	double x = _CDM_SAMPLE(X[i], X[i-1], pow(2, -1)*Rand->l, pow(2, 63));
	Rand += 2;
	if (_EXP_MINIMUM_TESTWORTHY_VALUE(y, Rand[-2].l) || _CDM_SAMPLE(Y[i-1], Y[i], pow(2, 63) - y, pow(2, 63)) <= exp(-x) ) {
		return x;
	}
	return _exp_overhang(i);
}

static inline double exponential(void) {
/* map & pmf are used to sample from the array denoted A_i in the main text, using WDS_Sampler algorithm. */
	static uint8_t map[256] = { 0, 0, 1, 235, 3, 4, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 250, 250, 250, 250, 250, 250, 250, 249, 249, 249, 249, 249, 249, 248, 248, 248, 248, 247, 247, 247, 247, 246, 246, 246, 245, 245, 244, 244, 243, 243, 242, 241, 241, 240, 239, 237, 3, 3, 4, 4, 6, 0, 0, 0, 0, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 2, 0, 0, 0 };
	static uint64_t pmf[256] = { 72057594037927930u, 42371753696506213u, 46436183522457200u, 64888060121167341u, 61478267669560543u, 70562032810685515u, 59855545430616049u, 66001962384821446u, 60326972282961775u, 55739654989873398u, 51947960445620046u, 48756975425848834u, 46031394234150542u, 43674206880967483u, 41613956922677162u, 39796790416271814u, 38181312345524856u, 36735154945123697u, 35432626166932627u, 34253060204861267u, 33179636369949223u, 32198517683731754u, 31298212250731688u, 30469092746039951u, 29703030001897365u, 28993110179291267u, 28333414016715460u, 27718842764824495u, 27144979638871444u, 26607978581086409u, 26104474229279661u, 25631508502895981u, 25186470321571583u, 24767045784469964u, 24371176744027817u, 23997026162721326u, 23642948986530019u, 23307467532699050u, 22989250592889217u, 22687095610865144u, 22399913417532608u, 22126715103516808u, 21866600686666933u, 21618749293409312u, 21382410622230453u, 21156897497358280u, 20941579352960673u, 20735876514445298u, 20539255164933245u, 20351222902647970u, 20171324809539033u, 19999139963548964u, 19834278336986905u, 19676378031876675u, 19525102810185550u, 19380139882767540u, 19241197925852564u, 19108005298149369u, 18980308435223841u, 18857870400880368u, 18740469577889219u, 18627898482647825u, 18519962690287052u, 18416479858396437u, 18317278838972527u, 18222198869432882u, 18131088834619372u, 18043806592642649u, 17960218358240315u, 17880198138029947u, 17803627212661992u, 17730393661423630u, 17660391925324274u, 17593522405115972u, 17529691091073553u, 17468809221690125u, 17410792968732998u, 17355563146362353u, 17303044942249546u, 17253167668826772u, 17205864532990090u, 17161072422735586u, 17118731709351255u, 17078786063923606u, 17041182287024671u, 17005870150559017u, 16972802250835994u, 16941933872020892u, 16913222859195207u, 16886629500320597u, 16862116416468322u, 16839648459727681u, 16819192618260311u, 16800717928012670u, 16784195390639519u, 16769597897232190u, 16756900157477049u, 16746078633904188u, 16737111480911758u, 16729978488282032u, 16724661028926353u, 16721142010619769u, 16719405831506598u, 16719438339176750u, 16721226793131131u, 16724759830467744u, 16730027434640770u, 16737020907150064u, 16745732842042890u, 16756157103109181u, 16768288803674679u, 16782124288898074u, 16797661120494140u, 16814898063810834u, 16833835077199706u, 16854473303625923u, 16876815064473643u, 16900863855509755u, 16926624344977517u, 16954102373797717u, 16983304957863259u, 17014240292421283u, 17046917758541646u, 17081347931678431u, 17117542592340767u, 17155514738891732u, 17195278602505164u, 17236849664315271u, 17280244674801927u, 17325481675462805u, 17372580022829142u, 17421560414893207u, 17472444920020628u, 17525257008431196u, 17580021586341435u, 17636765032869830u, 17695515239817790u, 17756301654447956u, 17819155325395585u, 17884108951857581u, 17951196936218762u, 18020455440288458u, 18091922445333681u, 18165637816112646u, 18241643369127224u, 18319982945334599u, 18400702487572285u, 18483850122977321u, 18569476250700644u, 18657633635240951u, 18748377505751915u, 18841765661704462u, 18937858585315142u, 19036719561188683u, 19138414803660363u, 19243013592358691u, 19350588416561817u, 19461215128961038u, 19574973109503631u, 19691945440040326u, 19812219090569913u, 19935885117939368u, 20063038877935897u, 20193780251791476u, 20328213888209701u, 20466449462129291u, 20608601951548248u, 20754791933857145u, 20905145903264581u, 21059796611052289u, 21218883430559555u, 21382552748986121u, 21550958388307798u, 21724262057823890u, 21902633841118124u, 22086252720490631u, 22275307142241516u, 22469995626539425u, 22670527426003938u, 22877123237578003u, 23090015972766851u, 23309451591877983u, 23535690008535435u, 23769006071451568u, 24009690631248482u, 24258051701035325u, 24514415720482028u, 24779128934309020u, 25052558897450219u, 25335096120675462u, 25627155872200962u, 25929180152817930u, 26241639864357026u, 26565037193943602u, 26899908239533902u, 27246825905726846u, 27606403102906182u, 27979296287475655u, 28366209386427324u, 28767898155877636u, 29185175030671425u, 29618914530928218u, 30070059301707777u, 30539626874138787u, 31028717250750454u, 31538521434836693u, 32070331044047142u, 32625549172744801u, 33205702696879318u, 33812456250313881u, 34447628144093041u, 35113208551809579u, 35811380347244740u, 36544543057666430u, 37315340491201533u, 38126692714280695u, 38981833201360690u, 39884352161964116u, 40838247280016420u, 41847983391411326u, 42918562996259117u, 44055609977330306u, 45265469509681865u, 46555327944708071u, 47933357498977567u, 49408891963615614u, 50992641499812772u, 52696957080236763u, 54536158534549957u, 56526944840053827u, 58688911829648933u, 61045211718156595u, 63623402074661316u, 66456551118387200u, 69584694705485219u, 65887249404450334u, 70762978821664948u, 57346704366683564u, 71512017491343982u, 67185873792067285u, 67976575731804258u, 47049452588209091u, 60727975469361388u, 52862796055634384u, 54330245202402199u, 68860226579648466u, 64663652380087401u, 43688741546608623u, 54555791841795724u, 33092078962192699u, 63464174377331213u, 51040972341599684u, 51369544840893175u, 0u, 0u, 0u };
	MT_FLUSH();
/* Efficiently accesses last 8 bytes of Rand->l; hence, 1 64-bit random number can be used to select i and then a length within X[i] */
	uint8_t i = Rand->l & 0x00000000000000ff;
	if (i < __EXP_BINS__) return __exp_X__[i]*(Rand++->l & 0x7fffffffffffffff);
	Rand++;
	uint8_t j = _WDS_SAMPLER(); 
	return j == 0 ? 7.56927469415 + exponential() : _exp_overhang(j);
}

#endif
