# Managed by Puppet: do not edit this file directly. It will be overwritten!

"""Resize root filesystem if needed."""

from __future__ import print_function
import os
import re
import subprocess
import sys

# 5G disk size granularity -> 2.5G sampling -> 512 byte sectors
FREE_SECTOR_THRESHOLD = (5 * (1024 * 1024 * 1024) / 2) / 512
EXTRACT_FREE_SECTORS = re.compile(r'\s([0-9]+) free sectors')
PROGNAME = os.path.basename(sys.argv[0])
DISK = '/dev/vda'


def grow(free_sectors):
    print('{}: found {} free sectors, growing'.format(
        PROGNAME, free_sectors))
    data = subprocess.check_output(['partx', '-r', DISK]).decode()
    first_sector = data.splitlines()[1].split()[1]
    subprocess.check_call([
        'sgdisk', DISK, '-d', '1', '-n', '1:{}:0'.format(first_sector),
        '-c', '1:root', '-t', '1:8300'])

    # ensure kernel knows partition size
    data = subprocess.check_output(['partx', '-r', DISK]).decode()
    partition_size = data.splitlines()[1].split()[3]   # sectors
    subprocess.check_call(['resizepart', DISK, '1', partition_size])

    # resize filesystem online
    subprocess.check_call(['resize2fs', '/dev/vda1'])


def check_grow():
    # ensure correct gpt
    output = subprocess.check_output(['sgdisk', '-v', DISK])
    if 'Problem: The secondary' in output.decode():
        subprocess.check_call(['sgdisk', '-e', DISK])

    # ensure correct partition size
    free = EXTRACT_FREE_SECTORS.search(subprocess.check_output([
        'sgdisk', '-v', DISK]))
    free_sectors = int(free.group(1))
    if free_sectors >= FREE_SECTOR_THRESHOLD:
        grow(free_sectors)
