"""
Usage::

  class Thing(object):

    @quick_contract(species=str)
    def __init__(self, species):
      pass
    @quick_contract(air_speed="(float|int),>=0", returns="float,>=0")
    def ask(self, air_speed=1.0):
      return sqrt(air_speed)


  class TestThing(ut.TestCase):
    @quick_check
    def setUp(self, animal):
      self.thing = Thing(animal)

    @quick_check
    def ask_theorem(self, speed):
      self.assertEqual(self.thing.ask(speed)*self.thing.ask(speed), speed)

For each successful execution of @quick_check(->setUp(...)) perform edgecase and stochastic analysis of each @quick_check(->*_theorem(...))
"""


from contracts import contract
from itertools import chain
import random, string
from functools import wraps

known_contract_functions = {}

def quick_contract(*args, **kwargs):
    def wrapper(f):
        if type(f)==type:
            class Wrapped(f):
                def __init__()
            f.__init__ = contract(*args, **kwargs)(f.__init__)
        f = contract(*args, **kwargs)(f)
        known_contract_functions[f] = kwargs
        return f
    return wrapper    


def quick_check(*args, **kwargs):
    """Wrap f in unittest test_* function that calls f with arguments individually generated by ObjectGenerator. If a call to f(...) violates contract, retreive the (<i;arg[i]>, contract) pair, then narrow generator belonging to the argument that triggered the contract violation. if a generator finishes without uncaught exceptions, contract violations or assertion errors then the test passed. 

if a generator can not be narrowed then ignore a threshold number of contract violations then fail with a MissingGenerator exception
"""
    pass

class Generator(object):
    edge_cases=[]

    def __init__(self, tests=20):
        self.tests = tests

    def __iter__(self):
        return self
    
    def generate(self):
        raise Exception("Generator ill defined")

    def next(self):
        self.tests = self.tests-1

        if self.tests < 0:
            raise StopIteration()

        if len(self.edge_cases) > 0:
            return self.edge_cases.pop(0)
        else:
            return self.generate()


class ObjectGenerator(Generator):
    def __iter__(self):
        return chain(IntGenerator(), StringGenerator(), FloatGenerator())

class FloatGenerator(Generator):
    edge_cases = [0.0, 1.0, -1.0, 0.4, 0.5, 0.6, 1.5, -0.4, -0.5, -0.6]

    def generate(self):
        return random.choice([-1, 1])*10**(random.uniform(-15, 15))

class IntGenerator(Generator):
    edge_cases = [0, 1, 2, -1, -2]


    def generate(self):
        return int(random.uniform(-10, 10) * 10**(random.uniform(0, 15)))
    # def next(self):
    #     Generator.next(self)

class StringGenerator(Generator):
    edge_cases = ['']
    def __init__(self, tests=20, 
                 chars=string.printable):
        Generator.__init__(self, tests)
        self.chars = chars

    def generate(self):
        return ''.join(random.choice(self.chars) for _ in range(random.randint(0, 1000)))


def sanity_check():
    contracts = {}
    for function, contract in known_contract_functions.iteritems():
        if function.func_name == '__init__':
            contracts[

def optimize(clause):
    """ clause -> clause """

def generate(clause):
#    if isinstance(clause, And) && 
    if isinstance(clause, Extension):
        generators = {'float': FloatGenerator()}
        return generators[clause.identifier]
    else:
        return NotImplemented
        
