# F3AT - Flumotion Asynchronous Autonomous Agent Toolkit
# Copyright (C) 2010,2011 Flumotion Services, S.A.
# All rights reserved.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

# See "LICENSE.GPL" in the source distribution for more information.

# Headers in this file shall remain intact.
from feat.test import common

from feat.common import manhole, serialization
from feat.common.serialization import sexp
from feat.agents.base import testsuite


class TestClass(manhole.Manhole):

    @manhole.expose()
    @serialization.freeze_tag('tag_name')
    def method(self):
        pass

    @serialization.freeze_tag('tag_other_name')
    @manhole.expose()
    def method2(self):
        pass


class FreezeTest(testsuite.TestCase):

    def testFreezetTag(self):
        test = TestClass()
        s = sexp.Serializer()
        self.assertEqual('tag_name', s.freeze(test.method))
        self.assertEqual('tag_other_name', s.freeze(test.method2))
