import globals


def log_console(message):
    if globals.verbose:
        print 'DEBUG', message


def config_error_message():
    return """Your configuration file is absent or incorrect.\nPlease create a .fedecfg file inside your home with the following structure:

    [options]
    email =  Name Surname <your@email.com>

    [smtp]
    url = <SMTP server address>
    port = <SMTP server port>
    username = <SMTP server auth username>
    password = <SMTP server auth password>
"""


tutorials = dict(tg="""

Please take not of the following instructions when running a TurboGears project:
virtualenv --no-site-packages tg2env
$ cd tg2env/
$ source bin/activate
(tg2env)$ pip install tg.devtools

For more information please READ the project's readme file.
""",
                 A="""

Open the Xcode project.
Find the server configuration file and input your machine's local IP or the test server'S IP address.
Setup the project's certificates: use development certificates for local testing and use test certificates for testing enviroment.
Press Run to start the project on a simulator or iOS device.

For more information please READ the project's readme file.
""",
                 iOS="""

Use the "gradle ./gradlew installDebug -Penv=enviroment" where enviroment is either test or dev, for test or development.
Remeber to change the IP address in the .groovy file inside the project.
Have a device connected while running this command.

For more information please READ the project's readme file.
"""
)


def get_tutorial(option):
    if option is not None:
        return tutorials[option]
    else:
        return ""

