import smtplib

from helpers import log_console

from email.message import Message
from email.header import Header

class EmailHelper:
    smtp = ''
    port = 0
    username = ''
    password = ''

    @classmethod
    def format_email(cls, name, email):
        return "{} <{}>".format(name, email)

    def initialize(self, smtp, port, username, password):
        self.smtp = smtp
        self.port = port
        self.username = username
        self.password = password

    def send_email(self, sender_email, receiver_email, subject, message, sender_name, receiver_name):

        receivers = [receiver_email]

        formatted_message = Message()
        formatted_message['Subject'] = Header(subject, 'utf-8')
        formatted_message['From'] = self.format_email(sender_name, sender_email)
        formatted_message['To'] = self.format_email(receiver_name, receiver_email)
        formatted_message.set_payload("""{}
""".format(message))

        try:
            smtpObj = smtplib.SMTP(self.smtp, self.port)
            smtpObj.ehlo()
            smtpObj.starttls()
            smtpObj.ehlo()
            smtpObj.login(self.username, self.password)
            smtpObj.sendmail(sender_email, receivers, str(formatted_message))
            log_console("Formatted email:\n\n"+str(formatted_message))
            print "Message sent!"
        except smtplib.SMTPException as error:
            log_console("Error: unable to send email\n{}".format(error))

