import os
from ConfigParser import SafeConfigParser
import argparse
import sys

import globals
from helpers import config_error_message, get_tutorial
from mailer import EmailHelper


receiver_email = 'federico.fulgheri@axant.it'
receiver_name = 'Federico Fulgheri'


def load_configuration():
    try:
        parser = SafeConfigParser()
        parser.read(os.path.expanduser('~/.fedecfg'))

        email_str = parser.get('options', 'email')
        if email_str.find('<') == -1 or email_str.find('>') == -1:
            raise Exception

        return dict(
            email=email_str[email_str.find("<") + 1:email_str.find(">")],
            email_sender=email_str[0:email_str.find("<")].rstrip(),
            smtp_url=parser.get('smtp', 'url'),
            smtp_port=parser.get('smtp', 'port'),
            smtp_username=parser.get('smtp', 'username'),
            smtp_password=parser.get('smtp', 'password')
        )

    except:
        sys.exit(config_error_message())


def parse_commands():
    parser = argparse.ArgumentParser()
    parser.add_argument("titile", type=str, help="email title")
    parser.add_argument("message", type=str, help="email message")
    parser.add_argument("-e", "--email", type=str, help="use this sender email address")
    parser.add_argument("-v", "--verbose", action="count", help="enable verbose mode")
    parser.add_argument("-t", "--tutorial", type=str, choices=["tg", "A", "iOS"],
                        help="Choose project quickstart to send: TurboGears, Android or iOS")
    args = parser.parse_args()
    return args


def main():
    globals.init()
    config = load_configuration()
    parsed_args = parse_commands()
    globals.verbose = parsed_args.verbose is not None

    email_helper = EmailHelper()
    email_helper.initialize(smtp=config['smtp_url'],
                            port=config['smtp_port'],
                            username=config['smtp_username'],
                            password=config['smtp_password'])

    print "Sending message..."
    email_helper.send_email(sender_email=parsed_args.email if parsed_args.email else config['email'],
                            receiver_email=receiver_email,
                            subject=parsed_args.titile,
                            message=parsed_args.message + get_tutorial(parsed_args.tutorial),
                            sender_name=parsed_args.email if parsed_args.email else config['email_sender'],
                            receiver_name=receiver_name)


if __name__ == "__main__":
    main()