import os

from setuptools import setup


here = os.path.abspath(os.path.dirname(__file__))
try:
    README = open(os.path.join(here, 'README.rst')).read()
except IOError:
    README = ''

version = "0.0.1"

setup(name='fede-worker',
      version=version,
      description="Quick command line tool to send emails with instructions to a designated person.",
      long_description=README,
      classifiers=['Topic :: Communications :: Email'],
      keywords='email fede-worker',
      author='Andrei Neagu',
      author_email='andrei.neagu@axant.it',
      url='https://bitbucket.org/bithk/fede-worker',
      license='MIT',
      zip_safe=False,
      packages=['fedeworker', ],
      entry_points={
          'console_scripts': [
              'fede-worker = fedeworker.robot:main'
          ]
      }
)