# This file is part of fedmsg.
# Copyright (C) 2012 Red Hat, Inc.
#
# fedmsg is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# fedmsg is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with fedmsg; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#
# Authors:  Ralph Bean <rbean@redhat.com>
#
""" Tests for ansible messages """

import unittest

from fedmsg.tests.test_meta import Base


class TestAnsiblePlaybookStart(Base):
    """ These messages are published when an admin begins an ansible
    playbook run.  We use that system to manage the servers that
    run fedoraproject.org.
    """

    expected_title = "ansible.playbook.start"
    expected_subti = 'ralph started an ansible run of ' +\
        'playbooks/groups/badges-backend.yml'
    expected_link = "http://infrastructure.fedoraproject.org/cgit/" +\
        "ansible.git/tree/playbooks/groups/badges-backend.yml"
    expected_secondary_icon = "http://www.gravatar.com/avatar/" + \
        "2f933f4364baaabd2d3ab8f0664faef2?s=64&d=http%3A%2F%2F" + \
        "fedoraproject.org%2Fstatic%2Fimages%2Ffedora_infinity_64x64.png"
    expected_packages = set([])
    expected_usernames = set(['ralph'])
    expected_objects = set(['playbooks/groups/badges-backend.yml'])
    msg = {
        "username": "root",
        "i": 1,
        "timestamp": 1375753735.32427,
        "topic": "org.fedoraproject.prod.ansible.playbook.start",
        "msg": {
            "playbook_checksum": False,
            "extra_vars": {},
            "userid": "ralph",
            "playbook": "/srv/web/infra/ansible/playbooks/groups/"
            "badges-backend.yml",
            "check": False,
            "inventory": "/srv/web/infra/ansible/inventory/"
        }
    }


class TestAnsiblePlaybookComplete(Base):
    """ These messages are published when an admin finishes an ansible
    playbook run.  We use that system to manage the servers that
    run fedoraproject.org.
    """
    expected_title = "ansible.playbook.complete"
    expected_subti = "ralph's playbooks/groups/badges-backend.yml playbook" +\
        " run completed"
    expected_link = "http://infrastructure.fedoraproject.org/cgit/" +\
        "ansible.git/tree/playbooks/groups/badges-backend.yml"
    expected_secondary_icon = "http://www.gravatar.com/avatar/" + \
        "2f933f4364baaabd2d3ab8f0664faef2?s=64&d=http%3A%2F%2F" + \
        "fedoraproject.org%2Fstatic%2Fimages%2Ffedora_infinity_64x64.png"
    expected_packages = set([])
    expected_usernames = set(['ralph'])
    expected_objects = set([
        'playbooks/groups/badges-backend.yml',
        'inventory/badges-backend01.phx2.fedoraproject.org',
        'inventory/badges-backend01.stg.phx2.fedoraproject.org',
    ])
    msg = {
        "username": "root",
        "i": 2,
        "timestamp": 1375753955.771203,
        "topic": "org.fedoraproject.prod.ansible.playbook.complete",
        "msg": {
            "userid": "ralph",
            "playbook": "/srv/web/infra/ansible/playbooks/groups/"
            "badges-backend.yml",
            "results": {
                "badges-backend01.phx2.fedoraproject.org": {
                    "failures": 0,
                    "skipped": 9,
                    "ok": 56,
                    "changed": 1,
                    "unreachable": 0
                },
                "badges-backend01.stg.phx2.fedoraproject.org": {
                    "failures": 0,
                    "skipped": 9,
                    "ok": 56,
                    "changed": 1,
                    "unreachable": 0
                }
            }
        }
    }

if __name__ == '__main__':
    unittest.main()
