from abc import ABCMeta, abstractmethod

RESULT_OK = 101
RESULT_CORRUPT = 102
RESULT_MUMBLE = 103
RESULT_DOWN = 104
RESULT_CHECKER_ERROR = 110


class FemidaChecker(object):
    """Checker interface. You should implement _push and _pull methods"""
    __metaclass__ = ABCMeta

    def push(self, endpoint, flag_id, flag):
        result = (RESULT_CHECKER_ERROR, flag_id)
        try:
            result = self._push(endpoint, flag_id, flag)
        except:
            # TODO: make logging and log exception traceback here
            pass
        return result

    def pull(self, endpoint, flag_id, flag):
        result = RESULT_CHECKER_ERROR
        try:
            result = self._pull(endpoint, flag_id, flag)
        except:
            # TODO: make logging and log exception traceback here
            pass
        return result

    @abstractmethod
    def _push(self, endpoint, flag_id, flag):
        """Push <flag> into the <endpoint> service. Return tuple containing
        result from one of RESULT_* constants and flag_id"""
        pass

    @abstractmethod
    def _pull(self, endpoint, flag_id, flag):
        """Check if the flag that can be pulled from <endpoint> service by
        using some data in <flag_id> equals given <flag>. Return result from
        one of RESULT_* constants"""
        pass

    def run(self):
        """This method will be final. Don't override it"""
        raise NotImplementedError()
