import requests
import json


_pusher_config = None


def configure(host=None, origin=None):
    global _pusher_config
    _pusher_config = dict(host=host, origin=origin)


class PushResult(object):
    _status_codes = [
        'unknown error',
        'flag accepted',
        'this is your flag',
        'flag expired',
        'too many submit attempts',
        'not a flag',
        'flag already submitted'
    ]

    @classmethod
    def get_description(cls, status):
        if 0 <= status < len(cls._status_codes):
            return cls._status_codes[status]
        return cls._status_codes[0]

    def __init__(self, status):
        self._status = status

    @property
    def status(self):
        return self._status

    @property
    def description(self):
        return self.get_description(self._status)

    def __str__(self):
        return 'Push result: {0}'.format(self.description)

    def __unicode__(self):
        return u'Push result: {0}'.format(self.description)

    def __repr__(self):
        return str(self)


def push(flag):
    try:
        global _pusher_config
        url = 'http://{0}/attack'.format(_pusher_config['host'])
        payload = dict(flag=flag, origin=_pusher_config['origin'])
        r = requests.post(url, data=json.dumps(payload))
        data = r.json()
        return PushResult(data['status'])
    except:
        return PushResult(0)
