#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 0.0.82.2943 (xds-profile.profile.json) on 2014-10-31.
#  2014, SMART Platforms.


import io
import unittest
import json
from condition import Condition
from fhirdate import FHIRDate


class ConditionTests(unittest.TestCase):
    def instantiate_from(self, filename):
        with io.open(filename, 'r', encoding='utf-8') as handle:
            js = json.load(handle)
        instance = Condition(js)
        self.assertIsNotNone(instance, "Must have instantiated a test instance")
        return instance
    
    def testCondition1(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/condition-example-f001-heart.json")
        self.assertIsNotNone(inst, "Must have instantiated a Condition instance")
    
        self.assertEqual(inst.asserter.display, "P. van de Heuvel")
        self.assertEqual(inst.asserter.reference, "Patient/f001")
        self.assertEqual(inst.category.coding[0].code, "439401001")
        self.assertEqual(inst.category.coding[0].display, "diagnosis")
        self.assertEqual(inst.category.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.code.coding[0].code, "368009")
        self.assertEqual(inst.code.coding[0].display, "Heart valve disorder")
        self.assertEqual(inst.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dateAsserted.date, FHIRDate("2011-10-05").date)
        self.assertEqual(inst.dateAsserted.isostring, "2011-10-05")
        self.assertEqual(inst.encounter.reference, "Encounter/f001")
        self.assertEqual(inst.evidence[0].code.coding[0].code, "426396005")
        self.assertEqual(inst.evidence[0].code.coding[0].display, "Cardiac chest pain")
        self.assertEqual(inst.evidence[0].code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.location[0].code.coding[0].code, "40768004")
        self.assertEqual(inst.location[0].code.coding[0].display, "Left thorax")
        self.assertEqual(inst.location[0].code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.location[0].detail, "heart structure")
        self.assertEqual(inst.onsetDate.date, FHIRDate("2011-08-05").date)
        self.assertEqual(inst.onsetDate.isostring, "2011-08-05")
        self.assertEqual(inst.severity.coding[0].code, "6736007")
        self.assertEqual(inst.severity.coding[0].display, "Moderate")
        self.assertEqual(inst.severity.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.status, "confirmed")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>encounter</b>: \n        <a href=\"encounter-example-f001-heart.html\">v1451 (official); finished; outpatient; Patient-initiated encounter; 140 min; Heart valve replacement; Non-urgent cardiological admission</a>\n      </p>\n      <p>\n        <b>asserter</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>dateAsserted</b>: 5-Oct 2011\n      </p>\n      <p>\n        <b>code</b>: \n        <span title=\"Codes: {http://snomed.info/sct 368009}\">Heart valve disorder</span>\n      </p>\n      <p>\n        <b>category</b>: \n        <span title=\"Codes: {http://snomed.info/sct 439401001}\">diagnosis</span>\n      </p>\n      <p>\n        <b>status</b>: confirmed\n      </p>\n      <p>\n        <b>severity</b>: \n        <span title=\"Codes: {http://snomed.info/sct 6736007}\">Moderate</span>\n      </p>\n      <p>\n        <b>onset[x]</b>: 5-Aug 2011\n      </p>\n      <h3>Evidences</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 426396005}\">Cardiac chest pain</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>Locations</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 40768004}\">Left thorax</span>\n          </td>\n          <td>heart structure</td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCondition2(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/condition-example-f002-lung.json")
        self.assertIsNotNone(inst, "Must have instantiated a Condition instance")
    
        self.assertEqual(inst.asserter.display, "P. van de Heuvel")
        self.assertEqual(inst.asserter.reference, "Patient/f001")
        self.assertEqual(inst.category.coding[0].code, "439401001")
        self.assertEqual(inst.category.coding[0].display, "diagnosis")
        self.assertEqual(inst.category.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.code.coding[0].code, "254637007")
        self.assertEqual(inst.code.coding[0].display, "NSCLC - Non-small cell lung cancer")
        self.assertEqual(inst.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dateAsserted.date, FHIRDate("2012-06-03").date)
        self.assertEqual(inst.dateAsserted.isostring, "2012-06-03")
        self.assertEqual(inst.encounter.reference, "Encounter/f002")
        self.assertEqual(inst.evidence[0].code.coding[0].code, "169069000")
        self.assertEqual(inst.evidence[0].code.coding[0].display, "CT of thorax")
        self.assertEqual(inst.evidence[0].code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.location[0].code.coding[0].code, "51185008")
        self.assertEqual(inst.location[0].code.coding[0].display, "Thorax")
        self.assertEqual(inst.location[0].code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.location[0].detail, "lung")
        self.assertEqual(inst.onsetDate.date, FHIRDate("2011-05-05").date)
        self.assertEqual(inst.onsetDate.isostring, "2011-05-05")
        self.assertEqual(inst.severity.coding[0].code, "24484000")
        self.assertEqual(inst.severity.coding[0].display, "Severe")
        self.assertEqual(inst.severity.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.stage.summary.coding[0].code, "258219007")
        self.assertEqual(inst.stage.summary.coding[0].display, "stage II")
        self.assertEqual(inst.stage.summary.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.status, "confirmed")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>encounter</b>: \n        <a href=\"encounter-example-f002-lung.html\">v3251 (official); finished; outpatient; Patient-initiated encounter; 140 min; Partial lobectomy of lung; Urgent</a>\n      </p>\n      <p>\n        <b>asserter</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>dateAsserted</b>: 3-Jun 2012\n      </p>\n      <p>\n        <b>code</b>: \n        <span title=\"Codes: {http://snomed.info/sct 254637007}\">NSCLC - Non-small cell lung cancer</span>\n      </p>\n      <p>\n        <b>category</b>: \n        <span title=\"Codes: {http://snomed.info/sct 439401001}\">diagnosis</span>\n      </p>\n      <p>\n        <b>status</b>: confirmed\n      </p>\n      <p>\n        <b>severity</b>: \n        <span title=\"Codes: {http://snomed.info/sct 24484000}\">Severe</span>\n      </p>\n      <p>\n        <b>onset[x]</b>: 5-May 2011\n      </p>\n      <h3>Stages</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Summary</b>\n          </td>\n          <td>\n            <b>Assessment</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 258219007}\">stage II</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>Evidences</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 169069000}\">CT of thorax</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>Locations</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 51185008}\">Thorax</span>\n          </td>\n          <td>lung</td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCondition3(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/condition-example-f003-abscess.json")
        self.assertIsNotNone(inst, "Must have instantiated a Condition instance")
    
        self.assertEqual(inst.asserter.display, "P. van de Heuvel")
        self.assertEqual(inst.asserter.reference, "Patient/f001")
        self.assertEqual(inst.category.coding[0].code, "439401001")
        self.assertEqual(inst.category.coding[0].display, "diagnosis")
        self.assertEqual(inst.category.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.code.coding[0].code, "18099001")
        self.assertEqual(inst.code.coding[0].display, "Retropharyngeal abscess")
        self.assertEqual(inst.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dateAsserted.date, FHIRDate("2012-02-20").date)
        self.assertEqual(inst.dateAsserted.isostring, "2012-02-20")
        self.assertEqual(inst.encounter.reference, "Encounter/f003")
        self.assertEqual(inst.evidence[0].code.coding[0].code, "169068008")
        self.assertEqual(inst.evidence[0].code.coding[0].display, "CT of neck")
        self.assertEqual(inst.evidence[0].code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.location[0].code.coding[0].code, "280193007")
        self.assertEqual(inst.location[0].code.coding[0].display, "Entire retropharyngeal area")
        self.assertEqual(inst.location[0].code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.onsetDate.date, FHIRDate("2012-02-27").date)
        self.assertEqual(inst.onsetDate.isostring, "2012-02-27")
        self.assertEqual(inst.severity.coding[0].code, "371923003")
        self.assertEqual(inst.severity.coding[0].display, "Mild to moderate")
        self.assertEqual(inst.severity.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.status, "confirmed")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>encounter</b>: \n        <a href=\"encounter-example-f003-abscess.html\">v6751 (official); finished; outpatient; Patient-initiated encounter; 90 min; Retropharyngeal abscess; Non-urgent ear, nose and throat admission</a>\n      </p>\n      <p>\n        <b>asserter</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>dateAsserted</b>: 20-Feb 2012\n      </p>\n      <p>\n        <b>code</b>: \n        <span title=\"Codes: {http://snomed.info/sct 18099001}\">Retropharyngeal abscess</span>\n      </p>\n      <p>\n        <b>category</b>: \n        <span title=\"Codes: {http://snomed.info/sct 439401001}\">diagnosis</span>\n      </p>\n      <p>\n        <b>status</b>: confirmed\n      </p>\n      <p>\n        <b>severity</b>: \n        <span title=\"Codes: {http://snomed.info/sct 371923003}\">Mild to moderate</span>\n      </p>\n      <p>\n        <b>onset[x]</b>: 27-Feb 2012\n      </p>\n      <h3>Evidences</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 169068008}\">CT of neck</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>Locations</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 280193007}\">Entire retropharyngeal area</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCondition4(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/condition-example-f201-fever.json")
        self.assertIsNotNone(inst, "Must have instantiated a Condition instance")
    
        self.assertEqual(inst.asserter.reference, "Practitioner/f201")
        self.assertEqual(inst.category.coding[0].code, "55607006")
        self.assertEqual(inst.category.coding[0].display, "Problem")
        self.assertEqual(inst.category.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.category.coding[1].code, "condition")
        self.assertEqual(inst.category.coding[1].system, "http://hl7.org/fhir/condition-category")
        self.assertEqual(inst.code.coding[0].code, "386661006")
        self.assertEqual(inst.code.coding[0].display, "Fever")
        self.assertEqual(inst.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dateAsserted.date, FHIRDate("2013-04-04").date)
        self.assertEqual(inst.dateAsserted.isostring, "2013-04-04")
        self.assertEqual(inst.encounter.reference, "Encounter/f201")
        self.assertEqual(inst.evidence[0].code.coding[0].code, "258710007")
        self.assertEqual(inst.evidence[0].code.coding[0].display, "degrees C")
        self.assertEqual(inst.evidence[0].code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.evidence[0].detail[0].display, "Temperature")
        self.assertEqual(inst.evidence[0].detail[0].reference, "Observation/f202")
        self.assertEqual(inst.location[0].code.coding[0].code, "38266002")
        self.assertEqual(inst.location[0].code.coding[0].display, "Entire body as a whole")
        self.assertEqual(inst.location[0].code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.onsetDate.date, FHIRDate("2013-04-02").date)
        self.assertEqual(inst.onsetDate.isostring, "2013-04-02")
        self.assertEqual(inst.relatedItem[0].target.display, "TPF chemokuur")
        self.assertEqual(inst.relatedItem[0].target.reference, "Procedure/f201")
        self.assertEqual(inst.relatedItem[0].type, "due-to")
        self.assertEqual(inst.relatedItem[1].target.display, "bacterial infection")
        self.assertEqual(inst.relatedItem[1].target.reference, "Condition/f205")
        self.assertEqual(inst.relatedItem[1].type, "due-to")
        self.assertEqual(inst.severity.coding[0].code, "255604002")
        self.assertEqual(inst.severity.coding[0].display, "Mild")
        self.assertEqual(inst.severity.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.status, "confirmed")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <p>\n        <b>encounter</b>: \n        <a href=\"encounter-example-f201-20130404.html\">Roel's encounter on April fourth 2013 = Encounter_Roel_20130404 (temp); finished; outpatient; Consultation; The patient had fever peaks over the last couple of days. He is worried about these peaks.; Normal</a>\n      </p>\n      <p>\n        <b>asserter</b>: \n        <a href=\"practitioner-example-f201-ab.html\">UZI-nummer = 12345678901 (official); Dokter Bronsig(official); Male; birthDate: 24-Dec 1956; Implementation of planned interventions; Medical oncologist</a>\n      </p>\n      <p>\n        <b>dateAsserted</b>: 4-Apr 2013\n      </p>\n      <p>\n        <b>code</b>: \n        <span title=\"Codes: {http://snomed.info/sct 386661006}\">Fever</span>\n      </p>\n      <p>\n        <b>category</b>: \n        <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category condition}\">Problem</span>\n      </p>\n      <p>\n        <b>status</b>: confirmed\n      </p>\n      <p>\n        <b>severity</b>: \n        <span title=\"Codes: {http://snomed.info/sct 255604002}\">Mild</span>\n      </p>\n      <p>\n        <b>onset[x]</b>: 2-Apr 2013\n      </p>\n      <h3>Evidences</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 258710007}\">degrees C</span>\n          </td>\n          <td>Temperature</td>\n        </tr>\n      </table>\n      <h3>Locations</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 38266002}\">Entire body as a whole</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>RelatedItems</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Target</b>\n          </td>\n        </tr>\n        <tr>\n          <td>dueto</td>\n          <td> </td>\n          <td>TPF chemokuur</td>\n        </tr>\n        <tr>\n          <td>dueto</td>\n          <td> </td>\n          <td>bacterial infection</td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCondition5(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/condition-example-f202-malignancy.json")
        self.assertIsNotNone(inst, "Must have instantiated a Condition instance")
    
        self.assertEqual(inst.category.coding[0].code, "diagnose")
        self.assertEqual(inst.category.coding[0].system, "http://hl7.org/fhir/condition-category")
        self.assertEqual(inst.certainty.coding[0].code, "17162000")
        self.assertEqual(inst.certainty.coding[0].display, "Certain")
        self.assertEqual(inst.certainty.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.code.coding[0].code, "363346000")
        self.assertEqual(inst.code.coding[0].display, "Malignant neoplastic disease")
        self.assertEqual(inst.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dateAsserted.date, FHIRDate("2012-12-01").date)
        self.assertEqual(inst.dateAsserted.isostring, "2012-12-01")
        self.assertEqual(inst.evidence[0].detail[0].display, "Erasmus' diagnostic report of Roel's tumor")
        self.assertEqual(inst.evidence[0].detail[0].reference, "DiagnosticReport/f201")
        self.assertEqual(inst.location[0].code.coding[0].code, "361355005")
        self.assertEqual(inst.location[0].code.coding[0].display, "Entire head and neck")
        self.assertEqual(inst.location[0].code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.severity.coding[0].code, "24484000")
        self.assertEqual(inst.severity.coding[0].display, "Severe")
        self.assertEqual(inst.severity.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.status, "confirmed")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <p>\n        <b>dateAsserted</b>: 1-Dec 2012\n      </p>\n      <p>\n        <b>code</b>: \n        <span title=\"Codes: {http://snomed.info/sct 363346000}\">Malignant neoplastic disease</span>\n      </p>\n      <p>\n        <b>category</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/condition-category diagnose}\">diagnose</span>\n      </p>\n      <p>\n        <b>status</b>: confirmed\n      </p>\n      <p>\n        <b>certainty</b>: \n        <span title=\"Codes: {http://snomed.info/sct 17162000}\">Certain</span>\n      </p>\n      <p>\n        <b>severity</b>: \n        <span title=\"Codes: {http://snomed.info/sct 24484000}\">Severe</span>\n      </p>\n      <p>\n        <b>onset[x]</b>: 52 years\n      </p>\n      <h3>Evidences</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>Erasmus' diagnostic report of Roel's tumor</td>\n        </tr>\n      </table>\n      <h3>Locations</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 361355005}\">Entire head and neck</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCondition6(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/condition-example-f203-sepsis.json")
        self.assertIsNotNone(inst, "Must have instantiated a Condition instance")
    
        self.assertEqual(inst.asserter.reference, "Practitioner/f201")
        self.assertEqual(inst.category.coding[0].code, "55607006")
        self.assertEqual(inst.category.coding[0].display, "Problem")
        self.assertEqual(inst.category.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.category.coding[1].code, "finding")
        self.assertEqual(inst.category.coding[1].system, "http://hl7.org/fhir/condition-category")
        self.assertEqual(inst.certainty.coding[0].code, "17162000")
        self.assertEqual(inst.certainty.coding[0].display, "Certain")
        self.assertEqual(inst.certainty.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.code.coding[0].code, "10001005")
        self.assertEqual(inst.code.coding[0].display, "Bacterial sepsis")
        self.assertEqual(inst.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dateAsserted.date, FHIRDate("2013-03-11").date)
        self.assertEqual(inst.dateAsserted.isostring, "2013-03-11")
        self.assertEqual(inst.encounter.display, "Roel's encounter on March eleventh")
        self.assertEqual(inst.encounter.reference, "Encounter/f203")
        self.assertEqual(inst.evidence[0].detail[0].display, "Diagnostic report for Roel's sepsis")
        self.assertEqual(inst.evidence[0].detail[0].reference, "DiagnosticReport/f202")
        self.assertEqual(inst.location[0].code.coding[0].code, "281158006")
        self.assertEqual(inst.location[0].code.coding[0].display, "Pulmonary vascular structure")
        self.assertEqual(inst.location[0].code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.onsetDate.date, FHIRDate("2013-03-08").date)
        self.assertEqual(inst.onsetDate.isostring, "2013-03-08")
        self.assertEqual(inst.relatedItem[0].target.display, "Staphylococcus Aureus")
        self.assertEqual(inst.relatedItem[0].target.reference, "Substance/f202")
        self.assertEqual(inst.relatedItem[0].type, "due-to")
        self.assertEqual(inst.severity.coding[0].code, "371924009")
        self.assertEqual(inst.severity.coding[0].display, "Moderate to severe")
        self.assertEqual(inst.severity.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.status, "confirmed")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <p>\n        <b>encounter</b>: Roel's encounter on March eleventh\n      </p>\n      <p>\n        <b>asserter</b>: \n        <a href=\"practitioner-example-f201-ab.html\">UZI-nummer = 12345678901 (official); Dokter Bronsig(official); Male; birthDate: 24-Dec 1956; Implementation of planned interventions; Medical oncologist</a>\n      </p>\n      <p>\n        <b>dateAsserted</b>: 11-Mar 2013\n      </p>\n      <p>\n        <b>code</b>: \n        <span title=\"Codes: {http://snomed.info/sct 10001005}\">Bacterial sepsis</span>\n      </p>\n      <p>\n        <b>category</b>: \n        <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category finding}\">Problem</span>\n      </p>\n      <p>\n        <b>status</b>: confirmed\n      </p>\n      <p>\n        <b>certainty</b>: \n        <span title=\"Codes: {http://snomed.info/sct 17162000}\">Certain</span>\n      </p>\n      <p>\n        <b>severity</b>: \n        <span title=\"Codes: {http://snomed.info/sct 371924009}\">Moderate to severe</span>\n      </p>\n      <p>\n        <b>onset[x]</b>: 8-Mar 2013\n      </p>\n      <h3>Evidences</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>Diagnostic report for Roel's sepsis</td>\n        </tr>\n      </table>\n      <h3>Locations</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 281158006}\">Pulmonary vascular structure</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>RelatedItems</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Target</b>\n          </td>\n        </tr>\n        <tr>\n          <td>dueto</td>\n          <td> </td>\n          <td>Staphylococcus Aureus</td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCondition7(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/condition-example-f204-renal.json")
        self.assertIsNotNone(inst, "Must have instantiated a Condition instance")
    
        self.assertEqual(inst.abatementDate.date, FHIRDate("2013-03-20").date)
        self.assertEqual(inst.abatementDate.isostring, "2013-03-20")
        self.assertEqual(inst.asserter.reference, "Practitioner/f201")
        self.assertEqual(inst.category.coding[0].code, "55607006")
        self.assertEqual(inst.category.coding[0].display, "Problem")
        self.assertEqual(inst.category.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.category.coding[1].code, "condition")
        self.assertEqual(inst.category.coding[1].system, "http://hl7.org/fhir/condition-category")
        self.assertEqual(inst.code.coding[0].code, "36225005")
        self.assertEqual(inst.code.coding[0].display, "Acute renal insufficiency specified as due to procedure")
        self.assertEqual(inst.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dateAsserted.date, FHIRDate("2013-03-11").date)
        self.assertEqual(inst.dateAsserted.isostring, "2013-03-11")
        self.assertEqual(inst.encounter.display, "Roel's encounter on March eleventh")
        self.assertEqual(inst.encounter.reference, "Encounter/f203")
        self.assertEqual(inst.location[0].code.coding[0].code, "181414000")
        self.assertEqual(inst.location[0].code.coding[0].display, "Kidney")
        self.assertEqual(inst.location[0].code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.onsetDate.date, FHIRDate("2013-03-11").date)
        self.assertEqual(inst.onsetDate.isostring, "2013-03-11")
        self.assertEqual(inst.relatedItem[0].target.display, "TPF chemotherapy for the sphenoid bone")
        self.assertEqual(inst.relatedItem[0].target.reference, "Procedure/f201")
        self.assertEqual(inst.relatedItem[0].type, "due-to")
        self.assertEqual(inst.severity.coding[0].code, "24484000")
        self.assertEqual(inst.severity.coding[0].display, "Severe")
        self.assertEqual(inst.severity.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.stage.summary.coding[0].code, "14803004")
        self.assertEqual(inst.stage.summary.coding[0].display, "Temporary")
        self.assertEqual(inst.stage.summary.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.status, "working")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <p>\n        <b>encounter</b>: Roel's encounter on March eleventh\n      </p>\n      <p>\n        <b>asserter</b>: \n        <a href=\"practitioner-example-f201-ab.html\">UZI-nummer = 12345678901 (official); Dokter Bronsig(official); Male; birthDate: 24-Dec 1956; Implementation of planned interventions; Medical oncologist</a>\n      </p>\n      <p>\n        <b>dateAsserted</b>: 11-Mar 2013\n      </p>\n      <p>\n        <b>code</b>: \n        <span title=\"Codes: {http://snomed.info/sct 36225005}\">Acute renal insufficiency specified as due to procedure</span>\n      </p>\n      <p>\n        <b>category</b>: \n        <span title=\"Codes: {http://snomed.info/sct 55607006}, {http://hl7.org/fhir/condition-category condition}\">Problem</span>\n      </p>\n      <p>\n        <b>status</b>: working\n      </p>\n      <p>\n        <b>severity</b>: \n        <span title=\"Codes: {http://snomed.info/sct 24484000}\">Severe</span>\n      </p>\n      <p>\n        <b>onset[x]</b>: 11-Mar 2013\n      </p>\n      <p>\n        <b>abatement[x]</b>: 20-Mar 2013\n      </p>\n      <h3>Stages</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Summary</b>\n          </td>\n          <td>\n            <b>Assessment</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 14803004}\">Temporary</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>Locations</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Detail</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 181414000}\">Kidney</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>RelatedItems</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Target</b>\n          </td>\n        </tr>\n        <tr>\n          <td>dueto</td>\n          <td> </td>\n          <td>TPF chemotherapy for the sphenoid bone</td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCondition8(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/condition-example-f205-infection.json")
        self.assertIsNotNone(inst, "Must have instantiated a Condition instance")
    
        self.assertEqual(inst.asserter.reference, "Practitioner/f201")
        self.assertEqual(inst.code.coding[0].code, "87628006")
        self.assertEqual(inst.code.coding[0].display, "Bacterial infectious disease")
        self.assertEqual(inst.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dateAsserted.date, FHIRDate("2013-04-04").date)
        self.assertEqual(inst.dateAsserted.isostring, "2013-04-04")
        self.assertEqual(inst.status, "working")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <p>\n        <b>asserter</b>: \n        <a href=\"practitioner-example-f201-ab.html\">UZI-nummer = 12345678901 (official); Dokter Bronsig(official); Male; birthDate: 24-Dec 1956; Implementation of planned interventions; Medical oncologist</a>\n      </p>\n      <p>\n        <b>dateAsserted</b>: 4-Apr 2013\n      </p>\n      <p>\n        <b>code</b>: \n        <span title=\"Codes: {http://snomed.info/sct 87628006}\">Bacterial infectious disease</span>\n      </p>\n      <p>\n        <b>status</b>: working\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")

