#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 0.0.82.2943 (xds-profile.profile.json) on 2014-10-31.
#  2014, SMART Platforms.


import io
import unittest
import json
from encounter import Encounter
from fhirdate import FHIRDate


class EncounterTests(unittest.TestCase):
    def instantiate_from(self, filename):
        with io.open(filename, 'r', encoding='utf-8') as handle:
            js = json.load(handle)
        instance = Encounter(js)
        self.assertIsNotNone(instance, "Must have instantiated a test instance")
        return instance
    
    def testEncounter1(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/encounter-example-f001-heart.json")
        self.assertIsNotNone(inst, "Must have instantiated a Encounter instance")
    
        self.assertEqual(inst.hospitalization.accomodation[0].period.end.date, FHIRDate("2011-07-01").date)
        self.assertEqual(inst.hospitalization.accomodation[0].period.end.isostring, "2011-07-01")
        self.assertEqual(inst.hospitalization.accomodation[0].period.start.date, FHIRDate("2011-06-26").date)
        self.assertEqual(inst.hospitalization.accomodation[0].period.start.isostring, "2011-06-26")
        self.assertEqual(inst.hospitalization.admitSource.coding[0].code, "305956004")
        self.assertEqual(inst.hospitalization.admitSource.coding[0].display, "Referral by physician")
        self.assertEqual(inst.hospitalization.admitSource.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.hospitalization.dischargeDisposition.coding[0].code, "306689006")
        self.assertEqual(inst.hospitalization.dischargeDisposition.coding[0].display, "Discharge to home")
        self.assertEqual(inst.hospitalization.dischargeDisposition.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.hospitalization.period.end.date, FHIRDate("2011-06-30").date)
        self.assertEqual(inst.hospitalization.period.end.isostring, "2011-06-30")
        self.assertEqual(inst.hospitalization.period.start.date, FHIRDate("2011-06-26").date)
        self.assertEqual(inst.hospitalization.period.start.isostring, "2011-06-26")
        self.assertEqual(inst.hospitalization.preAdmissionIdentifier.system, "http://www.amc.nl/zorgportal/identifiers/pre-admissions")
        self.assertEqual(inst.hospitalization.preAdmissionIdentifier.use, "official")
        self.assertEqual(inst.hospitalization.preAdmissionIdentifier.value, "93042")
        self.assertFalse(inst.hospitalization.reAdmission)
        self.assertEqual(inst.identifier[0].system, "http://www.amc.nl/zorgportal/identifiers/visits")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "v1451")
        self.assertEqual(inst.participant[0].individual.display, "P. Voigt")
        self.assertEqual(inst.participant[0].individual.reference, "Practitioner/f002")
        self.assertEqual(inst.priority.coding[0].code, "310361003")
        self.assertEqual(inst.priority.coding[0].display, "Non-urgent cardiological admission")
        self.assertEqual(inst.priority.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.reason.coding[0].code, "34068001")
        self.assertEqual(inst.reason.coding[0].display, "Heart valve replacement")
        self.assertEqual(inst.reason.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.serviceProvider.display, "Burgers University Medical Center")
        self.assertEqual(inst.serviceProvider.reference, "Organization/f001")
        self.assertEqual(inst.status, "finished")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: v1451 (official)\n      </p>\n      <p>\n        <b>status</b>: finished\n      </p>\n      <p>\n        <b>class</b>: outpatient\n      </p>\n      <p>\n        <b>type</b>: \n        <span title=\"Codes: {http://snomed.info/sct 270427003}\">Patient-initiated encounter</span>\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Individual</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>P. Voigt</td>\n        </tr>\n      </table>\n      <p>\n        <b>length</b>: 140 min\n      </p>\n      <p>\n        <b>reason</b>: \n        <span title=\"Codes: {http://snomed.info/sct 34068001}\">Heart valve replacement</span>\n      </p>\n      <p>\n        <b>priority</b>: \n        <span title=\"Codes: {http://snomed.info/sct 310361003}\">Non-urgent cardiological admission</span>\n      </p>\n      <blockquote>\n        <p>\n          <b>hospitalization</b>\n        </p>\n        <p>\n          <b>preAdmissionIdentifier</b>: 93042 (official)\n        </p>\n        <p>\n          <b>admitSource</b>: \n          <span title=\"Codes: {http://snomed.info/sct 305956004}\">Referral by physician</span>\n        </p>\n        <p>\n          <b>period</b>: 26-Jun 2011 --&gt; 30-Jun 2011\n        </p>\n        <h3>Accomodations</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Bed</b>\n            </td>\n            <td>\n              <b>Period</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td>26-Jun 2011 --&gt; 1-Jul 2011</td>\n          </tr>\n        </table>\n        <p>\n          <b>dischargeDisposition</b>: \n          <span title=\"Codes: {http://snomed.info/sct 306689006}\">Discharge to home</span>\n        </p>\n        <p>\n          <b>reAdmission</b>: false\n        </p>\n      </blockquote>\n      <p>\n        <b>serviceProvider</b>: Burgers University Medical Center\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type[0].coding[0].code, "270427003")
        self.assertEqual(inst.type[0].coding[0].display, "Patient-initiated encounter")
        self.assertEqual(inst.type[0].coding[0].system, "http://snomed.info/sct")
    
    def testEncounter2(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/encounter-example-f002-lung.json")
        self.assertIsNotNone(inst, "Must have instantiated a Encounter instance")
    
        self.assertEqual(inst.hospitalization.accomodation[0].period.end.date, FHIRDate("2012-07-13").date)
        self.assertEqual(inst.hospitalization.accomodation[0].period.end.isostring, "2012-07-13")
        self.assertEqual(inst.hospitalization.accomodation[0].period.start.date, FHIRDate("2012-07-06").date)
        self.assertEqual(inst.hospitalization.accomodation[0].period.start.isostring, "2012-07-06")
        self.assertEqual(inst.hospitalization.admitSource.coding[0].code, "305997006")
        self.assertEqual(inst.hospitalization.admitSource.coding[0].display, "Referral by radiologist")
        self.assertEqual(inst.hospitalization.admitSource.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.hospitalization.dischargeDisposition.coding[0].code, "306689006")
        self.assertEqual(inst.hospitalization.dischargeDisposition.coding[0].display, "Discharge to home")
        self.assertEqual(inst.hospitalization.dischargeDisposition.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.hospitalization.period.end.date, FHIRDate("2012-07-13").date)
        self.assertEqual(inst.hospitalization.period.end.isostring, "2012-07-13")
        self.assertEqual(inst.hospitalization.period.start.date, FHIRDate("2012-07-06").date)
        self.assertEqual(inst.hospitalization.period.start.isostring, "2012-07-06")
        self.assertEqual(inst.hospitalization.preAdmissionIdentifier.system, "http://www.bmc.nl/zorgportal/identifiers/pre-admissions")
        self.assertEqual(inst.hospitalization.preAdmissionIdentifier.use, "official")
        self.assertEqual(inst.hospitalization.preAdmissionIdentifier.value, "98682")
        self.assertFalse(inst.hospitalization.reAdmission)
        self.assertEqual(inst.identifier[0].system, "http://www.bmc.nl/zorgportal/identifiers/encounters")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "v3251")
        self.assertEqual(inst.participant[0].individual.display, "M.I.M Versteegh")
        self.assertEqual(inst.participant[0].individual.reference, "Practitioner/f003")
        self.assertEqual(inst.priority.coding[0].code, "103391001")
        self.assertEqual(inst.priority.coding[0].display, "Urgent")
        self.assertEqual(inst.priority.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.reason.coding[0].code, "34068001")
        self.assertEqual(inst.reason.coding[0].display, "Partial lobectomy of lung")
        self.assertEqual(inst.reason.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.serviceProvider.display, "BMC")
        self.assertEqual(inst.serviceProvider.reference, "Organization/f001")
        self.assertEqual(inst.status, "finished")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: v3251 (official)\n      </p>\n      <p>\n        <b>status</b>: finished\n      </p>\n      <p>\n        <b>class</b>: outpatient\n      </p>\n      <p>\n        <b>type</b>: \n        <span title=\"Codes: {http://snomed.info/sct 270427003}\">Patient-initiated encounter</span>\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Individual</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>M.I.M Versteegh</td>\n        </tr>\n      </table>\n      <p>\n        <b>length</b>: 140 min\n      </p>\n      <p>\n        <b>reason</b>: \n        <span title=\"Codes: {http://snomed.info/sct 34068001}\">Partial lobectomy of lung</span>\n      </p>\n      <p>\n        <b>priority</b>: \n        <span title=\"Codes: {http://snomed.info/sct 103391001}\">Urgent</span>\n      </p>\n      <blockquote>\n        <p>\n          <b>hospitalization</b>\n        </p>\n        <p>\n          <b>preAdmissionIdentifier</b>: 98682 (official)\n        </p>\n        <p>\n          <b>admitSource</b>: \n          <span title=\"Codes: {http://snomed.info/sct 305997006}\">Referral by radiologist</span>\n        </p>\n        <p>\n          <b>period</b>: 6-Jul 2012 --&gt; 13-Jul 2012\n        </p>\n        <h3>Accomodations</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Bed</b>\n            </td>\n            <td>\n              <b>Period</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td>6-Jul 2012 --&gt; 13-Jul 2012</td>\n          </tr>\n        </table>\n        <p>\n          <b>dischargeDisposition</b>: \n          <span title=\"Codes: {http://snomed.info/sct 306689006}\">Discharge to home</span>\n        </p>\n        <p>\n          <b>reAdmission</b>: false\n        </p>\n      </blockquote>\n      <p>\n        <b>serviceProvider</b>: BMC\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type[0].coding[0].code, "270427003")
        self.assertEqual(inst.type[0].coding[0].display, "Patient-initiated encounter")
        self.assertEqual(inst.type[0].coding[0].system, "http://snomed.info/sct")
    
    def testEncounter3(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/encounter-example-f003-abscess.json")
        self.assertIsNotNone(inst, "Must have instantiated a Encounter instance")
    
        self.assertEqual(inst.hospitalization.accomodation[0].period.end.date, FHIRDate("2011-07-01").date)
        self.assertEqual(inst.hospitalization.accomodation[0].period.end.isostring, "2011-07-01")
        self.assertEqual(inst.hospitalization.accomodation[0].period.start.date, FHIRDate("2011-06-26").date)
        self.assertEqual(inst.hospitalization.accomodation[0].period.start.isostring, "2011-06-26")
        self.assertEqual(inst.hospitalization.admitSource.coding[0].code, "305956004")
        self.assertEqual(inst.hospitalization.admitSource.coding[0].display, "Referral by physician")
        self.assertEqual(inst.hospitalization.admitSource.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.hospitalization.dischargeDisposition.coding[0].code, "306689006")
        self.assertEqual(inst.hospitalization.dischargeDisposition.coding[0].display, "Discharge to home")
        self.assertEqual(inst.hospitalization.dischargeDisposition.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.hospitalization.period.end.date, FHIRDate("2011-06-30").date)
        self.assertEqual(inst.hospitalization.period.end.isostring, "2011-06-30")
        self.assertEqual(inst.hospitalization.period.start.date, FHIRDate("2011-06-26").date)
        self.assertEqual(inst.hospitalization.period.start.isostring, "2011-06-26")
        self.assertEqual(inst.hospitalization.preAdmissionIdentifier.system, "http://www.bmc.nl/zorgportal/identifiers/pre-admissions")
        self.assertEqual(inst.hospitalization.preAdmissionIdentifier.use, "official")
        self.assertEqual(inst.hospitalization.preAdmissionIdentifier.value, "93042")
        self.assertFalse(inst.hospitalization.reAdmission)
        self.assertEqual(inst.identifier[0].system, "http://www.bmc.nl/zorgportal/identifiers/encounters")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "v6751")
        self.assertEqual(inst.participant[0].individual.display, "E.M. van den Broek")
        self.assertEqual(inst.participant[0].individual.reference, "Practitioner/f001")
        self.assertEqual(inst.priority.coding[0].code, "103391001")
        self.assertEqual(inst.priority.coding[0].display, "Non-urgent ear, nose and throat admission")
        self.assertEqual(inst.priority.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.reason.coding[0].code, "18099001")
        self.assertEqual(inst.reason.coding[0].display, "Retropharyngeal abscess")
        self.assertEqual(inst.reason.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.serviceProvider.reference, "Organization/f001")
        self.assertEqual(inst.status, "finished")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: v6751 (official)\n      </p>\n      <p>\n        <b>status</b>: finished\n      </p>\n      <p>\n        <b>class</b>: outpatient\n      </p>\n      <p>\n        <b>type</b>: \n        <span title=\"Codes: {http://snomed.info/sct 270427003}\">Patient-initiated encounter</span>\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Individual</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>E.M. van den Broek</td>\n        </tr>\n      </table>\n      <p>\n        <b>length</b>: 90 min\n      </p>\n      <p>\n        <b>reason</b>: \n        <span title=\"Codes: {http://snomed.info/sct 18099001}\">Retropharyngeal abscess</span>\n      </p>\n      <p>\n        <b>priority</b>: \n        <span title=\"Codes: {http://snomed.info/sct 103391001}\">Non-urgent ear, nose and throat admission</span>\n      </p>\n      <blockquote>\n        <p>\n          <b>hospitalization</b>\n        </p>\n        <p>\n          <b>preAdmissionIdentifier</b>: 93042 (official)\n        </p>\n        <p>\n          <b>admitSource</b>: \n          <span title=\"Codes: {http://snomed.info/sct 305956004}\">Referral by physician</span>\n        </p>\n        <p>\n          <b>period</b>: 26-Jun 2011 --&gt; 30-Jun 2011\n        </p>\n        <h3>Accomodations</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Bed</b>\n            </td>\n            <td>\n              <b>Period</b>\n            </td>\n          </tr>\n          <tr>\n            <td> </td>\n            <td>26-Jun 2011 --&gt; 1-Jul 2011</td>\n          </tr>\n        </table>\n        <p>\n          <b>dischargeDisposition</b>: \n          <span title=\"Codes: {http://snomed.info/sct 306689006}\">Discharge to home</span>\n        </p>\n        <p>\n          <b>reAdmission</b>: false\n        </p>\n      </blockquote>\n      <p>\n        <b>serviceProvider</b>: \n        <a href=\"organization-example-f001-burgers.html\">91654 (official), 17-0112278 (usual); name: Burgers University Medical Center; University Medical Hospital</a>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type[0].coding[0].code, "270427003")
        self.assertEqual(inst.type[0].coding[0].display, "Patient-initiated encounter")
        self.assertEqual(inst.type[0].coding[0].system, "http://snomed.info/sct")
    
    def testEncounter4(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/encounter-example-f201-20130404.json")
        self.assertIsNotNone(inst, "Must have instantiated a Encounter instance")
    
        self.assertEqual(inst.identifier[0].label, "Roel's encounter on April fourth 2013")
        self.assertEqual(inst.identifier[0].use, "temp")
        self.assertEqual(inst.identifier[0].value, "Encounter_Roel_20130404")
        self.assertEqual(inst.participant[0].individual.reference, "Practitioner/f201")
        self.assertEqual(inst.priority.coding[0].code, "17621005")
        self.assertEqual(inst.priority.coding[0].display, "Normal")
        self.assertEqual(inst.priority.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.reason.text, "The patient had fever peaks over the last couple of days. He is worried about these peaks.")
        self.assertEqual(inst.serviceProvider.reference, "Organization/f201")
        self.assertEqual(inst.status, "finished")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: Roel's encounter on April fourth 2013 = Encounter_Roel_20130404 (temp)\n      </p>\n      <p>\n        <b>status</b>: finished\n      </p>\n      <p>\n        <b>class</b>: outpatient\n      </p>\n      <p>\n        <b>type</b>: \n        <span title=\"Codes: {http://snomed.info/sct 11429006}\">Consultation</span>\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Individual</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>\n            <a href=\"practitioner-example-f201-ab.html\">UZI-nummer = 12345678901 (official); Dokter Bronsig(official); Male; birthDate: 24-Dec 1956; Implementation of planned interventions; Medical oncologist</a>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>reason</b>: \n        <span title=\"Codes: \">The patient had fever peaks over the last couple of days. He is worried about these peaks.</span>\n      </p>\n      <p>\n        <b>priority</b>: \n        <span title=\"Codes: {http://snomed.info/sct 17621005}\">Normal</span>\n      </p>\n      <p>\n        <b>serviceProvider</b>: \n        <a href=\"organization-example-f201-aumc.html\">Zorginstelling naam = Artis University Medical Center (official); name: Artis University Medical Center (AUMC); Academic Medical Center; active</a>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type[0].coding[0].code, "11429006")
        self.assertEqual(inst.type[0].coding[0].display, "Consultation")
        self.assertEqual(inst.type[0].coding[0].system, "http://snomed.info/sct")
    
    def testEncounter5(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/encounter-example-f202-20130128.json")
        self.assertIsNotNone(inst, "Must have instantiated a Encounter instance")
    
        self.assertEqual(inst.identifier[0].label, "Roel's encounter on January 28th, 2013")
        self.assertEqual(inst.identifier[0].use, "temp")
        self.assertEqual(inst.identifier[0].value, "Encounter_Roel_20130128")
        self.assertEqual(inst.indication.display, "Roel's TPF chemotherapy on January 28th, 2013")
        self.assertEqual(inst.indication.reference, "Procedure/f201")
        self.assertEqual(inst.participant[0].individual.reference, "Practitioner/f201")
        self.assertEqual(inst.priority.coding[0].code, "103391001")
        self.assertEqual(inst.priority.coding[0].display, "Urgent")
        self.assertEqual(inst.priority.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.reason.text, "The patient is treated for a tumor.")
        self.assertEqual(inst.serviceProvider.reference, "Organization/f201")
        self.assertEqual(inst.status, "finished")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: Roel's encounter on January 28th, 2013 = Encounter_Roel_20130128 (temp)\n      </p>\n      <p>\n        <b>status</b>: finished\n      </p>\n      <p>\n        <b>class</b>: outpatient\n      </p>\n      <p>\n        <b>type</b>: \n        <span title=\"Codes: {http://snomed.info/sct 367336001}\">Chemotherapy</span>\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Individual</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>\n            <a href=\"practitioner-example-f201-ab.html\">UZI-nummer = 12345678901 (official); Dokter Bronsig(official); Male; birthDate: 24-Dec 1956; Implementation of planned interventions; Medical oncologist</a>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>length</b>: 56 minutes\n      </p>\n      <p>\n        <b>reason</b>: \n        <span title=\"Codes: \">The patient is treated for a tumor.</span>\n      </p>\n      <p>\n        <b>indication</b>: Roel's TPF chemotherapy on January 28th, 2013\n      </p>\n      <p>\n        <b>priority</b>: \n        <span title=\"Codes: {http://snomed.info/sct 103391001}\">Urgent</span>\n      </p>\n      <p>\n        <b>serviceProvider</b>: \n        <a href=\"organization-example-f201-aumc.html\">Zorginstelling naam = Artis University Medical Center (official); name: Artis University Medical Center (AUMC); Academic Medical Center; active</a>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type[0].coding[0].code, "367336001")
        self.assertEqual(inst.type[0].coding[0].display, "Chemotherapy")
        self.assertEqual(inst.type[0].coding[0].system, "http://snomed.info/sct")
    
    def testEncounter6(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/encounter-example-f203-20130311.json")
        self.assertIsNotNone(inst, "Must have instantiated a Encounter instance")
    
        self.assertEqual(inst.hospitalization.admitSource.coding[0].code, "309902002")
        self.assertEqual(inst.hospitalization.admitSource.coding[0].display, "Clinical Oncology Department")
        self.assertEqual(inst.hospitalization.admitSource.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.hospitalization.diet.coding[0].code, "276026009")
        self.assertEqual(inst.hospitalization.diet.coding[0].display, "Fluid balance regulation")
        self.assertEqual(inst.hospitalization.diet.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.hospitalization.period.end.date, FHIRDate("2013-03-20").date)
        self.assertEqual(inst.hospitalization.period.end.isostring, "2013-03-20")
        self.assertEqual(inst.hospitalization.period.start.date, FHIRDate("2013-03-11").date)
        self.assertEqual(inst.hospitalization.period.start.isostring, "2013-03-11")
        self.assertFalse(inst.hospitalization.reAdmission)
        self.assertEqual(inst.identifier[0].label, "Roel's encounter on March eleventh 2013")
        self.assertEqual(inst.identifier[0].use, "temp")
        self.assertEqual(inst.identifier[0].value, "Encounter_Roel_20130311")
        self.assertEqual(inst.participant[0].individual.reference, "Practitioner/f201")
        self.assertEqual(inst.priority.coding[0].code, "394849002")
        self.assertEqual(inst.priority.coding[0].display, "High priority")
        self.assertEqual(inst.priority.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.reason.text, "The patient seems to suffer from bilateral pneumonia and renal insufficiency, most likely due to chemotherapy.")
        self.assertEqual(inst.serviceProvider.reference, "Organization/f201")
        self.assertEqual(inst.status, "finished")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: Roel's encounter on March eleventh 2013 = Encounter_Roel_20130311 (temp)\n      </p>\n      <p>\n        <b>status</b>: finished\n      </p>\n      <p>\n        <b>class</b>: inpatient\n      </p>\n      <p>\n        <b>type</b>: \n        <span title=\"Codes: {http://snomed.info/sct 183807002}\">Inpatient stay for nine days</span>\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Individual</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>\n            <a href=\"practitioner-example-f201-ab.html\">UZI-nummer = 12345678901 (official); Dokter Bronsig(official); Male; birthDate: 24-Dec 1956; Implementation of planned interventions; Medical oncologist</a>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>reason</b>: \n        <span title=\"Codes: \">The patient seems to suffer from bilateral pneumonia and renal insufficiency, most likely due to chemotherapy.</span>\n      </p>\n      <p>\n        <b>priority</b>: \n        <span title=\"Codes: {http://snomed.info/sct 394849002}\">High priority</span>\n      </p>\n      <blockquote>\n        <p>\n          <b>hospitalization</b>\n        </p>\n        <p>\n          <b>admitSource</b>: \n          <span title=\"Codes: {http://snomed.info/sct 309902002}\">Clinical Oncology Department</span>\n        </p>\n        <p>\n          <b>period</b>: 11-Mar 2013 --&gt; 20-Mar 2013\n        </p>\n        <p>\n          <b>diet</b>: \n          <span title=\"Codes: {http://snomed.info/sct 276026009}\">Fluid balance regulation</span>\n        </p>\n        <p>\n          <b>reAdmission</b>: false\n        </p>\n      </blockquote>\n      <p>\n        <b>serviceProvider</b>: \n        <a href=\"organization-example-f201-aumc.html\">Zorginstelling naam = Artis University Medical Center (official); name: Artis University Medical Center (AUMC); Academic Medical Center; active</a>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type[0].coding[0].code, "183807002")
        self.assertEqual(inst.type[0].coding[0].display, "Inpatient stay for nine days")
        self.assertEqual(inst.type[0].coding[0].system, "http://snomed.info/sct")

