#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 0.0.82.2943 (xds-profile.profile.json) on 2014-10-31.
#  2014, SMART Platforms.


import io
import unittest
import json
from practitioner import Practitioner
from fhirdate import FHIRDate


class PractitionerTests(unittest.TestCase):
    def instantiate_from(self, filename):
        with io.open(filename, 'r', encoding='utf-8') as handle:
            js = json.load(handle)
        instance = Practitioner(js)
        self.assertIsNotNone(instance, "Must have instantiated a test instance")
        return instance
    
    def testPractitioner1(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/practitioner-example-f001-evdb.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
    
        self.assertEqual(inst.address.city, "Den Burg")
        self.assertEqual(inst.address.country, "NLD")
        self.assertEqual(inst.address.line[0], "Galapagosweg 91")
        self.assertEqual(inst.address.use, "work")
        self.assertEqual(inst.address.zip, "9105 PZ")
        self.assertEqual(inst.birthDate.date, FHIRDate("1975-12-07").date)
        self.assertEqual(inst.birthDate.isostring, "1975-12-07")
        self.assertEqual(inst.gender.coding[0].code, "M")
        self.assertEqual(inst.gender.coding[0].display, "Male")
        self.assertEqual(inst.gender.coding[0].system, "http://hl7.org/fhir/v3/AdministrativeGender")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.528.1.1007.3.1")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "938273695")
        self.assertEqual(inst.identifier[1].system, "urn:oid:2.16.840.1.113883.2.4.6.3")
        self.assertEqual(inst.identifier[1].use, "usual")
        self.assertEqual(inst.identifier[1].value, "129IDH4OP733")
        self.assertEqual(inst.name.family[0], "van den broek")
        self.assertEqual(inst.name.given[0], "Eric")
        self.assertEqual(inst.name.suffix[0], "MD")
        self.assertEqual(inst.name.use, "official")
        self.assertEqual(inst.organization.display, "BMC")
        self.assertEqual(inst.organization.reference, "Organization/f001")
        self.assertEqual(inst.role[0].coding[0].code, "01.000")
        self.assertEqual(inst.role[0].coding[0].display, "Arts")
        self.assertEqual(inst.role[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.role[0].text, "Care role")
        self.assertEqual(inst.specialty[0].coding[0].code, "01.018")
        self.assertEqual(inst.specialty[0].coding[0].display, "Ear-, Nose and Throat")
        self.assertEqual(inst.specialty[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.specialty[0].text, "specialisation")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "work")
        self.assertEqual(inst.telecom[0].value, "0205568263")
        self.assertEqual(inst.telecom[1].system, "email")
        self.assertEqual(inst.telecom[1].use, "work")
        self.assertEqual(inst.telecom[1].value, "E.M.vandenbroek@bmc.nl")
        self.assertEqual(inst.telecom[2].system, "fax")
        self.assertEqual(inst.telecom[2].use, "work")
        self.assertEqual(inst.telecom[2].value, "0205664440")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: 938273695 (official), 129IDH4OP733 (usual)\n      </p>\n      <p>\n        <b>name</b>: Eric van den broek (official)\n      </p>\n      <p>\n        <b>telecom</b>: ph: 0205568263(work), E.M.vandenbroek@bmc.nl(work), fax: 0205664440(work)\n      </p>\n      <p>\n        <b>address</b>: Galapagosweg 91 Den Burg 9105 PZ NLD (work)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/v3/AdministrativeGender M}\">Male</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 7-Dec 1975\n      </p>\n      <p>\n        <b>organization</b>: BMC\n      </p>\n      <p>\n        <b>role</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.000}\">Care role</span>\n      </p>\n      <p>\n        <b>specialty</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.018}\">specialisation</span>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPractitioner2(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/practitioner-example-f002-pv.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
    
        self.assertEqual(inst.address.city, "Den Burg")
        self.assertEqual(inst.address.country, "NLD")
        self.assertEqual(inst.address.line[0], "Galapagosweg 91")
        self.assertEqual(inst.address.use, "work")
        self.assertEqual(inst.address.zip, "9105 PZ")
        self.assertEqual(inst.birthDate.date, FHIRDate("1979-04-29").date)
        self.assertEqual(inst.birthDate.isostring, "1979-04-29")
        self.assertEqual(inst.gender.coding[0].code, "M")
        self.assertEqual(inst.gender.coding[0].display, "Male")
        self.assertEqual(inst.gender.coding[0].system, "urn:oid:2.16.840.1.113883.4.642.1.24")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.528.1.1007.3.1")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "730291637")
        self.assertEqual(inst.identifier[1].system, "urn:oid:2.16.840.1.113883.2.4.6.3")
        self.assertEqual(inst.identifier[1].use, "usual")
        self.assertEqual(inst.identifier[1].value, "174BIP3JH438")
        self.assertEqual(inst.name.family[0], "Voigt")
        self.assertEqual(inst.name.given[0], "Pieter")
        self.assertEqual(inst.name.suffix[0], "MD")
        self.assertEqual(inst.name.use, "official")
        self.assertEqual(inst.organization.display, "BMC")
        self.assertEqual(inst.organization.reference, "Organization/f001")
        self.assertEqual(inst.role[0].coding[0].code, "01.000")
        self.assertEqual(inst.role[0].coding[0].display, "Arts")
        self.assertEqual(inst.role[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.role[0].text, "Care role")
        self.assertEqual(inst.specialty[0].coding[0].code, "01.011")
        self.assertEqual(inst.specialty[0].coding[0].display, "Cardiothoracal surgery")
        self.assertEqual(inst.specialty[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.specialty[0].text, "specialisation")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "work")
        self.assertEqual(inst.telecom[0].value, "0205569336")
        self.assertEqual(inst.telecom[1].system, "email")
        self.assertEqual(inst.telecom[1].use, "work")
        self.assertEqual(inst.telecom[1].value, "p.voigt@bmc.nl")
        self.assertEqual(inst.telecom[2].system, "fax")
        self.assertEqual(inst.telecom[2].use, "work")
        self.assertEqual(inst.telecom[2].value, "0205669382")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: 730291637 (official), 174BIP3JH438 (usual)\n      </p>\n      <p>\n        <b>name</b>: Pieter Voigt (official)\n      </p>\n      <p>\n        <b>telecom</b>: ph: 0205569336(work), p.voigt@bmc.nl(work), fax: 0205669382(work)\n      </p>\n      <p>\n        <b>address</b>: Galapagosweg 91 Den Burg 9105 PZ NLD (work)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.4.642.1.24 M}\">Male</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 29-Apr 1979\n      </p>\n      <p>\n        <b>organization</b>: BMC\n      </p>\n      <p>\n        <b>role</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.000}\">Care role</span>\n      </p>\n      <p>\n        <b>specialty</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.011}\">specialisation</span>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPractitioner3(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/practitioner-example-f003-mv.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
    
        self.assertEqual(inst.address.city, "Amsterdam")
        self.assertEqual(inst.address.country, "NLD")
        self.assertEqual(inst.address.line[0], "Galapagosweg 91")
        self.assertEqual(inst.address.use, "work")
        self.assertEqual(inst.address.zip, "1105 AZ")
        self.assertEqual(inst.birthDate.date, FHIRDate("1963-07-01").date)
        self.assertEqual(inst.birthDate.isostring, "1963-07-01")
        self.assertEqual(inst.communication[0].coding[0].code, "nl")
        self.assertEqual(inst.communication[0].coding[0].display, "Dutch")
        self.assertEqual(inst.communication[0].coding[0].system, "urn:oid:2.16.840.1.113883.6.121")
        self.assertEqual(inst.gender.coding[0].code, "M")
        self.assertEqual(inst.gender.coding[0].display, "Male")
        self.assertEqual(inst.gender.coding[0].system, "urn:oid:2.16.840.1.113883.4.642.1.24")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.528.1.1007.3.1")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "846100293")
        self.assertEqual(inst.identifier[1].system, "urn:oid:2.16.840.1.113883.2.4.6.3")
        self.assertEqual(inst.identifier[1].use, "usual")
        self.assertEqual(inst.identifier[1].value, "243HID3RT938")
        self.assertEqual(inst.name.family[0], "Versteegh")
        self.assertEqual(inst.name.given[0], "Marc")
        self.assertEqual(inst.name.suffix[0], "MD")
        self.assertEqual(inst.name.use, "official")
        self.assertEqual(inst.organization.display, "BMC")
        self.assertEqual(inst.organization.reference, "Organization/f001")
        self.assertEqual(inst.role[0].coding[0].code, "01.000")
        self.assertEqual(inst.role[0].coding[0].display, "Arts")
        self.assertEqual(inst.role[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.role[0].text, "Care role")
        self.assertEqual(inst.specialty[0].coding[0].code, "01.011")
        self.assertEqual(inst.specialty[0].coding[0].display, "Cardiothoracal surgery")
        self.assertEqual(inst.specialty[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.specialty[0].text, "specialisation")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "work")
        self.assertEqual(inst.telecom[0].value, "0205562431")
        self.assertEqual(inst.telecom[1].system, "email")
        self.assertEqual(inst.telecom[1].use, "work")
        self.assertEqual(inst.telecom[1].value, "m.versteegh@bmc.nl")
        self.assertEqual(inst.telecom[2].system, "fax")
        self.assertEqual(inst.telecom[2].use, "work")
        self.assertEqual(inst.telecom[2].value, "0205662948")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: 846100293 (official), 243HID3RT938 (usual)\n      </p>\n      <p>\n        <b>name</b>: Marc Versteegh (official)\n      </p>\n      <p>\n        <b>telecom</b>: ph: 0205562431(work), m.versteegh@bmc.nl(work), fax: 0205662948(work)\n      </p>\n      <p>\n        <b>address</b>: Galapagosweg 91 Amsterdam 1105 AZ NLD (work)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.4.642.1.24 M}\">Male</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 1-Jul 1963\n      </p>\n      <p>\n        <b>organization</b>: BMC\n      </p>\n      <p>\n        <b>role</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.000}\">Care role</span>\n      </p>\n      <p>\n        <b>specialty</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.011}\">specialisation</span>\n      </p>\n      <p>\n        <b>communication</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.6.121 nl}\">Dutch</span>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPractitioner4(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/practitioner-example-f004-rb.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
    
        self.assertEqual(inst.address.city, "Amsterdam")
        self.assertEqual(inst.address.country, "NLD")
        self.assertEqual(inst.address.line[0], "Galapagosweg 91")
        self.assertEqual(inst.address.use, "work")
        self.assertEqual(inst.address.zip, "1105 AZ")
        self.assertEqual(inst.birthDate.date, FHIRDate("1980-02-04").date)
        self.assertEqual(inst.birthDate.isostring, "1980-02-04")
        self.assertEqual(inst.communication[0].coding[0].code, "nl")
        self.assertEqual(inst.communication[0].coding[0].display, "Netherlands")
        self.assertEqual(inst.communication[0].coding[0].system, "urn:oid:2.16.840.1.113883.6.121")
        self.assertEqual(inst.communication[0].text, "Language")
        self.assertEqual(inst.gender.coding[0].code, "M")
        self.assertEqual(inst.gender.coding[0].display, "Male")
        self.assertEqual(inst.gender.coding[0].system, "urn:oid:2.16.840.1.113883.4.642.1.24")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.528.1.1007.3.1")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "118265112")
        self.assertEqual(inst.identifier[1].system, "urn:oid:2.16.840.1.113883.2.4.6.3")
        self.assertEqual(inst.identifier[1].use, "usual")
        self.assertEqual(inst.identifier[1].value, "523ASA1LK927")
        self.assertEqual(inst.name.family[0], "Briet")
        self.assertEqual(inst.name.given[0], "Ronald")
        self.assertEqual(inst.name.suffix[0], "MD")
        self.assertEqual(inst.name.use, "official")
        self.assertEqual(inst.organization.display, "BMC")
        self.assertEqual(inst.organization.reference, "Organization/f001")
        self.assertEqual(inst.role[0].coding[0].code, "01.000")
        self.assertEqual(inst.role[0].coding[0].display, "Arts")
        self.assertEqual(inst.role[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.role[0].text, "Care role")
        self.assertEqual(inst.specialty[0].coding[0].code, "01.018")
        self.assertEqual(inst.specialty[0].coding[0].display, "Ear-, Nose and Throat")
        self.assertEqual(inst.specialty[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.specialty[0].text, "specialisation")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "work")
        self.assertEqual(inst.telecom[0].value, "0205569273")
        self.assertEqual(inst.telecom[1].system, "email")
        self.assertEqual(inst.telecom[1].use, "work")
        self.assertEqual(inst.telecom[1].value, "r.briet@bmc.nl")
        self.assertEqual(inst.telecom[2].system, "fax")
        self.assertEqual(inst.telecom[2].use, "work")
        self.assertEqual(inst.telecom[2].value, "0205664440")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: 118265112 (official), 523ASA1LK927 (usual)\n      </p>\n      <p>\n        <b>name</b>: Ronald Briet (official)\n      </p>\n      <p>\n        <b>telecom</b>: ph: 0205569273(work), r.briet@bmc.nl(work), fax: 0205664440(work)\n      </p>\n      <p>\n        <b>address</b>: Galapagosweg 91 Amsterdam 1105 AZ NLD (work)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.4.642.1.24 M}\">Male</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 4-Feb 1980\n      </p>\n      <p>\n        <b>organization</b>: BMC\n      </p>\n      <p>\n        <b>role</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.000}\">Care role</span>\n      </p>\n      <p>\n        <b>specialty</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.018}\">specialisation</span>\n      </p>\n      <p>\n        <b>communication</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.6.121 nl}\">Language</span>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPractitioner5(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/practitioner-example-f005-al.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
    
        self.assertEqual(inst.address.city, "Amsterdam")
        self.assertEqual(inst.address.country, "NLD")
        self.assertEqual(inst.address.line[0], "Galapagosweg 9")
        self.assertEqual(inst.address.use, "work")
        self.assertEqual(inst.address.zip, "1105 AZ")
        self.assertEqual(inst.birthDate.date, FHIRDate("1959-03-11").date)
        self.assertEqual(inst.birthDate.isostring, "1959-03-11")
        self.assertEqual(inst.communication[0].coding[0].code, "fr")
        self.assertEqual(inst.communication[0].coding[0].display, "France")
        self.assertEqual(inst.communication[0].coding[0].system, "urn:oid:2.16.840.1.113883.6.121")
        self.assertEqual(inst.gender.coding[0].code, "F")
        self.assertEqual(inst.gender.coding[0].display, "Female")
        self.assertEqual(inst.gender.coding[0].system, "urn:oid:2.16.840.1.113883.4.642.1.24")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.528.1.1007.3.1")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "118265112")
        self.assertEqual(inst.identifier[1].system, "urn:oid:2.16.840.1.113883.2.4.6.3")
        self.assertEqual(inst.identifier[1].use, "usual")
        self.assertEqual(inst.identifier[1].value, "191REW8WE916")
        self.assertEqual(inst.name.family[0], "Anne")
        self.assertEqual(inst.name.given[0], "Langeveld")
        self.assertEqual(inst.name.suffix[0], "MD")
        self.assertEqual(inst.name.use, "official")
        self.assertEqual(inst.organization.display, "BMC")
        self.assertEqual(inst.organization.reference, "Organization/f001")
        self.assertEqual(inst.role[0].coding[0].code, "01.000")
        self.assertEqual(inst.role[0].coding[0].display, "Arts")
        self.assertEqual(inst.role[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.role[0].text, "Care role")
        self.assertEqual(inst.specialty[0].coding[0].code, "01.018")
        self.assertEqual(inst.specialty[0].coding[0].display, "Keel- neus- en oorarts")
        self.assertEqual(inst.specialty[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.specialty[0].text, "specialisation")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "work")
        self.assertEqual(inst.telecom[0].value, "0205563847")
        self.assertEqual(inst.telecom[1].system, "email")
        self.assertEqual(inst.telecom[1].use, "work")
        self.assertEqual(inst.telecom[1].value, "a.langeveld@bmc.nl")
        self.assertEqual(inst.telecom[2].system, "fax")
        self.assertEqual(inst.telecom[2].use, "work")
        self.assertEqual(inst.telecom[2].value, "0205668916")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: 118265112 (official), 191REW8WE916 (usual)\n      </p>\n      <p>\n        <b>name</b>: Langeveld Anne (official)\n      </p>\n      <p>\n        <b>telecom</b>: ph: 0205563847(work), a.langeveld@bmc.nl(work), fax: 0205668916(work)\n      </p>\n      <p>\n        <b>address</b>: Galapagosweg 9 Amsterdam 1105 AZ NLD (work)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.4.642.1.24 F}\">Female</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 11-Mar 1959\n      </p>\n      <p>\n        <b>organization</b>: BMC\n      </p>\n      <p>\n        <b>role</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.000}\">Care role</span>\n      </p>\n      <p>\n        <b>specialty</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.018}\">specialisation</span>\n      </p>\n      <p>\n        <b>communication</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.6.121 fr}\">France</span>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPractitioner6(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/practitioner-example-f006-rvdb.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
    
        self.assertEqual(inst.address.city, "Den Burg")
        self.assertEqual(inst.address.country, "NLD")
        self.assertEqual(inst.address.line[0], "Galapagosweg 91")
        self.assertEqual(inst.address.use, "work")
        self.assertEqual(inst.address.zip, "9105 PZ")
        self.assertEqual(inst.birthDate.date, FHIRDate("1975-12-07").date)
        self.assertEqual(inst.birthDate.isostring, "1975-12-07")
        self.assertEqual(inst.gender.coding[0].code, "M")
        self.assertEqual(inst.gender.coding[0].display, "Male")
        self.assertEqual(inst.gender.coding[0].system, "http://hl7.org/fhir/v3/AdministrativeGender")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.528.1.1007.3.1")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "937223645")
        self.assertEqual(inst.identifier[1].system, "urn:oid:2.16.840.1.113883.2.4.6.3")
        self.assertEqual(inst.identifier[1].use, "usual")
        self.assertEqual(inst.identifier[1].value, "134IDY41W988")
        self.assertEqual(inst.name.family[0], "van den Berk")
        self.assertEqual(inst.name.given[0], "Rob")
        self.assertEqual(inst.name.suffix[0], "MD")
        self.assertEqual(inst.name.use, "official")
        self.assertEqual(inst.organization.display, "BMC")
        self.assertEqual(inst.organization.reference, "Organization/f001")
        self.assertEqual(inst.role[0].coding[0].code, "01.000")
        self.assertEqual(inst.role[0].coding[0].display, "Arts")
        self.assertEqual(inst.role[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.role[0].text, "Care role")
        self.assertEqual(inst.specialty[0].coding[0].code, "17.000")
        self.assertEqual(inst.specialty[0].coding[0].display, "Pharmacist")
        self.assertEqual(inst.specialty[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.specialty[0].text, "specialisation")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "work")
        self.assertEqual(inst.telecom[0].value, "0205569288")
        self.assertEqual(inst.telecom[1].system, "email")
        self.assertEqual(inst.telecom[1].use, "work")
        self.assertEqual(inst.telecom[1].value, "R.A.vandenberk@bmc.nl")
        self.assertEqual(inst.telecom[2].system, "fax")
        self.assertEqual(inst.telecom[2].use, "work")
        self.assertEqual(inst.telecom[2].value, "0205664987")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: 937223645 (official), 134IDY41W988 (usual)\n      </p>\n      <p>\n        <b>name</b>: Rob van den Berk (official)\n      </p>\n      <p>\n        <b>telecom</b>: ph: 0205569288(work), R.A.vandenberk@bmc.nl(work), fax: 0205664987(work)\n      </p>\n      <p>\n        <b>address</b>: Galapagosweg 91 Den Burg 9105 PZ NLD (work)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/v3/AdministrativeGender M}\">Male</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 7-Dec 1975\n      </p>\n      <p>\n        <b>organization</b>: BMC\n      </p>\n      <p>\n        <b>role</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.000}\">Care role</span>\n      </p>\n      <p>\n        <b>specialty</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 17.000}\">specialisation</span>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPractitioner7(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/practitioner-example-f007-sh.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
    
        self.assertEqual(inst.address.city, "Den Burg")
        self.assertEqual(inst.address.country, "NLD")
        self.assertEqual(inst.address.line[0], "Galapagosweg 91")
        self.assertEqual(inst.address.use, "work")
        self.assertEqual(inst.address.zip, "9105 PZ")
        self.assertEqual(inst.birthDate.date, FHIRDate("1971-11-07").date)
        self.assertEqual(inst.birthDate.isostring, "1971-11-07")
        self.assertEqual(inst.gender.coding[0].code, "F")
        self.assertEqual(inst.gender.coding[0].display, "Female")
        self.assertEqual(inst.gender.coding[0].system, "http://hl7.org/fhir/v3/AdministrativeGender")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.528.1.1007.3.1")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "874635264")
        self.assertEqual(inst.identifier[1].system, "urn:oid:2.16.840.1.113883.2.4.6.3")
        self.assertEqual(inst.identifier[1].use, "usual")
        self.assertEqual(inst.identifier[1].value, "567IUI51C154")
        self.assertEqual(inst.name.family[0], "Heps")
        self.assertEqual(inst.name.given[0], "Simone")
        self.assertEqual(inst.name.suffix[0], "MD")
        self.assertEqual(inst.name.use, "official")
        self.assertEqual(inst.organization.display, "BMC")
        self.assertEqual(inst.organization.reference, "Organization/f001")
        self.assertEqual(inst.role[0].coding[0].code, "01.000")
        self.assertEqual(inst.role[0].coding[0].display, "Arts")
        self.assertEqual(inst.role[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.role[0].text, "Care role")
        self.assertEqual(inst.specialty[0].coding[0].code, "01.015")
        self.assertEqual(inst.specialty[0].coding[0].display, "Physician")
        self.assertEqual(inst.specialty[0].coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.specialty[0].text, "specialisation")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "work")
        self.assertEqual(inst.telecom[0].value, "020556936")
        self.assertEqual(inst.telecom[1].system, "email")
        self.assertEqual(inst.telecom[1].use, "work")
        self.assertEqual(inst.telecom[1].value, "S.M.Heps@bmc.nl")
        self.assertEqual(inst.telecom[2].system, "fax")
        self.assertEqual(inst.telecom[2].use, "work")
        self.assertEqual(inst.telecom[2].value, "0205669283")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: 874635264 (official), 567IUI51C154 (usual)\n      </p>\n      <p>\n        <b>name</b>: Simone Heps (official)\n      </p>\n      <p>\n        <b>telecom</b>: ph: 020556936(work), S.M.Heps@bmc.nl(work), fax: 0205669283(work)\n      </p>\n      <p>\n        <b>address</b>: Galapagosweg 91 Den Burg 9105 PZ NLD (work)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/v3/AdministrativeGender F}\">Female</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 7-Nov 1971\n      </p>\n      <p>\n        <b>organization</b>: BMC\n      </p>\n      <p>\n        <b>role</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.000}\">Care role</span>\n      </p>\n      <p>\n        <b>specialty</b>: \n        <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.015}\">specialisation</span>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPractitioner8(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/practitioner-example-f201-ab.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
    
        self.assertEqual(inst.address.city, "Den helder")
        self.assertEqual(inst.address.country, "NLD")
        self.assertEqual(inst.address.line[0], "Walvisbaai 3")
        self.assertEqual(inst.address.line[1], "C4 - Automatisering")
        self.assertEqual(inst.address.use, "work")
        self.assertEqual(inst.address.zip, "2333ZA")
        self.assertEqual(inst.birthDate.date, FHIRDate("1956-12-24").date)
        self.assertEqual(inst.birthDate.isostring, "1956-12-24")
        self.assertEqual(inst.gender.coding[0].code, "248153007")
        self.assertEqual(inst.gender.coding[0].display, "Male")
        self.assertEqual(inst.gender.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.identifier[0].label, "UZI-nummer")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.528.1.1007.3.1")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "12345678901")
        self.assertEqual(inst.name.family[0], "Bronsig")
        self.assertEqual(inst.name.given[0], "Arend")
        self.assertEqual(inst.name.prefix[0], "Dr.")
        self.assertEqual(inst.name.text, "Dokter Bronsig")
        self.assertEqual(inst.name.use, "official")
        self.assertEqual(inst.organization.display, "AUMC")
        self.assertEqual(inst.organization.reference, "Organization/f201")
        self.assertEqual(inst.qualification[0].code.coding[0].code, "41672002")
        self.assertEqual(inst.qualification[0].code.coding[0].display, "Pulmonologist")
        self.assertEqual(inst.qualification[0].code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.role[0].coding[0].code, "225304007")
        self.assertEqual(inst.role[0].coding[0].display, "Implementation of planned interventions")
        self.assertEqual(inst.role[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.specialty[0].coding[0].code, "310512001")
        self.assertEqual(inst.specialty[0].coding[0].display, "Medical oncologist")
        self.assertEqual(inst.specialty[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "work")
        self.assertEqual(inst.telecom[0].value, "+31715269111")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: UZI-nummer = 12345678901 (official)\n      </p>\n      <p>\n        <b>name</b>: Dokter Bronsig(official)\n      </p>\n      <p>\n        <b>telecom</b>: ph: +31715269111(work)\n      </p>\n      <p>\n        <b>address</b>: Walvisbaai 3 C4 - Automatisering Den helder 2333ZA NLD (work)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {http://snomed.info/sct 248153007}\">Male</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 24-Dec 1956\n      </p>\n      <p>\n        <b>organization</b>: AUMC\n      </p>\n      <p>\n        <b>role</b>: \n        <span title=\"Codes: {http://snomed.info/sct 225304007}\">Implementation of planned interventions</span>\n      </p>\n      <p>\n        <b>specialty</b>: \n        <span title=\"Codes: {http://snomed.info/sct 310512001}\">Medical oncologist</span>\n      </p>\n      <h3>Qualifications</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Code</b>\n          </td>\n          <td>\n            <b>Period</b>\n          </td>\n          <td>\n            <b>Issuer</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 41672002}\">Pulmonologist</span>\n          </td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPractitioner9(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/practitioner-example-f202-lm.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
    
        self.assertEqual(inst.address.city, "Den helder")
        self.assertEqual(inst.address.country, "NLD")
        self.assertEqual(inst.address.line[0], "Walvisbaai 3")
        self.assertEqual(inst.address.line[1], "C4 - Automatisering")
        self.assertEqual(inst.address.use, "work")
        self.assertEqual(inst.address.zip, "2333ZA")
        self.assertEqual(inst.birthDate.date, FHIRDate("1960-06-12").date)
        self.assertEqual(inst.birthDate.isostring, "1960-06-12")
        self.assertEqual(inst.gender.coding[0].code, "248153007")
        self.assertEqual(inst.gender.coding[0].display, "Male")
        self.assertEqual(inst.gender.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.identifier[0].label, "UZI-nummer")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.528.1.1007.3.1")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "12345678902")
        self.assertEqual(inst.identifier[1].label, "BIG-nummer")
        self.assertEqual(inst.identifier[1].system, "https://www.bigregister.nl/")
        self.assertEqual(inst.identifier[1].use, "official")
        self.assertEqual(inst.identifier[1].value, "12345678902")
        self.assertEqual(inst.name.family[0], "Maas")
        self.assertEqual(inst.name.given[0], "Luigi")
        self.assertEqual(inst.name.prefix[0], "Dr.")
        self.assertEqual(inst.name.text, "Luigi Maas")
        self.assertEqual(inst.name.use, "official")
        self.assertEqual(inst.organization.display, "AUMC")
        self.assertEqual(inst.organization.reference, "Organization/f201")
        self.assertEqual(inst.role[0].coding[0].code, "33526004")
        self.assertEqual(inst.role[0].coding[0].display, "Electronic laboratory reporting")
        self.assertEqual(inst.role[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.specialty[0].coding[0].code, "159285000")
        self.assertEqual(inst.specialty[0].coding[0].display, "Medical laboratory technician")
        self.assertEqual(inst.specialty[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "work")
        self.assertEqual(inst.telecom[0].value, "+31715269111")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: UZI-nummer = 12345678902 (official), BIG-nummer = 12345678902 (official)\n      </p>\n      <p>\n        <b>name</b>: Luigi Maas(official)\n      </p>\n      <p>\n        <b>telecom</b>: ph: +31715269111(work)\n      </p>\n      <p>\n        <b>address</b>: Walvisbaai 3 C4 - Automatisering Den helder 2333ZA NLD (work)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {http://snomed.info/sct 248153007}\">Male</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 12-Jun 1960\n      </p>\n      <p>\n        <b>organization</b>: AUMC\n      </p>\n      <p>\n        <b>role</b>: \n        <span title=\"Codes: {http://snomed.info/sct 33526004}\">Electronic laboratory reporting</span>\n      </p>\n      <p>\n        <b>specialty</b>: \n        <span title=\"Codes: {http://snomed.info/sct 159285000}\">Medical laboratory technician</span>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPractitioner10(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/practitioner-example-f203-jvg.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
    
        self.assertEqual(inst.address.city, "Den helder")
        self.assertEqual(inst.address.country, "NLD")
        self.assertEqual(inst.address.line[0], "Walvisbaai 3")
        self.assertEqual(inst.address.use, "work")
        self.assertEqual(inst.address.zip, "2333ZA")
        self.assertEqual(inst.birthDate.date, FHIRDate("1983-04-20").date)
        self.assertEqual(inst.birthDate.isostring, "1983-04-20")
        self.assertEqual(inst.gender.coding[0].code, "248153007")
        self.assertEqual(inst.gender.coding[0].display, "Male")
        self.assertEqual(inst.gender.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.identifier[0].label, "UZI-nummer")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.528.1.1007.3.1")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "12345678903")
        self.assertEqual(inst.identifier[1].label, "BIG-nummer")
        self.assertEqual(inst.identifier[1].system, "https://www.bigregister.nl/")
        self.assertEqual(inst.identifier[1].use, "official")
        self.assertEqual(inst.identifier[1].value, "12345678903")
        self.assertEqual(inst.name.text, "Juri van Gelder")
        self.assertEqual(inst.name.use, "official")
        self.assertEqual(inst.organization.display, "AUMC")
        self.assertEqual(inst.organization.reference, "Organization/f201")
        self.assertEqual(inst.role[0].coding[0].code, "36682004")
        self.assertEqual(inst.role[0].coding[0].display, "Physical therapist")
        self.assertEqual(inst.role[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.specialty[0].coding[0].code, "410158009")
        self.assertEqual(inst.specialty[0].coding[0].display, "Assess physical therapist service")
        self.assertEqual(inst.specialty[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "work")
        self.assertEqual(inst.telecom[0].value, "+31715269111")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: UZI-nummer = 12345678903 (official), BIG-nummer = 12345678903 (official)\n      </p>\n      <p>\n        <b>name</b>: Juri van Gelder(official)\n      </p>\n      <p>\n        <b>telecom</b>: ph: +31715269111(work)\n      </p>\n      <p>\n        <b>address</b>: Walvisbaai 3 Den helder 2333ZA NLD (work)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {http://snomed.info/sct 248153007}\">Male</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 20-Apr 1983\n      </p>\n      <p>\n        <b>organization</b>: AUMC\n      </p>\n      <p>\n        <b>role</b>: \n        <span title=\"Codes: {http://snomed.info/sct 36682004}\">Physical therapist</span>\n      </p>\n      <p>\n        <b>specialty</b>: \n        <span title=\"Codes: {http://snomed.info/sct 410158009}\">Assess physical therapist service</span>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPractitioner11(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/practitioner-example-f204-ce.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
    
        self.assertEqual(inst.address.city, "Den helder")
        self.assertEqual(inst.address.country, "NLD")
        self.assertEqual(inst.address.line[0], "Walvisbaai 3")
        self.assertEqual(inst.address.use, "work")
        self.assertEqual(inst.address.zip, "2333ZA")
        self.assertEqual(inst.birthDate.date, FHIRDate("1967-11-05").date)
        self.assertEqual(inst.birthDate.isostring, "1967-11-05")
        self.assertEqual(inst.gender.coding[0].code, "248152002")
        self.assertEqual(inst.gender.coding[0].display, "Female")
        self.assertEqual(inst.gender.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.identifier[0].label, "UZI-nummer")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.528.1.1007.3.1")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "12345678904")
        self.assertEqual(inst.name.text, "Carla Espinosa")
        self.assertEqual(inst.name.use, "usual")
        self.assertEqual(inst.organization.display, "AUMC")
        self.assertEqual(inst.organization.reference, "Organization/f201")
        self.assertEqual(inst.role[0].coding[0].code, "224565004")
        self.assertEqual(inst.role[0].coding[0].display, "Renal nurse")
        self.assertEqual(inst.role[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.specialty[0].coding[0].code, "9632001")
        self.assertEqual(inst.specialty[0].coding[0].display, "Nursing procedure")
        self.assertEqual(inst.specialty[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "work")
        self.assertEqual(inst.telecom[0].value, "+31715262169")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: UZI-nummer = 12345678904 (official)\n      </p>\n      <p>\n        <b>name</b>: Carla Espinosa\n      </p>\n      <p>\n        <b>telecom</b>: ph: +31715262169(work)\n      </p>\n      <p>\n        <b>address</b>: Walvisbaai 3 Den helder 2333ZA NLD (work)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {http://snomed.info/sct 248152002}\">Female</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 5-Nov 1967\n      </p>\n      <p>\n        <b>organization</b>: AUMC\n      </p>\n      <p>\n        <b>role</b>: \n        <span title=\"Codes: {http://snomed.info/sct 224565004}\">Renal nurse</span>\n      </p>\n      <p>\n        <b>specialty</b>: \n        <span title=\"Codes: {http://snomed.info/sct 9632001}\">Nursing procedure</span>\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPractitioner12(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/practitioner-example-xcda-author.json")
        self.assertIsNotNone(inst, "Must have instantiated a Practitioner instance")
    
        self.assertEqual(inst.name.family[0], "Dolin")
        self.assertEqual(inst.name.given[0], "Bob")
        self.assertEqual(inst.name.suffix[0], "MD")
        self.assertEqual(inst.text.div, "<div>\n      <p>Bob Dolin, MD</p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")

