#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 0.0.82.2943 (xds-profile.profile.json) on 2014-10-31.
#  2014, SMART Platforms.


import io
import unittest
import json
from careplan import CarePlan
from fhirdate import FHIRDate


class CarePlanTests(unittest.TestCase):
    def instantiate_from(self, filename):
        with io.open(filename, 'r', encoding='utf-8') as handle:
            js = json.load(handle)
        instance = CarePlan(js)
        self.assertIsNotNone(instance, "Must have instantiated a test instance")
        return instance
    
    def testCarePlan1(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/careplan-example-f001-heart.json")
        self.assertIsNotNone(inst, "Must have instantiated a CarePlan instance")
    
        self.assertTrue(inst.activity[0].prohibited)
        self.assertEqual(inst.activity[0].simple.category, "procedure")
        self.assertEqual(inst.activity[0].simple.code.coding[0].code, "64915003")
        self.assertEqual(inst.activity[0].simple.code.coding[0].display, "Operation on heart")
        self.assertEqual(inst.activity[0].simple.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.activity[0].simple.performer[0].display, "P. Voigt")
        self.assertEqual(inst.activity[0].simple.performer[0].reference, "Practitioner/f002")
        self.assertEqual(inst.activity[0].simple.timingString, "2011-06-27T09:30:10+01:00")
        self.assertEqual(inst.activity[0].status, "completed")
        self.assertEqual(inst.concern[0].display, "?????")
        self.assertEqual(inst.concern[0].reference, "Condition/f201")
        self.assertEqual(inst.goal[0].description, "recovery surgery on heart of patient")
        self.assertEqual(inst.goal[0].notes, "goal accomplished without complications")
        self.assertEqual(inst.goal[0].status, "achieved")
        self.assertEqual(inst.identifier[0].system, "http://www.bmc.nl/zorgportal/identifiers/careplans")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "CP2903")
        self.assertEqual(inst.modified.date, FHIRDate("2011-06-27T09:30:10+01:00").date)
        self.assertEqual(inst.modified.isostring, "2011-06-27T09:30:10+01:00")
        self.assertEqual(inst.participant[0].member.display, "P. Voigt")
        self.assertEqual(inst.participant[0].member.reference, "Practitioner/f002")
        self.assertEqual(inst.patient.display, "P. van de Heuvel")
        self.assertEqual(inst.patient.reference, "Patient/f001")
        self.assertEqual(inst.period.end.date, FHIRDate("2011-06-27").date)
        self.assertEqual(inst.period.end.isostring, "2011-06-27")
        self.assertEqual(inst.period.start.date, FHIRDate("2011-06-26").date)
        self.assertEqual(inst.period.start.isostring, "2011-06-26")
        self.assertEqual(inst.status, "completed")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: CP2903 (official)\n      </p>\n      <p>\n        <b>patient</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>status</b>: completed\n      </p>\n      <p>\n        <b>period</b>: 26-Jun 2011 --&gt; 27-Jun 2011\n      </p>\n      <p>\n        <b>modified</b>: 27-Jun 2011 9:30\n      </p>\n      <p>\n        <b>concern</b>: ?????\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>P. Voigt</td>\n        </tr>\n      </table>\n      <h3>Goals</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Description</b>\n          </td>\n          <td>\n            <b>Status</b>\n          </td>\n          <td>\n            <b>Notes</b>\n          </td>\n          <td>\n            <b>Concern</b>\n          </td>\n        </tr>\n        <tr>\n          <td>recovery surgery on heart of patient</td>\n          <td>achieved</td>\n          <td>goal accomplished without complications</td>\n          <td> </td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <p>\n          <b>status</b>: completed\n        </p>\n        <p>\n          <b>prohibited</b>: true\n        </p>\n        <h3>Simples</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Timing[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Details</b>\n            </td>\n          </tr>\n          <tr>\n            <td>procedure</td>\n            <td>\n              <span title=\"Codes: {http://snomed.info/sct 64915003}\">Operation on heart</span>\n            </td>\n            <td>2011-06-27T09:30:10+01:00</td>\n            <td> </td>\n            <td>P. Voigt</td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCarePlan2(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/careplan-example-f002-lung.json")
        self.assertIsNotNone(inst, "Must have instantiated a CarePlan instance")
    
        self.assertTrue(inst.activity[0].prohibited)
        self.assertEqual(inst.activity[0].simple.category, "procedure")
        self.assertEqual(inst.activity[0].simple.code.coding[0].code, "359615001")
        self.assertEqual(inst.activity[0].simple.code.coding[0].display, "Partial lobectomy of lung")
        self.assertEqual(inst.activity[0].simple.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.activity[0].simple.performer[0].display, "M.I.M. Versteegh")
        self.assertEqual(inst.activity[0].simple.performer[0].reference, "Practitioner/f003")
        self.assertEqual(inst.activity[0].simple.timingString, "2011-07-07T09:30:10+01:00")
        self.assertEqual(inst.activity[0].status, "completed")
        self.assertEqual(inst.concern[0].display, "?????")
        self.assertEqual(inst.concern[0].reference, "Condition/f201")
        self.assertEqual(inst.goal[0].description, "succesful surgery on lung of patient")
        self.assertEqual(inst.goal[0].notes, "goal accomplished with minor complications")
        self.assertEqual(inst.goal[0].status, "achieved")
        self.assertEqual(inst.identifier[0].system, "http://www.bmc.nl/zorgportal/identifiers/careplans")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "CP2934")
        self.assertEqual(inst.modified.date, FHIRDate("2011-07-07T09:30:10+01:00").date)
        self.assertEqual(inst.modified.isostring, "2011-07-07T09:30:10+01:00")
        self.assertEqual(inst.participant[0].member.display, "M.I.M. Versteegh")
        self.assertEqual(inst.participant[0].member.reference, "Practitioner/f003")
        self.assertEqual(inst.patient.display, "P. van de Heuvel")
        self.assertEqual(inst.patient.reference, "Patient/f001")
        self.assertEqual(inst.period.end.date, FHIRDate("2013-07-07").date)
        self.assertEqual(inst.period.end.isostring, "2013-07-07")
        self.assertEqual(inst.period.start.date, FHIRDate("2011-07-06").date)
        self.assertEqual(inst.period.start.isostring, "2011-07-06")
        self.assertEqual(inst.status, "completed")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: CP2934 (official)\n      </p>\n      <p>\n        <b>patient</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>status</b>: completed\n      </p>\n      <p>\n        <b>period</b>: 6-Jul 2011 --&gt; 7-Jul 2013\n      </p>\n      <p>\n        <b>modified</b>: 7-Jul 2011 9:30\n      </p>\n      <p>\n        <b>concern</b>: ?????\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>M.I.M. Versteegh</td>\n        </tr>\n      </table>\n      <h3>Goals</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Description</b>\n          </td>\n          <td>\n            <b>Status</b>\n          </td>\n          <td>\n            <b>Notes</b>\n          </td>\n          <td>\n            <b>Concern</b>\n          </td>\n        </tr>\n        <tr>\n          <td>succesful surgery on lung of patient</td>\n          <td>achieved</td>\n          <td>goal accomplished with minor complications</td>\n          <td> </td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <p>\n          <b>status</b>: completed\n        </p>\n        <p>\n          <b>prohibited</b>: true\n        </p>\n        <h3>Simples</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Timing[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Details</b>\n            </td>\n          </tr>\n          <tr>\n            <td>procedure</td>\n            <td>\n              <span title=\"Codes: {http://snomed.info/sct 359615001}\">Partial lobectomy of lung</span>\n            </td>\n            <td>2011-07-07T09:30:10+01:00</td>\n            <td> </td>\n            <td>M.I.M. Versteegh</td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCarePlan3(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/careplan-example-f003-pharynx.json")
        self.assertIsNotNone(inst, "Must have instantiated a CarePlan instance")
    
        self.assertTrue(inst.activity[0].prohibited)
        self.assertEqual(inst.activity[0].simple.category, "procedure")
        self.assertEqual(inst.activity[0].simple.code.coding[0].code, "172960003")
        self.assertEqual(inst.activity[0].simple.code.coding[0].display, "Incision of retropharyngeal abscess")
        self.assertEqual(inst.activity[0].simple.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.activity[0].simple.performer[0].display, "E.M. van den broek")
        self.assertEqual(inst.activity[0].simple.performer[0].reference, "Practitioner/f001")
        self.assertEqual(inst.activity[0].simple.timingString, "2011-06-27T09:30:10+01:00")
        self.assertEqual(inst.activity[0].status, "completed")
        self.assertEqual(inst.concern[0].display, "?????")
        self.assertEqual(inst.concern[0].reference, "Condition/f201")
        self.assertEqual(inst.goal[0].description, "Retropharyngeal abscess removal")
        self.assertEqual(inst.goal[0].notes, "goal accomplished without complications")
        self.assertEqual(inst.goal[0].status, "achieved")
        self.assertEqual(inst.identifier[0].system, "http://www.bmc.nl/zorgportal/identifiers/careplans")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "CP3953")
        self.assertEqual(inst.modified.date, FHIRDate("2013-06-27T09:30:10+01:00").date)
        self.assertEqual(inst.modified.isostring, "2013-06-27T09:30:10+01:00")
        self.assertEqual(inst.participant[0].member.display, "E.M. van den broek")
        self.assertEqual(inst.participant[0].member.reference, "Practitioner/f001")
        self.assertEqual(inst.patient.display, "P. van de Heuvel")
        self.assertEqual(inst.patient.reference, "Patient/f001")
        self.assertEqual(inst.period.end.date, FHIRDate("2013-03-08T09:30:10+01:00").date)
        self.assertEqual(inst.period.end.isostring, "2013-03-08T09:30:10+01:00")
        self.assertEqual(inst.period.start.date, FHIRDate("2013-03-08T09:00:10+01:00").date)
        self.assertEqual(inst.period.start.isostring, "2013-03-08T09:00:10+01:00")
        self.assertEqual(inst.status, "completed")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: CP3953 (official)\n      </p>\n      <p>\n        <b>patient</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>status</b>: completed\n      </p>\n      <p>\n        <b>period</b>: 8-Mar 2013 9:0 --&gt; 8-Mar 2013 9:30\n      </p>\n      <p>\n        <b>modified</b>: 27-Jun 2013 9:30\n      </p>\n      <p>\n        <b>concern</b>: ?????\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>E.M. van den broek</td>\n        </tr>\n      </table>\n      <h3>Goals</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Description</b>\n          </td>\n          <td>\n            <b>Status</b>\n          </td>\n          <td>\n            <b>Notes</b>\n          </td>\n          <td>\n            <b>Concern</b>\n          </td>\n        </tr>\n        <tr>\n          <td>Retropharyngeal abscess removal</td>\n          <td>achieved</td>\n          <td>goal accomplished without complications</td>\n          <td> </td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <p>\n          <b>status</b>: completed\n        </p>\n        <p>\n          <b>prohibited</b>: true\n        </p>\n        <h3>Simples</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Timing[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Details</b>\n            </td>\n          </tr>\n          <tr>\n            <td>procedure</td>\n            <td>\n              <span title=\"Codes: {http://snomed.info/sct 172960003}\">Incision of retropharyngeal abscess</span>\n            </td>\n            <td>2011-06-27T09:30:10+01:00</td>\n            <td> </td>\n            <td>E.M. van den broek</td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCarePlan4(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/careplan-example-f201-renal.json")
        self.assertIsNotNone(inst, "Must have instantiated a CarePlan instance")
    
        self.assertFalse(inst.activity[0].prohibited)
        self.assertEqual(inst.activity[0].simple.category, "diet")
        self.assertEqual(inst.activity[0].simple.code.coding[0].code, "284093001")
        self.assertEqual(inst.activity[0].simple.code.coding[0].display, "Potassium supplementation")
        self.assertEqual(inst.activity[0].simple.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.activity[0].simple.dailyAmount.code, "258718000")
        self.assertEqual(inst.activity[0].simple.dailyAmount.system, "http://snomed.info/sct")
        self.assertEqual(inst.activity[0].simple.dailyAmount.units, "mmol")
        self.assertEqual(inst.activity[0].simple.dailyAmount.value, 80)
        self.assertEqual(inst.activity[0].simple.product.display, "Potassium")
        self.assertEqual(inst.activity[0].simple.product.reference, "Substance/f203")
        self.assertEqual(inst.activity[0].simple.timingString, "daily")
        self.assertEqual(inst.activity[0].status, "completed")
        self.assertFalse(inst.activity[1].prohibited)
        self.assertEqual(inst.activity[1].simple.category, "observation")
        self.assertEqual(inst.activity[1].simple.code.coding[0].code, "306005")
        self.assertEqual(inst.activity[1].simple.code.coding[0].display, "Echography of kidney")
        self.assertEqual(inst.activity[1].simple.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.activity[1].status, "completed")
        self.assertEqual(inst.concern[0].display, "Roel's renal insufficiency")
        self.assertEqual(inst.concern[0].reference, "Condition/f204")
        self.assertEqual(inst.goal[0].description, "Re-established renal function with at least healthy nutrients.")
        self.assertEqual(inst.goal[0].status, "achieved")
        self.assertEqual(inst.modified.date, FHIRDate("2013-03-11").date)
        self.assertEqual(inst.modified.isostring, "2013-03-11")
        self.assertEqual(inst.participant[0].member.display, "Dokter Bronsig")
        self.assertEqual(inst.participant[0].member.reference, "Practitioner/f201")
        self.assertEqual(inst.participant[0].role.coding[0].code, "425268008")
        self.assertEqual(inst.participant[0].role.coding[0].display, "Review of care plan")
        self.assertEqual(inst.participant[0].role.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.participant[1].member.display, "Nurse Carla Espinosa")
        self.assertEqual(inst.participant[1].member.reference, "Practitioner/f204")
        self.assertEqual(inst.participant[1].role.coding[0].code, "229774002")
        self.assertEqual(inst.participant[1].role.coding[0].display, "Carer")
        self.assertEqual(inst.participant[1].role.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.patient.display, "Roel")
        self.assertEqual(inst.patient.reference, "Patient/f201")
        self.assertEqual(inst.period.end.date, FHIRDate("2013-03-13").date)
        self.assertEqual(inst.period.end.isostring, "2013-03-13")
        self.assertEqual(inst.period.start.date, FHIRDate("2013-03-11").date)
        self.assertEqual(inst.period.start.isostring, "2013-03-11")
        self.assertEqual(inst.status, "planned")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>patient</b>: Roel\n      </p>\n      <p>\n        <b>status</b>: planned\n      </p>\n      <p>\n        <b>period</b>: 11-Mar 2013 --&gt; 13-Mar 2013\n      </p>\n      <p>\n        <b>modified</b>: 11-Mar 2013\n      </p>\n      <p>\n        <b>concern</b>: Roel's renal insufficiency\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 425268008}\">Review of care plan</span>\n          </td>\n          <td>Dokter Bronsig</td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 229774002}\">Carer</span>\n          </td>\n          <td>Nurse Carla Espinosa</td>\n        </tr>\n      </table>\n      <h3>Goals</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Description</b>\n          </td>\n          <td>\n            <b>Status</b>\n          </td>\n          <td>\n            <b>Notes</b>\n          </td>\n          <td>\n            <b>Concern</b>\n          </td>\n        </tr>\n        <tr>\n          <td>Re-established renal function with at least healthy nutrients.</td>\n          <td>achieved</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <p>\n          <b>status</b>: completed\n        </p>\n        <p>\n          <b>prohibited</b>: false\n        </p>\n        <h3>Simples</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Timing[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Details</b>\n            </td>\n          </tr>\n          <tr>\n            <td>diet</td>\n            <td>\n              <span title=\"Codes: {http://snomed.info/sct 284093001}\">Potassium supplementation</span>\n            </td>\n            <td>daily</td>\n            <td> </td>\n            <td> </td>\n            <td>Potassium</td>\n            <td>80 mmol</td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <p>\n          <b>status</b>: completed\n        </p>\n        <p>\n          <b>prohibited</b>: false\n        </p>\n        <h3>Simples</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Timing[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Details</b>\n            </td>\n          </tr>\n          <tr>\n            <td>observation</td>\n            <td>\n              <span title=\"Codes: {http://snomed.info/sct 306005}\">Echography of kidney</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCarePlan5(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/careplan-example-f202-malignancy.json")
        self.assertIsNotNone(inst, "Must have instantiated a CarePlan instance")
    
        self.assertEqual(inst.activity[0].actionResulting[0].display, "Roel's Chemotherapy")
        self.assertEqual(inst.activity[0].actionResulting[0].reference, "Procedure/f201")
        self.assertFalse(inst.activity[0].prohibited)
        self.assertEqual(inst.activity[0].simple.category, "procedure")
        self.assertEqual(inst.activity[0].simple.code.coding[0].code, "367336001")
        self.assertEqual(inst.activity[0].simple.code.coding[0].display, "Chemotherapy")
        self.assertEqual(inst.activity[0].simple.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.activity[0].simple.product.reference, "#tpf")
        self.assertEqual(inst.activity[0].status, "in progress")
        self.assertEqual(inst.concern[0].display, "Roel's head-neck tumor")
        self.assertEqual(inst.concern[0].reference, "Condition/f202")
        self.assertEqual(inst.goal[0].description, "Elimination of the spenoid bone tumor")
        self.assertEqual(inst.goal[0].status, "in progress")
        self.assertEqual(inst.participant[0].member.display, "Dokter Bronsig")
        self.assertEqual(inst.participant[0].member.reference, "Practitioner/f201")
        self.assertEqual(inst.participant[0].role.coding[0].code, "28995006")
        self.assertEqual(inst.participant[0].role.coding[0].display, "Treated with")
        self.assertEqual(inst.participant[0].role.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.patient.display, "Roel")
        self.assertEqual(inst.patient.reference, "Patient/f201")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>patient</b>: Roel\n      </p>\n      <p>\n        <b>status</b>: active\n      </p>\n      <p>\n        <b>concern</b>: Roel's head-neck tumor\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 28995006}\">Treated with</span>\n          </td>\n          <td>Dokter Bronsig</td>\n        </tr>\n      </table>\n      <h3>Goals</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Description</b>\n          </td>\n          <td>\n            <b>Status</b>\n          </td>\n          <td>\n            <b>Notes</b>\n          </td>\n          <td>\n            <b>Concern</b>\n          </td>\n        </tr>\n        <tr>\n          <td>Elimination of the spenoid bone tumor</td>\n          <td>inProgress</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <p>\n          <b>status</b>: inProgress\n        </p>\n        <p>\n          <b>prohibited</b>: false\n        </p>\n        <p>\n          <b>actionResulting</b>: Roel's Chemotherapy\n        </p>\n        <h3>Simples</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Timing[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Details</b>\n            </td>\n          </tr>\n          <tr>\n            <td>procedure</td>\n            <td>\n              <span title=\"Codes: {http://snomed.info/sct 367336001}\">Chemotherapy</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td>name: TPF</td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCarePlan6(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/careplan-example-f203-sepsis.json")
        self.assertIsNotNone(inst, "Must have instantiated a CarePlan instance")
    
        self.assertFalse(inst.activity[0].prohibited)
        self.assertEqual(inst.activity[0].simple.category, "observation")
        self.assertEqual(inst.activity[0].simple.code.coding[0].code, "241541005")
        self.assertEqual(inst.activity[0].simple.code.coding[0].display, "High resolution computed tomography of lungs")
        self.assertEqual(inst.activity[0].simple.code.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.activity[0].status, "not started")
        self.assertEqual(inst.concern[0].display, "Roel's sepsis")
        self.assertEqual(inst.concern[0].reference, "Condition/f203")
        self.assertEqual(inst.goal[0].description, "Check whether further treatment of sepsis/pulmonary abcess is required")
        self.assertEqual(inst.goal[0].status, "cancelled")
        self.assertEqual(inst.modified.date, FHIRDate("2013-03-11").date)
        self.assertEqual(inst.modified.isostring, "2013-03-11")
        self.assertEqual(inst.participant[0].member.display, "Dokter Bronsig")
        self.assertEqual(inst.participant[0].member.reference, "Practitioner/f201")
        self.assertEqual(inst.participant[0].role.coding[0].code, "425268008")
        self.assertEqual(inst.participant[0].role.coding[0].display, "Review of care plan")
        self.assertEqual(inst.participant[0].role.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.participant[1].member.display, "Luigi Maas")
        self.assertEqual(inst.participant[1].member.reference, "Practitioner/f202")
        self.assertEqual(inst.participant[1].role.coding[0].code, "278110001")
        self.assertEqual(inst.participant[1].role.coding[0].display, "Radiographic imaging")
        self.assertEqual(inst.participant[1].role.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.patient.display, "Roel")
        self.assertEqual(inst.patient.reference, "Patient/f201")
        self.assertEqual(inst.period.end.date, FHIRDate("2013-04-21").date)
        self.assertEqual(inst.period.end.isostring, "2013-04-21")
        self.assertEqual(inst.period.start.date, FHIRDate("2013-04-14").date)
        self.assertEqual(inst.period.start.isostring, "2013-04-14")
        self.assertEqual(inst.status, "completed")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>patient</b>: Roel\n      </p>\n      <p>\n        <b>status</b>: completed\n      </p>\n      <p>\n        <b>period</b>: 14-Apr 2013 --&gt; 21-Apr 2013\n      </p>\n      <p>\n        <b>modified</b>: 11-Mar 2013\n      </p>\n      <p>\n        <b>concern</b>: Roel's sepsis\n      </p>\n      <h3>Participants</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Role</b>\n          </td>\n          <td>\n            <b>Member</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 425268008}\">Review of care plan</span>\n          </td>\n          <td>Dokter Bronsig</td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 278110001}\">Radiographic imaging</span>\n          </td>\n          <td>Luigi Maas</td>\n        </tr>\n      </table>\n      <h3>Goals</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Description</b>\n          </td>\n          <td>\n            <b>Status</b>\n          </td>\n          <td>\n            <b>Notes</b>\n          </td>\n          <td>\n            <b>Concern</b>\n          </td>\n        </tr>\n        <tr>\n          <td>Check whether further treatment of sepsis/pulmonary abcess is required</td>\n          <td>cancelled</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <blockquote>\n        <p>\n          <b>activity</b>\n        </p>\n        <p>\n          <b>status</b>: notStarted\n        </p>\n        <p>\n          <b>prohibited</b>: false\n        </p>\n        <h3>Simples</h3>\n        <table class=\"grid\">\n          <tr>\n            <td>\n              <b>Category</b>\n            </td>\n            <td>\n              <b>Code</b>\n            </td>\n            <td>\n              <b>Timing[x]</b>\n            </td>\n            <td>\n              <b>Location</b>\n            </td>\n            <td>\n              <b>Performer</b>\n            </td>\n            <td>\n              <b>Product</b>\n            </td>\n            <td>\n              <b>DailyAmount</b>\n            </td>\n            <td>\n              <b>Quantity</b>\n            </td>\n            <td>\n              <b>Details</b>\n            </td>\n          </tr>\n          <tr>\n            <td>observation</td>\n            <td>\n              <span title=\"Codes: {http://snomed.info/sct 241541005}\">High resolution computed tomography of lungs</span>\n            </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n            <td> </td>\n          </tr>\n        </table>\n      </blockquote>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCarePlan7(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/careplan-example-GPVisit.json")
        self.assertIsNotNone(inst, "Must have instantiated a CarePlan instance")
    
        self.assertEqual(inst.activity[0].actionResulting[0].reference, "Encounter/example")
        self.assertFalse(inst.activity[0].prohibited)
        self.assertEqual(inst.activity[0].simple.category, "encounter")
        self.assertEqual(inst.activity[0].simple.code.coding[0].code, "nursecon")
        self.assertEqual(inst.activity[0].simple.code.coding[0].system, "local")
        self.assertEqual(inst.activity[0].simple.code.text, "Nurse Consultation")
        self.assertEqual(inst.activity[0].simple.performer[0].display, "Nurse Nancy")
        self.assertEqual(inst.activity[0].simple.performer[0].reference, "Practitioner/13")
        self.assertEqual(inst.activity[0].simple.timingPeriod.end.date, FHIRDate("2013-01-01T10:50:00-00:00").date)
        self.assertEqual(inst.activity[0].simple.timingPeriod.end.isostring, "2013-01-01T10:50:00-00:00")
        self.assertEqual(inst.activity[0].simple.timingPeriod.start.date, FHIRDate("2013-01-01T10:38:00-00:00").date)
        self.assertEqual(inst.activity[0].simple.timingPeriod.start.isostring, "2013-01-01T10:38:00-00:00")
        self.assertEqual(inst.activity[0].status, "completed")
        self.assertFalse(inst.activity[1].prohibited)
        self.assertEqual(inst.activity[1].simple.category, "encounter")
        self.assertEqual(inst.activity[1].simple.code.coding[0].code, "doccon")
        self.assertEqual(inst.activity[1].simple.code.coding[0].system, "local")
        self.assertEqual(inst.activity[1].simple.code.text, "Doctor Consultation")
        self.assertEqual(inst.activity[1].simple.performer[0].display, "Doctor Dave")
        self.assertEqual(inst.activity[1].simple.performer[0].reference, "Practitioner/14")
        self.assertEqual(inst.activity[1].status, "scheduled")
        self.assertEqual(inst.concern[0].display, "obesity")
        self.assertEqual(inst.concern[0].reference, "#p1")
        self.assertEqual(inst.goal[0].description, "Complete consultation")
        self.assertEqual(inst.participant[0].member.display, "Nurse Nancy")
        self.assertEqual(inst.participant[0].member.reference, "Practitioner/13")
        self.assertEqual(inst.participant[0].role.coding[0].code, "nur")
        self.assertEqual(inst.participant[0].role.coding[0].system, "local")
        self.assertEqual(inst.participant[0].role.text, "nurse")
        self.assertEqual(inst.participant[1].member.display, "Doctor Dave")
        self.assertEqual(inst.participant[1].member.reference, "Practitioner/14")
        self.assertEqual(inst.participant[1].role.coding[0].code, "doc")
        self.assertEqual(inst.participant[1].role.coding[0].system, "local")
        self.assertEqual(inst.participant[1].role.text, "doctor")
        self.assertEqual(inst.patient.display, "Peter James Chalmers")
        self.assertEqual(inst.patient.reference, "Patient/100")
        self.assertEqual(inst.period.start.date, FHIRDate("2013-01-01T10:30:00-00:00").date)
        self.assertEqual(inst.period.start.isostring, "2013-01-01T10:30:00-00:00")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div>\n          <p>  Represents the flow of a patient within a practice. The plan is created when\n        they arrive and represents the 'care' of the patient over the course of that encounter.\n        They first see the nurse for basic observations (BP, pulse, temp) then the doctor for\n        the consultation and finally the nurse again for a tetanus immunization. As the plan is\n        updated (e.g. a new activity added), different versions of the plan exist, and workflow timings\n        for reporting can be gained by examining the plan history. This example is the version after\n        seeing the doctor, and waiting for the nurse.The plan can either be created 'ad hoc' and modified as\n        the parient progresses, or start with a standard template (which can, of course, be altered to suit the patient.</p>\n        </div>")
        self.assertEqual(inst.text.status, "additional")
    
    def testCarePlan8(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/careplan-example-integrated.json")
        self.assertIsNotNone(inst, "Must have instantiated a CarePlan instance")
    
        self.assertEqual(inst.activity[0].notes, "9/10/12 Eve eats one meal a day with her parents")
        self.assertFalse(inst.activity[0].prohibited)
        self.assertEqual(inst.activity[0].simple.category, "other")
        self.assertEqual(inst.activity[0].simple.details, "Eve will review photos of high and low density foods and share with her parents")
        self.assertEqual(inst.activity[0].simple.timingPeriod.start.date, FHIRDate("2012-09-10").date)
        self.assertEqual(inst.activity[0].simple.timingPeriod.start.isostring, "2012-09-10")
        self.assertEqual(inst.activity[0].status, "not started")
        self.assertEqual(inst.activity[10].notes, "7/16/12 Eve now has some of her medications set up in pill packs by her pharmacist")
        self.assertFalse(inst.activity[10].prohibited)
        self.assertEqual(inst.activity[10].simple.category, "other")
        self.assertEqual(inst.activity[10].simple.details, "Eve will get a medication box to sort her pills.  She will have one for scheduled medications and one for as needed")
        self.assertEqual(inst.activity[10].simple.timingPeriod.start.date, FHIRDate("2012-07-10").date)
        self.assertEqual(inst.activity[10].simple.timingPeriod.start.isostring, "2012-07-10")
        self.assertEqual(inst.activity[10].status, "completed")
        self.assertEqual(inst.activity[11].notes, "7/30/12 Eve will be able to resume exercise on 7/30/12.  8/13/12 -hold until \"less busy\"")
        self.assertFalse(inst.activity[11].prohibited)
        self.assertEqual(inst.activity[11].simple.category, "other")
        self.assertEqual(inst.activity[11].simple.details, "Eve will open \"The Firm\" DVD workout package and listen to it")
        self.assertEqual(inst.activity[11].simple.timingPeriod.start.date, FHIRDate("2012-07-23").date)
        self.assertEqual(inst.activity[11].simple.timingPeriod.start.isostring, "2012-07-23")
        self.assertEqual(inst.activity[11].status, "cancelled")
        self.assertEqual(inst.activity[1].notes, "9/10/12 Eve will sleep in her bed more often than the couch")
        self.assertFalse(inst.activity[1].prohibited)
        self.assertEqual(inst.activity[1].simple.category, "other")
        self.assertEqual(inst.activity[1].simple.details, "Eve will ask her dad to asist her to put the head of her bed on blocks")
        self.assertEqual(inst.activity[1].simple.timingPeriod.start.date, FHIRDate("2012-09-10").date)
        self.assertEqual(inst.activity[1].simple.timingPeriod.start.isostring, "2012-09-10")
        self.assertEqual(inst.activity[1].status, "not started")
        self.assertFalse(inst.activity[2].prohibited)
        self.assertEqual(inst.activity[2].simple.category, "other")
        self.assertEqual(inst.activity[2].simple.details, "Eve will reduce her intake of coffee and chocolate")
        self.assertEqual(inst.activity[2].simple.timingPeriod.start.date, FHIRDate("2012-09-10").date)
        self.assertEqual(inst.activity[2].simple.timingPeriod.start.isostring, "2012-09-10")
        self.assertEqual(inst.activity[2].status, "in progress")
        self.assertEqual(inst.activity[3].notes, "8/27/12 Eve would like to try for 5 days a week.  9/10/12 Eve is still walking the dogs.")
        self.assertFalse(inst.activity[3].prohibited)
        self.assertEqual(inst.activity[3].simple.category, "other")
        self.assertEqual(inst.activity[3].simple.details, "Eve will walk her friend's dog up and down a big hill 15-30 minutes 3 days a week")
        self.assertEqual(inst.activity[3].simple.timingPeriod.start.date, FHIRDate("2012-08-27").date)
        self.assertEqual(inst.activity[3].simple.timingPeriod.start.isostring, "2012-08-27")
        self.assertEqual(inst.activity[3].status, "in progress")
        self.assertEqual(inst.activity[4].notes, "8/13/12 Eve walked 4 times the last week.  9/10/12 Eve did not walk to her parents the last week, but has plans to start again")
        self.assertFalse(inst.activity[4].prohibited)
        self.assertEqual(inst.activity[4].simple.category, "other")
        self.assertEqual(inst.activity[4].simple.details, "Eve will walk 3 blocks to her parents house twice a week")
        self.assertEqual(inst.activity[4].simple.timingPeriod.start.date, FHIRDate("2012-07-23").date)
        self.assertEqual(inst.activity[4].simple.timingPeriod.start.isostring, "2012-07-23")
        self.assertEqual(inst.activity[4].status, "in progress")
        self.assertFalse(inst.activity[5].prohibited)
        self.assertEqual(inst.activity[5].simple.category, "other")
        self.assertEqual(inst.activity[5].simple.details, "Eve will us a calendar to check off after medications are taken")
        self.assertEqual(inst.activity[5].simple.timingPeriod.start.date, FHIRDate("2012-07-23").date)
        self.assertEqual(inst.activity[5].simple.timingPeriod.start.isostring, "2012-07-23")
        self.assertEqual(inst.activity[5].status, "in progress")
        self.assertEqual(inst.activity[6].notes, "8/13/12 After restarting the vinegar soaks the psoriasis is improved and Eve plans to treat the remainder with light treatments.  She plans to start this week.  8/27/12 Since her skin is improved Eve has not been using the light treatment as often, maybe once a week.  She would like to increase to 3 times a week again")
        self.assertFalse(inst.activity[6].prohibited)
        self.assertEqual(inst.activity[6].simple.category, "other")
        self.assertEqual(inst.activity[6].simple.details, "Eve will use her lights MWF after her shower for 3 minutes")
        self.assertEqual(inst.activity[6].simple.timingPeriod.start.date, FHIRDate("2012-07-23").date)
        self.assertEqual(inst.activity[6].simple.timingPeriod.start.isostring, "2012-07-23")
        self.assertEqual(inst.activity[6].status, "in progress")
        self.assertEqual(inst.activity[7].notes, "7/23/12 Eve created a chart as a reminer to take the medications that do not fit in her pill box")
        self.assertFalse(inst.activity[7].prohibited)
        self.assertEqual(inst.activity[7].simple.category, "other")
        self.assertEqual(inst.activity[7].simple.details, "Eve will use a calendar of a chart to help her remember when to take her medications")
        self.assertEqual(inst.activity[7].simple.timingPeriod.start.date, FHIRDate("2012-07-10").date)
        self.assertEqual(inst.activity[7].simple.timingPeriod.start.isostring, "2012-07-10")
        self.assertEqual(inst.activity[7].status, "in progress")
        self.assertEqual(inst.activity[8].notes, "7/30/12 will be able to esume exercise.  8/13/12 Eve prefers to focus on walking at this time")
        self.assertFalse(inst.activity[8].prohibited)
        self.assertEqual(inst.activity[8].simple.category, "other")
        self.assertEqual(inst.activity[8].simple.details, "Eve will start using stretch bands and one step 2 days a week Mon/Wed 6-7am and maybe Friday afternoon")
        self.assertEqual(inst.activity[8].simple.timingPeriod.start.date, FHIRDate("2012-07-23").date)
        self.assertEqual(inst.activity[8].simple.timingPeriod.start.isostring, "2012-07-23")
        self.assertEqual(inst.activity[8].status, "on hold")
        self.assertFalse(inst.activity[9].prohibited)
        self.assertEqual(inst.activity[9].simple.category, "other")
        self.assertEqual(inst.activity[9].simple.details, "Eve will match a printed medication worksheet with the medication bottles at home")
        self.assertEqual(inst.activity[9].simple.timingPeriod.start.date, FHIRDate("2012-07-10").date)
        self.assertEqual(inst.activity[9].simple.timingPeriod.start.isostring, "2012-07-10")
        self.assertEqual(inst.activity[9].status, "completed")
        self.assertEqual(inst.concern[0].display, "GERDS")
        self.assertEqual(inst.concern[0].reference, "#p1")
        self.assertEqual(inst.concern[1].display, "Obesity")
        self.assertEqual(inst.concern[1].reference, "#p2")
        self.assertEqual(inst.concern[2].display, "Psoriasis")
        self.assertEqual(inst.concern[2].reference, "#p3")
        self.assertEqual(inst.goal[0].description, "Eve will lose weight and reduce her GERDS symptoms by improving her diet")
        self.assertEqual(inst.goal[0].status, "in progress")
        self.assertEqual(inst.goal[1].description, "Eve will improve her GERDS symptoms")
        self.assertEqual(inst.goal[1].status, "in progress")
        self.assertEqual(inst.goal[2].description, "Eve will increase her energy by being more active")
        self.assertEqual(inst.goal[2].status, "in progress")
        self.assertEqual(inst.goal[3].description, "Eve will set up her medications and take as prescribed")
        self.assertEqual(inst.goal[3].status, "in progress")
        self.assertEqual(inst.goal[4].description, "Eve will restart her light treatments")
        self.assertEqual(inst.goal[4].status, "in progress")
        self.assertEqual(inst.modified.date, FHIRDate("2012-09-10").date)
        self.assertEqual(inst.modified.isostring, "2012-09-10")
        self.assertEqual(inst.notes, "Patient family is not ready to commit to goal setting at this time.  Goal setting will be addressed in the future")
        self.assertEqual(inst.patient.display, "Eve Everywoman")
        self.assertEqual(inst.patient.reference, "Patient/1")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div>\n      <p>Patient family is not ready to commit to goal setting at this time.  Goal setting will be addressed in the future</p>\n      <table>\n        <thead>\n          <tr>\n            <th>Start Date</th>\n            <th>Goal</th>\n            <th>Action Steps</th>\n            <th>Status</th>\n            <th>Date Last Updated</th>\n            <th>Comments</th>\n          </tr>\n        </thead>\n        <tbody>\n          <tr>\n            <td>10 Sep 2012</td>\n            <td>Eve will lose weight and reduce her GERDS symptoms by improving her diet</td>\n            <td>Eve will review photos of high and low density foods and share with her parents</td>\n            <td>New Goal</td>\n            <td>10 Sep 2012</td>\n            <td>9/10/12 Eve eats one meal a day with her parents</td>\n          </tr>\n          <tr>\n            <td>10 Sep 2012</td>\n            <td>Eve will lose weight and reduce her GERDS symptoms by improving her diet</td>\n            <td>Eve will ask her dad to asist her to put the head of her bed on blocks</td>\n            <td>New Goal</td>\n            <td>10 Sep 2012</td>\n            <td>9/10/12 Eve will sleep in her bed more often than the couch</td>\n          </tr>\n          <tr>\n            <td>10 Sep 2012</td>\n            <td>Eve will improve her GERDS symptoms</td>\n            <td>Eve will reduce her intake of coffee and chocolate</td>\n            <td>In Process</td>\n            <td>10 Sep 2012</td>\n            <td/>\n          </tr>\n          <tr>\n            <td>27 Aug 2012</td>\n            <td>Eve will increase her energy by being more active</td>\n            <td>Eve will walk her friend's dog up and down a big hill 15-30 minutes 3 days a week</td>\n            <td>In Process</td>\n            <td>10 Sep 2012</td>\n            <td>8/27/12 Eve would like to try for 5 days a week.  9/10/12 Eve is still walking the dogs.</td>\n          </tr>\n          <tr>\n            <td>23 Jul 2012</td>\n            <td>Eve will increase her energy by being more active</td>\n            <td>Eve will walk 3 blocks to her parents house twice a week</td>\n            <td>In Process</td>\n            <td>10 Sep 2012</td>\n            <td>8/13/12 Eve walked 4 times the last week.  9/10/12 Eve did not walk to her parents the last week, but has plans to start again</td>\n          </tr>\n          <tr>\n            <td>23 Jul 2012</td>\n            <td>Eve will set up her medications and take as prescribed</td>\n            <td>Eve will us a calendar to check off after medications are taken</td>\n            <td>In Process</td>\n            <td>13 Aug 2012</td>\n            <td/>\n          </tr>\n          <tr>\n            <td>23 Jul 2012</td>\n            <td>Eve will restart her light treatments</td>\n            <td>Eve will use her lights MWF after her shower for 3 minutes</td>\n            <td>In Process</td>\n            <td>27 Aug 2012</td>\n            <td>8/13/12 After restarting the vinegar soaks the psoriasis is improved and Eve plans to treat the remainder with light treatments.  She plans to start this week.  8/27/12 Since her skin is improved Eve has not been using the light treatment as often, maybe once a week.  She would like to increase to 3 times a week again</td>\n          </tr>\n          <tr>\n            <td>10 Jul 2012</td>\n            <td>Eve will set up her medications and take as prescribed</td>\n            <td>Eve will use a calendar of a chart to help her remember when to take her medications</td>\n            <td>In Process</td>\n            <td>10 Sep 2012</td>\n            <td>7/23/12 Eve created a chart as a reminer to take the medications that do not fit in her pill box</td>\n          </tr>\n          <tr>\n            <td>23 Jul 2012</td>\n            <td>Eve will increase her energy by being more active</td>\n            <td>Eve will start using stretch bands and one step 2 days a week Mon/Wed 6-7am and maybe Friday afternoon</td>\n            <td>On-Hold</td>\n            <td>23 Aug 2012</td>\n            <td>7/30/12 will be able to esume exercise.  8/13/12 Eve prefers to focus on walking at this time</td>\n          </tr>\n          <tr>\n            <td>10 Jul 2012</td>\n            <td>Eve will set up her medications and take as prescribed</td>\n            <td>Eve will match a printed medication worksheet with the medication bottles at home</td>\n            <td>Completed</td>\n            <td>23 Jul 2012</td>\n            <td/>\n          </tr>\n          <tr>\n            <td>10 Jul 2012</td>\n            <td>Eve will set up her medications and take as prescribed</td>\n            <td>Eve will get a medication box to sort her pills.  She will have one for scheduled medications and one for as needed</td>\n            <td>Completed</td>\n            <td>16 Jul 2012</td>\n            <td>7/16/12 Eve now has some of her medications set up in pill packs by her pharmacist</td>\n          </tr>\n          <tr>\n            <td>23 Jul 2012</td>\n            <td>Eve will increase her energy by being more active</td>\n            <td>Eve will open &quot;The Firm&quot; DVD workout package and listen to it</td>\n            <td>Discontinued</td>\n            <td>13 Aug 2012</td>\n            <td>7/30/12 Eve will be able to resume exercise on 7/30/12.  8/13/12 -hold until &quot;less busy&quot;</td>\n          </tr>\n        </tbody>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testCarePlan9(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/careplan-example-pregnancy.json")
        self.assertIsNotNone(inst, "Must have instantiated a CarePlan instance")
    
        self.assertFalse(inst.activity[0].prohibited)
        self.assertEqual(inst.activity[0].simple.category, "encounter")
        self.assertEqual(inst.activity[0].simple.code.coding[0].code, "1an")
        self.assertEqual(inst.activity[0].simple.code.coding[0].system, "mySystem")
        self.assertEqual(inst.activity[0].simple.code.text, "First Antenatal encounter")
        self.assertEqual(inst.activity[0].simple.details, "The first antenatal encounter. This is where a detailed physical examination is performed.             and the pregnanacy discussed with the mother-to-be.")
        self.assertEqual(inst.activity[0].simple.performer[0].display, "Mavis Midwife")
        self.assertEqual(inst.activity[0].simple.performer[0].reference, "#pr1")
        self.assertEqual(inst.activity[0].simple.timingSchedule.event[0].end.date, FHIRDate("2013-02-28").date)
        self.assertEqual(inst.activity[0].simple.timingSchedule.event[0].end.isostring, "2013-02-28")
        self.assertEqual(inst.activity[0].simple.timingSchedule.event[0].start.date, FHIRDate("2013-02-14").date)
        self.assertEqual(inst.activity[0].simple.timingSchedule.event[0].start.isostring, "2013-02-14")
        self.assertEqual(inst.activity[0].status, "scheduled")
        self.assertFalse(inst.activity[1].prohibited)
        self.assertEqual(inst.activity[1].simple.category, "encounter")
        self.assertEqual(inst.activity[1].simple.code.coding[0].code, "an")
        self.assertEqual(inst.activity[1].simple.code.coding[0].system, "mySystem")
        self.assertEqual(inst.activity[1].simple.code.text, "Follow-up Antenatal encounter")
        self.assertEqual(inst.activity[1].simple.details, "The second antenatal encounter. Discuss any issues that arose from the first antenatal encounter")
        self.assertEqual(inst.activity[1].simple.performer[0].display, "Mavis Midwife")
        self.assertEqual(inst.activity[1].simple.performer[0].reference, "#pr1")
        self.assertEqual(inst.activity[1].simple.timingSchedule.event[0].end.date, FHIRDate("2013-03-14").date)
        self.assertEqual(inst.activity[1].simple.timingSchedule.event[0].end.isostring, "2013-03-14")
        self.assertEqual(inst.activity[1].simple.timingSchedule.event[0].start.date, FHIRDate("2013-03-01").date)
        self.assertEqual(inst.activity[1].simple.timingSchedule.event[0].start.isostring, "2013-03-01")
        self.assertEqual(inst.activity[1].status, "not started")
        self.assertFalse(inst.activity[2].prohibited)
        self.assertEqual(inst.activity[2].simple.category, "encounter")
        self.assertEqual(inst.activity[2].simple.code.coding[0].code, "del")
        self.assertEqual(inst.activity[2].simple.code.coding[0].system, "mySystem")
        self.assertEqual(inst.activity[2].simple.code.text, "Delivery")
        self.assertEqual(inst.activity[2].simple.details, "The delivery.")
        self.assertEqual(inst.activity[2].simple.performer[0].display, "Mavis Midwife")
        self.assertEqual(inst.activity[2].simple.performer[0].reference, "#pr1")
        self.assertEqual(inst.activity[2].simple.timingSchedule.event[0].end.date, FHIRDate("2013-09-14").date)
        self.assertEqual(inst.activity[2].simple.timingSchedule.event[0].end.isostring, "2013-09-14")
        self.assertEqual(inst.activity[2].simple.timingSchedule.event[0].start.date, FHIRDate("2013-09-01").date)
        self.assertEqual(inst.activity[2].simple.timingSchedule.event[0].start.isostring, "2013-09-01")
        self.assertEqual(inst.activity[2].status, "not started")
        self.assertEqual(inst.concern[0].display, "pregnancy")
        self.assertEqual(inst.concern[0].reference, "#p1")
        self.assertEqual(inst.goal[0].description, "Maintain a womans health throughout pregnancy and ensure a healthy child")
        self.assertEqual(inst.participant[0].member.display, "Mavis Midwife")
        self.assertEqual(inst.participant[0].member.reference, "#pr1")
        self.assertEqual(inst.participant[0].role.coding[0].code, "lmc")
        self.assertEqual(inst.participant[0].role.coding[0].system, "mySys")
        self.assertEqual(inst.participant[0].role.text, "Midwife")
        self.assertEqual(inst.participant[1].member.display, "Oscar Obstetrician")
        self.assertEqual(inst.participant[1].member.reference, "#pr2")
        self.assertEqual(inst.participant[1].role.coding[0].code, "obs")
        self.assertEqual(inst.participant[1].role.coding[0].system, "mySys")
        self.assertEqual(inst.participant[1].role.text, "Obstretitian")
        self.assertEqual(inst.patient.display, "Eve Everywoman")
        self.assertEqual(inst.patient.reference, "Patient/1")
        self.assertEqual(inst.period.end.date, FHIRDate("2013-10-01").date)
        self.assertEqual(inst.period.end.isostring, "2013-10-01")
        self.assertEqual(inst.period.start.date, FHIRDate("2013-01-01").date)
        self.assertEqual(inst.period.start.isostring, "2013-01-01")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div>\n            <p>A maternity care plan (for a pregnant woman).</p>           \n            <p>LMP is 1st Jan, 2013 (a greaat new years party!) The plan has a scheduled first antenatal,\n            and 'placeholders' for the second antenatal and delivery (there would be lots of others of course)</p>\n            <p>Note that where is a proposed 'status' element against each activity</p>\n        </div>")
        self.assertEqual(inst.text.status, "additional")

