#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 0.0.82.2943 (xds-profile.profile.json) on 2014-10-31.
#  2014, SMART Platforms.


import io
import unittest
import json
from conceptmap import ConceptMap
from fhirdate import FHIRDate


class ConceptMapTests(unittest.TestCase):
    def instantiate_from(self, filename):
        with io.open(filename, 'r', encoding='utf-8') as handle:
            js = json.load(handle)
        instance = ConceptMap(js)
        self.assertIsNotNone(instance, "Must have instantiated a test instance")
        return instance
    
    def testConceptMap1(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/conceptmap-example-specimen-type.json")
        self.assertIsNotNone(inst, "Must have instantiated a ConceptMap instance")
    
        self.assertEqual(inst.concept[0].code, "ACNE")
        self.assertEqual(inst.concept[0].map[0].code, "309068002")
        self.assertEqual(inst.concept[0].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[0].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[0].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[100].code, "GSOL")
        self.assertEqual(inst.concept[100].map[0].comments, "TBD")
        self.assertEqual(inst.concept[100].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[100].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[100].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[101].code, "GSPEC")
        self.assertEqual(inst.concept[101].map[0].code, "309211008")
        self.assertEqual(inst.concept[101].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[101].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[101].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[102].code, "GT")
        self.assertEqual(inst.concept[102].map[0].comments, "TBD")
        self.assertEqual(inst.concept[102].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[102].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[102].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[103].code, "GTUBE")
        self.assertEqual(inst.concept[103].map[0].code, "258459007")
        self.assertEqual(inst.concept[103].map[0].comments, "Historical term - consider what is being drained and indicate that in SPM-4 instead")
        self.assertEqual(inst.concept[103].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[103].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[103].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[104].code, "HBITE")
        self.assertEqual(inst.concept[104].map[0].comments, "Submit for new term with parent 119365002")
        self.assertEqual(inst.concept[104].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[104].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[104].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[105].code, "HBLUD")
        self.assertEqual(inst.concept[105].map[0].code, "119297000")
        self.assertEqual(inst.concept[105].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[105].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[105].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[106].code, "HEMAQ")
        self.assertEqual(inst.concept[106].map[0].code, "119312009")
        self.assertEqual(inst.concept[106].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[106].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[106].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[106].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[107].code, "HEMO")
        self.assertEqual(inst.concept[107].map[0].code, "119312009")
        self.assertEqual(inst.concept[107].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[107].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[107].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[107].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[108].code, "HERNI")
        self.assertEqual(inst.concept[108].map[0].code, "119376003")
        self.assertEqual(inst.concept[108].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[108].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[108].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[109].code, "HEV")
        self.assertEqual(inst.concept[109].map[0].code, "119306004")
        self.assertEqual(inst.concept[109].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[109].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[109].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[10].code, "AUTOC")
        self.assertEqual(inst.concept[10].map[0].comments, "TBD")
        self.assertEqual(inst.concept[10].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[10].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[10].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[110].code, "HIC")
        self.assertEqual(inst.concept[110].map[0].code, "119312009")
        self.assertEqual(inst.concept[110].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[110].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[110].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[110].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[111].code, "HYDC")
        self.assertEqual(inst.concept[111].map[0].code, "309051001")
        self.assertEqual(inst.concept[111].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[111].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[111].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[112].code, "IBITE")
        self.assertEqual(inst.concept[112].map[0].comments, "Submit for new term with parent 119365002")
        self.assertEqual(inst.concept[112].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[112].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[112].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[113].code, "ICYST")
        self.assertEqual(inst.concept[113].map[0].code, "309075001")
        self.assertEqual(inst.concept[113].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[113].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[113].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[114].code, "IDC")
        self.assertEqual(inst.concept[114].map[0].code, "119312009")
        self.assertEqual(inst.concept[114].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[114].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[114].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[114].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[115].code, "IHG")
        self.assertEqual(inst.concept[115].map[0].code, "119337004")
        self.assertEqual(inst.concept[115].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[115].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[115].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[116].code, "ILEO")
        self.assertEqual(inst.concept[116].map[0].code, "258455001")
        self.assertEqual(inst.concept[116].map[0].comments, "Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample")
        self.assertEqual(inst.concept[116].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[116].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[116].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[117].code, "ILLEG")
        self.assertEqual(inst.concept[117].map[0].comments, "TBD")
        self.assertEqual(inst.concept[117].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[117].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[117].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[118].code, "IMP")
        self.assertEqual(inst.concept[118].map[0].code, "439961009")
        self.assertEqual(inst.concept[118].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[118].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[118].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[119].code, "INCI")
        self.assertEqual(inst.concept[119].map[0].code, "438660002")
        self.assertEqual(inst.concept[119].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[119].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[119].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[11].code, "AUTP")
        self.assertEqual(inst.concept[11].map[0].comments, "This really is not a specimen per se - it is the state of the subject from whom the specimen is collected, so it should be used as a  specimen type modifier ONLY!. Often this is indicated with a special medical record number or other notation on the patient. needs to have specimen type (SPM-4) and source site (SPM.8) and spatial orientation (SPM.9)")
        self.assertEqual(inst.concept[11].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[11].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[11].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[120].code, "INFIL")
        self.assertEqual(inst.concept[120].map[0].comments, "This describes a morphologic abnormality, not a sample")
        self.assertEqual(inst.concept[120].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[120].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[120].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[121].code, "INS")
        self.assertEqual(inst.concept[121].map[0].code, "258614005")
        self.assertEqual(inst.concept[121].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[121].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[121].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[122].code, "INTRD")
        self.assertEqual(inst.concept[122].map[0].code, "119312009")
        self.assertEqual(inst.concept[122].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[122].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[122].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[122].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[123].code, "IT")
        self.assertEqual(inst.concept[123].map[0].code, "119307008")
        self.assertEqual(inst.concept[123].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[123].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[123].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[124].code, "IUD")
        self.assertEqual(inst.concept[124].map[0].comments, "pending")
        self.assertEqual(inst.concept[124].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[124].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[124].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[125].code, "IVCAT")
        self.assertEqual(inst.concept[125].map[0].code, "119312009")
        self.assertEqual(inst.concept[125].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[125].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[125].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[125].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[126].code, "IVFLD")
        self.assertEqual(inst.concept[126].map[0].code, "258649003")
        self.assertEqual(inst.concept[126].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[126].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[126].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[127].code, "IVTIP")
        self.assertEqual(inst.concept[127].map[0].code, "119312009")
        self.assertEqual(inst.concept[127].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[127].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[127].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[128].code, "JEJU")
        self.assertEqual(inst.concept[128].map[0].code, "258463000")
        self.assertEqual(inst.concept[128].map[0].comments, "Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample")
        self.assertEqual(inst.concept[128].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[128].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[128].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[129].code, "JNTFLD")
        self.assertEqual(inst.concept[129].map[0].code, "119332005")
        self.assertEqual(inst.concept[129].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[129].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[129].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[12].code, "BBL")
        self.assertEqual(inst.concept[12].map[0].code, "119304001")
        self.assertEqual(inst.concept[12].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[12].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[12].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[130].code, "JP")
        self.assertEqual(inst.concept[130].map[0].code, "309051001")
        self.assertEqual(inst.concept[130].map[0].comments, "Historical term - consider what is being drained and indicate that in SPM-4 instead")
        self.assertEqual(inst.concept[130].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[130].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[130].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[131].code, "KELOI")
        self.assertEqual(inst.concept[131].map[0].code, "440674008")
        self.assertEqual(inst.concept[131].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[131].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[131].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[132].code, "KIDFLD")
        self.assertEqual(inst.concept[132].map[0].code, "309051001")
        self.assertEqual(inst.concept[132].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[132].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[132].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[133].code, "LAVG")
        self.assertEqual(inst.concept[133].map[0].code, "258607008")
        self.assertEqual(inst.concept[133].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[133].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[133].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[134].code, "LAVGG")
        self.assertEqual(inst.concept[134].map[0].code, "168138009")
        self.assertEqual(inst.concept[134].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[134].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[134].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[135].code, "LAVGP")
        self.assertEqual(inst.concept[135].map[0].code, "440137008")
        self.assertEqual(inst.concept[135].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[135].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[135].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[136].code, "LAVPG")
        self.assertEqual(inst.concept[136].map[0].code, "440674008")
        self.assertEqual(inst.concept[136].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[136].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[136].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[137].code, "LENS1")
        self.assertEqual(inst.concept[137].map[0].code, "440473005")
        self.assertEqual(inst.concept[137].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[137].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[137].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[138].code, "LENS2")
        self.assertEqual(inst.concept[138].map[0].comments, "TBD")
        self.assertEqual(inst.concept[138].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[138].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[138].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[139].code, "LESN")
        self.assertEqual(inst.concept[139].map[0].code, "309049000")
        self.assertEqual(inst.concept[139].map[0].comments, "should be more specific what kind of lesion is observed - be more specific is it a wound, abscess, mass - specify! Ask SNOMED CT to mark it as a grouper term only (309049000)")
        self.assertEqual(inst.concept[139].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[139].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[139].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[13].code, "BCYST")
        self.assertEqual(inst.concept[13].map[0].comments, "submitted (PLR155) with parent of  167874004^knee joint synovial fluid (specimen), with specimen source topography 32361000^Popliteal fossa structure (body structure)")
        self.assertEqual(inst.concept[13].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[13].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[13].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[140].code, "LIQ")
        self.assertEqual(inst.concept[140].map[0].code, "258442002")
        self.assertEqual(inst.concept[140].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[140].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[140].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[141].code, "LIQO")
        self.assertEqual(inst.concept[141].map[0].comments, "TBD")
        self.assertEqual(inst.concept[141].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[141].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[141].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[142].code, "LSAC")
        self.assertEqual(inst.concept[142].map[0].code, "258450006")
        self.assertEqual(inst.concept[142].map[0].comments, "The HL7 term is a historical term Mapped to CSF obtained by lumbar puncture")
        self.assertEqual(inst.concept[142].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[142].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[142].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[143].code, "MAHUR")
        self.assertEqual(inst.concept[143].map[0].code, "119312009")
        self.assertEqual(inst.concept[143].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[143].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[143].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[143].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[144].code, "MASS")
        self.assertEqual(inst.concept[144].map[0].code, "420548004")
        self.assertEqual(inst.concept[144].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[144].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[144].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[145].code, "MBLD")
        self.assertEqual(inst.concept[145].map[0].code, "119345009")
        self.assertEqual(inst.concept[145].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[145].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[145].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[146].code, "MUCOS")
        self.assertEqual(inst.concept[146].map[0].code, "119376003")
        self.assertEqual(inst.concept[146].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[146].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[146].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[147].code, "MUCUS")
        self.assertEqual(inst.concept[147].map[0].code, "258483004")
        self.assertEqual(inst.concept[147].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[147].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[147].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[148].code, "NASDR")
        self.assertEqual(inst.concept[148].map[0].code, "258474009")
        self.assertEqual(inst.concept[148].map[0].comments, "Historical term - consider what is being drained and indicate that in SPM-4 instead")
        self.assertEqual(inst.concept[148].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[148].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[148].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[149].code, "NEDL")
        self.assertEqual(inst.concept[149].map[0].comments, "TBD")
        self.assertEqual(inst.concept[149].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[149].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[149].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[14].code, "BITE")
        self.assertEqual(inst.concept[14].map[0].comments, "Submit for new term with parent 119365002")
        self.assertEqual(inst.concept[14].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[14].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[14].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[150].code, "NEPH")
        self.assertEqual(inst.concept[150].map[0].code, "438660002")
        self.assertEqual(inst.concept[150].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[150].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[150].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[151].code, "NGASP")
        self.assertEqual(inst.concept[151].map[0].code, "302794003")
        self.assertEqual(inst.concept[151].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[151].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[151].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[152].code, "NGAST")
        self.assertEqual(inst.concept[152].map[0].code, "258459007")
        self.assertEqual(inst.concept[152].map[0].comments, "Historical term - consider what is being drained and indicate that in SPM-4 instead")
        self.assertEqual(inst.concept[152].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[152].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[152].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[153].code, "NGS")
        self.assertEqual(inst.concept[153].map[0].code, "438660002")
        self.assertEqual(inst.concept[153].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[153].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[153].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[154].code, "NODUL")
        self.assertEqual(inst.concept[154].map[0].comments, "pending")
        self.assertEqual(inst.concept[154].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[154].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[154].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[155].code, "NSECR")
        self.assertEqual(inst.concept[155].map[0].code, "168141000")
        self.assertEqual(inst.concept[155].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[155].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[155].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[156].code, "ORH")
        self.assertEqual(inst.concept[156].map[0].code, "123038009")
        self.assertEqual(inst.concept[156].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[156].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[156].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[157].code, "ORL")
        self.assertEqual(inst.concept[157].map[0].comments, "be more precise use ulcer, tumor, vesicle")
        self.assertEqual(inst.concept[157].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[157].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[157].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[158].code, "OTH")
        self.assertEqual(inst.concept[158].map[0].code, "123038009")
        self.assertEqual(inst.concept[158].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[158].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[158].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[159].code, "PACEM")
        self.assertEqual(inst.concept[159].map[0].comments, "TBD")
        self.assertEqual(inst.concept[159].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[159].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[159].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[15].code, "BLEB")
        self.assertEqual(inst.concept[15].map[0].code, "309049000")
        self.assertEqual(inst.concept[15].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[15].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[15].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[160].code, "PCFL")
        self.assertEqual(inst.concept[160].map[0].code, "122571007")
        self.assertEqual(inst.concept[160].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[160].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[160].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[161].code, "PDSIT")
        self.assertEqual(inst.concept[161].map[0].code, "438660002")
        self.assertEqual(inst.concept[161].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[161].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[161].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[162].code, "PDTS")
        self.assertEqual(inst.concept[162].map[0].comments, "submitted for code")
        self.assertEqual(inst.concept[162].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[162].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[162].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[163].code, "PELVA")
        self.assertEqual(inst.concept[163].map[0].code, "119371008")
        self.assertEqual(inst.concept[163].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[163].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[163].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[164].code, "PENIL")
        self.assertEqual(inst.concept[164].map[0].comments, "need to know what kind of lesion, so map to: UlcerTissue_penile, VesicleFluid_penile, Wound_penile, Mass tissue_penile, Necrotic tissue_penile, AbscessAspirate_penile, Anything else?")
        self.assertEqual(inst.concept[164].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[164].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[164].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[165].code, "PERIA")
        self.assertEqual(inst.concept[165].map[0].code, "119371008")
        self.assertEqual(inst.concept[165].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[165].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[165].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[166].code, "PILOC")
        self.assertEqual(inst.concept[166].map[0].code, "119368000")
        self.assertEqual(inst.concept[166].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[166].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[166].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[167].code, "PINS")
        self.assertEqual(inst.concept[167].map[0].code, "438660002")
        self.assertEqual(inst.concept[167].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[167].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[167].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[168].code, "PIS")
        self.assertEqual(inst.concept[168].map[0].code, "258507003")
        self.assertEqual(inst.concept[168].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[168].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[168].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[169].code, "PLAN")
        self.assertEqual(inst.concept[169].map[0].code, "119301009")
        self.assertEqual(inst.concept[169].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[169].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[169].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[16].code, "BLIST")
        self.assertEqual(inst.concept[16].map[0].code, "309049000")
        self.assertEqual(inst.concept[16].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[16].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[16].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[170].code, "PLAS")
        self.assertEqual(inst.concept[170].map[0].code, "119361006")
        self.assertEqual(inst.concept[170].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[170].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[170].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[171].code, "PLB")
        self.assertEqual(inst.concept[171].map[0].code, "119305000")
        self.assertEqual(inst.concept[171].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[171].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[171].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[172].code, "PLEVS")
        self.assertEqual(inst.concept[172].map[0].code, "119364003")
        self.assertEqual(inst.concept[172].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[172].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[172].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[173].code, "PND")
        self.assertEqual(inst.concept[173].map[0].code, "258439008")
        self.assertEqual(inst.concept[173].map[0].comments, "Historical term -though in this case more often used for discharge")
        self.assertEqual(inst.concept[173].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[173].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[173].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[174].code, "POL")
        self.assertEqual(inst.concept[174].map[0].code, "119376003")
        self.assertEqual(inst.concept[174].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[174].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[174].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[175].code, "POPGS")
        self.assertEqual(inst.concept[175].map[0].code, "440493002")
        self.assertEqual(inst.concept[175].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[175].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[175].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[176].code, "POPLG")
        self.assertEqual(inst.concept[176].map[0].code, "440493002")
        self.assertEqual(inst.concept[176].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[176].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[176].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[177].code, "POPLV")
        self.assertEqual(inst.concept[177].map[0].comments, "TBD")
        self.assertEqual(inst.concept[177].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[177].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[177].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[178].code, "PORTA")
        self.assertEqual(inst.concept[178].map[0].code, "119311002")
        self.assertEqual(inst.concept[178].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[178].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[178].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[178].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[179].code, "PPP")
        self.assertEqual(inst.concept[179].map[0].code, "119362004")
        self.assertEqual(inst.concept[179].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[179].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[179].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[17].code, "BOIL")
        self.assertEqual(inst.concept[17].map[0].code, "119295008")
        self.assertEqual(inst.concept[17].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[17].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[17].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[180].code, "PROST")
        self.assertEqual(inst.concept[180].map[0].code, "438660002")
        self.assertEqual(inst.concept[180].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[180].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[180].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[181].code, "PRP")
        self.assertEqual(inst.concept[181].map[0].code, "119363009")
        self.assertEqual(inst.concept[181].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[181].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[181].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[182].code, "PSC")
        self.assertEqual(inst.concept[182].map[0].code, "119368000")
        self.assertEqual(inst.concept[182].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[182].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[182].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[183].code, "PUNCT")
        self.assertEqual(inst.concept[183].map[0].code, "119365002")
        self.assertEqual(inst.concept[183].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[183].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[183].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[184].code, "PUS")
        self.assertEqual(inst.concept[184].map[0].code, "119323008")
        self.assertEqual(inst.concept[184].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[184].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[184].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[185].code, "PUSFR")
        self.assertEqual(inst.concept[185].map[0].code, "119323008")
        self.assertEqual(inst.concept[185].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[185].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[185].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[186].code, "PUST")
        self.assertEqual(inst.concept[186].map[0].code, "119323008")
        self.assertEqual(inst.concept[186].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[186].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[186].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[187].code, "QC3")
        self.assertEqual(inst.concept[187].map[0].comments, "TBD")
        self.assertEqual(inst.concept[187].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[187].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[187].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[188].code, "RANDU")
        self.assertEqual(inst.concept[188].map[0].code, "278020009")
        self.assertEqual(inst.concept[188].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[188].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[188].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[189].code, "RBITE")
        self.assertEqual(inst.concept[189].map[0].comments, "Submit for new term with parent: 119365002")
        self.assertEqual(inst.concept[189].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[189].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[189].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[18].code, "BON")
        self.assertEqual(inst.concept[18].map[0].code, "430268003")
        self.assertEqual(inst.concept[18].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[18].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[18].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[190].code, "RECT")
        self.assertEqual(inst.concept[190].map[0].code, "119339001")
        self.assertEqual(inst.concept[190].map[0].comments, "Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample")
        self.assertEqual(inst.concept[190].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[190].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[190].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[191].code, "RECTA")
        self.assertEqual(inst.concept[191].map[0].code, "119371008")
        self.assertEqual(inst.concept[191].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[191].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[191].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[192].code, "RENALC")
        self.assertEqual(inst.concept[192].map[0].code, "258420003")
        self.assertEqual(inst.concept[192].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[192].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[192].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[193].code, "RENC")
        self.assertEqual(inst.concept[193].map[0].code, "258453008")
        self.assertEqual(inst.concept[193].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[193].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[193].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[194].code, "RES")
        self.assertEqual(inst.concept[194].map[0].code, "258603007")
        self.assertEqual(inst.concept[194].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[194].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[194].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[195].code, "SAL")
        self.assertEqual(inst.concept[195].map[0].code, "119342007")
        self.assertEqual(inst.concept[195].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[195].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[195].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[196].code, "SCAR")
        self.assertEqual(inst.concept[196].map[0].code, "119376003")
        self.assertEqual(inst.concept[196].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[196].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[196].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[197].code, "SCLV")
        self.assertEqual(inst.concept[197].map[0].code, "119312009")
        self.assertEqual(inst.concept[197].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[197].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[197].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[197].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[198].code, "SCROA")
        self.assertEqual(inst.concept[198].map[0].code, "119371008")
        self.assertEqual(inst.concept[198].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[198].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[198].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[199].code, "SECRE")
        self.assertEqual(inst.concept[199].map[0].code, "432825001")
        self.assertEqual(inst.concept[199].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[199].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[199].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[19].code, "BOWL")
        self.assertEqual(inst.concept[19].map[0].comments, "Don't use this term for human samples - use Stool instead. animal would use small intestinal contents, large intestinal contents")
        self.assertEqual(inst.concept[19].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[19].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[19].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[1].code, "ACNFLD")
        self.assertEqual(inst.concept[1].map[0].code, "119323008")
        self.assertEqual(inst.concept[1].map[0].comments, "HL7 term is a historical term. mapped to Pus")
        self.assertEqual(inst.concept[1].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[1].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[1].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[200].code, "SER")
        self.assertEqual(inst.concept[200].map[0].code, "119364003")
        self.assertEqual(inst.concept[200].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[200].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[200].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[201].code, "SHU")
        self.assertEqual(inst.concept[201].map[0].code, "119295008")
        self.assertEqual(inst.concept[201].map[0].comments, "Preferred is aspiration with sterile syringe from inflamed area. Specify body location of shunt site")
        self.assertEqual(inst.concept[201].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[201].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[201].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[202].code, "SHUNF")
        self.assertEqual(inst.concept[202].map[0].code, "446861007")
        self.assertEqual(inst.concept[202].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[202].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[202].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[203].code, "SHUNT")
        self.assertEqual(inst.concept[203].map[0].comments, "TBD")
        self.assertEqual(inst.concept[203].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[203].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[203].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[204].code, "SITE")
        self.assertEqual(inst.concept[204].map[0].comments, "TBD")
        self.assertEqual(inst.concept[204].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[204].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[204].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[205].code, "SKBP")
        self.assertEqual(inst.concept[205].map[0].code, "309066003")
        self.assertEqual(inst.concept[205].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[205].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[205].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[206].code, "SKN")
        self.assertEqual(inst.concept[206].map[0].code, "119325001")
        self.assertEqual(inst.concept[206].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[206].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[206].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[207].code, "SMM")
        self.assertEqual(inst.concept[207].map[0].code, "420548004")
        self.assertEqual(inst.concept[207].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[207].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[207].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[208].code, "SNV")
        self.assertEqual(inst.concept[208].map[0].code, "119332005")
        self.assertEqual(inst.concept[208].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[208].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[208].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[209].code, "SPRM")
        self.assertEqual(inst.concept[209].map[0].code, "119349003")
        self.assertEqual(inst.concept[209].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[209].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[209].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[20].code, "BPU")
        self.assertEqual(inst.concept[20].map[0].code, "119300005")
        self.assertEqual(inst.concept[20].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[20].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[20].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[210].code, "SPRP")
        self.assertEqual(inst.concept[210].map[0].code, "119312009")
        self.assertEqual(inst.concept[210].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[210].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[210].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[210].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[211].code, "SPRPB")
        self.assertEqual(inst.concept[211].map[0].code, "119312009")
        self.assertEqual(inst.concept[211].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[211].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[211].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[211].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[212].code, "SPS")
        self.assertEqual(inst.concept[212].map[0].comments, "TBD")
        self.assertEqual(inst.concept[212].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[212].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[212].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[213].code, "SPT")
        self.assertEqual(inst.concept[213].map[0].code, "119334006")
        self.assertEqual(inst.concept[213].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[213].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[213].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[214].code, "SPTC")
        self.assertEqual(inst.concept[214].map[0].code, "119335007")
        self.assertEqual(inst.concept[214].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[214].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[214].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[215].code, "SPTT")
        self.assertEqual(inst.concept[215].map[0].code, "258609006")
        self.assertEqual(inst.concept[215].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[215].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[215].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[216].code, "SPUT1")
        self.assertEqual(inst.concept[216].map[0].comments, "TBD")
        self.assertEqual(inst.concept[216].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[216].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[216].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[217].code, "SPUTIN")
        self.assertEqual(inst.concept[217].map[0].code, "258610001")
        self.assertEqual(inst.concept[217].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[217].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[217].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[218].code, "SPUTSP")
        self.assertEqual(inst.concept[218].map[0].code, "119335007")
        self.assertEqual(inst.concept[218].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[218].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[218].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[219].code, "STER")
        self.assertEqual(inst.concept[219].map[0].comments, "TBD")
        self.assertEqual(inst.concept[219].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[219].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[219].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[21].code, "BRN")
        self.assertEqual(inst.concept[21].map[0].code, "119367005")
        self.assertEqual(inst.concept[21].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[21].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[21].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[220].code, "STL")
        self.assertEqual(inst.concept[220].map[0].code, "119339001")
        self.assertEqual(inst.concept[220].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[220].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[220].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[221].code, "STONE")
        self.assertEqual(inst.concept[221].map[0].code, "119350003")
        self.assertEqual(inst.concept[221].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[221].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[221].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[222].code, "SUBMA")
        self.assertEqual(inst.concept[222].map[0].code, "119371008")
        self.assertEqual(inst.concept[222].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[222].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[222].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[223].code, "SUBMX")
        self.assertEqual(inst.concept[223].map[0].code, "119371008")
        self.assertEqual(inst.concept[223].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[223].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[223].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[224].code, "SUMP")
        self.assertEqual(inst.concept[224].map[0].code, "446562005")
        self.assertEqual(inst.concept[224].map[0].comments, "Historical term - consider what is being drained and indicate that in SPM-4 instead")
        self.assertEqual(inst.concept[224].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[224].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[224].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[225].code, "SUP")
        self.assertEqual(inst.concept[225].map[0].code, "122575003")
        self.assertEqual(inst.concept[225].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[225].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[225].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[226].code, "SUTUR")
        self.assertEqual(inst.concept[226].map[0].comments, "TBD")
        self.assertEqual(inst.concept[226].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[226].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[226].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[227].code, "SWGZ")
        self.assertEqual(inst.concept[227].map[0].code, "119312009")
        self.assertEqual(inst.concept[227].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[227].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[227].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[227].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[228].code, "TASP")
        self.assertEqual(inst.concept[228].map[0].code, "122877000")
        self.assertEqual(inst.concept[228].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[228].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[228].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[229].code, "TISS")
        self.assertEqual(inst.concept[229].map[0].code, "119376003")
        self.assertEqual(inst.concept[229].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[229].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[229].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[22].code, "BRSH")
        self.assertEqual(inst.concept[22].map[0].code, "258415003")
        self.assertEqual(inst.concept[22].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[22].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[22].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[230].code, "TISU")
        self.assertEqual(inst.concept[230].map[0].code, "122593002")
        self.assertEqual(inst.concept[230].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[230].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[230].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[231].code, "TLC")
        self.assertEqual(inst.concept[231].map[0].code, "119312009")
        self.assertEqual(inst.concept[231].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[231].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[231].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[231].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[232].code, "TRAC")
        self.assertEqual(inst.concept[232].map[0].code, "438660002")
        self.assertEqual(inst.concept[232].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[232].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[232].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[233].code, "TRANS")
        self.assertEqual(inst.concept[233].map[0].code, "258538002")
        self.assertEqual(inst.concept[233].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[233].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[233].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[234].code, "TSERU")
        self.assertEqual(inst.concept[234].map[0].code, "119364003")
        self.assertEqual(inst.concept[234].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[234].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[234].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[235].code, "TSTES")
        self.assertEqual(inst.concept[235].map[0].code, "119371008")
        self.assertEqual(inst.concept[235].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[235].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[235].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[236].code, "TTRA")
        self.assertEqual(inst.concept[236].map[0].code, "258480001")
        self.assertEqual(inst.concept[236].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[236].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[236].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[237].code, "TUBES")
        self.assertEqual(inst.concept[237].map[0].code, "119310001")
        self.assertEqual(inst.concept[237].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[237].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[237].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[238].code, "TUMOR")
        self.assertEqual(inst.concept[238].map[0].code, "258435002")
        self.assertEqual(inst.concept[238].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[238].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[238].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[239].code, "TZANC")
        self.assertEqual(inst.concept[239].map[0].comments, "This is the name of a lab test. A skin sample is examined for viral inclusions.")
        self.assertEqual(inst.concept[239].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[239].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[239].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[23].code, "BRTH")
        self.assertEqual(inst.concept[23].map[0].code, "119336008")
        self.assertEqual(inst.concept[23].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[23].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[23].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[240].code, "UDENT")
        self.assertEqual(inst.concept[240].map[0].code, "123038009")
        self.assertEqual(inst.concept[240].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[240].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[240].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[241].code, "UR")
        self.assertEqual(inst.concept[241].map[0].code, "122575003")
        self.assertEqual(inst.concept[241].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[241].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[241].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[242].code, "URC")
        self.assertEqual(inst.concept[242].map[0].code, "122880004")
        self.assertEqual(inst.concept[242].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[242].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[242].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[243].code, "URINB")
        self.assertEqual(inst.concept[243].map[0].code, "122575003")
        self.assertEqual(inst.concept[243].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[243].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[243].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[244].code, "URINC")
        self.assertEqual(inst.concept[244].map[0].code, "446846006")
        self.assertEqual(inst.concept[244].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[244].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[244].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[245].code, "URINM")
        self.assertEqual(inst.concept[245].map[0].code, "258574006")
        self.assertEqual(inst.concept[245].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[245].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[245].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[246].code, "URINN")
        self.assertEqual(inst.concept[246].map[0].code, "446277003")
        self.assertEqual(inst.concept[246].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[246].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[246].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[247].code, "URINP")
        self.assertEqual(inst.concept[247].map[0].comments, "TBD")
        self.assertEqual(inst.concept[247].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[247].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[247].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[248].code, "URT")
        self.assertEqual(inst.concept[248].map[0].code, "122565001")
        self.assertEqual(inst.concept[248].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[248].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[248].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[249].code, "USCOP")
        self.assertEqual(inst.concept[249].map[0].comments, "NEW specimenTERM 7")
        self.assertEqual(inst.concept[249].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[249].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[249].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[24].code, "BRUS")
        self.assertEqual(inst.concept[24].map[0].code, "309176002")
        self.assertEqual(inst.concept[24].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[24].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[24].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[250].code, "USPEC")
        self.assertEqual(inst.concept[250].map[0].code, "123038009")
        self.assertEqual(inst.concept[250].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[250].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[250].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[251].code, "VASTIP")
        self.assertEqual(inst.concept[251].map[0].code, "119312009")
        self.assertEqual(inst.concept[251].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[251].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[251].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[251].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[252].code, "VENT")
        self.assertEqual(inst.concept[252].map[0].code, "119312009")
        self.assertEqual(inst.concept[252].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[252].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[252].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[252].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[253].code, "VITF")
        self.assertEqual(inst.concept[253].map[0].code, "258438000")
        self.assertEqual(inst.concept[253].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[253].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[253].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[254].code, "VOM")
        self.assertEqual(inst.concept[254].map[0].code, "122572000")
        self.assertEqual(inst.concept[254].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[254].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[254].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[255].code, "WASH")
        self.assertEqual(inst.concept[255].map[0].code, "440674008")
        self.assertEqual(inst.concept[255].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[255].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[255].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[256].code, "WASI")
        self.assertEqual(inst.concept[256].map[0].code, "122609004")
        self.assertEqual(inst.concept[256].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[256].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[256].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[257].code, "WAT")
        self.assertEqual(inst.concept[257].map[0].code, "119318008")
        self.assertEqual(inst.concept[257].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[257].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[257].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[258].code, "WB")
        self.assertEqual(inst.concept[258].map[0].comments, "Bloodbanking term ONLY now map to blood and the respective preservative")
        self.assertEqual(inst.concept[258].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[258].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[258].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[259].code, "WEN")
        self.assertEqual(inst.concept[259].map[0].code, "309075001")
        self.assertEqual(inst.concept[259].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[259].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[259].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[25].code, "BUB")
        self.assertEqual(inst.concept[25].map[0].code, "302795002")
        self.assertEqual(inst.concept[25].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[25].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[25].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[260].code, "WICK")
        self.assertEqual(inst.concept[260].map[0].comments, "TBD")
        self.assertEqual(inst.concept[260].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[260].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[260].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[261].code, "WND")
        self.assertEqual(inst.concept[261].map[0].code, "119365002")
        self.assertEqual(inst.concept[261].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[261].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[261].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[262].code, "WNDA")
        self.assertEqual(inst.concept[262].map[0].code, "119366001")
        self.assertEqual(inst.concept[262].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[262].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[262].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[263].code, "WNDD")
        self.assertEqual(inst.concept[263].map[0].code, "122566000")
        self.assertEqual(inst.concept[263].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[263].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[263].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[264].code, "WNDE")
        self.assertEqual(inst.concept[264].map[0].code, "122568004")
        self.assertEqual(inst.concept[264].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[264].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[264].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[265].code, "WORM")
        self.assertEqual(inst.concept[265].map[0].code, "258618008")
        self.assertEqual(inst.concept[265].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[265].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[265].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[266].code, "WRT")
        self.assertEqual(inst.concept[266].map[0].code, "309068002")
        self.assertEqual(inst.concept[266].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[266].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[266].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[267].code, "WWA")
        self.assertEqual(inst.concept[267].map[0].code, "119318008")
        self.assertEqual(inst.concept[267].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[267].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[267].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[268].code, "WWO")
        self.assertEqual(inst.concept[268].map[0].comments, "TBD")
        self.assertEqual(inst.concept[268].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[268].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[268].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[269].code, "WWT")
        self.assertEqual(inst.concept[269].map[0].comments, "TBD")
        self.assertEqual(inst.concept[269].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[269].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[269].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[26].code, "BULLA")
        self.assertEqual(inst.concept[26].map[0].code, "258482009")
        self.assertEqual(inst.concept[26].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[26].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[26].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[270].code, "CSITE")
        self.assertEqual(inst.concept[270].map[0].comments, "Prefer to have aspirate of the pus oozing out from cleaned insertion site - if swab is all that can be obtained, then swab after cleaning, otherwise you may get a contaminated specimen and a falsely identified infected central line. Do not just swab the reddened area - that will just collect skin flora")
        self.assertEqual(inst.concept[270].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[270].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[270].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[271].code, "CLIPP")
        self.assertEqual(inst.concept[271].map[0].comments, "Be more specific use either: 119326000^hair specimen, or 119327009^nail specimen")
        self.assertEqual(inst.concept[271].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[271].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[271].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[272].code, "SHU")
        self.assertEqual(inst.concept[272].map[0].comments, "assume swab from shunt site for mapping here - clean surface of skin prior to expressing the shunt site - preferred is aspiration with sterile syringe should use SPM.8 to specify body approximate match location of shunt site")
        self.assertEqual(inst.concept[272].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[272].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[272].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[27].code, "BX")
        self.assertEqual(inst.concept[27].map[0].code, "258415003")
        self.assertEqual(inst.concept[27].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[27].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[27].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[28].code, "CALC")
        self.assertEqual(inst.concept[28].map[0].code, "119350003")
        self.assertEqual(inst.concept[28].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[28].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[28].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[29].code, "CARBU")
        self.assertEqual(inst.concept[29].map[0].code, "309051001")
        self.assertEqual(inst.concept[29].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[29].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[29].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[2].code, "AIRS")
        self.assertEqual(inst.concept[2].map[0].code, "446302006")
        self.assertEqual(inst.concept[2].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[2].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[2].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[30].code, "CAT")
        self.assertEqual(inst.concept[30].map[0].code, "119311002")
        self.assertEqual(inst.concept[30].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[30].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[30].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[31].code, "CBITE")
        self.assertEqual(inst.concept[31].map[0].comments, "Submit for new term with parent 119365002")
        self.assertEqual(inst.concept[31].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[31].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[31].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[32].code, "CLIPP")
        self.assertEqual(inst.concept[32].map[0].code, "119327009")
        self.assertEqual(inst.concept[32].map[0].comments, "Be more specific use either: 119326000^hair specimen or 119327009^nail specimen")
        self.assertEqual(inst.concept[32].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[32].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[32].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[33].code, "CNJT")
        self.assertEqual(inst.concept[33].map[0].code, "119401005")
        self.assertEqual(inst.concept[33].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[33].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[33].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[34].code, "CNJT")
        self.assertEqual(inst.concept[34].map[0].code, "128160006")
        self.assertEqual(inst.concept[34].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[34].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[34].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[35].code, "CNJT")
        self.assertEqual(inst.concept[35].map[0].code, "258498002")
        self.assertEqual(inst.concept[35].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[35].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[35].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[36].code, "COL")
        self.assertEqual(inst.concept[36].map[0].code, "119329007")
        self.assertEqual(inst.concept[36].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[36].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[36].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[37].code, "CONE")
        self.assertEqual(inst.concept[37].map[0].code, "399713008")
        self.assertEqual(inst.concept[37].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[37].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[37].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[38].code, "CSCR")
        self.assertEqual(inst.concept[38].map[0].comments, "submit for new term with parent 119365002^Specimen from wound (specimen)")
        self.assertEqual(inst.concept[38].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[38].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[38].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[39].code, "CSERU")
        self.assertEqual(inst.concept[39].map[0].comments, "pending")
        self.assertEqual(inst.concept[39].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[39].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[39].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[3].code, "ALL")
        self.assertEqual(inst.concept[3].map[0].code, "119376003")
        self.assertEqual(inst.concept[3].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[3].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[3].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[40].code, "CSITE")
        self.assertEqual(inst.concept[40].map[0].code, "258507003")
        self.assertEqual(inst.concept[40].map[0].comments, "Prefer to have aspirate of the pus oozing out from cleaned insertion site - if swab is all that can be obtained, then swab after cleaning, otherwise you may get a contaminated specimen and a falsely identified infected central line. Do not just swab the reddened area - that will just collect skin flora       ")
        self.assertEqual(inst.concept[40].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[40].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[40].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[41].code, "CSMY")
        self.assertEqual(inst.concept[41].map[0].code, "309051001")
        self.assertEqual(inst.concept[41].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[41].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[41].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[42].code, "CST")
        self.assertEqual(inst.concept[42].map[0].code, "258453008")
        self.assertEqual(inst.concept[42].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[42].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[42].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[43].code, "CSVR")
        self.assertEqual(inst.concept[43].map[0].comments, "TBD - may use blood and SPM-6")
        self.assertEqual(inst.concept[43].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[43].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[43].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[44].code, "CTP")
        self.assertEqual(inst.concept[44].map[0].code, "119312009")
        self.assertEqual(inst.concept[44].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[44].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[44].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[44].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[45].code, "CVPS")
        self.assertEqual(inst.concept[45].map[0].code, "258507003")
        self.assertEqual(inst.concept[45].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[45].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[45].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[46].code, "CVPT")
        self.assertEqual(inst.concept[46].map[0].code, "119312009")
        self.assertEqual(inst.concept[46].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[46].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[46].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[46].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[47].code, "CYN")
        self.assertEqual(inst.concept[47].map[0].code, "119368000")
        self.assertEqual(inst.concept[47].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[47].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[47].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[48].code, "CYST")
        self.assertEqual(inst.concept[48].map[0].code, "119368000")
        self.assertEqual(inst.concept[48].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[48].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[48].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[49].code, "DBITE")
        self.assertEqual(inst.concept[49].map[0].comments, "Submit for new term with parent 119365002")
        self.assertEqual(inst.concept[49].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[49].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[49].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[4].code, "AMP")
        self.assertEqual(inst.concept[4].map[0].code, "408654003")
        self.assertEqual(inst.concept[4].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[4].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[4].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[50].code, "DCS")
        self.assertEqual(inst.concept[50].map[0].code, "119335007")
        self.assertEqual(inst.concept[50].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[50].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[50].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[51].code, "DEC")
        self.assertEqual(inst.concept[51].map[0].code, "258505006")
        self.assertEqual(inst.concept[51].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[51].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[51].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[52].code, "DEION")
        self.assertEqual(inst.concept[52].map[0].comments, "TBD")
        self.assertEqual(inst.concept[52].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[52].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[52].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[53].code, "DIA")
        self.assertEqual(inst.concept[53].map[0].code, "119360007")
        self.assertEqual(inst.concept[53].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[53].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[53].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[54].code, "DISCHG")
        self.assertEqual(inst.concept[54].map[0].code, "258439008")
        self.assertEqual(inst.concept[54].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[54].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[54].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[55].code, "DIV")
        self.assertEqual(inst.concept[55].map[0].code, "119376003")
        self.assertEqual(inst.concept[55].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[55].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[55].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[56].code, "DRN")
        self.assertEqual(inst.concept[56].map[0].code, "119306004")
        self.assertEqual(inst.concept[56].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[56].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[56].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[57].code, "DRNG")
        self.assertEqual(inst.concept[57].map[0].code, "258455001")
        self.assertEqual(inst.concept[57].map[0].comments, "Historical term - consider what is being drained and indicate that in SPM-4 instead: not an acceptible specimen for micro - not specific enough term")
        self.assertEqual(inst.concept[57].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[57].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[57].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[58].code, "DRNGP")
        self.assertEqual(inst.concept[58].map[0].code, "309051001")
        self.assertEqual(inst.concept[58].map[0].comments, "Historical term - consider what is being drained and indicate that in SPM-4 instead")
        self.assertEqual(inst.concept[58].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[58].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[58].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[59].code, "EARW")
        self.assertEqual(inst.concept[59].map[0].code, "122580007")
        self.assertEqual(inst.concept[59].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[59].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[59].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[5].code, "ANGI")
        self.assertEqual(inst.concept[5].map[0].code, "119312009")
        self.assertEqual(inst.concept[5].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[5].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[5].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[5].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[60].code, "EBRUSH")
        self.assertEqual(inst.concept[60].map[0].code, "309210009")
        self.assertEqual(inst.concept[60].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[60].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[60].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[61].code, "EEYE")
        self.assertEqual(inst.concept[61].map[0].comments, "TBD")
        self.assertEqual(inst.concept[61].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[61].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[61].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[62].code, "EFF")
        self.assertEqual(inst.concept[62].map[0].comments, "TBD")
        self.assertEqual(inst.concept[62].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[62].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[62].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[63].code, "EFFUS")
        self.assertEqual(inst.concept[63].map[0].code, "258440005")
        self.assertEqual(inst.concept[63].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[63].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[63].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[64].code, "EFOD")
        self.assertEqual(inst.concept[64].map[0].code, "119320006")
        self.assertEqual(inst.concept[64].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[64].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[64].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[65].code, "EISO")
        self.assertEqual(inst.concept[65].map[0].code, "258536003")
        self.assertEqual(inst.concept[65].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[65].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[65].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[66].code, "ELT")
        self.assertEqual(inst.concept[66].map[0].code, "119314005")
        self.assertEqual(inst.concept[66].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[66].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[66].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[67].code, "ENVIR")
        self.assertEqual(inst.concept[67].map[0].code, "119324002")
        self.assertEqual(inst.concept[67].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[67].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[67].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[68].code, "EOTH")
        self.assertEqual(inst.concept[68].map[0].comments, "TBD")
        self.assertEqual(inst.concept[68].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[68].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[68].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[69].code, "ESOI")
        self.assertEqual(inst.concept[69].map[0].comments, "TBD")
        self.assertEqual(inst.concept[69].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[69].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[69].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[6].code, "ARTC")
        self.assertEqual(inst.concept[6].map[0].code, "119312009")
        self.assertEqual(inst.concept[6].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[6].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[6].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[6].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[70].code, "ESOS")
        self.assertEqual(inst.concept[70].map[0].comments, "TBD")
        self.assertEqual(inst.concept[70].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[70].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[70].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[71].code, "ETA")
        self.assertEqual(inst.concept[71].map[0].code, "119307008")
        self.assertEqual(inst.concept[71].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[71].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[71].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[72].code, "ETTP")
        self.assertEqual(inst.concept[72].map[0].code, "119312009")
        self.assertEqual(inst.concept[72].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[72].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[72].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[72].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[73].code, "ETTUB")
        self.assertEqual(inst.concept[73].map[0].code, "119307008")
        self.assertEqual(inst.concept[73].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[73].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[73].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[74].code, "EWHI")
        self.assertEqual(inst.concept[74].map[0].comments, "TBD")
        self.assertEqual(inst.concept[74].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[74].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[74].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[75].code, "EXG")
        self.assertEqual(inst.concept[75].map[0].code, "119336008")
        self.assertEqual(inst.concept[75].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[75].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[75].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[76].code, "EXS")
        self.assertEqual(inst.concept[76].map[0].comments, "TBD")
        self.assertEqual(inst.concept[76].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[76].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[76].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[77].code, "EXUDTE")
        self.assertEqual(inst.concept[77].map[0].code, "258441009")
        self.assertEqual(inst.concept[77].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[77].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[77].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[78].code, "FAW")
        self.assertEqual(inst.concept[78].map[0].comments, "TBD")
        self.assertEqual(inst.concept[78].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[78].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[78].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[79].code, "FBLOOD")
        self.assertEqual(inst.concept[79].map[0].code, "119297000")
        self.assertEqual(inst.concept[79].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[79].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[79].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[7].code, "ASERU")
        self.assertEqual(inst.concept[7].map[0].comments, "pending")
        self.assertEqual(inst.concept[7].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[7].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[7].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[80].code, "FGA")
        self.assertEqual(inst.concept[80].map[0].code, "168139001")
        self.assertEqual(inst.concept[80].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[80].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[80].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[81].code, "FIST")
        self.assertEqual(inst.concept[81].map[0].code, "119370009")
        self.assertEqual(inst.concept[81].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[81].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[81].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[82].code, "FLD")
        self.assertEqual(inst.concept[82].map[0].code, "309051001")
        self.assertEqual(inst.concept[82].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[82].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[82].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[83].code, "FLT")
        self.assertEqual(inst.concept[83].map[0].comments, "TBD")
        self.assertEqual(inst.concept[83].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[83].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[83].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[84].code, "FLU")
        self.assertEqual(inst.concept[84].map[0].code, "309051001")
        self.assertEqual(inst.concept[84].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[84].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[84].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[85].code, "FLUID")
        self.assertEqual(inst.concept[85].map[0].code, "258442002")
        self.assertEqual(inst.concept[85].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[85].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[85].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[86].code, "FOLEY")
        self.assertEqual(inst.concept[86].map[0].code, "119312009")
        self.assertEqual(inst.concept[86].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[86].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[86].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[86].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[87].code, "FRS")
        self.assertEqual(inst.concept[87].map[0].code, "258442002")
        self.assertEqual(inst.concept[87].map[0].comments, "this term is not specific enough, choose from terms that more accurately describe the specimen")
        self.assertEqual(inst.concept[87].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[87].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[87].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[88].code, "FSCLP")
        self.assertEqual(inst.concept[88].map[0].code, "309502007")
        self.assertEqual(inst.concept[88].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[88].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[88].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[89].code, "FUR")
        self.assertEqual(inst.concept[89].map[0].code, "119295008")
        self.assertEqual(inst.concept[89].map[0].comments, "Further describe the sample as tissue or pus. or by the collection method. The term boil is not specifc to a body site - need to indicate source site (spm.8). preferred term is Aspirate_Boil")
        self.assertEqual(inst.concept[89].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[89].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[89].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[8].code, "ASP")
        self.assertEqual(inst.concept[8].map[0].code, "119295008")
        self.assertEqual(inst.concept[8].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[8].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[8].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[90].code, "GAS")
        self.assertEqual(inst.concept[90].map[0].code, "119317003")
        self.assertEqual(inst.concept[90].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[90].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[90].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[91].code, "GASA")
        self.assertEqual(inst.concept[91].map[0].code, "168137004")
        self.assertEqual(inst.concept[91].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[91].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[91].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[92].code, "GASAN")
        self.assertEqual(inst.concept[92].map[0].code, "119379005")
        self.assertEqual(inst.concept[92].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[92].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[92].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[93].code, "GASBR")
        self.assertEqual(inst.concept[93].map[0].code, "309213006")
        self.assertEqual(inst.concept[93].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[93].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[93].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[94].code, "GASD")
        self.assertEqual(inst.concept[94].map[0].code, "258459007")
        self.assertEqual(inst.concept[94].map[0].comments, "Historical term - consider what is being drained and indicate that in SPM-4 instead")
        self.assertEqual(inst.concept[94].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[94].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[94].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[95].code, "GAST")
        self.assertEqual(inst.concept[95].map[0].code, "258459007")
        self.assertEqual(inst.concept[95].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[95].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[95].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[96].code, "GENV")
        self.assertEqual(inst.concept[96].map[0].code, "119394009")
        self.assertEqual(inst.concept[96].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[96].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[96].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[97].code, "GRAFT")
        self.assertEqual(inst.concept[97].map[0].code, "440493002")
        self.assertEqual(inst.concept[97].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[97].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[97].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[98].code, "GRANU")
        self.assertEqual(inst.concept[98].map[0].code, "119376003")
        self.assertEqual(inst.concept[98].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[98].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[98].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[99].code, "GROSH")
        self.assertEqual(inst.concept[99].map[0].code, "119311002")
        self.assertEqual(inst.concept[99].map[0].comments, "TBD in detail")
        self.assertEqual(inst.concept[99].map[0].equivalence, "equivalent")
        self.assertEqual(inst.concept[99].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[99].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.concept[9].code, "ATTE")
        self.assertEqual(inst.concept[9].map[0].comments, "TBD")
        self.assertEqual(inst.concept[9].map[0].equivalence, "unmatched")
        self.assertEqual(inst.concept[9].map[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.concept[9].system, "http://hl7.org/fhir/v2/0487")
        self.assertEqual(inst.date.date, FHIRDate("2013-07-25").date)
        self.assertEqual(inst.date.isostring, "2013-07-25")
        self.assertFalse(inst.experimental)
        self.assertEqual(inst.identifier, "http://hl7.org/fhir/conceptmap-example-specimen-type.html")
        self.assertEqual(inst.name, "Specimen mapping from v2 table 0487 to SNOMED CT")
        self.assertEqual(inst.publisher, "FHIR project team (original source: LabMCoP)")
        self.assertEqual(inst.source.reference, "http://hl7.org/fhir/v2/vs/0487")
        self.assertEqual(inst.status, "draft")
        self.assertEqual(inst.target.reference, "http://snomed.info/id")
        self.assertEqual(inst.telecom[0].system, "url")
        self.assertEqual(inst.telecom[0].value, "http://hl7.org/fhir")
        self.assertEqual(inst.telecom[1].system, "url")
        self.assertEqual(inst.telecom[1].value, "http://www.phconnect.org/group/laboratorymessagingcommunityofpractice/forum/attachment/download?id=3649725%3AUploadedFile%3A145786")
        self.assertEqual(inst.text.div, "<div>\n      <h2>Specimen mapping from v2 table 0487 to SNOMED CT (http://hl7.org/fhir/conceptmap-example-specimen-type.html)</h2>\n      <p>Mapping from \n        <a href=\"v2/0487/index.html\">http://hl7.org/fhir/v2/vs/0487</a> to \n        <a href=\"http://snomed.info/id\">SNOMED-CT</a>\n      </p>\n      <p>Draft. Published on 25-Jul 2013 by FHIR project team (original source: LabMCoP) (\n        <a href=\"http://hl7.org/fhir\">http://hl7.org/fhir</a>, \n        <a href=\"http://www.phconnect.org/group/laboratorymessagingcommunityofpractice/forum/attachment/download?id=3649725%3AUploadedFile%3A145786\">http://www.phconnect.org/group...</a>). \n      </p>\n      <br/>\n      <table class=\"grid\">\n        <tr>\n          <td colspan=\"1\">\n            <b>Source Concept</b>\n          </td>\n          <td>\n            <b>Equivalence</b>\n          </td>\n          <td colspan=\"4\">\n            <b>Destination Concept</b>\n          </td>\n          <td>\n            <b>Comments</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <b>Code [http://hl7.org/fhir/v2/0487]</b>\n          </td>\n          <td/>\n          <td>\n            <b>Code [http://snomed.info/sct]</b>\n          </td>\n          <td>\n            <b>v2 SPM-7 [http://snomed.info/sct]</b>\n          </td>\n          <td>\n            <b>v2 SPM-8 [http://snomed.info/sct]</b>\n          </td>\n          <td>\n            <b>v2 SPM-5 [http://snomed.info/sct]</b>\n          </td>\n          <td/>\n        </tr>\n        <tr>\n          <td>ACNE (Tissue, Acne)</td>\n          <td>equivalent</td>\n          <td>309068002 (Skin lesion sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ACNFLD (Fluid, Acne)</td>\n          <td>equivalent</td>\n          <td>119323008 (Pus sample)</td>\n          <td/>\n          <td/>\n          <td>47002008 (Pustule)</td>\n          <td>HL7 term is a historical term. mapped to Pus</td>\n        </tr>\n        <tr>\n          <td>AIRS (Air Sample)</td>\n          <td>equivalent</td>\n          <td>446302006 (Air sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ALL (Allograft)</td>\n          <td>equivalent</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td>7970006 (Allograft)</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>AMP (Amputation)</td>\n          <td>equivalent</td>\n          <td>408654003 (Specimen obtained by amputation)</td>\n          <td>81723002 (Amputation)</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ANGI (Catheter Tip, Angio)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>ARTC (Catheter Tip, Arterial)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>ASERU (Serum, Acute)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>pending</td>\n        </tr>\n        <tr>\n          <td>ASP (Aspirate)</td>\n          <td>equivalent</td>\n          <td>119295008 (Aspirate)</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ATTE (Environment, Attest)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>AUTOC (Environmental, Autoclave Capsule)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>AUTP (Autopsy)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>This really is not a specimen per se - it is the state of the subject from whom the specimen is collected, so it should be used as a  specimen type modifier ONLY!. Often this is indicated with a special medical record number or other notation on the patient. needs to have specimen type (SPM-4) and source site (SPM.8) and spatial orientation (SPM.9)</td>\n        </tr>\n        <tr>\n          <td>BBL (Blood bag)</td>\n          <td>equivalent</td>\n          <td>119304001 (Blood bag specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BCYST (Cyst, Baker's)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td>32361000 (Popliteal fossa structure (body structure))</td>\n          <td/>\n          <td>submitted (PLR155) with parent of  167874004^knee joint synovial fluid (specimen), with specimen source topography 32361000^Popliteal fossa structure (body structure)</td>\n        </tr>\n        <tr>\n          <td>BITE (Bite)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>BLEB (Bleb)</td>\n          <td>equivalent</td>\n          <td>309049000 (Lesion sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>339008 (Blister (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BLIST (Blister)</td>\n          <td>equivalent</td>\n          <td>309049000 (Lesion sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>339008 (Blister (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BOIL (Boil)</td>\n          <td>equivalent</td>\n          <td>119295008 (Aspirate)</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td/>\n          <td>59843005 (Furuncle (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BON (Bone)</td>\n          <td>equivalent</td>\n          <td>430268003 (Specimen from bone (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BOWL (Bowel contents)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Don't use this term for human samples - use Stool instead. animal would use small intestinal contents, large intestinal contents</td>\n        </tr>\n        <tr>\n          <td>BPU (Blood product unit)</td>\n          <td>equivalent</td>\n          <td>119300005 (Specimen from blood product (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BRN (Burn)</td>\n          <td>equivalent</td>\n          <td>119367005 (Specimen from burn injury (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BRSH (Brush)</td>\n          <td>equivalent</td>\n          <td>258415003 (Biopsy sample (specimen))</td>\n          <td>439336003 (Brush biopsy (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BRTH (Breath (use EXHLD))</td>\n          <td>equivalent</td>\n          <td>119336008 (Exhaled air specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BRUS (Brushing)</td>\n          <td>equivalent</td>\n          <td>309176002 (Bronchial brushings sample (specimen))</td>\n          <td>80657008 (Bronchoscopy with brush biopsy (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>BUB (Bubo)</td>\n          <td>equivalent</td>\n          <td>302795002 (Lymph node aspirate (specimen))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td/>\n          <td>11585000 (Bubo (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BULLA (Bulla/Bullae)</td>\n          <td>equivalent</td>\n          <td>258482009 (Vesicle fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>339008 (Blister (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>BX (Biopsy)</td>\n          <td>equivalent</td>\n          <td>258415003 (Biopsy sample (specimen))</td>\n          <td>86273004 (Biopsy (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CALC (Calculus (=Stone))</td>\n          <td>equivalent</td>\n          <td>119350003 (Calculus specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CARBU (Carbuncle)</td>\n          <td>equivalent</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>41570003 (Carbuncle (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>CAT (Catheter)</td>\n          <td>equivalent</td>\n          <td>119311002 (Catheter specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CBITE (Bite, Cat)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>CLIPP (Clippings)</td>\n          <td>equivalent</td>\n          <td>119327009 (Nail specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>Be more specific use either: 119326000^hair specimen or 119327009^nail specimen</td>\n        </tr>\n        <tr>\n          <td>CNJT (Conjunctiva)</td>\n          <td>equivalent</td>\n          <td>119401005 (Specimen from conjunctiva (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CNJT (Conjunctiva)</td>\n          <td>equivalent</td>\n          <td>128160006 (Tissue specimen from conjunctiva (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CNJT (Conjunctiva)</td>\n          <td>equivalent</td>\n          <td>258498002 (Conjunctival swab (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>COL (Colostrum)</td>\n          <td>equivalent</td>\n          <td>119329007 (Colostrum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CONE (Biospy, Cone)</td>\n          <td>equivalent</td>\n          <td>399713008 (Specimen from uterine cervix obtained by cone biopsy (specimen))</td>\n          <td>54535009 (Cone biopsy of cervix (procedure))</td>\n          <td>71252005 (Cervix uteri structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CSCR (Scratch, Cat)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>submit for new term with parent 119365002^Specimen from wound (specimen)</td>\n        </tr>\n        <tr>\n          <td>CSERU (Serum, Convalescent)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>pending</td>\n        </tr>\n        <tr>\n          <td>CSITE (Catheter Insertion Site)</td>\n          <td>equivalent</td>\n          <td>258507003 (Swab of line insertion site (specimen))</td>\n          <td>285570007 (Taking of swab (procedure))</td>\n          <td/>\n          <td>386144009 (Line insertion site (morphologic abnormality))</td>\n          <td>Prefer to have aspirate of the pus oozing out from cleaned insertion site - if swab is all that can be obtained, then swab after cleaning, otherwise you may get a contaminated specimen and a falsely identified infected central line. Do not just swab the reddened area - that will just collect skin flora       </td>\n        </tr>\n        <tr>\n          <td>CSMY (Fluid,  Cystostomy Tube)</td>\n          <td>equivalent</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CST (Fluid, Cyst)</td>\n          <td>equivalent</td>\n          <td>258453008 (Cyst fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CSVR (Blood, Cell Saver)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD - may use blood and SPM-6</td>\n        </tr>\n        <tr>\n          <td>CTP (Catheter tip)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>CVPS (Site, CVP)</td>\n          <td>equivalent</td>\n          <td>258507003 (Swab of line insertion site (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>CVPT (Catheter Tip, CVP)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td>445085009 (Tunneled central venous catheter (physical object))</td>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>CYN (Nodule, Cystic)</td>\n          <td>equivalent</td>\n          <td>119368000 (Specimen from cyst (specimen))</td>\n          <td/>\n          <td/>\n          <td>27925004 (Nodule (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>CYST (Cyst)</td>\n          <td>equivalent</td>\n          <td>119368000 (Specimen from cyst (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DBITE (Bite, Dog)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>DCS (Sputum, Deep Cough)</td>\n          <td>equivalent</td>\n          <td>119335007 (Coughed sputum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DEC (Ulcer, Decubitus)</td>\n          <td>equivalent</td>\n          <td>258505006 (Skin ulcer swab (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DEION (Environmental, Water  (Deionized))</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>DIA (Dialysate)</td>\n          <td>equivalent</td>\n          <td>119360007 (Dialysis fluid specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DISCHG (Discharge)</td>\n          <td>equivalent</td>\n          <td>258439008 (Discharge specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DIV (Diverticulum)</td>\n          <td>equivalent</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td>31113003 (Diverticulum (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>DRN (Drain)</td>\n          <td>equivalent</td>\n          <td>119306004 (Drain device specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>DRNG (Drainage, Tube)</td>\n          <td>equivalent</td>\n          <td>258455001 (Drainage fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead: not an acceptible specimen for micro - not specific enough term</td>\n        </tr>\n        <tr>\n          <td>DRNGP (Drainage, Penrose)</td>\n          <td>equivalent</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>EARW (Ear wax (cerumen))</td>\n          <td>equivalent</td>\n          <td>122580007 (Cerumen specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EBRUSH (Brush, Esophageal)</td>\n          <td>equivalent</td>\n          <td>309210009 (Esophageal brushings sample (specimen))</td>\n          <td>36213007 (Endoscopy and brush biopsy (procedure))</td>\n          <td>32849002 (Esophageal structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EEYE (Environmental, Eye Wash)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>EFF (Environmental, Effluent)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>EFFUS (Effusion)</td>\n          <td>equivalent</td>\n          <td>258440005 (Effusion sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EFOD (Environmental, Food)</td>\n          <td>equivalent</td>\n          <td>119320006 (Food specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EISO (Environmental, Isolette)</td>\n          <td>equivalent</td>\n          <td>258536003 (Incubator swab (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ELT (Electrode)</td>\n          <td>equivalent</td>\n          <td>119314005 (Electrode specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ENVIR (Environmental, Unidentified Substance)</td>\n          <td>equivalent</td>\n          <td>119324002 (Specimen of unknown material (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EOTH (Environmental, Other Substance)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>ESOI (Environmental, Soil)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>ESOS (Environmental, Solution (Sterile))</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>ETA (Aspirate,  Endotrach)</td>\n          <td>equivalent</td>\n          <td>119307008 (Specimen from endotracheal tube (specimen))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td>321667001 (Respiratory tract)</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ETTP (Catheter Tip, Endotracheal)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>ETTUB (Tube, Endotracheal)</td>\n          <td>equivalent</td>\n          <td>119307008 (Specimen from endotracheal tube (specimen))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td>321667001 (Respiratory tract)</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EWHI (Environmental, Whirlpool)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>EXG (Gas, exhaled (=breath))</td>\n          <td>equivalent</td>\n          <td>119336008 (Exhaled air specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>EXS (Shunt, External)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>EXUDTE (Exudate)</td>\n          <td>equivalent</td>\n          <td>258441009 (Exudate sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FAW (Environmental, Water  (Well))</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>FBLOOD (Blood, Fetal)</td>\n          <td>equivalent</td>\n          <td>119297000 (Blood specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td>303112003 (Fetal period (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>FGA (Fluid,  Abdomen)</td>\n          <td>equivalent</td>\n          <td>168139001 (Peritoneal fluid sample (specimen))</td>\n          <td/>\n          <td>83670000 (Peritoneal cavity structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FIST (Fistula)</td>\n          <td>equivalent</td>\n          <td>119370009 (Specimen from fistula (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FLD (Fluid, Other)</td>\n          <td>equivalent</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FLT (Filter)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>FLU (Fluid, Body unsp)</td>\n          <td>equivalent</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FLUID (Fluid)</td>\n          <td>equivalent</td>\n          <td>258442002 (Fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FOLEY (Catheter Tip, Foley)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>FRS (Fluid, Respiratory)</td>\n          <td>equivalent</td>\n          <td>258442002 (Fluid sample (specimen))</td>\n          <td/>\n          <td>272626006 (Respiratory organ (body structure))</td>\n          <td/>\n          <td>this term is not specific enough, choose from terms that more accurately describe the specimen</td>\n        </tr>\n        <tr>\n          <td>FSCLP (Scalp, Fetal)</td>\n          <td>equivalent</td>\n          <td>309502007 (Fetus specimen (specimen))</td>\n          <td/>\n          <td>41695006 (Scalp structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>FUR (Furuncle)</td>\n          <td>equivalent</td>\n          <td>119295008 (Aspirate)</td>\n          <td/>\n          <td/>\n          <td>59843005 (Furuncle (morphologic abnormality))</td>\n          <td>Further describe the sample as tissue or pus. or by the collection method. The term boil is not specifc to a body site - need to indicate source site (spm.8). preferred term is Aspirate_Boil</td>\n        </tr>\n        <tr>\n          <td>GAS (Gas)</td>\n          <td>equivalent</td>\n          <td>119317003 (Gaseous material specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GASA (Aspirate, Gastric)</td>\n          <td>equivalent</td>\n          <td>168137004 (Gastric aspirate sample (specimen))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GASAN (Antrum, Gastric)</td>\n          <td>equivalent</td>\n          <td>119379005 (Specimen from stomach (specimen))</td>\n          <td/>\n          <td>66051006 (Pyloric antrum structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GASBR (Brushing, Gastric)</td>\n          <td>equivalent</td>\n          <td>309213006 (Gastric brushings sample (specimen))</td>\n          <td>235157009 (Endoscopic brushings of gastrointestinal tract (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GASD (Drainage, Gastric)</td>\n          <td>equivalent</td>\n          <td>258459007 (Gastric fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>GAST (Fluid/contents, Gastric)</td>\n          <td>equivalent</td>\n          <td>258459007 (Gastric fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GENV (Genital vaginal)</td>\n          <td>equivalent</td>\n          <td>119394009 (Specimen from vagina)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GRAFT (Graft)</td>\n          <td>equivalent</td>\n          <td>440493002 (Graft specimen from patient (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GRANU (Granuloma)</td>\n          <td>equivalent</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td>45647009 (Granuloma (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>GROSH (Catheter, Groshong)</td>\n          <td>equivalent</td>\n          <td>119311002 (Catheter specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>GSOL (Solution, Gastrostomy)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>GSPEC (Biopsy, Gastric)</td>\n          <td>equivalent</td>\n          <td>309211008 (Gastric biopsy sample (specimen))</td>\n          <td>79121003 (Biopsy of stomach (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>GT (Tube, Gastric)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>GTUBE (Drainage Tube, Drainage (Gastrostomy))</td>\n          <td>equivalent</td>\n          <td>258459007 (Gastric fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td>127490009 (Gastrostomy route (qualifier value))</td>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>HBITE (Bite, Human)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>HBLUD (Blood, Autopsy)</td>\n          <td>equivalent</td>\n          <td>119297000 (Blood specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td>303113008 (Postmortem period (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>HEMAQ (Catheter Tip, Hemaquit)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>HEMO (Catheter Tip, Hemovac)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>HERNI (Tissue, Herniated)</td>\n          <td>equivalent</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>HEV (Drain, Hemovac)</td>\n          <td>equivalent</td>\n          <td>119306004 (Drain device specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>HIC (Catheter, Hickman)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td>445085009 (Tunneled central venous catheter (physical object))</td>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>HYDC (Fluid, Hydrocele)</td>\n          <td>equivalent</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>55434001 (Hydrocele (disorder))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>IBITE (Bite, Insect)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent 119365002</td>\n        </tr>\n        <tr>\n          <td>ICYST (Cyst, Inclusion)</td>\n          <td>equivalent</td>\n          <td>309075001 (Skin cyst sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>IDC (Catheter Tip, Indwelling)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>IHG (Gas, Inhaled)</td>\n          <td>equivalent</td>\n          <td>119337004 (Inhaled gas specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ILEO (Drainage, Ileostomy)</td>\n          <td>equivalent</td>\n          <td>258455001 (Drainage fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td>419954003 (Ileostomy route (qualifier value))</td>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample</td>\n        </tr>\n        <tr>\n          <td>ILLEG (Source of Specimen Is Illegible)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>IMP (Implant)</td>\n          <td>equivalent</td>\n          <td>439961009 (Implant submitted as specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>INCI (Site, Incision/Surgical)</td>\n          <td>equivalent</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>INFIL (Infiltrate)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>This describes a morphologic abnormality, not a sample</td>\n        </tr>\n        <tr>\n          <td>INS (Insect)</td>\n          <td>equivalent</td>\n          <td>258614005 (Insect sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>INTRD (Catheter Tip, Introducer)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>IT (Intubation tube)</td>\n          <td>equivalent</td>\n          <td>119307008 (Specimen from endotracheal tube (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>IUD (Intrauterine Device)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>pending</td>\n        </tr>\n        <tr>\n          <td>IVCAT (Catheter Tip, IV)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td>255560000 (Intravenous (qualifier value))</td>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>IVFLD (Fluid, IV)</td>\n          <td>equivalent</td>\n          <td>258649003 (Intravenous infusion fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>IVTIP (Tubing Tip, IV)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>JEJU (Drainage, Jejunal)</td>\n          <td>equivalent</td>\n          <td>258463000 (Jejunal fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>21306003 (Jejunal structure (body structure))</td>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample</td>\n        </tr>\n        <tr>\n          <td>JNTFLD (Fluid, Joint)</td>\n          <td>equivalent</td>\n          <td>119332005 (Synovial fluid specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>JP (Drainage, Jackson Pratt)</td>\n          <td>equivalent</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>KELOI (Lavage)</td>\n          <td>equivalent</td>\n          <td>440674008 (Specimen obtained by lavage (specimen))</td>\n          <td>67889009 (Lavage)</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>KIDFLD (Fluid, Kidney)</td>\n          <td>equivalent</td>\n          <td>309051001 (Body fluid sample (specimen))</td>\n          <td/>\n          <td>64033007 (Kidney structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LAVG (Lavage, Bronhial)</td>\n          <td>equivalent</td>\n          <td>258607008 (Bronchoalveolar lavage fluid sample (specimen))</td>\n          <td>397394009 (Bronchoalveolar lavage (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LAVGG (Lavage, Gastric)</td>\n          <td>equivalent</td>\n          <td>168138009 (Gastric lavage aspirate sample)</td>\n          <td>173830003 (Gastric lavage (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LAVGP (Lavage, Peritoneal)</td>\n          <td>equivalent</td>\n          <td>440137008 (Specimen obtained by peritoneal lavage (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LAVPG (Lavage, Pre-Bronch)</td>\n          <td>equivalent</td>\n          <td>440674008 (Specimen obtained by lavage (specimen))</td>\n          <td>67889009 (Lavage)</td>\n          <td>44567001 (Tracheal structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LENS1 (Contact Lens)</td>\n          <td>equivalent</td>\n          <td>440473005 (Contact lens submitted as specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LENS2 (Contact Lens Case)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>LESN (Lesion)</td>\n          <td>equivalent</td>\n          <td>309049000 (Lesion sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>should be more specific what kind of lesion is observed - be more specific is it a wound, abscess, mass - specify! Ask SNOMED CT to mark it as a grouper term only (309049000)</td>\n        </tr>\n        <tr>\n          <td>LIQ (Liquid, Unspecified)</td>\n          <td>equivalent</td>\n          <td>258442002 (Fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>LIQO (Liquid, Other)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>LSAC (Fluid, Lumbar Sac)</td>\n          <td>equivalent</td>\n          <td>258450006 (Cerebrospinal fluid sample (specimen))</td>\n          <td/>\n          <td>303949008 (Lumbar spinal cerebrospinal fluid pathway (body structure))</td>\n          <td/>\n          <td>The HL7 term is a historical term Mapped to CSF obtained by lumbar puncture</td>\n        </tr>\n        <tr>\n          <td>MAHUR (Catheter Tip, Makurkour)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>MASS (Mass)</td>\n          <td>equivalent</td>\n          <td>420548004 (Specimen from mass lesion (specimen))</td>\n          <td/>\n          <td/>\n          <td>4147007 (Mass (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>MBLD (Blood, Menstrual)</td>\n          <td>equivalent</td>\n          <td>119345009 (Menstrual blood specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>MUCOS (Mucosa)</td>\n          <td>equivalent</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td>414781009 (Mucous membrane structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>MUCUS (Mucus)</td>\n          <td>equivalent</td>\n          <td>258483004 (Mucus sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>NASDR (Drainage, Nasal)</td>\n          <td>equivalent</td>\n          <td>258474009 (Sinus fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>2095001 (Nasal sinus structure (body structure))</td>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>NEDL (Needle)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>NEPH (Site, Nephrostomy)</td>\n          <td>equivalent</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>NGASP (Aspirate, Nasogastric)</td>\n          <td>equivalent</td>\n          <td>302794003 (Nasogastric aspirate (specimen))</td>\n          <td>6853008 (Nasogastric tube aspiration (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>NGAST (Drainage, Nasogastric)</td>\n          <td>equivalent</td>\n          <td>258459007 (Gastric fluid sample (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>69695003 (Stomach structure (body structure))</td>\n          <td>127492001 (Nasogastric route (qualifier value))</td>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>NGS (Site, Naso/Gastric)</td>\n          <td>equivalent</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>NODUL (Nodule(s))</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>pending</td>\n        </tr>\n        <tr>\n          <td>NSECR (Secretion, Nasal)</td>\n          <td>equivalent</td>\n          <td>168141000 (Nasal fluid sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ORH (Other)</td>\n          <td>equivalent</td>\n          <td>123038009 (Specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>ORL (Lesion, Oral)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td>74262004 (Oral cavity)</td>\n          <td/>\n          <td>be more precise use ulcer, tumor, vesicle</td>\n        </tr>\n        <tr>\n          <td>OTH (Source, Other)</td>\n          <td>equivalent</td>\n          <td>123038009 (Specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PACEM (Pacemaker)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>PCFL (Fluid, Pericardial)</td>\n          <td>equivalent</td>\n          <td>122571007 (Pericardial fluid specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PDSIT (Site, Peritoneal Dialysis)</td>\n          <td>equivalent</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PDTS (Site, Peritoneal Dialysis Tunnel)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>submitted for code</td>\n        </tr>\n        <tr>\n          <td>PELVA (Abscess, Pelvic)</td>\n          <td>equivalent</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>12921003 (Pelvic structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PENIL (Lesion, Penile)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td>18911002 (Penile structure (body structure))</td>\n          <td/>\n          <td>need to know what kind of lesion, so map to: UlcerTissue_penile, VesicleFluid_penile, Wound_penile, Mass tissue_penile, Necrotic tissue_penile, AbscessAspirate_penile, Anything else?</td>\n        </tr>\n        <tr>\n          <td>PERIA (Abscess, Perianal)</td>\n          <td>equivalent</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>397158004 (Perianal region structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PILOC (Cyst, Pilonidal)</td>\n          <td>equivalent</td>\n          <td>119368000 (Specimen from cyst (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PINS (Site, Pin)</td>\n          <td>equivalent</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PIS (Site, Pacemaker Insetion)</td>\n          <td>equivalent</td>\n          <td>258507003 (Swab of line insertion site (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PLAN (Plant Material)</td>\n          <td>equivalent</td>\n          <td>119301009 (Plant specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PLAS (Plasma)</td>\n          <td>equivalent</td>\n          <td>119361006 (Plasma specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PLB (Plasma bag)</td>\n          <td>equivalent</td>\n          <td>119305000 (Plasma bag specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PLEVS (Serum, Peak Level)</td>\n          <td>equivalent</td>\n          <td>119364003 (Serum specimen)</td>\n          <td/>\n          <td/>\n          <td>255587001 (Peak (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>PND (Drainage, Penile)</td>\n          <td>equivalent</td>\n          <td>258439008 (Discharge specimen (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>13648007 (Urethral structure (body structure))</td>\n          <td/>\n          <td>Historical term -though in this case more often used for discharge</td>\n        </tr>\n        <tr>\n          <td>POL (Polyps)</td>\n          <td>equivalent</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td>41329004 (Polyp (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>POPGS (Graft Site, Popliteal)</td>\n          <td>equivalent</td>\n          <td>440493002 (Graft specimen from patient (specimen))</td>\n          <td/>\n          <td>6902008 (Popliteal region structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>POPLG (Graft, Popliteal)</td>\n          <td>equivalent</td>\n          <td>440493002 (Graft specimen from patient (specimen))</td>\n          <td/>\n          <td>6902008 (Popliteal region structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>POPLV (Site, Popliteal Vein)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>PORTA (Catheter, Porta)</td>\n          <td>equivalent</td>\n          <td>119311002 (Catheter specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>PPP (Plasma, Platelet poor)</td>\n          <td>equivalent</td>\n          <td>119362004 (Platelet poor plasma specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PROST (Prosthetic Device)</td>\n          <td>equivalent</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PRP (Plasma, Platelet rich)</td>\n          <td>equivalent</td>\n          <td>119363009 (Platelet rich plasma specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PSC (Pseudocyst)</td>\n          <td>equivalent</td>\n          <td>119368000 (Specimen from cyst (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PUNCT (Wound, Puncture)</td>\n          <td>equivalent</td>\n          <td>119365002 (Specimen from wound (specimen))</td>\n          <td/>\n          <td/>\n          <td>129300006 (Puncture - action (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>PUS (Pus)</td>\n          <td>equivalent</td>\n          <td>119323008 (Pus sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>PUSFR (Pustule)</td>\n          <td>equivalent</td>\n          <td>119323008 (Pus sample)</td>\n          <td/>\n          <td/>\n          <td>47002008 (Pustule)</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>PUST (Pus)</td>\n          <td>equivalent</td>\n          <td>119323008 (Pus sample)</td>\n          <td/>\n          <td/>\n          <td>47002008 (Pustule)</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>QC3 (Quality Control)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>RANDU (Urine, Random)</td>\n          <td>equivalent</td>\n          <td>278020009 (Spot urine sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>RBITE (Bite, Reptile)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Submit for new term with parent: 119365002</td>\n        </tr>\n        <tr>\n          <td>RECT (Drainage, Rectal)</td>\n          <td>equivalent</td>\n          <td>119339001 (Stool specimen (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td>34402009 (Rectum structure (body structure))</td>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead: stool is what is expected, should use stool sample</td>\n        </tr>\n        <tr>\n          <td>RECTA (Abscess, Rectal)</td>\n          <td>equivalent</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>34402009 (Rectum structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>RENALC (Cyst, Renal)</td>\n          <td>equivalent</td>\n          <td>258420003 (Cyst tissue (specimen))</td>\n          <td/>\n          <td>64033007 (Kidney structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>RENC (Fluid, Renal Cyst)</td>\n          <td>equivalent</td>\n          <td>258453008 (Cyst fluid sample (specimen))</td>\n          <td/>\n          <td>64033007 (Kidney structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>RES (Respiratory)</td>\n          <td>equivalent</td>\n          <td>258603007 (Respiratory sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SAL (Saliva)</td>\n          <td>equivalent</td>\n          <td>119342007 (Saliva specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SCAR (Tissue, Keloid (Scar))</td>\n          <td>equivalent</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SCLV (Catheter Tip, Subclavian)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td>9454009 (Structure of subclavian vein (body structure))</td>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>SCROA (Abscess, Scrotal)</td>\n          <td>equivalent</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>20233005 (Scrotal structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SECRE (Secretion(s))</td>\n          <td>equivalent</td>\n          <td>432825001 (Body secretion specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SER (Serum)</td>\n          <td>equivalent</td>\n          <td>119364003 (Serum specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SHU (Site, Shunt)</td>\n          <td>equivalent</td>\n          <td>119295008 (Aspirate)</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td/>\n          <td>257351008 (Shunt (physical object))</td>\n          <td>Preferred is aspiration with sterile syringe from inflamed area. Specify body location of shunt site</td>\n        </tr>\n        <tr>\n          <td>SHUNF (Fluid, Shunt)</td>\n          <td>equivalent</td>\n          <td>446861007 (Cerebrospinal fluid specimen obtained via ventriculoperitoneal shunt (specimen))</td>\n          <td>446860008 (Collection of cerebrospinal fluid via ventriculoperitoneal shunt (procedure))</td>\n          <td>279107003 (Central nervous system space (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SHUNT (Shunt)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SITE (Site)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SKBP (Biopsy, Skin)</td>\n          <td>equivalent</td>\n          <td>309066003 (Skin biopsy sample (specimen))</td>\n          <td>240977001 (Biopsy of skin)</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SKN (Skin)</td>\n          <td>equivalent</td>\n          <td>119325001 (Skin (tissue) specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SMM (Mass, Sub-Mandibular)</td>\n          <td>equivalent</td>\n          <td>420548004 (Specimen from mass lesion (specimen))</td>\n          <td/>\n          <td/>\n          <td>4147007 (Mass (morphologic abnormality))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>SNV (Fluid, synovial (Joint fluid))</td>\n          <td>equivalent</td>\n          <td>119332005 (Synovial fluid specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPRM (Spermatozoa)</td>\n          <td>equivalent</td>\n          <td>119349003 (Spermatozoa specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPRP (Catheter Tip, Suprapubic)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>SPRPB (Cathether Tip, Suprapubic)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>SPS (Environmental, Spore Strip)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SPT (Sputum)</td>\n          <td>equivalent</td>\n          <td>119334006 (Sputum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPTC (Sputum - coughed)</td>\n          <td>equivalent</td>\n          <td>119335007 (Coughed sputum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPTT (Sputum - tracheal aspirate)</td>\n          <td>equivalent</td>\n          <td>258609006 (Sputum specimen obtained by aspiration from trachea (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPUT1 (Sputum, Simulated)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SPUTIN (Sputum, Inducted)</td>\n          <td>equivalent</td>\n          <td>258610001 (Sputum specimen obtained by sputum induction (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SPUTSP (Sputum, Spontaneous)</td>\n          <td>equivalent</td>\n          <td>119335007 (Coughed sputum specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>STER (Environmental, Sterrad)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>STL (Stool = Fecal)</td>\n          <td>equivalent</td>\n          <td>119339001 (Stool specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>STONE (Stone, Kidney)</td>\n          <td>equivalent</td>\n          <td>119350003 (Calculus specimen (specimen))</td>\n          <td/>\n          <td>64033007 (Kidney structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SUBMA (Abscess, Submandibular)</td>\n          <td>equivalent</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>5713008 (Submandibular triangle structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SUBMX (Abscess, Submaxillary)</td>\n          <td>equivalent</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>4335006 (Upper jaw region structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SUMP (Drainage, Sump)</td>\n          <td>equivalent</td>\n          <td>446562005 (Body fluid specimen obtained via sump drain (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td>Historical term - consider what is being drained and indicate that in SPM-4 instead</td>\n        </tr>\n        <tr>\n          <td>SUP (Suprapubic Tap)</td>\n          <td>equivalent</td>\n          <td>122575003 (Urine sample)</td>\n          <td>58088002 (Urine specimen collection, suprapubic (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>SUTUR (Suture)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>SWGZ (Catheter Tip, Swan Gantz)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>TASP (Aspirate, Tracheal)</td>\n          <td>equivalent</td>\n          <td>122877000 (Upper respiratory fluid specimen obtained by tracheal aspiration (specimen))</td>\n          <td>129112001 (Aspiration from trachea (procedure))</td>\n          <td>44567001 (Tracheal structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TISS (Tissue)</td>\n          <td>equivalent</td>\n          <td>119376003 (Tissue specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TISU (Tissue ulcer)</td>\n          <td>equivalent</td>\n          <td>122593002 (Tissue specimen obtained from ulcer (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TLC (Cathether Tip, Triple Lumen)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>TRAC (Site, Tracheostomy)</td>\n          <td>equivalent</td>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TRANS (Transudate)</td>\n          <td>equivalent</td>\n          <td>258538002 (Transudate sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TSERU (Serum, Trough)</td>\n          <td>equivalent</td>\n          <td>119364003 (Serum specimen)</td>\n          <td/>\n          <td/>\n          <td>255588006 (Trough (qualifier value))</td>\n          <td/>\n        </tr>\n        <tr>\n          <td>TSTES (Abscess, Testicular)</td>\n          <td>equivalent</td>\n          <td>119371008 (Specimen from abscess (specimen))</td>\n          <td/>\n          <td>279572002 (Testicular structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TTRA (Aspirate, Transtracheal)</td>\n          <td>equivalent</td>\n          <td>258480001 (Transtracheal aspirate sample (specimen))</td>\n          <td>129112001 (Aspiration from trachea (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TUBES (Tubes)</td>\n          <td>equivalent</td>\n          <td>119310001 (Tube specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TUMOR (Tumor)</td>\n          <td>equivalent</td>\n          <td>258435002 (Tumor tissue sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>TZANC (Smear, Tzanck)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>This is the name of a lab test. A skin sample is examined for viral inclusions.</td>\n        </tr>\n        <tr>\n          <td>UDENT (Source, Unidentified)</td>\n          <td>equivalent</td>\n          <td>123038009 (Specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>UR (Urine)</td>\n          <td>equivalent</td>\n          <td>122575003 (Urine sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URC (Urine clean catch)</td>\n          <td>equivalent</td>\n          <td>122880004 (Urine specimen obtained by clean catch procedure (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URINB (Urine, Bladder Washings)</td>\n          <td>equivalent</td>\n          <td>122575003 (Urine sample)</td>\n          <td>78533007 (Irrigation of urinary bladder (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URINC (Urine, Catheterized)</td>\n          <td>equivalent</td>\n          <td>446846006 (Urine specimen obtained via indwelling urinary catheter (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URINM (Urine, Midstream)</td>\n          <td>equivalent</td>\n          <td>258574006 (Mid-stream urine sample (specimen))</td>\n          <td>225271002 (Collection of mid-stream specimen of urine (procedure))</td>\n          <td>431938005 (Structure of urinary tract proper (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URINN (Urine, Nephrostomy)</td>\n          <td>equivalent</td>\n          <td>446277003 (Urine specimen obtained from nephrostomy tube after percutaneous insertion (specimen))</td>\n          <td>225109005 (Collection of nephrostomy urine specimen (procedure))</td>\n          <td>25990002 (Renal pelvis structure (body structure))</td>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>URINP (Urine, Pedibag)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>URT (Urine catheter)</td>\n          <td>equivalent</td>\n          <td>122565001 (Urinary catheter specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>USCOP (Urine, Cystoscopy)</td>\n          <td>unmatched</td>\n          <td/>\n          <td>176178006 (Diagnostic cystoscopy (procedure))</td>\n          <td>89837001 (Urinary bladder structure (body structure))</td>\n          <td/>\n          <td>NEW specimenTERM 7</td>\n        </tr>\n        <tr>\n          <td>USPEC (Source, Unspecified)</td>\n          <td>equivalent</td>\n          <td>123038009 (Specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>VASTIP (Catheter Tip, Vas)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>VENT (Catheter Tip, Ventricular)</td>\n          <td>equivalent</td>\n          <td>119312009 (Catheter tip specimen)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD in detail</td>\n        </tr>\n        <tr>\n          <td>VITF (Vitreous Fluid)</td>\n          <td>equivalent</td>\n          <td>258438000 (Vitreous humor sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>VOM (Vomitus)</td>\n          <td>equivalent</td>\n          <td>122572000 (Vomitus specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WASH (Wash)</td>\n          <td>equivalent</td>\n          <td>440674008 (Specimen obtained by lavage (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WASI (Washing, e.g. bronchial washing)</td>\n          <td>equivalent</td>\n          <td>122609004 (Specimen from lung obtained by bronchial washing procedure (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WAT (Water)</td>\n          <td>equivalent</td>\n          <td>119318008 (Water specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WB (Blood, Whole)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>Bloodbanking term ONLY now map to blood and the respective preservative</td>\n        </tr>\n        <tr>\n          <td>WEN (Wen)</td>\n          <td>equivalent</td>\n          <td>309075001 (Skin cyst sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WICK (Wick)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>WND (Wound)</td>\n          <td>equivalent</td>\n          <td>119365002 (Specimen from wound (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WNDA (Wound abscess)</td>\n          <td>equivalent</td>\n          <td>119366001 (Specimen from wound abscess (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WNDD (Wound drainage)</td>\n          <td>equivalent</td>\n          <td>122566000 (Fluid specimen from wound (specimen))</td>\n          <td>122462000 (Drainage procedure (procedure))</td>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WNDE (Wound exudate)</td>\n          <td>equivalent</td>\n          <td>122568004 (Exudate specimen from wound (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WORM (Worm)</td>\n          <td>equivalent</td>\n          <td>258618008 (Helminth sample (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WRT (Wart)</td>\n          <td>equivalent</td>\n          <td>309068002 (Skin lesion sample)</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WWA (Environmental, Water)</td>\n          <td>equivalent</td>\n          <td>119318008 (Water specimen (specimen))</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n        </tr>\n        <tr>\n          <td>WWO (Environmental, Water (Ocean))</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>WWT (Environmental, Water  (Tap))</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td/>\n          <td>TBD</td>\n        </tr>\n        <tr>\n          <td>CSITE (Catheter Insertion Site)</td>\n          <td>unmatched</td>\n          <td/>\n          <td>386144009 (Line insertion site (morphologic abnormality))</td>\n          <td>14766002 (Aspiration (procedure))</td>\n          <td>119295008 (Aspirate)</td>\n          <td>Prefer to have aspirate of the pus oozing out from cleaned insertion site - if swab is all that can be obtained, then swab after cleaning, otherwise you may get a contaminated specimen and a falsely identified infected central line. Do not just swab the reddened area - that will just collect skin flora</td>\n        </tr>\n        <tr>\n          <td>CLIPP (Clippings)</td>\n          <td>unmatched</td>\n          <td/>\n          <td/>\n          <td/>\n          <td>119326000 (Hair specimen (specimen))</td>\n          <td>Be more specific use either: 119326000^hair specimen, or 119327009^nail specimen</td>\n        </tr>\n        <tr>\n          <td>SHU (Site, Shunt)</td>\n          <td>unmatched</td>\n          <td/>\n          <td>257351008 (Shunt (physical object))</td>\n          <td/>\n          <td>438660002 (Specimen from prosthetic device (specimen))</td>\n          <td>assume swab from shunt site for mapping here - clean surface of skin prior to expressing the shunt site - preferred is aspiration with sterile syringe should use SPM.8 to specify body approximate match location of shunt site</td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.version, "20130725")

