#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 0.0.82.2943 (xds-profile.profile.json) on 2014-10-31.
#  2014, SMART Platforms.


import io
import unittest
import json
from medicationprescription import MedicationPrescription
from fhirdate import FHIRDate


class MedicationPrescriptionTests(unittest.TestCase):
    def instantiate_from(self, filename):
        with io.open(filename, 'r', encoding='utf-8') as handle:
            js = json.load(handle)
        instance = MedicationPrescription(js)
        self.assertIsNotNone(instance, "Must have instantiated a test instance")
        return instance
    
    def testMedicationPrescription1(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/medicationprescription-example-f001-combivent.json")
        self.assertIsNotNone(inst, "Must have instantiated a MedicationPrescription instance")
    
        self.assertEqual(inst.dateWritten.date, FHIRDate("2013-05-25T19:32:52+01:00").date)
        self.assertEqual(inst.dateWritten.isostring, "2013-05-25T19:32:52+01:00")
        self.assertEqual(inst.dispense.numberOfRepeatsAllowed, 20)
        self.assertEqual(inst.dispense.quantity.code, "ug")
        self.assertEqual(inst.dispense.quantity.system, "urn:oid:2.16.840.1.113883.6.8")
        self.assertEqual(inst.dispense.quantity.units, "mcg")
        self.assertEqual(inst.dispense.quantity.value, 100)
        self.assertEqual(inst.dispense.validityPeriod.end.date, FHIRDate("2013-05-30").date)
        self.assertEqual(inst.dispense.validityPeriod.end.isostring, "2013-05-30")
        self.assertEqual(inst.dispense.validityPeriod.start.date, FHIRDate("2013-04-08").date)
        self.assertEqual(inst.dispense.validityPeriod.start.isostring, "2013-04-08")
        self.assertEqual(inst.dosageInstruction[0].additionalInstructions.text, "for use during pregnancy, contact physician")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.code, "ml")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.units, "ml")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.value, 10)
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].code, "394899003")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].display, "oral administration of treatment")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].code, "181220002")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].display, "Entire oral cavity")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].text, "3 tot 4 maal daags 1 flacon")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].end.date, FHIRDate("2013-11-05").date)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].end.isostring, "2013-11-05")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.date, FHIRDate("2013-08-04").date)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.isostring, "2013-08-04")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.duration, 1)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.frequency, 3)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.units, "d")
        self.assertEqual(inst.encounter.display, "visit who leads to this priscription")
        self.assertEqual(inst.encounter.reference, "Encounter/f001")
        self.assertEqual(inst.identifier[0].system, "http://www.bmc/portal/prescriptions")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "order9837293")
        self.assertEqual(inst.medication.display, "prescribed medication")
        self.assertEqual(inst.medication.reference, "Medication/f001")
        self.assertEqual(inst.patient.display, "P. van den Heuvel")
        self.assertEqual(inst.patient.reference, "Patient/f001")
        self.assertEqual(inst.prescriber.display, "R.A. van den Berk")
        self.assertEqual(inst.prescriber.reference, "Practitioner/f006")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].code, "13645005")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].display, "Chronic obstructive pulmonary disease")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: order9837293 (official)\n      </p>\n      <p>\n        <b>dateWritten</b>: 25-May 2013 19:32\n      </p>\n      <p>\n        <b>status</b>: active\n      </p>\n      <p>\n        <b>patient</b>: P. van den Heuvel\n      </p>\n      <p>\n        <b>prescriber</b>: R.A. van den Berk\n      </p>\n      <p>\n        <b>encounter</b>: visit who leads to this priscription\n      </p>\n      <p>\n        <b>reason[x]</b>: \n        <span title=\"Codes: {http://snomed.info/sct 13645005}\">Chronic obstructive pulmonary disease</span>\n      </p>\n      <p>\n        <b>medication</b>: prescribed medication\n      </p>\n      <h3>DosageInstructions</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Text</b>\n          </td>\n          <td>\n            <b>AdditionalInstructions</b>\n          </td>\n          <td>\n            <b>Timing[x]</b>\n          </td>\n          <td>\n            <b>AsNeeded[x]</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Route</b>\n          </td>\n          <td>\n            <b>Method</b>\n          </td>\n          <td>\n            <b>DoseQuantity</b>\n          </td>\n          <td>\n            <b>Rate</b>\n          </td>\n          <td>\n            <b>MaxDosePerPeriod</b>\n          </td>\n        </tr>\n        <tr>\n          <td>3 tot 4 maal daags 1 flacon</td>\n          <td>\n            <span title=\"Codes: \">for use during pregnancy, contact physician</span>\n          </td>\n          <td>Starting 4-Aug 2013 --&gt; 5-Nov 2013, 3 per 1 days</td>\n          <td> </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 181220002}\">Entire oral cavity</span>\n          </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 394899003}\">oral administration of treatment</span>\n          </td>\n          <td> </td>\n          <td>10 ml</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>Dispenses</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Medication</b>\n          </td>\n          <td>\n            <b>ValidityPeriod</b>\n          </td>\n          <td>\n            <b>NumberOfRepeatsAllowed</b>\n          </td>\n          <td>\n            <b>Quantity</b>\n          </td>\n          <td>\n            <b>ExpectedSupplyDuration</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>8-Apr 2013 --&gt; 30-May 2013</td>\n          <td>20</td>\n          <td>100 mcg</td>\n          <td>40 days</td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testMedicationPrescription2(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/medicationprescription-example-f002-crestor.json")
        self.assertIsNotNone(inst, "Must have instantiated a MedicationPrescription instance")
    
        self.assertEqual(inst.dateWritten.date, FHIRDate("2013-04-08").date)
        self.assertEqual(inst.dateWritten.isostring, "2013-04-08")
        self.assertEqual(inst.dispense.quantity.code, "46992007")
        self.assertEqual(inst.dispense.quantity.system, "http://snomed.info/sct")
        self.assertEqual(inst.dispense.quantity.value, 90)
        self.assertEqual(inst.dispense.validityPeriod.start.date, FHIRDate("2013-04-08").date)
        self.assertEqual(inst.dispense.validityPeriod.start.isostring, "2013-04-08")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.code, "mg")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.units, "mg")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.value, 10)
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].code, "386359008")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].display, "Administration of drug or medicament via oral route")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].code, "181220002")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].display, "Entire oral cavity")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.date, FHIRDate("2013-08-04").date)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.isostring, "2013-08-04")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.duration, 1)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.frequency, 1)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.units, "d")
        self.assertEqual(inst.encounter.display, "encounter who leads to this priscription")
        self.assertEqual(inst.encounter.reference, "Encounter/f001")
        self.assertEqual(inst.identifier[0].system, "http://www.bmc.nl/portal/prescriptions")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "order9837343")
        self.assertEqual(inst.medication.display, "prescribed medication")
        self.assertEqual(inst.medication.reference, "Medication/f002")
        self.assertEqual(inst.patient.display, "P. van den Heuvel")
        self.assertEqual(inst.patient.reference, "Patient/f001")
        self.assertEqual(inst.prescriber.display, "R.A. van den Berk")
        self.assertEqual(inst.prescriber.reference, "Practitioner/f006")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].code, "28036006")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].display, "High density lipoprotein cholesterol level")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: order9837343 (official)\n      </p>\n      <p>\n        <b>dateWritten</b>: 8-Apr 2013\n      </p>\n      <p>\n        <b>status</b>: active\n      </p>\n      <p>\n        <b>patient</b>: P. van den Heuvel\n      </p>\n      <p>\n        <b>prescriber</b>: R.A. van den Berk\n      </p>\n      <p>\n        <b>encounter</b>: encounter who leads to this priscription\n      </p>\n      <p>\n        <b>reason[x]</b>: \n        <span title=\"Codes: {http://snomed.info/sct 28036006}\">High density lipoprotein cholesterol level</span>\n      </p>\n      <p>\n        <b>medication</b>: prescribed medication\n      </p>\n      <h3>DosageInstructions</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Text</b>\n          </td>\n          <td>\n            <b>AdditionalInstructions</b>\n          </td>\n          <td>\n            <b>Timing[x]</b>\n          </td>\n          <td>\n            <b>AsNeeded[x]</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Route</b>\n          </td>\n          <td>\n            <b>Method</b>\n          </td>\n          <td>\n            <b>DoseQuantity</b>\n          </td>\n          <td>\n            <b>Rate</b>\n          </td>\n          <td>\n            <b>MaxDosePerPeriod</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td>Starting 4-Aug 2013 --&gt; (ongoing), Once per 1 days</td>\n          <td> </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 181220002}\">Entire oral cavity</span>\n          </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 386359008}\">Administration of drug or medicament via oral route</span>\n          </td>\n          <td> </td>\n          <td>10 mg</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>Dispenses</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Medication</b>\n          </td>\n          <td>\n            <b>ValidityPeriod</b>\n          </td>\n          <td>\n            <b>NumberOfRepeatsAllowed</b>\n          </td>\n          <td>\n            <b>Quantity</b>\n          </td>\n          <td>\n            <b>ExpectedSupplyDuration</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>8-Apr 2013 --&gt; (ongoing)</td>\n          <td> </td>\n          <td>90 46992007</td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testMedicationPrescription3(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/medicationprescription-example-f003-tolbutamide.json")
        self.assertIsNotNone(inst, "Must have instantiated a MedicationPrescription instance")
    
        self.assertEqual(inst.dateWritten.date, FHIRDate("2011-05-01").date)
        self.assertEqual(inst.dateWritten.isostring, "2011-05-01")
        self.assertEqual(inst.dispense.quantity.code, "46992007")
        self.assertEqual(inst.dispense.quantity.system, "http://snomed.info/sct")
        self.assertEqual(inst.dispense.quantity.value, 90)
        self.assertEqual(inst.dispense.validityPeriod.start.date, FHIRDate("2011-05-01").date)
        self.assertEqual(inst.dispense.validityPeriod.start.isostring, "2011-05-01")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.code, "mg")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.units, "mg")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.value, 500)
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].code, "386359008")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].display, "Administration of drug or medicament via oral route")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].code, "181220002")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].display, "Entire oral cavity")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.date, FHIRDate("2011-05-01").date)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.isostring, "2011-05-01")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.duration, 1)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.frequency, 3)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.units, "d")
        self.assertEqual(inst.encounter.display, "encounter who leads to this priscription")
        self.assertEqual(inst.encounter.reference, "Encounter/f002")
        self.assertEqual(inst.identifier[0].system, "http://www.bmc.nl/portal/prescriptions")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "order9845343")
        self.assertEqual(inst.medication.display, "prescribed medication")
        self.assertEqual(inst.medication.reference, "Medication/f003")
        self.assertEqual(inst.patient.display, "P. van den Heuvel")
        self.assertEqual(inst.patient.reference, "Patient/f001")
        self.assertEqual(inst.prescriber.display, "S.M. Heps")
        self.assertEqual(inst.prescriber.reference, "Practitioner/f007")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].code, "444780001")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].display, "High glucose level in blood")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: order9845343 (official)\n      </p>\n      <p>\n        <b>dateWritten</b>: 1-May 2011\n      </p>\n      <p>\n        <b>status</b>: active\n      </p>\n      <p>\n        <b>patient</b>: P. van den Heuvel\n      </p>\n      <p>\n        <b>prescriber</b>: S.M. Heps\n      </p>\n      <p>\n        <b>encounter</b>: encounter who leads to this priscription\n      </p>\n      <p>\n        <b>reason[x]</b>: \n        <span title=\"Codes: {http://snomed.info/sct 444780001}\">High glucose level in blood</span>\n      </p>\n      <p>\n        <b>medication</b>: prescribed medication\n      </p>\n      <h3>DosageInstructions</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Text</b>\n          </td>\n          <td>\n            <b>AdditionalInstructions</b>\n          </td>\n          <td>\n            <b>Timing[x]</b>\n          </td>\n          <td>\n            <b>AsNeeded[x]</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Route</b>\n          </td>\n          <td>\n            <b>Method</b>\n          </td>\n          <td>\n            <b>DoseQuantity</b>\n          </td>\n          <td>\n            <b>Rate</b>\n          </td>\n          <td>\n            <b>MaxDosePerPeriod</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td>Starting 1-May 2011 --&gt; (ongoing), 3 per 1 days</td>\n          <td> </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 181220002}\">Entire oral cavity</span>\n          </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 386359008}\">Administration of drug or medicament via oral route</span>\n          </td>\n          <td> </td>\n          <td>500 mg</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>Dispenses</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Medication</b>\n          </td>\n          <td>\n            <b>ValidityPeriod</b>\n          </td>\n          <td>\n            <b>NumberOfRepeatsAllowed</b>\n          </td>\n          <td>\n            <b>Quantity</b>\n          </td>\n          <td>\n            <b>ExpectedSupplyDuration</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>1-May 2011 --&gt; (ongoing)</td>\n          <td> </td>\n          <td>90 46992007</td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testMedicationPrescription4(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/medicationprescription-example-f004-metoprolol.json")
        self.assertIsNotNone(inst, "Must have instantiated a MedicationPrescription instance")
    
        self.assertEqual(inst.dateWritten.date, FHIRDate("2011-05-01").date)
        self.assertEqual(inst.dateWritten.isostring, "2011-05-01")
        self.assertEqual(inst.dispense.quantity.code, "46992007")
        self.assertEqual(inst.dispense.quantity.system, "http://snomed.info/sct")
        self.assertEqual(inst.dispense.quantity.value, 90)
        self.assertEqual(inst.dispense.validityPeriod.start.date, FHIRDate("2011-05-01").date)
        self.assertEqual(inst.dispense.validityPeriod.start.isostring, "2011-05-01")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.code, "mg")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.units, "mg")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.value, 50)
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].code, "386359008")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].display, "Administration of drug or medicament via oral route")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].code, "181220002")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].display, "Entire oral cavity")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.date, FHIRDate("2011-05-01").date)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.isostring, "2011-05-01")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.duration, 1)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.frequency, 1)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.units, "d")
        self.assertEqual(inst.encounter.display, "encounter who leads to this priscription")
        self.assertEqual(inst.encounter.reference, "Encounter/f001")
        self.assertEqual(inst.identifier[0].system, "http://www.bmc.nl/portal/prescriptions")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "order9845343")
        self.assertEqual(inst.medication.display, "prescribed medication")
        self.assertEqual(inst.medication.reference, "Medication/f004")
        self.assertEqual(inst.patient.display, "P. van den Heuvel")
        self.assertEqual(inst.patient.reference, "Patient/f001")
        self.assertEqual(inst.prescriber.display, "S.M. Heps")
        self.assertEqual(inst.prescriber.reference, "Practitioner/f007")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].code, "38341003")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].display, "High blood pressure")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: order9845343 (official)\n      </p>\n      <p>\n        <b>dateWritten</b>: 1-May 2011\n      </p>\n      <p>\n        <b>status</b>: active\n      </p>\n      <p>\n        <b>patient</b>: P. van den Heuvel\n      </p>\n      <p>\n        <b>prescriber</b>: S.M. Heps\n      </p>\n      <p>\n        <b>encounter</b>: encounter who leads to this priscription\n      </p>\n      <p>\n        <b>reason[x]</b>: \n        <span title=\"Codes: {http://snomed.info/sct 38341003}\">High blood pressure</span>\n      </p>\n      <p>\n        <b>medication</b>: prescribed medication\n      </p>\n      <h3>DosageInstructions</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Text</b>\n          </td>\n          <td>\n            <b>AdditionalInstructions</b>\n          </td>\n          <td>\n            <b>Timing[x]</b>\n          </td>\n          <td>\n            <b>AsNeeded[x]</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Route</b>\n          </td>\n          <td>\n            <b>Method</b>\n          </td>\n          <td>\n            <b>DoseQuantity</b>\n          </td>\n          <td>\n            <b>Rate</b>\n          </td>\n          <td>\n            <b>MaxDosePerPeriod</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td>Starting 1-May 2011 --&gt; (ongoing), Once per 1 days</td>\n          <td> </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 181220002}\">Entire oral cavity</span>\n          </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 386359008}\">Administration of drug or medicament via oral route</span>\n          </td>\n          <td> </td>\n          <td>50 mg</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>Dispenses</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Medication</b>\n          </td>\n          <td>\n            <b>ValidityPeriod</b>\n          </td>\n          <td>\n            <b>NumberOfRepeatsAllowed</b>\n          </td>\n          <td>\n            <b>Quantity</b>\n          </td>\n          <td>\n            <b>ExpectedSupplyDuration</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>1-May 2011 --&gt; (ongoing)</td>\n          <td> </td>\n          <td>90 46992007</td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testMedicationPrescription5(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/medicationprescription-example-f005-enalapril.json")
        self.assertIsNotNone(inst, "Must have instantiated a MedicationPrescription instance")
    
        self.assertEqual(inst.dateWritten.date, FHIRDate("2011-05-01").date)
        self.assertEqual(inst.dateWritten.isostring, "2011-05-01")
        self.assertEqual(inst.dispense.quantity.code, "46992007")
        self.assertEqual(inst.dispense.quantity.system, "http://snomed.info/sct")
        self.assertEqual(inst.dispense.quantity.value, 28)
        self.assertEqual(inst.dispense.validityPeriod.start.date, FHIRDate("2011-05-01").date)
        self.assertEqual(inst.dispense.validityPeriod.start.isostring, "2011-05-01")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.code, "mg")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.units, "mg")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.value, 5)
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].code, "386359008")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].display, "Administration of drug or medicament via oral route")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].code, "181220002")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].display, "Entire oral cavity")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.date, FHIRDate("2011-05-01").date)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.isostring, "2011-05-01")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.duration, 1)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.frequency, 1)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.units, "d")
        self.assertEqual(inst.encounter.display, "encounter who leads to this priscription")
        self.assertEqual(inst.encounter.reference, "Encounter/f001")
        self.assertEqual(inst.identifier[0].system, "http://www.bmc.nl/portal/prescriptions")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "order9823343")
        self.assertEqual(inst.medication.display, "prescribed medication")
        self.assertEqual(inst.medication.reference, "Medication/f005")
        self.assertEqual(inst.patient.display, "P. van den Heuvel")
        self.assertEqual(inst.patient.reference, "Patient/f001")
        self.assertEqual(inst.prescriber.display, "S.M. Heps")
        self.assertEqual(inst.prescriber.reference, "Practitioner/f007")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].code, "38341003")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].display, "High blood pressure")
        self.assertEqual(inst.reasonCodeableConcept.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: order9823343 (official)\n      </p>\n      <p>\n        <b>dateWritten</b>: 1-May 2011\n      </p>\n      <p>\n        <b>status</b>: active\n      </p>\n      <p>\n        <b>patient</b>: P. van den Heuvel\n      </p>\n      <p>\n        <b>prescriber</b>: S.M. Heps\n      </p>\n      <p>\n        <b>encounter</b>: encounter who leads to this priscription\n      </p>\n      <p>\n        <b>reason[x]</b>: \n        <span title=\"Codes: {http://snomed.info/sct 38341003}\">High blood pressure</span>\n      </p>\n      <p>\n        <b>medication</b>: prescribed medication\n      </p>\n      <h3>DosageInstructions</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Text</b>\n          </td>\n          <td>\n            <b>AdditionalInstructions</b>\n          </td>\n          <td>\n            <b>Timing[x]</b>\n          </td>\n          <td>\n            <b>AsNeeded[x]</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Route</b>\n          </td>\n          <td>\n            <b>Method</b>\n          </td>\n          <td>\n            <b>DoseQuantity</b>\n          </td>\n          <td>\n            <b>Rate</b>\n          </td>\n          <td>\n            <b>MaxDosePerPeriod</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td> </td>\n          <td>Starting 1-May 2011 --&gt; (ongoing), Once per 1 days</td>\n          <td> </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 181220002}\">Entire oral cavity</span>\n          </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 386359008}\">Administration of drug or medicament via oral route</span>\n          </td>\n          <td> </td>\n          <td>5 mg</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>Dispenses</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Medication</b>\n          </td>\n          <td>\n            <b>ValidityPeriod</b>\n          </td>\n          <td>\n            <b>NumberOfRepeatsAllowed</b>\n          </td>\n          <td>\n            <b>Quantity</b>\n          </td>\n          <td>\n            <b>ExpectedSupplyDuration</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>1-May 2011 --&gt; (ongoing)</td>\n          <td> </td>\n          <td>28 46992007</td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testMedicationPrescription6(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/medicationprescription-example-f201-salmeterol.json")
        self.assertIsNotNone(inst, "Must have instantiated a MedicationPrescription instance")
    
        self.assertEqual(inst.dateWritten.date, FHIRDate("2013-03-11").date)
        self.assertEqual(inst.dateWritten.isostring, "2013-03-11")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.code, "PUFF")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.system, "http://hl7.org/fhir/v3/orderableDrugForm")
        self.assertEqual(inst.dosageInstruction[0].doseQuantity.value, 1)
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.denominator.code, "259032004")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.denominator.system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.denominator.units, "daily")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.denominator.value, 1)
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.numerator.code, "415215001")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.numerator.system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.numerator.units, "puffs")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.numerator.value, 2)
        self.assertEqual(inst.dosageInstruction[0].method.coding[0].code, "320276009")
        self.assertEqual(inst.dosageInstruction[0].method.coding[0].display, "Salmeterol+fluticasone 25/250ug inhaler")
        self.assertEqual(inst.dosageInstruction[0].method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].code, "321667001")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].display, "Respiratory tract")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].code, "74262004")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].display, "Oral cavity")
        self.assertEqual(inst.dosageInstruction[0].site.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].text, "aerosol 25/250ug/do 120do 2x - 1 dose - daily")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].end.date, FHIRDate("2013-05-11").date)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].end.isostring, "2013-05-11")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.date, FHIRDate("2013-03-11").date)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.isostring, "2013-03-11")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.duration, 1)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.frequency, 2)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.repeat.units, "d")
        self.assertEqual(inst.medication.display, "25ug Salmeterol + 250ug Fluticasone")
        self.assertEqual(inst.medication.reference, "Medication/f201")
        self.assertEqual(inst.patient.display, "Roel")
        self.assertEqual(inst.patient.reference, "Patient/f201")
        self.assertEqual(inst.prescriber.display, "Dokter Bonsig")
        self.assertEqual(inst.prescriber.reference, "Practitioner/f201")
        self.assertEqual(inst.reasonResource.display, "fever")
        self.assertEqual(inst.reasonResource.reference, "Condition/f201")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>dateWritten</b>: 11-Mar 2013\n      </p>\n      <p>\n        <b>status</b>: active\n      </p>\n      <p>\n        <b>patient</b>: Roel\n      </p>\n      <p>\n        <b>prescriber</b>: Dokter Bonsig\n      </p>\n      <p>\n        <b>reason[x]</b>: fever\n      </p>\n      <p>\n        <b>medication</b>: 25ug Salmeterol + 250ug Fluticasone\n      </p>\n      <h3>DosageInstructions</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Text</b>\n          </td>\n          <td>\n            <b>AdditionalInstructions</b>\n          </td>\n          <td>\n            <b>Timing[x]</b>\n          </td>\n          <td>\n            <b>AsNeeded[x]</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Route</b>\n          </td>\n          <td>\n            <b>Method</b>\n          </td>\n          <td>\n            <b>DoseQuantity</b>\n          </td>\n          <td>\n            <b>Rate</b>\n          </td>\n          <td>\n            <b>MaxDosePerPeriod</b>\n          </td>\n        </tr>\n        <tr>\n          <td>aerosol 25/250ug/do 120do 2x - 1 dose - daily</td>\n          <td> </td>\n          <td>Starting 11-Mar 2013 --&gt; 11-May 2013, 2 per 1 days</td>\n          <td> </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 74262004}\">Oral cavity</span>\n          </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 321667001}\">Respiratory tract</span>\n          </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 320276009}\">Salmeterol+fluticasone 25/250ug inhaler</span>\n          </td>\n          <td>1 PUFF</td>\n          <td> </td>\n          <td>2 puffs/1 daily</td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testMedicationPrescription7(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/medicationprescription-example-f202-flucloxacilline.json")
        self.assertIsNotNone(inst, "Must have instantiated a MedicationPrescription instance")
    
        self.assertEqual(inst.dateWritten.date, FHIRDate("2013-03-11").date)
        self.assertEqual(inst.dateWritten.isostring, "2013-03-11")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.denominator.code, "258702006")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.denominator.system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.denominator.units, "hours")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.denominator.value, 24)
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.numerator.code, "258682000")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.numerator.system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.numerator.units, "gram")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.numerator.value, 12)
        self.assertEqual(inst.dosageInstruction[0].method.coding[0].code, "323493005")
        self.assertEqual(inst.dosageInstruction[0].method.coding[0].display, "Injected floxacillin")
        self.assertEqual(inst.dosageInstruction[0].method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].code, "47625008")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].display, "Intravenous route")
        self.assertEqual(inst.dosageInstruction[0].route.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].text, "Flucloxacilline 12g/24h")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].end.date, FHIRDate("2013-03-21").date)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].end.isostring, "2013-03-21")
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.date, FHIRDate("2013-03-11").date)
        self.assertEqual(inst.dosageInstruction[0].timingSchedule.event[0].start.isostring, "2013-03-11")
        self.assertEqual(inst.encounter.display, "Roel's encounter on March eleventh 2013")
        self.assertEqual(inst.encounter.reference, "Encounter/f203")
        self.assertEqual(inst.medication.display, "Flucloxacilline")
        self.assertEqual(inst.medication.reference, "Medication/f202")
        self.assertEqual(inst.patient.display, "Roel")
        self.assertEqual(inst.patient.reference, "Patient/f201")
        self.assertEqual(inst.prescriber.reference, "Practitioner/f201")
        self.assertEqual(inst.reasonResource.display, "sepsis")
        self.assertEqual(inst.reasonResource.reference, "Condition/f203")
        self.assertEqual(inst.status, "completed")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>dateWritten</b>: 11-Mar 2013\n      </p>\n      <p>\n        <b>status</b>: completed\n      </p>\n      <p>\n        <b>patient</b>: Roel\n      </p>\n      <p>\n        <b>prescriber</b>: \n        <a href=\"practitioner-example-f201-ab.html\">UZI-nummer = 12345678901 (official); Dokter Bronsig(official); Male; birthDate: 24-Dec 1956; Implementation of planned interventions; Medical oncologist</a>\n      </p>\n      <p>\n        <b>encounter</b>: Roel's encounter on March eleventh 2013\n      </p>\n      <p>\n        <b>reason[x]</b>: sepsis\n      </p>\n      <p>\n        <b>medication</b>: Flucloxacilline\n      </p>\n      <h3>DosageInstructions</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Text</b>\n          </td>\n          <td>\n            <b>AdditionalInstructions</b>\n          </td>\n          <td>\n            <b>Timing[x]</b>\n          </td>\n          <td>\n            <b>AsNeeded[x]</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Route</b>\n          </td>\n          <td>\n            <b>Method</b>\n          </td>\n          <td>\n            <b>DoseQuantity</b>\n          </td>\n          <td>\n            <b>Rate</b>\n          </td>\n          <td>\n            <b>MaxDosePerPeriod</b>\n          </td>\n        </tr>\n        <tr>\n          <td>Flucloxacilline 12g/24h</td>\n          <td> </td>\n          <td>11-Mar 2013 --&gt; 21-Mar 2013</td>\n          <td> </td>\n          <td> </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 47625008}\">Intravenous route</span>\n          </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 323493005}\">Injected floxacillin</span>\n          </td>\n          <td> </td>\n          <td> </td>\n          <td>12 gram/24 hours</td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testMedicationPrescription8(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/medicationprescription-example-f203-paracetamol.json")
        self.assertIsNotNone(inst, "Must have instantiated a MedicationPrescription instance")
    
        self.assertEqual(inst.dateWritten.date, FHIRDate("2013-04-04").date)
        self.assertEqual(inst.dateWritten.isostring, "2013-04-04")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.denominator.code, "258702006")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.denominator.system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.denominator.units, "hours")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.denominator.value, 24)
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.numerator.code, "258684004")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.numerator.system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.numerator.units, "milligram")
        self.assertEqual(inst.dosageInstruction[0].maxDosePerPeriod.numerator.value, 3000)
        self.assertEqual(inst.dosageInstruction[0].method.coding[0].code, "322236009")
        self.assertEqual(inst.dosageInstruction[0].method.coding[0].display, "Paracetamol 500mg tablet")
        self.assertEqual(inst.dosageInstruction[0].method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.dosageInstruction[0].text, "Paracetamol 3xdaags 1000mg")
        self.assertEqual(inst.encounter.display, "Roel's encounter on April fourth 2013")
        self.assertEqual(inst.encounter.reference, "Encounter/f201")
        self.assertEqual(inst.medication.display, "Paracetamol")
        self.assertEqual(inst.medication.reference, "Medication/f203")
        self.assertEqual(inst.patient.display, "Roel")
        self.assertEqual(inst.patient.reference, "Patient/f201")
        self.assertEqual(inst.prescriber.reference, "Practitioner/f201")
        self.assertEqual(inst.reasonResource.display, "fever")
        self.assertEqual(inst.reasonResource.reference, "Condition/f201")
        self.assertEqual(inst.status, "active")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>dateWritten</b>: 4-Apr 2013\n      </p>\n      <p>\n        <b>status</b>: active\n      </p>\n      <p>\n        <b>patient</b>: Roel\n      </p>\n      <p>\n        <b>prescriber</b>: \n        <a href=\"practitioner-example-f201-ab.html\">UZI-nummer = 12345678901 (official); Dokter Bronsig(official); Male; birthDate: 24-Dec 1956; Implementation of planned interventions; Medical oncologist</a>\n      </p>\n      <p>\n        <b>encounter</b>: Roel's encounter on April fourth 2013\n      </p>\n      <p>\n        <b>reason[x]</b>: fever\n      </p>\n      <p>\n        <b>medication</b>: Paracetamol\n      </p>\n      <h3>DosageInstructions</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Text</b>\n          </td>\n          <td>\n            <b>AdditionalInstructions</b>\n          </td>\n          <td>\n            <b>Timing[x]</b>\n          </td>\n          <td>\n            <b>AsNeeded[x]</b>\n          </td>\n          <td>\n            <b>Site</b>\n          </td>\n          <td>\n            <b>Route</b>\n          </td>\n          <td>\n            <b>Method</b>\n          </td>\n          <td>\n            <b>DoseQuantity</b>\n          </td>\n          <td>\n            <b>Rate</b>\n          </td>\n          <td>\n            <b>MaxDosePerPeriod</b>\n          </td>\n        </tr>\n        <tr>\n          <td>Paracetamol 3xdaags 1000mg</td>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 322236009}\">Paracetamol 500mg tablet</span>\n          </td>\n          <td> </td>\n          <td> </td>\n          <td>3000 milligram/24 hours</td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")

