#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 0.0.82.2943 (xds-profile.profile.json) on 2014-10-31.
#  2014, SMART Platforms.


import io
import unittest
import json
from observation import Observation
from fhirdate import FHIRDate


class ObservationTests(unittest.TestCase):
    def instantiate_from(self, filename):
        with io.open(filename, 'r', encoding='utf-8') as handle:
            js = json.load(handle)
        instance = Observation(js)
        self.assertIsNotNone(instance, "Must have instantiated a test instance")
        return instance
    
    def testObservation1(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/observation-example-f001-glucose.json")
        self.assertIsNotNone(inst, "Must have instantiated a Observation instance")
    
        self.assertEqual(inst.appliesPeriod.end.date, FHIRDate("2013-04-05T09:30:10+01:00").date)
        self.assertEqual(inst.appliesPeriod.end.isostring, "2013-04-05T09:30:10+01:00")
        self.assertEqual(inst.appliesPeriod.start.date, FHIRDate("2013-04-02T09:30:10+01:00").date)
        self.assertEqual(inst.appliesPeriod.start.isostring, "2013-04-02T09:30:10+01:00")
        self.assertEqual(inst.bodySite.coding[0].code, "308046002")
        self.assertEqual(inst.bodySite.coding[0].display, "Superficial forearm vein")
        self.assertEqual(inst.bodySite.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.identifier.system, "http://www.bmc.nl/zorgportal/identifiers/observations")
        self.assertEqual(inst.identifier.use, "official")
        self.assertEqual(inst.identifier.value, "6323")
        self.assertEqual(inst.interpretation.coding[0].code, "A")
        self.assertEqual(inst.interpretation.coding[0].display, "abnormal")
        self.assertEqual(inst.interpretation.coding[0].system, "http://hl7.org/fhir/v2/0078")
        self.assertEqual(inst.issued.date, FHIRDate("2013-04-03T15:30:10+01:00").date)
        self.assertEqual(inst.issued.isostring, "2013-04-03T15:30:10+01:00")
        self.assertEqual(inst.method.coding[0].code, "120220003")
        self.assertEqual(inst.method.coding[0].display, "Injection to forearm")
        self.assertEqual(inst.method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[0].code, "2339-0")
        self.assertEqual(inst.name.coding[0].display, "Glucose [Mass/volume] in Blood")
        self.assertEqual(inst.name.coding[0].system, "http://loinc.org")
        self.assertEqual(inst.performer[0].display, "A. Langeveld")
        self.assertEqual(inst.performer[0].reference, "Practitioner/f005")
        self.assertEqual(inst.referenceRange[0].high.code, "mmol/l")
        self.assertEqual(inst.referenceRange[0].high.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.referenceRange[0].high.units, "mmol/l")
        self.assertEqual(inst.referenceRange[0].high.value, 6.2)
        self.assertEqual(inst.referenceRange[0].low.code, "mmol/l")
        self.assertEqual(inst.referenceRange[0].low.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.referenceRange[0].low.units, "mmol/l")
        self.assertEqual(inst.referenceRange[0].low.value, 3.1)
        self.assertEqual(inst.reliability, "ok")
        self.assertEqual(inst.status, "final")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>name</b>: \n        <span title=\"Codes: {http://loinc.org 2339-0}\">Glucose [Mass/volume] in Blood</span>\n      </p>\n      <p>\n        <b>value[x]</b>: 6.3 mmol/l\n      </p>\n      <p>\n        <b>interpretation</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/v2/0078 A}\">abnormal</span>\n      </p>\n      <p>\n        <b>applies[x]</b>: 2-Apr 2013 9:30 --&gt; 5-Apr 2013 9:30\n      </p>\n      <p>\n        <b>issued</b>: 3-Apr 2013 15:30\n      </p>\n      <p>\n        <b>status</b>: final_\n      </p>\n      <p>\n        <b>reliability</b>: ok\n      </p>\n      <p>\n        <b>bodySite</b>: \n        <span title=\"Codes: {http://snomed.info/sct 308046002}\">Superficial forearm vein</span>\n      </p>\n      <p>\n        <b>method</b>: \n        <span title=\"Codes: {http://snomed.info/sct 120220003}\">Injection to forearm</span>\n      </p>\n      <p>\n        <b>identifier</b>: 6323 (official)\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>performer</b>: A. Langeveld\n      </p>\n      <h3>ReferenceRanges</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Low</b>\n          </td>\n          <td>\n            <b>High</b>\n          </td>\n          <td>\n            <b>Meaning</b>\n          </td>\n          <td>\n            <b>Age</b>\n          </td>\n        </tr>\n        <tr>\n          <td>3.1 mmol/l</td>\n          <td>6.2 mmol/l</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.valueQuantity.code, "mmol/l")
        self.assertEqual(inst.valueQuantity.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.valueQuantity.units, "mmol/l")
        self.assertEqual(inst.valueQuantity.value, 6.3)
    
    def testObservation2(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/observation-example-f002-excess.json")
        self.assertIsNotNone(inst, "Must have instantiated a Observation instance")
    
        self.assertEqual(inst.appliesPeriod.end.date, FHIRDate("2013-04-05T10:30:10+01:00").date)
        self.assertEqual(inst.appliesPeriod.end.isostring, "2013-04-05T10:30:10+01:00")
        self.assertEqual(inst.appliesPeriod.start.date, FHIRDate("2013-04-02T10:30:10+01:00").date)
        self.assertEqual(inst.appliesPeriod.start.isostring, "2013-04-02T10:30:10+01:00")
        self.assertEqual(inst.bodySite.coding[0].code, "308046002")
        self.assertEqual(inst.bodySite.coding[0].display, "Superficial forearm vein")
        self.assertEqual(inst.bodySite.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.identifier.system, "http://www.bmc.nl/zorgportal/identifiers/observations")
        self.assertEqual(inst.identifier.use, "official")
        self.assertEqual(inst.identifier.value, "6324")
        self.assertEqual(inst.interpretation.coding[0].code, "A")
        self.assertEqual(inst.interpretation.coding[0].display, "abnormal")
        self.assertEqual(inst.interpretation.coding[0].system, "http://hl7.org/fhir/v2/0078")
        self.assertEqual(inst.issued.date, FHIRDate("2013-04-03T15:30:10+01:00").date)
        self.assertEqual(inst.issued.isostring, "2013-04-03T15:30:10+01:00")
        self.assertEqual(inst.method.coding[0].code, "120220003")
        self.assertEqual(inst.method.coding[0].display, "Injection to forearm")
        self.assertEqual(inst.method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[0].code, "11555-0")
        self.assertEqual(inst.name.coding[0].display, "Base excess in Blood by calculation")
        self.assertEqual(inst.name.coding[0].system, "http://loinc.org")
        self.assertEqual(inst.performer[0].display, "A. Langeveld")
        self.assertEqual(inst.performer[0].reference, "Practitioner/f005")
        self.assertEqual(inst.referenceRange[0].high.code, "mmol/l")
        self.assertEqual(inst.referenceRange[0].high.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.referenceRange[0].high.units, "mmol/l")
        self.assertEqual(inst.referenceRange[0].high.value, 11.2)
        self.assertEqual(inst.referenceRange[0].low.code, "mmol/l")
        self.assertEqual(inst.referenceRange[0].low.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.referenceRange[0].low.units, "mmol/l")
        self.assertEqual(inst.referenceRange[0].low.value, 7.1)
        self.assertEqual(inst.reliability, "ok")
        self.assertEqual(inst.status, "final")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>name</b>: \n        <span title=\"Codes: {http://loinc.org 11555-0}\">Base excess in Blood by calculation</span>\n      </p>\n      <p>\n        <b>value[x]</b>: 12.6 mmol/l\n      </p>\n      <p>\n        <b>interpretation</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/v2/0078 A}\">abnormal</span>\n      </p>\n      <p>\n        <b>applies[x]</b>: 2-Apr 2013 10:30 --&gt; 5-Apr 2013 10:30\n      </p>\n      <p>\n        <b>issued</b>: 3-Apr 2013 15:30\n      </p>\n      <p>\n        <b>status</b>: final_\n      </p>\n      <p>\n        <b>reliability</b>: ok\n      </p>\n      <p>\n        <b>bodySite</b>: \n        <span title=\"Codes: {http://snomed.info/sct 308046002}\">Superficial forearm vein</span>\n      </p>\n      <p>\n        <b>method</b>: \n        <span title=\"Codes: {http://snomed.info/sct 120220003}\">Injection to forearm</span>\n      </p>\n      <p>\n        <b>identifier</b>: 6324 (official)\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>performer</b>: A. Langeveld\n      </p>\n      <h3>ReferenceRanges</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Low</b>\n          </td>\n          <td>\n            <b>High</b>\n          </td>\n          <td>\n            <b>Meaning</b>\n          </td>\n          <td>\n            <b>Age</b>\n          </td>\n        </tr>\n        <tr>\n          <td>7.1 mmol/l</td>\n          <td>11.2 mmol/l</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.valueQuantity.code, "mmol/l")
        self.assertEqual(inst.valueQuantity.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.valueQuantity.units, "mmol/l")
        self.assertEqual(inst.valueQuantity.value, 12.6)
    
    def testObservation3(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/observation-example-f003-co2.json")
        self.assertIsNotNone(inst, "Must have instantiated a Observation instance")
    
        self.assertEqual(inst.appliesPeriod.end.date, FHIRDate("2013-04-05T10:30:10+01:00").date)
        self.assertEqual(inst.appliesPeriod.end.isostring, "2013-04-05T10:30:10+01:00")
        self.assertEqual(inst.appliesPeriod.start.date, FHIRDate("2013-04-02T10:30:10+01:00").date)
        self.assertEqual(inst.appliesPeriod.start.isostring, "2013-04-02T10:30:10+01:00")
        self.assertEqual(inst.bodySite.coding[0].code, "308046002")
        self.assertEqual(inst.bodySite.coding[0].display, "Superficial forearm vein")
        self.assertEqual(inst.bodySite.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.identifier.system, "http://www.bmc.nl/zorgportal/identifiers/observations")
        self.assertEqual(inst.identifier.use, "official")
        self.assertEqual(inst.identifier.value, "6325")
        self.assertEqual(inst.interpretation.coding[0].code, "A")
        self.assertEqual(inst.interpretation.coding[0].display, "abnormal")
        self.assertEqual(inst.interpretation.coding[0].system, "http://hl7.org/fhir/v2/0078")
        self.assertEqual(inst.issued.date, FHIRDate("2013-04-03T15:30:10+01:00").date)
        self.assertEqual(inst.issued.isostring, "2013-04-03T15:30:10+01:00")
        self.assertEqual(inst.method.coding[0].code, "120220003")
        self.assertEqual(inst.method.coding[0].display, "Injection to forearm")
        self.assertEqual(inst.method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[0].code, "11557-6")
        self.assertEqual(inst.name.coding[0].display, "Carbon dioxide [Partial pressure] in Blood")
        self.assertEqual(inst.name.coding[0].system, "http://loinc.org")
        self.assertEqual(inst.performer[0].display, "A. Langeveld")
        self.assertEqual(inst.performer[0].reference, "Practitioner/f005")
        self.assertEqual(inst.referenceRange[0].high.code, "mmol/l")
        self.assertEqual(inst.referenceRange[0].high.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.referenceRange[0].high.units, "mmol/l")
        self.assertEqual(inst.referenceRange[0].high.value, 11.2)
        self.assertEqual(inst.referenceRange[0].low.code, "mmol/l")
        self.assertEqual(inst.referenceRange[0].low.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.referenceRange[0].low.units, "mmol/l")
        self.assertEqual(inst.referenceRange[0].low.value, 7.1)
        self.assertEqual(inst.reliability, "ok")
        self.assertEqual(inst.status, "final")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>name</b>: \n        <span title=\"Codes: {http://loinc.org 11557-6}\">Carbon dioxide [Partial pressure] in Blood</span>\n      </p>\n      <p>\n        <b>value[x]</b>: 6.2 mm[Hg]\n      </p>\n      <p>\n        <b>interpretation</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/v2/0078 A}\">abnormal</span>\n      </p>\n      <p>\n        <b>applies[x]</b>: 2-Apr 2013 10:30 --&gt; 5-Apr 2013 10:30\n      </p>\n      <p>\n        <b>issued</b>: 3-Apr 2013 15:30\n      </p>\n      <p>\n        <b>status</b>: final_\n      </p>\n      <p>\n        <b>reliability</b>: ok\n      </p>\n      <p>\n        <b>bodySite</b>: \n        <span title=\"Codes: {http://snomed.info/sct 308046002}\">Superficial forearm vein</span>\n      </p>\n      <p>\n        <b>method</b>: \n        <span title=\"Codes: {http://snomed.info/sct 120220003}\">Injection to forearm</span>\n      </p>\n      <p>\n        <b>identifier</b>: 6325 (official)\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>performer</b>: A. Langeveld\n      </p>\n      <h3>ReferenceRanges</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Low</b>\n          </td>\n          <td>\n            <b>High</b>\n          </td>\n          <td>\n            <b>Meaning</b>\n          </td>\n          <td>\n            <b>Age</b>\n          </td>\n        </tr>\n        <tr>\n          <td>7.1 mmol/l</td>\n          <td>11.2 mmol/l</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.valueQuantity.code, "mm[Hg]")
        self.assertEqual(inst.valueQuantity.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.valueQuantity.units, "mm[Hg]")
        self.assertEqual(inst.valueQuantity.value, 6.2)
    
    def testObservation4(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/observation-example-f004-hemoglobin.json")
        self.assertIsNotNone(inst, "Must have instantiated a Observation instance")
    
        self.assertEqual(inst.appliesPeriod.end.date, FHIRDate("2013-04-05T10:30:10+01:00").date)
        self.assertEqual(inst.appliesPeriod.end.isostring, "2013-04-05T10:30:10+01:00")
        self.assertEqual(inst.appliesPeriod.start.date, FHIRDate("2013-04-02T10:30:10+01:00").date)
        self.assertEqual(inst.appliesPeriod.start.isostring, "2013-04-02T10:30:10+01:00")
        self.assertEqual(inst.bodySite.coding[0].code, "308046002")
        self.assertEqual(inst.bodySite.coding[0].display, "Superficial forearm vein")
        self.assertEqual(inst.bodySite.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.identifier.system, "http://www.bmc.nl/zorgportal/identifiers/observations")
        self.assertEqual(inst.identifier.use, "official")
        self.assertEqual(inst.identifier.value, "6326")
        self.assertEqual(inst.interpretation.coding[0].code, "A")
        self.assertEqual(inst.interpretation.coding[0].display, "abnormal")
        self.assertEqual(inst.interpretation.coding[0].system, "http://hl7.org/fhir/v2/0078")
        self.assertEqual(inst.issued.date, FHIRDate("2013-04-03T15:30:10+01:00").date)
        self.assertEqual(inst.issued.isostring, "2013-04-03T15:30:10+01:00")
        self.assertEqual(inst.method.coding[0].code, "120220003")
        self.assertEqual(inst.method.coding[0].display, "Injection to forearm")
        self.assertEqual(inst.method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[0].code, "28540-3")
        self.assertEqual(inst.name.coding[0].display, "Erythrocyte mean corpuscular hemoglobin concentration [Mass/volume]")
        self.assertEqual(inst.name.coding[0].system, "http://loinc.org")
        self.assertEqual(inst.performer[0].display, "A. Langeveld")
        self.assertEqual(inst.performer[0].reference, "Practitioner/f005")
        self.assertEqual(inst.referenceRange[0].high.code, "g/dl")
        self.assertEqual(inst.referenceRange[0].high.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.referenceRange[0].high.units, "g/dl")
        self.assertEqual(inst.referenceRange[0].high.value, 36)
        self.assertEqual(inst.referenceRange[0].low.code, "g/dl")
        self.assertEqual(inst.referenceRange[0].low.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.referenceRange[0].low.units, "g/dl")
        self.assertEqual(inst.referenceRange[0].low.value, 32)
        self.assertEqual(inst.reliability, "ok")
        self.assertEqual(inst.status, "final")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>name</b>: \n        <span title=\"Codes: {http://loinc.org 28540-3}\">Erythrocyte mean corpuscular hemoglobin concentration [Mass/volume]</span>\n      </p>\n      <p>\n        <b>value[x]</b>: 18.7 g/dl\n      </p>\n      <p>\n        <b>interpretation</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/v2/0078 A}\">abnormal</span>\n      </p>\n      <p>\n        <b>applies[x]</b>: 2-Apr 2013 10:30 --&gt; 5-Apr 2013 10:30\n      </p>\n      <p>\n        <b>issued</b>: 3-Apr 2013 15:30\n      </p>\n      <p>\n        <b>status</b>: final_\n      </p>\n      <p>\n        <b>reliability</b>: ok\n      </p>\n      <p>\n        <b>bodySite</b>: \n        <span title=\"Codes: {http://snomed.info/sct 308046002}\">Superficial forearm vein</span>\n      </p>\n      <p>\n        <b>method</b>: \n        <span title=\"Codes: {http://snomed.info/sct 120220003}\">Injection to forearm</span>\n      </p>\n      <p>\n        <b>identifier</b>: 6326 (official)\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>performer</b>: A. Langeveld\n      </p>\n      <h3>ReferenceRanges</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Low</b>\n          </td>\n          <td>\n            <b>High</b>\n          </td>\n          <td>\n            <b>Meaning</b>\n          </td>\n          <td>\n            <b>Age</b>\n          </td>\n        </tr>\n        <tr>\n          <td>32 g/dl</td>\n          <td>36 g/dl</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.valueQuantity.code, "g/dl")
        self.assertEqual(inst.valueQuantity.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.valueQuantity.units, "g/dl")
        self.assertEqual(inst.valueQuantity.value, 18.7)
    
    def testObservation5(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/observation-example-f005-hemoglobin.json")
        self.assertIsNotNone(inst, "Must have instantiated a Observation instance")
    
        self.assertEqual(inst.appliesPeriod.end.date, FHIRDate("2013-04-05T10:30:10+01:00").date)
        self.assertEqual(inst.appliesPeriod.end.isostring, "2013-04-05T10:30:10+01:00")
        self.assertEqual(inst.appliesPeriod.start.date, FHIRDate("2013-04-02T10:30:10+01:00").date)
        self.assertEqual(inst.appliesPeriod.start.isostring, "2013-04-02T10:30:10+01:00")
        self.assertEqual(inst.bodySite.coding[0].code, "308046002")
        self.assertEqual(inst.bodySite.coding[0].display, "Superficial forearm vein")
        self.assertEqual(inst.bodySite.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.identifier.system, "http://www.bmc.nl/zorgportal/identifiers/observations")
        self.assertEqual(inst.identifier.use, "official")
        self.assertEqual(inst.identifier.value, "6327")
        self.assertEqual(inst.interpretation.coding[0].code, "L")
        self.assertEqual(inst.interpretation.coding[0].display, "low")
        self.assertEqual(inst.interpretation.coding[0].system, "http://hl7.org/fhir/v2/0078")
        self.assertEqual(inst.issued.date, FHIRDate("2013-04-03T15:30:10+01:00").date)
        self.assertEqual(inst.issued.isostring, "2013-04-03T15:30:10+01:00")
        self.assertEqual(inst.method.coding[0].code, "120220003")
        self.assertEqual(inst.method.coding[0].display, "Injection to forearm")
        self.assertEqual(inst.method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[0].code, "30350-3")
        self.assertEqual(inst.name.coding[0].display, "Hemoglobin [Mass/volume] in Venous blood")
        self.assertEqual(inst.name.coding[0].system, "http://loinc.org")
        self.assertEqual(inst.performer[0].display, "A. Langeveld")
        self.assertEqual(inst.performer[0].reference, "Practitioner/f005")
        self.assertEqual(inst.referenceRange[0].high.code, "g/dl")
        self.assertEqual(inst.referenceRange[0].high.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.referenceRange[0].high.units, "g/dl")
        self.assertEqual(inst.referenceRange[0].high.value, 10)
        self.assertEqual(inst.referenceRange[0].low.code, "g/dl")
        self.assertEqual(inst.referenceRange[0].low.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.referenceRange[0].low.units, "g/dl")
        self.assertEqual(inst.referenceRange[0].low.value, 7.5)
        self.assertEqual(inst.reliability, "ok")
        self.assertEqual(inst.status, "final")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>name</b>: \n        <span title=\"Codes: {http://loinc.org 30350-3}\">Hemoglobin [Mass/volume] in Venous blood</span>\n      </p>\n      <p>\n        <b>value[x]</b>: 7.2 g/dl\n      </p>\n      <p>\n        <b>interpretation</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/v2/0078 L}\">low</span>\n      </p>\n      <p>\n        <b>applies[x]</b>: 2-Apr 2013 10:30 --&gt; 5-Apr 2013 10:30\n      </p>\n      <p>\n        <b>issued</b>: 3-Apr 2013 15:30\n      </p>\n      <p>\n        <b>status</b>: final_\n      </p>\n      <p>\n        <b>reliability</b>: ok\n      </p>\n      <p>\n        <b>bodySite</b>: \n        <span title=\"Codes: {http://snomed.info/sct 308046002}\">Superficial forearm vein</span>\n      </p>\n      <p>\n        <b>method</b>: \n        <span title=\"Codes: {http://snomed.info/sct 120220003}\">Injection to forearm</span>\n      </p>\n      <p>\n        <b>identifier</b>: 6327 (official)\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>performer</b>: A. Langeveld\n      </p>\n      <h3>ReferenceRanges</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Low</b>\n          </td>\n          <td>\n            <b>High</b>\n          </td>\n          <td>\n            <b>Meaning</b>\n          </td>\n          <td>\n            <b>Age</b>\n          </td>\n        </tr>\n        <tr>\n          <td>7.5 g/dl</td>\n          <td>10 g/dl</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.valueQuantity.code, "g/dl")
        self.assertEqual(inst.valueQuantity.system, "http://unitsofmeasure.org")
        self.assertEqual(inst.valueQuantity.units, "g/dl")
        self.assertEqual(inst.valueQuantity.value, 7.2)
    
    def testObservation6(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/observation-example-f201-bmi.json")
        self.assertIsNotNone(inst, "Must have instantiated a Observation instance")
    
        self.assertEqual(inst.bodySite.coding[0].code, "38266002")
        self.assertEqual(inst.bodySite.coding[0].display, "Entire body as a whole")
        self.assertEqual(inst.bodySite.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.interpretation.coding[0].code, "75540009")
        self.assertEqual(inst.interpretation.coding[0].display, "High")
        self.assertEqual(inst.interpretation.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.interpretation.coding[1].code, "H")
        self.assertEqual(inst.interpretation.coding[1].system, "http://hl7.org/fhir/v2/0078")
        self.assertEqual(inst.issued.date, FHIRDate("2013-04-04T13:27:00+01:00").date)
        self.assertEqual(inst.issued.isostring, "2013-04-04T13:27:00+01:00")
        self.assertEqual(inst.method.coding[0].code, "122869004")
        self.assertEqual(inst.method.coding[0].display, "Measurement - action")
        self.assertEqual(inst.method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[0].code, "60621009")
        self.assertEqual(inst.name.coding[0].display, "Body mass index")
        self.assertEqual(inst.name.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[1].code, "39156-5")
        self.assertEqual(inst.name.coding[1].display, "Body mass index (BMI) [Ratio]")
        self.assertEqual(inst.name.coding[1].system, "http://loinc.org")
        self.assertEqual(inst.name.text, "BMI")
        self.assertEqual(inst.performer[0].reference, "Practitioner/f201")
        self.assertEqual(inst.referenceRange[0].high.value, 20)
        self.assertEqual(inst.referenceRange[0].meaning.coding[0].code, "310252000")
        self.assertEqual(inst.referenceRange[0].meaning.coding[0].display, "Low BMI")
        self.assertEqual(inst.referenceRange[0].meaning.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.referenceRange[1].high.value, 25)
        self.assertEqual(inst.referenceRange[1].low.value, 20)
        self.assertEqual(inst.referenceRange[1].meaning.coding[0].code, "412768003")
        self.assertEqual(inst.referenceRange[1].meaning.coding[0].display, "Normal BMI")
        self.assertEqual(inst.referenceRange[1].meaning.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.referenceRange[2].high.value, 30)
        self.assertEqual(inst.referenceRange[2].low.value, 25)
        self.assertEqual(inst.referenceRange[2].meaning.coding[0].code, "162863004")
        self.assertEqual(inst.referenceRange[2].meaning.coding[0].display, "Overweight")
        self.assertEqual(inst.referenceRange[2].meaning.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.referenceRange[3].high.value, 40)
        self.assertEqual(inst.referenceRange[3].low.value, 30)
        self.assertEqual(inst.referenceRange[3].meaning.coding[0].code, "162864005")
        self.assertEqual(inst.referenceRange[3].meaning.coding[0].display, "Obesity")
        self.assertEqual(inst.referenceRange[3].meaning.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.referenceRange[4].low.value, 40)
        self.assertEqual(inst.referenceRange[4].meaning.coding[0].code, "162864005")
        self.assertEqual(inst.referenceRange[4].meaning.coding[0].display, "Severe obesity")
        self.assertEqual(inst.referenceRange[4].meaning.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.related[0].target.reference, "#length")
        self.assertEqual(inst.related[0].type, "derived-from")
        self.assertEqual(inst.related[1].target.reference, "#weight")
        self.assertEqual(inst.related[1].type, "derived-from")
        self.assertEqual(inst.reliability, "ok")
        self.assertEqual(inst.status, "final")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>name</b>: \n        <span title=\"Codes: {http://snomed.info/sct 60621009}, {http://loinc.org 39156-5}\">BMI</span>\n      </p>\n      <p>\n        <b>value[x]</b>: 31.31 null\n      </p>\n      <p>\n        <b>interpretation</b>: \n        <span title=\"Codes: {http://snomed.info/sct 75540009}, {http://hl7.org/fhir/v2/0078 H}\">High</span>\n      </p>\n      <p>\n        <b>issued</b>: 4-Apr 2013 13:27\n      </p>\n      <p>\n        <b>status</b>: final_\n      </p>\n      <p>\n        <b>reliability</b>: ok\n      </p>\n      <p>\n        <b>bodySite</b>: \n        <span title=\"Codes: {http://snomed.info/sct 38266002}\">Entire body as a whole</span>\n      </p>\n      <p>\n        <b>method</b>: \n        <span title=\"Codes: {http://snomed.info/sct 122869004}\">Measurement - action</span>\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <p>\n        <b>performer</b>: \n        <a href=\"practitioner-example-f201-ab.html\">UZI-nummer = 12345678901 (official); Dokter Bronsig(official); Male; birthDate: 24-Dec 1956; Implementation of planned interventions; Medical oncologist</a>\n      </p>\n      <h3>ReferenceRanges</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Low</b>\n          </td>\n          <td>\n            <b>High</b>\n          </td>\n          <td>\n            <b>Meaning</b>\n          </td>\n          <td>\n            <b>Age</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>20 null</td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 310252000}\">Low BMI</span>\n          </td>\n          <td> </td>\n        </tr>\n        <tr>\n          <td>20 null</td>\n          <td>25 null</td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 412768003}\">Normal BMI</span>\n          </td>\n          <td> </td>\n        </tr>\n        <tr>\n          <td>25 null</td>\n          <td>30 null</td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 162863004}\">Overweight</span>\n          </td>\n          <td> </td>\n        </tr>\n        <tr>\n          <td>30 null</td>\n          <td>40 null</td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 162864005}\">Obesity</span>\n          </td>\n          <td> </td>\n        </tr>\n        <tr>\n          <td>40 null</td>\n          <td> </td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 162864005}\">Severe obesity</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n      <h3>Relateds</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Type</b>\n          </td>\n          <td>\n            <b>Target</b>\n          </td>\n        </tr>\n        <tr>\n          <td>derivedfrom</td>\n          <td>Length; 182 centimeter; final_; ok</td>\n        </tr>\n        <tr>\n          <td>derivedfrom</td>\n          <td>Weight; 103.7 kilogram; final_; ok</td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.valueQuantity.value, 31.31)
    
    def testObservation7(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/observation-example-f202-temperature.json")
        self.assertIsNotNone(inst, "Must have instantiated a Observation instance")
    
        self.assertEqual(inst.bodySite.coding[0].code, "38266002")
        self.assertEqual(inst.bodySite.coding[0].display, "Entire body as a whole")
        self.assertEqual(inst.bodySite.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.interpretation.coding[0].code, "H")
        self.assertEqual(inst.interpretation.coding[0].system, "http://hl7.org/fhir/v2/0078")
        self.assertEqual(inst.issued.date, FHIRDate("2013-04-04T13:27:00+01:00").date)
        self.assertEqual(inst.issued.isostring, "2013-04-04T13:27:00+01:00")
        self.assertEqual(inst.method.coding[0].code, "89003005")
        self.assertEqual(inst.method.coding[0].display, "Oral temperature taking")
        self.assertEqual(inst.method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[0].code, "415945006")
        self.assertEqual(inst.name.coding[0].display, "Oral temperature")
        self.assertEqual(inst.name.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[1].code, "8310-5")
        self.assertEqual(inst.name.coding[1].display, "Body temperature")
        self.assertEqual(inst.name.coding[1].system, "http://loinc.org")
        self.assertEqual(inst.name.text, "Body temperature")
        self.assertEqual(inst.performer[0].reference, "Practitioner/f201")
        self.assertEqual(inst.referenceRange[0].low.units, "degrees C")
        self.assertEqual(inst.referenceRange[0].low.value, 37.5)
        self.assertEqual(inst.reliability, "questionable")
        self.assertEqual(inst.status, "entered in error")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>name</b>: \n        <span title=\"Codes: {http://snomed.info/sct 415945006}, {http://loinc.org 8310-5}\">Body temperature</span>\n      </p>\n      <p>\n        <b>value[x]</b>: 39 degrees C\n      </p>\n      <p>\n        <b>interpretation</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/v2/0078 H}\">Above high normal</span>\n      </p>\n      <p>\n        <b>issued</b>: 4-Apr 2013 13:27\n      </p>\n      <p>\n        <b>status</b>: enteredInError\n      </p>\n      <p>\n        <b>reliability</b>: questionable\n      </p>\n      <p>\n        <b>bodySite</b>: \n        <span title=\"Codes: {http://snomed.info/sct 38266002}\">Entire body as a whole</span>\n      </p>\n      <p>\n        <b>method</b>: \n        <span title=\"Codes: {http://snomed.info/sct 89003005}\">Oral temperature taking</span>\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <p>\n        <b>performer</b>: \n        <a href=\"practitioner-example-f201-ab.html\">UZI-nummer = 12345678901 (official); Dokter Bronsig(official); Male; birthDate: 24-Dec 1956; Implementation of planned interventions; Medical oncologist</a>\n      </p>\n      <h3>ReferenceRanges</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Low</b>\n          </td>\n          <td>\n            <b>High</b>\n          </td>\n          <td>\n            <b>Meaning</b>\n          </td>\n          <td>\n            <b>Age</b>\n          </td>\n        </tr>\n        <tr>\n          <td>37.5 degrees C</td>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.valueQuantity.code, "258710007")
        self.assertEqual(inst.valueQuantity.system, "http://snomed.info/sct")
        self.assertEqual(inst.valueQuantity.units, "degrees C")
        self.assertEqual(inst.valueQuantity.value, 39)
    
    def testObservation8(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/observation-example-f203-bicarbonate.json")
        self.assertIsNotNone(inst, "Must have instantiated a Observation instance")
    
        self.assertEqual(inst.identifier.label, "Bicarbonaat value of Roel on April 2013 - 03720")
        self.assertEqual(inst.identifier.system, "https://intranet.aumc.nl/labvalues")
        self.assertEqual(inst.identifier.value, "1304-03720-Bicarbonate")
        self.assertEqual(inst.interpretation.coding[0].code, "166698001")
        self.assertEqual(inst.interpretation.coding[0].display, "Serum bicarbonate level normal")
        self.assertEqual(inst.interpretation.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.interpretation.coding[1].code, "N")
        self.assertEqual(inst.interpretation.coding[1].system, "http://hl7.org/fhir/v2/0078")
        self.assertEqual(inst.issued.date, FHIRDate("2013-04-04T14:34:00+01:00").date)
        self.assertEqual(inst.issued.isostring, "2013-04-04T14:34:00+01:00")
        self.assertEqual(inst.method.coding[0].code, "271239003")
        self.assertEqual(inst.method.coding[0].display, "Serum bicarbonate measurement")
        self.assertEqual(inst.method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[0].code, "365722008")
        self.assertEqual(inst.name.coding[0].display, "Bicarbonate level")
        self.assertEqual(inst.name.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.performer[0].display, "Luigi Maas")
        self.assertEqual(inst.performer[0].reference, "Practitioner/f202")
        self.assertEqual(inst.referenceRange[0].high.value, 29)
        self.assertEqual(inst.referenceRange[0].low.value, 22)
        self.assertEqual(inst.referenceRange[0].meaning.coding[0].code, "normal")
        self.assertEqual(inst.referenceRange[0].meaning.coding[0].display, "Normal Range")
        self.assertEqual(inst.referenceRange[0].meaning.coding[0].system, "http://hl7.org/fhir/referencerange-meaning")
        self.assertEqual(inst.reliability, "ok")
        self.assertEqual(inst.status, "final")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>name</b>: \n        <span title=\"Codes: {http://snomed.info/sct 365722008}\">Bicarbonate level</span>\n      </p>\n      <p>\n        <b>value[x]</b>: 28 mmol/L\n      </p>\n      <p>\n        <b>interpretation</b>: \n        <span title=\"Codes: {http://snomed.info/sct 166698001}, {http://hl7.org/fhir/v2/0078 N}\">Serum bicarbonate level normal</span>\n      </p>\n      <p>\n        <b>issued</b>: 4-Apr 2013 14:34\n      </p>\n      <p>\n        <b>status</b>: final_\n      </p>\n      <p>\n        <b>reliability</b>: ok\n      </p>\n      <p>\n        <b>method</b>: \n        <span title=\"Codes: {http://snomed.info/sct 271239003}\">Serum bicarbonate measurement</span>\n      </p>\n      <p>\n        <b>identifier</b>: Bicarbonaat value of Roel on April 2013 - 03720 = 1304-03720-Bicarbonate\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <p>\n        <b>performer</b>: Luigi Maas\n      </p>\n      <h3>ReferenceRanges</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Low</b>\n          </td>\n          <td>\n            <b>High</b>\n          </td>\n          <td>\n            <b>Meaning</b>\n          </td>\n          <td>\n            <b>Age</b>\n          </td>\n        </tr>\n        <tr>\n          <td>22 null</td>\n          <td>29 null</td>\n          <td>\n            <span title=\"Codes: {http://hl7.org/fhir/referencerange-meaning normal}\">Normal Range</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.valueQuantity.code, "258813002")
        self.assertEqual(inst.valueQuantity.system, "http://snomed.info/sct")
        self.assertEqual(inst.valueQuantity.units, "mmol/L")
        self.assertEqual(inst.valueQuantity.value, 28)
    
    def testObservation9(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/observation-example-f204-creatinine.json")
        self.assertIsNotNone(inst, "Must have instantiated a Observation instance")
    
        self.assertEqual(inst.identifier.label, "Creatinine value of Roel on April 2013 - 03720")
        self.assertEqual(inst.identifier.system, "https://intranet.aumc.nl/labvalues")
        self.assertEqual(inst.identifier.value, "1304-03720-Creatinine")
        self.assertEqual(inst.interpretation.coding[0].code, "166717003")
        self.assertEqual(inst.interpretation.coding[0].display, "Serum creatinine raised")
        self.assertEqual(inst.interpretation.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.interpretation.coding[1].code, "H")
        self.assertEqual(inst.interpretation.coding[1].system, "http://hl7.org/fhir/v2/0078")
        self.assertEqual(inst.issued.date, FHIRDate("2013-04-04T14:34:00+01:00").date)
        self.assertEqual(inst.issued.isostring, "2013-04-04T14:34:00+01:00")
        self.assertEqual(inst.method.coding[0].code, "113075003")
        self.assertEqual(inst.method.coding[0].display, "Creatinine measurement, serum")
        self.assertEqual(inst.method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[0].code, "365756002")
        self.assertEqual(inst.name.coding[0].display, "Creatinine level")
        self.assertEqual(inst.name.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.performer[0].display, "Luigi Maas")
        self.assertEqual(inst.performer[0].reference, "Practitioner/f202")
        self.assertEqual(inst.referenceRange[0].high.value, 104)
        self.assertEqual(inst.referenceRange[0].low.value, 64)
        self.assertEqual(inst.referenceRange[0].meaning.coding[0].code, "normal")
        self.assertEqual(inst.referenceRange[0].meaning.coding[0].display, "Normal Range")
        self.assertEqual(inst.referenceRange[0].meaning.coding[0].system, "http://hl7.org/fhir/referencerange-meaning")
        self.assertEqual(inst.reliability, "ok")
        self.assertEqual(inst.status, "final")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>name</b>: \n        <span title=\"Codes: {http://snomed.info/sct 365756002}\">Creatinine level</span>\n      </p>\n      <p>\n        <b>value[x]</b>: 122 umol/L\n      </p>\n      <p>\n        <b>interpretation</b>: \n        <span title=\"Codes: {http://snomed.info/sct 166717003}, {http://hl7.org/fhir/v2/0078 H}\">Serum creatinine raised</span>\n      </p>\n      <p>\n        <b>issued</b>: 4-Apr 2013 14:34\n      </p>\n      <p>\n        <b>status</b>: final_\n      </p>\n      <p>\n        <b>reliability</b>: ok\n      </p>\n      <p>\n        <b>method</b>: \n        <span title=\"Codes: {http://snomed.info/sct 113075003}\">Creatinine measurement, serum</span>\n      </p>\n      <p>\n        <b>identifier</b>: Creatinine value of Roel on April 2013 - 03720 = 1304-03720-Creatinine\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <p>\n        <b>performer</b>: Luigi Maas\n      </p>\n      <h3>ReferenceRanges</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Low</b>\n          </td>\n          <td>\n            <b>High</b>\n          </td>\n          <td>\n            <b>Meaning</b>\n          </td>\n          <td>\n            <b>Age</b>\n          </td>\n        </tr>\n        <tr>\n          <td>64 null</td>\n          <td>104 null</td>\n          <td>\n            <span title=\"Codes: {http://hl7.org/fhir/referencerange-meaning normal}\">Normal Range</span>\n          </td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.valueQuantity.code, "258814008")
        self.assertEqual(inst.valueQuantity.system, "http://snomed.info/sct")
        self.assertEqual(inst.valueQuantity.units, "umol/L")
        self.assertEqual(inst.valueQuantity.value, 122)
    
    def testObservation10(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/observation-example-f205-egfr.json")
        self.assertIsNotNone(inst, "Must have instantiated a Observation instance")
    
        self.assertEqual(inst.identifier.label, "eGFR value of Roel on April 2013 - 03720")
        self.assertEqual(inst.identifier.system, "https://intranet.aumc.nl/labvalues")
        self.assertEqual(inst.identifier.value, "1304-03720-eGFR")
        self.assertEqual(inst.interpretation.coding[0].code, "427038005")
        self.assertEqual(inst.interpretation.coding[0].display, "Negative for epidermal growth factor receptor expression (Non-small cell lung cancer)")
        self.assertEqual(inst.interpretation.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.interpretation.coding[1].code, "NEG")
        self.assertEqual(inst.interpretation.coding[1].system, "http://hl7.org/fhir/v2/0078")
        self.assertEqual(inst.issued.date, FHIRDate("2013-04-04T14:34:00+01:00").date)
        self.assertEqual(inst.issued.isostring, "2013-04-04T14:34:00+01:00")
        self.assertEqual(inst.method.coding[0].code, "129266000")
        self.assertEqual(inst.method.coding[0].display, "Measurement")
        self.assertEqual(inst.method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[0].code, "409402009")
        self.assertEqual(inst.name.coding[0].display, "Epidermal Growth Factor Receptor")
        self.assertEqual(inst.name.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.performer[0].display, "Luigi Maas")
        self.assertEqual(inst.performer[0].reference, "Practitioner/f202")
        self.assertEqual(inst.referenceRange[0].high.units, "mL/min")
        self.assertEqual(inst.referenceRange[0].high.value, 60)
        self.assertEqual(inst.reliability, "ok")
        self.assertEqual(inst.status, "final")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>name</b>: \n        <span title=\"Codes: {http://snomed.info/sct 409402009}\">Epidermal Growth Factor Receptor</span>\n      </p>\n      <p>\n        <b>value[x]</b>: 54 mL/min\n      </p>\n      <p>\n        <b>interpretation</b>: \n        <span title=\"Codes: {http://snomed.info/sct 427038005}, {http://hl7.org/fhir/v2/0078 NEG}\">Negative for epidermal growth factor receptor expression (Non-small cell lung cancer)</span>\n      </p>\n      <p>\n        <b>issued</b>: 4-Apr 2013 14:34\n      </p>\n      <p>\n        <b>status</b>: final_\n      </p>\n      <p>\n        <b>reliability</b>: ok\n      </p>\n      <p>\n        <b>method</b>: \n        <span title=\"Codes: {http://snomed.info/sct 129266000}\">Measurement</span>\n      </p>\n      <p>\n        <b>identifier</b>: eGFR value of Roel on April 2013 - 03720 = 1304-03720-eGFR\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <p>\n        <b>performer</b>: Luigi Maas\n      </p>\n      <h3>ReferenceRanges</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Low</b>\n          </td>\n          <td>\n            <b>High</b>\n          </td>\n          <td>\n            <b>Meaning</b>\n          </td>\n          <td>\n            <b>Age</b>\n          </td>\n        </tr>\n        <tr>\n          <td> </td>\n          <td>60 mL/min</td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.valueQuantity.code, "258859000")
        self.assertEqual(inst.valueQuantity.system, "http://snomed.info/sct")
        self.assertEqual(inst.valueQuantity.units, "mL/min")
        self.assertEqual(inst.valueQuantity.value, 54)
    
    def testObservation11(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/observation-example-f206-staphylococcus.json")
        self.assertIsNotNone(inst, "Must have instantiated a Observation instance")
    
        self.assertEqual(inst.interpretation.coding[0].code, "POS")
        self.assertEqual(inst.interpretation.coding[0].system, "http://hl7.org/fhir/v2/0078")
        self.assertEqual(inst.issued.date, FHIRDate("2013-03-11T10:28:00+01:00").date)
        self.assertEqual(inst.issued.isostring, "2013-03-11T10:28:00+01:00")
        self.assertEqual(inst.method.coding[0].code, "104177005")
        self.assertEqual(inst.method.coding[0].display, "Blood culture for bacteria, including anaerobic screen")
        self.assertEqual(inst.method.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.name.coding[0].code, "104177005")
        self.assertEqual(inst.name.coding[0].display, "Blood culture for bacteria, including anaerobic screen")
        self.assertEqual(inst.name.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.performer[0].display, "Luigi Maas")
        self.assertEqual(inst.performer[0].reference, "Practitioner/f202")
        self.assertEqual(inst.reliability, "ok")
        self.assertEqual(inst.status, "final")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>name</b>: \n        <span title=\"Codes: {http://snomed.info/sct 104177005}\">Blood culture for bacteria, including anaerobic screen</span>\n      </p>\n      <p>\n        <b>value[x]</b>: \n        <span title=\"Codes: {http://snomed.info/sct 8745002}\">Gram-positive bacteria</span>\n      </p>\n      <p>\n        <b>interpretation</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/v2/0078 POS}\">Positive</span>\n      </p>\n      <p>\n        <b>issued</b>: 11-Mar 2013 10:28\n      </p>\n      <p>\n        <b>status</b>: final_\n      </p>\n      <p>\n        <b>reliability</b>: ok\n      </p>\n      <p>\n        <b>method</b>: \n        <span title=\"Codes: {http://snomed.info/sct 104177005}\">Blood culture for bacteria, including anaerobic screen</span>\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <p>\n        <b>performer</b>: Luigi Maas\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.valueCodeableConcept.coding[0].code, "8745002")
        self.assertEqual(inst.valueCodeableConcept.coding[0].display, "Gram-positive bacteria")
        self.assertEqual(inst.valueCodeableConcept.coding[0].system, "http://snomed.info/sct")

