#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 0.0.82.2943 (xds-profile.profile.json) on 2014-10-31.
#  2014, SMART Platforms.


import io
import unittest
import json
from patient import Patient
from fhirdate import FHIRDate


class PatientTests(unittest.TestCase):
    def instantiate_from(self, filename):
        with io.open(filename, 'r', encoding='utf-8') as handle:
            js = json.load(handle)
        instance = Patient(js)
        self.assertIsNotNone(instance, "Must have instantiated a test instance")
        return instance
    
    def testPatient1(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/patient-example-a.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
    
        self.assertTrue(inst.active)
        self.assertEqual(inst.contact[0].organization.display, "Walt Disney Corporation")
        self.assertEqual(inst.contact[0].organization.reference, "Organization/1")
        self.assertEqual(inst.contact[0].relationship[0].coding[0].code, "owner")
        self.assertEqual(inst.contact[0].relationship[0].coding[0].system, "http://hl7.org/fhir/patient-contact-relationship")
        self.assertEqual(inst.gender.coding[0].code, "M")
        self.assertEqual(inst.gender.coding[0].display, "Male")
        self.assertEqual(inst.gender.coding[0].system, "http://hl7.org/fhir/v3/AdministrativeGender")
        self.assertEqual(inst.identifier[0].label, "MRN")
        self.assertEqual(inst.identifier[0].system, "urn:oid:0.1.2.3.4.5.6.7")
        self.assertEqual(inst.identifier[0].use, "usual")
        self.assertEqual(inst.identifier[0].value, "654321")
        self.assertEqual(inst.link[0].other.reference, "Patient/pat2")
        self.assertEqual(inst.link[0].type, "seealso")
        self.assertEqual(inst.managingOrganization.display, "ACME Healthcare, Inc")
        self.assertEqual(inst.managingOrganization.reference, "Organization/1")
        self.assertEqual(inst.name[0].family[0], "Donald")
        self.assertEqual(inst.name[0].given[0], "Duck")
        self.assertEqual(inst.name[0].use, "official")
        self.assertEqual(inst.photo[0].contentType, "image/gif")
        self.assertEqual(inst.photo[0].data, "R0lGODlhEwARAPcAAAAAAAAA/+9aAO+1AP/WAP/eAP/eCP/eEP/eGP/nAP/nCP/nEP/nIf/nKf/nUv/nWv/vAP/vCP/vEP/vGP/vIf/vKf/vMf/vOf/vWv/vY//va//vjP/3c//3lP/3nP//tf//vf///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////yH5BAEAAAEALAAAAAATABEAAAi+AAMIDDCgYMGBCBMSvMCQ4QCFCQcwDBGCA4cLDyEGECDxAoAQHjxwyKhQAMeGIUOSJJjRpIAGDS5wCDly4AALFlYOgHlBwwOSNydM0AmzwYGjBi8IHWoTgQYORg8QIGDAwAKhESI8HIDgwQaRDI1WXXAhK9MBBzZ8/XDxQoUFZC9IiCBh6wEHGz6IbNuwQoSpWxEgyLCXL8O/gAnylNlW6AUEBRIL7Og3KwQIiCXb9HsZQoIEUzUjNEiaNMKAAAA7")
        self.assertEqual(inst.text.div, "<div>\n      <p>Patient Donald DUCK @ Acme Healthcare, Inc. MR = 654321</p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPatient2(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/patient-example-animal.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
    
        self.assertTrue(inst.active)
        self.assertEqual(inst.animal.breed.coding[0].code, "58108001")
        self.assertEqual(inst.animal.breed.coding[0].display, "Golden retriever")
        self.assertEqual(inst.animal.breed.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.animal.breed.coding[1].code, "gret")
        self.assertEqual(inst.animal.breed.coding[1].display, "Golden Retriever")
        self.assertEqual(inst.animal.breed.coding[1].system, "http://hl7.org/fhir/animal-breed")
        self.assertEqual(inst.animal.genderStatus.coding[0].code, "neutered")
        self.assertEqual(inst.animal.genderStatus.coding[0].system, "http://hl7.org/fhir/animal-genderstatus")
        self.assertEqual(inst.animal.species.coding[0].code, "canislf")
        self.assertEqual(inst.animal.species.coding[0].display, "Dog")
        self.assertEqual(inst.animal.species.coding[0].system, "http://hl7.org/fhir/animal-species")
        self.assertEqual(inst.birthDate.date, FHIRDate("2010-03-23").date)
        self.assertEqual(inst.birthDate.isostring, "2010-03-23")
        self.assertEqual(inst.contact[0].name.family[0], "Chalmers")
        self.assertEqual(inst.contact[0].name.given[0], "Peter")
        self.assertEqual(inst.contact[0].name.given[1], "James")
        self.assertEqual(inst.contact[0].relationship[0].coding[0].code, "owner")
        self.assertEqual(inst.contact[0].relationship[0].coding[0].system, "http://hl7.org/fhir/patient-contact-relationship")
        self.assertEqual(inst.contact[0].telecom[0].system, "phone")
        self.assertEqual(inst.contact[0].telecom[0].use, "work")
        self.assertEqual(inst.contact[0].telecom[0].value, "(03) 5555 6473")
        self.assertEqual(inst.gender.coding[0].code, "F")
        self.assertEqual(inst.gender.coding[0].system, "http://hl7.org/fhir/v3/AdministrativeGender")
        self.assertEqual(inst.identifier[0].assigner.display, "Maroondah City Council")
        self.assertEqual(inst.identifier[0].label, "Dog Tag")
        self.assertEqual(inst.identifier[0].period.start.date, FHIRDate("2010-05-31").date)
        self.assertEqual(inst.identifier[0].period.start.isostring, "2010-05-31")
        self.assertEqual(inst.identifier[0].system, "http://www.maroondah.vic.gov.au/AnimalRegFees.aspx")
        self.assertEqual(inst.identifier[0].value, "1234123")
        self.assertEqual(inst.managingOrganization.display, "Pete's Vetinary Services")
        self.assertEqual(inst.name[0].given[0], "Kenzi")
        self.assertEqual(inst.name[0].use, "usual")
        self.assertEqual(inst.text.div, "<div>\n      <table>\n        <tbody>\n          <tr>\n            <td>Id</td>\n            <td>Kenzi (Dog: Golden Retriever)</td>\n          </tr>\n          <tr>\n            <td>Owner</td>\n            <td>Peter Chalmers, 534 Erewhon, Pleasantville, Vic, 3999</td>\n          </tr>\n          <tr>\n            <td>Contacts</td>\n            <td>Work: (03) 5555 6473</td>\n          </tr>\n          <tr>\n            <td>Id</td>\n            <td>Dog Tag: 1234123 (Maroondah City Council)</td>\n          </tr>\n        </tbody>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPatient3(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/patient-example-b.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
    
        self.assertTrue(inst.active)
        self.assertEqual(inst.gender.coding[0].code, "M")
        self.assertEqual(inst.gender.coding[0].display, "Male")
        self.assertEqual(inst.gender.coding[0].system, "http://hl7.org/fhir/v3/AdministrativeGender")
        self.assertEqual(inst.identifier[0].label, "MRN")
        self.assertEqual(inst.identifier[0].system, "urn:oid:0.1.2.3.4.5.6.7")
        self.assertEqual(inst.identifier[0].use, "usual")
        self.assertEqual(inst.identifier[0].value, "123456")
        self.assertEqual(inst.link[0].other.reference, "Patient/pat1")
        self.assertEqual(inst.link[0].type, "seealso")
        self.assertEqual(inst.managingOrganization.display, "ACME Healthcare, Inc")
        self.assertEqual(inst.managingOrganization.reference, "Organization/1")
        self.assertEqual(inst.name[0].family[0], "Donald")
        self.assertEqual(inst.name[0].given[0], "Duck")
        self.assertEqual(inst.name[0].given[1], "D")
        self.assertEqual(inst.name[0].use, "official")
        self.assertEqual(inst.photo[0].contentType, "image/gif")
        self.assertEqual(inst.photo[0].data, "R0lGODlhEwARAPcAAAAAAAAA/+9aAO+1AP/WAP/eAP/eCP/eEP/eGP/nAP/nCP/nEP/nIf/nKf/nUv/nWv/vAP/vCP/vEP/vGP/vIf/vKf/vMf/vOf/vWv/vY//va//vjP/3c//3lP/3nP//tf//vf///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////yH5BAEAAAEALAAAAAATABEAAAi+AAMIDDCgYMGBCBMSvMCQ4QCFCQcwDBGCA4cLDyEGECDxAoAQHjxwyKhQAMeGIUOSJJjRpIAGDS5wCDly4AALFlYOgHlBwwOSNydM0AmzwYGjBi8IHWoTgQYORg8QIGDAwAKhESI8HIDgwQaRDI1WXXAhK9MBBzZ8/XDxQoUFZC9IiCBh6wEHGz6IbNuwQoSpWxEgyLCXL8O/gAnylNlW6AUEBRIL7Og3KwQIiCXb9HsZQoIEUzUjNEiaNMKAAAA7")
        self.assertEqual(inst.text.div, "<div>\n      <p>Patient Donald D DUCK @ Acme Healthcare, Inc. MR = 123456</p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPatient4(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/patient-example-dicom.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
    
        self.assertTrue(inst.active)
        self.assertEqual(inst.gender.coding[0].code, "M")
        self.assertEqual(inst.gender.coding[0].system, "http://hl7.org/fhir/v3/AdministrativeGender")
        self.assertEqual(inst.gender.coding[1].code, "M")
        self.assertEqual(inst.gender.coding[1].system, "http://nema.org/examples/gender")
        self.assertEqual(inst.identifier[0].system, "http://nema.org/examples/patients")
        self.assertEqual(inst.identifier[0].value, "MINT1234")
        self.assertEqual(inst.managingOrganization.reference, "Organization/1")
        self.assertEqual(inst.name[0].family[0], "MINT_TEST")
        self.assertEqual(inst.text.div, "<div> Patient MINT_TEST, ID = MINT1234. Age = 56y, Size =\n      1.83m, Weight = 72.58kg </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPatient5(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/patient-example-f001-pieter.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
    
        self.assertTrue(inst.active)
        self.assertEqual(inst.address[0].city, "Amsterdam")
        self.assertEqual(inst.address[0].country, "NLD")
        self.assertEqual(inst.address[0].line[0], "Van Egmondkade 23")
        self.assertEqual(inst.address[0].use, "home")
        self.assertEqual(inst.address[0].zip, "1024 RJ")
        self.assertEqual(inst.birthDate.date, FHIRDate("1944-11-17").date)
        self.assertEqual(inst.birthDate.isostring, "1944-11-17")
        self.assertEqual(inst.communication[0].coding[0].code, "nl")
        self.assertEqual(inst.communication[0].coding[0].display, "Dutch")
        self.assertEqual(inst.communication[0].coding[0].system, "urn:ietf:bcp:47")
        self.assertEqual(inst.communication[0].text, "Nederlands")
        self.assertEqual(inst.contact[0].name.family[0], "Abels")
        self.assertEqual(inst.contact[0].name.given[0], "Sarah")
        self.assertEqual(inst.contact[0].name.use, "usual")
        self.assertEqual(inst.contact[0].relationship[0].coding[0].code, "partner")
        self.assertEqual(inst.contact[0].relationship[0].coding[0].system, "http://hl7.org/fhir/patient-contact-relationship")
        self.assertEqual(inst.contact[0].telecom[0].system, "phone")
        self.assertEqual(inst.contact[0].telecom[0].use, "mobile")
        self.assertEqual(inst.contact[0].telecom[0].value, "0690383372")
        self.assertFalse(inst.deceasedBoolean)
        self.assertEqual(inst.gender.coding[0].code, "M")
        self.assertEqual(inst.gender.coding[0].display, "Male")
        self.assertEqual(inst.gender.coding[0].system, "http://hl7.org/fhir/v3/AdministrativeGender")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.840.1.113883.2.4.6.3")
        self.assertEqual(inst.identifier[0].use, "usual")
        self.assertEqual(inst.identifier[0].value, "738472983")
        self.assertEqual(inst.identifier[1].system, "urn:oid:2.16.840.1.113883.2.4.6.3")
        self.assertEqual(inst.identifier[1].use, "usual")
        self.assertEqual(inst.managingOrganization.display, "Burgers University Medical Centre")
        self.assertEqual(inst.managingOrganization.reference, "Organization/f001")
        self.assertEqual(inst.maritalStatus.coding[0].code, "M")
        self.assertEqual(inst.maritalStatus.coding[0].display, "Married")
        self.assertEqual(inst.maritalStatus.coding[0].system, "http://hl7.org/fhir/v3/MaritalStatus")
        self.assertEqual(inst.maritalStatus.text, "Getrouwd")
        self.assertTrue(inst.multipleBirthBoolean)
        self.assertEqual(inst.name[0].family[0], "van de Heuvel")
        self.assertEqual(inst.name[0].given[0], "Pieter")
        self.assertEqual(inst.name[0].suffix[0], "MSc")
        self.assertEqual(inst.name[0].use, "usual")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "mobile")
        self.assertEqual(inst.telecom[0].value, "0648352638")
        self.assertEqual(inst.telecom[1].system, "email")
        self.assertEqual(inst.telecom[1].use, "home")
        self.assertEqual(inst.telecom[1].value, "p.heuvel@gmail.com")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: 738472983 (usual), ?? (usual)\n      </p>\n      <p>\n        <b>name</b>: Pieter van de Heuvel \n      </p>\n      <p>\n        <b>telecom</b>: ph: 0648352638(mobile), p.heuvel@gmail.com(home)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/v3/AdministrativeGender M}\">Male</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 17-Nov 1944\n      </p>\n      <p>\n        <b>deceased[x]</b>: false\n      </p>\n      <p>\n        <b>address</b>: Van Egmondkade 23 Amsterdam 1024 RJ NLD (home)\n      </p>\n      <p>\n        <b>maritalStatus</b>: \n        <span title=\"Codes: {http://hl7.org/fhir/v3/MaritalStatus M}\">Getrouwd</span>\n      </p>\n      <p>\n        <b>multipleBirth[x]</b>: true\n      </p>\n      <h3>Contacts</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Relationship</b>\n          </td>\n          <td>\n            <b>Name</b>\n          </td>\n          <td>\n            <b>Telecom</b>\n          </td>\n          <td>\n            <b>Address</b>\n          </td>\n          <td>\n            <b>Gender</b>\n          </td>\n          <td>\n            <b>Organization</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://hl7.org/fhir/patient-contact-relationship partner}\">Partner</span>\n          </td>\n          <td>Sarah Abels </td>\n          <td>ph: 0690383372(mobile)</td>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <p>\n        <b>communication</b>: \n        <span title=\"Codes: {urn:ietf:bcp:47 nl}\">Nederlands</span>\n      </p>\n      <p>\n        <b>managingOrganization</b>: Burgers University Medical Centre\n      </p>\n      <p>\n        <b>active</b>: true\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPatient6(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/patient-example-f201-roel.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
    
        self.assertTrue(inst.active)
        self.assertEqual(inst.address[0].city, "Amsterdam")
        self.assertEqual(inst.address[0].country, "NLD")
        self.assertEqual(inst.address[0].line[0], "Bos en Lommerplein 280")
        self.assertEqual(inst.address[0].use, "home")
        self.assertEqual(inst.address[0].zip, "1055RW")
        self.assertEqual(inst.birthDate.date, FHIRDate("1960-03-13").date)
        self.assertEqual(inst.birthDate.isostring, "1960-03-13")
        self.assertEqual(inst.communication[0].coding[0].code, "nl-NL")
        self.assertEqual(inst.communication[0].coding[0].display, "Dutch")
        self.assertEqual(inst.communication[0].coding[0].system, "urn:std:iso:639-1")
        self.assertEqual(inst.contact[0].name.text, "Ariadne Bor-Jansma")
        self.assertEqual(inst.contact[0].name.use, "usual")
        self.assertEqual(inst.contact[0].relationship[0].coding[0].code, "127850001")
        self.assertEqual(inst.contact[0].relationship[0].coding[0].display, "Wife")
        self.assertEqual(inst.contact[0].relationship[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.contact[0].relationship[0].coding[1].code, "partner")
        self.assertEqual(inst.contact[0].relationship[0].coding[1].system, "http://hl7.org/fhir/patient-contact-relationship")
        self.assertEqual(inst.contact[0].telecom[0].system, "phone")
        self.assertEqual(inst.contact[0].telecom[0].use, "home")
        self.assertEqual(inst.contact[0].telecom[0].value, "+31201234567")
        self.assertFalse(inst.deceasedBoolean)
        self.assertEqual(inst.gender.coding[0].code, "248153007")
        self.assertEqual(inst.gender.coding[0].display, "Male")
        self.assertEqual(inst.gender.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.gender.coding[1].code, "M")
        self.assertEqual(inst.gender.coding[1].display, "Male")
        self.assertEqual(inst.gender.coding[1].system, "http://hl7.org/fhir/v3/AdministrativeGender")
        self.assertEqual(inst.identifier[0].label, "BSN")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.840.1.113883.2.4.6.3")
        self.assertEqual(inst.identifier[0].use, "official")
        self.assertEqual(inst.identifier[0].value, "123456789")
        self.assertEqual(inst.identifier[1].label, "BSN")
        self.assertEqual(inst.identifier[1].system, "urn:oid:2.16.840.1.113883.2.4.6.3")
        self.assertEqual(inst.identifier[1].use, "official")
        self.assertEqual(inst.identifier[1].value, "123456789")
        self.assertEqual(inst.managingOrganization.display, "AUMC")
        self.assertEqual(inst.managingOrganization.reference, "Organization/f201")
        self.assertEqual(inst.maritalStatus.coding[0].code, "36629006")
        self.assertEqual(inst.maritalStatus.coding[0].display, "Legally married")
        self.assertEqual(inst.maritalStatus.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.maritalStatus.coding[1].code, "M")
        self.assertEqual(inst.maritalStatus.coding[1].system, "http://hl7.org/fhir/v3/MaritalStatus")
        self.assertFalse(inst.multipleBirthBoolean)
        self.assertEqual(inst.name[0].family[0], "Bor")
        self.assertEqual(inst.name[0].given[0], "Roelof Olaf")
        self.assertEqual(inst.name[0].prefix[0], "Drs.")
        self.assertEqual(inst.name[0].suffix[0], "PDEng.")
        self.assertEqual(inst.name[0].text, "Roel")
        self.assertEqual(inst.name[0].use, "official")
        self.assertEqual(inst.photo[0].contentType, "image/jpeg")
        self.assertEqual(inst.photo[0].url, "binary/@f006")
        self.assertEqual(inst.telecom[0].system, "phone")
        self.assertEqual(inst.telecom[0].use, "mobile")
        self.assertEqual(inst.telecom[0].value, "+31612345678")
        self.assertEqual(inst.telecom[1].system, "phone")
        self.assertEqual(inst.telecom[1].use, "home")
        self.assertEqual(inst.telecom[1].value, "+31201234567")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>identifier</b>: BSN = 123456789 (official), BSN = 123456789 (official)\n      </p>\n      <p>\n        <b>name</b>: Roel(official)\n      </p>\n      <p>\n        <b>telecom</b>: ph: +31612345678(mobile), ph: +31201234567(home)\n      </p>\n      <p>\n        <b>gender</b>: \n        <span title=\"Codes: {http://snomed.info/sct 248153007}, {http://hl7.org/fhir/v3/AdministrativeGender M}\">Male</span>\n      </p>\n      <p>\n        <b>birthDate</b>: 13-Mar 1960\n      </p>\n      <p>\n        <b>deceased[x]</b>: false\n      </p>\n      <p>\n        <b>address</b>: Bos en Lommerplein 280 Amsterdam 1055RW NLD (home)\n      </p>\n      <p>\n        <b>maritalStatus</b>: \n        <span title=\"Codes: {http://snomed.info/sct 36629006}, {http://hl7.org/fhir/v3/MaritalStatus M}\">Legally married</span>\n      </p>\n      <p>\n        <b>multipleBirth[x]</b>: false\n      </p>\n      <p>\n        <b>photo</b>: \n      </p>\n      <h3>Contacts</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Relationship</b>\n          </td>\n          <td>\n            <b>Name</b>\n          </td>\n          <td>\n            <b>Telecom</b>\n          </td>\n          <td>\n            <b>Address</b>\n          </td>\n          <td>\n            <b>Gender</b>\n          </td>\n          <td>\n            <b>Organization</b>\n          </td>\n        </tr>\n        <tr>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 127850001}, {http://hl7.org/fhir/patient-contact-relationship partner}\">Wife</span>\n          </td>\n          <td>Ariadne Bor-Jansma</td>\n          <td>ph: +31201234567(home)</td>\n          <td> </td>\n          <td> </td>\n          <td> </td>\n        </tr>\n      </table>\n      <p>\n        <b>communication</b>: \n        <span title=\"Codes: {urn:std:iso:639-1 nl-NL}\">Dutch</span>\n      </p>\n      <p>\n        <b>managingOrganization</b>: AUMC\n      </p>\n      <p>\n        <b>active</b>: true\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPatient7(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/patient-example-ihe-pcd.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
    
        self.assertTrue(inst.active)
        self.assertEqual(inst.identifier[0].label, "Internal Identifier")
        self.assertEqual(inst.identifier[0].value, "AB60001")
        self.assertEqual(inst.name[0].family[0], "BROOKS")
        self.assertEqual(inst.name[0].given[0], "ALBERT")
        self.assertEqual(inst.text.div, "<div>Albert Brooks, Id: AB60001</div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPatient8(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/patient-example-us-extensions.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
    
        self.assertTrue(inst.active)
        self.assertEqual(inst.address[0].city, "PleasantVille")
        self.assertEqual(inst.address[0].line[0], "534 Erewhon St")
        self.assertEqual(inst.address[0].state, "Vic")
        self.assertEqual(inst.address[0].use, "home")
        self.assertEqual(inst.address[0].zip, "3999")
        self.assertEqual(inst.name[0].family[0], "Chalmers")
        self.assertEqual(inst.name[0].given[0], "Peter")
        self.assertEqual(inst.name[0].given[1], "James")
        self.assertEqual(inst.name[0].use, "official")
        self.assertEqual(inst.text.div, "<div>\n      <table>\n        <tbody>\n          <tr>\n            <td>Name</td>\n            <td>Peter James <b>Chalmers</b> (&quot;Jim&quot;)</td>\n          </tr>\n          <tr>\n            <td>Address</td>\n            <td>534 Erewhon, Pleasantville, Orange County, 3999</td>\n          </tr>\n          <tr>\n            <td>Contacts</td>\n            <td>Home: unknown. Work: (03) 5555 6473</td>\n          </tr>\n          <tr>\n            <td>Id</td>\n            <td>MRN: 12345 (Acme Healthcare)</td>\n          </tr>\n        </tbody>\n      </table>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPatient9(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/patient-example-xcda.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
    
        self.assertTrue(inst.active)
        self.assertEqual(inst.birthDate.date, FHIRDate("1932-09-24").date)
        self.assertEqual(inst.birthDate.isostring, "1932-09-24")
        self.assertEqual(inst.gender.coding[0].code, "M")
        self.assertEqual(inst.gender.coding[0].system, "http://hl7.org/fhir/v3/AdministrativeGender")
        self.assertEqual(inst.identifier[0].label, "MRN")
        self.assertEqual(inst.identifier[0].system, "urn:oid:2.16.840.1.113883.19.5")
        self.assertEqual(inst.identifier[0].use, "usual")
        self.assertEqual(inst.identifier[0].value, "12345")
        self.assertEqual(inst.managingOrganization.display, "Good Health Clinic")
        self.assertEqual(inst.managingOrganization.reference, "Organization/2.16.840.1.113883.19.5")
        self.assertEqual(inst.name[0].family[0], "Levin")
        self.assertEqual(inst.name[0].given[0], "Henry")
        self.assertEqual(inst.text.div, "<div>\n      <p>Henry Levin the 7th</p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
    
    def testPatient10(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/patient-example-xds.json")
        self.assertIsNotNone(inst, "Must have instantiated a Patient instance")
    
        self.assertTrue(inst.active)
        self.assertEqual(inst.address[0].city, "Metropolis")
        self.assertEqual(inst.address[0].country, "USA")
        self.assertEqual(inst.address[0].line[0], "100 Main St")
        self.assertEqual(inst.address[0].state, "Il")
        self.assertEqual(inst.address[0].zip, "44130")
        self.assertEqual(inst.birthDate.date, FHIRDate("1956-05-27").date)
        self.assertEqual(inst.birthDate.isostring, "1956-05-27")
        self.assertEqual(inst.gender.coding[0].code, "M")
        self.assertEqual(inst.gender.coding[0].system, "http://hl7.org/fhir/v3/AdministrativeGender")
        self.assertEqual(inst.identifier[0].label, "MRN")
        self.assertEqual(inst.identifier[0].system, "urn:oid:1.2.3.4.5")
        self.assertEqual(inst.identifier[0].use, "usual")
        self.assertEqual(inst.identifier[0].value, "89765a87b")
        self.assertEqual(inst.managingOrganization.reference, "Organization/2")
        self.assertEqual(inst.name[0].family[0], "Doe")
        self.assertEqual(inst.name[0].given[0], "John")
        self.assertEqual(inst.text.div, "<div>\n      <p>Patient John Doe, M, 27-May 1956. ID: 89765a87b</p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")

