#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  Generated from FHIR 0.0.82.2943 (xds-profile.profile.json) on 2014-10-31.
#  2014, SMART Platforms.


import io
import unittest
import json
from procedure import Procedure
from fhirdate import FHIRDate


class ProcedureTests(unittest.TestCase):
    def instantiate_from(self, filename):
        with io.open(filename, 'r', encoding='utf-8') as handle:
            js = json.load(handle)
        instance = Procedure(js)
        self.assertIsNotNone(instance, "Must have instantiated a test instance")
        return instance
    
    def testProcedure1(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/procedure-example-biopsy.json")
        self.assertIsNotNone(inst, "Must have instantiated a Procedure instance")
    
        self.assertEqual(inst.bodySite[0].coding[0].code, "368225008")
        self.assertEqual(inst.bodySite[0].coding[0].display, "Entire Left Forearm")
        self.assertEqual(inst.bodySite[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.bodySite[0].text, "Left forearm")
        self.assertEqual(inst.date.start.date, FHIRDate("2014-02-03").date)
        self.assertEqual(inst.date.start.isostring, "2014-02-03")
        self.assertEqual(inst.followUp, "Review in clinic")
        self.assertEqual(inst.indication[0].text, "Dark lesion l) forearm. getting darker last 3 months.")
        self.assertEqual(inst.notes, "Standard Biopsy")
        self.assertEqual(inst.performer[0].person.display, "Dr Bert Biopser")
        self.assertEqual(inst.performer[0].person.reference, "Practitioner/example")
        self.assertEqual(inst.subject.reference, "Patient/example")
        self.assertEqual(inst.text.div, "<div>Biopsy of suspected melanoma L) arm</div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type.coding[0].code, "90105005")
        self.assertEqual(inst.type.coding[0].display, "Biopsy of soft tissue of forearm (Procedure)")
        self.assertEqual(inst.type.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.type.text, "Biopsy of suspected melanoma L) arm")
    
    def testProcedure2(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/procedure-example-f001-heart.json")
        self.assertIsNotNone(inst, "Must have instantiated a Procedure instance")
    
        self.assertEqual(inst.bodySite[0].coding[0].code, "17401000")
        self.assertEqual(inst.bodySite[0].coding[0].display, "Heart valve structure")
        self.assertEqual(inst.bodySite[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.date.end.date, FHIRDate("2011-06-27").date)
        self.assertEqual(inst.date.end.isostring, "2011-06-27")
        self.assertEqual(inst.date.start.date, FHIRDate("2011-06-26").date)
        self.assertEqual(inst.date.start.isostring, "2011-06-26")
        self.assertEqual(inst.encounter.reference, "Encounter/f001")
        self.assertEqual(inst.followUp, "described in care plan")
        self.assertEqual(inst.indication[0].text, "Heart valve disorder")
        self.assertEqual(inst.outcome, "improved blood circulation")
        self.assertEqual(inst.performer[0].person.display, "P. Voigt")
        self.assertEqual(inst.performer[0].person.reference, "Practitioner/f002")
        self.assertEqual(inst.performer[0].role.coding[0].code, "01.000")
        self.assertEqual(inst.performer[0].role.coding[0].display, "Arts")
        self.assertEqual(inst.performer[0].role.coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.performer[0].role.text, "Care role")
        self.assertEqual(inst.report[0].display, "Lab results blood test")
        self.assertEqual(inst.report[0].reference, "DiagnosticReport/f001")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>type</b>: \n        <span title=\"Codes: {http://snomed.info/sct 34068001}\">Heart valve replacement</span>\n      </p>\n      <p>\n        <b>bodySite</b>: \n        <span title=\"Codes: {http://snomed.info/sct 17401000}\">Heart valve structure</span>\n      </p>\n      <p>\n        <b>indication</b>: \n        <span title=\"Codes: \">Heart valve disorder</span>\n      </p>\n      <h3>Performers</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Person</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n        </tr>\n        <tr>\n          <td>P. Voigt</td>\n          <td>\n            <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.000}\">Care role</span>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>date</b>: 26-Jun 2011 --&gt; 27-Jun 2011\n      </p>\n      <p>\n        <b>encounter</b>: \n        <a href=\"encounter-example-f001-heart.html\">v1451 (official); finished; outpatient; Patient-initiated encounter; 140 min; Heart valve replacement; Non-urgent cardiological admission</a>\n      </p>\n      <p>\n        <b>outcome</b>: improved blood circulation\n      </p>\n      <p>\n        <b>report</b>: Lab results blood test\n      </p>\n      <p>\n        <b>followUp</b>: described in care plan\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type.coding[0].code, "34068001")
        self.assertEqual(inst.type.coding[0].display, "Heart valve replacement")
        self.assertEqual(inst.type.coding[0].system, "http://snomed.info/sct")
    
    def testProcedure3(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/procedure-example-f002-lung.json")
        self.assertIsNotNone(inst, "Must have instantiated a Procedure instance")
    
        self.assertEqual(inst.bodySite[0].coding[0].code, "39607008")
        self.assertEqual(inst.bodySite[0].coding[0].display, "Lung structure")
        self.assertEqual(inst.bodySite[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.date.end.date, FHIRDate("2013-03-08T09:30:10+01:00").date)
        self.assertEqual(inst.date.end.isostring, "2013-03-08T09:30:10+01:00")
        self.assertEqual(inst.date.start.date, FHIRDate("2013-03-08T09:00:10+01:00").date)
        self.assertEqual(inst.date.start.isostring, "2013-03-08T09:00:10+01:00")
        self.assertEqual(inst.encounter.reference, "Encounter/f002")
        self.assertEqual(inst.followUp, "described in care plan")
        self.assertEqual(inst.indication[0].text, "Malignant tumor of lung")
        self.assertEqual(inst.outcome, "improved blood circulation")
        self.assertEqual(inst.performer[0].person.display, "M.I.M. Versteegh")
        self.assertEqual(inst.performer[0].person.reference, "Practitioner/f003")
        self.assertEqual(inst.performer[0].role.coding[0].code, "01.000")
        self.assertEqual(inst.performer[0].role.coding[0].display, "Arts")
        self.assertEqual(inst.performer[0].role.coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.performer[0].role.text, "Care role")
        self.assertEqual(inst.report[0].display, "Lab results blood test")
        self.assertEqual(inst.report[0].reference, "DiagnosticReport/f001")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>type</b>: \n        <span title=\"Codes: {http://snomed.info/sct 359615001}\">Partial lobectomy of lung</span>\n      </p>\n      <p>\n        <b>bodySite</b>: \n        <span title=\"Codes: {http://snomed.info/sct 39607008}\">Lung structure</span>\n      </p>\n      <p>\n        <b>indication</b>: \n        <span title=\"Codes: \">Malignant tumor of lung</span>\n      </p>\n      <h3>Performers</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Person</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n        </tr>\n        <tr>\n          <td>M.I.M. Versteegh</td>\n          <td>\n            <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.000}\">Care role</span>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>date</b>: 8-Mar 2013 9:0 --&gt; 8-Mar 2013 9:30\n      </p>\n      <p>\n        <b>encounter</b>: \n        <a href=\"encounter-example-f002-lung.html\">v3251 (official); finished; outpatient; Patient-initiated encounter; 140 min; Partial lobectomy of lung; Urgent</a>\n      </p>\n      <p>\n        <b>outcome</b>: improved blood circulation\n      </p>\n      <p>\n        <b>report</b>: Lab results blood test\n      </p>\n      <p>\n        <b>followUp</b>: described in care plan\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type.coding[0].code, "359615001")
        self.assertEqual(inst.type.coding[0].display, "Partial lobectomy of lung")
        self.assertEqual(inst.type.coding[0].system, "http://snomed.info/sct")
    
    def testProcedure4(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/procedure-example-f003-abscess.json")
        self.assertIsNotNone(inst, "Must have instantiated a Procedure instance")
    
        self.assertEqual(inst.bodySite[0].coding[0].code, "83030008")
        self.assertEqual(inst.bodySite[0].coding[0].display, "Retropharyngeal area")
        self.assertEqual(inst.bodySite[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.date.end.date, FHIRDate("2013-03-24T10:30:10+01:00").date)
        self.assertEqual(inst.date.end.isostring, "2013-03-24T10:30:10+01:00")
        self.assertEqual(inst.date.start.date, FHIRDate("2013-03-24T09:30:10+01:00").date)
        self.assertEqual(inst.date.start.isostring, "2013-03-24T09:30:10+01:00")
        self.assertEqual(inst.encounter.reference, "Encounter/f003")
        self.assertEqual(inst.followUp, "described in care plan")
        self.assertEqual(inst.indication[0].text, "abcess in retropharyngeal area")
        self.assertEqual(inst.outcome, "removal of the retropharyngeal abscess")
        self.assertEqual(inst.performer[0].person.display, "E.M.J.M. van den broek")
        self.assertEqual(inst.performer[0].person.reference, "Practitioner/f001")
        self.assertEqual(inst.performer[0].role.coding[0].code, "01.000")
        self.assertEqual(inst.performer[0].role.coding[0].display, "Arts")
        self.assertEqual(inst.performer[0].role.coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.performer[0].role.text, "Care role")
        self.assertEqual(inst.report[0].display, "Lab results blood test")
        self.assertEqual(inst.report[0].reference, "DiagnosticReport/f001")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>type</b>: \n        <span title=\"Codes: {http://snomed.info/sct 172960003}\">Incision of retropharyngeal abscess</span>\n      </p>\n      <p>\n        <b>bodySite</b>: \n        <span title=\"Codes: {http://snomed.info/sct 83030008}\">Retropharyngeal area</span>\n      </p>\n      <p>\n        <b>indication</b>: \n        <span title=\"Codes: \">abcess in retropharyngeal area</span>\n      </p>\n      <h3>Performers</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Person</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n        </tr>\n        <tr>\n          <td>E.M.J.M. van den broek</td>\n          <td>\n            <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.000}\">Care role</span>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>date</b>: 24-Mar 2013 9:30 --&gt; 24-Mar 2013 10:30\n      </p>\n      <p>\n        <b>encounter</b>: \n        <a href=\"encounter-example-f003-abscess.html\">v6751 (official); finished; outpatient; Patient-initiated encounter; 90 min; Retropharyngeal abscess; Non-urgent ear, nose and throat admission</a>\n      </p>\n      <p>\n        <b>outcome</b>: removal of the retropharyngeal abscess\n      </p>\n      <p>\n        <b>report</b>: Lab results blood test\n      </p>\n      <p>\n        <b>followUp</b>: described in care plan\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type.coding[0].code, "172960003")
        self.assertEqual(inst.type.coding[0].display, "Incision of retropharyngeal abscess")
        self.assertEqual(inst.type.coding[0].system, "http://snomed.info/sct")
    
    def testProcedure5(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/procedure-example-f004-tracheotomy.json")
        self.assertIsNotNone(inst, "Must have instantiated a Procedure instance")
    
        self.assertEqual(inst.bodySite[0].coding[0].code, "83030008")
        self.assertEqual(inst.bodySite[0].coding[0].display, "Retropharyngeal area")
        self.assertEqual(inst.bodySite[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.date.end.date, FHIRDate("2013-03-22T10:30:10+01:00").date)
        self.assertEqual(inst.date.end.isostring, "2013-03-22T10:30:10+01:00")
        self.assertEqual(inst.date.start.date, FHIRDate("2013-03-22T09:30:10+01:00").date)
        self.assertEqual(inst.date.start.isostring, "2013-03-22T09:30:10+01:00")
        self.assertEqual(inst.encounter.reference, "Encounter/f003")
        self.assertEqual(inst.followUp, "described in care plan")
        self.assertEqual(inst.indication[0].text, "ensure breathing during surgery")
        self.assertEqual(inst.outcome, "removal of the retropharyngeal abscess")
        self.assertEqual(inst.performer[0].person.display, "A. Langeveld")
        self.assertEqual(inst.performer[0].person.reference, "Practitioner/f005")
        self.assertEqual(inst.performer[0].role.coding[0].code, "01.000")
        self.assertEqual(inst.performer[0].role.coding[0].display, "Arts")
        self.assertEqual(inst.performer[0].role.coding[0].system, "urn:oid:2.16.840.1.113883.2.4.15.111")
        self.assertEqual(inst.performer[0].role.text, "Care role")
        self.assertEqual(inst.report[0].display, "???????????")
        self.assertEqual(inst.report[0].reference, "DiagnosticReport/f001")
        self.assertEqual(inst.subject.display, "P. van de Heuvel")
        self.assertEqual(inst.subject.reference, "Patient/f001")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: P. van de Heuvel\n      </p>\n      <p>\n        <b>type</b>: \n        <span title=\"Codes: {http://snomed.info/sct 48387007}\">Tracheotomy</span>\n      </p>\n      <p>\n        <b>bodySite</b>: \n        <span title=\"Codes: {http://snomed.info/sct 83030008}\">Retropharyngeal area</span>\n      </p>\n      <p>\n        <b>indication</b>: \n        <span title=\"Codes: \">ensure breathing during surgery</span>\n      </p>\n      <h3>Performers</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Person</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n        </tr>\n        <tr>\n          <td>A. Langeveld</td>\n          <td>\n            <span title=\"Codes: {urn:oid:2.16.840.1.113883.2.4.15.111 01.000}\">Care role</span>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>date</b>: 22-Mar 2013 9:30 --&gt; 22-Mar 2013 10:30\n      </p>\n      <p>\n        <b>encounter</b>: \n        <a href=\"encounter-example-f003-abscess.html\">v6751 (official); finished; outpatient; Patient-initiated encounter; 90 min; Retropharyngeal abscess; Non-urgent ear, nose and throat admission</a>\n      </p>\n      <p>\n        <b>outcome</b>: removal of the retropharyngeal abscess\n      </p>\n      <p>\n        <b>report</b>: ???????????\n      </p>\n      <p>\n        <b>followUp</b>: described in care plan\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type.coding[0].code, "48387007")
        self.assertEqual(inst.type.coding[0].display, "Tracheotomy")
        self.assertEqual(inst.type.coding[0].system, "http://snomed.info/sct")
    
    def testProcedure6(self):
        inst = self.instantiate_from("../../fhir-parser/downloads/site/procedure-example-f201-tpf.json")
        self.assertIsNotNone(inst, "Must have instantiated a Procedure instance")
    
        self.assertEqual(inst.bodySite[0].coding[0].code, "272676008")
        self.assertEqual(inst.bodySite[0].coding[0].display, "Sphenoid bone")
        self.assertEqual(inst.bodySite[0].coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.date.end.date, FHIRDate("2013-01-28T14:27:00+01:00").date)
        self.assertEqual(inst.date.end.isostring, "2013-01-28T14:27:00+01:00")
        self.assertEqual(inst.date.start.date, FHIRDate("2013-01-28T13:31:00+01:00").date)
        self.assertEqual(inst.date.start.isostring, "2013-01-28T13:31:00+01:00")
        self.assertEqual(inst.encounter.display, "Roel's encounter on January 28th, 2013")
        self.assertEqual(inst.encounter.reference, "Encounter/f202")
        self.assertEqual(inst.indication[0].text, "DiagnosticReport/f201")
        self.assertEqual(inst.notes, "Eerste neo-adjuvante TPF-kuur bij groot proces in sphenoid met intracraniale uitbreiding.")
        self.assertEqual(inst.performer[0].person.display, "Dokter Bronsig")
        self.assertEqual(inst.performer[0].person.reference, "Practitioner/f201")
        self.assertEqual(inst.performer[0].role.coding[0].code, "310512001")
        self.assertEqual(inst.performer[0].role.coding[0].display, "Medical oncologist")
        self.assertEqual(inst.performer[0].role.coding[0].system, "http://snomed.info/sct")
        self.assertEqual(inst.subject.display, "Roel")
        self.assertEqual(inst.subject.reference, "Patient/f201")
        self.assertEqual(inst.text.div, "<div>\n      <p>\n        <b>Generated Narrative</b>\n      </p>\n      <p>\n        <b>subject</b>: Roel\n      </p>\n      <p>\n        <b>type</b>: \n        <span title=\"Codes: {http://snomed.info/sct 367336001}\">Chemotherapy</span>\n      </p>\n      <p>\n        <b>bodySite</b>: \n        <span title=\"Codes: {http://snomed.info/sct 272676008}\">Sphenoid bone</span>\n      </p>\n      <p>\n        <b>indication</b>: \n        <span title=\"Codes: \">DiagnosticReport/f201</span>\n      </p>\n      <h3>Performers</h3>\n      <table class=\"grid\">\n        <tr>\n          <td>\n            <b>Person</b>\n          </td>\n          <td>\n            <b>Role</b>\n          </td>\n        </tr>\n        <tr>\n          <td>Dokter Bronsig</td>\n          <td>\n            <span title=\"Codes: {http://snomed.info/sct 310512001}\">Medical oncologist</span>\n          </td>\n        </tr>\n      </table>\n      <p>\n        <b>date</b>: 28-Jan 2013 13:31 --&gt; 28-Jan 2013 14:27\n      </p>\n      <p>\n        <b>encounter</b>: Roel's encounter on January 28th, 2013\n      </p>\n      <p>\n        <b>notes</b>: Eerste neo-adjuvante TPF-kuur bij groot proces in sphenoid met intracraniale uitbreiding.\n      </p>\n    </div>")
        self.assertEqual(inst.text.status, "generated")
        self.assertEqual(inst.type.coding[0].code, "367336001")
        self.assertEqual(inst.type.coding[0].display, "Chemotherapy")
        self.assertEqual(inst.type.coding[0].system, "http://snomed.info/sct")

