#  Copyright 2014 Klaudiusz Staniek
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

"""
This is a fiblary package providing python API implementation to Home Center 2

"""


from fiblary.common import utils


def Client(version, *args, **kwargs):
    """This is a client wrapper handling API versioning

    :param version: A verstion string of the API (i.e. 'v3')
    :returns: A Home Center Client class
    """

    module = utils.import_versioned_module('client', version, 'client')
    client_class = getattr(module, 'Client')
    return client_class(*args, **kwargs)
