from __future__ import print_function

from random import randrange
from fibre import entry_point, read_line

@entry_point
def main(low=1, high=100, guesses=10):
    actual_answer = randrange(low, high + 1)

    print()
    print("I'm thinking of a number between {} and {}.".format(low, high))
    print('Try to guess it.')

    guesses_remaining = guesses
    while guesses_remaining > 0:
        print()
        print('You have {} guesses remaining.'.format(guesses_remaining))
        guessed_line = yield read_line('Please enter your guess: ')
        guessed_answer = int(guessed_line)
        if guessed_answer > actual_answer:
            print('Your guess is too high.')
        elif guessed_answer < actual_answer:
            print('Your guess is too low.')
        else:
            print('That is correct. Congratulations!')
            break

        guesses_remaining -= 1
    else:
        print('You have run out of guesses.')
        print('My number was {}.'.format(actual_answer))

    print()
    print('That is all.')

