from __future__ import print_function

import random
import sys
import termios

from fibre import entry_point, read_character
from fibre.stdio import get_input_mode_manager

TUTOR_LINES = [
    'The cat sat on the mat.',
    'The quick brown fox jumped over the lazy dog.',
    'She had a nasty cough.',
]

def main():
    set_character_input_mode()

    lines = list(TUTOR_LINES)
    random.shuffle(lines)

    for line in lines:
        print(line)
        for expected in line:
            actual = yield read_character()
            if actual == expected:
                display_char(actual)
            else:
                display_char('X')

        actual = yield read_character()
        while actual != '\n':
            display_char('X')
            actual = yield read_character()
        print()

def set_character_input_mode():
    get_input_mode_manager().modify_input_lflags(
            clear=(termios.ECHO | termios.ICANON | termios.ECHONL))

def display_char(c):
    print(c, end='')
    sys.stdout.flush()

entry_point(main)
